/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.panels;

import dk.hkj.main.FontAdjust;
import dk.hkj.main.InterfaceThreads;
import dk.hkj.main.ValueFormat;
import dk.hkj.panels.BasicAnalogReadoutPanel;
import dk.hkj.panels.BasicPanel;
import dk.hkj.panels.PopupAskDualValue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenuItem;

public class AnalogReadoutPanel
extends BasicAnalogReadoutPanel
implements ActionListener {
    public static String panelName = "AnalogReadout";
    private String channel = null;

    public AnalogReadoutPanel() {
        this.nameLabel.setText("--empty--");
        this.displayLayout(this.includeName);
    }

    @Override
    public BasicPanel.ParamsSet getParamsSet() {
        BasicPanel.ParamsSet ps = super.getParamsSet();
        ps.nChannels = 1;
        return ps;
    }

    @Override
    public void setParams(BasicPanel.ParamsSet paramsSet) {
        super.setParams(paramsSet);
        this.channel = paramsSet.channels.get(0);
        this.setToolTipText(this.channel);
        this.nameLabel.setText(this.channel);
    }

    @Override
    public String getPanelName() {
        return panelName;
    }

    @Override
    public void update() {
        double v;
        if (!this.isVisible()) {
            return;
        }
        if (this.channel != null && !Double.isNaN(v = this.readValue(this.channel))) {
            this.adp.updateValue(v);
        }
        if (this.requestDisplayUpdate) {
            this.sizeAnalogPanel();
            this.requestDisplayUpdate = false;
            this.repaint();
        }
    }

    @Override
    protected void popupMenuAdjust() {
        FontAdjust.FontMenu menu = null;
        JMenuItem mi = null;
        this.selectMenu("Select channel", "C:", this.channel, InterfaceThreads.listChannels(true, "*"), '.', this);
        menu = new FontAdjust.FontMenu("Scale");
        this.popupMenu.add(menu);
        mi = new FontAdjust.FontRadioButtonMenuItem("Horizontal");
        if (this.adp.getScaleType() == BasicAnalogReadoutPanel.ScaleType.Horizontal) {
            mi.setSelected(true);
        }
        mi.setActionCommand("horizontal");
        mi.addActionListener(this);
        menu.add(mi);
        mi = new FontAdjust.FontRadioButtonMenuItem("Vertical");
        if (this.adp.getScaleType() == BasicAnalogReadoutPanel.ScaleType.Vertical) {
            mi.setSelected(true);
        }
        mi.setActionCommand("vertical");
        mi.addActionListener(this);
        menu.add(mi);
        mi = new FontAdjust.FontMenuItem("Limits");
        mi.setActionCommand("limits");
        mi.addActionListener(this);
        this.popupMenu.add(mi);
        mi = new FontAdjust.FontCheckBoxMenuItem("Alarm");
        mi.setSelected(this.adp.getAlarm());
        mi.setActionCommand("alarm");
        mi.addActionListener(this);
        this.popupMenu.add(mi);
        this.addBasicPopupMenu();
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        if (arg0.getActionCommand().startsWith("C:")) {
            this.channel = arg0.getActionCommand().substring(2);
            ValueFormat fmt = InterfaceThreads.findValueFormat(this.channel);
            this.adp.setUnit(fmt != null ? fmt.unit : "");
            this.setToolTipText(this.channel);
            this.nameLabel.setText(this.channel == null ? "--empty--" : this.channel);
            this.reset();
        } else if (arg0.getActionCommand().equals("limits")) {
            PopupAskDualValue pav = new PopupAskDualValue(this, "Limits", "Lower", "Upper", this.adp.getLower(), this.adp.getUpper(), true);
            if (!Double.isNaN(pav.getValue1()) && !Double.isNaN(pav.getValue2())) {
                this.adp.setLower(pav.getValue1());
                this.adp.setUpper(pav.getValue2());
                this.update();
            }
        } else if (arg0.getActionCommand().equals("alarm")) {
            this.adp.setAlarm(!this.adp.getAlarm());
            this.update();
        } else if (arg0.getActionCommand().equals("vertical")) {
            this.adp.setScaleType(BasicAnalogReadoutPanel.ScaleType.Vertical);
            this.update();
        } else if (arg0.getActionCommand().equals("horizontal")) {
            this.adp.setScaleType(BasicAnalogReadoutPanel.ScaleType.Horizontal);
            this.update();
        }
    }

    @Override
    public String generateScriptCmd() {
        StringBuilder sb = new StringBuilder();
        sb.append(panelName);
        sb.append(" ");
        sb.append(this.channel);
        sb.append(" ");
        sb.append(this.generateParams());
        sb.append(this.generateParamsColor());
        return sb.toString();
    }
}

