/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.panels;

import dk.hkj.main.DeviceInterface;
import dk.hkj.main.InterfaceThreads;
import dk.hkj.main.ValueFormat;
import dk.hkj.panels.BasicLargeNSmallPanel;
import dk.hkj.panels.BasicPanel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;

public class AdvancedDeviceReadoutPanel
extends BasicLargeNSmallPanel
implements ActionListener {
    public static String panelName = "AdvancedDeviceReadout";
    protected String device = null;
    protected DeviceInterface di = null;
    protected double min = Double.MAX_VALUE;
    protected double max = -1.7976931348623157E308;
    protected double stdm = 0.0;
    protected double stds = 0.0;
    protected double sum = 0.0;
    protected int cnt = 0;
    protected double currentValue = Double.NaN;
    protected String lastChannel = "";

    public AdvancedDeviceReadoutPanel() {
        super(3);
        this.small1LeftLabel.setToolTipText("Minimum");
        this.small1RightLabel.setToolTipText("Maximum");
        this.small2LeftLabel.setToolTipText("Average");
        this.small2RightLabel.setToolTipText("Standard deviation");
        this.small3LeftLabel.setToolTipText("Peak to Peak i.e. max-min");
        this.small3RightLabel.setToolTipText("Sample count");
        this.displayLayout(this.includeName);
    }

    @Override
    public String getPanelName() {
        return panelName;
    }

    @Override
    public BasicPanel.ParamsSet getParamsSet() {
        BasicPanel.ParamsSet ps = super.getParamsSet();
        ps.nChannels = 1;
        return ps;
    }

    @Override
    public void setParams(BasicPanel.ParamsSet paramsSet) {
        super.setParams(paramsSet);
        this.device = paramsSet.channels.get(0);
        this.di = InterfaceThreads.getLoadedDeviceInterfaceHandle(this.device);
        this.largeLabel.setToolTipText(this.device);
    }

    @Override
    public void update() {
        if (!this.isVisible()) {
            return;
        }
        if (this.di == null || this.device == null) {
            super.update();
            return;
        }
        String c1 = String.valueOf(this.device) + "." + this.di.getValueName(0);
        if (!c1.equals(this.lastChannel)) {
            this.lastChannel = c1;
            this.reset();
            return;
        }
        ValueFormat fmt = InterfaceThreads.findValueFormat(c1);
        this.largeLabel.setToolTipText(this.device);
        double v = this.readValue(c1);
        if (!Double.isNaN(v)) {
            this.currentValue = v;
            if (this.currentValue > this.max) {
                this.max = this.currentValue;
            }
            if (this.currentValue < this.min) {
                this.min = this.currentValue;
            }
            this.sum += this.currentValue;
            ++this.cnt;
            double nextm = this.stdm + (this.currentValue - this.stdm) / (double)this.cnt;
            this.stds += (this.currentValue - this.stdm) * (this.currentValue - nextm);
            this.stdm = nextm;
            this.update(c1, String.valueOf(fmt.format.formatDisplay(this.currentValue)) + fmt.unit, "Min:" + fmt.format.formatDisplay(this.min), "Max:" + fmt.format.formatDisplay(this.max), "Avg:" + fmt.format.formatDisplay(this.sum / (double)this.cnt), "SD:" + fmt.format.formatDisplay(this.stds / (double)this.cnt), "PP:" + fmt.format.formatDisplay(this.max - this.min), "Cnt:" + Integer.toString(this.cnt));
        } else {
            this.update(c1, "---", "---", "---", "---", "---");
        }
    }

    @Override
    public void reset() {
        this.min = Double.MAX_VALUE;
        this.max = -1.7976931348623157E308;
        this.sum = 0.0;
        this.cnt = 0;
        this.stdm = 0.0;
        this.stds = 0.0;
    }

    @Override
    protected boolean supportReset() {
        return true;
    }

    @Override
    protected void popupMenuAdjust() {
        List<String> list = InterfaceThreads.listDeviceHandles();
        this.selectMenu("Select device", "D:", this.device, list, '.', this);
        super.popupMenuAdjust();
        this.addBasicPopupMenu();
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        if (arg0.getActionCommand().startsWith("D:")) {
            this.device = arg0.getActionCommand().substring(2);
            this.di = InterfaceThreads.getLoadedDeviceInterfaceHandle(this.device);
            this.largeLabel.setToolTipText(this.device);
            this.reset();
        }
    }

    @Override
    public boolean needData() {
        return true;
    }

    @Override
    public String generateScriptCmd() {
        StringBuilder sb = new StringBuilder();
        sb.append(panelName);
        sb.append(" ");
        sb.append(this.device);
        sb.append(" ");
        sb.append(this.generateParams());
        sb.append(this.generateParamsColor());
        return sb.toString();
    }
}

