/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.net;

import dk.hkj.net.RPC;

public class LXI {
    static final int VXI_11_Core = 395183;
    static final int VXI_11_CreateLink = 10;
    static final int VXI_11_DeviceClear = 15;
    static final int VXI_11_DeviceWrite = 11;
    static final int VXI_11_DeviceRead = 12;
    static final int VXI_11_DestroyLink = 23;
    private String address = null;
    private RPC rpc = null;
    private RPC lxirpc = null;
    private int linkId = 0;

    public LXI(String address) {
        this.address = address;
        this.rpc = new RPC(address, "111");
    }

    public synchronized boolean connect() {
        int port = this.rpc.portmapGetport(395183, 1, 6, 0);
        this.lxirpc = new RPC(this.address, port);
        this.lxirpc.defineCall(395183, 1, 10);
        int clientId = 10;
        this.lxirpc.addParam(clientId);
        this.lxirpc.addParam(0);
        this.lxirpc.addParam(0);
        this.lxirpc.addParam("inst0");
        if (!this.lxirpc.doCall(1000)) {
            return false;
        }
        if (!this.lxirpc.decodeAnswer()) {
            return false;
        }
        this.linkId = this.lxirpc.getAnswer(1);
        this.lxirpc.getAnswer(2);
        this.lxirpc.getAnswer(3);
        return true;
    }

    public synchronized boolean deviceWrite(String cmd) {
        this.lxirpc.defineCall(395183, 1, 11);
        this.lxirpc.addParam(this.linkId);
        this.lxirpc.addParam(3000);
        this.lxirpc.addParam(0);
        this.lxirpc.addParam(8);
        this.lxirpc.addParam(String.valueOf(cmd) + "\r");
        return this.lxirpc.doCall(2000) && this.lxirpc.decodeAnswer();
    }

    public synchronized boolean deviceClear() {
        this.lxirpc.defineCall(395183, 1, 15);
        this.lxirpc.addParam(this.linkId);
        this.lxirpc.addParam(0);
        this.lxirpc.addParam(0);
        this.lxirpc.addParam(2000);
        return this.lxirpc.doCall(1000) && this.lxirpc.decodeAnswer();
    }

    public synchronized String deviceRead() {
        this.lxirpc.defineCall(395183, 1, 12);
        this.lxirpc.addParam(this.linkId);
        this.lxirpc.addParam(1000);
        this.lxirpc.addParam(3000);
        this.lxirpc.addParam(2000);
        this.lxirpc.addParam(128);
        this.lxirpc.addParam(10);
        if (!this.lxirpc.doCall(3000)) {
            return null;
        }
        if (!this.lxirpc.decodeAnswer()) {
            return null;
        }
        int size = this.lxirpc.getAnswer(2);
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < size) {
            int c = this.lxirpc.getAnswer(3 + i / 4);
            switch (i % 4) {
                case 0: {
                    sb.append((char)(c >> 24 & 0xFF));
                    break;
                }
                case 1: {
                    sb.append((char)(c >> 16 & 0xFF));
                    break;
                }
                case 2: {
                    sb.append((char)(c >> 8 & 0xFF));
                    break;
                }
                case 3: {
                    sb.append((char)(c & 0xFF));
                }
            }
            ++i;
        }
        return sb.toString();
    }

    public String deviceWriteRead(String cmd) {
        int a;
        if (!this.deviceWrite(cmd)) {
            System.out.println("Failed to write " + cmd + " to lxi");
        }
        if ((a = this.lxirpc.getAnswer(1)) == 6 || a == 7 || a == 11) {
            String answer = this.deviceRead();
            return answer;
        }
        return null;
    }

    public synchronized boolean destroyLink() {
        this.lxirpc.defineCall(395183, 1, 23);
        this.lxirpc.addParam(this.linkId);
        this.linkId = 0;
        return this.lxirpc.doCall(1000) && this.lxirpc.decodeAnswer();
    }

    public synchronized void close() {
        if (this.linkId != 0) {
            this.destroyLink();
        }
        if (this.lxirpc != null) {
            this.lxirpc.close();
            this.lxirpc = null;
        }
        if (this.rpc != null) {
            this.rpc.close();
            this.rpc = null;
        }
    }

    public static void main(String[] args) {
        LXI lxi = new LXI("10.0.0.62");
        lxi.connect();
        lxi.deviceClear();
        System.out.println("idn=" + lxi.deviceWriteRead("*cls;*idn?"));
        System.out.println("volt=" + lxi.deviceWriteRead(":volt 10;"));
        System.out.println("curr=" + lxi.deviceWriteRead(":curr 1.5;"));
        System.out.println("output=" + lxi.deviceWriteRead(":output:state 1;"));
        System.out.println("trig1=" + lxi.deviceWriteRead(":arm:sour imm;:arm:count 1;"));
        System.out.println("trig2=" + lxi.deviceWriteRead(":trig:sour imm;:trig:count 1;:trig:samp:count 1"));
        System.out.println("Read=" + lxi.deviceWriteRead(":read?"));
        lxi.close();
    }
}

