/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.main;

import dk.hkj.main.FontAdjust;
import dk.hkj.main.Support;
import dk.hkj.util.StringUtil;
import dk.hkj.vars.Var;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;

public class ValueFormat {
    public String name;
    public String unit;
    public ValueFormatter format;
    private static NumberFormat nff;
    private static DecimalFormat ndd;
    private static char localDecimalPoint;
    public static ValueFormatter formatTime;
    public static ValueFormatter formatInt;
    public static ValueFormatter formatSI;
    public static ValueFormatter formatSI3;
    public static ValueFormatter formatSI4;
    public static ValueFormatter formatSI5;
    public static ValueFormatter formatSI6;
    public static ValueFormatter formatSI7;
    public static ValueFormatter formatSI8;
    public static ValueFormatter formatSI9;
    public static ValueFormatter formatSI10;
    public static ValueFormatter formatSI11;
    public static ValueFormatter formatSI12;
    public static ValueFormatter formatSI13;
    public static ValueFormatter formatSI14;
    public static ValueFormatter formatSI15;
    public static ValueFormatter formatD0;
    public static ValueFormatter formatD1;
    public static ValueFormatter formatD2;
    public static ValueFormatter formatD3;
    public static ValueFormatter formatD4;
    public static ValueFormatter formatD5;
    public static ValueFormatter formatD6;
    public static ValueFormatter formatD7;
    public static ValueFormatter formatD8;
    public static ValueFormatter formatD9;
    public static ValueFormatter formatD10;
    public static ValueFormatter formatD11;
    public static ValueFormatter formatD12;
    public static ValueFormatter formatD13;
    public static ValueFormatter formatD14;
    public static ValueFormatter formatD15;
    public static ValueFormatter formatX1;
    public static ValueFormatter formatX2;
    public static ValueFormatter formatX3;
    public static ValueFormatter formatX4;
    public static ValueFormatter formatX5;
    public static ValueFormatter formatX6;
    public static ValueFormatter formatX7;
    public static ValueFormatter formatX8;
    public static ValueFormatter formatX9;
    public static ValueFormatter formatX10;
    public static ValueFormatter formatX11;
    public static ValueFormatter formatX12;
    public static ValueFormatter formatX13;
    public static ValueFormatter formatX14;
    public static ValueFormatter formatX15;
    public static ValueFormatter formatDateTime;

    static {
        localDecimalPoint = (char)46;
        formatTime = new ValueFormatterTime();
        formatInt = new ValueFormatterInt();
        formatSI = new ValueFormatterSI(-1);
        formatSI3 = new ValueFormatterSI(3);
        formatSI4 = new ValueFormatterSI(4);
        formatSI5 = new ValueFormatterSI(5);
        formatSI6 = new ValueFormatterSI(6);
        formatSI7 = new ValueFormatterSI(7);
        formatSI8 = new ValueFormatterSI(8);
        formatSI9 = new ValueFormatterSI(9);
        formatSI10 = new ValueFormatterSI(10);
        formatSI11 = new ValueFormatterSI(11);
        formatSI12 = new ValueFormatterSI(12);
        formatSI13 = new ValueFormatterSI(13);
        formatSI14 = new ValueFormatterSI(14);
        formatSI15 = new ValueFormatterSI(15);
        formatD0 = new ValueFormatterD(0);
        formatD1 = new ValueFormatterD(1);
        formatD2 = new ValueFormatterD(2);
        formatD3 = new ValueFormatterD(3);
        formatD4 = new ValueFormatterD(4);
        formatD5 = new ValueFormatterD(5);
        formatD6 = new ValueFormatterD(6);
        formatD7 = new ValueFormatterD(7);
        formatD8 = new ValueFormatterD(8);
        formatD9 = new ValueFormatterD(9);
        formatD10 = new ValueFormatterD(10);
        formatD11 = new ValueFormatterD(11);
        formatD12 = new ValueFormatterD(12);
        formatD13 = new ValueFormatterD(13);
        formatD14 = new ValueFormatterD(14);
        formatD15 = new ValueFormatterD(15);
        formatX1 = new ValueFormatterDX(1);
        formatX2 = new ValueFormatterDX(2);
        formatX3 = new ValueFormatterDX(3);
        formatX4 = new ValueFormatterDX(4);
        formatX5 = new ValueFormatterDX(5);
        formatX6 = new ValueFormatterDX(6);
        formatX7 = new ValueFormatterDX(7);
        formatX8 = new ValueFormatterDX(8);
        formatX9 = new ValueFormatterDX(9);
        formatX10 = new ValueFormatterDX(10);
        formatX11 = new ValueFormatterDX(11);
        formatX12 = new ValueFormatterDX(12);
        formatX13 = new ValueFormatterDX(13);
        formatX14 = new ValueFormatterDX(14);
        formatX15 = new ValueFormatterDX(15);
        formatDateTime = new ValueFormatterDateTime();
    }

    public static ValueFormatter getFormatter(FormatType t, int digits) {
        switch (t) {
            case D: {
                return new ValueFormatterD(digits);
            }
            case X: {
                return new ValueFormatterDX(digits);
            }
            case SI: {
                return new ValueFormatterSI(digits);
            }
        }
        return formatD2;
    }

    public ValueFormat(String name, String unit, ValueFormatter format) {
        if (format == null) {
            throw new RuntimeException("null format");
        }
        this.name = name;
        this.unit = unit;
        this.format = format;
        nff = NumberFormat.getNumberInstance(Locale.ENGLISH);
        nff.setGroupingUsed(false);
        nff.setMinimumFractionDigits(0);
        nff.setMaximumFractionDigits(10);
        nff.setMaximumIntegerDigits(10);
        ndd = new DecimalFormat("0.0#########E0;-0.0#########E0");
        DecimalFormatSymbols dfs = new DecimalFormatSymbols();
        dfs.setDecimalSeparator('.');
        ndd.setDecimalFormatSymbols(dfs);
        localDecimalPoint = NumberFormat.getInstance().format(1.1).charAt(1);
    }

    public String toString() {
        return String.valueOf(this.name) + " " + this.unit + " " + this.format;
    }

    public static ValueFormatter getFormatter(String name) {
        if (name.equalsIgnoreCase("SI")) {
            return formatSI;
        }
        if (name.equalsIgnoreCase("SI3")) {
            return formatSI3;
        }
        if (name.equalsIgnoreCase("SI4")) {
            return formatSI4;
        }
        if (name.equalsIgnoreCase("SI5")) {
            return formatSI5;
        }
        if (name.equalsIgnoreCase("SI6")) {
            return formatSI6;
        }
        if (name.equalsIgnoreCase("SI7")) {
            return formatSI7;
        }
        if (name.equalsIgnoreCase("SI8")) {
            return formatSI8;
        }
        if (name.equalsIgnoreCase("SI9")) {
            return formatSI9;
        }
        if (name.equalsIgnoreCase("SI10")) {
            return formatSI10;
        }
        if (name.equalsIgnoreCase("SI11")) {
            return formatSI11;
        }
        if (name.equalsIgnoreCase("SI12")) {
            return formatSI12;
        }
        if (name.equalsIgnoreCase("SI13")) {
            return formatSI13;
        }
        if (name.equalsIgnoreCase("SI14")) {
            return formatSI14;
        }
        if (name.equalsIgnoreCase("SI15")) {
            return formatSI15;
        }
        if (name.equalsIgnoreCase("INT")) {
            return formatInt;
        }
        if (name.equalsIgnoreCase("TIME")) {
            return formatTime;
        }
        if (name.equalsIgnoreCase("DATETIME")) {
            return formatDateTime;
        }
        if (name.equalsIgnoreCase("D0") || name.equalsIgnoreCase("X0")) {
            return formatD0;
        }
        if (name.equalsIgnoreCase("D1")) {
            return formatD1;
        }
        if (name.equalsIgnoreCase("D2")) {
            return formatD2;
        }
        if (name.equalsIgnoreCase("D3")) {
            return formatD3;
        }
        if (name.equalsIgnoreCase("D4")) {
            return formatD4;
        }
        if (name.equalsIgnoreCase("D5")) {
            return formatD5;
        }
        if (name.equalsIgnoreCase("D6")) {
            return formatD6;
        }
        if (name.equalsIgnoreCase("D7")) {
            return formatD7;
        }
        if (name.equalsIgnoreCase("D8")) {
            return formatD8;
        }
        if (name.equalsIgnoreCase("D9")) {
            return formatD9;
        }
        if (name.equalsIgnoreCase("D10")) {
            return formatD10;
        }
        if (name.equalsIgnoreCase("D11")) {
            return formatD11;
        }
        if (name.equalsIgnoreCase("D12")) {
            return formatD12;
        }
        if (name.equalsIgnoreCase("D13")) {
            return formatD13;
        }
        if (name.equalsIgnoreCase("D14")) {
            return formatD14;
        }
        if (name.equalsIgnoreCase("D15")) {
            return formatD15;
        }
        if (name.equalsIgnoreCase("X1")) {
            return formatX1;
        }
        if (name.equalsIgnoreCase("X2")) {
            return formatX2;
        }
        if (name.equalsIgnoreCase("X3")) {
            return formatX3;
        }
        if (name.equalsIgnoreCase("X4")) {
            return formatX4;
        }
        if (name.equalsIgnoreCase("X5")) {
            return formatX5;
        }
        if (name.equalsIgnoreCase("X6")) {
            return formatX6;
        }
        if (name.equalsIgnoreCase("X7")) {
            return formatX7;
        }
        if (name.equalsIgnoreCase("X8")) {
            return formatX8;
        }
        if (name.equalsIgnoreCase("X9")) {
            return formatX9;
        }
        if (name.equalsIgnoreCase("X10")) {
            return formatX10;
        }
        if (name.equalsIgnoreCase("X11")) {
            return formatX11;
        }
        if (name.equalsIgnoreCase("X12")) {
            return formatX12;
        }
        if (name.equalsIgnoreCase("X13")) {
            return formatX13;
        }
        if (name.equalsIgnoreCase("X14")) {
            return formatX14;
        }
        if (name.equalsIgnoreCase("X15")) {
            return formatX15;
        }
        if (name.equalsIgnoreCase("Text")) {
            return new ValueFormatterText();
        }
        if (name.matches("[Ss][iI][3-9][munpfazy_]")) {
            return new ValueFormatterSI(name.charAt(2) - 48, name.charAt(3));
        }
        if (name.matches("[Ss][iI]1[0-5][munpfazy_]")) {
            return new ValueFormatterSI(10 + (name.charAt(3) - 48), name.charAt(4));
        }
        if (name.toLowerCase().startsWith("digital(")) {
            int i = name.indexOf(41);
            if (i >= 0) {
                name = name.substring(8, i);
            }
            return new ValueFormatterDigital(name);
        }
        return formatD2;
    }

    public static void addMenuItem(JMenu menu, String menuText, String menuId, ValueFormatter ref, String tip, ActionListener listner) {
        FontAdjust.FontRadioButtonMenuItem mi = new FontAdjust.FontRadioButtonMenuItem(menuText);
        if (ref == null && menuText.equalsIgnoreCase("default")) {
            mi.setSelected(true);
        } else if (ref != null && ref.getName().equalsIgnoreCase(menuText)) {
            mi.setSelected(true);
        }
        mi.setActionCommand(String.valueOf(menuId) + menuText);
        mi.addActionListener(listner);
        mi.setToolTipText(tip);
        menu.add(mi);
    }

    public static void formatMenu(JPopupMenu popupMenu, String menuText, String menuId, ValueFormatter ref, boolean includeDefault, boolean includeText, ActionListener listner) {
        FontAdjust.FontMenu menu = new FontAdjust.FontMenu(menuText);
        menu.setToolTipText("Select readout format, this includes number of decimal places and SI format");
        popupMenu.add(menu);
        if (includeDefault) {
            ValueFormat.addMenuItem(menu, "default", menuId, ref, "Default", listner);
        }
        FontAdjust.FontMenu submenu = new FontAdjust.FontMenu("SI");
        menu.add(submenu);
        submenu.setToolTipText("SI based formats");
        ValueFormat.addMenuItem(submenu, "SI", menuId, ref, "SI format with as many digits as needed", listner);
        ValueFormat.addMenuItem(submenu, "SI3", menuId, ref, "SI format with up to 3 digits", listner);
        ValueFormat.addMenuItem(submenu, "SI4", menuId, ref, "SI format with up to 4 digits", listner);
        ValueFormat.addMenuItem(submenu, "SI5", menuId, ref, "SI format with up to 5 digits", listner);
        ValueFormat.addMenuItem(submenu, "SI6", menuId, ref, "SI format with up to 6 digits", listner);
        ValueFormat.addMenuItem(submenu, "SI7", menuId, ref, "SI format with up to 7 digits", listner);
        ValueFormat.addMenuItem(submenu, "SI8", menuId, ref, "SI format with up to 8 digits", listner);
        ValueFormat.addMenuItem(submenu, "SI9", menuId, ref, "SI format with up to 9 digits", listner);
        ValueFormat.addMenuItem(submenu, "SI10", menuId, ref, "SI format with up to 10 digits", listner);
        ValueFormat.addMenuItem(submenu, "SI11", menuId, ref, "SI format with up to 11 digits", listner);
        ValueFormat.addMenuItem(submenu, "SI12", menuId, ref, "SI format with up to 12 digits", listner);
        ValueFormat.addMenuItem(submenu, "SI13", menuId, ref, "SI format with up to 13 digits", listner);
        ValueFormat.addMenuItem(submenu, "SI14", menuId, ref, "SI format with up to 14 digits", listner);
        ValueFormat.addMenuItem(submenu, "SI15", menuId, ref, "SI format with up to 15 digits", listner);
        submenu = new FontAdjust.FontMenu("D");
        menu.add(submenu);
        submenu.setToolTipText("Formats with fixed number of decimals");
        ValueFormat.addMenuItem(submenu, "D0", menuId, ref, "No decimals", listner);
        ValueFormat.addMenuItem(submenu, "D1", menuId, ref, "1 decimal", listner);
        ValueFormat.addMenuItem(submenu, "D2", menuId, ref, "2 decimals", listner);
        ValueFormat.addMenuItem(submenu, "D3", menuId, ref, "3 decimals", listner);
        ValueFormat.addMenuItem(submenu, "D4", menuId, ref, "4 decimals", listner);
        ValueFormat.addMenuItem(submenu, "D5", menuId, ref, "5 decimals", listner);
        ValueFormat.addMenuItem(submenu, "D6", menuId, ref, "6 decimals", listner);
        ValueFormat.addMenuItem(submenu, "D7", menuId, ref, "7 decimals", listner);
        ValueFormat.addMenuItem(submenu, "D8", menuId, ref, "8 decimals", listner);
        ValueFormat.addMenuItem(submenu, "D9", menuId, ref, "9 decimals", listner);
        ValueFormat.addMenuItem(submenu, "D10", menuId, ref, "10 decimals", listner);
        ValueFormat.addMenuItem(submenu, "D11", menuId, ref, "11 decimals", listner);
        ValueFormat.addMenuItem(submenu, "D12", menuId, ref, "12 decimals", listner);
        ValueFormat.addMenuItem(submenu, "D13", menuId, ref, "13 decimals", listner);
        ValueFormat.addMenuItem(submenu, "D14", menuId, ref, "14 decimals", listner);
        ValueFormat.addMenuItem(submenu, "D15", menuId, ref, "15 decimals", listner);
        submenu = new FontAdjust.FontMenu("X");
        menu.add(submenu);
        submenu.setToolTipText("Formats with up to number of decimals");
        ValueFormat.addMenuItem(submenu, "X1", menuId, ref, "Up to 1 decimal digit", listner);
        ValueFormat.addMenuItem(submenu, "X2", menuId, ref, "Up to 2 decimal digit", listner);
        ValueFormat.addMenuItem(submenu, "X3", menuId, ref, "Up to 3 decimal digit", listner);
        ValueFormat.addMenuItem(submenu, "X4", menuId, ref, "Up to 4 decimal digit", listner);
        ValueFormat.addMenuItem(submenu, "X5", menuId, ref, "Up to 5 decimal digit", listner);
        ValueFormat.addMenuItem(submenu, "X6", menuId, ref, "Up to 6 decimal digit", listner);
        ValueFormat.addMenuItem(submenu, "X7", menuId, ref, "Up to 7 decimal digit", listner);
        ValueFormat.addMenuItem(submenu, "X8", menuId, ref, "Up to 8 decimal digit", listner);
        ValueFormat.addMenuItem(submenu, "X9", menuId, ref, "Up to 9 decimal digit", listner);
        ValueFormat.addMenuItem(submenu, "X10", menuId, ref, "Up to 10 decimal digit", listner);
        ValueFormat.addMenuItem(submenu, "X11", menuId, ref, "Up to 11 decimal digit", listner);
        ValueFormat.addMenuItem(submenu, "X12", menuId, ref, "Up to 12 decimal digit", listner);
        ValueFormat.addMenuItem(submenu, "X13", menuId, ref, "Up to 13 decimal digit", listner);
        ValueFormat.addMenuItem(submenu, "X14", menuId, ref, "Up to 14 decimal digit", listner);
        ValueFormat.addMenuItem(submenu, "X15", menuId, ref, "Up to 15 decimal digit", listner);
        ValueFormat.addMenuItem(menu, "Time", menuId, ref, "Time format, i.e. hh:mm:ss", listner);
        if (includeText) {
            ValueFormat.addMenuItem(menu, "Text", menuId, ref, "Text format, allows showing of text, use empty unit with this format", listner);
        }
    }

    public static enum FormatType {
        D,
        X,
        SI;

    }

    public static interface ValueFormatter {
        public String formatDisplay(Var var1);

        public String formatDisplay(double var1);

        public String formatDisplayLocal(double var1);

        public String formatFile(double var1);

        public String getName();

        public int justify();

        public int digitalValues();

        public String getValueName(int var1);

        public int getMask(String var1);

        public String toString();
    }

    static class ValueFormatterD
    implements ValueFormatter {
        private NumberFormat nf = NumberFormat.getInstance(Locale.ENGLISH);
        private DecimalFormat nd;

        ValueFormatterD(int decimals) {
            this.nf.setGroupingUsed(false);
            this.nf.setMaximumFractionDigits(decimals);
            this.nf.setMinimumFractionDigits(decimals);
            String s = "";
            int i = 0;
            while (i < decimals) {
                s = String.valueOf(s) + "0";
                ++i;
            }
            this.nd = new DecimalFormat("0." + s + "E0;-0." + s + "E0");
            DecimalFormatSymbols dfs = new DecimalFormatSymbols();
            dfs.setDecimalSeparator('.');
            this.nd.setDecimalFormatSymbols(dfs);
        }

        @Override
        public String formatDisplay(Var v) {
            if (v.canDouble()) {
                return this.formatDisplay(v.asDouble());
            }
            return this.formatDisplay(Double.NaN);
        }

        @Override
        public String getName() {
            return "D" + this.nf.getMaximumFractionDigits();
        }

        @Override
        public synchronized String formatDisplay(double v) {
            if (Double.isNaN(v)) {
                return "?";
            }
            if (Math.abs(v) < 1.0E7) {
                return this.nf.format(v);
            }
            return this.nd.format(v);
        }

        @Override
        public synchronized String formatDisplayLocal(double v) {
            if (Double.isNaN(v)) {
                return "?";
            }
            if (Math.abs(v) < 1.0E7) {
                return this.nf.format(v).replace('.', localDecimalPoint);
            }
            return this.nd.format(v).replace('.', localDecimalPoint);
        }

        @Override
        public String formatFile(double v) {
            if (Double.isNaN(v)) {
                return "?";
            }
            if (Math.abs(v) < 1.0E10) {
                return nff.format(v);
            }
            return ndd.format(v);
        }

        @Override
        public int justify() {
            return 1;
        }

        @Override
        public int digitalValues() {
            return 0;
        }

        @Override
        public String getValueName(int no) {
            return null;
        }

        @Override
        public int getMask(String bitName) {
            return 0;
        }

        @Override
        public String toString() {
            return "D" + this.nf.getMaximumFractionDigits();
        }
    }

    static class ValueFormatterDX
    implements ValueFormatter {
        private NumberFormat nf = NumberFormat.getNumberInstance(Locale.ENGLISH);
        private DecimalFormat nd;

        @Override
        public String formatDisplay(Var v) {
            if (v.canDouble()) {
                return this.formatDisplay(v.asDouble());
            }
            return this.formatDisplay(Double.NaN);
        }

        ValueFormatterDX(int decimals) {
            this.nf.setGroupingUsed(false);
            this.nf.setMaximumFractionDigits(decimals);
            this.nf.setMinimumFractionDigits(0);
            String s = "";
            int i = 0;
            while (i < decimals) {
                s = String.valueOf(s) + "#";
                ++i;
            }
            this.nd = new DecimalFormat("0." + s + "E0;-0." + s + "E0");
            DecimalFormatSymbols dfs = new DecimalFormatSymbols();
            dfs.setDecimalSeparator('.');
            this.nd.setDecimalFormatSymbols(dfs);
        }

        @Override
        public String getName() {
            return "X" + this.nf.getMaximumFractionDigits();
        }

        @Override
        public synchronized String formatDisplay(double v) {
            if (Double.isNaN(v)) {
                return "?";
            }
            if (Math.abs(v) < 1.0E7) {
                return this.nf.format(v);
            }
            return this.nd.format(v);
        }

        @Override
        public synchronized String formatDisplayLocal(double v) {
            if (Double.isNaN(v)) {
                return "?";
            }
            if (Math.abs(v) < 1.0E7) {
                return this.nf.format(v);
            }
            return this.nd.format(v).replace('.', localDecimalPoint);
        }

        @Override
        public String formatFile(double v) {
            if (Double.isNaN(v)) {
                return "?";
            }
            if (Math.abs(v) < 1.0E10) {
                return nff.format(v);
            }
            return ndd.format(v);
        }

        @Override
        public int justify() {
            return 1;
        }

        @Override
        public int digitalValues() {
            return 0;
        }

        @Override
        public String getValueName(int no) {
            return null;
        }

        @Override
        public int getMask(String bitName) {
            return 0;
        }

        @Override
        public String toString() {
            return "X" + this.nf.getMaximumFractionDigits();
        }
    }

    static class ValueFormatterDateTime
    implements ValueFormatter {
        private SimpleDateFormat dt = new SimpleDateFormat("dd/MM-yyyy HH:mm:ss");
        private NumberFormat nf = NumberFormat.getNumberInstance(Locale.ENGLISH);

        ValueFormatterDateTime() {
            this.nf.setGroupingUsed(false);
            this.nf.setMaximumFractionDigits(3);
            this.nf.setMinimumFractionDigits(0);
            this.nf.setMaximumIntegerDigits(12);
            this.nf.setMinimumIntegerDigits(1);
        }

        @Override
        public String formatDisplay(Var v) {
            if (v.canDouble()) {
                return this.formatDisplay(v.asDouble());
            }
            return this.formatDisplay(Double.NaN);
        }

        public SimpleDateFormat getFormatter() {
            return this.dt;
        }

        @Override
        public String getName() {
            return "dateTime";
        }

        @Override
        public String formatDisplay(double v) {
            if (Double.isNaN(v)) {
                return "?";
            }
            return this.dt.format(new Date((long)(v * 1000.0)));
        }

        @Override
        public String formatDisplayLocal(double v) {
            if (Double.isNaN(v)) {
                return "?";
            }
            return this.dt.format(new Date((long)(v * 1000.0)));
        }

        @Override
        public String formatFile(double v) {
            return this.nf.format(v);
        }

        @Override
        public int justify() {
            return 1;
        }

        @Override
        public int digitalValues() {
            return 0;
        }

        @Override
        public String getValueName(int no) {
            return null;
        }

        @Override
        public int getMask(String bitName) {
            return 0;
        }

        @Override
        public String toString() {
            return "DateTime";
        }
    }

    public static class ValueFormatterDigital
    implements ValueFormatter {
        private String[] format = null;

        @Override
        public String formatDisplay(Var v) {
            if (v.canDouble()) {
                return this.formatDisplay(v.asDouble());
            }
            return this.formatDisplay(Double.NaN);
        }

        public ValueFormatterDigital(String format) {
            this.format = format.split("[, ;-]+");
        }

        @Override
        public String getName() {
            return "Digital";
        }

        @Override
        public String formatDisplay(double v) {
            if (Double.isNaN(v)) {
                return "?";
            }
            long vv = (long)v;
            StringBuilder sb = new StringBuilder();
            long mask = 1L;
            String[] stringArray = this.format;
            int n = this.format.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                if (!s.equals("-") && (vv & mask) != 0L) {
                    sb.append(s);
                    sb.append(' ');
                }
                mask <<= 1;
                ++n2;
            }
            return sb.toString();
        }

        @Override
        public String formatDisplayLocal(double v) {
            if (Double.isNaN(v)) {
                return "?";
            }
            long vv = (long)v;
            StringBuilder sb = new StringBuilder();
            long mask = 1L;
            String[] stringArray = this.format;
            int n = this.format.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                if (!s.equals("-") && (vv & mask) != 0L) {
                    sb.append(s);
                    sb.append(' ');
                }
                mask <<= 1;
                ++n2;
            }
            return sb.toString();
        }

        @Override
        public String formatFile(double v) {
            return Long.toString((long)v);
        }

        @Override
        public int justify() {
            return 0;
        }

        @Override
        public int digitalValues() {
            return this.format.length;
        }

        @Override
        public String getValueName(int no) {
            String s = this.format[no];
            return s.equals(Character.valueOf('-')) ? null : s;
        }

        @Override
        public int getMask(String bitName) {
            int i = 0;
            while (i < this.format.length) {
                if (this.format[i].equals(bitName)) {
                    return 1 << i;
                }
                ++i;
            }
            return 0;
        }

        public String formatAsString() {
            return this.formatDisplay(-1.0);
        }

        @Override
        public String toString() {
            return "Bool(" + this.formatAsString() + ")";
        }
    }

    static class ValueFormatterInt
    implements ValueFormatter {
        ValueFormatterInt() {
        }

        @Override
        public String formatDisplay(Var v) {
            if (v.canDouble()) {
                return this.formatDisplay(v.asDouble());
            }
            return this.formatDisplay(Double.NaN);
        }

        @Override
        public String formatDisplay(double v) {
            if (Double.isNaN(v)) {
                return "?";
            }
            return Long.toString((long)v);
        }

        @Override
        public String formatDisplayLocal(double v) {
            if (Double.isNaN(v)) {
                return "?";
            }
            return Long.toString((long)v);
        }

        @Override
        public String getName() {
            return "Int";
        }

        @Override
        public String formatFile(double v) {
            return Long.toString((long)v);
        }

        @Override
        public int justify() {
            return 1;
        }

        @Override
        public int digitalValues() {
            return 0;
        }

        @Override
        public String getValueName(int no) {
            return null;
        }

        @Override
        public int getMask(String bitName) {
            return 0;
        }

        @Override
        public String toString() {
            return "Int";
        }
    }

    static class ValueFormatterSI
    implements ValueFormatter {
        private int digits = -1;
        private char minSI = (char)46;

        ValueFormatterSI(int digits) {
            this.digits = digits;
        }

        @Override
        public String formatDisplay(Var v) {
            if (v.canDouble()) {
                return this.formatDisplay(v.asDouble());
            }
            return this.formatDisplay(Double.NaN);
        }

        @Override
        public String getName() {
            return "SI" + (this.digits > 2 ? Integer.valueOf(this.digits) : "");
        }

        ValueFormatterSI(int digits, char minSI) {
            this.digits = digits;
            this.minSI = minSI;
        }

        @Override
        public String formatDisplay(double v) {
            if (Double.isNaN(v)) {
                return "?";
            }
            return StringUtil.formatDoubleEE(v, false, this.digits, this.minSI);
        }

        @Override
        public String formatDisplayLocal(double v) {
            if (Double.isNaN(v)) {
                return "?";
            }
            return StringUtil.formatDoubleEE(v, false, this.digits, this.minSI).replace('.', localDecimalPoint);
        }

        @Override
        public String formatFile(double v) {
            if (Double.isNaN(v)) {
                return "?";
            }
            if (Math.abs(v) < 1.0E10) {
                return nff.format(v);
            }
            return ndd.format(v);
        }

        @Override
        public int justify() {
            return 1;
        }

        @Override
        public int digitalValues() {
            return 0;
        }

        @Override
        public String getValueName(int no) {
            return null;
        }

        @Override
        public int getMask(String bitName) {
            return 0;
        }

        @Override
        public String toString() {
            String limit = "";
            if ("_munpfazy".indexOf(this.minSI) >= 0) {
                limit = String.valueOf(this.minSI);
            }
            return "SI" + (this.digits > 2 ? String.valueOf(this.digits) + limit : "");
        }
    }

    public static class ValueFormatterText
    implements ValueFormatter {
        @Override
        public String formatDisplay(Var v) {
            if (v.canDouble()) {
                return this.formatDisplay(v.asDouble());
            }
            return v.asString();
        }

        @Override
        public String formatDisplay(double v) {
            return Double.toString(v);
        }

        @Override
        public String formatDisplayLocal(double v) {
            return Double.toString(v).replace('.', localDecimalPoint);
        }

        @Override
        public String formatFile(double v) {
            return Double.toString(v);
        }

        @Override
        public String getName() {
            return "Text";
        }

        @Override
        public int justify() {
            return -1;
        }

        @Override
        public int digitalValues() {
            return 0;
        }

        @Override
        public String getValueName(int no) {
            return null;
        }

        @Override
        public int getMask(String bitName) {
            return 0;
        }
    }

    static class ValueFormatterTime
    implements ValueFormatter {
        private NumberFormat nf = NumberFormat.getNumberInstance(Locale.ENGLISH);

        ValueFormatterTime() {
            this.nf.setGroupingUsed(false);
            this.nf.setMinimumFractionDigits(0);
            this.nf.setMaximumFractionDigits(3);
        }

        @Override
        public String formatDisplay(Var v) {
            if (v.canDouble()) {
                return this.formatDisplay(v.asDouble());
            }
            return this.formatDisplay(Double.NaN);
        }

        @Override
        public String getName() {
            return "Time";
        }

        @Override
        public String formatDisplay(double v) {
            if (Double.isNaN(v)) {
                return "?";
            }
            return Support.toHMS1(v);
        }

        @Override
        public String formatDisplayLocal(double v) {
            if (Double.isNaN(v)) {
                return "?";
            }
            return Support.toHMS1(v);
        }

        @Override
        public String formatFile(double v) {
            return this.nf.format(v);
        }

        @Override
        public int justify() {
            return 1;
        }

        @Override
        public int digitalValues() {
            return 0;
        }

        @Override
        public String getValueName(int no) {
            return null;
        }

        @Override
        public int getMask(String bitName) {
            return 0;
        }

        @Override
        public String toString() {
            return "Time";
        }
    }
}

