/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.main;

import dk.hkj.color.ColorUtil;
import dk.hkj.database.DataBase;
import dk.hkj.database.Exporter;
import dk.hkj.devices.ManageDeviceDefinitions;
import dk.hkj.main.ChartScales;
import dk.hkj.main.CommandProcessor;
import dk.hkj.main.FontAdjust;
import dk.hkj.main.InterfaceThreads;
import dk.hkj.main.Main;
import dk.hkj.main.Mathematics;
import dk.hkj.main.PaneChart;
import dk.hkj.main.PaneCommand;
import dk.hkj.main.PaneConfig;
import dk.hkj.main.PaneCurrentValues;
import dk.hkj.main.PaneHistogram;
import dk.hkj.main.PaneLoadDevices;
import dk.hkj.main.PaneMath;
import dk.hkj.main.PaneRange;
import dk.hkj.main.PaneRemap;
import dk.hkj.main.PaneScales;
import dk.hkj.main.PaneTable;
import dk.hkj.main.PopupExport;
import dk.hkj.main.PopupImport;
import dk.hkj.script.Script;
import dk.hkj.util.FileUtil;
import dk.hkj.util.LogToWebserver;
import dk.hkj.util.StringUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.Paths;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.FieldPosition;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListSet;
import javax.swing.DefaultCellEditor;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileSystemView;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;

public class Support {
    public static final int MAX_IMAGE_WIDTH = 15000;
    public static final int MIN_IMAGE_WIDTH = 400;
    public static final int MAX_IMAGE_HEIGHT = 10000;
    public static final int MIN_IMAGE_HEIGHT = 250;
    public static List<String> systemCommands = null;
    public static CommandProcessor.CmdEnvironment cmdEnvironment = new CommandProcessor.CmdEnvironment();
    public static DataBase dataBase = new DataBase();
    public static ChartScales chartScales = null;
    public static Mathematics math = null;
    public static boolean listDevices = false;
    public static boolean devlop = false;
    public static int resetDelay = 0;
    public static Color chartColor = null;
    public static Color chartBorderColor = null;
    public static Color chartFontColor = null;
    public static Color chartHeaderColor = null;
    public static Color chartGridColor = null;
    public static final Color[] InitialChartLineColor = new Color[]{Color.red, Color.blue, new Color(100, 100, 60), Color.magenta, new Color(0, 156, 0), new Color(230, 230, 30), Color.cyan, new Color(0, 80, 156), Color.green, new Color(0, 0, 156)};
    public static Color[] chartLineColor = Arrays.copyOf(InitialChartLineColor, InitialChartLineColor.length);
    public static ManageDeviceDefinitions manageDeviceDefinitions = new ManageDeviceDefinitions();
    public static String startupScript = null;
    public static ColorScheme colorScheme = new ColorScheme();
    public static SystemSettings systemSettings = null;
    public static boolean useHid4Java = false;
    public static String chartTitle = null;
    public static PaneCommand paneCommand = null;
    public static PaneCurrentValues paneCurrentValues = null;
    public static PaneTable paneTable = null;
    public static PaneChart paneChart = null;
    public static PaneScales paneScales = null;
    public static PaneHistogram paneHistogram = null;
    public static PaneRange paneRange = null;
    public static PaneMath paneMath = null;
    public static PaneRemap paneRemap = null;
    public static PaneConfig paneConfig = null;
    public static PaneLoadDevices paneLoadDevices = null;
    private static String devicePath = null;
    private static String dataPath = null;
    private static String configPath = null;
    private static String scriptPath = null;
    public static PopupExport popupExporter = null;
    public static CommandList commandList = new CommandList();

    public static void addUsedFunction(String name) {
        if (Support.systemSettings.lastFunctions.length() < 10000) {
            if (Support.systemSettings.lastFunctions.length() > 0) {
                Support.systemSettings.lastFunctions.append(";");
            }
            Support.systemSettings.lastFunctions.append(name);
        }
    }

    public static String getUsedFunctions() {
        String s = Support.systemSettings.lastFunctions.toString();
        Support.systemSettings.lastFunctions.setLength(0);
        return s;
    }

    public static void updateExport() {
        if (popupExporter != null) {
            popupExporter.updateFields();
        }
    }

    public static void showExport() {
        if (popupExporter == null) {
            popupExporter = new PopupExport();
            popupExporter.setLocation(Main.main.frame.getLocationOnScreen());
        }
        popupExporter.setVisible(true);
    }

    public static void showImport() {
        PopupImport popupImport = new PopupImport();
        popupImport.setLocation(Main.main.frame.getLocationOnScreen());
        popupImport.setVisible(true);
    }

    public static void showExport(String first, String last) {
        if (popupExporter == null) {
            popupExporter = new PopupExport();
            popupExporter.setLocation(Main.main.frame.getLocationOnScreen());
        }
        popupExporter.setRange(first, last);
        popupExporter.setVisible(true);
    }

    public static void clearExporter() {
        if (popupExporter != null) {
            popupExporter.setVisible(false);
            popupExporter.dispose();
            popupExporter = null;
        }
        Exporter.resetExporter();
    }

    public static void initSupport() {
        chartScales = new ChartScales();
        systemSettings = new SystemSettings();
        math = new Mathematics();
    }

    public static String getDataPath() {
        if (dataPath != null) {
            return dataPath;
        }
        String s = FileSystemView.getFileSystemView().getDefaultDirectory().getPath();
        return Paths.get(s, "TestController").toString();
    }

    public static void setDataPath(String path) {
        dataPath = path;
    }

    public static void setConfigPath(String path) {
        configPath = path;
    }

    public static void setDevicePath(String path) {
        devicePath = path;
    }

    public static void setScriptPath(String path) {
        scriptPath = path;
    }

    public static String getDevicePath() {
        if (devicePath != null) {
            return devicePath;
        }
        String s = FileSystemView.getFileSystemView().getDefaultDirectory().getPath();
        return Paths.get(s, "TestController", "Devices").toString();
    }

    public static String getConfigPath() {
        if (configPath != null) {
            return configPath;
        }
        String s = FileSystemView.getFileSystemView().getDefaultDirectory().getPath();
        return Paths.get(s, "TestController", "Settings").toString();
    }

    public static String getScriptPath() {
        if (scriptPath != null) {
            return scriptPath;
        }
        String s = FileSystemView.getFileSystemView().getDefaultDirectory().getPath();
        return Paths.get(s, "TestController", "ScriptLibrary").toString();
    }

    public static String getProgramPath() {
        try {
            return new File(Support.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath()).getParent();
        }
        catch (URISyntaxException exception) {
            exception.printStackTrace(System.out);
            return null;
        }
    }

    public static void makeDirs() {
        new File(Support.getConfigPath()).mkdirs();
        new File(Support.getDevicePath()).mkdirs();
        new File(Support.getDataPath()).mkdirs();
    }

    public static double parseTextFieldDouble(JTextField tf, double def, boolean allowBlank) {
        return Support.parseTextFieldDouble(tf, def, allowBlank, -1.7976931348623157E308, Double.MAX_VALUE);
    }

    public static double parseTextFieldDouble(JTextField tf, double def, boolean allowBlank, double min, double max) {
        double v;
        block6: {
            String s = tf.getText().trim();
            if (allowBlank && s.length() == 0) {
                tf.setBackground(Support.colorScheme.textBackground);
                return Double.NaN;
            }
            v = def;
            if (tf.isEnabled()) {
                try {
                    double vv = StringUtil.parseDoubleEE(s);
                    if (vv >= min && vv <= max && !Double.isNaN(vv) && !Double.isInfinite(vv)) {
                        tf.setBackground(Support.colorScheme.textBackground);
                        v = vv;
                        break block6;
                    }
                    tf.setBackground(Support.colorScheme.errorBackground);
                    v = Double.NaN;
                }
                catch (Exception exception) {
                    tf.setBackground(Support.colorScheme.errorBackground);
                    v = Double.NaN;
                }
            } else {
                tf.setBackground(Support.colorScheme.textBackground);
            }
        }
        return v;
    }

    public static String toHMS(int time) {
        StringBuilder sb = new StringBuilder();
        int s = time % 60;
        int m = (time /= 60) % 60;
        int h = time /= 60;
        if (h > 0) {
            sb.append(h);
            sb.append(':');
        }
        if (h > 0 || m > 0) {
            sb.append(StringUtil.dec2(m));
            sb.append(':');
        }
        sb.append(StringUtil.dec2(s));
        return sb.toString();
    }

    public static String toHMS(double time) {
        StringBuilder sb = new StringBuilder();
        if (time < 0.0) {
            time = -time;
            sb.append('-');
        }
        int t = (int)(time += 5.0E-4);
        time -= (double)t;
        int s = t % 60;
        int m = (t /= 60) % 60;
        int h = t /= 60;
        if (h > 0) {
            sb.append(h);
            sb.append(':');
        }
        sb.append(StringUtil.dec2(m));
        sb.append(':');
        sb.append(StringUtil.dec2(s));
        t = (int)(time * 1000.0);
        if (t != 0) {
            if (t % 100 == 0) {
                sb.append(".");
                sb.append(StringUtil.dec1(t / 100));
            } else if (t % 10 == 0) {
                sb.append(".");
                sb.append(StringUtil.dec2(t / 10));
            } else {
                sb.append(".");
                sb.append(StringUtil.dec3(t));
            }
        }
        return sb.toString();
    }

    public static String toHMS1(double time) {
        StringBuilder sb = new StringBuilder();
        int t = (int)time;
        time -= (double)t;
        int s = t % 60;
        int m = (t /= 60) % 60;
        int h = t /= 60;
        if (h > 0) {
            sb.append(h);
            sb.append(':');
        }
        sb.append(h > 0 ? StringUtil.dec2(m) : Integer.valueOf(m));
        sb.append(':');
        sb.append(StringUtil.dec2(s));
        t = (int)(time * 10.0);
        if (t != 0) {
            sb.append(".");
            sb.append(StringUtil.dec1(t));
        }
        return sb.toString();
    }

    public static String filterToIdentifier(String name) {
        if (name == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        char[] cArray = name.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (sb.length() == 0) {
                if (Character.isJavaIdentifierStart(c)) {
                    sb.append(c);
                }
            } else if (Character.isJavaIdentifierPart(c)) {
                sb.append(c);
            }
            ++n2;
        }
        return sb.toString();
    }

    public static String filterToIdentifierWithPoint(String name) {
        if (name == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        char[] cArray = name.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (sb.length() == 0) {
                if (Character.isJavaIdentifierStart(c)) {
                    sb.append(c);
                }
            } else if (c == '.' || Character.isJavaIdentifierPart(c)) {
                sb.append(c);
            }
            ++n2;
        }
        return sb.toString();
    }

    public static String unQuote(String str) {
        if (str.length() > 0 && str.charAt(0) == '\"' && str.charAt(str.length() - 1) == '\"') {
            return str.substring(1, str.length() - 1);
        }
        return str;
    }

    public static String conditionalQuote(String str) {
        return str.indexOf(32) < 0 && str.length() > 0 ? str : "\"" + str + "\"";
    }

    public static String formatTime(double time) {
        long iTime = (long)time;
        int ms = (int)((time - (double)iTime) * 1000.0);
        StringBuilder sb = new StringBuilder();
        if (iTime < 300L) {
            sb.append(iTime);
        } else if (iTime < 3600L) {
            sb.append(iTime / 60L);
            sb.append(':');
            sb.append(iTime % 60L);
        } else {
            sb.append(iTime / 3600L);
            sb.append(':');
            sb.append(iTime / 60L % 60L);
            sb.append(':');
            sb.append(iTime % 60L);
        }
        if (ms >= 10) {
            sb.append('.');
            sb.append(ms / 100);
            sb.append(ms / 10 % 10);
        }
        return sb.toString();
    }

    public static String cleanString(String str) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < str.length()) {
            char c = str.charAt(i);
            if (i == 0 && Character.isJavaIdentifierStart(c)) {
                sb.append(c);
            }
            if (i > 0 && Character.isJavaIdentifierPart(c)) {
                sb.append(c);
            }
            ++i;
        }
        return sb.toString();
    }

    public static int scriptEndPosition(String source) {
        int brackets = 0;
        boolean quotes = false;
        boolean skip = false;
        int i = 0;
        while (i < source.length()) {
            char c = source.charAt(i);
            if (c == '\"') {
                boolean bl = quotes = !quotes;
                if (!quotes && brackets == 0) {
                    return i + 1;
                }
            }
            if (!quotes) {
                if (c == '(') {
                    skip = brackets == 0;
                    ++brackets;
                } else if (c == ')' && --brackets == 0) {
                    return i + 1;
                }
            }
            if (skip) {
                skip = false;
            }
            ++i;
        }
        return 0;
    }

    public static String processScriptInBrackets(Script script, String source) {
        StringBuilder sbFinal = new StringBuilder();
        StringBuilder sb = new StringBuilder();
        int brackets = 0;
        boolean quotes = false;
        boolean skip = false;
        int i = 0;
        while (i < source.length()) {
            char c = source.charAt(i);
            if (c == '\"') {
                boolean bl = quotes = !quotes;
            }
            if (!quotes) {
                if (c == '(') {
                    skip = brackets == 0;
                    ++brackets;
                } else if (c == ')' && --brackets == 0) {
                    sbFinal.append(script.expression(sb.toString()).asString());
                    sb.setLength(0);
                    skip = true;
                }
            }
            if (skip) {
                skip = false;
            } else if (brackets > 0) {
                sb.append(c);
            } else {
                sbFinal.append(c);
            }
            ++i;
        }
        return sbFinal.toString();
    }

    public static String uniqueFilename(String fname) {
        if (!new File(fname).exists()) {
            return fname;
        }
        int n = 0;
        String ext = "";
        int i = fname.lastIndexOf(46);
        if (i > 0) {
            ext = fname.substring(i);
            fname = fname.substring(0, i);
        }
        if (fname.substring((i = fname.lastIndexOf(32)) + 1).matches("[0-9]+")) {
            n = StringUtil.parseInt(fname.substring(i + 1));
            fname = fname.substring(0, i);
        }
        while (new File(String.valueOf(fname) + " " + ++n + ext).exists()) {
        }
        return String.valueOf(fname) + " " + n + ext;
    }

    public static String[] splitWithQuotes(String str) {
        ArrayList<String> list = new ArrayList<String>();
        int j = 0;
        boolean quote = false;
        boolean bracket = false;
        int i = 0;
        while (i < str.length()) {
            char c = str.charAt(i);
            if (!quote && !bracket && c == '(') {
                bracket = true;
            }
            if (!quote && bracket && c == ')') {
                bracket = false;
            }
            if (!(bracket || c != '\"' || i != 0 && str.charAt(i - 1) == '\\')) {
                boolean bl = quote = !quote;
            }
            if (!bracket && !quote && c == ' ') {
                String s = str.substring(j, i).trim();
                if (s.length() > 0) {
                    list.add(StringUtil.unQuote(s));
                }
                j = i + 1;
            }
            ++i;
        }
        String s = str.substring(j).trim();
        if (s.length() > 0) {
            list.add(StringUtil.unQuote(s));
        }
        return list.toArray(new String[0]);
    }

    public static String showPeriod(double time) {
        long t = (long)time;
        if (t <= 1L) {
            return "";
        }
        if (time < 60.0) {
            return String.valueOf(new DecimalFormat("#0.##").format(time).replace(",", ".")) + "s";
        }
        if (time < 600.0) {
            return String.valueOf(Long.toString(t)) + "s";
        }
        if (time < 7200.0) {
            return String.valueOf(Long.toString(t / 60L)) + "m";
        }
        if (time < 345600.0) {
            return String.valueOf(Long.toString(t / 3600L)) + "h";
        }
        return String.valueOf(Long.toString(t / 3600L / 24L)) + "days";
    }

    public static JPopupMenu getPopupMenu(boolean chart, ActionListener listner) {
        JPopupMenu pop = new JPopupMenu();
        if (chart && dataBase.rows() > 0) {
            for (String s : dataBase.header().getDataColumnsList()) {
                FontAdjust.FontMenuItem mi = new FontAdjust.FontMenuItem(s);
                mi.setActionCommand(s);
                mi.addActionListener(listner);
                pop.add(mi);
            }
        } else {
            for (String s : InterfaceThreads.listChannels(true)) {
                FontAdjust.FontMenuItem mi = new FontAdjust.FontMenuItem(s);
                mi.setActionCommand(s);
                mi.addActionListener(listner);
                pop.add(mi);
            }
        }
        return pop;
    }

    public static boolean isWindows() {
        String os = System.getProperty("os.name");
        return os.startsWith("Windows");
    }

    public static String formatVersion(String ver) {
        int i;
        if ((ver = ver.trim()).length() > 1 && Character.toLowerCase(ver.charAt(0)) == 'v') {
            ver = ver.substring(1);
        }
        if ((i = ver.indexOf(32)) > 0) {
            ver = ver.substring(0, i);
        }
        if (ver.length() == 0) {
            ver = "0.0";
        }
        if (ver.indexOf(46) < 0) {
            ver = String.valueOf(ver) + '.';
        }
        while (ver.indexOf(46) < 3) {
            ver = "0" + ver;
        }
        return ver;
    }

    public static File fileWithOptinalDefaults(String fname, String defaultPath, String defaultExtension) {
        File f;
        int i = fname.lastIndexOf(File.separatorChar);
        int j = fname.lastIndexOf(46);
        if (i < fname.length() - 2 && fname.charAt(i + 1) == '.') {
            i += 2;
        }
        if (j < 0 || j < i) {
            fname = String.valueOf(fname) + defaultExtension;
        }
        if ((f = new File(fname)).isAbsolute() || defaultPath == null) {
            return f;
        }
        return Paths.get(defaultPath, fname).toFile();
    }

    public static File fileWithExtension(String fname, String defaultPath, String extension) {
        File f;
        if (!fname.toLowerCase().endsWith(extension.toLowerCase())) {
            fname = String.valueOf(fname) + extension;
        }
        if ((f = new File(fname)).isAbsolute() || defaultPath == null) {
            return f;
        }
        return Paths.get(defaultPath, fname).toFile();
    }

    public static String escapeForCommandLine(String str) {
        StringBuilder result = new StringBuilder();
        StringCharacterIterator iterator = new StringCharacterIterator(str);
        char character = iterator.current();
        while (character != '\uffff') {
            if (character == '\\') {
                result.append("\\\\");
            } else if (character == '\n') {
                result.append("\\n");
            } else if (character == '\r') {
                result.append("\\r");
            } else if (character == '\t') {
                result.append("\\t");
            } else if (character == '\"') {
                result.append("\\\"");
            } else {
                result.append(character);
            }
            character = iterator.next();
        }
        return result.toString();
    }

    public static String unescapeFromCommandLine(String str) {
        StringBuilder result = new StringBuilder();
        StringCharacterIterator iterator = new StringCharacterIterator(str);
        boolean escape = false;
        char character = iterator.current();
        while (character != '\uffff') {
            if (character == '\\') {
                if (escape) {
                    result.append("\\");
                    escape = false;
                } else {
                    escape = true;
                }
            } else if (escape && character == 'n') {
                result.append("\n");
                escape = false;
            } else if (escape && character == 'r') {
                result.append("\r");
                escape = false;
            } else if (escape && character == 't') {
                result.append("\t");
                escape = false;
            } else if (escape && character == '\"') {
                result.append("\"");
                escape = false;
            } else if (escape && character == '\\') {
                result.append("\\");
                escape = false;
            } else {
                result.append(character);
            }
            character = iterator.next();
        }
        return result.toString();
    }

    public static String toUnit(String txt) {
        String s = txt;
        if (s == null) {
            return "";
        }
        if (s.startsWith("+/-")) {
            s = s.substring(3);
        }
        if (s.endsWith(".")) {
            s = s.substring(0, s.length() - 1);
        }
        if (s.equalsIgnoreCase("Volt")) {
            return "V";
        }
        if (s.equalsIgnoreCase("Volts")) {
            return "V";
        }
        if (s.equalsIgnoreCase("Watt")) {
            return "W";
        }
        if (s.equalsIgnoreCase("Amp")) {
            return "A";
        }
        if (s.equalsIgnoreCase("Amps")) {
            return "A";
        }
        if (s.equalsIgnoreCase("Ohms")) {
            return "ohm";
        }
        if (s.equalsIgnoreCase("Sec")) {
            return "s";
        }
        if (s.equalsIgnoreCase("Secs")) {
            return "s";
        }
        if (s.equalsIgnoreCase("Seconds")) {
            return "s";
        }
        if (s.equalsIgnoreCase("-")) {
            return "";
        }
        if (s.equalsIgnoreCase("_")) {
            return " ";
        }
        if (s.equalsIgnoreCase("Arms")) {
            return "A";
        }
        if (s.equalsIgnoreCase("Apeak")) {
            return "A";
        }
        if (s.equalsIgnoreCase("ADC")) {
            return "A";
        }
        if (s.equalsIgnoreCase("AAC")) {
            return "A";
        }
        if (s.equalsIgnoreCase("Vrms")) {
            return "V";
        }
        if (s.equalsIgnoreCase("Vpeak")) {
            return "V";
        }
        if (s.equalsIgnoreCase("VDC")) {
            return "V";
        }
        if (s.equalsIgnoreCase("VAC")) {
            return "V";
        }
        return txt;
    }

    public static class AutoSelectCellEditor
    extends DefaultCellEditor {
        public AutoSelectCellEditor() {
            super(new FontAdjust.FontTextField());
        }

        public JTextField getEditorComponent() {
            return (JTextField)super.getComponent();
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            Component editor = super.getTableCellEditorComponent(table, value, isSelected, row, column);
            if (editor instanceof JTextField) {
                ((JTextField)editor).selectAll();
            }
            return editor;
        }
    }

    public static class ClosedFocusTraversalPolicy
    extends FocusTraversalPolicy {
        private List<Component> list = new ArrayList<Component>();
        private Container container;

        public ClosedFocusTraversalPolicy(Container container) {
            this.container = container;
        }

        public void add(Component c) {
            this.list.add(c);
        }

        @Override
        public Component getComponentAfter(Container arg0, Component arg1) {
            if (arg0 != this.container) {
                return null;
            }
            int idx = (this.list.indexOf(arg1) + 1) % this.list.size();
            return this.list.get(idx);
        }

        @Override
        public Component getComponentBefore(Container arg0, Component arg1) {
            if (arg0 != this.container) {
                return null;
            }
            int idx = this.list.indexOf(arg1) - 1;
            if (idx < 0) {
                idx = this.list.size() - 1;
            }
            return this.list.get(idx);
        }

        @Override
        public Component getDefaultComponent(Container arg0) {
            if (arg0 != this.container) {
                return null;
            }
            return this.list.get(0);
        }

        @Override
        public Component getFirstComponent(Container arg0) {
            if (arg0 != this.container) {
                return null;
            }
            return this.list.get(0);
        }

        @Override
        public Component getLastComponent(Container arg0) {
            if (arg0 != this.container) {
                return null;
            }
            return this.list.get(this.list.size() - 1);
        }
    }

    public static class ColorScheme {
        public Color tableGridAlternateBackground = null;
        public Color errorBackground = null;
        public Color textBackground = null;
        public Color changedBackground = null;
        public Color selectedCellbackground = null;
        public Color selectedCellForeground = null;
        public Color okBackground = null;
        public Color okAltBackground = null;

        public ColorScheme() {
            this.setTextBackground(Color.white);
        }

        public void setTextBackground(Color color) {
            this.textBackground = color;
            this.tableGridAlternateBackground = ColorUtil.blend(this.textBackground, Color.yellow, 0.15);
            this.errorBackground = ColorUtil.blend(this.textBackground, Color.red, 0.5);
            this.changedBackground = ColorUtil.blend(this.textBackground, Color.blue, 0.1);
            this.okBackground = ColorUtil.blend(this.textBackground, Color.green, 0.08);
            this.okAltBackground = ColorUtil.blend(this.tableGridAlternateBackground, Color.green, 0.15);
        }
    }

    public static class CommandList {
        private List<String> setupCommands = new ArrayList<String>();
        private int maxDelay = 0;

        CommandList() {
        }

        public synchronized void add(String cmd) {
            this.setupCommands.add(cmd);
        }

        public synchronized void delayTime(int delay) {
            this.maxDelay = Math.max(this.maxDelay, delay);
        }

        public synchronized List<String> generateScript(boolean forMenu, boolean optimize) {
            StringBuilder sb;
            int i;
            ArrayList<String> list = new ArrayList<String>();
            ConcurrentSkipListSet<String> devices = new ConcurrentSkipListSet<String>();
            boolean initFound = false;
            for (String line : this.setupCommands) {
                if (line.toLowerCase().startsWith("#initcolumns")) {
                    initFound = true;
                    continue;
                }
                i = line.indexOf(58);
                if (i <= 0) continue;
                devices.add(line.substring(0, i));
            }
            if (optimize && devices.size() > 1) {
                sb = new StringBuilder();
                for (String string : devices) {
                    sb.setLength(0);
                    for (String line : this.setupCommands) {
                        if (!line.startsWith(String.valueOf(string) + ":")) continue;
                        if (sb.length() > 0) {
                            sb.append(";");
                        }
                        sb.append(line.substring(string.length() + 1));
                    }
                    sb.insert(0, "#async " + string + " ");
                    list.add(sb.toString());
                }
                list.add("#async");
            } else {
                for (String line : this.setupCommands) {
                    if (line.toLowerCase().startsWith("#initcolumns")) continue;
                    i = line.indexOf(58);
                    if (i > 0) {
                        devices.add(line.substring(0, i));
                    }
                    list.add(line);
                }
            }
            if (initFound) {
                list.add("#InitColumns");
            }
            if (forMenu) {
                sb = new StringBuilder();
                for (String string : devices) {
                    if (sb.length() > 0) {
                        sb.append(" ");
                    }
                    sb.append(string);
                }
                sb.insert(0, "#scriptHandles ");
                list.add(0, sb.toString());
                if (this.maxDelay > 0) {
                    list.add("#Delay " + (double)this.maxDelay / 1000.0);
                }
            }
            if (list.size() > 0) {
                list.add("#SyncPopups");
            }
            return list;
        }

        public synchronized void clearList() {
            this.setupCommands.clear();
            this.maxDelay = 0;
        }

        public synchronized List<String> getList() {
            return this.setupCommands;
        }
    }

    public static class ConfigLineElement {
        public String name = "";
        public String value = "";

        public String toString() {
            return String.valueOf(this.name) + ":" + this.value;
        }
    }

    public static class ConfigLineSplitter
    implements Iterable<ConfigLineElement> {
        private List<ConfigLineElement> elements = new ArrayList<ConfigLineElement>();

        public ConfigLineSplitter(String line) {
            String[] stringArray = line.replace("|", " | ").split("[|]");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String entry = stringArray[n2];
                ConfigLineElement element = new ConfigLineElement();
                if (entry != null) {
                    int i = entry.indexOf(58);
                    if (i < 0) {
                        element.name = entry.trim();
                    } else {
                        element.name = entry.substring(0, i).trim();
                        element.value = entry.substring(i + 1).trim();
                    }
                }
                this.elements.add(element);
                ++n2;
            }
        }

        @Override
        public Iterator<ConfigLineElement> iterator() {
            return this.elements.iterator();
        }
    }

    public static enum DeviceTableBackground {
        OneInFour,
        Alternate,
        First;

    }

    public static class LongList
    extends ArrayList<Long> {
        public boolean contains(int value) {
            return this.contains((long)value);
        }

        public boolean contains(long value) {
            return this.indexOf(value) >= 0;
        }

        public int indexOf(long value) {
            int i = 0;
            while (i < this.size()) {
                if (value == (Long)this.get(i)) {
                    return i;
                }
                ++i;
            }
            return -1;
        }

        public void flip(long value) {
            int i = this.indexOf(value);
            if (i >= 0) {
                this.remove(i);
            } else {
                this.add(value);
            }
        }
    }

    public static class MyDecimalFormat
    extends DecimalFormat {
        DecimalFormat df = new DecimalFormat("0.###E0;-0.###E0");
        boolean siFormat = false;
        boolean eFormat = false;

        public MyDecimalFormat() {
            this.df.setGroupingUsed(false);
            super.setGroupingUsed(false);
            DecimalFormatSymbols dfs = new DecimalFormatSymbols();
            dfs.setDecimalSeparator('.');
            this.df.setDecimalFormatSymbols(dfs);
            super.setDecimalFormatSymbols(dfs);
        }

        @Override
        public void setMaximumFractionDigits(int digits) {
            super.setMaximumFractionDigits(digits);
            if (this.df != null) {
                String s = "0.";
                int i = 0;
                while (i < digits) {
                    s = String.valueOf(s) + "#";
                    ++i;
                }
                s = String.valueOf(s) + "E0";
                this.df.applyPattern(String.valueOf(s) + ";-" + s);
            }
        }

        public void seteFormat(boolean eFormat) {
            this.eFormat = eFormat;
        }

        public void setSIFormat(boolean siFormat) {
            this.siFormat = siFormat;
        }

        @Override
        public StringBuffer format(double number, StringBuffer sbuf, FieldPosition pos) {
            if (this.siFormat) {
                sbuf.append(StringUtil.formatDoubleEE(number, false));
            } else if (Math.abs(number) < 1.0E7 && !this.eFormat) {
                super.format(number, sbuf, pos);
            } else {
                this.df.format(number, sbuf, pos);
            }
            return sbuf;
        }
    }

    public static class MyTextField
    extends FontAdjust.FontTextField {
        private Color bgColor = null;

        public MyTextField(int columns) {
            super(columns);
        }

        @Override
        public void setEnabled(boolean enable) {
            super.setEnabled(enable);
            super.setBackground(enable ? this.bgColor : Support.colorScheme.textBackground);
        }

        @Override
        public void setBackground(Color color) {
            if (this.isEnabled()) {
                super.setBackground(color);
            }
            this.bgColor = color;
        }
    }

    public static class OpenFocusTraversalPolicy
    extends FocusTraversalPolicy {
        private List<Component> list = new ArrayList<Component>();
        private Container container;

        public OpenFocusTraversalPolicy(Container container) {
            this.container = container;
        }

        public void add(Component c) {
            this.list.add(c);
        }

        @Override
        public Component getComponentAfter(Container arg0, Component arg1) {
            if (arg0 != this.container) {
                return null;
            }
            int idx = this.list.indexOf(arg1) + 1;
            return idx < this.list.size() ? this.list.get(idx) : null;
        }

        @Override
        public Component getComponentBefore(Container arg0, Component arg1) {
            if (arg0 != this.container) {
                return null;
            }
            int idx = this.list.indexOf(arg1) - 1;
            return idx >= 0 ? this.list.get(idx) : null;
        }

        @Override
        public Component getDefaultComponent(Container arg0) {
            if (arg0 != this.container) {
                return null;
            }
            return this.list.get(0);
        }

        @Override
        public Component getFirstComponent(Container arg0) {
            if (arg0 != this.container) {
                return null;
            }
            return this.list.get(0);
        }

        @Override
        public Component getLastComponent(Container arg0) {
            if (arg0 != this.container) {
                return null;
            }
            return this.list.get(this.list.size() - 1);
        }
    }

    public static enum OverflowChartHandling {
        fixedValue,
        filter;

    }

    public static enum OverflowHandling {
        zero,
        infinite,
        highValue;

    }

    public static class PopupTextArea
    extends FontAdjust.FontTextArea
    implements ActionListener {
        private int n = 0;

        public PopupTextArea(int rows, int columns) {
            super(rows, columns);
            this.setComponentPopupMenu(Support.getPopupMenu(false, this));
            this.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent arg0) {
                    if (!(arg0.getKeyCode() != 155 || arg0.isAltDown() || arg0.isShiftDown() || arg0.isControlDown())) {
                        this.popupMenu();
                    }
                }
            });
        }

        private void popupMenu() {
            this.getComponentPopupMenu().show(this, 0, 0);
            this.getComponentPopupMenu();
        }

        private void insert(String value) {
            this.n = this.getCaretPosition();
            String s = this.getText();
            this.setText(String.valueOf(s.substring(0, this.n)) + value + s.substring(this.n));
            this.n += value.length();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    this.setCaretPosition(n);
                }
            });
        }

        @Override
        public void actionPerformed(ActionEvent value) {
            this.insert(value.getActionCommand());
        }
    }

    public static class PopupTextField
    extends FontAdjust.FontTextField
    implements ActionListener {
        private int n = 0;

        public PopupTextField(int w) {
            super(w);
            this.setComponentPopupMenu(Support.getPopupMenu(false, this));
            this.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent arg0) {
                    if (!(arg0.getKeyCode() != 155 && arg0.getKeyCode() != 525 || arg0.isAltDown() || arg0.isShiftDown() || arg0.isControlDown())) {
                        this.popupMenu();
                    }
                }
            });
        }

        private void popupMenu() {
            this.getComponentPopupMenu().show(this, 0, 0);
        }

        private void insert(String value) {
            this.n = this.getCaretPosition();
            String s = this.getText();
            if (this.getSelectionStart() < this.getSelectionEnd()) {
                s = String.valueOf(s.substring(0, this.getSelectionStart())) + value + s.substring(this.getSelectionEnd());
                this.n = this.getSelectionStart() + value.length();
                this.setText(s);
            } else {
                this.setText(String.valueOf(s.substring(0, this.n)) + value + s.substring(this.n));
                this.n += value.length();
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    this.setCaretPosition(n);
                }
            });
        }

        @Override
        public void actionPerformed(ActionEvent value) {
            this.insert(value.getActionCommand());
        }
    }

    public static class PosCtlGridBagLayout
    extends GridBagLayout {
        private Map<Integer, Component> position = new HashMap<Integer, Component>();

        @Override
        public void addLayoutComponent(Component comp, Object constraints) {
            this.position.put(((GridBagConstraints)constraints).gridy + ((GridBagConstraints)constraints).gridx * 1000, comp);
            super.addLayoutComponent(comp, constraints);
        }

        public Component getComponent(int x, int y) {
            return this.position.get(y + x * 1000);
        }

        @Override
        public void removeLayoutComponent(Component comp) {
            super.removeLayoutComponent(comp);
            for (Integer i : this.position.keySet()) {
                if (!this.position.get(i).equals(comp)) continue;
                this.position.remove(i);
                return;
            }
        }

        public void recreate() {
        }
    }

    public static class StringList
    extends ArrayList<String> {
        @Override
        public boolean add(String name) {
            if (name == null) {
                System.out.println("Trying to add a null");
                return false;
            }
            if (this.contains(name)) {
                return false;
            }
            super.add(name);
            return true;
        }

        public boolean remove(String name) {
            if (name == null) {
                System.out.println("Trying to remove a null");
                return false;
            }
            return super.remove(name);
        }

        public boolean contains(String name) {
            for (String s : this) {
                if (!s.equals(name)) continue;
                return true;
            }
            return false;
        }
    }

    public static class StringListIC
    extends StringList {
        @Override
        public boolean contains(String value) {
            return this.indexOf(value) >= 0;
        }

        public int indexOf(String str) {
            int i = 0;
            while (i < this.size()) {
                if (((String)this.get(i)).equalsIgnoreCase(str)) {
                    return i;
                }
                ++i;
            }
            return -1;
        }

        public void flip(String value) {
            int i = this.indexOf(value);
            if (i >= 0) {
                this.remove(i);
            } else {
                this.add(value);
            }
        }
    }

    public static class SystemSettings {
        protected StringBuilder lastFunctions = new StringBuilder();
        public int delayOverflow = 3;
        public OverflowHandling overflowHandling = OverflowHandling.infinite;
        public OverflowChartHandling overflowChartHandling = OverflowChartHandling.fixedValue;
        public double overflowLimit = 1.0E35;
        public double overFlowValue = 1.0E99;
        public double chartLowLog = 1.0E-6;
        public long uid = 0L;
        public int fontSize = 100;
        public double timeoutValue = 0.0;
        public int delayTimeout = 1;
        public Point screenUpperLeft = new Point(0, 0);
        public Dimension screenSize = new Dimension(0, 0);
        public boolean restorePopupLocations = false;
        public Dimension[] imageResolution = new Dimension[]{new Dimension(500, 250), new Dimension(800, 400), new Dimension(1200, 700), new Dimension(2000, 1000), new Dimension(1000, 500)};
        public DeviceTableBackground deviceTableBackground = DeviceTableBackground.OneInFour;

        SystemSettings() {
            this.loadDefault();
            if (this.uid == 0L) {
                this.uid = LogToWebserver.makeUid();
            }
        }

        public String getImageRes(int i) {
            return String.valueOf(Integer.toString(this.imageResolution[i].width)) + " x " + Integer.toString(this.imageResolution[i].height);
        }

        public DeviceTableBackground getDeviceTableBackground(String name) {
            DeviceTableBackground[] deviceTableBackgroundArray = DeviceTableBackground.values();
            int n = deviceTableBackgroundArray.length;
            int n2 = 0;
            while (n2 < n) {
                DeviceTableBackground dtb = deviceTableBackgroundArray[n2];
                if (dtb.name().equalsIgnoreCase(name)) {
                    return dtb;
                }
                ++n2;
            }
            return DeviceTableBackground.OneInFour;
        }

        public void loadFromFile(File file) {
            try {
                List<String> list = FileUtil.readFileAsList(file);
                for (String line : list) {
                    block3: for (ConfigLineElement element : new ConfigLineSplitter(line)) {
                        Enum oh;
                        int n;
                        int n2;
                        Enum[] enumArray;
                        String[] ss;
                        if (element.name.equalsIgnoreCase("uid")) {
                            this.uid = Long.parseLong(element.value);
                            if (LogToWebserver.uidValid(this.uid)) continue;
                            this.uid = LogToWebserver.makeUid();
                            this.saveToFile(file);
                            continue;
                        }
                        if (element.name.equalsIgnoreCase("delayOverflow")) {
                            this.delayOverflow = Integer.parseInt(element.value);
                            continue;
                        }
                        if (element.name.equalsIgnoreCase("chartLowLog")) {
                            this.chartLowLog = Double.parseDouble(element.value);
                            continue;
                        }
                        if (element.name.equalsIgnoreCase("delayTimeout")) {
                            this.delayTimeout = Integer.parseInt(element.value);
                            continue;
                        }
                        if (element.name.equalsIgnoreCase("timeoutValue")) {
                            this.timeoutValue = Double.parseDouble(element.value);
                            continue;
                        }
                        if (element.name.equalsIgnoreCase("fontSize")) {
                            this.fontSize = Integer.parseInt(element.value);
                            continue;
                        }
                        if (element.name.equalsIgnoreCase("DeviceTableBackground")) {
                            this.deviceTableBackground = this.getDeviceTableBackground(element.value);
                            continue;
                        }
                        if (element.name.equalsIgnoreCase("screen")) {
                            ss = element.value.split("[,]");
                            if (ss.length != 4) continue;
                            this.screenUpperLeft = new Point(Integer.parseInt(ss[0].trim()), Integer.parseInt(ss[1].trim()));
                            this.screenSize = new Dimension(Integer.parseInt(ss[2].trim()), Integer.parseInt(ss[3].trim()));
                            continue;
                        }
                        if (element.name.equalsIgnoreCase("imageResolution0")) {
                            ss = element.value.split("[,]");
                            if (ss.length != 2) continue;
                            this.imageResolution[0] = new Dimension(Integer.parseInt(ss[0].trim()), Integer.parseInt(ss[1].trim()));
                            continue;
                        }
                        if (element.name.equalsIgnoreCase("imageResolution1")) {
                            ss = element.value.split("[,]");
                            if (ss.length != 2) continue;
                            this.imageResolution[1] = new Dimension(Integer.parseInt(ss[0].trim()), Integer.parseInt(ss[1].trim()));
                            continue;
                        }
                        if (element.name.equalsIgnoreCase("imageResolution2")) {
                            ss = element.value.split("[,]");
                            if (ss.length != 2) continue;
                            this.imageResolution[2] = new Dimension(Integer.parseInt(ss[0].trim()), Integer.parseInt(ss[1].trim()));
                            continue;
                        }
                        if (element.name.equalsIgnoreCase("imageResolution3")) {
                            ss = element.value.split("[,]");
                            if (ss.length != 2) continue;
                            this.imageResolution[3] = new Dimension(Integer.parseInt(ss[0].trim()), Integer.parseInt(ss[1].trim()));
                            continue;
                        }
                        if (element.name.equalsIgnoreCase("imageResolution4")) {
                            ss = element.value.split("[,]");
                            if (ss.length != 2) continue;
                            this.imageResolution[4] = new Dimension(Integer.parseInt(ss[0].trim()), Integer.parseInt(ss[1].trim()));
                            continue;
                        }
                        if (element.name.equalsIgnoreCase("overflowHandling")) {
                            enumArray = OverflowHandling.values();
                            n2 = enumArray.length;
                            n = 0;
                            while (n < n2) {
                                oh = enumArray[n];
                                if (element.value.equalsIgnoreCase(oh.name())) {
                                    this.overflowHandling = oh;
                                    continue block3;
                                }
                                ++n;
                            }
                            continue;
                        }
                        if (element.name.equalsIgnoreCase("overflowChartHandling")) {
                            enumArray = OverflowChartHandling.values();
                            n2 = enumArray.length;
                            n = 0;
                            while (n < n2) {
                                oh = enumArray[n];
                                if (element.value.equalsIgnoreCase(oh.name())) {
                                    this.overflowChartHandling = oh;
                                    continue block3;
                                }
                                ++n;
                            }
                            continue;
                        }
                        if (element.name.equalsIgnoreCase("restorePopupLocations")) {
                            this.restorePopupLocations = Integer.parseInt(element.value) != 0;
                            continue;
                        }
                        if (!element.name.equalsIgnoreCase("lastFunctions") || this.lastFunctions.length() != 0) continue;
                        this.lastFunctions.append(element.value);
                    }
                }
            }
            catch (IOException iOException) {}
        }

        public void saveToFile(File file) {
            ArrayList<String> list = new ArrayList<String>();
            try {
                list.add("delayOverflow:" + Integer.toString(this.delayOverflow));
                list.add("overflowHandling:" + this.overflowHandling.toString());
                list.add("overflowChartHandling:" + this.overflowChartHandling.toString());
                list.add("delayTimeout:" + this.delayTimeout);
                list.add("timeoutValue:" + this.timeoutValue);
                list.add("uid:" + Long.toString(this.uid));
                list.add("chartLowLog:" + Double.toString(this.chartLowLog));
                list.add("DeviceTableBackground:" + this.deviceTableBackground.name());
                list.add("fontSize:" + Integer.toString(this.fontSize));
                list.add("screen:" + this.screenUpperLeft.x + "," + this.screenUpperLeft.y + "," + this.screenSize.width + "," + this.screenSize.height);
                list.add("restorePopupLocations:" + (this.restorePopupLocations ? "1" : "0"));
                int i = 0;
                while (i < this.imageResolution.length) {
                    list.add("imageResolution" + i + ":" + this.imageResolution[i].width + "," + this.imageResolution[i].height);
                    ++i;
                }
                list.add("lastFunctions:" + this.lastFunctions.toString());
                FileUtil.writeFile(file, list);
            }
            catch (IOException iOException) {}
        }

        public void saveDefault() {
            this.saveToFile(new File(String.valueOf(Support.getConfigPath()) + "/settingsConfig.txt"));
        }

        public void loadDefault() {
            this.loadFromFile(new File(String.valueOf(Support.getConfigPath()) + "/settingsConfig.txt"));
        }
    }

    public static class TransferableImage
    implements Transferable {
        Image i;

        public TransferableImage(Image i) {
            this.i = i;
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            if (flavor.equals(DataFlavor.imageFlavor) && this.i != null) {
                return this.i;
            }
            throw new UnsupportedFlavorException(flavor);
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            DataFlavor[] flavors = new DataFlavor[]{DataFlavor.imageFlavor};
            return flavors;
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            DataFlavor[] flavors = this.getTransferDataFlavors();
            int i = 0;
            while (i < flavors.length) {
                if (flavor.equals(flavors[i])) {
                    return true;
                }
                ++i;
            }
            return false;
        }
    }

    public static class TransferableText
    implements Transferable {
        String text;

        public TransferableText(String text) {
            this.text = text;
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            if (flavor.equals(DataFlavor.getTextPlainUnicodeFlavor()) && this.text != null) {
                return this.text;
            }
            throw new UnsupportedFlavorException(flavor);
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            DataFlavor[] flavors = new DataFlavor[]{DataFlavor.getTextPlainUnicodeFlavor()};
            return flavors;
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            DataFlavor[] flavors = this.getTransferDataFlavors();
            int i = 0;
            while (i < flavors.length) {
                if (flavor.equals(flavors[i])) {
                    return true;
                }
                ++i;
            }
            return false;
        }
    }

    public static enum UpdateType {
        Devices,
        ColumnsSource,
        ColumnsTable,
        StartInit;

    }

    public static class WidthTableColumnModel
    extends DefaultTableColumnModel {
        private List<Integer> orginalWidths;
        private List<Integer> widths = new ArrayList<Integer>();

        public WidthTableColumnModel(List<Integer> widths) {
            this.orginalWidths = widths;
            this.scale(1.0);
        }

        public WidthTableColumnModel(int[] widths) {
            this.orginalWidths = new ArrayList<Integer>(widths.length);
            int[] nArray = widths;
            int n = widths.length;
            int n2 = 0;
            while (n2 < n) {
                int i = nArray[n2];
                this.orginalWidths.add(i);
                ++n2;
            }
            this.scale(1.0);
        }

        public void scale(double scale) {
            this.widths.clear();
            for (int i : this.orginalWidths) {
                this.widths.add((int)((double)i * scale + 0.5));
            }
        }

        @Override
        public TableColumn getColumn(int columnIndex) {
            int w;
            TableColumn tc = super.getColumn(columnIndex);
            if (columnIndex < 0) {
                return tc;
            }
            if (columnIndex < this.widths.size() && this.widths.get(columnIndex) != 0) {
                int w2 = this.widths.get(columnIndex);
                if (w2 != tc.getMinWidth()) {
                    tc.setMinWidth(w2);
                    tc.setPreferredWidth(this.widths.get(columnIndex));
                }
            } else if (columnIndex >= this.widths.size() && this.widths.get(this.widths.size() - 1) != 0 && (w = this.widths.get(this.widths.size() - 1).intValue()) != tc.getMinWidth()) {
                tc.setMinWidth(w);
                tc.setPreferredWidth(this.widths.get(this.widths.size() - 1));
            }
            return tc;
        }
    }
}

