/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.main;

import dk.hkj.main.Support;
import dk.hkj.main.ValueFormat;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

public abstract class StatValues
implements TableModel,
Iterable<StatValue> {
    private List<StatValue> values = new ArrayList<StatValue>();
    private List<TableModelListener> listeners = new ArrayList<TableModelListener>();
    private boolean currentValue = false;
    private NumberFormat nf;
    private char slopeMode = (char)115;
    private boolean isTimeBased = true;

    public StatValues(boolean currentValue) {
        this.currentValue = currentValue;
        this.nf = NumberFormat.getNumberInstance(Locale.ENGLISH);
        this.nf.setGroupingUsed(false);
    }

    public void setSlopeMode(char slopeMode) {
        this.isTimeBased = true;
        switch (Character.toUpperCase(slopeMode)) {
            case 'S': {
                this.slopeMode = (char)115;
                break;
            }
            case 'M': {
                this.slopeMode = (char)109;
                break;
            }
            case 'H': {
                this.slopeMode = (char)104;
                break;
            }
            case ' ': {
                this.isTimeBased = false;
            }
        }
    }

    public char getSlopeMode() {
        return this.slopeMode;
    }

    public void clear() {
        this.values.clear();
    }

    public void add(StatValue value) {
        this.values.add(value);
        this.sendNotificationLayout();
    }

    public void add(String name) {
        this.values.add(new StatValue(name));
        this.sendNotificationLayout();
    }

    public void add(String name, int column, ValueFormat fmt) {
        this.values.add(new StatValue(name, column, fmt));
        this.sendNotificationLayout();
    }

    public void addAll(Iterable<String> names) {
        for (String s : names) {
            this.values.add(new StatValue(s));
        }
        this.sendNotificationLayout();
    }

    public StatValue getEntry(String name) {
        for (StatValue v : this.values) {
            if (!v.name.equals(name)) continue;
            return v;
        }
        return null;
    }

    public StatValue getEntry(int index) {
        return this.values.get(index);
    }

    public void update() {
        this.updater();
        this.sendNotificationData();
    }

    public abstract void updater();

    @Override
    public void addTableModelListener(TableModelListener l) {
        this.listeners.add(l);
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return String.class;
    }

    @Override
    public int getColumnCount() {
        return this.currentValue ? 8 : 9;
    }

    @Override
    public String getColumnName(int column) {
        if (this.currentValue && column >= 2) {
            ++column;
        }
        switch (column) {
            case 0: {
                return "Name";
            }
            case 1: {
                return "Unit";
            }
            case 2: {
                return "First";
            }
            case 3: {
                return this.currentValue ? "Current" : "Last";
            }
            case 4: {
                return "Minimum";
            }
            case 5: {
                return "Maximum";
            }
            case 6: {
                return "Range";
            }
            case 7: {
                return "Average";
            }
            case 8: {
                return "Slope /" + (this.isTimeBased ? (char)this.slopeMode : (char)' ');
            }
        }
        return "";
    }

    @Override
    public int getRowCount() {
        return this.values.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object getValueAt(int row, int column) {
        StatValue v = this.values.get(row);
        if (this.currentValue && column >= 2) {
            ++column;
        }
        StatValue statValue = v;
        synchronized (statValue) {
            switch (column) {
                case 0: {
                    return v.getName().replace("_", " ");
                }
                case 1: {
                    return ((StatValue)v).fmt.unit.replace("_", " ");
                }
                case 2: {
                    return ((StatValue)v).fmt.format.formatDisplay(v.getFirst());
                }
                case 3: {
                    return ((StatValue)v).fmt.format.formatDisplay(v.getLast());
                }
                case 4: {
                    return ((StatValue)v).fmt.format.formatDisplay(v.getMinimum());
                }
                case 5: {
                    return ((StatValue)v).fmt.format.formatDisplay(v.getMaximum());
                }
                case 6: {
                    if (((StatValue)v).fmt.format.digitalValues() > 0) {
                        return "-";
                    }
                    String string = ((StatValue)v).fmt.format.formatDisplay(v.getMaximum() - v.getMinimum());
                    return string;
                }
                case 7: {
                    if (((StatValue)v).fmt.format.digitalValues() > 0) {
                        return "-";
                    }
                    String string = ((StatValue)v).fmt.format.formatDisplay(v.getAverage());
                    return string;
                }
                case 8: {
                    if (((StatValue)v).fmt.format.digitalValues() > 0) return "-";
                    if (!v.slopeValid()) {
                        return "-";
                    }
                    double vv = v.slope;
                    if (Math.abs(vv) > 1.0E7) {
                        return new DecimalFormat("0.####E0;-0.####E0").format(vv);
                    }
                    if (this.isTimeBased) {
                        switch (this.slopeMode) {
                            case 's': {
                                this.nf.setMaximumFractionDigits(4);
                                this.nf.setMinimumFractionDigits(4);
                                break;
                            }
                            case 'm': {
                                this.nf.setMaximumFractionDigits(3);
                                this.nf.setMinimumFractionDigits(3);
                                vv *= 60.0;
                                break;
                            }
                            case 'h': {
                                this.nf.setMaximumFractionDigits(2);
                                this.nf.setMinimumFractionDigits(2);
                                vv *= 3600.0;
                            }
                        }
                    } else {
                        this.nf.setMaximumFractionDigits(4);
                        this.nf.setMinimumFractionDigits(4);
                    }
                    if (Double.isNaN(vv)) {
                        return "?";
                    }
                    String string = this.nf.format(vv);
                    return string;
                }
            }
            return "";
        }
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return false;
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
        this.listeners.remove(l);
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
    }

    public void sendNotificationData() {
        for (TableModelListener ml : this.listeners) {
            ml.tableChanged(new TableModelEvent(this, 0, this.getRowCount()));
            ml.tableChanged(new TableModelEvent(this, -1));
        }
    }

    public void sendNotificationLayout() {
        for (TableModelListener ml : this.listeners) {
            ml.tableChanged(new TableModelEvent(this, -1));
        }
    }

    @Override
    public Iterator<StatValue> iterator() {
        return this.values.iterator();
    }

    public void copyToClipboard() {
        StringBuilder sb = new StringBuilder();
        sb.append("Name");
        sb.append("\t");
        sb.append("Unit");
        sb.append("\t");
        if (!this.currentValue) {
            sb.append("First");
            sb.append("\t");
            sb.append("Last");
            sb.append("\t");
        } else {
            sb.append("Current");
            sb.append("\t");
        }
        sb.append("Minimum");
        sb.append("\t");
        sb.append("Maximum");
        sb.append("\t");
        sb.append("Range");
        sb.append("\t");
        sb.append("Average");
        sb.append("\t");
        sb.append("Slope");
        sb.append("\n");
        Iterator<StatValue> iterator = this.iterator();
        while (iterator.hasNext()) {
            StatValue statValue;
            StatValue v = statValue = iterator.next();
            sb.append(v.name.replace("_", " "));
            sb.append("\t");
            sb.append(((StatValue)statValue).fmt.unit.replace("_", " "));
            sb.append("\t");
            if (!this.currentValue) {
                sb.append(((StatValue)v).fmt.format.formatDisplay(statValue.first).replace('.', DecimalFormatSymbols.getInstance().getDecimalSeparator()));
                sb.append("\t");
            }
            sb.append(((StatValue)v).fmt.format.formatDisplay(statValue.last).replace('.', DecimalFormatSymbols.getInstance().getDecimalSeparator()));
            sb.append("\t");
            sb.append(((StatValue)v).fmt.format.formatDisplay(statValue.minimum).replace('.', DecimalFormatSymbols.getInstance().getDecimalSeparator()));
            sb.append("\t");
            sb.append(((StatValue)v).fmt.format.formatDisplay(statValue.maximum).replace('.', DecimalFormatSymbols.getInstance().getDecimalSeparator()));
            sb.append("\t");
            sb.append(((StatValue)v).fmt.format.digitalValues() > 0 ? "-" : ((StatValue)v).fmt.format.formatDisplay(statValue.maximum - statValue.minimum).replace('.', DecimalFormatSymbols.getInstance().getDecimalSeparator()));
            sb.append("\t");
            sb.append(((StatValue)v).fmt.format.digitalValues() > 0 ? "-" : ((StatValue)v).fmt.format.formatDisplay(statValue.average).replace('.', DecimalFormatSymbols.getInstance().getDecimalSeparator()));
            sb.append("\t");
            sb.append(((StatValue)v).fmt.format.digitalValues() == 0 && statValue.slopeValid ? ((StatValue)v).fmt.format.formatDisplay(statValue.slope).replace('.', DecimalFormatSymbols.getInstance().getDecimalSeparator()) : "-");
            sb.append("\n");
        }
        try {
            StringSelection stringSelection = new StringSelection(sb.toString());
            Clipboard clpbrd = Toolkit.getDefaultToolkit().getSystemClipboard();
            clpbrd.setContents(stringSelection, null);
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
    }

    public static class StatValue {
        private String name = "";
        private int columnNo = -1;
        private double first = 0.0;
        private double last = 0.0;
        private double minimum = 0.0;
        private double maximum = 0.0;
        private double average = 0.0;
        private double slope = 0.0;
        private boolean slopeValid = false;
        private ValueFormat fmt;

        public StatValue() {
        }

        public StatValue(String name) {
            this.name = name;
            this.columnNo = Support.dataBase.header().getIndex(name);
            this.fmt = Support.dataBase.format().get(this.columnNo);
        }

        public StatValue(String name, int columnNo, ValueFormat fmt) {
            this.name = name;
            this.columnNo = columnNo;
            this.fmt = fmt;
            if (fmt == null) {
                fmt = new ValueFormat("", "", ValueFormat.formatD2);
            }
        }

        public void define(String name, int columnNo, ValueFormat fmt) {
            this.name = name;
            this.columnNo = columnNo;
            this.fmt = fmt;
            if (fmt == null) {
                fmt = new ValueFormat("", "", ValueFormat.formatD2);
            }
        }

        public ValueFormat getFormat() {
            return this.fmt;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void update(double[] data, double time) {
            double min = Double.MAX_VALUE;
            double max = -1.7976931348623157E308;
            double sumx = 0.0;
            double sumy = 0.0;
            double sumxx = 0.0;
            double sumxy = 0.0;
            boolean digital = this.fmt != null && this.fmt.format instanceof ValueFormat.ValueFormatterDigital;
            int n = 0;
            if (digital) {
                int mi = 65535;
                int mx = 0;
                int i = 0;
                while (i < data.length) {
                    try {
                        int d = (int)data[i];
                        mi &= d;
                        mx |= d;
                        ++n;
                    }
                    catch (Exception exception) {}
                    ++i;
                }
                min = mi;
                max = mx;
            } else {
                int i = 0;
                while (i < data.length) {
                    double d = data[i];
                    if (Double.isFinite(d)) {
                        ++n;
                        if (d > max) {
                            max = d;
                        }
                        if (d < min) {
                            min = d;
                        }
                        sumy += d;
                        sumx += (double)i;
                        sumxx += (double)(i * i);
                        sumxy += (double)i * d;
                    }
                    ++i;
                }
            }
            if (n == 0) {
                if (data.length > 0) {
                    this.first = data[0];
                    this.last = data[data.length - 1];
                } else {
                    this.first = 0.0;
                    this.last = 0.0;
                }
                this.minimum = 0.0;
                this.maximum = 0.0;
                this.average = 0.0;
                this.slope = 0.0;
                this.slopeValid = false;
                return;
            }
            StatValue statValue = this;
            synchronized (statValue) {
                double b = ((double)n * sumxy - sumy * sumx) / ((double)n * sumxx - sumx * sumx);
                if (n > 10) {
                    this.slopeValid = true;
                    this.slope = b * (double)(data.length - 1) / time;
                }
                this.first = data[0];
                this.last = data[data.length - 1];
                this.average = sumy / (double)data.length;
                this.minimum = min;
                this.maximum = max;
            }
        }

        public String getName() {
            return this.name;
        }

        public double getFirst() {
            return this.first;
        }

        public double getLast() {
            return this.last;
        }

        public double getMinimum() {
            return this.minimum;
        }

        public double getMaximum() {
            return this.maximum;
        }

        public double getAverage() {
            return this.average;
        }

        public double getSlope() {
            return this.slope;
        }

        public boolean slopeValid() {
            return this.slopeValid;
        }

        public int getColumnNo() {
            return this.columnNo;
        }
    }
}

