/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.main;

import dk.hkj.main.ChartScales;
import dk.hkj.main.InterfaceThreads;
import dk.hkj.main.Main;
import dk.hkj.main.Mathematics;
import dk.hkj.main.PopupAdjustScale;
import dk.hkj.main.PopupAlarm;
import dk.hkj.main.PopupAutoAdjust;
import dk.hkj.main.PopupAutoHold;
import dk.hkj.main.PopupCalculator;
import dk.hkj.main.PopupFFTView;
import dk.hkj.main.PopupGridPanel;
import dk.hkj.main.PopupImage;
import dk.hkj.main.PopupLogEvent;
import dk.hkj.main.PopupLogTrigger;
import dk.hkj.main.PopupMPPT;
import dk.hkj.main.PopupParamAdjuster;
import dk.hkj.main.PopupParamSweeper;
import dk.hkj.main.PopupReadout;
import dk.hkj.main.PopupScriptList;
import dk.hkj.main.PopupTimer;
import dk.hkj.main.PopupTimerCounter;
import dk.hkj.main.PopupVarDisplay;
import dk.hkj.main.Support;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;

public class SetupScriptGenerator {
    SetupScriptGenerator() {
    }

    public List<String> getValueFormatScript() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(";");
        list.add("; Format definition for all values/columns from currently loaded devices");
        list.add("; This list may include unused value/column names (some devices defines unused columns)");
        list.add("; Lines from this script will typically be placed at the end of a layout script");
        if (InterfaceThreads.getDevices() != null) {
            for (InterfaceThreads.DeviceThread dt : InterfaceThreads.getDevices()) {
                list.addAll(dt.getDeviceInterface().generateScriptValueName());
            }
        }
        list.addAll(Support.math.generateScriptValueFormats());
        return list;
    }

    public List<String> getDeviceScript() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("#CloseAll");
        list.add(";");
        list.add("; Loaded devices");
        list.add("#Device");
        if (InterfaceThreads.getDevices() != null) {
            for (InterfaceThreads.DeviceThread dt : InterfaceThreads.getDevices()) {
                list.add("#Device \"" + dt.getDeviceInterface().getDeviceName() + "\" " + dt.cPort.getAddress());
            }
        }
        list.add("#Reconnect");
        list.add("#WaitReady");
        return list;
    }

    public List<String> getScaleScript() {
        ArrayList<String> list = new ArrayList<String>();
        TreeSet<String> cs = new TreeSet<String>();
        list.add(";");
        list.add("; Adding scales, when needed a missing scale will always be auto created");
        if (InterfaceThreads.getDevices() != null) {
            for (InterfaceThreads.DeviceThread dt : InterfaceThreads.getDevices()) {
                cs.addAll(Support.chartScales.matchingChannels(String.valueOf(dt.getHandleName()) + "\\..*"));
            }
        }
        for (String s : Support.dataBase.header().getDataColumnsList()) {
            cs.add(s);
        }
        cs.remove("index");
        cs.remove("time");
        cs.remove("datetime");
        for (String s : cs) {
            list.addAll(Support.chartScales.generateScript(s));
        }
        return list;
    }

    public List<String> getScript() {
        ArrayList<String> list = new ArrayList<String>();
        list.addAll(this.getDeviceScript());
        list.add(";");
        list.add("; Device mode & setup popups");
        if (InterfaceThreads.getDevices() != null) {
            for (InterfaceThreads.DeviceThread dt : InterfaceThreads.getDevices()) {
                list.addAll(dt.getDeviceInterface().generateScriptPopup());
            }
        }
        list.addAll(this.getScaleScript());
        list.add(";");
        list.add("; Enabled math channels, these will usually require specific devices");
        list.addAll(Support.math.generateScriptMath());
        for (Mathematics.MathEntry me : Support.math.getEnabledMathEntries()) {
            ChartScales.ChartScale cs = Support.chartScales.getExistingScale(me.getFullName());
            if (cs == null) continue;
            list.add(cs.generateScript());
        }
        list.add(";");
        list.add("; Popup windows including location, this will also move the main window");
        list.addAll(Main.generateScript());
        list.addAll(PopupAdjustScale.generateScript());
        list.addAll(PopupAlarm.generateScript());
        list.addAll(PopupCalculator.generateScript());
        list.addAll(PopupLogTrigger.generateScript());
        list.addAll(PopupTimer.generateScript());
        list.addAll(PopupReadout.generateScript());
        list.addAll(PopupVarDisplay.generateScript());
        list.addAll(PopupParamAdjuster.generateScript());
        list.addAll(PopupParamSweeper.generateScript());
        list.addAll(PopupImage.generateScript());
        list.addAll(PopupAutoHold.generateScript());
        list.addAll(PopupScriptList.generateScript());
        list.addAll(PopupLogEvent.generateScript());
        list.addAll(PopupFFTView.generateScript());
        list.addAll(PopupMPPT.generateScript());
        list.addAll(PopupAutoAdjust.generateScript());
        list.addAll(PopupTimerCounter.generateScript());
        list.addAll(PopupGridPanel.generateScript());
        list.add(";");
        list.add("; Restoring of miscellaneous user interface settings");
        list.addAll(Support.paneCurrentValues.generateScript());
        list.add(";");
        list.add("; Finishing off by clearing the log window without enabling restore option");
        list.add("#Clear 1");
        return list;
    }
}

