/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.main;

import dk.hkj.main.DeviceInterface;
import dk.hkj.main.FontAdjust;
import dk.hkj.main.HelpLoader;
import dk.hkj.main.InterfaceThreads;
import dk.hkj.main.Main;
import dk.hkj.main.PopupImage;
import dk.hkj.main.Support;
import dk.hkj.script.Script;
import dk.hkj.util.FileUtil;
import java.awt.Container;
import java.awt.Desktop;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListMap;
import javax.swing.JMenu;
import javax.swing.JOptionPane;

public class ScriptMenu {
    private static final int MAX_MENU_DEPTH = 10;
    private static final String ScriptMenu = "#scriptMenu";
    private static final String ScriptScript = "#scriptScript";
    private static final String ScriptSystemVersion = "#scriptSystemVersion";
    private static final String ScriptDevices = "#scriptDevices";
    private static final String ScriptHandles = "#scriptHandles";
    private static final String ScriptNoLog = "#scriptNoLog";
    private static final String ScriptInterface = "#scriptInterface";
    private static final String ScriptTable = "#scriptTable";
    private static final String ScriptAutorun = "#autorun";
    private static final String ScriptShowImage = "#scriptShowImage";
    private Thread loaderThread;
    private Map<String, ScriptEntry> menuScripts = new ConcurrentSkipListMap<String, ScriptEntry>();
    private Map<String, ScriptEntry> scriptScripts = new HashMap<String, ScriptEntry>();
    private String formattedVersion = Support.formatVersion("2.38");
    private boolean scriptsLoaded = false;

    ScriptMenu() {
        this.loaderThread = new Thread(){

            @Override
            public void run() {
                ScriptMenu.this.loadScripts();
            }
        };
        this.loaderThread.setDaemon(true);
        this.loaderThread.setPriority(1);
        this.loaderThread.start();
    }

    public List<ScriptEntry> getScriptList(boolean includeHidden, boolean includeSystem) {
        ArrayList<ScriptEntry> list = new ArrayList<ScriptEntry>();
        for (ScriptEntry se : this.menuScripts.values()) {
            if (!includeSystem && se.isSystem()) continue;
            list.add(se);
        }
        if (includeHidden) {
            for (ScriptEntry se : this.scriptScripts.values()) {
                if (!includeSystem && se.isSystem()) continue;
                list.add(se);
            }
        }
        return list;
    }

    private String findTag(String tag, List<String> script) {
        tag = tag.toLowerCase();
        int i = 0;
        while (i < Math.min(15, script.size())) {
            String line = script.get(i).trim();
            if (line.toLowerCase().startsWith(tag)) {
                return line.substring(tag.length()).trim();
            }
            ++i;
        }
        return "";
    }

    private void addItem(File f, List<String> script) {
        if (script.size() < 3) {
            return;
        }
        String ver = this.findTag(ScriptSystemVersion, script);
        if (ver.length() > 0 && (ver = Support.formatVersion(ver)).compareTo(this.formattedVersion) > 0) {
            return;
        }
        String line = script.get(0);
        int i = line.indexOf(32);
        if (i < 0) {
            return;
        }
        line = line.substring(i + 1).trim();
        if (this.findTag(ScriptScript, script).isEmpty()) {
            if (this.menuScripts.containsKey(line.toLowerCase())) {
                return;
            }
            this.menuScripts.put(line.toLowerCase(), new ScriptEntry(f, line, script));
        } else {
            if (this.scriptScripts.containsKey(line.toLowerCase())) {
                return;
            }
            this.scriptScripts.put(line.toLowerCase(), new ScriptEntry(f, line, script));
        }
    }

    public static void showImage(List<String> script) {
        ArrayList<String> images = new ArrayList<String>();
        for (String line : script) {
            if (!line.toLowerCase().startsWith(ScriptShowImage.toLowerCase())) continue;
            String[] stringArray = Support.splitWithQuotes(line.substring(ScriptShowImage.length() + 1));
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                images.add(s);
                ++n2;
            }
        }
        if (images.size() > 0) {
            PopupImage pi = PopupImage.getPopup();
            pi.setShowFirstLoaded();
            for (String s : images) {
                pi.addImage(s);
            }
            pi.showDefault(false);
        }
    }

    public ScriptEntry getScript(String id, boolean showImage) {
        ScriptEntry pgm = this.menuScripts.get(id.toLowerCase());
        if (pgm == null) {
            pgm = this.scriptScripts.get(id.toLowerCase());
        }
        if (pgm == null) {
            return null;
        }
        if (showImage) {
            dk.hkj.main.ScriptMenu.showImage(pgm.getScriptList());
        }
        return pgm;
    }

    private void parse(File f, List<String> list) {
        ArrayList<String> script = null;
        int i = 0;
        while (i < list.size()) {
            String line = list.get(i).trim();
            if (line.toLowerCase().startsWith(ScriptMenu.toLowerCase()) || line.toLowerCase().startsWith(ScriptScript.toLowerCase())) {
                if (script != null) {
                    this.addItem(f, script);
                }
                script = new ArrayList<String>();
            }
            if (script != null) {
                script.add(line);
            }
            ++i;
        }
        if (script != null) {
            this.addItem(f, script);
        }
    }

    public void add(Container menu, String menuId, ActionListener listener) {
        if (!this.scriptsLoaded) {
            return;
        }
        FontAdjust.FontMenuItem mi = null;
        JMenu[] mn = new JMenu[11];
        for (String key : this.menuScripts.keySet()) {
            if (!this.menuScripts.get(key).includeScriptInMenu()) continue;
            ScriptEntry script = this.menuScripts.get(key);
            String[] s = script.getMenuNames();
            int i = 0;
            while (i < s.length) {
                s[i] = s[i].trim();
                ++i;
            }
            if (s.length >= 10) continue;
            i = 0;
            while (i < s.length - 1) {
                if (mn[i] == null || !mn[i].getText().equalsIgnoreCase(s[i])) {
                    mn[i] = new FontAdjust.FontMenu(s[i]);
                    if (i == 0) {
                        menu.add(mn[i]);
                    } else {
                        mn[i - 1].add(mn[i]);
                    }
                    int j = i + 1;
                    while (j < mn.length) {
                        mn[j] = null;
                        ++j;
                    }
                }
                ++i;
            }
            mi = new FontAdjust.FontMenuItem(String.valueOf(s[s.length - 1]) + (script.isAutorun() ? " >>" : ""));
            mi.setActionCommand(String.valueOf(menuId) + key);
            mi.addActionListener(listener);
            if (s.length == 1) {
                menu.add(mi);
                continue;
            }
            mn[s.length - 2].add(mi);
        }
    }

    public boolean isScriptsLoaded() {
        return this.scriptsLoaded;
    }

    public synchronized void reload() {
        this.menuScripts.clear();
        this.scriptScripts.clear();
        this.loadScripts();
    }

    private synchronized void loadScripts() {
        File path = new File(Support.getScriptPath());
        if (path.exists()) {
            File[] fileArray = path.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File f, String name) {
                    return name.toLowerCase().matches("(?i).*script\\.txt");
                }
            });
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                try {
                    List<String> list = FileUtil.readFileAsListAutoCharset(f);
                    this.parse(f, list);
                }
                catch (IOException e) {
                    e.printStackTrace(System.out);
                }
                ++n2;
            }
        }
        this.parse(new File(String.valueOf(Support.getConfigPath()) + "/ScriptLibrary.dat"), HelpLoader.getFile("/pic/Projects/TestController/ScriptLibrary.dat", String.valueOf(Support.getConfigPath()) + "/ScriptLibrary.dat"));
        this.scriptsLoaded = true;
    }

    public boolean fileExists(String filename) {
        File f = new File(String.valueOf(Support.getScriptPath()) + "/" + filename + "Script.txt");
        return f.exists();
    }

    public void saveScript(String filename, String menuName, List<String> list, boolean edit) {
        File path = new File(Support.getScriptPath());
        path.mkdir();
        list.add(0, "#scriptMenu " + menuName);
        File f = new File(String.valueOf(path.getPath()) + "/" + filename + "Script.txt");
        try {
            FileUtil.writeFileAutoCharset(f, list);
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(Main.main.frame, "Failed to save script", "Error", 0);
        }
        this.menuScripts.put(menuName.toLowerCase(), new ScriptEntry(f, menuName, list));
        if (!edit) {
            return;
        }
        try {
            Desktop dt = Desktop.getDesktop();
            if (dt != null) {
                dt.open(f);
            }
        }
        catch (Exception exception) {}
    }

    public void openDirectory() {
        try {
            Desktop dt = Desktop.getDesktop();
            if (dt != null) {
                dt.open(new File(Support.getScriptPath()));
            }
        }
        catch (Exception exception) {}
    }

    public class ScriptEntry {
        private String name;
        private File file;
        private List<String> script;

        private ScriptEntry(File file, String name, List<String> script) {
            this.file = file;
            this.name = name;
            while (script.get(script.size() - 1).trim().isEmpty()) {
                script.remove(script.size() - 1);
            }
            this.script = script;
        }

        public List<String> getScriptList() {
            return this.script;
        }

        public boolean isEmptry() {
            return this.getFilteredScript().length() == 0;
        }

        public boolean isMenuEntry() {
            return this.getMenuNames() != null;
        }

        public String getName() {
            return this.name;
        }

        public String[] getMenuNames() {
            String scriptMenu = this.findTag(dk.hkj.main.ScriptMenu.ScriptMenu);
            return scriptMenu == null ? null : scriptMenu.split("[;]+");
        }

        public boolean isSystem() {
            return this.file.getName().equals("ScriptLibrary.dat");
        }

        public String getFileName() {
            return this.isSystem() ? "<System>" : this.file.getName();
        }

        public File getFile() {
            return this.file;
        }

        public int getSize() {
            return this.script.size();
        }

        public String getFilters() {
            StringBuilder sb = new StringBuilder();
            if (this.hasTag(dk.hkj.main.ScriptMenu.ScriptScript)) {
                return "Script";
            }
            if (this.hasTag(dk.hkj.main.ScriptMenu.ScriptInterface)) {
                sb.append("IF");
            }
            if (this.hasTag(dk.hkj.main.ScriptMenu.ScriptTable)) {
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append("Table");
            }
            if (this.hasTag(dk.hkj.main.ScriptMenu.ScriptHandles)) {
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append("Handles");
            }
            if (this.hasTag(dk.hkj.main.ScriptMenu.ScriptNoLog)) {
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append("NoLog");
            }
            return sb.toString();
        }

        private String findTag(String tag) {
            tag = tag.toLowerCase();
            int i = 0;
            while (i < Math.min(15, this.script.size())) {
                String line = this.script.get(i).trim();
                if (line.toLowerCase().startsWith(tag)) {
                    return line.substring(tag.length()).trim();
                }
                ++i;
            }
            return "";
        }

        private boolean hasTag(String tag) {
            tag = tag.toLowerCase();
            int i = 0;
            while (i < Math.min(15, this.script.size())) {
                String line = this.script.get(i).trim();
                if (line.toLowerCase().startsWith(tag)) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        public String getScript() {
            StringBuilder sb = new StringBuilder();
            for (String line : this.script) {
                sb.append(line);
                sb.append('\n');
            }
            return sb.toString();
        }

        public String getFilteredScript() {
            StringBuilder sb = new StringBuilder();
            for (String line : this.script) {
                String lineLC = line.toLowerCase();
                if (lineLC.startsWith(dk.hkj.main.ScriptMenu.ScriptMenu.toLowerCase()) || lineLC.startsWith(dk.hkj.main.ScriptMenu.ScriptSystemVersion.toLowerCase()) || lineLC.startsWith(dk.hkj.main.ScriptMenu.ScriptInterface.toLowerCase()) || lineLC.startsWith(dk.hkj.main.ScriptMenu.ScriptScript.toLowerCase()) || lineLC.startsWith(dk.hkj.main.ScriptMenu.ScriptAutorun.toLowerCase()) || lineLC.startsWith(dk.hkj.main.ScriptMenu.ScriptHandles.toLowerCase()) || lineLC.startsWith(dk.hkj.main.ScriptMenu.ScriptTable.toLowerCase()) || lineLC.startsWith(dk.hkj.main.ScriptMenu.ScriptNoLog.toLowerCase()) || lineLC.startsWith(dk.hkj.main.ScriptMenu.ScriptDevices.toLowerCase())) continue;
                sb.append(line);
                sb.append('\n');
            }
            return sb.toString();
        }

        public boolean isAutorun() {
            int i = 0;
            while (i < Math.min(this.script.size(), 10)) {
                String line = this.script.get(i).trim();
                if (line.toLowerCase().startsWith(dk.hkj.main.ScriptMenu.ScriptAutorun)) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        public boolean includeScriptInMenu() {
            for (String line : this.script) {
                int n;
                String[] stringArray;
                String handle;
                String[] items;
                String lineLower = line.toLowerCase();
                if (lineLower.startsWith(dk.hkj.main.ScriptMenu.ScriptInterface.toLowerCase())) {
                    items = (line = line.substring(dk.hkj.main.ScriptMenu.ScriptInterface.length()).trim()).split("[ ;,]+");
                    handle = new Script().expression("getDevice(\"" + items[0] + "\")").asString();
                    DeviceInterface di = InterfaceThreads.getLoadedDeviceInterfaceHandle(handle);
                    if (di == null) {
                        return false;
                    }
                    int j = 1;
                    while (j < items.length) {
                        if (!di.getIFaces().containsKey(items[j])) {
                            return false;
                        }
                        ++j;
                    }
                    continue;
                }
                if (lineLower.startsWith(dk.hkj.main.ScriptMenu.ScriptHandles.toLowerCase())) {
                    line = line.substring(dk.hkj.main.ScriptMenu.ScriptHandles.length()).trim();
                    stringArray = items = line.split("[ ;,]+");
                    n = items.length;
                    int n2 = 0;
                    while (n2 < n) {
                        handle = stringArray[n2];
                        DeviceInterface di = InterfaceThreads.getLoadedDeviceInterfaceHandle(handle);
                        if (di == null) {
                            return false;
                        }
                        ++n2;
                    }
                    continue;
                }
                if (lineLower.startsWith(dk.hkj.main.ScriptMenu.ScriptTable.toLowerCase())) {
                    if (Support.dataBase.rows() == 0) {
                        return false;
                    }
                    if ((line = line.substring(dk.hkj.main.ScriptMenu.ScriptTable.length()).trim()).isEmpty()) continue;
                    stringArray = items = line.split("[ ;,]+");
                    n = items.length;
                    int n3 = 0;
                    while (n3 < n) {
                        String columns = stringArray[n3];
                        if (Support.dataBase.header().getIndex(columns) < 0) {
                            return false;
                        }
                        ++n3;
                    }
                    continue;
                }
                if (!lineLower.startsWith(dk.hkj.main.ScriptMenu.ScriptNoLog.toLowerCase()) || !InterfaceThreads.isLogging()) continue;
                return false;
            }
            return true;
        }

        public String toString() {
            return this.name;
        }
    }
}

