/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.main;

import dk.hkj.comm.GpibInterface;
import dk.hkj.comm.SerialInterface;
import dk.hkj.devices.ParseValues;
import dk.hkj.main.DeviceInterface;
import dk.hkj.main.InterfaceThreads;
import dk.hkj.main.Support;
import dk.hkj.script.Script;
import dk.hkj.util.StringUtil;
import dk.hkj.vars.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;

public class SCPICommand {
    private String cmd = "";
    private String readMath = "";
    private String readFormat = "";
    private DeviceInterface di = null;
    private Processor processor = null;
    private boolean debug = false;
    private boolean saveInCommandList = false;
    private double overflowValue = 1.0E36;
    private String lastAnswer = "";
    private StringBuilder collectSb = null;

    public SCPICommand(DeviceInterface di) {
        this.di = di;
        this.debug = InterfaceThreads.debugAll;
        this.setCmd(this.cmd);
    }

    public SCPICommand(DeviceInterface di, String cmd) {
        this.di = di;
        this.debug = InterfaceThreads.debugAll;
        this.setCmd(cmd);
    }

    public SCPICommand(DeviceInterface di, String cmd, String readMath, String readFormat) {
        this.di = di;
        this.debug = InterfaceThreads.debugAll;
        this.debug = InterfaceThreads.debugAll;
        this.setCmd(cmd);
        this.readMath = readMath;
        this.readFormat = readFormat;
    }

    public SCPICommand(DeviceInterface di, SCPICommand model) {
        this.di = di;
        this.debug = InterfaceThreads.debugAll;
        this.cmd = model.cmd;
        this.readMath = model.readMath;
        this.readFormat = model.readFormat;
    }

    public void clearCollect() {
        if (this.collectSb != null) {
            this.collectSb.setLength(0);
        }
    }

    public void enableCollect(boolean enable) {
        if (enable) {
            this.collectSb = new StringBuilder();
        } else if (this.collectSb != null) {
            this.collectSb = null;
        }
    }

    public String getCollected() {
        if (this.collectSb == null) {
            return "";
        }
        return this.collectSb.toString();
    }

    public void setDebug(boolean on) {
        this.debug = on || InterfaceThreads.debugAll;
    }

    public void setSaveInCommandList(boolean on) {
        this.saveInCommandList = on;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public boolean isValid() {
        return this.cmd.length() > 0;
    }

    public void setProcessor(String name) {
        this.processor = this.getProcessor(name);
    }

    private void debugLog(String tag) {
        if (this.di == null) {
            return;
        }
        this.di.debugLog(tag);
    }

    private void debugLog(String tag, String data, boolean hex) {
        if (this.di == null || this.di.dt == null || this.di.dt.cPort == null) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        if (this.di.handle != null) {
            sb.append(this.di.handle);
        } else {
            sb.append(this.di.dt.cPort.getDeviceName());
        }
        sb.append(": ");
        sb.append(tag);
        if (data == null) {
            sb.append(" Timeout");
        } else {
            sb.append(" <");
            sb.append(data);
            sb.append(">");
            if (hex) {
                sb.append(" ");
                sb.append(StringUtil.hexString(data));
            }
        }
        InterfaceThreads.logDebug(sb.toString());
    }

    public String getCmd() {
        return this.cmd == null ? "" : this.cmd;
    }

    public void setCmd(String cmd) {
        if (cmd != null) {
            StringBuilder sb = new StringBuilder();
            String[] stringArray = cmd.split("[\r\n]");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                if ((s = s.trim()).length() > 0 && s.charAt(0) != ';') {
                    if (sb.length() > 0) {
                        sb.append(';');
                    }
                    sb.append(s);
                }
                ++n2;
            }
            this.cmd = sb.toString();
        } else {
            this.cmd = "";
        }
    }

    public void setReadFormat(String format) {
        this.readFormat = format != null ? format.trim() : "";
    }

    public void setMathFormat(String math) {
        this.readMath = math != null ? math.trim() : "";
    }

    public void setExtraTimeout() {
        if (this.di == null) {
            return;
        }
        if (this.di.def != null) {
            this.di.noTimeoutBefore = (long)this.di.def.getModeChangeDelay() + System.currentTimeMillis();
        }
    }

    private String writeReadDelay(String str) {
        int timeout;
        if (this.di == null || this.di.dt == null || this.di.dt.cPort == null) {
            return "";
        }
        int n = timeout = this.di.def == null ? 1000 : this.di.def.getReadingDelay();
        if (this.di.noTimeoutBefore != 0L) {
            int t = (int)(this.di.noTimeoutBefore - System.currentTimeMillis());
            if (t > timeout) {
                timeout = t;
            } else {
                this.di.noTimeoutBefore = 0L;
            }
        }
        return this.di.dt.cPort.writeRead(str, timeout);
    }

    private synchronized String writeReadInternal(String cmd) {
        String s;
        StringBuilder sb;
        if (cmd.length() == 0 || this.di == null || this.di.dt == null || this.di.dt.cPort == null) {
            return "";
        }
        if (this.collectSb != null) {
            this.collectSb.append(cmd);
            return "";
        }
        if (cmd.indexOf(34) < 0) {
            if (cmd.indexOf(92) > 0) {
                sb = new StringBuilder();
                boolean esc = false;
                int i = 0;
                while (i < cmd.length()) {
                    char c = cmd.charAt(i);
                    if (esc) {
                        switch (c) {
                            case 'b': {
                                sb.append('\b');
                                break;
                            }
                            case 't': {
                                sb.append('\t');
                                break;
                            }
                            case 'n': {
                                sb.append('\n');
                                break;
                            }
                            case 'r': {
                                sb.append('\r');
                                break;
                            }
                            case '_': {
                                break;
                            }
                            case '\\': {
                                sb.append('\\');
                                break;
                            }
                            case ' ': {
                                sb.append(' ');
                                break;
                            }
                            case '\"': {
                                sb.append('\"');
                                break;
                            }
                            case '\'': {
                                sb.append('\'');
                                break;
                            }
                            case '\u0000': {
                                break;
                            }
                            case 'u': {
                                sb.append((char)Integer.parseInt("" + cmd.charAt(++i) + cmd.charAt(++i) + cmd.charAt(++i) + cmd.charAt(++i), 16));
                                break;
                            }
                            case 'x': {
                                sb.append((char)Integer.parseInt("" + cmd.charAt(++i) + cmd.charAt(++i), 16));
                                break;
                            }
                            default: {
                                sb.append(c);
                            }
                        }
                        esc = false;
                    } else if (c == '\\') {
                        esc = true;
                    } else if (c == '_') {
                        sb.append(' ');
                    } else {
                        sb.append(c);
                    }
                    ++i;
                }
                cmd = sb.toString();
            } else {
                cmd = cmd.replace('_', ' ');
            }
        }
        sb = new StringBuilder();
        String[] stringArray = cmd.split("[;]+");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String s2 = stringArray[n2];
            if ((s2 = s2.trim()).matches("\\[[0-9]{1,4}\\]")) {
                int t;
                if (this.saveInCommandList) {
                    Support.commandList.add(String.valueOf(this.di.getHandleName()) + ":" + s2);
                }
                if ((t = Integer.parseInt(s2.substring(1, s2.length() - 1))) > 0) {
                    SerialInterface.sleep(t);
                    if (this.debug) {
                        this.debugLog("Delay: " + t + "ms");
                    }
                }
            } else if (s2.equalsIgnoreCase("[*]")) {
                this.writeReadDelay("*ESE?");
            } else if (s2.equalsIgnoreCase("[*OPC]")) {
                if (this.saveInCommandList) {
                    Support.commandList.add(String.valueOf(this.di.getHandleName()) + ":" + s2);
                }
                this.di.dt.cPort.write("*OPC");
                int answer = 0;
                long t = System.currentTimeMillis();
                long dt = 0L;
                do {
                    String a;
                    if ((a = this.writeReadDelay("*ESR?")) != null && a.length() > 0) {
                        answer = Integer.parseInt(a.trim()) & 1;
                    }
                    if (answer == 0) {
                        SerialInterface.sleep(10);
                    }
                    dt = System.currentTimeMillis() - t;
                } while (answer != 1 && dt < 10000L);
                if (this.debug) {
                    this.debugLog("*OPC waited: " + dt + "ms");
                }
            } else if (s2.toUpperCase().matches("\\[(CLR|LLO|LOC|TRG)\\]")) {
                if (this.di.dt.cPort instanceof GpibInterface) {
                    ((GpibInterface)this.di.dt.cPort).writeControl(s2.substring(1, s2.length() - 1).toUpperCase());
                }
            } else if (s2.contains("?")) {
                String ss = this.di.commCache.get(s2);
                if (ss == null) {
                    if (this.debug) {
                        this.debugLog("Tx", s2, this.di.debugCommHex);
                    }
                    ss = this.writeReadDelay(s2);
                    if (this.debug) {
                        this.debugLog("Rx", ss, this.di.debugCommHex);
                    }
                    this.di.commCache.put(s2, ss);
                } else if (this.debug) {
                    InterfaceThreads.logDebug(String.valueOf(this.di.handle) + ": Cache Tx: <" + s2 + "> Rx: <" + ss + ">");
                }
                if (ss != null) {
                    ss = ss.trim();
                    sb.append(sb.length() > 0 && ss.length() > 0 ? " " : "");
                    sb.append(ss);
                }
            } else if (s2.length() > 0) {
                this.di.commCache.clear();
                if (this.debug) {
                    this.debugLog("Tx", s2, this.di.debugCommHex);
                }
                if (this.saveInCommandList) {
                    Support.commandList.add(String.valueOf(this.di.getHandleName()) + ":" + s2);
                }
                this.di.dt.cPort.write(s2);
            }
            ++n2;
        }
        this.lastAnswer = s = sb.toString();
        if (this.readMath.length() > 0) {
            this.di.getScript().addLocalVar(Var.createValue("value", s));
            s = this.di.getScript().expression(this.readMath).asString();
            if (this.debug) {
                this.debugLog("Rx after :readmath: " + this.readMath, s, false);
            }
        }
        if (this.processor != null) {
            s = this.processor.process(s);
            if (this.debug) {
                this.debugLog("Rx after internal processor", s, false);
            }
        }
        return s;
    }

    public synchronized String writeRead() {
        return this.writeReadInternal(this.cmd);
    }

    public synchronized String writeReadDirect(String cmd) {
        return this.writeReadInternal(cmd);
    }

    public synchronized void writeDirect(String cmd) {
        this.writeReadInternal(cmd);
    }

    public synchronized String writeRead(String param) {
        if (this.isValid() || param.length() > 0) {
            String s;
            if (this.cmd.contains("#")) {
                s = this.cmd.replaceAll("##", "???").replaceAll("#", param).replaceAll("\\?\\?\\?", "#");
            } else if (this.cmd.contains("(")) {
                Script script = new Script();
                script.addLocalVar("value", Var.createValue(param));
                s = Support.processScriptInBrackets(script, this.cmd);
            } else {
                s = String.valueOf(this.cmd) + (this.cmd.length() > 0 && param.length() > 0 ? " " : "") + param;
            }
            return this.writeReadInternal(s);
        }
        return "";
    }

    public synchronized String writeRead(List<String> params, String delimiter) {
        boolean isParams = false;
        for (String s : params) {
            if (s.isEmpty()) continue;
            isParams = true;
            break;
        }
        if (this.isValid() || isParams) {
            String s;
            s = this.cmd;
            if (this.cmd.contains("#")) {
                s = s.replaceAll("##", "???");
                for (String p : params) {
                    s = s.replaceFirst("#", Matcher.quoteReplacement(p));
                }
                while (s.indexOf(35) > 0) {
                    s = s.replace("#", "");
                }
                s = s.replaceAll("\\?\\?\\?", "#");
            } else if (this.cmd.contains("(")) {
                Script script = new Script();
                script.addLocalVar("value", Var.createValue(params.get(0)));
                int i = 1;
                while (i < params.size()) {
                    script.addLocalVar("value" + (i + 1), Var.createValue(params.get(i)));
                    ++i;
                }
                s = Support.processScriptInBrackets(script, this.cmd);
            } else {
                for (String p : params) {
                    s = String.valueOf(s) + (s.length() > 0 && p.length() > 0 ? delimiter : "") + p;
                }
            }
            return this.writeReadInternal(s);
        }
        return "";
    }

    public void write() {
        this.writeRead();
    }

    public void write(String param) {
        this.writeRead(param);
    }

    public void write(List<String> params, String delimiter) {
        this.writeRead(params, delimiter);
    }

    private double readNumberInternal() {
        if (!this.isValid()) {
            return Double.NaN;
        }
        String v = this.writeRead();
        if (this.readFormat.length() > 0) {
            ArrayList<Double> list = new ArrayList<Double>();
            ParseValues.parse(list, v.split("[,;\t ]+"), this.readFormat);
            if (list.size() >= 1) {
                double vv = (Double)list.get(0);
                if (Math.abs(vv) >= this.overflowValue) {
                    vv = DeviceInterface.overflowValueDouble(vv >= 0.0);
                }
                return vv;
            }
        } else {
            double vv = StringUtil.parseDoubleEE(v);
            if (Math.abs(vv) >= this.overflowValue) {
                vv = DeviceInterface.overflowValueDouble(vv >= 0.0);
            }
            return vv;
        }
        return Double.NaN;
    }

    public double readNumber() {
        double v = this.readNumberInternal();
        if (this.debug) {
            this.debugLog("Rx as number", "" + v, false);
        }
        return v;
    }

    public List<Double> readNumbers() {
        ArrayList<Double> list = new ArrayList<Double>();
        if (!this.isValid()) {
            if (this.debug) {
                this.debugLog("Rx as numbers", "", false);
            }
            return list;
        }
        String v = this.writeRead();
        if (v.trim().isEmpty()) {
            this.debugLog("Rx as numbers", "No data (timeout?)", false);
            return list;
        }
        if (this.readFormat.length() > 0) {
            ParseValues.parse(list, v.split("[,;\t ]+"), this.readFormat);
        } else {
            String[] stringArray = v.split("[,;\t ]+");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                list.add(StringUtil.parseDoubleEE(s));
                ++n2;
            }
        }
        int i = 0;
        while (i < list.size()) {
            if (Math.abs((Double)list.get(i)) >= this.overflowValue) {
                list.set(i, DeviceInterface.overflowValueDouble((Double)list.get(i) >= 0.0));
            }
            ++i;
        }
        if (this.debug) {
            StringBuilder sb = new StringBuilder();
            for (Double d : list) {
                if (sb.length() > 0) {
                    sb.append(" ");
                }
                sb.append(d);
            }
            this.debugLog("Rx as numbers", sb.toString(), false);
        }
        return list;
    }

    public String getLastAnswer() {
        return this.lastAnswer;
    }

    public String toString() {
        return "SCPI " + this.cmd;
    }

    Processor getProcessor(String name) {
        if (name == null || name.length() == 0) {
            return null;
        }
        String params = "";
        int i = (name = name.trim()).indexOf(32);
        if (i > 0) {
            params = name.substring(i + 1).trim();
            name.substring(0, i);
        }
        ProcessorSiglentSDG processor = null;
        if (name.equalsIgnoreCase("SiglentSDG")) {
            processor = new ProcessorSiglentSDG();
        }
        if (processor != null) {
            processor.setParams(params);
        }
        return processor;
    }

    abstract class Processor {
        String params;

        Processor() {
        }

        void setParams(String params) {
            this.params = params;
        }

        abstract String process(String var1);
    }

    class ProcessorSiglentSDG
    extends Processor {
        StringBuilder sb = new StringBuilder();

        ProcessorSiglentSDG() {
        }

        private String parseNumber(String s) {
            int i = s.indexOf(44);
            if (i < 0) {
                i = s.indexOf(32);
            }
            if (i > 0) {
                s = s.substring(0, i);
            }
            while (s.length() > 0 && Character.isAlphabetic(s.charAt(s.length() - 1))) {
                s = s.substring(0, s.length() - 1);
            }
            return s;
        }

        private void getFrequency(String answer) {
            int i = answer.indexOf("FRQ,");
            if (i > 0) {
                this.sb.append(this.parseNumber(answer.substring(i + 4)));
            } else {
                this.sb.append("0");
            }
            this.sb.append(" ");
        }

        private void getAmplitude(String answer) {
            int i = answer.indexOf("AMP,");
            int j = 4;
            if (i < 0) {
                i = answer.indexOf("MEAN,");
                j = 5;
            }
            if (i > 0) {
                this.sb.append(this.parseNumber(answer.substring(i + j)));
            } else {
                this.sb.append("0");
            }
            this.sb.append(" ");
        }

        private void getOffset(String answer) {
            int i = answer.indexOf("OFST,");
            if (i > 0) {
                this.sb.append(this.parseNumber(answer.substring(i + 5)));
            } else {
                this.sb.append("0");
            }
            this.sb.append(" ");
        }

        private void getDutyCycle(String answer) {
            int i = answer.indexOf("SYM,");
            int j = 4;
            if (i < 0) {
                i = answer.indexOf("DUTY,");
                j = 5;
            }
            if (i > 0) {
                this.sb.append(this.parseNumber(answer.substring(i + j)));
            } else {
                this.sb.append("0");
            }
            this.sb.append(" ");
        }

        private void parseChannel(String answer) {
            this.getFrequency(answer);
            this.getAmplitude(answer);
            this.getOffset(answer);
            this.getDutyCycle(answer);
        }

        @Override
        String process(String answer) {
            int i = answer.indexOf("WVTP");
            int j = answer.indexOf("WVTP", i + 1);
            if (j < 0) {
                j = answer.length();
            }
            this.sb.setLength(0);
            if (i > 0) {
                this.parseChannel(answer.substring(i, j));
                if (j < answer.length()) {
                    this.parseChannel(answer.substring(j));
                }
            }
            return this.sb.toString();
        }
    }
}

