/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.main;

import dk.hkj.main.FontAdjust;
import dk.hkj.main.PopupBase;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class PopupVarDisplay
extends PopupBase {
    private static PopupVarDisplay popupVarDisplay = null;
    private JPanel panel;

    public PopupVarDisplay(Point location) {
        PopupVarDisplay.closeAll();
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent e) {
                if (PopupVarDisplay.this == popupVarDisplay) {
                    PopupVarDisplay.popupVarDisplay = null;
                }
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent arg0) {
                if (PopupVarDisplay.this == popupVarDisplay) {
                    PopupVarDisplay.popupVarDisplay = null;
                }
            }
        });
        popupVarDisplay = this;
        this.setTitle("Var display");
        this.setAlwaysOnTop(true);
        this.definePopupName("VarDisplay", false);
        this.setDefaultCloseOperation(2);
        this.setLayout(new BoxLayout(this.getContentPane(), 2));
        this.panel = new JPanel();
        this.panel.setLayout(new GridBagLayout());
        JScrollPane scrollPane = new JScrollPane(this.panel);
        this.add(scrollPane);
        this.setLocation(location);
        this.setMinimumSize(new Dimension(150, 70));
        this.setVisible(true);
    }

    public static synchronized void closeAll() {
        if (popupVarDisplay != null) {
            popupVarDisplay.setVisible(false);
            popupVarDisplay = null;
        }
    }

    private void update(List<Object> list) {
        this.panel.removeAll();
        this.setPreferredSize(null);
        this.generatePanel(this.panel, list);
        this.pack();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        if (this.getWidth() > screenSize.width || this.getHeight() > screenSize.height * 2 / 3) {
            int w = Math.min(screenSize.width * 2 / 3, this.panel.getWidth() + this.getInsets().left + this.getInsets().right + 25);
            int h = Math.min(screenSize.height * 2 / 3, this.panel.getHeight() + this.getInsets().top + this.getInsets().bottom + 25);
            Dimension dim = new Dimension(w, h);
            this.setPreferredSize(dim);
            this.pack();
        }
    }

    public static boolean isPopupVisible() {
        return popupVarDisplay != null && popupVarDisplay.isVisible();
    }

    public static boolean showVar(List<Object> list) {
        if (PopupVarDisplay.isPopupVisible()) {
            popupVarDisplay.update(list);
            return true;
        }
        popupVarDisplay = null;
        return false;
    }

    private JPanel generatePanel(JPanel panel, List<Object> list) {
        int line = 0;
        for (Object obj : list) {
            GridBagConstraints c;
            if (obj instanceof String) {
                c = new GridBagConstraints();
                c.gridx = 0;
                c.gridy = line;
                c.gridwidth = 100;
                c.insets = new Insets(2, 5, 2, 5);
                c.weightx = 5.0;
                c.weighty = 5.0;
                c.fill = 2;
                c.anchor = 10;
                FontAdjust.FontLabel label = new FontAdjust.FontLabel((String)obj);
                label.setHorizontalAlignment(0);
                label.setToolTipText(Integer.toString(line));
                panel.add((Component)label, c);
            } else if (obj instanceof List) {
                int l = 0;
                for (String s : (List)obj) {
                    c = new GridBagConstraints();
                    c.gridx = l;
                    c.gridy = line;
                    c.gridwidth = 1;
                    c.insets = new Insets(2, 5, 2, 5);
                    c.weightx = 5.0;
                    c.weighty = 5.0;
                    c.fill = 2;
                    c.anchor = 10;
                    FontAdjust.FontLabel label = new FontAdjust.FontLabel(s);
                    label.setToolTipText(String.valueOf(Integer.toString(line)) + ", " + Integer.toString(l));
                    label.setHorizontalAlignment(0);
                    panel.add((Component)label, c);
                    ++l;
                }
            }
            ++line;
        }
        return panel;
    }

    public static synchronized List<String> generateScript() {
        ArrayList<String> list = new ArrayList<String>();
        if (PopupVarDisplay.isPopupVisible()) {
            list.add("#ShowPopupSystem VarDisplay " + popupVarDisplay.generateLocationParams());
        }
        return list;
    }

    public static synchronized void alignGridAll(int pixels) {
        if (PopupVarDisplay.isPopupVisible()) {
            popupVarDisplay.alignGrid(pixels);
        }
    }
}

