/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.main;

import dk.hkj.main.FontAdjust;
import dk.hkj.main.Support;
import dk.hkj.main.ValueFormat;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;

public class PopupValuesHistogram
extends JDialog
implements ActionListener {
    public static PopupValuesHistogram popupValues = null;
    private JPanel mainPanel = null;
    private List<Entry> values = new ArrayList<Entry>();
    private JLabel channelLabel;

    public PopupValuesHistogram(Component frame) {
        PopupValuesHistogram.closeAll();
        popupValues = this;
        this.setDefaultCloseOperation(2);
        this.setDefaultCloseOperation(2);
        this.setAlwaysOnTop(true);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent e) {
                if (PopupValuesHistogram.this == popupValues) {
                    popupValues = null;
                }
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent arg0) {
                if (PopupValuesHistogram.this == popupValues) {
                    popupValues = null;
                }
            }
        });
        this.setTitle("Values histogram");
        this.mainPanel = new FontAdjust.FontPanel();
        ((FontAdjust.FontPanel)this.mainPanel).setScaleWidth(180);
        this.mainPanel.setLayout(new GridBagLayout());
        this.setContentPane(this.mainPanel);
        JPopupMenu popup = new JPopupMenu();
        FontAdjust.FontMenuItem mi = new FontAdjust.FontMenuItem("Copy to clipboard");
        mi.addActionListener(this);
        popup.add(mi);
        this.makePanel();
        ((FontAdjust.FontPanel)this.mainPanel).setScaleHeight(this.values.size() * 20 + 20);
        this.mainPanel.setComponentPopupMenu(popup);
        this.pack();
        this.setVisible(true);
        Point p = frame.getLocationOnScreen();
        p.x += frame.getWidth();
        p.y += 50;
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        if (p.x >= screenSize.width - this.getWidth()) {
            p.x = screenSize.width - this.getWidth();
            p.y += 300;
        }
        this.setLocation(p);
    }

    public static void closeAll() {
        if (popupValues != null) {
            popupValues.setVisible(false);
            popupValues = null;
        }
    }

    private void addLine(int n, String name) {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = n;
        c.anchor = 13;
        c.insets = new Insets(5, 5, 5, 5);
        c.weightx = 1.0;
        c.weighty = 1.0;
        FontAdjust.FontLabel label = new FontAdjust.FontLabel(String.valueOf(name) + ":");
        this.mainPanel.add((Component)label, c);
        label = new FontAdjust.FontLabel("-");
        c.gridx = 2;
        c.gridy = n;
        c.insets = new Insets(5, 5, 5, 5);
        c.anchor = 17;
        c.weightx = 1.0;
        c.weighty = 1.0;
        this.mainPanel.add((Component)label, c);
        this.values.add(new Entry(name, label));
    }

    private void addMarker(int n) {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = n++;
        c.gridwidth = 3;
        c.weightx = 100.0;
        c.fill = 2;
        this.mainPanel.add((Component)new JSeparator(0), c);
    }

    private void addChannel(int n) {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = n++;
        c.gridwidth = 3;
        c.weightx = 100.0;
        c.anchor = 10;
        c.fill = 2;
        this.channelLabel = new FontAdjust.FontLabel();
        this.channelLabel.setHorizontalAlignment(0);
        this.mainPanel.add((Component)this.channelLabel, c);
    }

    private void makePanel() {
        this.values.clear();
        this.mainPanel.removeAll();
        int n = 0;
        this.addChannel(n++);
        this.addLine(n++, "Value");
        this.addMarker(n++);
        this.addLine(n++, "Center");
        this.addLine(n++, "Start");
        this.addLine(n++, "End");
        this.addLine(n++, "Span");
        this.addMarker(n++);
        this.addLine(n++, "Count");
        this.addLine(n++, "Percent");
    }

    public void updataValues(int column, HistogramValues histogramValues) {
        ValueFormat fmt = Support.dataBase.format().get(column);
        this.channelLabel.setText(Support.dataBase.header().getColumnName(column));
        this.values.get(0).update(histogramValues.value, fmt.format, fmt.unit);
        this.values.get(1).update(histogramValues.center, fmt.format, fmt.unit);
        this.values.get(2).update(histogramValues.start, fmt.format, fmt.unit);
        this.values.get(3).update(histogramValues.end, fmt.format, fmt.unit);
        this.values.get(4).update(histogramValues.end - histogramValues.start, fmt.format, fmt.unit);
        this.values.get(5).update(histogramValues.count, ValueFormat.formatInt, "");
        double pct = 100.0 * (double)histogramValues.count / (double)histogramValues.totalCount;
        if (pct > 10.0 || histogramValues.count == 0) {
            this.values.get(6).update(pct, ValueFormat.formatX1, "%");
        } else if (pct > 1.0) {
            this.values.get(6).update(pct, ValueFormat.formatX2, "%");
        } else if (pct > 0.1) {
            this.values.get(6).update(pct, ValueFormat.formatX3, "%");
        } else {
            this.values.get(6).update(pct * 10000.0, ValueFormat.formatX1, "ppm");
        }
    }

    @Override
    public void actionPerformed(ActionEvent ee) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.channelLabel.getText());
        sb.append('\n');
        for (Entry e : this.values) {
            sb.append(e.toString());
            sb.append('\n');
        }
        try {
            StringSelection stringSelection = new StringSelection(sb.toString());
            Clipboard clpbrd = Toolkit.getDefaultToolkit().getSystemClipboard();
            clpbrd.setContents(stringSelection, null);
        }
        catch (Exception exception) {}
    }

    private class Entry {
        String name;
        JLabel label;
        String lastValue = "";

        public Entry(String name, JLabel label) {
            this.name = name;
            this.label = label;
        }

        public void update(Double value, ValueFormat.ValueFormatter format, String unit) {
            this.lastValue = String.valueOf(format.formatDisplay(value)) + " " + unit;
            this.label.setText(this.lastValue);
        }

        public void update(int value, ValueFormat.ValueFormatter format, String unit) {
            this.lastValue = String.valueOf(format.formatDisplay(value)) + " " + unit;
            this.label.setText(this.lastValue);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.name);
            sb.append("\t");
            sb.append(this.lastValue);
            return sb.toString();
        }
    }

    public static class HistogramValues {
        double value;
        double center;
        double start;
        double end;
        int count;
        int totalCount;
    }
}

