/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.main;

import dk.hkj.database.DataRow;
import dk.hkj.main.FontAdjust;
import dk.hkj.main.Support;
import dk.hkj.main.ValueFormat;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;

public class PopupValues
extends JDialog
implements ActionListener {
    private static PopupValues popupValues = null;
    private static int windowWidth = -1;
    private int domainColumn = -1;
    private int timeColumn = 0;
    private JPanel mainPanel = null;
    private List<Entry> values = new ArrayList<Entry>();
    private NumberFormat nf = null;
    private boolean useTimeFormat = false;
    private int column = 1;
    private double position = 0.0;
    private Double marker = null;
    private static Set<String> forceAbsoluteList = new HashSet<String>();
    private List<String> digitalLines = new ArrayList<String>();

    public PopupValues(Component frame, int domainColumn) {
        PopupValues.closeAll();
        popupValues = this;
        this.domainColumn = domainColumn;
        this.setDefaultCloseOperation(2);
        this.timeColumn = Support.dataBase.header().getIndex("time");
        this.setDefaultCloseOperation(2);
        this.nf = NumberFormat.getNumberInstance(Locale.ENGLISH);
        this.nf.setGroupingUsed(false);
        this.nf.setMinimumFractionDigits(0);
        this.nf.setMaximumFractionDigits(3);
        this.setAlwaysOnTop(true);
        this.useTimeFormat = Support.dataBase.header().isTimeColumn(this.timeColumn);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent e) {
                if (PopupValues.this == popupValues) {
                    PopupValues.popupValues = null;
                }
            }

            @Override
            public void componentResized(ComponentEvent e) {
                windowWidth = popupValues.getWidth();
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent arg0) {
                if (PopupValues.this == popupValues) {
                    PopupValues.popupValues = null;
                }
            }
        });
        this.setTitle("Values from chart");
        this.mainPanel = new FontAdjust.FontPanel();
        ((FontAdjust.FontPanel)this.mainPanel).setScaleWidth(Support.dataBase.header().getColumnName(domainColumn).equals("dateTime") ? 240 : 200);
        this.mainPanel.setLayout(new GridBagLayout());
        this.setContentPane(this.mainPanel);
        JPopupMenu popup = new JPopupMenu();
        FontAdjust.FontMenuItem mi = new FontAdjust.FontMenuItem("Copy to clipboard");
        mi.addActionListener(this);
        popup.add(mi);
        this.makePanel();
        ((FontAdjust.FontPanel)this.mainPanel).setScaleHeight(this.values.size() * 20 + 20);
        this.mainPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent arg0) {
                if (arg0.getButton() == 1) {
                    int y = arg0.getY();
                    for (Entry e : PopupValues.this.values) {
                        if (y <= e.marker1.getY() || y >= e.marker1.getY() + e.marker1.getHeight()) continue;
                        e.setForceAbsolute(!e.isForceAbsolute());
                        PopupValues.this.updateForm();
                    }
                }
            }
        });
        this.mainPanel.setComponentPopupMenu(popup);
        this.pack();
        if (windowWidth > 0) {
            Dimension d = new Dimension(windowWidth, popupValues.getHeight());
            popupValues.setPreferredSize(d);
            popupValues.setSize(d);
        }
        this.setVisible(true);
        Point p = frame.getLocationOnScreen();
        p.x += frame.getWidth();
        p.y += 50;
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        if (p.x >= screenSize.width - this.getWidth()) {
            p.x = screenSize.width - this.getWidth();
            p.y += 300;
        }
        this.setLocation(p);
    }

    public static void closeAll() {
        if (popupValues != null) {
            popupValues.setVisible(false);
            popupValues = null;
        }
    }

    public boolean updataValues(int column, double position, Double marker) {
        this.column = column;
        this.position = position;
        this.marker = marker;
        return this.updateForm();
    }

    public boolean updateForm() {
        int mpos;
        int pos = Support.dataBase.findSampleIndex(this.column, this.position);
        int n = mpos = this.marker != null ? Support.dataBase.findSampleIndex(this.column, (double)this.marker) : -1;
        if (pos < 0 || pos >= Support.dataBase.rows()) {
            return this.isVisible();
        }
        DataRow dataRow = Support.dataBase.getRow(pos);
        DataRow markerRow = mpos < 0 ? null : Support.dataBase.getRow(mpos);
        int n2 = 0;
        for (Entry e : this.values) {
            double v = dataRow.getValue(e.column);
            if (markerRow == null || e.isForceAbsolute()) {
                e.setMarker(false);
            } else {
                v -= markerRow.getValue(e.column);
                e.setMarker(true);
            }
            String s = "";
            if (this.useTimeFormat) {
                switch (n2) {
                    case 0: {
                        s = Support.toHMS(v);
                        break;
                    }
                    case 1: {
                        s = this.nf.format(v);
                        break;
                    }
                    case 2: {
                        s = this.nf.format(v / 60.0);
                        break;
                    }
                    case 3: {
                        if (Support.dataBase.header().getColumnName(this.domainColumn).equals("dateTime")) {
                            v = dataRow.getValue(this.domainColumn);
                            s = new ValueFormat.ValueFormatterDateTime().formatDisplay(v);
                            e.setMarker(false);
                            break;
                        }
                        s = this.nf.format(v / 3600.0);
                    }
                }
            } else if (n2 == 0) {
                s = Integer.toString((int)v);
            }
            if (s.length() == 0) {
                s = e.fmt.format.formatDisplay(v);
                if (e.bits.size() > 0) {
                    StringBuilder sb = new StringBuilder();
                    String[] stringArray = s.split("[ ]");
                    int n3 = stringArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String ss = stringArray[n4];
                        if (e.bits.contains(ss)) {
                            sb.append(ss);
                            sb.append(" ");
                        }
                        ++n4;
                    }
                    s = sb.toString().trim();
                }
            }
            e.lastDisplay = s;
            e.label.setText(String.valueOf(s) + (e.unit.length() > 0 ? " " + e.unit.replace("_", " ") : ""));
            ++n2;
        }
        return this.isVisible();
    }

    private void addLine(int n, String name, int column) {
        ValueFormat fmt = Support.dataBase.format().get(column);
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = n;
        c.anchor = 13;
        c.insets = new Insets(5, 5, 5, 5);
        c.weightx = 1.0;
        c.weighty = 1.0;
        FontAdjust.FontLabel label = new FontAdjust.FontLabel(String.valueOf(name) + ":");
        this.mainPanel.add((Component)label, c);
        label = new FontAdjust.FontLabel("-");
        c.gridx = 2;
        c.gridy = n;
        c.insets = new Insets(5, 5, 5, 5);
        c.anchor = 17;
        c.weightx = 1.0;
        c.weighty = 1.0;
        this.mainPanel.add((Component)label, c);
        String u = fmt.unit;
        if (this.useTimeFormat) {
            switch (n) {
                case 0: {
                    u = "";
                    break;
                }
                case 1: {
                    u = "s";
                    break;
                }
                case 2: {
                    u = "m";
                    break;
                }
                case 3: {
                    if (Support.dataBase.header().getColumnName(this.domainColumn).equals("dateTime")) {
                        u = "";
                        break;
                    }
                    u = "h";
                }
            }
        } else if (n == 0) {
            u = "";
        }
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = n;
        c.anchor = 13;
        c.fill = 3;
        c.weightx = 0.0;
        c.weighty = 0.0;
        JPanel p1 = new JPanel();
        p1.setBackground(Color.MAGENTA);
        p1.setBorder(null);
        p1.setMinimumSize(new Dimension(4, 22));
        this.mainPanel.add((Component)p1, c);
        c = new GridBagConstraints();
        c.gridx = 3;
        c.gridy = n;
        c.anchor = 17;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 3;
        JPanel p2 = new JPanel();
        p2.setBackground(Color.MAGENTA);
        p2.setBorder(null);
        p2.setMinimumSize(new Dimension(4, 22));
        this.mainPanel.add((Component)p2, c);
        this.values.add(new Entry(name, label, p1, p2, column, fmt, u));
    }

    private int addEntry(int n, String name) {
        if (!Support.dataBase.header().isDigital(name)) {
            this.addLine(n++, name, Support.dataBase.header().getIndex(name));
        } else {
            int i = name.lastIndexOf(32);
            String m = name.substring(0, i).trim();
            if (!this.digitalLines.contains(m)) {
                this.addLine(n++, m, Support.dataBase.header().getIndex(m));
                this.digitalLines.add(m);
            }
            for (Entry e : this.values) {
                if (!e.name.equals(m)) continue;
                e.bits.add(name.substring(i + 1).trim());
            }
        }
        return n;
    }

    private void makePanel() {
        this.values.clear();
        this.mainPanel.removeAll();
        int n = 0;
        if (this.useTimeFormat) {
            this.addLine(n++, "Time", this.timeColumn);
            this.addLine(n++, "Seconds", this.timeColumn);
            this.addLine(n++, "Minutes", this.timeColumn);
            if (Support.dataBase.header().getColumnName(this.domainColumn).equals("dateTime")) {
                this.addLine(n++, "Date", this.timeColumn);
            } else {
                this.addLine(n++, "Hours", this.timeColumn);
            }
        } else {
            this.addLine(n++, "Sample", this.timeColumn);
        }
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = n++;
        c.gridwidth = 3;
        c.weightx = 100.0;
        c.fill = 2;
        this.mainPanel.add((Component)new JSeparator(0), c);
        this.digitalLines.clear();
        if (!(Support.paneChart.lastDomainColumn.equals("time") || Support.paneChart.lastDomainColumn.equals("index") || Support.paneChart.lastDomainColumn.equals("minutes") || Support.paneChart.lastDomainColumn.equals("dateTime") || Support.dataBase.header().getIndex(Support.paneChart.lastDomainColumn) < 0)) {
            n = this.addEntry(n, Support.paneChart.lastDomainColumn);
            c.gridy = n++;
            this.mainPanel.add((Component)new JSeparator(0), c);
        }
        for (String name : Support.paneChart.checkedColumns) {
            if (name.equals(Support.paneChart.lastDomainColumn)) continue;
            n = this.addEntry(n, name);
        }
    }

    @Override
    public void actionPerformed(ActionEvent ee) {
        StringBuilder sb = new StringBuilder();
        for (Entry e : this.values) {
            sb.append(e.name);
            sb.append('\t');
            sb.append(e.lastDisplay.replace('.', DecimalFormatSymbols.getInstance().getDecimalSeparator()));
            sb.append('\t');
            sb.append(e.unit);
            sb.append('\n');
        }
        try {
            StringSelection stringSelection = new StringSelection(sb.toString());
            Clipboard clpbrd = Toolkit.getDefaultToolkit().getSystemClipboard();
            clpbrd.setContents(stringSelection, null);
        }
        catch (Exception exception) {}
    }

    private class Entry {
        String name;
        JLabel label;
        JPanel marker1 = null;
        JPanel marker2 = null;
        int column;
        String unit;
        String lastDisplay;
        ValueFormat fmt;
        Set<String> bits = new HashSet<String>();

        public Entry(String name, JLabel label, JPanel marker1, JPanel marker2, int column, ValueFormat fmt, String unit) {
            this.name = name;
            this.label = label;
            this.marker1 = marker1;
            this.marker2 = marker2;
            this.column = column;
            this.fmt = fmt;
            this.unit = unit;
        }

        private void setForceAbsolute(boolean on) {
            if (on && !this.name.equals("dateTime")) {
                forceAbsoluteList.add(this.name);
            } else {
                forceAbsoluteList.remove(this.name);
            }
        }

        private boolean isForceAbsolute() {
            return forceAbsoluteList.contains(this.name);
        }

        public void setMarker(boolean on) {
            this.marker1.setVisible(on);
            this.marker2.setVisible(on);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.name);
            if (this.bits.size() > 0) {
                sb.append("(");
                for (String s : this.bits) {
                    sb.append(s);
                    sb.append(" ");
                }
                sb.append(")");
            }
            sb.append(" ");
            sb.append(this.unit);
            return sb.toString();
        }
    }
}

