/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.main;

import dk.hkj.main.FontAdjust;
import dk.hkj.main.Indicator;
import dk.hkj.main.InterfaceThreads;
import dk.hkj.main.PopupBase;
import dk.hkj.main.Support;
import dk.hkj.main.ValueFormat;
import dk.hkj.util.MySwingUtil;
import dk.hkj.util.StringUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.Timer;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

public class PopupTimerCounter
extends PopupBase
implements ActionListener,
FocusListener {
    private static String StaticTable = "Table: ";
    private static PopupTimerCounter popupTimerCounter = null;
    private String selectedChannelName = "";
    protected ValueFormat fmt = new ValueFormat("??", "", ValueFormat.formatD2);
    private JComboBox<String> channelComboBox;
    private JTextField thresholdTextField;
    private JTextField toleranceTextField;
    private JCheckBox onIsLowCheckbox;
    private JCheckBox tableCheckbox;
    private JLabel currentValueLabel;
    private JLabel currentTimeLabel;
    private Indicator onIndicator;
    private JTable table;
    private JTable footerTable;
    private JPopupMenu popupMenu;
    private Timer timer;
    private double threshold = 1.0;
    private double tolerance = 0.0;
    private boolean onIsLow = false;
    private boolean useTableData = false;
    private boolean currentState = false;
    private double sumValue = 0.0;
    private long sumTime = 0L;
    private long checkTime = 0L;
    private long startTime = 0L;
    private int count = 0;
    private int tableEntry = 0;
    private double onsum;
    private double offsum;
    private double onsumTime;
    private double offsumTime;
    private double sumCount;
    private Entry currentEntry = new Entry();
    private Entry footerEntry = new Entry();
    private NumberFormat nf1 = NumberFormat.getNumberInstance(Locale.US);
    private NumberFormat nf1local = NumberFormat.getNumberInstance();
    private MyTableModel dataTableModel = new MyTableModel(false);
    private MyTableModel footerTableModel = new MyTableModel(true);

    public static void set(String channel, double threshold, double tol, Boolean onIsLowCheckbox, Boolean useTable) {
        PopupTimerCounter.getPopup();
        if (useTable != null && useTable != PopupTimerCounter.popupTimerCounter.useTableData) {
            PopupTimerCounter.popupTimerCounter.useTableData = useTable;
            popupTimerCounter.fillChannels();
        }
        if (channel != null && channel.length() > 0) {
            popupTimerCounter.setChannel(channel);
        }
        if (!Double.isNaN(threshold)) {
            PopupTimerCounter.popupTimerCounter.threshold = threshold;
        }
        if (!Double.isNaN(tol)) {
            PopupTimerCounter.popupTimerCounter.tolerance = tol;
        }
        if (onIsLowCheckbox != null) {
            PopupTimerCounter.popupTimerCounter.onIsLow = onIsLowCheckbox;
        }
        popupTimerCounter.fillTextFields();
        popupTimerCounter.reset();
    }

    private String generateParams() {
        StringBuilder sb = new StringBuilder();
        sb.append(Support.conditionalQuote(this.selectedChannelName));
        sb.append(' ');
        sb.append(StringUtil.formatDoubleEE(this.threshold, false));
        sb.append(' ');
        sb.append(StringUtil.formatDoubleEE(this.tolerance, false));
        sb.append(' ');
        sb.append(this.onIsLow ? 1 : 0);
        sb.append(' ');
        sb.append(this.useTableData ? 1 : 0);
        return sb.toString();
    }

    private PopupTimerCounter() {
        this.setPreferredSize(new Dimension(600, 300));
        popupTimerCounter = this;
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent e) {
                if (popupTimerCounter == PopupTimerCounter.this) {
                    if (PopupTimerCounter.this.timer != null) {
                        PopupTimerCounter.this.timer.stop();
                        PopupTimerCounter.this.timer = null;
                    }
                    Support.math.removeDomain("TimerCounter");
                    PopupTimerCounter.popupTimerCounter = null;
                }
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                if (popupTimerCounter == PopupTimerCounter.this) {
                    if (PopupTimerCounter.this.timer != null) {
                        PopupTimerCounter.this.timer.stop();
                        PopupTimerCounter.this.timer = null;
                    }
                    Support.math.removeDomain("TimerCounter");
                    PopupTimerCounter.popupTimerCounter = null;
                }
            }
        });
        this.nf1.setMaximumFractionDigits(1);
        this.nf1.setMinimumFractionDigits(1);
        this.nf1.setGroupingUsed(false);
        this.nf1local.setMaximumFractionDigits(1);
        this.nf1local.setMinimumFractionDigits(1);
        this.nf1local.setGroupingUsed(false);
        this.popupMenu = new JPopupMenu();
        this.popupMenu.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuCanceled(PopupMenuEvent arg0) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent arg0) {
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent arg0) {
                PopupTimerCounter.this.makePopupMenu();
            }
        });
        this.setTitle("Timer Counter");
        this.setDefaultCloseOperation(2);
        this.definePopupName("TimerCounter", true);
        this.getLayeredPane().setComponentPopupMenu(this.popupMenu);
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = null;
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 5;
        c.anchor = 11;
        c.fill = 2;
        c.insets = new Insets(2, 5, 2, 5);
        this.currentValueLabel = new FontAdjust.FontLabel();
        ((FontAdjust.FontLabel)this.currentValueLabel).setLargeFont(true);
        this.currentValueLabel.setHorizontalAlignment(0);
        this.currentValueLabel.setInheritsPopupMenu(true);
        this.currentValueLabel.setFocusable(true);
        this.currentValueLabel.requestFocusInWindow();
        this.currentValueLabel.requestFocus();
        this.add((Component)this.currentValueLabel, c);
        c = new GridBagConstraints();
        c.gridx = 5;
        c.gridy = 0;
        c.gridwidth = 6;
        c.anchor = 11;
        c.fill = 2;
        c.insets = new Insets(2, 5, 2, 5);
        this.currentTimeLabel = new FontAdjust.FontLabel();
        ((FontAdjust.FontLabel)this.currentTimeLabel).setLargeFont(true);
        this.currentTimeLabel.setHorizontalAlignment(0);
        this.currentTimeLabel.setInheritsPopupMenu(true);
        this.currentTimeLabel.setFocusable(true);
        this.currentTimeLabel.requestFocusInWindow();
        this.currentTimeLabel.requestFocus();
        this.add((Component)this.currentTimeLabel, c);
        c = new GridBagConstraints();
        c.gridx = 6;
        c.gridy = 0;
        c.gridwidth = 1;
        c.anchor = 13;
        c.insets = new Insets(2, 5, 2, 5);
        this.onIndicator = new Indicator();
        this.onIndicator.setToolTipText("On when state is on");
        this.add((Component)this.onIndicator, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 7;
        c.anchor = 17;
        c.fill = 1;
        c.weightx = 1.0;
        c.insets = new Insets(2, 5, 2, 5);
        this.channelComboBox = new FontAdjust.FontComboBox<String>();
        this.channelComboBox.addActionListener(this);
        this.channelComboBox.setActionCommand("channel");
        this.channelComboBox.setMaximumRowCount(20);
        this.fillChannels();
        if (this.channelComboBox.getItemCount() > 0) {
            this.channelComboBox.setSelectedIndex(0);
        }
        this.add(this.channelComboBox, c);
        this.channelComboBox.setInheritsPopupMenu(true);
        Dimension dim = new Dimension(50, 20);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 2;
        c.weightx = 1.0;
        c.anchor = 13;
        c.insets = new Insets(2, 5, 2, 5);
        this.add((Component)new FontAdjust.FontLabel("Threshold: "), c);
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 2;
        c.anchor = 17;
        c.insets = new Insets(2, 5, 2, 5);
        this.thresholdTextField = new FontAdjust.FontTextField(6);
        this.thresholdTextField.setMinimumSize(dim);
        this.thresholdTextField.setToolTipText("Level to change between on/off");
        this.thresholdTextField.addActionListener(this);
        this.thresholdTextField.addFocusListener(this);
        this.thresholdTextField.setInheritsPopupMenu(true);
        this.add((Component)this.thresholdTextField, c);
        c = new GridBagConstraints();
        c.gridx = 2;
        c.gridy = 2;
        c.anchor = 13;
        c.weightx = 1.0;
        c.insets = new Insets(2, 5, 2, 5);
        this.add((Component)new FontAdjust.FontLabel("Tol: "), c);
        c = new GridBagConstraints();
        c.gridx = 3;
        c.gridy = 2;
        c.weightx = 1.0;
        c.anchor = 17;
        c.insets = new Insets(2, 5, 2, 5);
        this.toleranceTextField = new FontAdjust.FontTextField(6);
        this.toleranceTextField.setMinimumSize(dim);
        this.toleranceTextField.setToolTipText("Tolerance on threshold in value");
        this.toleranceTextField.addActionListener(this);
        this.toleranceTextField.addFocusListener(this);
        this.toleranceTextField.setInheritsPopupMenu(true);
        this.add((Component)this.toleranceTextField, c);
        c = new GridBagConstraints();
        c.gridx = 4;
        c.gridy = 2;
        c.weightx = 1.0;
        c.anchor = 17;
        c.insets = new Insets(2, 5, 2, 5);
        this.onIsLowCheckbox = new FontAdjust.FontCheckBox("On is low");
        this.onIsLowCheckbox.setToolTipText("When checked values below threshold is assumed to be on");
        this.onIsLowCheckbox.addActionListener(this);
        this.onIsLowCheckbox.setInheritsPopupMenu(true);
        this.add((Component)this.onIsLowCheckbox, c);
        c = new GridBagConstraints();
        c.gridx = 5;
        c.gridy = 2;
        c.weightx = 1.0;
        c.anchor = 17;
        c.insets = new Insets(2, 5, 2, 5);
        this.tableCheckbox = new FontAdjust.FontCheckBox("Use table");
        this.tableCheckbox.setToolTipText("Use table for data, this makes it possible to load data into the table and analyze them");
        this.tableCheckbox.setActionCommand("table");
        this.tableCheckbox.addActionListener(this);
        this.tableCheckbox.setInheritsPopupMenu(true);
        this.add((Component)this.tableCheckbox, c);
        c = new GridBagConstraints();
        c.gridx = 6;
        c.gridwidth = 1;
        c.gridy = 2;
        c.weightx = 1.0;
        c.anchor = 10;
        c.insets = new Insets(2, 5, 2, 5);
        FontAdjust.FontButton resetButton = new FontAdjust.FontButton("Reset");
        resetButton.setActionCommand("reset");
        resetButton.addActionListener(this);
        this.add((Component)resetButton, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 3;
        c.gridwidth = 7;
        c.weightx = 10.0;
        c.weighty = 10.0;
        c.anchor = 18;
        c.fill = 1;
        c.insets = new Insets(2, 5, 2, 5);
        this.table = new FontAdjust.FontTable(){

            @Override
            public Component prepareRenderer(TableCellRenderer renderer, int row, int col) {
                JComponent comp = (JComponent)super.prepareRenderer(renderer, row, col);
                boolean sel = comp.getBackground().equals(Support.colorScheme.selectedCellbackground);
                if (!sel) {
                    comp.setBackground((this.getRowCount() - row) % 4 == 0 ? Support.colorScheme.tableGridAlternateBackground : Support.colorScheme.textBackground);
                }
                if (comp instanceof JLabel) {
                    ((JLabel)comp).setHorizontalAlignment(0);
                }
                return comp;
            }
        };
        this.table.setModel(this.dataTableModel);
        this.table.setComponentPopupMenu(this.popupMenu);
        this.table.getTableHeader().setComponentPopupMenu(this.popupMenu);
        this.table.getTableHeader().setReorderingAllowed(false);
        JScrollPane sp = new JScrollPane(this.table);
        sp.setInheritsPopupMenu(true);
        this.add((Component)sp, c);
        this.footerTable = new FontAdjust.FontTable(){

            @Override
            public Component prepareRenderer(TableCellRenderer renderer, int row, int col) {
                JComponent comp = (JComponent)super.prepareRenderer(renderer, row, col);
                if (comp instanceof JLabel) {
                    ((JLabel)comp).setHorizontalAlignment(0);
                }
                return comp;
            }
        };
        this.footerTable.setRowSelectionAllowed(false);
        this.footerTable.setColumnSelectionAllowed(false);
        this.footerTable.setColumnModel(this.table.getColumnModel());
        this.footerTableModel.entries.add(this.footerEntry);
        this.footerTable.setModel(this.footerTableModel);
        this.footerTable.setComponentPopupMenu(this.popupMenu);
        this.footerTable.getTableHeader().setComponentPopupMenu(this.popupMenu);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 4;
        c.gridwidth = 7;
        c.weightx = 10.0;
        c.weighty = 0.0;
        c.anchor = 18;
        c.fill = 1;
        c.insets = new Insets(2, 5, 2, 5);
        this.add((Component)this.footerTable, c);
        this.fillTextFields();
        this.checkTime = this.startTime = System.currentTimeMillis();
        this.timer = new Timer(200, this);
        this.timer.setActionCommand("timer");
        this.timer.start();
        MySwingUtil.addKeyListenerAll(this, new KeyListener(){

            @Override
            public void keyPressed(KeyEvent arg0) {
            }

            @Override
            public void keyReleased(KeyEvent arg0) {
            }

            @Override
            public void keyTyped(KeyEvent arg0) {
                if (arg0.getKeyChar() == ' ') {
                    PopupTimerCounter.this.dataTableModel.fireInsert();
                }
            }
        });
        this.pack();
    }

    private void makePopupMenu() {
        this.popupMenu.removeAll();
        FontAdjust.FontMenu m = new FontAdjust.FontMenu("Minimum");
        this.popupMenu.add(m);
        FontAdjust.FontMenuItem mi = new FontAdjust.FontMenuItem("Off time");
        mi.setActionCommand("minOffTime");
        mi.addActionListener(this);
        m.add(mi);
        mi = new FontAdjust.FontMenuItem("On time");
        mi.setActionCommand("minOnTime");
        mi.addActionListener(this);
        m.add(mi);
        mi = new FontAdjust.FontMenuItem("Idle time");
        mi.setActionCommand("minIdleTime");
        mi.addActionListener(this);
        m.add(mi);
        mi = new FontAdjust.FontMenuItem("Off value");
        mi.setActionCommand("minOffValue");
        mi.addActionListener(this);
        m.add(mi);
        mi = new FontAdjust.FontMenuItem("On value");
        mi.setActionCommand("minOnValue");
        mi.addActionListener(this);
        m.add(mi);
        mi = new FontAdjust.FontMenuItem("Duty cycle");
        mi.setActionCommand("minDutyCycle");
        mi.addActionListener(this);
        m.add(mi);
        m = new FontAdjust.FontMenu("Maximum");
        this.popupMenu.add(m);
        mi = new FontAdjust.FontMenuItem("Off time");
        mi.setActionCommand("maxOffTime");
        mi.addActionListener(this);
        m.add(mi);
        mi = new FontAdjust.FontMenuItem("On time");
        mi.setActionCommand("maxOnTime");
        mi.addActionListener(this);
        m.add(mi);
        mi = new FontAdjust.FontMenuItem("Idle time");
        mi.setActionCommand("maxIdleTime");
        mi.addActionListener(this);
        m.add(mi);
        mi = new FontAdjust.FontMenuItem("Off value");
        mi.setActionCommand("maxOffValue");
        mi.addActionListener(this);
        m.add(mi);
        mi = new FontAdjust.FontMenuItem("On value");
        mi.setActionCommand("maxOnValue");
        mi.addActionListener(this);
        m.add(mi);
        mi = new FontAdjust.FontMenuItem("Duty cycle");
        mi.setActionCommand("maxDutyCycle");
        mi.addActionListener(this);
        m.add(mi);
        mi = new FontAdjust.FontMenuItem("Table to clipboard");
        mi.setActionCommand("numclip");
        mi.addActionListener(this);
        this.popupMenu.add(mi);
        mi = new FontAdjust.FontMenuItem("Summary to clipboard");
        mi.setActionCommand("sumclip");
        mi.addActionListener(this);
        this.popupMenu.add(mi);
    }

    private void parseTextFields() {
        double a = StringUtil.parseDoubleEE(this.toleranceTextField.getText());
        if (!Double.isNaN(a)) {
            this.tolerance = a;
        }
        if (!Double.isNaN(a = StringUtil.parseDoubleEE(this.thresholdTextField.getText()))) {
            this.threshold = a;
        }
        this.onIsLow = this.onIsLowCheckbox.isSelected();
    }

    private void fillTextFields() {
        if (this.selectedChannelName != null) {
            this.channelComboBox.setSelectedItem(this.useTableData ? String.valueOf(StaticTable) + this.selectedChannelName : this.selectedChannelName);
        }
        this.toleranceTextField.setText(StringUtil.formatDoubleEE(this.tolerance, false));
        this.thresholdTextField.setText(StringUtil.formatDoubleEE(this.threshold, false));
        this.onIsLowCheckbox.setSelected(this.onIsLow);
        this.tableCheckbox.setSelected(this.useTableData);
    }

    protected void toClipboard(String data) {
        Clipboard clpbrd = Toolkit.getDefaultToolkit().getSystemClipboard();
        StringSelection stringSelection = new StringSelection(data);
        clpbrd.setContents(stringSelection, null);
    }

    private void reset() {
        this.checkTime = this.startTime = System.currentTimeMillis();
        this.currentState = false;
        this.sumValue = 0.0;
        this.sumTime = 0L;
        this.count = 0;
        this.currentEntry = new Entry();
        this.footerEntry = new Entry();
        this.footerTableModel.entries.clear();
        this.footerTableModel.entries.add(this.footerEntry);
        this.tableEntry = 0;
        this.onsum = 0.0;
        this.offsum = 0.0;
        this.onsumTime = 0.0;
        this.offsumTime = 0.0;
        this.sumCount = 0.0;
        Support.math.resetCalc("TimerCounter");
        this.dataTableModel.entries.clear();
        this.dataTableModel.fireDelete();
        this.footerTableModel.fireUpdate();
    }

    private void setChannel(String channel) {
        this.selectedChannelName = channel;
        if (channel == null) {
            return;
        }
        if (channel.startsWith(StaticTable)) {
            this.selectedChannelName = this.selectedChannelName.substring(StaticTable.length());
        }
        this.fmt = this.useTableData ? Support.dataBase.format().get(Support.dataBase.header().getIndex(this.selectedChannelName)) : InterfaceThreads.findValueFormat(this.selectedChannelName);
        this.reset();
    }

    private void numClip() {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        sb.append("Index");
        sb.append("\t");
        sb.append("Time");
        sb.append("\t");
        sb.append("Off time");
        sb.append("\t");
        sb.append("On time");
        sb.append("\t");
        sb.append("Idle time");
        sb.append("\t");
        sb.append("Off value");
        sb.append("\t");
        sb.append("On Value");
        sb.append("\t");
        sb.append("Duty cycle");
        sb.append("\n");
        for (Entry e : this.dataTableModel.entries) {
            sb.append(i++);
            sb.append("\t");
            sb.append(this.nf1local.format((double)e.timestamp / 1000.0));
            sb.append("\t");
            sb.append(this.nf1local.format((double)e.offTime / 1000.0));
            sb.append("\t");
            sb.append(this.nf1local.format((double)e.onTime / 1000.0));
            sb.append("\t");
            sb.append(this.nf1local.format((double)e.idleTime / 1000.0));
            sb.append("\t");
            sb.append(this.fmt.format.formatDisplayLocal(e.offValue));
            sb.append("\t");
            sb.append(this.fmt.format.formatDisplayLocal(e.onValue));
            sb.append("\t");
            sb.append(this.nf1local.format(e.dutyCycle()));
            sb.append("\n");
        }
        this.toClipboard(sb.toString());
    }

    private void summaryClip() {
        StringBuilder sb = new StringBuilder();
        int n = this.dataTableModel.getRowCount() - 1;
        Entry e = (Entry)this.footerTableModel.entries.get(0);
        String u = this.fmt.unit;
        int i = u.indexOf(47);
        if (i >= 0) {
            u = String.valueOf(u.substring(0, i - 1)) + "h" + u.substring(i);
        } else if (!u.isEmpty()) {
            u = String.valueOf(u) + 'h';
        }
        sb.append("Entries:\t" + n + "\n");
        sb.append("Total time:\t" + this.nf1local.format((double)e.timestamp / 1000.0) + "s\n");
        sb.append("Total off time:\t" + this.nf1local.format((double)e.offTime / 1000.0) + "s\n");
        sb.append("Total on time:\t" + this.nf1local.format((double)e.onTime / 1000.0) + "s\n");
        sb.append("Total idle time:\t" + this.nf1local.format((double)e.idleTime / 1000.0) + "s\n");
        sb.append("Avg. off time:\t" + this.nf1local.format((double)e.offTime / 1000.0 / (double)n) + "s\n");
        sb.append("Avg. on time:\t" + this.nf1local.format((double)e.onTime / 1000.0 / (double)n) + "s\n");
        sb.append("Avg. idle time:\t" + this.nf1local.format((double)e.idleTime / 1000.0 / (double)n) + "s\n");
        sb.append("Avg. cycle time:\t" + this.nf1local.format((double)(e.onTime + e.offTime + e.idleTime) / 1000.0 / (double)n) + "s\n");
        sb.append("Cycles over time:\t" + this.nf1local.format(3600000.0 * (double)n / (double)(e.onTime + e.offTime + e.idleTime)) + "/h\n");
        sb.append("Avg. off value:\t" + this.fmt.format.formatDisplayLocal(e.offValue) + this.fmt.unit + "\n");
        sb.append("Avg. on value:\t" + this.fmt.format.formatDisplayLocal(e.onValue) + this.fmt.unit + "\n");
        sb.append("Time sum off value:\t" + this.fmt.format.formatDisplayLocal(this.offsumTime / 3600000.0) + u + "\n");
        sb.append("Time sum on value:\t" + this.fmt.format.formatDisplayLocal(this.onsumTime / 3600000.0) + u + "\n");
        sb.append("Duty cycle:\t" + this.nf1local.format(e.dutyCycle()) + "%\n");
        this.toClipboard(sb.toString());
    }

    @Override
    public void actionPerformed(ActionEvent cmd) {
        if (cmd.getActionCommand().equals("channel")) {
            this.setChannel((String)this.channelComboBox.getSelectedItem());
        } else if (cmd.getActionCommand().equals("timer")) {
            this.timerUpdate();
        } else if (cmd.getActionCommand().equals("reset")) {
            this.reset();
        } else if (cmd.getActionCommand().equals("numclip")) {
            this.numClip();
        } else if (cmd.getActionCommand().equals("sumclip")) {
            this.summaryClip();
        } else if (cmd.getActionCommand().equals("minOffTime")) {
            double v = Double.MAX_VALUE;
            int index = -1;
            int i = 1;
            while (i < this.dataTableModel.entries.size()) {
                if ((double)((Entry)((MyTableModel)this.dataTableModel).entries.get((int)i)).offTime < v) {
                    v = ((Entry)((MyTableModel)this.dataTableModel).entries.get((int)i)).offTime;
                    index = i;
                }
                if (index > 0) {
                    this.table.getSelectionModel().setSelectionInterval(index, index);
                    this.table.scrollRectToVisible(new Rectangle(this.table.getCellRect(index, 0, true)));
                }
                ++i;
            }
        } else if (cmd.getActionCommand().equals("minOnTime")) {
            double v = Double.MAX_VALUE;
            int index = -1;
            int i = 1;
            while (i < this.dataTableModel.entries.size()) {
                if ((double)((Entry)((MyTableModel)this.dataTableModel).entries.get((int)i)).onTime < v) {
                    v = ((Entry)((MyTableModel)this.dataTableModel).entries.get((int)i)).onTime;
                    index = i;
                }
                if (index > 0) {
                    this.table.getSelectionModel().setSelectionInterval(index, index);
                    this.table.scrollRectToVisible(new Rectangle(this.table.getCellRect(index, 0, true)));
                }
                ++i;
            }
        } else if (cmd.getActionCommand().equals("minIdleTime")) {
            double v = Double.MAX_VALUE;
            int index = -1;
            int i = 1;
            while (i < this.dataTableModel.entries.size()) {
                if ((double)((Entry)((MyTableModel)this.dataTableModel).entries.get((int)i)).idleTime < v) {
                    v = ((Entry)((MyTableModel)this.dataTableModel).entries.get((int)i)).idleTime;
                    index = i;
                }
                if (index > 0) {
                    this.table.getSelectionModel().setSelectionInterval(index, index);
                    this.table.scrollRectToVisible(new Rectangle(this.table.getCellRect(index, 0, true)));
                }
                ++i;
            }
        } else if (cmd.getActionCommand().equals("minOffValue")) {
            double v = Double.MAX_VALUE;
            int index = -1;
            int i = 1;
            while (i < this.dataTableModel.entries.size()) {
                if (((Entry)((MyTableModel)this.dataTableModel).entries.get((int)i)).offValue < v) {
                    v = ((Entry)((MyTableModel)this.dataTableModel).entries.get((int)i)).offValue;
                    index = i;
                }
                if (index > 0) {
                    this.table.getSelectionModel().setSelectionInterval(index, index);
                    this.table.scrollRectToVisible(new Rectangle(this.table.getCellRect(index, 0, true)));
                }
                ++i;
            }
        } else if (cmd.getActionCommand().equals("minOnValue")) {
            double v = Double.MAX_VALUE;
            int index = -1;
            int i = 1;
            while (i < this.dataTableModel.entries.size()) {
                if (((Entry)((MyTableModel)this.dataTableModel).entries.get((int)i)).onValue < v) {
                    v = ((Entry)((MyTableModel)this.dataTableModel).entries.get((int)i)).onValue;
                    index = i;
                }
                if (index > 0) {
                    this.table.getSelectionModel().setSelectionInterval(index, index);
                    this.table.scrollRectToVisible(new Rectangle(this.table.getCellRect(index, 0, true)));
                }
                ++i;
            }
        } else if (cmd.getActionCommand().equals("minDutyCycle")) {
            double v = Double.MAX_VALUE;
            int index = -1;
            int i = 1;
            while (i < this.dataTableModel.entries.size()) {
                if (((Entry)this.dataTableModel.entries.get(i)).dutyCycle() < v) {
                    v = ((Entry)this.dataTableModel.entries.get(i)).dutyCycle();
                    index = i;
                }
                if (index > 0) {
                    this.table.getSelectionModel().setSelectionInterval(index, index);
                    this.table.scrollRectToVisible(new Rectangle(this.table.getCellRect(index, 0, true)));
                }
                ++i;
            }
        } else if (cmd.getActionCommand().equals("maxOffTime")) {
            double v = -1.7976931348623157E308;
            int index = -1;
            int i = 1;
            while (i < this.dataTableModel.entries.size()) {
                if ((double)((Entry)((MyTableModel)this.dataTableModel).entries.get((int)i)).offTime > v) {
                    v = ((Entry)((MyTableModel)this.dataTableModel).entries.get((int)i)).offTime;
                    index = i;
                }
                if (index > 0) {
                    this.table.getSelectionModel().setSelectionInterval(index, index);
                    this.table.scrollRectToVisible(new Rectangle(this.table.getCellRect(index, 0, true)));
                }
                ++i;
            }
        } else if (cmd.getActionCommand().equals("maxOnTime")) {
            double v = -1.7976931348623157E308;
            int index = -1;
            int i = 1;
            while (i < this.dataTableModel.entries.size()) {
                if ((double)((Entry)((MyTableModel)this.dataTableModel).entries.get((int)i)).onTime > v) {
                    v = ((Entry)((MyTableModel)this.dataTableModel).entries.get((int)i)).onTime;
                    index = i;
                }
                if (index > 0) {
                    this.table.getSelectionModel().setSelectionInterval(index, index);
                    this.table.scrollRectToVisible(new Rectangle(this.table.getCellRect(index, 0, true)));
                }
                ++i;
            }
        } else if (cmd.getActionCommand().equals("maxIdleTime")) {
            double v = -1.7976931348623157E308;
            int index = -1;
            int i = 1;
            while (i < this.dataTableModel.entries.size()) {
                if ((double)((Entry)((MyTableModel)this.dataTableModel).entries.get((int)i)).idleTime > v) {
                    v = ((Entry)((MyTableModel)this.dataTableModel).entries.get((int)i)).idleTime;
                    index = i;
                }
                if (index > 0) {
                    this.table.getSelectionModel().setSelectionInterval(index, index);
                    this.table.scrollRectToVisible(new Rectangle(this.table.getCellRect(index, 0, true)));
                }
                ++i;
            }
        } else if (cmd.getActionCommand().equals("maxOffValue")) {
            double v = -1.7976931348623157E308;
            int index = -1;
            int i = 1;
            while (i < this.dataTableModel.entries.size()) {
                if (((Entry)((MyTableModel)this.dataTableModel).entries.get((int)i)).offValue > v) {
                    v = ((Entry)((MyTableModel)this.dataTableModel).entries.get((int)i)).offValue;
                    index = i;
                }
                if (index > 0) {
                    this.table.getSelectionModel().setSelectionInterval(index, index);
                    this.table.scrollRectToVisible(new Rectangle(this.table.getCellRect(index, 0, true)));
                }
                ++i;
            }
        } else if (cmd.getActionCommand().equals("maxOnValue")) {
            double v = -1.7976931348623157E308;
            int index = -1;
            int i = 1;
            while (i < this.dataTableModel.entries.size()) {
                if (((Entry)((MyTableModel)this.dataTableModel).entries.get((int)i)).onValue > v) {
                    v = ((Entry)((MyTableModel)this.dataTableModel).entries.get((int)i)).onValue;
                    index = i;
                }
                if (index > 0) {
                    this.table.getSelectionModel().setSelectionInterval(index, index);
                    this.table.scrollRectToVisible(new Rectangle(this.table.getCellRect(index, 0, true)));
                }
                ++i;
            }
        } else if (cmd.getActionCommand().equals("maxDutyCycle")) {
            double v = -1.7976931348623157E308;
            int index = -1;
            int i = 1;
            while (i < this.dataTableModel.entries.size()) {
                if (((Entry)this.dataTableModel.entries.get(i)).dutyCycle() > v) {
                    v = ((Entry)this.dataTableModel.entries.get(i)).dutyCycle();
                    index = i;
                }
                if (index > 0) {
                    this.table.getSelectionModel().setSelectionInterval(index, index);
                    this.table.scrollRectToVisible(new Rectangle(this.table.getCellRect(index, 0, true)));
                }
                ++i;
            }
        } else if (cmd.getActionCommand().equals("table")) {
            this.useTableData = this.tableCheckbox.isSelected();
            this.fillChannels();
        } else {
            this.parseTextFields();
        }
    }

    private void addEntry(double v, long t) {
        long dt = t - this.checkTime;
        this.checkTime = t;
        if (!Double.isNaN(v)) {
            this.currentValueLabel.setText(String.valueOf(this.fmt.format.formatDisplay(v)) + this.fmt.unit);
            Boolean state = null;
            if (v >= this.threshold + this.tolerance / 2.0) {
                state = !this.onIsLow;
            }
            if (v <= this.threshold - this.tolerance / 2.0) {
                state = this.onIsLow;
            }
            this.currentTimeLabel.setText(String.valueOf(this.nf1.format((double)(state == null ? this.currentEntry.idleTime : this.sumTime) / 1000.0)) + "s");
            if (state != null && state != this.currentState) {
                this.onIndicator.setColor(Color.red);
                this.onIndicator.setOn(state);
                if (state.booleanValue()) {
                    this.currentEntry.offTime = this.sumTime;
                    this.currentEntry.offValue = this.sumValue / (double)this.count;
                    this.sumValue = 0.0;
                    this.sumTime = 0L;
                    this.count = 0;
                    this.currentState = state;
                } else {
                    this.currentEntry.onTime = this.sumTime;
                    this.currentEntry.onValue = this.sumValue / (double)this.count;
                    this.sumValue = 0.0;
                    this.sumTime = 0L;
                    this.count = 0;
                    this.currentState = state;
                    if (this.dataTableModel.getRowCount() > 0) {
                        this.onsum += this.currentEntry.onValue;
                        this.offsum += this.currentEntry.offValue;
                        this.onsumTime += this.currentEntry.onValue * (double)this.currentEntry.onTime;
                        this.offsumTime += this.currentEntry.offValue * (double)this.currentEntry.offTime;
                        this.sumCount += 1.0;
                        this.footerEntry.timestamp += this.currentEntry.onTime + this.currentEntry.offTime + this.currentEntry.idleTime;
                        this.footerEntry.onTime += this.currentEntry.onTime;
                        this.footerEntry.offTime += this.currentEntry.offTime;
                        this.footerEntry.idleTime += this.currentEntry.idleTime;
                        this.footerEntry.onValue = this.onsum / this.sumCount;
                        this.footerEntry.offValue = this.offsum / this.sumCount;
                        this.footerTableModel.fireUpdate();
                    }
                    this.dataTableModel.entries.add(this.currentEntry);
                    this.currentEntry = new Entry();
                    this.currentEntry.timestamp = t - this.startTime;
                    this.dataTableModel.fireInsert();
                }
            }
            if (state != null && state == this.currentState) {
                this.sumValue += v;
                this.sumTime += dt;
                ++this.count;
            }
            if (state == null) {
                this.onIndicator.setColor(Color.blue);
                this.onIndicator.setOn(true);
                this.currentEntry.idleTime += dt;
            }
        } else {
            this.onIndicator.setColor(Color.blue);
            this.onIndicator.setOn(true);
            this.currentEntry.idleTime += dt;
        }
    }

    private void timerUpdate() {
        boolean tt = Support.dataBase.columns() > 0;
        this.tableCheckbox.setEnabled(tt);
        if (!tt) {
            this.tableCheckbox.setSelected(false);
        }
        if (this.useTableData) {
            if (this.tableEntry < Support.dataBase.rows()) {
                if (this.tableEntry == 0) {
                    this.startTime = 0L;
                    this.checkTime = 0L;
                }
                double[] time = Support.dataBase.getColumn("time");
                double[] data = Support.dataBase.getColumn(this.selectedChannelName);
                int i = this.tableEntry;
                while (i < data.length) {
                    this.addEntry(data[i], (long)(time[i] * 1000.0));
                    ++i;
                }
                this.tableEntry = data.length;
            }
        } else {
            InterfaceThreads.setupVars();
            double v = Support.math.getChannelValue(this.selectedChannelName, "TimerCounter");
            long t = System.currentTimeMillis();
            this.addEntry(v, t);
        }
    }

    private void fillChannels() {
        Object sel = this.channelComboBox.getSelectedItem();
        this.channelComboBox.removeAllItems();
        if (this.useTableData) {
            for (String s : Support.dataBase.header().getDataColumnsList()) {
                this.channelComboBox.addItem(String.valueOf(StaticTable) + s);
            }
        } else {
            for (String s : InterfaceThreads.listChannels(true)) {
                this.channelComboBox.addItem(s);
            }
        }
        this.channelComboBox.setSelectedItem(sel);
        if (this.channelComboBox.getSelectedIndex() < 0) {
            this.channelComboBox.setSelectedIndex(0);
        }
    }

    @Override
    public void focusGained(FocusEvent arg0) {
        if (arg0.getSource() instanceof JTextField) {
            ((JTextField)arg0.getSource()).selectAll();
        }
    }

    @Override
    public void focusLost(FocusEvent arg0) {
        this.parseTextFields();
    }

    public static synchronized void closeAll() {
        if (popupTimerCounter != null) {
            popupTimerCounter.setVisible(false);
            popupTimerCounter = null;
        }
    }

    public static PopupTimerCounter getPopup() {
        if (popupTimerCounter != null) {
            popupTimerCounter.requestFocus();
            return popupTimerCounter;
        }
        popupTimerCounter = new PopupTimerCounter();
        Point p = Support.paneCommand.popupsButton.getLocationOnScreen();
        p.translate(-750, -500);
        if (p.y < 0) {
            p.y = 0;
        }
        if (p.x < 0) {
            p.x = 0;
        }
        popupTimerCounter.setLocation(p);
        popupTimerCounter.setVisible(true);
        return popupTimerCounter;
    }

    public static List<String> generateScript() {
        ArrayList<String> list = new ArrayList<String>();
        if (popupTimerCounter != null) {
            list.add("#ShowPopupSystem TimerCounter " + popupTimerCounter.generateLocationParams());
            list.add("#SetTimerCounter " + popupTimerCounter.generateParams());
        }
        return list;
    }

    public static void alignGridAll(int pixels) {
        if (popupTimerCounter != null) {
            popupTimerCounter.alignGrid(pixels);
        }
    }

    private class Entry {
        long timestamp = 0L;
        long offTime = 0L;
        long onTime = 0L;
        long idleTime = 0L;
        double offValue = Double.NaN;
        double onValue = Double.NaN;

        private Entry() {
        }

        double dutyCycle() {
            long t = this.onTime + this.offTime + this.idleTime;
            return t == 0L ? 0.0 : (double)this.onTime * 100.0 / (double)t;
        }
    }

    private class MyTableModel
    implements TableModel {
        private List<Entry> entries = new ArrayList<Entry>();
        private List<TableModelListener> listeners = new ArrayList<TableModelListener>();
        private boolean footer = false;

        public MyTableModel(boolean footer) {
            this.footer = footer;
        }

        @Override
        public void addTableModelListener(TableModelListener arg0) {
            this.listeners.add(arg0);
        }

        @Override
        public Class<?> getColumnClass(int column) {
            return column == 0 ? Integer.class : String.class;
        }

        @Override
        public int getColumnCount() {
            return 8;
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return "Index";
                }
                case 1: {
                    return "Time";
                }
                case 2: {
                    return "Off time";
                }
                case 3: {
                    return "On time";
                }
                case 4: {
                    return "Idle time";
                }
                case 5: {
                    return "Off value";
                }
                case 6: {
                    return "On value";
                }
                case 7: {
                    return "Duty cycle";
                }
            }
            return "";
        }

        @Override
        public int getRowCount() {
            return this.entries.size();
        }

        @Override
        public Object getValueAt(int row, int column) {
            Entry e = this.entries.get(row);
            int n = this.footer ? PopupTimerCounter.this.dataTableModel.getRowCount() - 1 : row;
            switch (column) {
                case 0: {
                    return n;
                }
                case 1: {
                    return String.valueOf(PopupTimerCounter.this.nf1.format((double)e.timestamp / 1000.0)) + "s";
                }
                case 2: {
                    return String.valueOf(PopupTimerCounter.this.nf1.format((double)e.offTime / 1000.0 / (double)(this.footer ? Math.max(n, 1) : 1))) + "s";
                }
                case 3: {
                    return String.valueOf(PopupTimerCounter.this.nf1.format((double)e.onTime / 1000.0 / (double)(this.footer ? Math.max(n, 1) : 1))) + "s";
                }
                case 4: {
                    return String.valueOf(PopupTimerCounter.this.nf1.format((double)e.idleTime / 1000.0 / (double)(this.footer ? Math.max(n, 1) : 1))) + "s";
                }
                case 5: {
                    return String.valueOf(PopupTimerCounter.this.fmt.format.formatDisplay(e.offValue)) + PopupTimerCounter.this.fmt.unit;
                }
                case 6: {
                    return String.valueOf(PopupTimerCounter.this.fmt.format.formatDisplay(e.onValue)) + PopupTimerCounter.this.fmt.unit;
                }
                case 7: {
                    return String.valueOf(PopupTimerCounter.this.nf1.format(e.dutyCycle())) + "%";
                }
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int arg0, int arg1) {
            return false;
        }

        @Override
        public void removeTableModelListener(TableModelListener arg0) {
            this.listeners.remove(arg0);
        }

        @Override
        public void setValueAt(Object arg0, int arg1, int arg2) {
        }

        public void fireInsert() {
            for (TableModelListener tml : this.listeners) {
                tml.tableChanged(new TableModelEvent(this, this.getRowCount(), this.getRowCount(), -1, 1));
            }
        }

        public void fireUpdate() {
            for (TableModelListener tml : this.listeners) {
                tml.tableChanged(new TableModelEvent(this, 0, this.getRowCount()));
            }
        }

        public void fireDelete() {
            for (TableModelListener tml : this.listeners) {
                tml.tableChanged(new TableModelEvent(this, 0, this.getRowCount(), -1, -1));
            }
        }
    }
}

