/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.main;

import dk.hkj.main.FontAdjust;
import dk.hkj.main.InterfaceThreads;
import dk.hkj.main.PopupBase;
import dk.hkj.main.Support;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.Timer;

public class PopupTimer
extends PopupBase
implements ActionListener {
    private static PopupTimer popupTimer = null;
    private JPanel mainPanel = null;
    private JLabel resultLabel1 = null;
    private JLabel resultLabel2 = null;
    private JButton startButton = null;
    private JButton markButton = null;
    private JButton stopButton = null;
    private long startTime = 0L;
    private long stopTime = 0L;
    private long lastMark = 0L;
    private boolean isRunning = false;
    private Timer timer = null;
    private NumberFormat nf;

    public PopupTimer() {
        PopupTimer.closeAll();
        popupTimer = this;
        this.setTitle("Timer");
        this.definePopupName("Timer", true);
        this.timer = new Timer(100, this);
        this.timer.setActionCommand("Timer");
        this.setLayout(new BorderLayout());
        this.add(this.makePanel());
        this.setAlwaysOnTop(true);
        this.nf = NumberFormat.getInstance(Locale.US);
        this.nf.setGroupingUsed(false);
        this.nf.setMaximumFractionDigits(2);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowActivated(WindowEvent arg0) {
                PopupTimer.this.startButton.requestFocusInWindow();
            }
        });
        this.pack();
    }

    public static void closeAll() {
        if (popupTimer != null) {
            popupTimer.setVisible(false);
        }
    }

    public static boolean reShow() {
        if (popupTimer != null) {
            popupTimer.setVisible(true);
        }
        return popupTimer != null;
    }

    public static PopupTimer getInstance() {
        return popupTimer;
    }

    private Component makePanel() {
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new GridBagLayout());
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        this.resultLabel1 = new FontAdjust.FontLabel("--");
        this.resultLabel1.setBorder(BorderFactory.createEtchedBorder(1));
        this.resultLabel1.setHorizontalAlignment(0);
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.fill = 1;
        c.anchor = 17;
        c.weightx = 1.0;
        panel.add((Component)this.resultLabel1, c);
        this.resultLabel2 = new FontAdjust.FontLabel("--");
        this.resultLabel2.setBorder(BorderFactory.createEtchedBorder(1));
        this.resultLabel2.setHorizontalAlignment(0);
        c = new GridBagConstraints();
        c.gridx = 1;
        c.fill = 1;
        c.anchor = 13;
        c.weightx = 1.0;
        panel.add((Component)this.resultLabel2, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 3;
        c.insets = new Insets(5, 5, 5, 5);
        c.fill = 2;
        c.weightx = 1.0;
        this.mainPanel.add((Component)panel, c);
        this.startButton = new FontAdjust.FontButton("Start");
        this.startButton.setToolTipText("Start the timer from 0");
        c = new GridBagConstraints();
        this.startButton.addActionListener(this);
        this.startButton.setActionCommand("Start");
        c.gridx = 0;
        c.gridy = 1;
        c.insets = new Insets(0, 3, 3, 3);
        c.weightx = 1.0;
        this.mainPanel.add((Component)this.startButton, c);
        this.markButton = new FontAdjust.FontButton("Mark");
        this.markButton.addActionListener(this);
        this.markButton.setActionCommand("Mark");
        this.markButton.setToolTipText("Copy the current time to the log window");
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 1;
        c.insets = new Insets(0, 3, 3, 3);
        c.weightx = 1.0;
        this.mainPanel.add((Component)this.markButton, c);
        this.stopButton = new FontAdjust.FontButton("Stop");
        this.stopButton.addActionListener(this);
        this.stopButton.setActionCommand("Stop");
        this.stopButton.setToolTipText("Stop the timer");
        c = new GridBagConstraints();
        c.gridx = 2;
        c.gridy = 1;
        c.insets = new Insets(0, 3, 3, 3);
        c.weightx = 1.0;
        this.mainPanel.add((Component)this.stopButton, c);
        this.enableButtons();
        return this.mainPanel;
    }

    private void display() {
        long delta = this.isRunning ? System.currentTimeMillis() - this.startTime : this.stopTime - this.startTime;
        StringBuilder sb = new StringBuilder();
        sb.append(Support.toHMS((double)Math.round((double)delta / 100.0) / 10.0));
        this.resultLabel1.setText(sb.toString());
        if (delta < 600000L) {
            this.resultLabel2.setText(String.valueOf(this.nf.format((double)Math.round((double)delta / 100.0) / 10.0)) + "s");
        } else if (delta < 10800000L) {
            this.resultLabel2.setText(String.valueOf(this.nf.format((double)delta / 60000.0)) + "m");
        } else {
            this.resultLabel2.setText(String.valueOf(this.nf.format((double)delta / 3600000.0)) + "h");
        }
    }

    private void enableButtons() {
        this.startButton.setEnabled(!this.isRunning);
        this.stopButton.setEnabled(this.isRunning);
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        if (arg0.getActionCommand().equals("Timer")) {
            this.display();
        } else if (arg0.getActionCommand().equals("Start")) {
            this.startTime = System.currentTimeMillis();
            this.lastMark = 0L;
            this.isRunning = true;
            this.timer.start();
            this.enableButtons();
        } else if (arg0.getActionCommand().equals("Mark")) {
            long t = System.currentTimeMillis();
            long delta = 0L;
            long deltaMark = 0L;
            if (this.isRunning) {
                delta = t - this.startTime;
                if (this.lastMark != 0L) {
                    deltaMark = t - this.lastMark;
                }
                this.lastMark = t;
            } else {
                delta = this.stopTime - this.startTime;
            }
            StringBuilder sb = new StringBuilder();
            sb.append(";; Timer: ");
            sb.append(Support.toHMS((double)Math.round((double)delta / 100.0) / 10.0));
            sb.append(" - ");
            sb.append(this.nf.format((double)delta / 1000.0));
            sb.append("s");
            if (delta > 60000L) {
                sb.append(" - ");
                sb.append(this.nf.format((double)delta / 60000.0));
                sb.append("m");
            }
            if (delta > 3600000L) {
                sb.append(" - ");
                sb.append(this.nf.format((double)delta / 3600000.0));
                sb.append("h");
            }
            if (deltaMark != 0L) {
                sb.append("    Time from last mark: " + this.nf.format((double)deltaMark / 1000.0) + "s");
            }
            InterfaceThreads.log(sb.toString());
        } else if (arg0.getActionCommand().equals("Stop") && this.isRunning) {
            this.stopTime = System.currentTimeMillis();
            this.isRunning = false;
            this.timer.stop();
            this.display();
            this.enableButtons();
        }
    }

    public static List<String> generateScript() {
        ArrayList<String> list = new ArrayList<String>();
        if (popupTimer != null && popupTimer.isVisible()) {
            list.add("#ShowPopupSystem Timer " + popupTimer.generateLocationParams());
        }
        return list;
    }

    public static void alignGridAll(int pixels) {
        if (popupTimer != null && popupTimer.isVisible()) {
            popupTimer.alignGrid(pixels);
        }
    }
}

