/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.main;

import dk.hkj.main.DeviceInterface;
import dk.hkj.main.FontAdjust;
import dk.hkj.main.IconGenerator;
import dk.hkj.main.PopupBase;
import dk.hkj.main.Support;
import dk.hkj.script.Script;
import dk.hkj.util.StringUtil;
import dk.hkj.vars.Var;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

public class PopupTestInterface
extends PopupBase
implements TableModel,
ActionListener {
    private static PopupTestInterface testInterfacePopup = null;
    private JPopupMenu popupMenu = null;
    private DeviceInterface di = null;
    private List<IFaceName> iFaceNames = new ArrayList<IFaceName>();
    private String value = "";
    private int channel = 0;
    private List<TableModelListener> listeners = new ArrayList<TableModelListener>();
    private Script script = new Script();
    private JTable table;
    private String deviceType = "";
    private boolean viewOnly;
    public static final String[] textFunctions = new String[]{"Mode", "Waveform", "Coupling", "MathDefinition"};
    public static final String[] onOffFunctions = new String[]{"On", "RemoteSense"};
    private String[] functionNames = new String[]{"Mode", "Waveform", "Voltage", "VoltagePP", "Current", "Power", "Energy", "Resistance", "On", "Capacity", "Temperature", "Value", "Amplitude", "Offset", "Frequency", "DutyCycle", "OVP", "OCP", "OPP", "RemoteSense", "Coupling", "Relay", "Relays", "BW", "Termination", "MathDefinition", "Input", "Inputs"};

    public static boolean isTextFunction(String func) {
        if (func.startsWith("set") || func.startsWith("get")) {
            func = func.substring(3);
        } else if (func.startsWith("read")) {
            func = func.substring(4);
        }
        String[] stringArray = textFunctions;
        int n = textFunctions.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (s.equals(func)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean isOnOffFunction(String func) {
        if (func.startsWith("set") || func.startsWith("get")) {
            func = func.substring(3);
        } else if (func.startsWith("read")) {
            func = func.substring(4);
        }
        String[] stringArray = onOffFunctions;
        int n = onOffFunctions.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (s.equals(func)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean isNumeric(String s) {
        block3: {
            try {
                if (s.length() != 0) break block3;
                return false;
            }
            catch (Exception exception) {
                return false;
            }
        }
        return !Double.isNaN(StringUtil.parseDoubleEE(s));
    }

    private boolean containsLetters(String s) {
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (Character.isAlphabetic(c)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean containsDeviceType(String type) {
        String[] stringArray = this.di.getIFaceTypes();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (s.equalsIgnoreCase(type)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    static boolean checkName(String name) {
        int hump = -1;
        if (name.startsWith("set")) {
            hump = 3;
        } else if (name.startsWith("get")) {
            hump = 3;
        } else if (name.startsWith("read")) {
            hump = 4;
        }
        if (hump < 0) {
            return false;
        }
        if (!Character.isUpperCase(name.charAt(hump))) {
            return false;
        }
        if (!name.substring(hump + 1).equals(name.substring(hump + 1).toLowerCase())) {
            return false;
        }
        return false;
    }

    public static void closeAll() {
        if (testInterfacePopup != null) {
            testInterfacePopup.setVisible(false);
            testInterfacePopup = null;
        }
    }

    public PopupTestInterface(JComponent pos, DeviceInterface di, boolean viewOnly) {
        PopupTestInterface.closeAll();
        testInterfacePopup = this;
        this.setDefaultCloseOperation(2);
        this.di = di;
        this.viewOnly = viewOnly;
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent arg0) {
            }
        });
        String[] deviceTypes = di.getIFaceTypes();
        String tt = "";
        if (deviceTypes != null) {
            int n = 0;
            this.deviceType = deviceTypes[0];
            StringBuilder sb = new StringBuilder();
            String[] stringArray = deviceTypes;
            int n2 = deviceTypes.length;
            int n3 = 0;
            while (n3 < n2) {
                String t = stringArray[n3];
                if (sb.length() > 0) {
                    sb.append(" ");
                }
                sb.append(t);
                ++n;
                ++n3;
            }
            tt = "   defined as type" + (n > 1 ? "s" : "") + ": " + sb.toString();
        }
        this.setTitle(String.valueOf(viewOnly ? "Preview" : "Test") + " of interface for " + di.getDeviceName() + tt);
        this.definePopupName("TestInterface", false);
        this.addComponentListener(new ComponentListener(){

            @Override
            public void componentHidden(ComponentEvent arg0) {
            }

            @Override
            public void componentMoved(ComponentEvent arg0) {
            }

            @Override
            public void componentResized(ComponentEvent arg0) {
                PopupTestInterface.this.setPreferredSize(PopupTestInterface.this.getMaximumSize());
            }

            @Override
            public void componentShown(ComponentEvent arg0) {
            }
        });
        for (String ifName : di.getIFaces().keySet()) {
            boolean added = false;
            for (IFaceName ifn : this.iFaceNames) {
                if (!ifn.addName(ifName)) continue;
                added = true;
                break;
            }
            if (added) continue;
            this.iFaceNames.add(new IFaceName(ifName));
        }
        this.iFaceNames.sort(null);
        this.setLocationRelativeTo(pos);
        this.makeMainPanel();
        this.pack();
        this.setVisible(true);
    }

    private void makeMainPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        this.table = new FontAdjust.FontTable(){

            @Override
            public Component prepareRenderer(TableCellRenderer renderer, int row, int col) {
                JComponent comp = (JComponent)super.prepareRenderer(renderer, row, col);
                boolean sel = comp.getBackground().equals(Support.colorScheme.selectedCellbackground);
                if (!sel) {
                    comp.setBackground(row % 4 == 0 ? Support.colorScheme.tableGridAlternateBackground : Support.colorScheme.textBackground);
                }
                if (col == 0 || col == 2 || col == 5) {
                    comp.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 0));
                    ((JLabel)comp).setHorizontalAlignment(2);
                } else if (comp instanceof JLabel) {
                    ((JLabel)comp).setHorizontalAlignment(0);
                }
                IFaceName ifn = (IFaceName)PopupTestInterface.this.iFaceNames.get(row);
                switch (col) {
                    case 0: {
                        if (ifn.setFailed) {
                            comp.setBackground(Support.colorScheme.errorBackground);
                            break;
                        }
                        if (!ifn.isSetValid() || sel) break;
                        comp.setBackground(row % 4 == 0 ? Support.colorScheme.okAltBackground : Support.colorScheme.okBackground);
                        break;
                    }
                    case 2: {
                        if (!ifn.isGetValid() || sel) break;
                        comp.setBackground(row % 4 == 0 ? Support.colorScheme.okAltBackground : Support.colorScheme.okBackground);
                        break;
                    }
                    case 4: {
                        if (ifn.getResult == null) break;
                        if (ifn.isGetResultValid()) {
                            comp.setBackground(row % 4 == 0 ? Support.colorScheme.okAltBackground : Support.colorScheme.okBackground);
                            break;
                        }
                        comp.setBackground(Support.colorScheme.errorBackground);
                        break;
                    }
                    case 5: {
                        if (!ifn.isReadValid() || sel) break;
                        comp.setBackground(row % 4 == 0 ? Support.colorScheme.okAltBackground : Support.colorScheme.okBackground);
                        break;
                    }
                    case 7: {
                        if (ifn.readResult == null) break;
                        if (ifn.isReadResultValid()) {
                            comp.setBackground(row % 4 == 0 ? Support.colorScheme.okAltBackground : Support.colorScheme.okBackground);
                            break;
                        }
                        comp.setBackground(Support.colorScheme.errorBackground);
                    }
                }
                return comp;
            }
        };
        this.table.setColumnModel(new Support.WidthTableColumnModel(new int[]{250, 50, 220, 50, 110, 220, 50, 110}));
        this.table.setModel(this);
        this.table.getTableHeader().setReorderingAllowed(false);
        Support.colorScheme.selectedCellbackground = this.table.getSelectionBackground();
        Support.colorScheme.selectedCellForeground = this.table.getSelectionForeground();
        this.table.setAutoResizeMode(0);
        this.table.setToolTipText("Green background means everything is fine, read can be due to a execution error or a get/read returning a string result when a number is expected");
        Dimension d = new Dimension(1090, 250);
        this.setPreferredSize(d);
        this.popupMenu = new JPopupMenu();
        JScrollPane sp = new JScrollPane(this.table);
        panel.add(sp);
        this.table.addMouseListener(new MouseListener(){

            public void checkPopup(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    PopupTestInterface.this.buildPopupMenu(e);
                    PopupTestInterface.this.popupMenu.show(PopupTestInterface.this.table, e.getX(), e.getY());
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                this.checkPopup(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.checkPopup(e);
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getButton() == 1 && e.getClickCount() == 1 && !PopupTestInterface.this.viewOnly) {
                    JTable source = (JTable)e.getSource();
                    int row = source.rowAtPoint(e.getPoint());
                    int column = source.columnAtPoint(e.getPoint());
                    switch (column) {
                        case 1: {
                            PopupTestInterface.this.testSet(row, PopupTestInterface.this.value);
                            break;
                        }
                        case 3: {
                            PopupTestInterface.this.testGet(row);
                            break;
                        }
                        case 6: {
                            PopupTestInterface.this.testRead(row);
                        }
                    }
                }
            }

            @Override
            public void mouseEntered(MouseEvent arg0) {
            }

            @Override
            public void mouseExited(MouseEvent arg0) {
            }
        });
        JPanel bottomPanel = new JPanel();
        bottomPanel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        int channels = this.di.getIFaceChannels();
        if (!this.viewOnly) {
            c.gridx = 0;
            c.insets = new Insets(5, 5, 5, 2);
            bottomPanel.add((Component)new JLabel("Set param:"), c);
            final FontAdjust.FontTextField setTextField = new FontAdjust.FontTextField(8);
            setTextField.setMinimumSize(new Dimension(30, 30));
            setTextField.addActionListener(this);
            setTextField.setActionCommand("Set");
            setTextField.setToolTipText("Parameter for set function, this will usually be a number. SetMode parameter may match Mode popup");
            setTextField.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent arg0) {
                }

                @Override
                public void focusLost(FocusEvent arg0) {
                    PopupTestInterface.this.actionPerformed(new ActionEvent(setTextField, 0, "Set"));
                }
            });
            c = new GridBagConstraints();
            c.gridx = 1;
            c.anchor = 17;
            c.weightx = 0.3;
            c.insets = new Insets(2, 5, 5, 5);
            bottomPanel.add((Component)setTextField, c);
            if (channels > 1) {
                c = new GridBagConstraints();
                c.gridx = 2;
                c.anchor = 13;
                c.weightx = 0.3;
                c.insets = new Insets(5, 5, 5, 2);
                bottomPanel.add((Component)new JLabel("Channel:"), c);
                ButtonGroup bg = new ButtonGroup();
                int channel = 0;
                while (channel < channels) {
                    FontAdjust.FontRadioButton channelRadioButton = new FontAdjust.FontRadioButton("" + (channel + 1));
                    channelRadioButton.setActionCommand("Channel " + (channel + 1));
                    channelRadioButton.addActionListener(this);
                    if (channel == 0) {
                        channelRadioButton.setSelected(true);
                    }
                    channelRadioButton.setToolTipText("Channel number for multichannel devices, One is default when no number is specified.");
                    bg.add(channelRadioButton);
                    c = new GridBagConstraints();
                    c.gridx = 3 + channel;
                    c.anchor = 17;
                    c.weightx = 0.05;
                    c.insets = new Insets(2, 5, 5, 5);
                    bottomPanel.add((Component)channelRadioButton, c);
                    ++channel;
                }
            }
            FontAdjust.FontButton testAllButton = new FontAdjust.FontButton("Test all get & read");
            testAllButton.setActionCommand("Test");
            testAllButton.addActionListener(this);
            c = new GridBagConstraints();
            c.gridx = 4 + channels;
            c.anchor = 10;
            c.weightx = 1.0;
            c.insets = new Insets(5, 5, 5, 5);
            bottomPanel.add((Component)testAllButton, c);
            FontAdjust.FontButton clearButton = new FontAdjust.FontButton("Clear results");
            clearButton.setActionCommand("Clear");
            clearButton.addActionListener(this);
            c = new GridBagConstraints();
            c.gridx = 5 + channels;
            c.anchor = 10;
            c.weightx = 1.0;
            c.insets = new Insets(5, 5, 5, 5);
            bottomPanel.add((Component)clearButton, c);
        }
        FontAdjust.FontLabel label = new FontAdjust.FontLabel("<html>In addition the interface also supports <font color=red>deviceWrite(device,scpi_commands)</font> and <font color=red>deviceRead(device,scpi_commands)</font>. They are similar, but read returns an answer.");
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridwidth = 6 + channels;
        c.anchor = 17;
        c.fill = 2;
        c.weightx = 1.0;
        c.insets = new Insets(5, 5, 5, 5);
        bottomPanel.add((Component)label, c);
        panel.add((Component)bottomPanel, "South");
        this.add(panel);
    }

    private void buildPopupMenu(MouseEvent e) {
        FontAdjust.FontMenuItem mi;
        this.popupMenu.removeAll();
        JTable source = (JTable)e.getSource();
        int row = source.rowAtPoint(e.getPoint());
        IFaceName ifn = this.iFaceNames.get(row);
        if (ifn.isSetValid() && !ifn.isTextParam() && !this.viewOnly) {
            mi = new FontAdjust.FontMenuItem(ifn.getSet("0"));
            mi.setActionCommand("MenuSet: " + row + " 0");
            mi.addActionListener(this);
            this.popupMenu.add(mi);
            mi = new FontAdjust.FontMenuItem(ifn.getSet("1"));
            mi.setActionCommand("MenuSet: " + row + " 1");
            mi.addActionListener(this);
            this.popupMenu.add(mi);
            mi = new FontAdjust.FontMenuItem(ifn.getSet("10"));
            mi.setActionCommand("MenuSet: " + row + " 10");
            mi.addActionListener(this);
            this.popupMenu.add(mi);
        }
        mi = new FontAdjust.FontMenuItem("Copy function list to clipboard");
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PopupTestInterface.this.copyToClipboard();
            }
        });
        this.popupMenu.add(mi);
        mi = new FontAdjust.FontMenuItem("Copy setup script to clipboard");
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PopupTestInterface.this.copySetupToClipboard("=");
            }
        });
        if (!this.viewOnly) {
            this.popupMenu.add(mi);
        }
    }

    private void copyToClipboard() {
        StringBuilder sb = new StringBuilder();
        sb.append("getDevice(\"" + this.deviceType + (this.channel > 1 ? ":" + this.channel : "") + "\")\n");
        sb.append("deviceWrite(\"" + this.di.getHandleName() + "\",\"SCPI commands\")\n");
        sb.append("deviceRead(\"" + this.di.getHandleName() + "\",\"SCPI commands\")\n");
        sb.append("\n");
        int r = 0;
        while (r < this.getRowCount()) {
            String s = (String)this.getValueAt(r, 0);
            if (s.length() > 0) {
                sb.append(s);
                sb.append("\n");
            }
            if ((s = (String)this.getValueAt(r, 2)).length() > 0) {
                sb.append(s);
                sb.append("\n");
            }
            if ((s = (String)this.getValueAt(r, 5)).length() > 0) {
                sb.append(s);
                sb.append("\n");
            }
            sb.append("\n");
            ++r;
        }
        try {
            StringSelection stringSelection = new StringSelection(sb.toString());
            Clipboard clpbrd = Toolkit.getDefaultToolkit().getSystemClipboard();
            clpbrd.setContents(stringSelection, null);
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
    }

    private void copySetupToClipboard(String prefix) {
        StringBuilder sb = new StringBuilder();
        String name = String.valueOf(this.deviceType.toLowerCase()) + (this.channel > 1 ? "" + this.channel : "");
        sb.append(String.valueOf(prefix) + "var " + name + "=getDevice(\"" + this.deviceType + (this.channel > 1 ? ":" + this.channel : "") + "\")\n");
        if (this.containsDeviceType("load")) {
            sb.append("; For devices where set... includes a mode change, some lines may have to be removed\n");
        }
        int r = 0;
        while (r < this.getRowCount()) {
            IFaceName ifn = this.iFaceNames.get(r);
            String val = this.doGet(r);
            if (val != null && ifn.isSetValid()) {
                if (val.contains(".") && !this.containsLetters(val)) {
                    while (val.endsWith("0")) {
                        val = val.substring(0, val.length() - 1);
                    }
                    if (val.endsWith(".")) {
                        val = val.substring(0, val.length() - 1);
                    }
                }
                sb.append(String.valueOf(prefix) + ifn.getSet(name, val));
                sb.append("\n");
            }
            ++r;
        }
        try {
            StringSelection stringSelection = new StringSelection(sb.toString());
            Clipboard clpbrd = Toolkit.getDefaultToolkit().getSystemClipboard();
            clpbrd.setContents(stringSelection, null);
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
    }

    @Override
    public void addTableModelListener(TableModelListener arg0) {
        this.listeners.add(arg0);
    }

    public void fireColumnChanged(int column) {
        for (TableModelListener tml : this.listeners) {
            tml.tableChanged(new TableModelEvent(this, 0, this.getRowCount() - 1, column));
        }
    }

    public void fireAllChanged() {
        for (TableModelListener tml : this.listeners) {
            tml.tableChanged(new TableModelEvent(this, 0, this.getRowCount() - 1, -1));
        }
    }

    public void fireValueChanged(int row, int column) {
        for (TableModelListener tml : this.listeners) {
            tml.tableChanged(new TableModelEvent(this, row, row, column));
        }
    }

    @Override
    public Class<?> getColumnClass(int column) {
        switch (column) {
            case 1: 
            case 3: 
            case 6: {
                return ImageIcon.class;
            }
        }
        return String.class;
    }

    @Override
    public int getColumnCount() {
        return 8;
    }

    @Override
    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return "Set";
            }
            case 1: {
                return "Test";
            }
            case 2: {
                return "Get";
            }
            case 3: {
                return "Test";
            }
            case 4: {
                return "Get result";
            }
            case 5: {
                return "Read";
            }
            case 6: {
                return "Test";
            }
            case 7: {
                return "Read result";
            }
        }
        return "";
    }

    @Override
    public int getRowCount() {
        return this.iFaceNames.size();
    }

    @Override
    public Object getValueAt(int row, int column) {
        IFaceName ifn = this.iFaceNames.get(row);
        switch (column) {
            case 0: {
                return ifn.getSet();
            }
            case 1: {
                return !this.viewOnly && ifn.setName.length() > 0 ? IconGenerator.makeIcon(IconGenerator.IconType.SetButton) : "";
            }
            case 2: {
                return ifn.getGet();
            }
            case 3: {
                return !this.viewOnly && ifn.getName.length() > 0 ? IconGenerator.makeIcon(IconGenerator.IconType.GetButton) : "";
            }
            case 4: {
                return ifn.getResult == null ? "" : ifn.getResult;
            }
            case 5: {
                return ifn.getRead();
            }
            case 6: {
                return !this.viewOnly && ifn.readName.length() > 0 ? IconGenerator.makeIcon(IconGenerator.IconType.ReadButton) : "";
            }
            case 7: {
                return ifn.readResult == null ? "" : ifn.readResult;
            }
        }
        return "";
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
    }

    protected void testSet(int row, String value) {
        IFaceName ifn = this.iFaceNames.get(row);
        try {
            if (ifn.setName.length() == 0) {
                return;
            }
            this.script.expression(ifn.getSet(value));
            ifn.setFailed = false;
        }
        catch (Exception exception) {
            ifn.setFailed = true;
        }
        this.fireValueChanged(row, 0);
    }

    protected String doGet(int row) {
        String s;
        IFaceName ifn;
        block3: {
            ifn = this.iFaceNames.get(row);
            s = "";
            ifn.getResult = null;
            if (ifn.getName.length() != 0) break block3;
            return null;
        }
        try {
            Var v = this.script.expression(ifn.getGet());
            s = v.asString();
        }
        catch (Exception exception) {
            ifn.getFailed = true;
        }
        return s;
    }

    protected void testGet(int row) {
        IFaceName ifn = this.iFaceNames.get(row);
        try {
            ifn.getResult = null;
            if (ifn.getName.length() == 0) {
                return;
            }
            Var v = this.script.expression(ifn.getGet());
            ifn.getResult = v.asString();
            ifn.getFailed = false;
        }
        catch (Exception exception) {
            ifn.getFailed = true;
        }
        this.fireValueChanged(row, 4);
    }

    protected void testRead(int row) {
        IFaceName ifn = this.iFaceNames.get(row);
        try {
            ifn.readResult = null;
            if (ifn.readName.length() == 0) {
                return;
            }
            Var v = this.script.expression(ifn.getRead());
            ifn.readResult = v.asString();
            ifn.readFailed = false;
        }
        catch (Exception exception) {
            ifn.readFailed = true;
        }
        this.fireValueChanged(row, 7);
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        if (arg0.getActionCommand().equals("Set")) {
            this.value = ((JTextField)arg0.getSource()).getText().trim();
            ((JTextField)arg0.getSource()).selectAll();
            this.fireColumnChanged(0);
            this.fireColumnChanged(2);
            this.fireColumnChanged(5);
        } else if (arg0.getActionCommand().startsWith("Channel")) {
            try {
                this.channel = Integer.parseInt(arg0.getActionCommand().split("[ ]+")[1]);
            }
            catch (Exception exception) {
                this.channel = 1;
            }
            this.fireColumnChanged(0);
            this.fireColumnChanged(2);
            this.fireColumnChanged(5);
        } else if (arg0.getActionCommand().equals("Test")) {
            int i = 0;
            while (i < this.getRowCount()) {
                this.testGet(i);
                this.testRead(i);
                ++i;
            }
            this.table.clearSelection();
        } else if (arg0.getActionCommand().equals("Clear")) {
            for (IFaceName ifn : this.iFaceNames) {
                ifn.getResult = null;
                ifn.readResult = null;
                ifn.getFailed = false;
                ifn.readFailed = false;
                ifn.setFailed = false;
            }
            this.table.clearSelection();
            this.fireAllChanged();
        } else if (arg0.getActionCommand().startsWith("MenuSet:")) {
            String[] s = arg0.getActionCommand().split("[ ]+");
            this.testSet(Integer.parseInt(s[1]), s[2]);
        }
    }

    public static void alignGridAll(int pixels) {
        if (testInterfacePopup != null) {
            testInterfacePopup.alignGrid(pixels);
        }
    }

    private class IFaceName
    implements Comparable<IFaceName> {
        String setName = "";
        String getName = "";
        String readName = "";
        String getResult = null;
        String readResult = null;
        boolean setFailed = false;
        boolean getFailed = false;
        boolean readFailed = false;

        public IFaceName(String name) {
            if (name.startsWith("set")) {
                this.setName = name;
            } else if (name.startsWith("get")) {
                this.getName = name;
            } else if (name.startsWith("read")) {
                this.readName = name;
            }
        }

        public boolean isStandardName() {
            String name = this.getName();
            String[] stringArray = PopupTestInterface.this.functionNames;
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                if (name.equalsIgnoreCase(s)) {
                    return true;
                }
                if (name.equalsIgnoreCase("min" + s)) {
                    return true;
                }
                if (name.equalsIgnoreCase("max" + s)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }

        public boolean isTextParam() {
            String name = this.getName();
            String[] stringArray = textFunctions;
            int n = textFunctions.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                if (name.equalsIgnoreCase(s)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }

        public boolean isSetValid() {
            if (this.setName.length() == 0) {
                return false;
            }
            return this.isStandardName();
        }

        public boolean isGetValid() {
            if (this.getName.length() == 0) {
                return false;
            }
            return this.isStandardName();
        }

        public boolean isGetResultValid() {
            if (this.getName.length() == 0 || this.getResult == null || this.getResult.length() == 0) {
                return true;
            }
            if (this.getFailed) {
                return false;
            }
            if (this.isTextParam()) {
                return true;
            }
            if (this.isStandardName() && PopupTestInterface.this.isNumeric(this.readResult)) {
                return true;
            }
            return true;
        }

        public boolean isReadValid() {
            if (this.readName.length() == 0) {
                return false;
            }
            return this.isStandardName();
        }

        public boolean isReadResultValid() {
            if (this.readName.length() == 0 || this.readResult == null || this.readResult.length() == 0) {
                return true;
            }
            if (this.readFailed) {
                return false;
            }
            if (this.isTextParam()) {
                return true;
            }
            if (this.isStandardName() && PopupTestInterface.this.isNumeric(this.readResult)) {
                return true;
            }
            return true;
        }

        public boolean addName(String name) {
            if (name.startsWith("set")) {
                if (name.substring(3).equals(this.getName())) {
                    this.setName = name;
                    return true;
                }
            } else if (name.startsWith("get")) {
                if (name.substring(3).equals(this.getName())) {
                    this.getName = name;
                    return true;
                }
            } else if (name.startsWith("read") && name.substring(4).equals(this.getName())) {
                this.readName = name;
                return true;
            }
            return false;
        }

        private String getName() {
            if (this.setName.length() > 0) {
                return this.setName.substring(3);
            }
            if (this.getName.length() > 0) {
                return this.getName.substring(3);
            }
            if (this.readName.length() > 0) {
                return this.readName.substring(4);
            }
            return "";
        }

        private String formatName(String name, String device, String value) {
            if (name.length() == 0) {
                return "";
            }
            StringBuilder sb = new StringBuilder();
            sb.append(name);
            sb.append("(");
            if (device != null) {
                sb.append(device);
            } else {
                sb.append("\"");
                sb.append(PopupTestInterface.this.di.getHandleName());
                if (PopupTestInterface.this.channel > 1) {
                    sb.append(":");
                    sb.append(PopupTestInterface.this.channel);
                }
                sb.append("\"");
            }
            if (name.startsWith("set")) {
                sb.append(",");
                if (PopupTestInterface.this.viewOnly) {
                    if (this.isStandardName() && this.isTextParam()) {
                        sb.append("\"\"");
                    } else {
                        sb.append("0");
                    }
                } else if (PopupTestInterface.this.isNumeric(value)) {
                    sb.append(value);
                } else if (this.isStandardName() && !this.isTextParam()) {
                    sb.append("--invalid--");
                } else {
                    sb.append('\"');
                    sb.append(value);
                    sb.append('\"');
                }
            }
            sb.append(")");
            return sb.toString();
        }

        public String getSet() {
            return this.formatName(this.setName, null, PopupTestInterface.this.value);
        }

        public String getSet(String value) {
            return this.formatName(this.setName, null, value);
        }

        public String getSet(String device, String value) {
            return this.formatName(this.setName, device, value);
        }

        public String getGet() {
            return this.formatName(this.getName, null, null);
        }

        public String getRead() {
            return this.formatName(this.readName, null, null);
        }

        @Override
        public int compareTo(IFaceName arg0) {
            return this.getName().toLowerCase().compareTo(arg0.getName().toLowerCase());
        }
    }
}

