/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.main;

import dk.hkj.main.FontAdjust;
import dk.hkj.main.InterfaceThreads;
import dk.hkj.main.PopupBase;
import dk.hkj.main.Support;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

public class PopupShowDevices
extends PopupBase
implements TableModel {
    private static PopupShowDevices showDevicesPopup = null;
    private JPopupMenu popupMenu = null;

    public PopupShowDevices(JComponent pos) {
        PopupShowDevices.closeAll();
        showDevicesPopup = this;
        this.setDefaultCloseOperation(2);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent e) {
                if (PopupShowDevices.this == showDevicesPopup) {
                    showDevicesPopup = null;
                }
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent arg0) {
                if (PopupShowDevices.this == showDevicesPopup) {
                    showDevicesPopup = null;
                }
            }
        });
        this.setTitle("Currently connected devices");
        this.definePopupName("Currently connected devices", true);
        this.addComponentListener(new ComponentListener(){

            @Override
            public void componentHidden(ComponentEvent arg0) {
            }

            @Override
            public void componentMoved(ComponentEvent arg0) {
            }

            @Override
            public void componentResized(ComponentEvent arg0) {
                PopupShowDevices.this.setPreferredSize(PopupShowDevices.this.getMaximumSize());
            }

            @Override
            public void componentShown(ComponentEvent arg0) {
            }
        });
        this.setLocationRelativeTo(pos);
        this.makeMainPanel();
        this.pack();
        this.setVisible(true);
    }

    public static void closeAll() {
        if (showDevicesPopup != null) {
            showDevicesPopup.setVisible(false);
            showDevicesPopup = null;
        }
    }

    private void makeMainPanel() {
        new JPanel();
        final FontAdjust.FontTable table = new FontAdjust.FontTable(){

            @Override
            public Component prepareRenderer(TableCellRenderer renderer, int row, int col) {
                JComponent comp = (JComponent)super.prepareRenderer(renderer, row, col);
                if (!comp.getBackground().equals(Support.colorScheme.selectedCellbackground)) {
                    comp.setBackground(row % 4 == 0 ? Support.colorScheme.tableGridAlternateBackground : Support.colorScheme.textBackground);
                }
                if (col == 0 || col == 1) {
                    comp.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 0));
                    ((JLabel)comp).setHorizontalAlignment(2);
                } else if (comp instanceof JLabel) {
                    ((JLabel)comp).setHorizontalAlignment(0);
                }
                return comp;
            }
        };
        table.setColumnModel(new Support.WidthTableColumnModel(new int[]{120, 250, 120, 120, 100}));
        table.setModel(this);
        Support.colorScheme.selectedCellbackground = table.getSelectionBackground();
        Support.colorScheme.selectedCellForeground = table.getSelectionForeground();
        table.setAutoResizeMode(0);
        Dimension d = new Dimension(750, 200);
        this.setPreferredSize(d);
        this.popupMenu = new JPopupMenu();
        FontAdjust.FontMenuItem mi = new FontAdjust.FontMenuItem("Copy to clipboard");
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PopupShowDevices.this.copyToClipboard();
            }
        });
        this.popupMenu.add(mi);
        JScrollPane sp = new JScrollPane(table);
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        this.add(sp);
        table.addMouseListener(new MouseAdapter(){

            public void checkPopup(MouseEvent arg0) {
                if (arg0.isPopupTrigger()) {
                    PopupShowDevices.this.popupMenu.show(table, arg0.getX(), arg0.getY());
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                this.checkPopup(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.checkPopup(e);
            }
        });
    }

    private void copyToClipboard() {
        StringBuilder sb = new StringBuilder();
        int c = 0;
        while (c < this.getColumnCount()) {
            if (c != 0) {
                sb.append('\t');
            }
            sb.append(this.getColumnName(c));
            ++c;
        }
        sb.append('\n');
        int r = 0;
        while (r < this.getRowCount()) {
            int c2 = 0;
            while (c2 < this.getColumnCount()) {
                if (c2 != 0) {
                    sb.append('\t');
                }
                sb.append(this.getValueAt(r, c2));
                ++c2;
            }
            sb.append('\n');
            ++r;
        }
        try {
            StringSelection stringSelection = new StringSelection(sb.toString());
            Clipboard clpbrd = Toolkit.getDefaultToolkit().getSystemClipboard();
            clpbrd.setContents(stringSelection, null);
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
    }

    @Override
    public void addTableModelListener(TableModelListener arg0) {
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return String.class;
    }

    @Override
    public int getColumnCount() {
        return 5;
    }

    @Override
    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return "Handle";
            }
            case 1: {
                return "Device";
            }
            case 2: {
                return "Serial number";
            }
            case 3: {
                return "Version";
            }
            case 4: {
                return "Address";
            }
        }
        return "";
    }

    @Override
    public int getRowCount() {
        return InterfaceThreads.getDevices().size();
    }

    @Override
    public Object getValueAt(int row, int column) {
        InterfaceThreads.DeviceThread dt = InterfaceThreads.getDevices().get(row);
        switch (column) {
            case 0: {
                return dt.getHandleName();
            }
            case 1: {
                return dt.getDeviceInterface().getDeviceName();
            }
            case 2: {
                return dt.getDeviceInterface().getSerialNumber();
            }
            case 3: {
                return dt.getDeviceInterface().getSoftwareVersion();
            }
            case 4: {
                return dt.cPort.getDeviceName();
            }
        }
        return "";
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
    }

    public static void alignGridAll(int pixels) {
        if (showDevicesPopup != null) {
            showDevicesPopup.alignGrid(pixels);
        }
    }
}

