/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.main;

import dk.hkj.comm.LXIInterface;
import dk.hkj.comm.SocketInterface;
import dk.hkj.devices.SetupFormats;
import dk.hkj.main.DeviceInterface;
import dk.hkj.main.FontAdjust;
import dk.hkj.main.PopupBase;
import dk.hkj.main.Support;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.Timer;

public class PopupSetupSelection
extends PopupBase {
    public static final String DEVICEIP = "DEVICEIP";
    public List<SetupFormats> modes = null;
    public DeviceInterface di;
    private static Map<String, PopupSetupSelection> openWindows = Collections.synchronizedMap(new HashMap());
    private Timer timer;
    private String name = "";
    private List<SetupFormats.SetField> setList = new ArrayList<SetupFormats.SetField>();

    public PopupSetupSelection(DeviceInterface di, JComponent pos) {
        this.di = di;
        this.name = di.getHandleName();
        if (di == null || di.dt == null || di.dt.cPort == null) {
            this.name = String.valueOf(this.name) + " not active";
        }
        this.setDefaultCloseOperation(2);
        PopupSetupSelection pop = openWindows.get(this.name);
        if (pop != null) {
            pop.dispose();
            openWindows.remove(pop);
        }
        openWindows.put(this.name, this);
        this.setResizable(false);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent e) {
                openWindows.remove(PopupSetupSelection.this);
                PopupSetupSelection.this.timer.stop();
                PopupSetupSelection.this.timer = null;
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent arg0) {
                openWindows.remove(PopupSetupSelection.this);
                PopupSetupSelection.this.timer.stop();
                PopupSetupSelection.this.timer = null;
            }
        });
        this.modes = di.getSetupPopupList();
        SetupFormats.optimizeFormList(this.modes);
        this.setTitle(this.name);
        this.definePopupName(String.valueOf(this.name) + "*setup", false);
        this.timer = new Timer(100, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                PopupSetupSelection.this.timerUpdate();
            }
        });
        this.timer.start();
        this.setLocationRelativeTo(pos);
        this.makeMainPanel();
        this.pack();
        this.setVisible(true);
    }

    public String getHelpURL() {
        String s = this.di.def.getItem("#helpurl");
        if (s != null && s.length() > 0) {
            if (s.contains(DEVICEIP)) {
                if (this.di.dt.cPort instanceof SocketInterface || this.di.dt.cPort instanceof LXIInterface) {
                    String ip = this.di.dt.cPort.getName();
                    int i = ip.indexOf(58);
                    if (i > 0) {
                        ip = ip.substring(0, i);
                    }
                    s = s.replace(DEVICEIP, ip);
                } else {
                    return null;
                }
            }
            try {
                new URI(s);
                return s;
            }
            catch (URISyntaxException uRISyntaxException) {}
        }
        return null;
    }

    public void initialSync() {
        SetupFormats.syncAll(this.modes);
        SetupFormats.enableItems(this.modes);
        this.pack();
    }

    private void timerUpdate() {
        this.initialSync();
        this.timer.stop();
    }

    private boolean inList(List<SetupFormats> pages, String page) {
        for (SetupFormats s : pages) {
            if (!s.getPage().equals(page)) continue;
            return true;
        }
        return false;
    }

    private void makeMainPanel() {
        this.setList.clear();
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 3));
        this.add(panel);
        this.di.cacheClear();
        ArrayList<SetupFormats> pages = new ArrayList<SetupFormats>();
        for (SetupFormats mode : this.modes) {
            if (this.inList(pages, mode.getPage())) continue;
            pages.add(mode);
        }
        FontAdjust.FontTabbedPane tabbedPane = new FontAdjust.FontTabbedPane();
        JPanel backPanel = null;
        for (SetupFormats mode : pages) {
            String pageName = mode.getPage();
            if (pageName.length() == 0) {
                backPanel = this.makePanel(pageName);
                continue;
            }
            String name = pageName.replace('_', ' ');
            tabbedPane.addTab(name, this.makePanel(pageName));
            SetupFormats.ColorField colorField = this.getColorField(pageName);
            if (colorField == null) continue;
            tabbedPane.setBackgroundAt(tabbedPane.indexOfTab(name), colorField.getColor());
        }
        if (tabbedPane.getTabCount() > 0) {
            panel.add(tabbedPane);
        }
        if (backPanel != null) {
            panel.add(backPanel);
        }
        for (SetupFormats.SetField sf : this.setList) {
            sf.initControls();
        }
    }

    public void syncAllOff() {
        if (this.modes.size() > 0) {
            this.modes.get(0).syncAllOff();
        }
    }

    public void syncModeChange() {
        if (this.modes.size() > 0) {
            this.modes.get(0).syncModeChange();
        }
    }

    public void setSetupFieldValue(Class controlType, String pageName, String name, String value) {
        if (name == null || value == null) {
            return;
        }
        for (SetupFormats mode : this.modes) {
            if (!controlType.equals(mode.getClass()) || !mode.getPage().equals(pageName) || !mode.getName().equals(name)) continue;
            mode.setSetupFieldValue(value);
        }
    }

    private SetupFormats.ColorField getColorField(String pageName) {
        for (SetupFormats mode : this.modes) {
            if (!(mode instanceof SetupFormats.ColorField) || !mode.getPage().equals(pageName)) continue;
            return (SetupFormats.ColorField)mode;
        }
        return null;
    }

    private JPanel makePanel(String pageName) {
        Support.PosCtlGridBagLayout layout = new Support.PosCtlGridBagLayout();
        JPanel panel = new JPanel();
        panel.setLayout(layout);
        SetupFormats.ColorField colorField = this.getColorField(pageName);
        if (colorField != null) {
            panel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(colorField.getColor(), 5), BorderFactory.createEmptyBorder(3, 3, 3, 3)));
            Color bgcolor = colorField.getBGColor();
            if (bgcolor != null) {
                panel.setBackground(bgcolor);
            }
        }
        int maxColumns = 1;
        for (SetupFormats mode : this.modes) {
            if (!mode.getPage().equals(pageName)) continue;
            maxColumns = Math.max(maxColumns, mode.getColumns());
        }
        int row = 0;
        for (SetupFormats mode : this.modes) {
            if (!mode.getPage().equals(pageName)) continue;
            int n = mode.addGridBag(this, panel, row, maxColumns);
            if (mode instanceof SetupFormats.SetField) {
                this.setList.add((SetupFormats.SetField)mode);
            }
            if (mode.getColumns() <= 0) continue;
            row += n;
        }
        JPanel p = new JPanel();
        p.add(panel);
        return p;
    }

    public List<String> generateScript() {
        ArrayList<String> list = new ArrayList<String>();
        if (this.isVisible()) {
            list.add("#ShowPopupSetup " + this.di.getHandleName() + " " + this.generateLocationParams() + (this.isOnTop() ? "  onTop" : ""));
        }
        return list;
    }
}

