/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.main;

import dk.hkj.main.FontAdjust;
import dk.hkj.main.InterfaceThreads;
import dk.hkj.main.PopupBaseFrame;
import dk.hkj.main.PopupGridPanel;
import dk.hkj.main.PopupNotes;
import dk.hkj.main.ScriptMenu;
import dk.hkj.main.Support;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

public class PopupScriptList
extends PopupBaseFrame
implements TableModel,
ActionListener {
    private static PopupScriptList popupScriptList = null;
    private boolean sortOnFile = false;
    private List<ScriptMenu.ScriptEntry> scripts = null;
    private List<TableModelListener> tableModelListener = new ArrayList<TableModelListener>();
    JCheckBox includeSystemCheckbox = null;
    JButton editButton = null;
    JButton deleteButton = null;
    JButton viewButton = null;
    JButton copyButton = null;
    JButton sortNameButton = null;
    JButton sortFileButton = null;
    JButton reloadButton = null;
    JTable table = null;

    public PopupScriptList() {
        PopupScriptList.closeAll();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                if (popupScriptList == PopupScriptList.this) {
                    PopupScriptList.popupScriptList = null;
                }
            }

            @Override
            public void windowActivated(WindowEvent arg0) {
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent e) {
                if (popupScriptList == PopupScriptList.this) {
                    PopupScriptList.popupScriptList = null;
                }
            }
        });
        popupScriptList = this;
        this.setDefaultCloseOperation(2);
        this.setTitle("Script list");
        this.definePopupName("ScriptList", true);
        this.setMinimumSize(new Dimension(770, 450));
        this.setPreferredSize(new Dimension(770, 450));
        this.scripts = Support.paneCommand.scriptMenu.getScriptList(true, false);
        this.sort();
        this.add(this.generateLayout());
    }

    private JPanel generateLayout() {
        this.table = new FontAdjust.FontTable(){

            @Override
            public Component prepareRenderer(TableCellRenderer renderer, int row, int col) {
                Component comp = super.prepareRenderer(renderer, row, col);
                if (comp instanceof JLabel) {
                    JLabel label = (JLabel)comp;
                    if (col == 0) {
                        label.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 0));
                        label.setHorizontalAlignment(2);
                    } else {
                        label.setHorizontalAlignment(0);
                    }
                }
                if (!comp.getBackground().equals(Support.colorScheme.selectedCellbackground)) {
                    comp.setBackground(row % 4 == 0 ? Support.colorScheme.tableGridAlternateBackground : Support.colorScheme.textBackground);
                }
                if (!(col != 2 || InterfaceThreads.loadDeviceConfig.getIndex(row) != null && InterfaceThreads.loadDeviceConfig.getIndex(row).isValid())) {
                    comp.setBackground(Support.colorScheme.errorBackground);
                }
                return comp;
            }
        };
        Support.colorScheme.selectedCellbackground = this.table.getSelectionBackground();
        Support.colorScheme.selectedCellForeground = this.table.getSelectionForeground();
        this.table.setAutoResizeMode(0);
        this.table.setColumnModel(new Support.WidthTableColumnModel(new int[]{310, 250, 60, 110}));
        this.table.setModel(this);
        JScrollPane sp = new JScrollPane(this.table);
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 10.0;
        c.weighty = 10.0;
        c.fill = 1;
        panel.add((Component)sp, c);
        FontAdjust.FontPanel uiPanel = new FontAdjust.FontPanel();
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 1;
        c.fill = 2;
        c.anchor = 17;
        c.weightx = 10.0;
        panel.add((Component)uiPanel, c);
        this.includeSystemCheckbox = new FontAdjust.FontCheckBox("Include system");
        this.includeSystemCheckbox.setToolTipText("Include scripts from my server, these cannot be edited or deleted");
        this.includeSystemCheckbox.setActionCommand("include");
        this.includeSystemCheckbox.addActionListener(this);
        uiPanel.add(this.includeSystemCheckbox);
        uiPanel.add(Box.createHorizontalStrut(20));
        this.viewButton = new FontAdjust.FontButton("View");
        this.viewButton.setToolTipText("View selected script(s)");
        this.viewButton.setActionCommand("view");
        this.viewButton.addActionListener(this);
        uiPanel.add(this.viewButton);
        this.copyButton = new FontAdjust.FontButton("Copy");
        this.copyButton.setToolTipText("Copy selected script(s) to clipboard");
        this.copyButton.setActionCommand("copy");
        this.copyButton.addActionListener(this);
        uiPanel.add(this.copyButton);
        this.editButton = new FontAdjust.FontButton("Edit");
        this.editButton.setToolTipText("Open files for selected script(s) in editor");
        this.editButton.setActionCommand("edit");
        this.editButton.addActionListener(this);
        uiPanel.add(this.editButton);
        this.deleteButton = new FontAdjust.FontButton("Delete");
        this.deleteButton.setToolTipText("Delete file with selected script, all other scripts in that file will also be deleted");
        this.deleteButton.setActionCommand("delete");
        this.deleteButton.addActionListener(this);
        uiPanel.add(this.deleteButton);
        uiPanel.add(Box.createHorizontalStrut(20));
        this.sortNameButton = new FontAdjust.FontButton("Sort name");
        this.sortNameButton.setToolTipText("Scripts are sorted based on name");
        this.sortNameButton.setActionCommand("sortname");
        this.sortNameButton.addActionListener(this);
        uiPanel.add(this.sortNameButton);
        this.sortFileButton = new FontAdjust.FontButton("Sort file");
        this.sortFileButton.setToolTipText("Scripts are sorted based on filename, then name");
        this.sortFileButton.setActionCommand("sortfile");
        this.sortFileButton.addActionListener(this);
        uiPanel.add(this.sortFileButton);
        uiPanel.add(Box.createHorizontalStrut(20));
        this.reloadButton = new FontAdjust.FontButton("Reload");
        this.reloadButton.setToolTipText("Reload all scripts from disk");
        this.reloadButton.setActionCommand("reload");
        this.reloadButton.addActionListener(this);
        uiPanel.add(this.reloadButton);
        return panel;
    }

    public static PopupScriptList getPopup() {
        Point p = Support.paneCommand.popupsButton.getLocationOnScreen();
        p.translate(-600, -300);
        if (p.y < 0) {
            p.y = 0;
        }
        PopupScriptList psl = new PopupScriptList();
        psl.setLocation(p);
        psl.setVisible(true);
        return psl;
    }

    @Override
    public void addTableModelListener(TableModelListener arg0) {
        this.tableModelListener.add(arg0);
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return String.class;
            }
            case 1: {
                return String.class;
            }
            case 2: {
                return Integer.class;
            }
            case 3: {
                return String.class;
            }
        }
        return String.class;
    }

    @Override
    public int getColumnCount() {
        return 4;
    }

    @Override
    public String getColumnName(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return "Name";
            }
            case 1: {
                return "File";
            }
            case 2: {
                return "Lines";
            }
            case 3: {
                return "Filters";
            }
        }
        return "";
    }

    @Override
    public int getRowCount() {
        return this.scripts.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        ScriptMenu.ScriptEntry se = this.scripts.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return se.getName().replaceAll(";", " - ");
            }
            case 1: {
                return se.getFileName();
            }
            case 2: {
                return se.getSize();
            }
            case 3: {
                return se.getFilters();
            }
            case 4: {
                return "";
            }
        }
        return "";
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
        this.tableModelListener.remove(l);
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
    }

    public void fireChange(TableModelEvent e) {
        for (TableModelListener tml : this.tableModelListener) {
            tml.tableChanged(e);
        }
    }

    private void sort() {
        if (this.sortOnFile) {
            this.scripts.sort(new Comparator<ScriptMenu.ScriptEntry>(){

                @Override
                public int compare(ScriptMenu.ScriptEntry o1, ScriptMenu.ScriptEntry o2) {
                    int i = o1.getFileName().compareTo(o2.getFileName());
                    if (i == 0) {
                        i = o1.getName().compareTo(o2.getName());
                    }
                    return i;
                }
            });
        } else {
            this.scripts.sort(new Comparator<ScriptMenu.ScriptEntry>(){

                @Override
                public int compare(ScriptMenu.ScriptEntry o1, ScriptMenu.ScriptEntry o2) {
                    return o1.getName().compareTo(o2.getName());
                }
            });
        }
    }

    protected void toClipboard(String data) {
        Clipboard clpbrd = Toolkit.getDefaultToolkit().getSystemClipboard();
        StringSelection stringSelection = new StringSelection(data);
        clpbrd.setContents(stringSelection, null);
    }

    private String getScripts() {
        StringBuilder sb = new StringBuilder();
        int n = this.table.getSelectedRowCount();
        int i = 0;
        while (i < this.getRowCount()) {
            if (this.table.isRowSelected(i)) {
                if (n == 1) {
                    sb.append(this.scripts.get(i).getFilteredScript());
                } else {
                    if (sb.length() > 0) {
                        sb.append("\n\n\n");
                    }
                    sb.append(this.scripts.get(i).getScript());
                }
            }
            ++i;
        }
        return sb.toString();
    }

    private void copy() {
        String s = this.getScripts();
        if (s.isEmpty()) {
            JOptionPane.showMessageDialog(this, "No scripts to copy", "Copy scripts", 1);
            return;
        }
        this.toClipboard(s);
    }

    private void view() {
        String s = this.getScripts();
        if (s.isEmpty()) {
            JOptionPane.showMessageDialog(this, "No scripts to view", "View scripts", 1);
            return;
        }
        PopupNotes popupNotes = new PopupNotes("View scripts", s);
        popupNotes.setLocationRelativeTo(this);
        popupNotes.setVisible(true);
    }

    private void edit() {
        HashMap<String, File> fnames = new HashMap<String, File>();
        int i = 0;
        while (i < this.getRowCount()) {
            ScriptMenu.ScriptEntry se;
            if (this.table.isRowSelected(i) && !(se = this.scripts.get(i)).isSystem()) {
                fnames.put(se.getFileName(), se.getFile());
            }
            ++i;
        }
        if (fnames.size() == 0) {
            JOptionPane.showMessageDialog(this, "No files to edit", "Edit files", 1);
            return;
        }
        try {
            Desktop dt = Desktop.getDesktop();
            if (dt != null) {
                for (File f : fnames.values()) {
                    dt.open(f);
                }
            }
        }
        catch (Exception exception) {}
    }

    private List<String> getScriptsInFile(String fname) {
        ArrayList<String> list = new ArrayList<String>();
        for (ScriptMenu.ScriptEntry se : this.scripts) {
            if (!se.getFileName().equals(fname)) continue;
            list.add(se.getName().replaceAll(";", " - "));
        }
        return list;
    }

    private void delete() {
        HashMap<String, File> fnames = new HashMap<String, File>();
        int i = 0;
        while (i < this.getRowCount()) {
            ScriptMenu.ScriptEntry se;
            if (this.table.isRowSelected(i) && !(se = this.scripts.get(i)).isSystem()) {
                fnames.put(se.getFileName(), se.getFile());
            }
            ++i;
        }
        ArrayList<String> scriptNames = new ArrayList<String>();
        for (String fname : fnames.keySet()) {
            scriptNames.addAll(this.getScriptsInFile(fname));
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<html><body width=400><h1>Delete</h1>");
        sb.append("<h2>" + scriptNames.size() + " Scripts:</h2>");
        boolean first = true;
        for (String s : scriptNames) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append(s);
        }
        sb.append("<h2>" + fnames.size() + " Files:</h2>");
        first = true;
        for (String s : fnames.keySet()) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append(s);
        }
        if (fnames.size() == 0) {
            JOptionPane.showMessageDialog(this, "No files to delete", "Delete script & files", 1);
            return;
        }
        if (JOptionPane.showConfirmDialog(null, sb.toString(), "Delete script & files", 0, 2) != 0) {
            return;
        }
        try {
            for (File f : fnames.values()) {
                f.delete();
            }
        }
        catch (Exception exception) {}
    }

    private void reload() {
        Support.paneCommand.scriptMenu.reload();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("include")) {
            this.scripts = Support.paneCommand.scriptMenu.getScriptList(true, this.includeSystemCheckbox.isSelected());
            this.sort();
            this.fireChange(new TableModelEvent(this));
        } else if (e.getActionCommand().equals("view")) {
            this.view();
        } else if (e.getActionCommand().equals("copy")) {
            this.copy();
        } else if (e.getActionCommand().equals("edit")) {
            this.edit();
        } else if (e.getActionCommand().equals("delete")) {
            this.delete();
            this.reload();
            this.scripts = Support.paneCommand.scriptMenu.getScriptList(true, this.includeSystemCheckbox.isSelected());
            PopupGridPanel.systemStateChanged();
            this.sort();
            this.fireChange(new TableModelEvent(this));
        } else if (e.getActionCommand().equals("sortname")) {
            this.sortOnFile = false;
            this.sort();
            this.fireChange(new TableModelEvent(this));
        } else if (e.getActionCommand().equals("sortfile")) {
            this.sortOnFile = true;
            this.sort();
            this.fireChange(new TableModelEvent(this));
        } else if (e.getActionCommand().equals("reload")) {
            this.reload();
            this.scripts = Support.paneCommand.scriptMenu.getScriptList(true, this.includeSystemCheckbox.isSelected());
            PopupGridPanel.systemStateChanged();
            this.sort();
            this.fireChange(new TableModelEvent(this));
        }
    }

    public static void closeAll() {
        if (popupScriptList != null) {
            popupScriptList.setVisible(false);
            popupScriptList = null;
        }
    }

    public static List<String> generateScript() {
        ArrayList<String> list = new ArrayList<String>();
        if (popupScriptList != null) {
            list.add("#ShowPopupSystem ScriptList " + popupScriptList.generateLocationParams());
        }
        return list;
    }

    public static void alignGridAll(int pixels) {
        if (popupScriptList != null && popupScriptList.isVisible()) {
            popupScriptList.alignGrid(pixels);
        }
    }
}

