/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.main;

import dk.hkj.color.ColorUtil;
import dk.hkj.main.DeviceInterface;
import dk.hkj.main.FontAdjust;
import dk.hkj.main.InterfaceThreads;
import dk.hkj.main.Mathematics;
import dk.hkj.main.Support;
import dk.hkj.main.ValueFormat;
import dk.hkj.util.FileUtil;
import dk.hkj.vars.Var;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.RoundRectangle2D;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class PopupReadout
extends JDialog
implements ActionListener {
    private Timer timer;
    private JLabel label;
    private boolean dragging = false;
    private int ofsx = 0;
    private int ofsy = 0;
    private JPopupMenu popupMenu;
    private static final String measureText = "-8.888A";
    private static List<PopupReadout> popupList = new ArrayList<PopupReadout>();
    private static Map<Integer, PopupSettings> popupSettings = new HashMap<Integer, PopupSettings>();
    private PopupSettings settings = null;
    private boolean firstTime = true;
    MouseMotionListener myMouseMotionListener = new MouseMotionListener(){

        @Override
        public void mouseDragged(MouseEvent e) {
            if (PopupReadout.this.dragging) {
                int x = e.getX() + PopupReadout.this.getLocationOnScreen().x;
                int y = e.getY() + PopupReadout.this.getLocationOnScreen().y;
                ((PopupReadout)PopupReadout.this).settings.x = x - PopupReadout.this.ofsx;
                ((PopupReadout)PopupReadout.this).settings.y = y - PopupReadout.this.ofsy;
                PopupReadout.this.setLocation(((PopupReadout)PopupReadout.this).settings.x, ((PopupReadout)PopupReadout.this).settings.y);
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
        }
    };
    MouseListener myMouseListener = new MouseAdapter(){

        private void checkPopup(MouseEvent e) {
            if (e.isPopupTrigger()) {
                PopupReadout.this.dragging = false;
                PopupReadout.this.makePopup();
                PopupReadout.this.popupMenu.show(PopupReadout.this.label, e.getX(), e.getY());
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.getButton() == 1) {
                PopupReadout.this.dragging = true;
                PopupReadout.this.ofsx = e.getX();
                PopupReadout.this.ofsy = e.getY();
            }
            this.checkPopup(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (e.getButton() == 1) {
                PopupReadout.this.dragging = false;
                PopupReadout.this.saveDefault();
            }
            this.checkPopup(e);
        }
    };

    public static PopupReadout getPopup(String name) {
        for (PopupReadout pr : popupList) {
            if (!pr.settings.valueName.equals(name)) continue;
            return pr;
        }
        return null;
    }

    public void setFormSize(String txt, boolean force) {
        AffineTransform affinetransform = new AffineTransform();
        FontRenderContext frc = new FontRenderContext(affinetransform, true, true);
        Font font = this.label.getFont();
        int w = (int)font.getStringBounds(txt, frc).getWidth() + 30;
        if (force || w > this.getWidth()) {
            int h = (int)font.getStringBounds(txt, frc).getHeight();
            Dimension dim = new Dimension(w, h);
            this.setMinimumSize(dim);
            this.setPreferredSize(dim);
            this.setSize(dim);
        }
    }

    public static synchronized void closeAll() {
        while (popupList.size() > 0) {
            PopupReadout pr = popupList.get(0);
            if (pr.isVisible()) {
                pr.setVisible(false);
            }
            popupList.remove(pr);
        }
    }

    private boolean isPopupNoInList(int popupNo) {
        for (PopupReadout pr : popupList) {
            if (pr.settings == null || pr.settings.popupNo != popupNo) continue;
            return true;
        }
        return false;
    }

    private PopupSettings findSetting(int popupNo) {
        PopupSettings ps = popupSettings.get(popupNo);
        if (ps != null) {
            return ps;
        }
        ps = popupSettings.get(0);
        ps = ps == null ? new PopupSettings() : ps.clone();
        ps.popupNo = popupNo;
        popupSettings.put(popupNo, ps);
        return ps;
    }

    private int findNumber() {
        if (popupList.size() == 0) {
            return 0;
        }
        int i = 0;
        while (this.isPopupNoInList(i)) {
            ++i;
        }
        return i;
    }

    public PopupReadout() {
        this.setAlwaysOnTop(true);
        popupList.add(this);
        if (popupSettings.size() == 0) {
            this.loadDefault();
        }
        this.setTitle("Readout");
        this.setDefaultCloseOperation(2);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent e) {
                if (PopupReadout.this.timer != null) {
                    PopupReadout.this.timer.stop();
                    PopupReadout.this.timer = null;
                }
                Support.math.removeDomain("Readout");
                popupList.remove(PopupReadout.this);
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent arg0) {
                if (PopupReadout.this.timer != null) {
                    PopupReadout.this.timer.stop();
                    PopupReadout.this.timer = null;
                }
                Support.math.removeDomain("Readout");
                popupList.remove(PopupReadout.this);
            }
        });
        this.settings = this.findSetting(this.findNumber());
        this.setDefaultCloseOperation(2);
        boolean found = false;
        List<String> channels = InterfaceThreads.listChannels(true);
        if (channels != null && channels.size() > 0) {
            for (String s : channels) {
                if (!this.settings.valueName.equals(s)) continue;
                found = true;
                break;
            }
            if (!found) {
                this.settings.valueName = channels.get(0);
            }
        }
        this.timer = new Timer(50, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                PopupReadout.this.timerUpdate();
            }
        });
        this.timer.setInitialDelay(50);
        this.timer.setDelay(200);
        this.timer.start();
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                PopupReadout.this.setShape(new RoundRectangle2D.Float(0.0f, 0.0f, PopupReadout.this.getWidth(), PopupReadout.this.getHeight(), (float)PopupReadout.this.getWidth() / 10.0f, (float)PopupReadout.this.getWidth() / 10.0f));
            }
        });
        this.addMouseMotionListener(this.myMouseMotionListener);
        this.addMouseListener(this.myMouseListener);
        this.makePanel();
        this.setUndecorated(true);
        this.settings.apply(this);
        this.pack();
        this.setVisible(true);
        Support.addUsedFunction("Readout");
    }

    private void makePanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.setBackground(new Color(1.0f, 1.0f, 1.0f, 0.0f));
        panel.addMouseMotionListener(this.myMouseMotionListener);
        panel.addMouseListener(this.myMouseListener);
        this.label = new JLabel(measureText){

            @Override
            public void paintComponent(Graphics g) {
                Graphics2D g2 = (Graphics2D)g;
                g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
                g2.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
                g2.setBackground(((PopupReadout)PopupReadout.this).settings.bc);
                g2.clearRect(0, 0, this.getSize().width, this.getSize().height);
                super.paintComponent(g2);
            }
        };
        this.label.addMouseMotionListener(this.myMouseMotionListener);
        this.label.addMouseListener(this.myMouseListener);
        this.label.setHorizontalAlignment(0);
        this.label.setBorder(null);
        this.label.setToolTipText("Click an hold to move, right click to configurate");
        Support.math.resetCalc("Readout");
        this.popupMenu = new JPopupMenu();
        panel.add(this.label);
        this.add(panel);
    }

    private void makePopup() {
        JMenuItem mi;
        this.popupMenu.removeAll();
        FontAdjust.FontMenu menu = new FontAdjust.FontMenu("Value");
        this.popupMenu.add(menu);
        for (InterfaceThreads.DeviceThread dt : InterfaceThreads.getDevices()) {
            for (String s : dt.getValueNames()) {
                mi = new FontAdjust.FontRadioButtonMenuItem(s);
                mi.setActionCommand("Value:" + s);
                mi.setSelected(this.settings.valueName.equals(s));
                mi.addActionListener(this);
                menu.add(mi);
            }
        }
        for (Mathematics.MathEntry me : Support.math.getEnabledMathEntries()) {
            mi = new FontAdjust.FontRadioButtonMenuItem(me.getFullName());
            mi.setActionCommand("Value:" + me.getFullName());
            mi.setSelected(this.settings.valueName.equals(me.getFullName()));
            mi.addActionListener(this);
            menu.add(mi);
        }
        menu = new FontAdjust.FontMenu("Size");
        this.popupMenu.add(menu);
        mi = new FontAdjust.FontRadioButtonMenuItem("1");
        mi.setActionCommand("F1");
        mi.setSelected(this.settings.fontSize == 1.0);
        mi.addActionListener(this);
        menu.add(mi);
        mi = new FontAdjust.FontRadioButtonMenuItem("2");
        mi.setActionCommand("F1.5");
        mi.setSelected(this.settings.fontSize == 1.5);
        mi.addActionListener(this);
        menu.add(mi);
        mi = new FontAdjust.FontRadioButtonMenuItem("3");
        mi.setActionCommand("F2.2");
        mi.setSelected(this.settings.fontSize == 2.2);
        mi.addActionListener(this);
        menu.add(mi);
        mi = new FontAdjust.FontRadioButtonMenuItem("4");
        mi.setActionCommand("F3.4");
        mi.setSelected(this.settings.fontSize == 3.4);
        mi.addActionListener(this);
        menu.add(mi);
        mi = new FontAdjust.FontRadioButtonMenuItem("5");
        mi.setActionCommand("F5.1");
        mi.setSelected(this.settings.fontSize == 5.1);
        mi.addActionListener(this);
        menu.add(mi);
        mi = new FontAdjust.FontRadioButtonMenuItem("6");
        mi.setActionCommand("F7.6");
        mi.setSelected(this.settings.fontSize == 7.6);
        mi.addActionListener(this);
        menu.add(mi);
        mi = new FontAdjust.FontRadioButtonMenuItem("7");
        mi.setActionCommand("F12");
        mi.setSelected(this.settings.fontSize == 12.0);
        mi.addActionListener(this);
        menu.add(mi);
        menu = new FontAdjust.FontMenu("Transparent");
        this.popupMenu.add(menu);
        mi = new FontAdjust.FontRadioButtonMenuItem("Fully");
        mi.setActionCommand("T0");
        mi.setSelected(this.settings.bc.getAlpha() == 0);
        mi.addActionListener(this);
        menu.add(mi);
        mi = new FontAdjust.FontRadioButtonMenuItem("Fully, with background");
        mi.setActionCommand("T1");
        mi.setSelected(this.settings.bc.getAlpha() == 1);
        mi.addActionListener(this);
        menu.add(mi);
        mi = new FontAdjust.FontRadioButtonMenuItem("Light");
        mi.setActionCommand("T30");
        mi.setSelected(this.settings.bc.getAlpha() == 30);
        mi.addActionListener(this);
        menu.add(mi);
        mi = new FontAdjust.FontRadioButtonMenuItem("Partially");
        mi.setActionCommand("T90");
        mi.setSelected(this.settings.bc.getAlpha() == 90);
        mi.addActionListener(this);
        menu.add(mi);
        mi = new FontAdjust.FontRadioButtonMenuItem("Opaque");
        mi.setActionCommand("T255");
        mi.setSelected(this.settings.bc.getAlpha() == 255);
        mi.addActionListener(this);
        menu.add(mi);
        mi = new FontAdjust.FontMenuItem("Text color");
        mi.setActionCommand("FC");
        mi.addActionListener(this);
        this.popupMenu.add(mi);
        mi = new FontAdjust.FontMenuItem("Background color");
        mi.setActionCommand("BC");
        mi.addActionListener(this);
        this.popupMenu.add(mi);
        ValueFormat.formatMenu(this.popupMenu, "Format", "FOR:", this.settings.overrideFormat, true, false, this);
        mi = new FontAdjust.FontMenuItem("Align");
        mi.setActionCommand("Align");
        mi.addActionListener(this);
        this.popupMenu.add(mi);
        mi = new FontAdjust.FontMenuItem("Close");
        mi.setActionCommand("Close");
        mi.addActionListener(this);
        this.popupMenu.add(mi);
    }

    public void alignGrid(int pixels) {
        int x = this.getLocationOnScreen().x / pixels * pixels + (pixels - 1) / 2;
        int y = this.getLocationOnScreen().y / pixels * pixels + (pixels - 1) / 2;
        this.setLocation(x, y);
    }

    private void timerUpdate() {
        if (this.firstTime) {
            this.settings.applyLocation(this);
            this.firstTime = false;
        }
        try {
            String s;
            boolean valueValid = false;
            InterfaceThreads.setupVars();
            DeviceInterface di = InterfaceThreads.getLoadedDeviceInterfaceHandle(this.settings.valueName);
            Mathematics.MathEntry me = null;
            ValueFormat fmt = null;
            if (di != null) {
                List<String> vn = di.getValueNameList();
                if (vn.size() == 1) {
                    s = String.valueOf(di.getHandleName()) + "." + vn.get(0);
                    if (!s.equals(this.settings.valueName)) {
                        this.settings.valueName = s;
                        this.setFormSize(measureText, true);
                    }
                    valueValid = true;
                } else {
                    s = this.settings.valueName.substring(di.getHandleName().length() + 1);
                    valueValid = vn.contains(s);
                }
                fmt = di.getValueFormat(this.settings.valueName);
            } else {
                int i = this.settings.valueName.indexOf(46);
                if (i > 0) {
                    me = Support.math.getEntry(this.settings.valueName.substring(i + 1));
                }
                boolean bl = valueValid = me != null && me.isEnabled();
                if (valueValid) {
                    Var.gl.getCreate(this.settings.valueName).set(me.calcDirect("Readout", (double)System.currentTimeMillis() / 1000.0));
                    fmt = me.getValueFormat();
                }
            }
            if (valueValid) {
                Var v = Var.gl.get(this.settings.valueName);
                s = this.settings.overrideFormat != null ? String.valueOf(this.settings.overrideFormat.formatDisplay(v.asDouble())) + fmt.unit.replace("_", "") : String.valueOf(fmt.format.formatDisplay(v.asDouble())) + fmt.unit.replace("_", "");
                if (s.replace("-", "").trim().length() == 0) {
                    s = "---";
                }
                this.label.setText(s);
                this.setFormSize(s, false);
            } else {
                this.label.setText("----");
            }
        }
        catch (Exception exception) {
            this.label.setText("----");
        }
        this.repaint();
    }

    private void align() {
        ArrayList<PopupReadout> list = new ArrayList<PopupReadout>();
        int rangex = this.getSize().width / 2;
        int x = this.settings.x;
        for (PopupReadout pr : popupList) {
            if (Math.abs(pr.settings.x - x) >= rangex) continue;
            pr.settings.x = x;
            list.add(pr);
        }
        if (list.size() > 1) {
            list.sort(new Comparator<PopupReadout>(){

                @Override
                public int compare(PopupReadout arg0, PopupReadout arg1) {
                    if (((PopupReadout)arg0).settings.y < ((PopupReadout)arg1).settings.y) {
                        return -1;
                    }
                    if (((PopupReadout)arg0).settings.y > ((PopupReadout)arg1).settings.y) {
                        return 1;
                    }
                    return 0;
                }
            });
            int ii = -1;
            int i = 0;
            while (i < list.size()) {
                if (((PopupReadout)list.get((int)i)).settings == this.settings) {
                    ii = i;
                    break;
                }
                ++i;
            }
            i = ii + 1;
            while (i < list.size()) {
                ((PopupReadout)list.get((int)i)).settings.y = ((PopupReadout)list.get((int)(i - 1))).settings.y + ((PopupReadout)list.get((int)(i - 1))).getSize().height + 5;
                ((PopupReadout)list.get(i)).setLocation(((PopupReadout)list.get((int)i)).settings.x, ((PopupReadout)list.get((int)i)).settings.y);
                ++i;
            }
            i = ii - 1;
            while (i >= 0) {
                ((PopupReadout)list.get((int)i)).settings.y = ((PopupReadout)list.get((int)(i + 1))).settings.y - ((PopupReadout)list.get((int)i)).getSize().height - 5;
                ((PopupReadout)list.get(i)).setLocation(((PopupReadout)list.get((int)i)).settings.x, ((PopupReadout)list.get((int)i)).settings.y);
                --i;
            }
        }
        list.clear();
        int rangey = this.getSize().height * 2 / 3;
        int y = this.settings.y;
        for (PopupReadout pr : popupList) {
            if (Math.abs(pr.settings.y - y) >= rangey) continue;
            pr.settings.y = y;
            list.add(pr);
        }
        if (list.size() > 1) {
            list.sort(new Comparator<PopupReadout>(){

                @Override
                public int compare(PopupReadout arg0, PopupReadout arg1) {
                    if (((PopupReadout)arg0).settings.x < ((PopupReadout)arg1).settings.x) {
                        return -1;
                    }
                    if (((PopupReadout)arg0).settings.x > ((PopupReadout)arg1).settings.x) {
                        return 1;
                    }
                    return 0;
                }
            });
            int ii = -1;
            int i = 0;
            while (i < list.size()) {
                if (((PopupReadout)list.get((int)i)).settings == this.settings) {
                    ii = i;
                    break;
                }
                ++i;
            }
            i = ii + 1;
            while (i < list.size()) {
                ((PopupReadout)list.get((int)i)).settings.x = ((PopupReadout)list.get((int)(i - 1))).settings.x + ((PopupReadout)list.get((int)(i - 1))).getSize().width + 5;
                ((PopupReadout)list.get(i)).setLocation(((PopupReadout)list.get((int)i)).settings.x, ((PopupReadout)list.get((int)i)).settings.y);
                ++i;
            }
            i = ii - 1;
            while (i >= 0) {
                ((PopupReadout)list.get((int)i)).settings.x = ((PopupReadout)list.get((int)(i + 1))).settings.x - ((PopupReadout)list.get((int)i)).getSize().width - 5;
                ((PopupReadout)list.get(i)).setLocation(((PopupReadout)list.get((int)i)).settings.x, ((PopupReadout)list.get((int)i)).settings.y);
                --i;
            }
        }
        this.saveDefault();
    }

    public PopupSettings getSettings() {
        return this.settings;
    }

    public void applySettings() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.applySettingsSync();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PopupReadout.this.applySettingsSync();
                }
            });
        }
    }

    private void applySettingsSync() {
        this.settings.apply(this);
        if (!this.firstTime) {
            this.settings.applyLocation(this);
        }
    }

    public void setFormat(String format) {
        this.settings.overrideFormat = format.isEmpty() || format.equalsIgnoreCase("default") ? null : ValueFormat.getFormatter(format);
        this.setFormSize(measureText, true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("FC")) {
            Color c = JColorChooser.showDialog(this, "Foreground Color", this.settings.fc);
            if (c != null) {
                this.settings.fc = c;
                this.settings.apply(this);
            }
        } else if (e.getActionCommand().equals("BC")) {
            Color c = JColorChooser.showDialog(this, "Background Color", this.settings.bc);
            if (c != null) {
                this.settings.bc = c;
                this.settings.apply(this);
            }
        } else if (e.getActionCommand().startsWith("FOR:")) {
            String f = e.getActionCommand().substring(4);
            this.setFormat(f);
        } else if (e.getActionCommand().equals("Close")) {
            this.setVisible(false);
            this.timer.stop();
            this.dispose();
            popupList.remove(this);
        } else if (e.getActionCommand().equals("Align")) {
            this.align();
        } else if (e.getActionCommand().matches("T[0-9]+")) {
            int alpha = Integer.parseInt(e.getActionCommand().substring(1));
            this.settings.bc = new Color((float)this.settings.bc.getRed() / 255.0f, (float)this.settings.bc.getGreen() / 255.0f, (float)this.settings.bc.getBlue() / 255.0f, (float)alpha / 255.0f);
            this.settings.apply(this);
        } else if (e.getActionCommand().matches("F[0-9.]+")) {
            this.settings.fontSize = Double.parseDouble(e.getActionCommand().substring(1));
            this.settings.apply(this);
        } else if (e.getActionCommand().startsWith("Value:")) {
            this.settings.valueName = e.getActionCommand().substring(6);
            this.settings.apply(this);
            this.setFormSize(measureText, true);
            this.timerUpdate();
        }
    }

    public void saveToFile(File file) {
        ArrayList<String> list = new ArrayList<String>();
        for (PopupSettings r : popupSettings.values()) {
            list.add(r.toString());
        }
        try {
            FileUtil.writeFile(file, list);
        }
        catch (IOException iOException) {}
    }

    public void loadFromFile(File file) {
        try {
            List<String> list = FileUtil.readFileAsList(file);
            for (String line : list) {
                if ((line = line.trim()).length() <= 0 || line.startsWith(";") || !line.contains("|")) continue;
                PopupSettings ps = new PopupSettings(line);
                popupSettings.put(ps.popupNo, ps);
            }
        }
        catch (IOException iOException) {}
    }

    public void saveDefault() {
        this.saveToFile(new File(String.valueOf(Support.getConfigPath()) + "/settingsReadouts.txt"));
    }

    public void loadDefault() {
        this.loadFromFile(new File(String.valueOf(Support.getConfigPath()) + "/settingsReadouts.txt"));
    }

    public static List<String> generateScript() {
        ArrayList<String> list = new ArrayList<String>();
        for (PopupReadout p : popupList) {
            list.add("#Readout " + p.settings.valueName + " " + p.getLocationOnScreen().x + " " + p.getLocationOnScreen().y + " " + p.settings.fontSize + " " + ColorUtil.colorToName(p.settings.fc) + " " + ColorUtil.colorToName(p.settings.bc) + " " + p.settings.bc.getAlpha() + (p.settings.overrideFormat != null ? " " + p.settings.overrideFormat.getName() : ""));
        }
        return list;
    }

    public static void alignGridAll(int pixels) {
        for (PopupReadout p : popupList) {
            p.alignGrid(pixels);
        }
    }

    static class PopupSettings {
        String valueName;
        int popupNo;
        double fontSize;
        int x;
        int y;
        Color fc;
        Color bc;
        ValueFormat.ValueFormatter overrideFormat = null;

        PopupSettings(String line) {
            for (Support.ConfigLineElement element : new Support.ConfigLineSplitter(line)) {
                int a;
                int b;
                int g;
                int r;
                String[] s;
                if (element.name.equals("Value")) {
                    this.valueName = element.value;
                    continue;
                }
                if (element.name.equals("Size")) {
                    this.fontSize = Double.parseDouble(element.value);
                    continue;
                }
                if (element.name.equals("No")) {
                    this.popupNo = Integer.parseInt(element.value);
                    continue;
                }
                if (element.name.equals("FC")) {
                    s = element.value.split("[,]");
                    r = Integer.parseInt(s[0]);
                    g = Integer.parseInt(s[1]);
                    b = Integer.parseInt(s[2]);
                    a = Integer.parseInt(s[3]);
                    this.fc = new Color(r, g, b, a);
                    continue;
                }
                if (element.name.equals("BC")) {
                    s = element.value.split("[,]");
                    r = Integer.parseInt(s[0]);
                    g = Integer.parseInt(s[1]);
                    b = Integer.parseInt(s[2]);
                    a = Integer.parseInt(s[3]);
                    this.bc = new Color(r, g, b, a);
                    continue;
                }
                if (element.name.equals("Pos")) {
                    s = element.value.split("[,]");
                    this.x = Integer.parseInt(s[0]);
                    this.y = Integer.parseInt(s[1]);
                    continue;
                }
                if (!element.name.equals("Format")) continue;
                this.overrideFormat = element.value.isEmpty() ? null : ValueFormat.getFormatter(element.value);
            }
        }

        PopupSettings() {
            this.valueName = "";
            this.popupNo = 0;
            this.fontSize = 2.2;
            this.fc = Color.blue;
            this.bc = new Color(0.4f, 0.4f, 0.4f, 0.1f);
            this.x = -1000;
            this.y = -1000;
        }

        protected PopupSettings clone() {
            PopupSettings ps = new PopupSettings();
            ps.valueName = "";
            ps.fontSize = this.fontSize;
            if (this.x >= -100 || this.y >= -100) {
                ps.x = this.x + 100;
                ps.y = this.y + 50;
            }
            ps.fc = this.fc;
            ps.bc = this.bc;
            return ps;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("Value:");
            sb.append(this.valueName);
            sb.append("|");
            sb.append("Size:");
            sb.append(this.fontSize);
            sb.append("|");
            sb.append("FC:");
            sb.append(this.fc.getRed());
            sb.append(",");
            sb.append(this.fc.getGreen());
            sb.append(",");
            sb.append(this.fc.getBlue());
            sb.append(",");
            sb.append(this.fc.getAlpha());
            sb.append("|");
            sb.append("BC:");
            sb.append(this.bc.getRed());
            sb.append(",");
            sb.append(this.bc.getGreen());
            sb.append(",");
            sb.append(this.bc.getBlue());
            sb.append(",");
            sb.append(this.bc.getAlpha());
            sb.append("|");
            sb.append("Pos:");
            sb.append(this.x);
            sb.append(",");
            sb.append(this.y);
            sb.append("|");
            sb.append("No:");
            sb.append(this.popupNo);
            sb.append("|");
            sb.append("Format:");
            sb.append(this.overrideFormat != null ? this.overrideFormat.getName() : "");
            return sb.toString();
        }

        public void applyLocation(PopupReadout form) {
            if (this.x >= -100 && this.y >= -100) {
                form.setLocation(this.x, this.y);
            }
        }

        public void apply(PopupReadout form) {
            form.getContentPane().setBackground(this.bc);
            if (this.bc.getAlpha() <= 1) {
                Color back = new Color(this.fc.getRed(), this.fc.getGreen(), this.fc.getBlue(), this.bc.getAlpha());
                form.setBackground(back);
            } else {
                form.setBackground(this.bc);
            }
            form.label.setBackground(this.bc);
            form.label.setForeground(this.fc);
            Font font = new Font("Dialog", 1, (int)(30.0 * this.fontSize * FontAdjust.fontSizes.scale + 0.5));
            form.label.setFont(font);
            form.setFormSize(PopupReadout.measureText, true);
            form.label.setToolTipText(this.valueName);
            form.repaint();
            form.saveDefault();
        }
    }
}

