/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.main;

import dk.hkj.comm.CommInterface;
import dk.hkj.devices.SetupFormatsAdjuster;
import dk.hkj.main.CommandProcessor;
import dk.hkj.main.FontAdjust;
import dk.hkj.main.IconGenerator;
import dk.hkj.main.Indicator;
import dk.hkj.main.InterfaceThreads;
import dk.hkj.main.PopupBaseFrame;
import dk.hkj.main.Support;
import dk.hkj.script.Script;
import dk.hkj.util.StringUtil;
import dk.hkj.vars.Var;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class PopupParamSweeper
extends PopupBaseFrame
implements ActionListener {
    private static PopupParamSweeper popupParamSweeper = null;
    private boolean popupOpen = false;
    private BlockingQueue<QueueMessage> queue = new ArrayBlockingQueue<QueueMessage>(5);
    private FontAdjust.FontTabbedPane tabbedpane = null;
    private JComboBox<String> sweepTypeComboBox = null;
    private JButton startButton = null;
    private Indicator indicator = null;
    private JTextField prepareTimeTextField = null;
    private JTextField pauseTextField = null;
    private JTextField logFilenameTextField = null;
    private JTextField logIntervalTextField = null;
    private JCheckBox saveLogEachCheckBox = null;
    private JCheckBox saveChartEachCheckBox = null;
    private JCheckBox logPauseCheckBox = null;
    private JProgressBar progressBar = null;
    private JLabel logFilenameLabel = null;
    private JLabel logIntervalLabel = null;
    private JLabel estimatedTimeLabel = null;
    private UpdateThread updateThread = null;
    private long startTime;
    private long totalTime = 0L;
    private boolean hasSwept = false;
    private Timer timer = null;
    private SweepType sweepType = SweepType.Primary_only;
    private double prepareTime = 0.0;
    private double pauseTime = 0.0;
    private double logInterval = 0.0;
    private boolean logPause = false;
    private boolean saveLogEach = false;
    private boolean saveChartEach = false;
    private String logFilename = "";
    private boolean breakDetected = false;
    protected int paramsCount = 0;
    private final int MAX_STEPS = 8;
    private final String[] idText = new String[]{"Primary", "Secondary", "Tertiary"};
    private SweepSet[] sweepSet = new SweepSet[3];
    private Breaker[] breakers = new Breaker[3];

    private PopupParamSweeper() {
        this.init();
    }

    private PopupParamSweeper(String defaultHandle) {
        this.init();
    }

    public void init() {
        popupParamSweeper = this;
        this.popupOpen = true;
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                if (PopupParamSweeper.this == popupParamSweeper) {
                    PopupParamSweeper.popupParamSweeper = null;
                }
                PopupParamSweeper.this.popupOpen = false;
                if (PopupParamSweeper.this.timer != null) {
                    PopupParamSweeper.this.timer.stop();
                    PopupParamSweeper.this.timer = null;
                }
                try {
                    PopupParamSweeper.this.queue.put(QueueMessage.Quit);
                }
                catch (InterruptedException interruptedException) {}
                Support.math.removeDomain("ParamSweeper");
            }

            @Override
            public void windowActivated(WindowEvent arg0) {
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent e) {
                if (PopupParamSweeper.this == popupParamSweeper) {
                    PopupParamSweeper.popupParamSweeper = null;
                }
                PopupParamSweeper.this.popupOpen = false;
                if (PopupParamSweeper.this.timer != null) {
                    PopupParamSweeper.this.timer.stop();
                    PopupParamSweeper.this.timer = null;
                }
                try {
                    PopupParamSweeper.this.queue.put(QueueMessage.Quit);
                }
                catch (InterruptedException interruptedException) {}
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent arg0) {
            }
        });
        this.setTitle("Param sweeper");
        this.setDefaultCloseOperation(2);
        this.definePopupName("ParamSweeper", false);
        this.setMinimumSize(new Dimension(600, 200));
        this.setPreferredSize(new Dimension(730, 200));
        this.add(this.generatePanel());
        this.pack();
        this.updateThread = new UpdateThread();
        this.timer = new Timer(200, this);
        this.timer.setActionCommand("timer");
        this.timer.addActionListener(this);
        this.timer.start();
        this.parsePrimary();
        this.setEnable();
        this.setTime();
    }

    private void setParams(CommandProcessor.CmdEnvironment env, String[] params) {
        SweepType st;
        if (params.length < 5) {
            return;
        }
        String s = env.exp(params[2]).toLowerCase();
        boolean found = true;
        SweepType[] sweepTypeArray = SweepType.values();
        int n = sweepTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            st = sweepTypeArray[n2];
            if (st.name().toLowerCase().replace("_", " ").equals(s)) {
                this.sweepType = st;
                this.sweepTypeComboBox.setSelectedItem(st.name().replace("_", " "));
                found = true;
                break;
            }
            ++n2;
        }
        if (!found) {
            sweepTypeArray = SweepType.values();
            n = sweepTypeArray.length;
            n2 = 0;
            while (n2 < n) {
                st = sweepTypeArray[n2];
                if (st.name().toLowerCase().replace("_", " ").contains(s)) {
                    this.sweepType = st;
                    this.sweepTypeComboBox.setSelectedItem(st.name().replace("_", " "));
                    found = true;
                    break;
                }
                ++n2;
            }
        }
        this.prepareTime = env.expDouble(params[3]);
        this.prepareTimeTextField.setText(StringUtil.formatDoubleEE(this.prepareTime, false));
        this.pauseTime = env.expDouble(params[4]);
        this.pauseTextField.setText(StringUtil.formatDoubleEE(this.pauseTime, false));
        this.setEnable();
    }

    private void setParamsL(CommandProcessor.CmdEnvironment env, String[] params) {
        if (params.length < 6) {
            return;
        }
        this.saveLogEach = env.expBoolean(params[2]);
        this.saveLogEachCheckBox.setSelected(this.saveLogEach);
        this.saveChartEach = env.expBoolean(params[3]);
        this.saveChartEachCheckBox.setSelected(this.saveChartEach);
        this.logPause = env.expBoolean(params[4]);
        this.logPauseCheckBox.setSelected(this.logPause);
        this.logInterval = env.expDouble(params[5]);
        this.logIntervalTextField.setText(StringUtil.formatDoubleEE(this.logInterval, false));
        this.logFilename = params.length >= 7 ? env.exp(params[6]) : "";
        this.logFilenameTextField.setText(this.logFilename);
        this.setEnable();
    }

    public static void setParamSweeper(CommandProcessor.CmdEnvironment env, String[] params) {
        String ch;
        if (params.length <= 1) {
            return;
        }
        if (popupParamSweeper == null) {
            PopupParamSweeper.getPopup();
        }
        if ((ch = params[1]).equalsIgnoreCase("M")) {
            popupParamSweeper.setParams(env, params);
        } else if (ch.equalsIgnoreCase("ML")) {
            popupParamSweeper.setParamsL(env, params);
        } else if (ch.equalsIgnoreCase("PC")) {
            PopupParamSweeper.popupParamSweeper.sweepSet[0].setParamsC(env, params);
        } else if (ch.equalsIgnoreCase("PS")) {
            PopupParamSweeper.popupParamSweeper.sweepSet[0].setParamsS(env, params);
        } else if (ch.equalsIgnoreCase("PV")) {
            PopupParamSweeper.popupParamSweeper.sweepSet[0].setParamsV(env, params);
        } else if (ch.equalsIgnoreCase("SC")) {
            PopupParamSweeper.popupParamSweeper.sweepSet[1].setParamsC(env, params);
        } else if (ch.equalsIgnoreCase("SS")) {
            PopupParamSweeper.popupParamSweeper.sweepSet[1].setParamsS(env, params);
        } else if (ch.equalsIgnoreCase("SV")) {
            PopupParamSweeper.popupParamSweeper.sweepSet[1].setParamsV(env, params);
        } else if (ch.equalsIgnoreCase("TC")) {
            PopupParamSweeper.popupParamSweeper.sweepSet[2].setParamsC(env, params);
        } else if (ch.equalsIgnoreCase("TS")) {
            PopupParamSweeper.popupParamSweeper.sweepSet[2].setParamsS(env, params);
        } else if (ch.equalsIgnoreCase("TV")) {
            PopupParamSweeper.popupParamSweeper.sweepSet[2].setParamsV(env, params);
        } else if (ch.equalsIgnoreCase("B1")) {
            PopupParamSweeper.popupParamSweeper.breakers[0].setParams(env, params);
        } else if (ch.equalsIgnoreCase("B2")) {
            PopupParamSweeper.popupParamSweeper.breakers[1].setParams(env, params);
        } else if (ch.equalsIgnoreCase("B3")) {
            PopupParamSweeper.popupParamSweeper.breakers[2].setParams(env, params);
        }
    }

    public static void closeAll() {
        PopupParamSweeper.closePopup();
    }

    public static void closePopup() {
        if (popupParamSweeper != null) {
            PopupParamSweeper.popupParamSweeper.popupOpen = false;
            popupParamSweeper.setVisible(false);
            popupParamSweeper = null;
        }
    }

    public static void abort() {
        if (popupParamSweeper != null) {
            popupParamSweeper.stop();
        }
    }

    public static boolean isPopupAlarm() {
        return popupParamSweeper != null && !PopupParamSweeper.isSweeping() && PopupParamSweeper.popupParamSweeper.hasSwept;
    }

    public static boolean isSweeping() {
        if (popupParamSweeper != null && PopupParamSweeper.popupParamSweeper.updateThread != null) {
            return PopupParamSweeper.popupParamSweeper.updateThread.isSweeping();
        }
        return false;
    }

    public static void alignGridAll(int pixels) {
        if (popupParamSweeper != null) {
            popupParamSweeper.alignGrid(pixels);
        }
    }

    public static PopupParamSweeper getPopup() {
        if (popupParamSweeper != null) {
            popupParamSweeper.requestFocus();
            return popupParamSweeper;
        }
        Point p = Support.paneCommand.popupsButton.getLocationOnScreen();
        p.translate(-750, -400);
        if (p.y < 0) {
            p.y = 0;
        }
        if (p.x < 0) {
            p.x = 0;
        }
        popupParamSweeper = new PopupParamSweeper();
        popupParamSweeper.setLocation(p);
        popupParamSweeper.setVisible(true);
        return popupParamSweeper;
    }

    public static void setParams(int no, String name, Double min, Double max, String cmd) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
            }
        });
    }

    private JTabbedPane generatePanel() {
        this.tabbedpane = new FontAdjust.FontTabbedPane();
        this.tabbedpane.addTab("Main", this.generatePrimaryPanel());
        int i = 0;
        while (i < 3) {
            this.sweepSet[i] = new SweepSet(i);
            this.tabbedpane.addTab(this.idText[i], this.sweepSet[i].generateSweepPanel());
            this.tabbedpane.setEnabledAt(i + 1, false);
            ++i;
        }
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.setAlignmentX(0.0f);
        int i2 = 0;
        while (i2 < 3) {
            this.breakers[i2] = new Breaker(i2);
            panel.add(this.breakers[i2].generateBreakerPanel());
            ++i2;
        }
        this.tabbedpane.addTab("Breaker", panel);
        this.tabbedpane.setToolTipTextAt(0, "Define sweep type and logging");
        this.tabbedpane.setToolTipTextAt(1, "Primary sweep parameter, this is the parameter that is sweep most frequently");
        this.tabbedpane.setToolTipTextAt(2, "Secondary sweep parameter, this is swept after the primary");
        this.tabbedpane.setToolTipTextAt(3, "Tertiary, this is the last sweept parameter");
        this.tabbedpane.setToolTipTextAt(4, "Conditions to break a single sweep or stop all sweeps");
        return this.tabbedpane;
    }

    private JPanel generatePrimaryPanel() {
        FontAdjust.FontPanel panel = new FontAdjust.FontPanel();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 17;
        c.weightx = 1.0;
        c.weighty = 1.0;
        JPanel line1Panel = new JPanel();
        panel.add((Component)line1Panel, c);
        line1Panel.add(new FontAdjust.FontLabel("Sweep type:"));
        this.sweepTypeComboBox = new FontAdjust.FontComboBox<String>();
        SweepType[] sweepTypeArray = SweepType.values();
        int n = sweepTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            SweepType st = sweepTypeArray[n2];
            this.sweepTypeComboBox.addItem(st.name().replace("_", " "));
            ++n2;
        }
        this.sweepTypeComboBox.setToolTipText("<html>\"then\" means one after another the other parameter at idle value<br>\"and\" means at the same time to get all combinations except:<br>\"simultanously\" means swept together");
        this.sweepTypeComboBox.setActionCommand("type");
        this.sweepTypeComboBox.addActionListener(this);
        this.sweepTypeComboBox.setMaximumRowCount(30);
        line1Panel.add(this.sweepTypeComboBox);
        line1Panel.add(Box.createHorizontalStrut(20));
        line1Panel.add(new FontAdjust.FontLabel("Estimated time:"));
        this.estimatedTimeLabel = new FontAdjust.FontLabel("");
        line1Panel.add(this.estimatedTimeLabel);
        line1Panel.add(Box.createHorizontalStrut(20));
        this.indicator = new Indicator();
        this.indicator.setColor(Color.red);
        line1Panel.add(this.indicator);
        line1Panel.add(Box.createHorizontalStrut(10));
        this.startButton = new FontAdjust.FontButton("Start");
        this.startButton.setActionCommand("start");
        this.startButton.setToolTipText("Press to start a sweep, use Alarm popup to set a alarm when done");
        this.startButton.addActionListener(this);
        line1Panel.add(this.startButton);
        JPanel line2Panel = new JPanel();
        c.gridy = 1;
        panel.add((Component)line2Panel, c);
        line2Panel.add(new FontAdjust.FontLabel("Prepare time before each sweep:"));
        this.prepareTimeTextField = new FontAdjust.FontTextField(6);
        this.prepareTimeTextField.setToolTipText("Time to stabilize after switching parameters to initial value");
        this.prepareTimeTextField.setText("1");
        this.prepareTimeTextField.setActionCommand("P");
        this.prepareTimeTextField.addActionListener(this);
        this.prepareTimeTextField.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent arg0) {
                PopupParamSweeper.this.prepareTimeTextField.selectAll();
            }

            @Override
            public void focusLost(FocusEvent arg0) {
                PopupParamSweeper.this.actionPerformed(new ActionEvent(PopupParamSweeper.this.prepareTimeTextField, 0, "P"));
            }
        });
        line2Panel.add(this.prepareTimeTextField);
        line2Panel.add(Box.createHorizontalStrut(20));
        line2Panel.add(new FontAdjust.FontLabel("Pause time after each sweep:"));
        this.pauseTextField = new FontAdjust.FontTextField(6);
        this.pauseTextField.setToolTipText("Pause time after sweep, before performing another sweep. This can be used for cool down time");
        this.pauseTextField.setText("1");
        this.pauseTextField.setActionCommand("P");
        this.pauseTextField.addActionListener(this);
        this.pauseTextField.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent arg0) {
                PopupParamSweeper.this.pauseTextField.selectAll();
            }

            @Override
            public void focusLost(FocusEvent arg0) {
                PopupParamSweeper.this.actionPerformed(new ActionEvent(PopupParamSweeper.this.pauseTextField, 0, "P"));
            }
        });
        line2Panel.add(this.pauseTextField);
        line2Panel.add(Box.createHorizontalStrut(5));
        JPanel line3Panel = new JPanel();
        c.gridy = 2;
        panel.add((Component)line3Panel, c);
        this.saveLogEachCheckBox = new FontAdjust.FontCheckBox("Save log each");
        this.saveLogEachCheckBox.setToolTipText("<html>The Start button will reset the log and save one or more times during the sweeps<br>then types and sweps with steps will usually save multiple logs");
        this.saveLogEachCheckBox.setActionCommand("P");
        this.saveLogEachCheckBox.addActionListener(this);
        line3Panel.add(this.saveLogEachCheckBox);
        this.saveChartEachCheckBox = new FontAdjust.FontCheckBox("Save chart each");
        this.saveChartEachCheckBox.setToolTipText("Save a chart together with the log, axis must be configured before start is pressed");
        this.saveChartEachCheckBox.setActionCommand("P");
        this.saveChartEachCheckBox.addActionListener(this);
        line3Panel.add(this.saveChartEachCheckBox);
        this.logPauseCheckBox = new FontAdjust.FontCheckBox("Log pause");
        this.logPauseCheckBox.setToolTipText("Log while in pause at the end of each sweep before saving");
        this.logPauseCheckBox.setActionCommand("P");
        this.logPauseCheckBox.addActionListener(this);
        line3Panel.add(this.logPauseCheckBox);
        this.logIntervalLabel = new FontAdjust.FontLabel("Log interval:");
        line3Panel.add(this.logIntervalLabel);
        this.logIntervalTextField = new FontAdjust.FontTextField(6);
        this.logIntervalTextField.setText("1");
        this.logIntervalTextField.setToolTipText("Interval used when log is started from sweeper");
        this.logIntervalTextField.setActionCommand("P");
        this.logIntervalTextField.addActionListener(this);
        this.logIntervalTextField.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent arg0) {
                PopupParamSweeper.this.logIntervalTextField.selectAll();
            }

            @Override
            public void focusLost(FocusEvent arg0) {
                PopupParamSweeper.this.actionPerformed(new ActionEvent(PopupParamSweeper.this.logIntervalTextField, 0, "P"));
            }
        });
        line3Panel.add(this.logIntervalTextField);
        line3Panel.add(Box.createHorizontalStrut(20));
        this.logFilenameLabel = new FontAdjust.FontLabel("Log name:");
        line3Panel.add(this.logFilenameLabel);
        this.logFilenameTextField = new FontAdjust.FontTextField(10);
        this.logFilenameTextField.setActionCommand("P");
        this.logFilenameTextField.addActionListener(this);
        this.logFilenameTextField.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent arg0) {
                PopupParamSweeper.this.logFilenameTextField.selectAll();
            }

            @Override
            public void focusLost(FocusEvent arg0) {
                PopupParamSweeper.this.actionPerformed(new ActionEvent(PopupParamSweeper.this.logFilenameTextField, 0, "P"));
            }
        });
        this.logFilenameTextField.setToolTipText("First part of log filename, TC will add second part, when empty a default name will be used");
        line3Panel.add(this.logFilenameTextField);
        ++c.gridy;
        c.weightx = 1.0;
        c.fill = 2;
        this.progressBar = new JProgressBar(0, 1000);
        this.progressBar.setString("idle");
        this.progressBar.setStringPainted(true);
        panel.add((Component)this.progressBar, c);
        return panel;
    }

    private void stop() {
        try {
            this.queue.put(QueueMessage.Stop);
        }
        catch (InterruptedException interruptedException) {}
    }

    private double calcTime() {
        switch (this.sweepType) {
            case Primary_and_secondary: {
                return (this.prepareTime + (double)this.sweepSet[0].getSteps() * this.sweepSet[0].stepTime + this.sweepSet[0].stepTime + this.pauseTime) * (double)this.sweepSet[1].getSteps();
            }
            case Primary_and_secondary_and_tertiary: {
                return (this.prepareTime + (double)this.sweepSet[0].getSteps() * this.sweepSet[0].stepTime + this.sweepSet[0].stepTime + this.pauseTime) * (double)this.sweepSet[1].getSteps() * (double)this.sweepSet[2].getSteps();
            }
            case Primary_and_secondary_simultanously: {
                return this.prepareTime + (double)this.sweepSet[0].getSteps() * this.sweepSet[0].stepTime + this.sweepSet[0].stepTime + this.pauseTime;
            }
            case Primary_only: {
                return this.prepareTime + (double)this.sweepSet[0].getSteps() * this.sweepSet[0].stepTime + this.sweepSet[0].stepTime + this.pauseTime;
            }
            case Primary_then_secondary: {
                return this.prepareTime + (double)this.sweepSet[0].getSteps() * this.sweepSet[0].stepTime + this.sweepSet[0].stepTime + this.pauseTime + (this.prepareTime + (double)this.sweepSet[1].getSteps() * this.sweepSet[1].stepTime + this.sweepSet[1].stepTime + this.pauseTime);
            }
            case Primary_then_secondary_then_tertiary: {
                return this.prepareTime + (double)this.sweepSet[0].getSteps() * this.sweepSet[0].stepTime + this.sweepSet[0].stepTime + this.pauseTime + (this.prepareTime + (double)this.sweepSet[1].getSteps() * this.sweepSet[1].stepTime + this.sweepSet[1].stepTime + this.pauseTime) + (this.prepareTime + (double)this.sweepSet[2].getSteps() * this.sweepSet[2].stepTime + this.sweepSet[2].stepTime + this.pauseTime);
            }
            case Primary_then_secondary_and_tertiary: {
                return (this.prepareTime + (double)this.sweepSet[0].getSteps() * this.sweepSet[0].stepTime + this.sweepSet[0].stepTime + this.pauseTime + (this.prepareTime + (double)this.sweepSet[1].getSteps() * this.sweepSet[1].stepTime + this.sweepSet[1].stepTime + this.pauseTime)) * (double)this.sweepSet[2].getSteps();
            }
            case Primary_and_secondary_simultanously_and_tertiary: {
                return (this.prepareTime + (double)this.sweepSet[0].getSteps() * this.sweepSet[0].stepTime + this.sweepSet[0].stepTime + this.pauseTime) * (double)this.sweepSet[2].getSteps();
            }
        }
        return 0.0;
    }

    private boolean ssParamDif(int s1, int s2) {
        if (!this.sweepSet[s1].adjustParam.getName().equals(this.sweepSet[s2].adjustParam.getName())) {
            return true;
        }
        if (!this.sweepSet[s1].adjustParam.useCustomCommand()) {
            return false;
        }
        return !this.sweepSet[s1].adjustParam.getCmd().trim().equalsIgnoreCase(this.sweepSet[s2].adjustParam.getCmd().trim());
    }

    private boolean setValid(int s) {
        if (this.sweepSet[s].getSteps() <= 0) {
            return false;
        }
        if (this.sweepSet[s].isError()) {
            return false;
        }
        if (!this.sweepSet[s].adjustParam.useCustomCommand()) {
            return true;
        }
        return this.sweepSet[s].adjustParam.getCmd().length() > 0;
    }

    private void setEnable() {
        if (this.sweepSet[0] == null || !this.sweepSet[0].isValid()) {
            return;
        }
        this.sweepSet[0].setEnable();
        this.sweepSet[1].setEnable();
        this.sweepSet[2].setEnable();
        switch (this.sweepType) {
            case Primary_and_secondary: {
                this.tabbedpane.setEnabledAt(1, true);
                this.tabbedpane.setEnabledAt(2, true);
                this.tabbedpane.setEnabledAt(3, false);
                this.paramsCount = 2;
                this.startButton.setEnabled(this.ssParamDif(0, 1) && this.setValid(0) && this.setValid(1));
                break;
            }
            case Primary_and_secondary_and_tertiary: {
                this.tabbedpane.setEnabledAt(1, true);
                this.tabbedpane.setEnabledAt(2, true);
                this.tabbedpane.setEnabledAt(3, true);
                this.paramsCount = 3;
                this.startButton.setEnabled(this.ssParamDif(0, 1) && this.ssParamDif(1, 2) && this.ssParamDif(0, 2) && this.setValid(0) && this.setValid(1) && this.setValid(2));
                break;
            }
            case Primary_and_secondary_simultanously: {
                this.tabbedpane.setEnabledAt(1, true);
                this.tabbedpane.setEnabledAt(2, true);
                this.tabbedpane.setEnabledAt(3, false);
                this.paramsCount = 2;
                this.startButton.setEnabled(this.ssParamDif(0, 1) && this.setValid(0) && this.setValid(1));
                break;
            }
            case Primary_only: {
                this.tabbedpane.setEnabledAt(1, true);
                this.tabbedpane.setEnabledAt(2, false);
                this.tabbedpane.setEnabledAt(3, false);
                this.paramsCount = 1;
                this.startButton.setEnabled(this.setValid(0));
                break;
            }
            case Primary_then_secondary: {
                this.tabbedpane.setEnabledAt(1, true);
                this.tabbedpane.setEnabledAt(2, true);
                this.tabbedpane.setEnabledAt(3, false);
                this.paramsCount = 2;
                this.startButton.setEnabled(this.setValid(0) && this.setValid(1));
                break;
            }
            case Primary_then_secondary_then_tertiary: {
                this.tabbedpane.setEnabledAt(1, true);
                this.tabbedpane.setEnabledAt(2, true);
                this.tabbedpane.setEnabledAt(3, true);
                this.paramsCount = 3;
                this.startButton.setEnabled(this.setValid(0) && this.setValid(1) && this.setValid(2));
                break;
            }
            case Primary_then_secondary_and_tertiary: {
                this.tabbedpane.setEnabledAt(1, true);
                this.tabbedpane.setEnabledAt(2, true);
                this.tabbedpane.setEnabledAt(3, true);
                this.paramsCount = 3;
                this.startButton.setEnabled(this.setValid(0) && this.setValid(1) && this.setValid(2));
                break;
            }
            case Primary_and_secondary_simultanously_and_tertiary: {
                this.tabbedpane.setEnabledAt(1, true);
                this.tabbedpane.setEnabledAt(2, true);
                this.tabbedpane.setEnabledAt(3, true);
                this.paramsCount = 3;
                this.startButton.setEnabled(this.setValid(0) && this.setValid(1) && this.setValid(2));
                break;
            }
        }
        this.saveChartEachCheckBox.setEnabled(this.saveLogEachCheckBox.isSelected());
        this.logPauseCheckBox.setEnabled(this.saveLogEachCheckBox.isSelected());
        this.logIntervalTextField.setEnabled(this.saveLogEachCheckBox.isSelected());
        this.logIntervalLabel.setEnabled(this.saveLogEachCheckBox.isSelected());
        this.logFilenameTextField.setEnabled(this.saveLogEachCheckBox.isSelected());
        this.logFilenameLabel.setEnabled(this.saveLogEachCheckBox.isSelected());
    }

    private void parsePrimary() {
        this.prepareTime = Support.parseTextFieldDouble(this.prepareTimeTextField, this.prepareTime, false, 1.0, 3600.0);
        this.pauseTime = Support.parseTextFieldDouble(this.pauseTextField, this.pauseTime, false, 1.0, 3600.0);
        this.logInterval = Support.parseTextFieldDouble(this.logIntervalTextField, this.logInterval, false, 0.01, 3600.0);
        this.saveLogEach = this.saveLogEachCheckBox.isSelected();
        this.saveChartEach = this.saveChartEachCheckBox.isSelected();
        this.logPause = this.logPauseCheckBox.isSelected();
        this.logFilename = this.logFilenameTextField.getText().trim();
        this.setEnable();
    }

    private void setTime() {
        double t = this.calcTime();
        this.estimatedTimeLabel.setText(Support.formatTime(t));
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        if (arg0.getActionCommand().equalsIgnoreCase("P")) {
            this.parsePrimary();
            this.setTime();
        } else if (arg0.getActionCommand().equalsIgnoreCase("type")) {
            String s = (String)this.sweepTypeComboBox.getSelectedItem();
            SweepType[] sweepTypeArray = SweepType.values();
            int n = sweepTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                SweepType st = sweepTypeArray[n2];
                if (s.equals(st.name().replace("_", " "))) {
                    this.sweepType = st;
                }
                ++n2;
            }
            this.setEnable();
            this.setTime();
        } else if (arg0.getActionCommand().equalsIgnoreCase("start")) {
            boolean start = !this.updateThread.isSweeping();
            this.hasSwept = false;
            try {
                this.queue.put(start ? QueueMessage.Start : QueueMessage.Stop);
            }
            catch (InterruptedException interruptedException) {}
            this.startButton.setText(start ? "Stop" : "Start");
            this.indicator.setOn(start);
            this.startTime = System.currentTimeMillis();
            this.totalTime = (long)(this.calcTime() * 1000.0);
            this.progress();
        } else if (arg0.getActionCommand().equalsIgnoreCase("timer")) {
            this.startButton.setText(this.updateThread.isSweeping() ? "Stop" : "Start");
            this.indicator.setOn(this.updateThread.isSweeping());
            this.progress();
        } else {
            System.out.println("Invalid action command: " + arg0.getActionCommand() + " from " + arg0.getSource().getClass().getName());
        }
    }

    private void progress() {
        if (this.updateThread.isSweeping()) {
            long usedTime = System.currentTimeMillis() - this.startTime;
            int pct = (int)(usedTime * 1000L / this.totalTime);
            this.progressBar.setValue(pct);
            this.progressBar.setString("Remaning: " + Support.formatTime((this.totalTime - usedTime) / 1000L));
        } else {
            this.progressBar.setString("idle");
            this.progressBar.setValue(1000);
        }
    }

    public List<String> generateScriptMain() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("#SetParamSweeper M \"" + this.sweepType.name().replace("_", " ") + "\" " + StringUtil.formatDoubleEE(this.prepareTime) + " " + StringUtil.formatDoubleEE(this.pauseTime));
        list.add("#SetParamSweeper ML " + (this.saveLogEach ? "1" : "0") + " " + (this.saveChartEach ? "1" : "0") + " " + (this.logPause ? "1" : "0") + " " + StringUtil.formatDoubleEE(this.logInterval) + " \"" + this.logFilename + "\"");
        return list;
    }

    public static List<String> generateScript() {
        ArrayList<String> list = new ArrayList<String>();
        if (popupParamSweeper != null) {
            list.add("#CloseParamSweeper");
            list.add("#ShowPopupSystem ParamSweeper " + popupParamSweeper.generateLocationParams());
            list.addAll(popupParamSweeper.generateScriptMain());
            switch (PopupParamSweeper.popupParamSweeper.sweepType) {
                case Primary_only: {
                    list.addAll(PopupParamSweeper.popupParamSweeper.sweepSet[0].generateScriptSweepSet());
                    break;
                }
                case Primary_then_secondary: 
                case Primary_and_secondary_simultanously: 
                case Primary_and_secondary: {
                    list.addAll(PopupParamSweeper.popupParamSweeper.sweepSet[0].generateScriptSweepSet());
                    list.addAll(PopupParamSweeper.popupParamSweeper.sweepSet[1].generateScriptSweepSet());
                    break;
                }
                case Primary_then_secondary_then_tertiary: 
                case Primary_and_secondary_and_tertiary: 
                case Primary_then_secondary_and_tertiary: 
                case Primary_and_secondary_simultanously_and_tertiary: {
                    list.addAll(PopupParamSweeper.popupParamSweeper.sweepSet[0].generateScriptSweepSet());
                    list.addAll(PopupParamSweeper.popupParamSweeper.sweepSet[1].generateScriptSweepSet());
                    list.addAll(PopupParamSweeper.popupParamSweeper.sweepSet[2].generateScriptSweepSet());
                    break;
                }
            }
            Breaker[] breakerArray = PopupParamSweeper.popupParamSweeper.breakers;
            int n = PopupParamSweeper.popupParamSweeper.breakers.length;
            int n2 = 0;
            while (n2 < n) {
                Breaker b = breakerArray[n2];
                list.addAll(b.generateScriptBreaker());
                ++n2;
            }
        }
        return list;
    }

    public static boolean addColumns() {
        if (popupParamSweeper == null) {
            return false;
        }
        int n = 0;
        int i = 0;
        while (i < PopupParamSweeper.popupParamSweeper.paramsCount) {
            if (PopupParamSweeper.popupParamSweeper.sweepSet[i].isLog()) {
                ++n;
            }
            ++i;
        }
        return n > 0;
    }

    public static List<String> columnNames() {
        ArrayList<String> list = new ArrayList<String>();
        if (popupParamSweeper == null) {
            return list;
        }
        int i = 0;
        while (i < PopupParamSweeper.popupParamSweeper.paramsCount) {
            if (PopupParamSweeper.popupParamSweeper.sweepSet[i].isLog()) {
                list.add("PS." + PopupParamSweeper.popupParamSweeper.sweepSet[i].adjustParam.getName().replace(' ', '_'));
            }
            ++i;
        }
        return list;
    }

    public static List<String> columnUnits() {
        ArrayList<String> list = new ArrayList<String>();
        if (popupParamSweeper == null) {
            return list;
        }
        int i = 0;
        while (i < PopupParamSweeper.popupParamSweeper.paramsCount) {
            if (PopupParamSweeper.popupParamSweeper.sweepSet[i].isLog()) {
                list.add(PopupParamSweeper.popupParamSweeper.sweepSet[i].adjustParam.getUnit());
            }
            ++i;
        }
        return list;
    }

    public static List<Double> columnValues() {
        ArrayList<Double> list = new ArrayList<Double>();
        if (popupParamSweeper == null) {
            return list;
        }
        if (!PopupParamSweeper.popupParamSweeper.updateThread.isSweeping() || PopupParamSweeper.popupParamSweeper.hasSwept) {
            return list;
        }
        int i = 0;
        while (i < PopupParamSweeper.popupParamSweeper.paramsCount) {
            if (PopupParamSweeper.popupParamSweeper.sweepSet[i].isLog()) {
                list.add(PopupParamSweeper.popupParamSweeper.sweepSet[i].adjustParam.getParam());
            }
            ++i;
        }
        return list;
    }

    private class Breaker
    implements ActionListener {
        private int id = 0;
        private JCheckBox allCheckBox = null;
        private JButton inputFormatButton = null;
        private JPanel cardPanel = null;
        private JPanel disabledPanel = null;
        private JPanel aboveBelowPanel = null;
        private JPanel expressionPanel = null;
        private JTextField aboveTextField = null;
        private JTextField belowTextField = null;
        private JTextField expressionTextField = null;
        private JComboBox<String> channelComboBox = null;
        private BreakerInputMethod inputMethod = BreakerInputMethod.breakerDisabled;
        private boolean breakAll = false;
        private String expression = "";
        private double below = Double.NaN;
        private double above = Double.NaN;
        private String channel = "";

        private Breaker(int id) {
            this.id = id;
        }

        private BreakerInputMethod nextInputMethod() {
            CardLayout cl = (CardLayout)this.cardPanel.getLayout();
            cl.next(this.cardPanel);
            this.inputMethod = BreakerInputMethod.breakerDisabled;
            if (this.expressionTextField.getParent().isVisible()) {
                this.inputMethod = BreakerInputMethod.breakerExpression;
            } else if (this.channelComboBox.getParent().isVisible()) {
                this.inputMethod = BreakerInputMethod.breakerBelowAbove;
            }
            return this.inputMethod;
        }

        private void setInputMethod(BreakerInputMethod im) {
            while (im != this.inputMethod) {
                this.nextInputMethod();
            }
        }

        private void fillChannels() {
            Object sel = this.channelComboBox.getSelectedItem();
            this.channelComboBox.removeAllItems();
            for (String s : InterfaceThreads.listChannels(true)) {
                this.channelComboBox.addItem(s);
            }
            this.channelComboBox.setSelectedItem(sel);
        }

        public boolean isBreak(Script script) {
            switch (this.inputMethod) {
                case breakerBelowAbove: {
                    Var vv = script.findVar(this.channel);
                    if (vv == null) {
                        return true;
                    }
                    double v = vv.asDouble();
                    if (!Double.isNaN(this.above) && v > this.above) {
                        return true;
                    }
                    return !Double.isNaN(this.below) && v < this.below;
                }
                case breakerDisabled: {
                    return false;
                }
                case breakerExpression: {
                    try {
                        return script.expression(this.expression).asBoolean();
                    }
                    catch (Exception exception) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                Breaker.this.expressionTextField.setBackground(Support.colorScheme.errorBackground);
                            }
                        });
                    }
                }
            }
            return true;
        }

        public boolean isAll() {
            return this.breakAll;
        }

        private void parse() {
            this.breakAll = this.allCheckBox.isSelected();
            this.channel = (String)this.channelComboBox.getSelectedItem();
            this.expression = this.expressionTextField.getText();
            this.below = Support.parseTextFieldDouble(this.belowTextField, this.below, true);
            this.above = Support.parseTextFieldDouble(this.aboveTextField, this.below, true);
            this.expressionTextField.setBackground(Support.colorScheme.textBackground);
        }

        private void setParams(CommandProcessor.CmdEnvironment env, String[] params) {
            if (params.length < 4) {
                return;
            }
            this.breakAll = env.expBoolean(params[2]);
            String s = env.exp(params[3]);
            if (s.equalsIgnoreCase("off")) {
                this.setInputMethod(BreakerInputMethod.breakerDisabled);
            } else if (s.equalsIgnoreCase("exp")) {
                if (params.length < 5) {
                    return;
                }
                this.setInputMethod(BreakerInputMethod.breakerExpression);
                this.expression = env.remaningExp(params, 4);
                this.expressionTextField.setText(this.expression);
            } else if (s.equalsIgnoreCase("ab")) {
                if (params.length < 7) {
                    return;
                }
                this.setInputMethod(BreakerInputMethod.breakerBelowAbove);
                this.channel = env.exp(params[4]);
                this.channelComboBox.setSelectedItem(this.channel);
                this.below = env.expDoubleNaN(params[5]);
                this.belowTextField.setText(Double.isNaN(this.below) ? "" : StringUtil.formatDoubleEE(this.below));
                this.above = env.expDoubleNaN(params[6]);
                this.aboveTextField.setText(Double.isNaN(this.above) ? "" : StringUtil.formatDoubleEE(this.above));
            }
        }

        JPanel generateBreakerPanel() {
            JPanel panel = new JPanel();
            panel.setLayout(new FlowLayout(0));
            this.allCheckBox = new FontAdjust.FontCheckBox("All");
            this.allCheckBox.addActionListener(this);
            this.allCheckBox.setToolTipText("Unchecked a single sweep will be stopped, checked all sweeps will be stopped");
            panel.add(this.allCheckBox);
            this.inputFormatButton = new FontAdjust.FontButton(null);
            this.inputFormatButton.setBorder(BorderFactory.createEmptyBorder());
            this.inputFormatButton.setIcon(IconGenerator.makeIcon(IconGenerator.IconType.FieldChange));
            this.inputFormatButton.setActionCommand("InputMethod");
            this.inputFormatButton.addActionListener(this);
            this.inputFormatButton.setToolTipText("Change between specifications formats");
            panel.add(this.inputFormatButton);
            this.cardPanel = new JPanel();
            this.cardPanel.setLayout(new CardLayout(0, 0));
            panel.add(this.cardPanel);
            this.disabledPanel = new JPanel();
            this.disabledPanel.setLayout(new FlowLayout(0));
            this.disabledPanel.add(new FontAdjust.FontLabel("Disabled"));
            this.cardPanel.add(this.disabledPanel);
            this.aboveBelowPanel = new JPanel();
            this.aboveBelowPanel.setLayout(new FlowLayout(0));
            this.channelComboBox = new FontAdjust.FontComboBox<String>();
            this.channelComboBox.setPreferredSize(new Dimension(150, 20));
            this.channelComboBox.setMaximumRowCount(30);
            this.channelComboBox.setToolTipText("Select channel to test agains above/below");
            this.fillChannels();
            if (this.channelComboBox.getItemCount() > 0) {
                this.channelComboBox.setSelectedIndex(0);
            }
            this.channelComboBox.addActionListener(this);
            this.aboveBelowPanel.add(this.channelComboBox);
            this.aboveBelowPanel.add(Box.createHorizontalStrut(20));
            this.aboveBelowPanel.add(new FontAdjust.FontLabel("Below:"));
            this.aboveBelowPanel.add(Box.createHorizontalStrut(3));
            this.belowTextField = new FontAdjust.FontTextField(6);
            this.belowTextField.addActionListener(this);
            this.belowTextField.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent e) {
                    ((JTextField)e.getSource()).selectAll();
                }

                @Override
                public void focusLost(FocusEvent e) {
                    Breaker.this.parse();
                }
            });
            this.aboveBelowPanel.add(this.belowTextField);
            this.aboveBelowPanel.add(Box.createHorizontalStrut(20));
            this.aboveBelowPanel.add(new FontAdjust.FontLabel("Above:"));
            this.aboveBelowPanel.add(Box.createHorizontalStrut(3));
            this.aboveTextField = new FontAdjust.FontTextField(6);
            this.aboveTextField.addActionListener(this);
            this.aboveTextField.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent e) {
                    ((JTextField)e.getSource()).selectAll();
                }

                @Override
                public void focusLost(FocusEvent e) {
                    Breaker.this.parse();
                }
            });
            this.aboveBelowPanel.add(this.aboveTextField);
            this.cardPanel.add(this.aboveBelowPanel);
            this.expressionPanel = new JPanel();
            this.expressionPanel.setLayout(new FlowLayout(0));
            this.expressionPanel.add(new FontAdjust.FontLabel("Expression: "));
            this.expressionTextField = new Support.PopupTextField(40);
            this.expressionTextField.addActionListener(this);
            this.expressionTextField.setToolTipText("A non-zero value will break the sweep, press INS to see a variable list.");
            this.expressionTextField.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent e) {
                    ((JTextField)e.getSource()).selectAll();
                }

                @Override
                public void focusLost(FocusEvent e) {
                    Breaker.this.parse();
                }
            });
            this.expressionPanel.add(this.expressionTextField);
            this.cardPanel.add(this.expressionPanel);
            return panel;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getActionCommand().equalsIgnoreCase("InputMethod")) {
                this.nextInputMethod();
            } else {
                this.parse();
            }
        }

        public List<String> generateScriptBreaker() {
            ArrayList<String> list = new ArrayList<String>();
            StringBuilder sb = new StringBuilder();
            sb.append("#setParamSweeper B" + (this.id + 1) + " ");
            sb.append(this.breakAll ? "1 " : "0 ");
            switch (this.inputMethod) {
                case breakerBelowAbove: {
                    sb.append("ab ");
                    sb.append("\"" + this.channel + "\" ");
                    sb.append(Double.isNaN(this.below) ? "\"\"" : Double.valueOf(this.below));
                    sb.append(" ");
                    sb.append(Double.isNaN(this.above) ? "\"\"" : Double.valueOf(this.above));
                    break;
                }
                case breakerDisabled: {
                    sb.append("off");
                    break;
                }
                case breakerExpression: {
                    sb.append("exp ");
                    sb.append("\"" + this.expression + "\"");
                    break;
                }
            }
            list.add(sb.toString());
            return list;
        }
    }

    private static enum BreakerInputMethod {
        breakerDisabled,
        breakerBelowAbove,
        breakerExpression;

    }

    private static enum QueueMessage {
        Start,
        Stop,
        Quit,
        Continue;

    }

    private static enum SweepMode {
        lin,
        log,
        step;

    }

    private class SweepSet
    implements ActionListener {
        int id = 0;
        JRadioButton linRadioButton;
        JRadioButton logRadioButton;
        JRadioButton stepRadioButton;
        JCheckBox logCheckBox;
        JComboBox<SetupFormatsAdjuster.AdjustParam> paramComboBox = null;
        JTextField cmdTextField = null;
        JLabel cmdLabel = null;
        JTextField stepTimeTextField = null;
        JLabel stepTimeLabel = null;
        JTextField stepsTextField = null;
        JLabel stepsLabel = null;
        JTextField startTextField = null;
        JLabel startLabel = null;
        JTextField stopTextField = null;
        JLabel stopLabel;
        JTextField idleTextField = null;
        JLabel idleLabel = null;
        JTextField[] stepValuesTextField = new JTextField[8];
        JLabel stepValuesLabel = null;
        SetupFormatsAdjuster.AdjustParam adjustParam = null;
        SweepMode sweepMode = SweepMode.lin;
        int errorCount = 0;
        double start = 0.0;
        double stop = 0.0;
        double idle = 0.0;
        double stepTime = 0.0;
        int steps;
        double[] stepValues = new double[8];
        boolean log = false;

        SweepSet(int id) {
            this.id = id;
        }

        public boolean isValid() {
            return this.idleTextField != null && this.paramComboBox.getItemCount() > 0;
        }

        int getStepValues() {
            int n = 0;
            int i = 0;
            while (i < 8) {
                if (!Double.isNaN(this.stepValues[i])) {
                    ++n;
                }
                ++i;
            }
            return n;
        }

        boolean isError() {
            return this.errorCount > 0;
        }

        public boolean isLog() {
            return this.log;
        }

        int getSteps() {
            if (this.sweepMode == SweepMode.step) {
                return this.getStepValues();
            }
            return this.steps;
        }

        double getUpdateValue(double r) {
            double v = 0.0;
            if (r < 0.0) {
                v = this.idle;
            } else {
                switch (this.sweepMode) {
                    case lin: {
                        v = (this.stop - this.start) * r + this.start;
                        break;
                    }
                    case log: {
                        v = this.start * Math.pow(Math.pow(this.stop / this.start, 1.0), r);
                        break;
                    }
                    case step: {
                        int i = (int)Math.rint(r * (double)(this.getSteps() - 1));
                        if (i < 0) {
                            i = 0;
                        } else if (i >= this.stepValues.length) {
                            i = this.stepValues.length - 1;
                        }
                        v = this.stepValues[i];
                        break;
                    }
                }
            }
            return v;
        }

        String getUpdateName(double r) {
            return String.valueOf(StringUtil.formatDoubleEE(this.getUpdateValue(r), false)) + this.adjustParam.getUnit();
        }

        void update(double r) {
            this.adjustParam.setParam(this.getUpdateValue(r));
        }

        void write(double v) {
            this.adjustParam.setParam(v);
        }

        void setEnable() {
            boolean enbt = false;
            boolean enbs = false;
            if (this.id != 0) {
                switch (PopupParamSweeper.this.sweepType) {
                    case Primary_only: 
                    case Primary_and_secondary_simultanously: 
                    case Primary_and_secondary: 
                    case Primary_and_secondary_and_tertiary: {
                        break;
                    }
                    case Primary_then_secondary: 
                    case Primary_then_secondary_then_tertiary: {
                        enbt = true;
                        break;
                    }
                    case Primary_then_secondary_and_tertiary: {
                        enbt = this.id == 1;
                        enbs = true;
                        break;
                    }
                    case Primary_and_secondary_simultanously_and_tertiary: {
                        enbt = false;
                        enbs = this.id == 2;
                        break;
                    }
                }
                enbs = this.sweepMode != SweepMode.step && PopupParamSweeper.this.sweepType != SweepType.Primary_and_secondary_simultanously;
            } else {
                enbt = true;
                enbs = this.sweepMode != SweepMode.step;
            }
            this.stepTimeTextField.setEnabled(enbt);
            this.stepTimeLabel.setEnabled(enbt);
            this.stepsTextField.setEnabled(enbs);
            this.stepsLabel.setEnabled(enbs);
            this.cmdTextField.setEnabled(this.adjustParam != null && this.adjustParam.useCustomCommand());
            this.cmdLabel.setEnabled(this.adjustParam != null && this.adjustParam.useCustomCommand());
            this.startTextField.setEnabled(this.sweepMode != SweepMode.step);
            this.startLabel.setEnabled(this.sweepMode != SweepMode.step);
            this.startTextField.setBackground(Support.colorScheme.textBackground);
            this.stopTextField.setEnabled(this.sweepMode != SweepMode.step);
            this.stopLabel.setEnabled(this.sweepMode != SweepMode.step);
            this.stopTextField.setBackground(Support.colorScheme.textBackground);
            this.stepValuesLabel.setEnabled(this.sweepMode == SweepMode.step);
            int i = 0;
            while (i < 8) {
                this.stepValuesTextField[i].setEnabled(this.sweepMode == SweepMode.step);
                this.stepValuesTextField[i].setBackground(Support.colorScheme.textBackground);
                ++i;
            }
            this.parse();
        }

        void parse() {
            boolean wasError;
            block29: {
                if (this.idleTextField == null) {
                    return;
                }
                wasError = this.errorCount > 0;
                this.errorCount = 0;
                SweepMode lm = this.sweepMode;
                if (this.linRadioButton.isSelected()) {
                    this.sweepMode = SweepMode.lin;
                } else if (this.logRadioButton.isSelected()) {
                    this.sweepMode = SweepMode.log;
                } else if (this.stepRadioButton.isSelected()) {
                    this.sweepMode = SweepMode.step;
                }
                SetupFormatsAdjuster.AdjustParam ap = this.adjustParam;
                this.adjustParam = (SetupFormatsAdjuster.AdjustParam)this.paramComboBox.getSelectedItem();
                if (this.adjustParam == null) {
                    return;
                }
                this.log = this.logCheckBox.isSelected();
                String oldCmd = this.adjustParam.getCmd();
                if (this.cmdTextField.isEnabled()) {
                    String s = this.cmdTextField.getText().trim();
                    this.adjustParam.setCmd(s);
                    if (s.length() == 0) {
                        this.cmdTextField.setBackground(Support.colorScheme.errorBackground);
                        ++this.errorCount;
                    } else {
                        this.cmdTextField.setBackground(Support.colorScheme.textBackground);
                    }
                } else {
                    this.cmdTextField.setBackground(Support.colorScheme.textBackground);
                }
                if (lm != this.sweepMode || ap != this.adjustParam || !oldCmd.equals(this.adjustParam.getCmd())) {
                    PopupParamSweeper.this.setEnable();
                }
                this.start = Support.parseTextFieldDouble(this.startTextField, this.start, false, this.adjustParam.getMin(), this.adjustParam.getMax());
                this.stop = Support.parseTextFieldDouble(this.stopTextField, this.stop, false, this.adjustParam.getMin(), this.adjustParam.getMax());
                this.idle = Support.parseTextFieldDouble(this.idleTextField, this.idle, false, this.adjustParam.getMin(), this.adjustParam.getMax());
                this.stepTime = Support.parseTextFieldDouble(this.stepTimeTextField, this.stepTime, false, 0.01, 3600.0);
                if (Double.isNaN(this.start)) {
                    ++this.errorCount;
                }
                if (Double.isNaN(this.stop)) {
                    ++this.errorCount;
                }
                if (Double.isNaN(this.idle)) {
                    ++this.errorCount;
                }
                if (Double.isNaN(this.stepTime)) {
                    ++this.errorCount;
                }
                if (this.stepsTextField.isEnabled()) {
                    try {
                        int v = StringUtil.parseInt(this.stepsTextField.getText());
                        if (v >= 1 && (double)v < 1000000.0) {
                            this.steps = v;
                            this.stepsTextField.setBackground(Support.colorScheme.textBackground);
                            break block29;
                        }
                        this.stepsTextField.setBackground(Support.colorScheme.errorBackground);
                        ++this.errorCount;
                    }
                    catch (Exception exception) {
                        this.stepsTextField.setBackground(Support.colorScheme.errorBackground);
                        ++this.errorCount;
                    }
                } else {
                    this.stepsTextField.setBackground(Support.colorScheme.textBackground);
                }
            }
            if (this.stepValuesLabel.isEnabled()) {
                int cnt = 0;
                int i = 0;
                while (i < 8) {
                    double v = Support.parseTextFieldDouble(this.stepValuesTextField[i], Double.NaN, true);
                    if (!Double.isNaN(v)) {
                        this.stepValues[cnt] = v;
                        ++cnt;
                    }
                    ++i;
                }
                if (cnt == 0) {
                    this.stepValuesTextField[0].setBackground(Support.colorScheme.errorBackground);
                    ++this.errorCount;
                }
                i = cnt;
                while (i < 8) {
                    this.stepValues[i] = Double.NaN;
                    ++i;
                }
            } else {
                int i = 0;
                while (i < 8) {
                    this.stepValuesTextField[i].setBackground(Support.colorScheme.textBackground);
                    ++i;
                }
            }
            if (wasError != this.errorCount > 0) {
                PopupParamSweeper.this.setEnable();
            }
            PopupParamSweeper.this.setTime();
        }

        private void setParamsC(CommandProcessor.CmdEnvironment env, String[] params) {
            if (params.length < 3) {
                return;
            }
            String s = env.exp(params[2]);
            for (SetupFormatsAdjuster.AdjustParam ap : SetupFormatsAdjuster.listAdjustableParams(true)) {
                if (!ap.getName().equalsIgnoreCase(s)) continue;
                this.adjustParam = ap;
                this.paramComboBox.setSelectedItem(ap);
                break;
            }
            if (params.length >= 4) {
                this.adjustParam.setCmd(env.exp(params[3]));
            } else {
                this.adjustParam.setCmd("");
            }
            this.log = params.length >= 5 ? params[4].equalsIgnoreCase("log") : false;
            this.logCheckBox.setSelected(this.log);
            this.cmdTextField.setText(this.adjustParam.getCmd());
            PopupParamSweeper.this.setEnable();
        }

        private void setParamsS(CommandProcessor.CmdEnvironment env, String[] params) {
            if (params.length < 8) {
                return;
            }
            String s = env.exp(params[2]);
            SweepMode[] sweepModeArray = SweepMode.values();
            int n = sweepModeArray.length;
            int n2 = 0;
            while (n2 < n) {
                SweepMode sm = sweepModeArray[n2];
                if (sm.name().equalsIgnoreCase(s)) {
                    this.sweepMode = sm;
                    if (sm == SweepMode.lin) {
                        this.linRadioButton.setSelected(true);
                        break;
                    }
                    if (sm == SweepMode.log) {
                        this.logRadioButton.setSelected(true);
                        break;
                    }
                    if (sm != SweepMode.step) break;
                    this.stepRadioButton.setSelected(true);
                    break;
                }
                ++n2;
            }
            this.stepTime = env.expDouble(params[3]);
            this.stepTimeTextField.setText(StringUtil.formatDoubleEE(this.stepTime, false));
            this.steps = env.expInt(params[4]);
            this.stepsTextField.setText(Integer.toString(this.steps));
            this.start = env.expDouble(params[5]);
            this.startTextField.setText(StringUtil.formatDoubleEE(this.start, false));
            this.stop = env.expDouble(params[6]);
            this.stopTextField.setText(StringUtil.formatDoubleEE(this.stop, false));
            this.idle = env.expDouble(params[7]);
            this.idleTextField.setText(StringUtil.formatDoubleEE(this.idle, false));
            PopupParamSweeper.this.setEnable();
        }

        private void setParamsV(CommandProcessor.CmdEnvironment env, String[] params) {
            int i = 0;
            while (i < 8) {
                if (i < params.length - 2) {
                    this.stepValues[i] = env.expDouble(params[i + 2]);
                    this.stepValuesTextField[i].setText(StringUtil.formatDoubleEE(this.stepValues[i], false));
                } else {
                    this.stepValues[i] = Double.NaN;
                    this.stepValuesTextField[i].setText("");
                }
                ++i;
            }
            PopupParamSweeper.this.setEnable();
        }

        public List<String> generateScriptSweepSet() {
            ArrayList<String> list = new ArrayList<String>();
            if (this.adjustParam == null || this.adjustParam.getName() == null) {
                return list;
            }
            String ch = "";
            switch (this.id) {
                case 0: {
                    ch = "P";
                    break;
                }
                case 1: {
                    ch = "S";
                    break;
                }
                case 2: {
                    ch = "T";
                }
            }
            list.add("#SetParamSweeper " + ch + "C \"" + this.adjustParam.getName().replace(":", " ") + "\" \"" + this.adjustParam.getCmd() + "\"" + (this.log ? " log" : ""));
            list.add("#SetParamSweeper " + ch + "S " + this.sweepMode.name() + " " + StringUtil.formatDoubleEE(this.stepTime, false) + " " + Integer.toString(this.steps) + " " + StringUtil.formatDoubleEE(this.start, false) + " " + StringUtil.formatDoubleEE(this.stop, false) + " " + StringUtil.formatDoubleEE(this.idle, false));
            StringBuilder sb = new StringBuilder();
            int i = 0;
            while (i < 8) {
                if (!Double.isNaN(this.stepValues[i])) {
                    if (sb.length() > 0) {
                        sb.append(" ");
                    }
                    sb.append(StringUtil.formatDoubleEE(this.stepValues[i], false));
                }
                ++i;
            }
            if (this.sweepMode == SweepMode.step) {
                list.add("#SetParamSweeper " + ch + "V " + sb.toString());
            }
            return list;
        }

        private JPanel generateSweepPanel() {
            FontAdjust.FontPanel panel = new FontAdjust.FontPanel();
            panel.setLayout(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            ButtonGroup bg = new ButtonGroup();
            JPanel radioPanel = new JPanel();
            radioPanel.setBorder(BorderFactory.createEmptyBorder());
            radioPanel.setLayout(new BoxLayout(radioPanel, 1));
            c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = 0;
            c.anchor = 17;
            c.weightx = 1.0;
            c.weighty = 1.0;
            c.gridheight = 3;
            panel.add((Component)radioPanel, c);
            this.linRadioButton = new FontAdjust.FontRadioButton("Linear");
            this.linRadioButton.setToolTipText("Do a linear sweep from start to stop");
            this.linRadioButton.setActionCommand("C" + this.id);
            this.linRadioButton.addActionListener(this);
            radioPanel.add(this.linRadioButton);
            this.linRadioButton.setSelected(true);
            bg.add(this.linRadioButton);
            this.logRadioButton = new FontAdjust.FontRadioButton("Logarithmic");
            this.linRadioButton.setToolTipText("Do a logarithmic sweep from start to stop");
            this.logRadioButton.setActionCommand("C" + this.id);
            this.logRadioButton.addActionListener(this);
            radioPanel.add(this.logRadioButton);
            bg.add(this.logRadioButton);
            this.stepRadioButton = new FontAdjust.FontRadioButton("Steps");
            this.linRadioButton.setToolTipText("Do a sample at each of the specified values, this sweep type is not recommended for Primary");
            this.stepRadioButton.setActionCommand("C" + this.id);
            this.stepRadioButton.addActionListener(this);
            radioPanel.add(this.stepRadioButton);
            bg.add(this.stepRadioButton);
            JPanel line1Panel = new JPanel();
            line1Panel.setLayout(new BoxLayout(line1Panel, 0));
            line1Panel.setBorder(BorderFactory.createEmptyBorder());
            c = new GridBagConstraints();
            c.gridx = 1;
            c.gridy = 0;
            c.anchor = 17;
            c.weightx = 1.0;
            c.weighty = 1.0;
            panel.add((Component)line1Panel, c);
            this.paramComboBox = new FontAdjust.FontComboBox<SetupFormatsAdjuster.AdjustParam>();
            this.paramComboBox.setMinimumSize(new Dimension(150, 20));
            this.paramComboBox.addActionListener(this);
            this.paramComboBox.setActionCommand("C" + this.id);
            this.paramComboBox.setMaximumRowCount(30);
            this.paramComboBox.setToolTipText("Select parameter to adjust (Not all listed may be valid at the current time)");
            for (SetupFormatsAdjuster.AdjustParam ap : SetupFormatsAdjuster.listAdjustableParams(true)) {
                this.paramComboBox.addItem(ap);
            }
            line1Panel.add(this.paramComboBox);
            this.cmdTextField = new FontAdjust.FontTextField(20);
            this.cmdTextField.setMinimumSize(new Dimension(100, 20));
            this.cmdTextField.addActionListener(this);
            this.cmdTextField.setActionCommand("C" + this.id);
            this.cmdTextField.setToolTipText("SCPI command to set value, a # will be replaced with value");
            this.cmdTextField.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent arg0) {
                    SweepSet.this.cmdTextField.selectAll();
                }

                @Override
                public void focusLost(FocusEvent arg0) {
                    SweepSet.this.actionPerformed(new ActionEvent(SweepSet.this.cmdTextField, 0, "C" + SweepSet.this.id));
                }
            });
            line1Panel.add(Box.createHorizontalStrut(30));
            this.cmdLabel = new FontAdjust.FontLabel("Cmd: ");
            line1Panel.add(this.cmdLabel);
            line1Panel.add(this.cmdTextField);
            this.logCheckBox = new FontAdjust.FontCheckBox("Log");
            this.logCheckBox.setToolTipText("Include parameter in logging, depending on parameter this may be redundant");
            this.logCheckBox.setActionCommand("log");
            this.logCheckBox.addActionListener(this);
            line1Panel.add(Box.createHorizontalStrut(10));
            line1Panel.add(this.logCheckBox);
            JPanel line2Panel = new JPanel();
            line2Panel.setLayout(new BoxLayout(line2Panel, 0));
            line2Panel.setBorder(BorderFactory.createEmptyBorder());
            c = new GridBagConstraints();
            c.gridx = 1;
            c.gridy = 1;
            c.anchor = 17;
            c.weightx = 1.0;
            c.weighty = 1.0;
            panel.add((Component)line2Panel, c);
            this.stepTimeTextField = new FontAdjust.FontTextField(6);
            this.stepTimeTextField.setText("1");
            this.stepTimeTextField.setMinimumSize(new Dimension(60, 20));
            this.stepTimeTextField.addActionListener(this);
            this.stepTimeTextField.setActionCommand("C" + this.id);
            this.stepTimeTextField.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent arg0) {
                    SweepSet.this.stepTimeTextField.selectAll();
                }

                @Override
                public void focusLost(FocusEvent arg0) {
                    SweepSet.this.actionPerformed(new ActionEvent(SweepSet.this.stepTimeTextField, 0, "C" + SweepSet.this.id));
                }
            });
            this.stepTimeLabel = new FontAdjust.FontLabel("Step time: ");
            line2Panel.add(this.stepTimeLabel);
            line2Panel.add(this.stepTimeTextField);
            this.stepsTextField = new FontAdjust.FontTextField(6);
            this.stepsTextField.setText("100");
            this.stepsTextField.setMinimumSize(new Dimension(60, 20));
            this.stepsTextField.addActionListener(this);
            this.stepsTextField.setActionCommand("C" + this.id);
            this.stepsTextField.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent arg0) {
                    SweepSet.this.stepsTextField.selectAll();
                }

                @Override
                public void focusLost(FocusEvent arg0) {
                    SweepSet.this.actionPerformed(new ActionEvent(SweepSet.this.stepsTextField, 0, "C" + SweepSet.this.id));
                }
            });
            line2Panel.add(Box.createHorizontalStrut(10));
            this.stepsLabel = new FontAdjust.FontLabel("Steps: ");
            line2Panel.add(this.stepsLabel);
            line2Panel.add(this.stepsTextField);
            this.startTextField = new FontAdjust.FontTextField(6);
            this.startTextField.setText("1.0");
            this.startTextField.setMinimumSize(new Dimension(60, 20));
            this.startTextField.addActionListener(this);
            this.startTextField.setActionCommand("C" + this.id);
            this.startTextField.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent arg0) {
                    SweepSet.this.startTextField.selectAll();
                }

                @Override
                public void focusLost(FocusEvent arg0) {
                    SweepSet.this.actionPerformed(new ActionEvent(SweepSet.this.startTextField, 0, "C" + SweepSet.this.id));
                }
            });
            line2Panel.add(Box.createHorizontalStrut(10));
            this.startLabel = new FontAdjust.FontLabel("Start: ");
            line2Panel.add(this.startLabel);
            line2Panel.add(this.startTextField);
            this.stopTextField = new FontAdjust.FontTextField(6);
            this.stopTextField.setText("10.0");
            this.stopTextField.setMinimumSize(new Dimension(60, 20));
            this.stopTextField.addActionListener(this);
            this.stopTextField.setActionCommand("C" + this.id);
            this.stopTextField.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent arg0) {
                    SweepSet.this.stopTextField.selectAll();
                }

                @Override
                public void focusLost(FocusEvent arg0) {
                    SweepSet.this.actionPerformed(new ActionEvent(SweepSet.this.stopTextField, 0, "C" + SweepSet.this.id));
                }
            });
            line2Panel.add(Box.createHorizontalStrut(10));
            this.stopLabel = new FontAdjust.FontLabel("Stop: ");
            line2Panel.add(this.stopLabel);
            line2Panel.add(this.stopTextField);
            this.idleTextField = new FontAdjust.FontTextField(6);
            this.idleTextField.setToolTipText("Value when other channels are updated and/or when finished");
            this.idleTextField.setText("1.0");
            this.idleTextField.setMinimumSize(new Dimension(60, 20));
            this.idleTextField.addActionListener(this);
            this.idleTextField.setActionCommand("C" + this.id);
            this.idleTextField.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent arg0) {
                    SweepSet.this.idleTextField.selectAll();
                }

                @Override
                public void focusLost(FocusEvent arg0) {
                    SweepSet.this.actionPerformed(new ActionEvent(SweepSet.this.idleTextField, 0, "C" + SweepSet.this.id));
                }
            });
            line2Panel.add(Box.createHorizontalStrut(10));
            this.idleLabel = new FontAdjust.FontLabel("Idle: ");
            line2Panel.add(this.idleLabel);
            line2Panel.add(this.idleTextField);
            JPanel line3Panel = new JPanel();
            line3Panel.setLayout(new BoxLayout(line3Panel, 0));
            line3Panel.setBorder(BorderFactory.createEmptyBorder());
            c = new GridBagConstraints();
            c.gridx = 1;
            c.gridy = 2;
            c.anchor = 17;
            c.weightx = 1.0;
            c.weighty = 1.0;
            panel.add((Component)line3Panel, c);
            this.stepValuesLabel = new FontAdjust.FontLabel("Values: ");
            line3Panel.add(this.stepValuesLabel);
            int i = 0;
            while (i < 8) {
                this.stepValuesTextField[i] = new FontAdjust.FontTextField(6);
                this.stepValuesTextField[i].setText(i == 0 ? "1" : "");
                this.stepValuesTextField[i].setMinimumSize(new Dimension(60, 20));
                this.stepValuesTextField[i].addActionListener(this);
                this.stepValuesTextField[i].setActionCommand("C" + this.id);
                this.stepValuesTextField[i].addFocusListener(new FocusListener(){

                    @Override
                    public void focusGained(FocusEvent arg0) {
                        ((JTextField)arg0.getSource()).selectAll();
                    }

                    @Override
                    public void focusLost(FocusEvent arg0) {
                        SweepSet.this.actionPerformed(new ActionEvent(arg0.getSource(), 0, "C" + SweepSet.this.id));
                    }
                });
                line3Panel.add(this.stepValuesTextField[i]);
                ++i;
            }
            return panel;
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            this.parse();
        }
    }

    private static enum SweepType {
        Primary_only,
        Primary_then_secondary,
        Primary_and_secondary_simultanously,
        Primary_and_secondary,
        Primary_then_secondary_then_tertiary,
        Primary_and_secondary_and_tertiary,
        Primary_then_secondary_and_tertiary,
        Primary_and_secondary_simultanously_and_tertiary;

    }

    private class UpdateThread
    extends Thread {
        private boolean stopSweep = true;
        private WriterThread w0 = null;
        private WriterThread w1 = null;
        private WriterThread w2 = null;
        private Script script = new Script();

        UpdateThread() {
            this.setName("ParamSweeperUpdater");
            this.setDaemon(true);
            this.start();
        }

        void setOn(boolean p, boolean s, boolean t) {
            if (p) {
                ((PopupParamSweeper)PopupParamSweeper.this).sweepSet[0].adjustParam.setDeviceOn(true);
            }
            if (s) {
                ((PopupParamSweeper)PopupParamSweeper.this).sweepSet[1].adjustParam.setDeviceOn(true);
            }
            if (t) {
                ((PopupParamSweeper)PopupParamSweeper.this).sweepSet[2].adjustParam.setDeviceOn(true);
            }
        }

        boolean isBreak() {
            boolean breakSweep = false;
            InterfaceThreads.setupVars();
            Support.math.calcAllColumns(this.script, "ParamSweeper");
            Breaker[] breakerArray = PopupParamSweeper.this.breakers;
            int n = breakerArray.length;
            int n2 = 0;
            while (n2 < n) {
                Breaker b = breakerArray[n2];
                if (b.isBreak(this.script)) {
                    breakSweep = true;
                    PopupParamSweeper.this.breakDetected = true;
                    if (b.isAll()) {
                        this.stopSweep = true;
                    }
                }
                ++n2;
            }
            return breakSweep;
        }

        void startLog() {
            if (!PopupParamSweeper.this.saveLogEach || InterfaceThreads.isLogging() || this.stopSweep) {
                return;
            }
            Support.math.resetCalc("ParamSweeper");
            CommandProcessor.sysCmdLog(PopupParamSweeper.this.logInterval, null, false);
        }

        void stopLog(String name) {
            if (!PopupParamSweeper.this.saveLogEach || !InterfaceThreads.isLogging() || this.stopSweep) {
                return;
            }
            CommandProcessor.sysCmdLog(0.0, null, false);
            String fname = PopupParamSweeper.this.logFilename;
            if (fname == null || fname.length() == 0) {
                SimpleDateFormat dt = new SimpleDateFormat("yyyyMMddHHmmss");
                fname = "PSLog " + dt.format(new Date());
            }
            if (name != null) {
                fname = String.valueOf(fname) + " " + name;
            }
            try {
                Support.dataBase.save(Support.fileWithExtension(fname, Support.getDataPath(), ".csv"));
            }
            catch (IOException e) {
                InterfaceThreads.log(";; ParamSweeper failed to save log: " + fname);
                e.printStackTrace(System.out);
            }
            if (PopupParamSweeper.this.saveChartEach) {
                ImageSaver imageSaver = new ImageSaver(fname);
                try {
                    SwingUtilities.invokeAndWait(imageSaver);
                }
                catch (InterruptedException | InvocationTargetException e) {
                    e.printStackTrace(System.out);
                }
            }
        }

        void wait(double time) {
            if (this.stopSweep) {
                return;
            }
            long t = System.currentTimeMillis() + (long)(time * 1000.0);
            while (t > System.currentTimeMillis()) {
                QueueMessage qm = (QueueMessage)((Object)PopupParamSweeper.this.queue.poll());
                if (qm == QueueMessage.Stop || qm == QueueMessage.Quit) {
                    this.stopSweep = true;
                    return;
                }
                long dt = t - System.currentTimeMillis();
                CommInterface.sleep(dt > 50L ? 50 : (int)dt);
            }
        }

        void waitPauseLog(String name) {
            if (!PopupParamSweeper.this.logPause) {
                this.stopLog(name);
            }
            this.wait(PopupParamSweeper.this.pauseTime);
            if (PopupParamSweeper.this.logPause) {
                this.stopLog(name);
            }
        }

        void primaryAndSecondary() {
            this.setOn(true, true, false);
            int j = 0;
            while (j < PopupParamSweeper.this.sweepSet[1].getSteps()) {
                double r = (double)j / (double)(PopupParamSweeper.this.sweepSet[1].getSteps() - 1);
                this.w1.update(r);
                this.w0.update(0.0);
                this.wait(PopupParamSweeper.this.prepareTime);
                this.startLog();
                int i = 0;
                while (i < PopupParamSweeper.this.sweepSet[0].getSteps() && !this.isBreak()) {
                    this.w0.update((double)i / (double)(PopupParamSweeper.this.sweepSet[0].getSteps() - 1));
                    this.wait(((PopupParamSweeper)PopupParamSweeper.this).sweepSet[0].stepTime);
                    if (this.stopSweep) {
                        return;
                    }
                    ++i;
                }
                this.wait(((PopupParamSweeper)PopupParamSweeper.this).sweepSet[0].stepTime);
                if (this.stopSweep) {
                    return;
                }
                this.w0.update(-1.0);
                this.w1.update(-1.0);
                if (((PopupParamSweeper)PopupParamSweeper.this).sweepSet[1].sweepMode == SweepMode.step) {
                    this.waitPauseLog(PopupParamSweeper.this.sweepSet[1].getUpdateName(r));
                } else if (j < PopupParamSweeper.this.sweepSet[1].getSteps()) {
                    this.wait(PopupParamSweeper.this.pauseTime);
                }
                ++j;
            }
            this.stopLog(null);
        }

        void primaryAndSecondaryAndTertiary() {
            this.setOn(true, true, true);
            int k = 0;
            while (k < PopupParamSweeper.this.sweepSet[2].getSteps()) {
                double r2 = (double)k / (double)(PopupParamSweeper.this.sweepSet[2].getSteps() - 1);
                this.w2.update(r2);
                int j = 0;
                while (j < PopupParamSweeper.this.sweepSet[1].getSteps()) {
                    double r1 = (double)j / (double)(PopupParamSweeper.this.sweepSet[1].getSteps() - 1);
                    this.w1.update(r1);
                    this.w0.update(0.0);
                    this.wait(PopupParamSweeper.this.prepareTime);
                    this.startLog();
                    int i = 0;
                    while (i < PopupParamSweeper.this.sweepSet[0].getSteps() && !this.isBreak()) {
                        this.w0.update((double)i / (double)(PopupParamSweeper.this.sweepSet[0].getSteps() - 1));
                        this.wait(((PopupParamSweeper)PopupParamSweeper.this).sweepSet[0].stepTime);
                        if (this.stopSweep) {
                            return;
                        }
                        ++i;
                    }
                    this.wait(((PopupParamSweeper)PopupParamSweeper.this).sweepSet[0].stepTime);
                    if (this.stopSweep) {
                        return;
                    }
                    this.w0.update(-1.0);
                    this.w1.update(-1.0);
                    this.w2.update(-1.0);
                    if (((PopupParamSweeper)PopupParamSweeper.this).sweepSet[1].sweepMode == SweepMode.step && ((PopupParamSweeper)PopupParamSweeper.this).sweepSet[2].sweepMode == SweepMode.step) {
                        this.waitPauseLog(String.valueOf(PopupParamSweeper.this.sweepSet[2].getUpdateName(r2)) + " " + PopupParamSweeper.this.sweepSet[1].getUpdateName(r1));
                    } else if (j < PopupParamSweeper.this.sweepSet[1].getSteps()) {
                        this.wait(PopupParamSweeper.this.pauseTime);
                    }
                    ++j;
                }
                if (((PopupParamSweeper)PopupParamSweeper.this).sweepSet[2].sweepMode == SweepMode.step) {
                    this.stopLog(PopupParamSweeper.this.sweepSet[2].getUpdateName(r2));
                }
                ++k;
            }
            this.w0.update(-1.0);
            this.w1.update(-1.0);
            this.w2.update(-1.0);
            this.waitPauseLog(null);
        }

        void primaryAndSecondarySimultanously() {
            this.setOn(true, true, false);
            this.w0.update(0.0);
            this.w1.update(0.0);
            this.wait(PopupParamSweeper.this.prepareTime);
            this.startLog();
            int i = 0;
            while (i < PopupParamSweeper.this.sweepSet[0].getSteps() && !this.isBreak()) {
                double r = (double)i / (double)(PopupParamSweeper.this.sweepSet[0].getSteps() - 1);
                this.w0.update(r);
                this.w1.update(r);
                this.wait(((PopupParamSweeper)PopupParamSweeper.this).sweepSet[0].stepTime);
                if (this.stopSweep) {
                    return;
                }
                ++i;
            }
            this.wait(((PopupParamSweeper)PopupParamSweeper.this).sweepSet[0].stepTime);
            this.w0.update(-1.0);
            this.w1.update(-1.0);
            this.waitPauseLog(null);
        }

        void primaryOnly() {
            this.setOn(true, false, false);
            this.w0.update(0.0);
            this.wait(PopupParamSweeper.this.prepareTime);
            this.startLog();
            int i = 0;
            while (i < PopupParamSweeper.this.sweepSet[0].getSteps() && !this.isBreak()) {
                this.w0.update((double)i / (double)(PopupParamSweeper.this.sweepSet[0].getSteps() - 1));
                this.wait(((PopupParamSweeper)PopupParamSweeper.this).sweepSet[0].stepTime);
                if (this.stopSweep) {
                    return;
                }
                ++i;
            }
            this.wait(((PopupParamSweeper)PopupParamSweeper.this).sweepSet[0].stepTime);
            this.w0.update(-1.0);
            this.waitPauseLog(null);
        }

        void primaryThenSecondary() {
            this.setOn(true, true, false);
            this.w1.update(-1.0);
            this.w0.update(0.0);
            this.wait(PopupParamSweeper.this.prepareTime);
            this.startLog();
            int i = 0;
            while (i < PopupParamSweeper.this.sweepSet[0].getSteps() && !this.isBreak()) {
                this.w0.update((double)i / (double)(PopupParamSweeper.this.sweepSet[0].getSteps() - 1));
                this.wait(((PopupParamSweeper)PopupParamSweeper.this).sweepSet[0].stepTime);
                if (this.stopSweep) {
                    return;
                }
                ++i;
            }
            this.wait(((PopupParamSweeper)PopupParamSweeper.this).sweepSet[0].stepTime);
            if (this.stopSweep) {
                return;
            }
            this.w0.update(-1.0);
            this.waitPauseLog("Primary");
            this.w1.update(0.0);
            this.wait(PopupParamSweeper.this.prepareTime);
            this.startLog();
            i = 0;
            while (i < PopupParamSweeper.this.sweepSet[1].getSteps() && !this.isBreak()) {
                this.w1.update((double)i / (double)(PopupParamSweeper.this.sweepSet[1].getSteps() - 1));
                this.wait(((PopupParamSweeper)PopupParamSweeper.this).sweepSet[1].stepTime);
                if (this.stopSweep) {
                    return;
                }
                ++i;
            }
            this.wait(((PopupParamSweeper)PopupParamSweeper.this).sweepSet[1].stepTime);
            this.w1.update(-1.0);
            this.waitPauseLog("Secondary");
        }

        void primaryThenSecondaryThenTertiary() {
            this.setOn(true, true, true);
            this.w1.update(-1.0);
            this.w2.update(-1.0);
            this.w0.update(0.0);
            this.wait(PopupParamSweeper.this.prepareTime);
            this.startLog();
            int i = 0;
            while (i < PopupParamSweeper.this.sweepSet[0].getSteps() && !this.isBreak()) {
                this.w0.update((double)i / (double)(PopupParamSweeper.this.sweepSet[0].getSteps() - 1));
                this.wait(((PopupParamSweeper)PopupParamSweeper.this).sweepSet[0].stepTime);
                if (this.stopSweep) {
                    return;
                }
                ++i;
            }
            this.wait(((PopupParamSweeper)PopupParamSweeper.this).sweepSet[0].stepTime);
            if (this.stopSweep) {
                return;
            }
            this.w0.update(-1.0);
            this.w1.update(-1.0);
            this.w2.update(-1.0);
            this.waitPauseLog("Primary");
            this.w1.update(0.0);
            this.wait(PopupParamSweeper.this.prepareTime);
            this.startLog();
            i = 0;
            while (i < PopupParamSweeper.this.sweepSet[1].getSteps() && !this.isBreak()) {
                this.w1.update((double)i / (double)(PopupParamSweeper.this.sweepSet[1].getSteps() - 1));
                this.wait(((PopupParamSweeper)PopupParamSweeper.this).sweepSet[1].stepTime);
                if (this.stopSweep) {
                    return;
                }
                ++i;
            }
            this.wait(((PopupParamSweeper)PopupParamSweeper.this).sweepSet[1].stepTime);
            if (this.stopSweep) {
                return;
            }
            this.w0.update(-1.0);
            this.w1.update(-1.0);
            this.w2.update(-1.0);
            this.waitPauseLog("Secondary");
            this.w2.update(0.0);
            this.wait(PopupParamSweeper.this.prepareTime);
            this.startLog();
            i = 0;
            while (i < PopupParamSweeper.this.sweepSet[2].getSteps() && !this.isBreak()) {
                this.w2.update((double)i / (double)(PopupParamSweeper.this.sweepSet[2].getSteps() - 1));
                this.wait(((PopupParamSweeper)PopupParamSweeper.this).sweepSet[2].stepTime);
                if (this.stopSweep) {
                    return;
                }
                ++i;
            }
            this.wait(((PopupParamSweeper)PopupParamSweeper.this).sweepSet[2].stepTime);
            this.w0.update(-1.0);
            this.w1.update(-1.0);
            this.w2.update(-1.0);
            this.waitPauseLog("Tertiary");
        }

        void primaryThenSecondaryAndTertiary() {
            this.setOn(true, true, true);
            int k = 0;
            while (k < PopupParamSweeper.this.sweepSet[2].getSteps()) {
                double r2 = (double)k / (double)(PopupParamSweeper.this.sweepSet[2].getSteps() - 1);
                this.w1.update(-1.0);
                this.w0.update(0.0);
                this.w2.update(r2);
                this.wait(PopupParamSweeper.this.prepareTime);
                this.startLog();
                int i = 0;
                while (i < PopupParamSweeper.this.sweepSet[0].getSteps() && !this.isBreak()) {
                    this.w0.update((double)i / (double)(PopupParamSweeper.this.sweepSet[0].getSteps() - 1));
                    this.wait(((PopupParamSweeper)PopupParamSweeper.this).sweepSet[0].stepTime);
                    if (this.stopSweep) {
                        return;
                    }
                    ++i;
                }
                this.wait(((PopupParamSweeper)PopupParamSweeper.this).sweepSet[0].stepTime);
                if (this.stopSweep) {
                    return;
                }
                this.w0.update(-1.0);
                this.w1.update(-1.0);
                this.w2.update(-1.0);
                if (((PopupParamSweeper)PopupParamSweeper.this).sweepSet[2].sweepMode == SweepMode.step) {
                    this.waitPauseLog(String.valueOf(PopupParamSweeper.this.sweepSet[2].getUpdateName(r2)) + " Primary");
                } else {
                    this.wait(PopupParamSweeper.this.pauseTime);
                }
                this.w1.update(0.0);
                this.wait(PopupParamSweeper.this.prepareTime);
                this.startLog();
                i = 0;
                while (i < PopupParamSweeper.this.sweepSet[1].getSteps() && !this.isBreak()) {
                    this.w1.update((double)i / (double)(PopupParamSweeper.this.sweepSet[1].getSteps() - 1));
                    this.wait(((PopupParamSweeper)PopupParamSweeper.this).sweepSet[1].stepTime);
                    if (this.stopSweep) {
                        return;
                    }
                    ++i;
                }
                this.wait(((PopupParamSweeper)PopupParamSweeper.this).sweepSet[1].stepTime);
                this.w0.update(-1.0);
                this.w1.update(-1.0);
                this.w2.update(-1.0);
                if (((PopupParamSweeper)PopupParamSweeper.this).sweepSet[2].sweepMode == SweepMode.step) {
                    this.waitPauseLog(String.valueOf(PopupParamSweeper.this.sweepSet[2].getUpdateName(r2)) + " Secondary");
                } else {
                    this.wait(PopupParamSweeper.this.pauseTime);
                }
                ++k;
            }
            this.stopLog(null);
        }

        void primaryAndSecondarySimultanouslySndTertiary() {
            this.setOn(true, true, true);
            int k = 0;
            while (k < PopupParamSweeper.this.sweepSet[2].getSteps()) {
                double r2 = (double)k / (double)(PopupParamSweeper.this.sweepSet[2].getSteps() - 1);
                this.w0.update(0.0);
                this.w1.update(0.0);
                this.w2.update(r2);
                this.wait(PopupParamSweeper.this.prepareTime);
                this.startLog();
                int i = 0;
                while (i < PopupParamSweeper.this.sweepSet[0].getSteps() && !this.isBreak()) {
                    double r = (double)i / (double)(PopupParamSweeper.this.sweepSet[0].getSteps() - 1);
                    this.w0.update(r);
                    this.w1.update(r);
                    this.wait(((PopupParamSweeper)PopupParamSweeper.this).sweepSet[0].stepTime);
                    if (this.stopSweep) {
                        return;
                    }
                    ++i;
                }
                this.wait(((PopupParamSweeper)PopupParamSweeper.this).sweepSet[0].stepTime);
                if (this.stopSweep) {
                    return;
                }
                this.w0.update(-1.0);
                this.w1.update(-1.0);
                this.w2.update(-1.0);
                if (((PopupParamSweeper)PopupParamSweeper.this).sweepSet[2].sweepMode == SweepMode.step) {
                    this.waitPauseLog(PopupParamSweeper.this.sweepSet[2].getUpdateName(r2));
                } else {
                    this.wait(PopupParamSweeper.this.pauseTime);
                }
                ++k;
            }
            this.stopLog(null);
        }

        public boolean isSweeping() {
            return !this.stopSweep;
        }

        @Override
        public void run() {
            this.w0 = new WriterThread(0, this.script.getLocalVars().getCreate("p"));
            this.w1 = new WriterThread(1, this.script.getLocalVars().getCreate("s"));
            this.w2 = new WriterThread(2, this.script.getLocalVars().getCreate("t"));
            Support.math.resetCalc("ParamSweeper");
            while (PopupParamSweeper.this.popupOpen) {
                try {
                    QueueMessage v = (QueueMessage)((Object)PopupParamSweeper.this.queue.take());
                    if (v == QueueMessage.Quit) {
                        this.w0.update(Double.NaN);
                        this.w1.update(Double.NaN);
                        this.w2.update(Double.NaN);
                        return;
                    }
                    if (v != QueueMessage.Start) continue;
                    this.stopSweep = false;
                    PopupParamSweeper.this.breakDetected = false;
                    if (PopupParamSweeper.this.saveLogEach) {
                        CommandProcessor.sysCmdLog(0.0, null, false);
                    }
                    switch (PopupParamSweeper.this.sweepType) {
                        case Primary_and_secondary: {
                            this.primaryAndSecondary();
                            this.w0.update(-1.0);
                            this.w1.update(-1.0);
                            break;
                        }
                        case Primary_and_secondary_and_tertiary: {
                            this.primaryAndSecondaryAndTertiary();
                            this.w0.update(-1.0);
                            this.w1.update(-1.0);
                            this.w2.update(-1.0);
                            break;
                        }
                        case Primary_and_secondary_simultanously: {
                            this.primaryAndSecondarySimultanously();
                            this.w0.update(-1.0);
                            this.w1.update(-1.0);
                            break;
                        }
                        case Primary_only: {
                            this.primaryOnly();
                            this.w0.update(-1.0);
                            break;
                        }
                        case Primary_then_secondary: {
                            this.primaryThenSecondary();
                            this.w0.update(-1.0);
                            this.w1.update(-1.0);
                            break;
                        }
                        case Primary_then_secondary_then_tertiary: {
                            this.primaryThenSecondaryThenTertiary();
                            this.w0.update(-1.0);
                            this.w1.update(-1.0);
                            this.w2.update(-1.0);
                            break;
                        }
                        case Primary_then_secondary_and_tertiary: {
                            this.primaryThenSecondaryAndTertiary();
                            this.w0.update(-1.0);
                            this.w1.update(-1.0);
                            this.w2.update(-1.0);
                            break;
                        }
                        case Primary_and_secondary_simultanously_and_tertiary: {
                            this.primaryAndSecondarySimultanouslySndTertiary();
                            this.w0.update(-1.0);
                            this.w1.update(-1.0);
                            this.w2.update(-1.0);
                            break;
                        }
                    }
                    PopupParamSweeper.this.hasSwept = !this.stopSweep;
                    this.stopSweep = true;
                    if (!PopupParamSweeper.this.breakDetected) continue;
                    InterfaceThreads.log(";; Breaks from Breaker where detected during param sweep");
                }
                catch (Exception e) {
                    e.printStackTrace(System.out);
                }
            }
            this.w0.update(Double.NaN);
            this.w1.update(Double.NaN);
            this.w2.update(Double.NaN);
        }

        class ImageSaver
        implements Runnable {
            private String fname;

            ImageSaver(String fname) {
                this.fname = fname;
            }

            @Override
            public void run() {
                Support.chartTitle = null;
                Support.paneChart.saveChart(this.fname, Support.systemSettings.imageResolution[0].width, Support.systemSettings.imageResolution[0].height);
            }
        }
    }

    private class WriterThread
    extends Thread {
        private BlockingQueue<Double> queue = new ArrayBlockingQueue<Double>(5);
        private int id;
        private Var vv;

        WriterThread(int id, Var v) {
            this.id = id;
            this.vv = v;
            this.setName("ParamSweeperWriter" + PopupParamSweeper.this.idText[id]);
            this.setDaemon(true);
            this.start();
        }

        public void update(double v) {
            try {
                this.queue.put(v);
            }
            catch (InterruptedException e) {
                e.printStackTrace(System.out);
            }
        }

        @Override
        public void run() {
            while (PopupParamSweeper.this.popupOpen) {
                try {
                    double v = this.queue.take();
                    if (this.queue.size() > 0) {
                        v = this.queue.take();
                    }
                    if (Double.isNaN(v)) {
                        return;
                    }
                    v = PopupParamSweeper.this.sweepSet[this.id].getUpdateValue(v);
                    PopupParamSweeper.this.sweepSet[this.id].write(v);
                    this.vv.set(v);
                }
                catch (Exception e) {
                    e.printStackTrace(System.out);
                }
            }
        }
    }
}

