/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.main;

import dk.hkj.devices.SetupFormatsAdjuster;
import dk.hkj.main.FontAdjust;
import dk.hkj.main.PopupBase;
import dk.hkj.main.Support;
import dk.hkj.util.CharacterEscapes;
import dk.hkj.util.StringUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class PopupParamAdjuster
extends PopupBase
implements ActionListener,
ChangeListener {
    private static List<PopupParamAdjuster> popupList = new ArrayList<PopupParamAdjuster>();
    private JSlider slider = null;
    private JComboBox<SetupFormatsAdjuster.AdjustParam> paramComboBox = null;
    private JTextField minTextField = null;
    private JTextField maxTextField = null;
    private JTextField cmdTextField = null;
    private JLabel cmdLabel = null;
    private SetupFormatsAdjuster.AdjustParam adjustParam = null;
    private double[] sliderEntries = null;
    private double min = 0.0;
    private double max = 0.0;
    private double lastValue;
    private boolean initDone = false;
    private boolean popupOpen = false;
    private boolean highres = false;
    private int inSetup = 0;
    private boolean log = false;
    private BlockingQueue<Double> queue = new ArrayBlockingQueue<Double>(5);

    public static void valueChanged(String page, String name, double value) {
        block3: for (PopupParamAdjuster pa : popupList) {
            if (pa.adjustParam == null || !pa.adjustParam.getPageName().equals(page) || !pa.adjustParam.getControlName().equals(name)) continue;
            ++pa.inSetup;
            try {
                pa.showTitle(value);
                pa.lastValue = value;
                int i = 0;
                while (i < pa.sliderEntries.length) {
                    if (pa.sliderEntries[i] >= value) {
                        pa.slider.setValue(i);
                        continue block3;
                    }
                    ++i;
                }
            }
            finally {
                --pa.inSetup;
            }
        }
    }

    public static void closePopup(final int no) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                int n;
                if (no < 0) {
                    int i = popupList.size() - 1;
                    while (i >= 0) {
                        ((PopupParamAdjuster)popupList.get(i)).setEnabled(false);
                        --i;
                    }
                }
                if ((n = no) > 0) {
                    --n;
                }
                if (n < popupList.size()) {
                    ((PopupParamAdjuster)popupList.get(n)).setVisible(false);
                }
            }
        });
    }

    public void selectDevice(String handle) {
        int i = 0;
        while (i < this.paramComboBox.getItemCount()) {
            String s = this.paramComboBox.getItemAt(i).getHandle();
            if (handle.equalsIgnoreCase(s)) {
                this.paramComboBox.setSelectedIndex(i);
                this.adjustParam = (SetupFormatsAdjuster.AdjustParam)this.paramComboBox.getSelectedItem();
                this.setupSelected();
                return;
            }
            ++i;
        }
    }

    public static PopupParamAdjuster getPopup(String handle) {
        Point p = Support.paneCommand.popupsButton.getLocationOnScreen();
        p.translate(-750, -400 + popupList.size() * -100);
        if (p.y < 0) {
            p.y = 0;
        }
        PopupParamAdjuster pa = new PopupParamAdjuster(handle);
        pa.setLocation(p);
        pa.setVisible(true);
        return pa;
    }

    public static PopupParamAdjuster getPopup() {
        return PopupParamAdjuster.getPopup(popupList.size() + 1);
    }

    public static PopupParamAdjuster getPopup(int no) {
        if (no > 0) {
            --no;
        }
        if (no < popupList.size()) {
            return popupList.get(no);
        }
        Point p = Support.paneCommand.popupsButton.getLocationOnScreen();
        p.translate(-750, -400 + popupList.size() * -100);
        if (p.y < 0) {
            p.y = 0;
        }
        PopupParamAdjuster pa = new PopupParamAdjuster();
        pa.setLocation(p);
        pa.setVisible(true);
        return pa;
    }

    public static void setParams(final int no, final String name, final Double min, final Double max, final String cmd) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PopupParamAdjuster pa = PopupParamAdjuster.getPopup(no);
                int i = 0;
                while (i < pa.paramComboBox.getItemCount()) {
                    if (((SetupFormatsAdjuster.AdjustParam)pa.paramComboBox.getItemAt(i)).getName().equalsIgnoreCase(name)) {
                        pa.paramComboBox.setSelectedIndex(i);
                        break;
                    }
                    ++i;
                }
                pa.paramComboBox.setSelectedItem(name);
                pa.adjustParam = (SetupFormatsAdjuster.AdjustParam)pa.paramComboBox.getSelectedItem();
                pa.setupSelected();
                if (min != null && max != null) {
                    pa.minTextField.setText(StringUtil.formatDoubleEE(min));
                    pa.maxTextField.setText(StringUtil.formatDoubleEE(max));
                    pa.setupRange();
                }
                if (cmd != null && cmd.length() > 0) {
                    pa.cmdTextField.setText(cmd);
                    pa.setupCmd();
                }
            }
        });
    }

    private PopupParamAdjuster() {
        this.init();
        this.filterParams("*");
    }

    private PopupParamAdjuster(String defaultHandle) {
        this.init();
        this.filterParams("!(" + defaultHandle + " .*)|(SCPI.*" + defaultHandle + ")|(" + defaultHandle + ")");
    }

    private void init() {
        popupList.add(this);
        if (popupList.size() > 1) {
            this.disableSaveLocation();
        }
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                popupList.remove(PopupParamAdjuster.this);
                PopupParamAdjuster.this.popupOpen = false;
                try {
                    PopupParamAdjuster.this.queue.put(0.0);
                }
                catch (InterruptedException interruptedException) {}
            }

            @Override
            public void windowActivated(WindowEvent arg0) {
                if (PopupParamAdjuster.this.slider != null) {
                    PopupParamAdjuster.this.slider.requestFocusInWindow();
                    PopupParamAdjuster.this.slider.requestFocus();
                }
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent e) {
                popupList.remove(PopupParamAdjuster.this);
                PopupParamAdjuster.this.popupOpen = false;
                try {
                    PopupParamAdjuster.this.queue.put(0.0);
                }
                catch (InterruptedException interruptedException) {}
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent arg0) {
                PopupParamAdjuster.this.setTicks();
            }
        });
        this.setAlwaysOnTop(true);
        this.showTitle(null);
        this.setDefaultCloseOperation(2);
        this.definePopupName("ParamAdjuster", true);
        this.setMinimumSize(new Dimension(500, 120));
        this.setPreferredSize(new Dimension(700, 120));
        this.add(this.generatePanel());
        this.pack();
        this.popupOpen = true;
        this.initDone = true;
        new UpdateThread();
        this.actionPerformed(new ActionEvent(this.paramComboBox, 0, "param"));
    }

    public static synchronized void closeAll() {
        while (popupList.size() > 0) {
            PopupParamAdjuster pa = popupList.get(0);
            popupList.remove(0);
            pa.popupOpen = false;
            if (!pa.isVisible()) continue;
            pa.setVisible(false);
        }
    }

    private void setupSelected() {
        try {
            ++this.inSetup;
            if (!this.initDone) {
                return;
            }
            if (this.adjustParam == null) {
                this.minTextField.setEnabled(false);
                this.maxTextField.setEnabled(false);
                this.cmdLabel.setEnabled(false);
                this.cmdTextField.setEnabled(false);
                this.slider.setEnabled(false);
                return;
            }
            this.minTextField.setEnabled(true);
            this.maxTextField.setEnabled(true);
            this.minTextField.setText(StringUtil.formatDoubleEE(this.adjustParam.getMin() < -1.0E10 ? 0.0 : this.adjustParam.getMin(), false));
            this.maxTextField.setText(StringUtil.formatDoubleEE(this.adjustParam.getMax() > 1.0E10 ? 10.0 : this.adjustParam.getMax(), false));
            this.lastValue = 0.0;
            this.setupRange();
            this.setTicks();
            this.setupCmd();
        }
        finally {
            --this.inSetup;
        }
    }

    private void setupRange() {
        if (!this.initDone) {
            return;
        }
        try {
            double v;
            ++this.inSetup;
            try {
                v = StringUtil.parseDoubleEE(this.minTextField.getText());
                if (this.adjustParam.isInt()) {
                    v = Math.rint(v);
                }
                if (Double.isNaN(v) || Double.isInfinite(v) || v < this.adjustParam.getMin() || v > this.adjustParam.getMax()) {
                    this.minTextField.setBackground(Support.colorScheme.errorBackground);
                } else {
                    this.minTextField.setBackground(Support.colorScheme.textBackground);
                    this.min = v;
                }
            }
            catch (Exception exception) {
                this.minTextField.setBackground(Support.colorScheme.errorBackground);
            }
            try {
                v = StringUtil.parseDoubleEE(this.maxTextField.getText());
                if (this.adjustParam.isInt()) {
                    v = Math.rint(v);
                }
                if (Double.isNaN(v) || Double.isInfinite(v) || v <= this.min || v > this.adjustParam.getMax()) {
                    this.maxTextField.setBackground(Support.colorScheme.errorBackground);
                } else {
                    this.maxTextField.setBackground(Support.colorScheme.textBackground);
                    this.max = v;
                }
            }
            catch (Exception exception) {
                this.maxTextField.setBackground(Support.colorScheme.errorBackground);
            }
            this.setTicks();
        }
        finally {
            --this.inSetup;
        }
    }

    private void setupRange(String range) {
        boolean usePct = false;
        if (range.trim().equalsIgnoreCase("full")) {
            this.min = this.adjustParam.getMin();
            this.max = this.adjustParam.getMax();
            if (this.min < -1.0E10 || this.max > 1.0E10) {
                this.min = 0.0;
                this.max = 10.0;
            }
        } else {
            double rHigh;
            double rLow;
            if (range.contains("%")) {
                usePct = true;
                range = range.replace("%", "");
            }
            String[] r = range.trim().split("[,; ]+");
            switch (r.length) {
                case 1: {
                    rLow = -Math.abs(StringUtil.parseDoubleEE(r[0]));
                    rHigh = Math.abs(rLow);
                    break;
                }
                case 2: {
                    rLow = -Math.abs(StringUtil.parseDoubleEE(r[0]));
                    rHigh = Math.abs(StringUtil.parseDoubleEE(r[1]));
                    break;
                }
                default: {
                    return;
                }
            }
            if (usePct) {
                this.min = this.lastValue * (1.0 + rLow / 100.0);
                this.max = this.lastValue * (1.0 + rHigh / 100.0);
            } else {
                this.min = this.lastValue + rLow;
                this.max = this.lastValue + rHigh;
            }
            if (this.min < this.adjustParam.getMin()) {
                this.min = this.adjustParam.getMin();
            }
            if (this.max > this.adjustParam.getMax()) {
                this.max = this.adjustParam.getMax();
            }
        }
        this.minTextField.setText(StringUtil.formatDoubleEE(this.min, false, 5));
        this.maxTextField.setText(StringUtil.formatDoubleEE(this.max, false, 5));
        this.setupRange();
    }

    private void setupCmd() {
        if (!this.initDone) {
            return;
        }
        try {
            ++this.inSetup;
            if (this.adjustParam.useCustomCommand()) {
                this.adjustParam.setCmd(this.cmdTextField.getText().trim());
                this.slider.setEnabled(!this.adjustParam.useCustomCommand() || this.adjustParam.getCmd().length() <= 0);
                this.cmdLabel.setEnabled(true);
                this.cmdTextField.setEnabled(true);
            } else {
                this.cmdLabel.setEnabled(false);
                this.cmdTextField.setEnabled(false);
                this.slider.setEnabled(true);
            }
        }
        finally {
            --this.inSetup;
        }
    }

    private void setTicks() {
        block17: {
            if (!this.initDone) {
                return;
            }
            try {
                Double vv;
                int i;
                ++this.inSetup;
                if (this.lastValue < this.min) {
                    this.lastValue = this.min;
                }
                int w = this.getSize().width - this.getInsets().left - this.getInsets().right;
                int range = w / 100 * 25 + 1;
                if (this.highres) {
                    range = w / 25 * 25 + 1;
                }
                this.slider.setMinimum(0);
                this.slider.setMaximum(range - 1);
                int pos = 0;
                this.sliderEntries = new double[range];
                int majorSpacing = (range - 1) / 5;
                int minorSpacing = majorSpacing / 5;
                boolean bl = this.log = this.min > 0.0 && this.max / this.min > 999.0;
                if (this.log) {
                    double decades = Math.log10((this.max - this.min) / this.min);
                    if (decades - Math.rint(decades) < 0.01 && Math.rint(decades) >= 3.0 && Math.rint(decades) <= 5.0) {
                        majorSpacing = (range - 1) / (int)Math.rint(decades);
                        minorSpacing = 0;
                    }
                    i = 0;
                    while (i < range) {
                        this.sliderEntries[i] = this.min * Math.pow(Math.pow(this.max / this.min, 1.0 / (double)(range - 1)), i);
                        if (this.sliderEntries[i] <= this.lastValue) {
                            pos = i;
                        }
                        ++i;
                    }
                } else {
                    int i2 = 0;
                    while (i2 < range) {
                        this.sliderEntries[i2] = (double)i2 * (this.max - this.min) / (double)(range - 1) + this.min;
                        if (this.sliderEntries[i2] <= this.lastValue) {
                            pos = i2;
                        }
                        ++i2;
                    }
                }
                this.slider.setMajorTickSpacing(majorSpacing);
                this.slider.setMinorTickSpacing(minorSpacing);
                Hashtable<Integer, JLabel> labelTable = new Hashtable<Integer, JLabel>();
                int i3 = 0;
                while (i3 < range - majorSpacing) {
                    labelTable.put(new Integer(i3), new JLabel(StringUtil.formatDoubleEE(this.sliderEntries[i3], false, this.log ? 3 : 5)));
                    i3 += majorSpacing;
                }
                labelTable.put(new Integer(range - 1), new JLabel(StringUtil.formatDoubleEE(this.sliderEntries[range - 1], false, this.log ? 3 : 5)));
                this.slider.setLabelTable(labelTable);
                Double d = vv = this.adjustParam == null ? null : this.adjustParam.getParam();
                if (vv != null) {
                    i = 0;
                    while (i < this.sliderEntries.length) {
                        if (this.sliderEntries[i] >= vv) {
                            this.slider.setValue(i);
                            this.showTitle(vv);
                            this.lastValue = vv;
                            break block17;
                        }
                        ++i;
                    }
                    break block17;
                }
                this.slider.setValue(pos);
                this.showTitle(null);
            }
            finally {
                --this.inSetup;
            }
        }
    }

    private void showTitle(Double value) {
        String u;
        String string = u = this.adjustParam != null ? this.adjustParam.getUnit() : "";
        if (value == null) {
            this.setTitle("Param adjuster         ----- " + u);
        } else {
            String s = StringUtil.formatDoubleEE(value, true, this.log ? 4 : 6);
            this.setTitle("Param adjuster         " + s + u);
            this.adjustParam.setSetupField(s.trim());
        }
    }

    private JPanel generatePanel() {
        FontAdjust.FontPanel panel = new FontAdjust.FontPanel();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 100;
        c.fill = 2;
        c.anchor = 10;
        c.weightx = 5.0;
        c.insets = new Insets(2, 5, 2, 5);
        this.slider = new FontAdjust.FontSlider(0);
        this.slider.setMinimum(0);
        this.slider.setMaximum(100);
        this.slider.setPaintTicks(true);
        this.slider.setPaintLabels(true);
        this.slider.setMinimumSize(new Dimension(200, 50));
        this.slider.addChangeListener(this);
        this.slider.setToolTipText("Slide to adjust parameter, if min>0 && max/min>999 the scale will be logarithmic");
        panel.add((Component)this.slider, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 1;
        c.fill = 2;
        c.anchor = 17;
        c.insets = new Insets(2, 5, 2, 5);
        c.weightx = 5.0;
        this.paramComboBox = new FontAdjust.FontComboBox<SetupFormatsAdjuster.AdjustParam>();
        this.paramComboBox.setMinimumSize(new Dimension(150, 20));
        this.paramComboBox.addActionListener(this);
        this.paramComboBox.setActionCommand("param");
        this.paramComboBox.setMaximumRowCount(30);
        this.paramComboBox.setToolTipText("Select parameter to adjust (Not all listed may be valid at the current time)");
        panel.add(this.paramComboBox, c);
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 1;
        c.fill = 2;
        c.anchor = 13;
        c.insets = new Insets(2, 5, 2, 5);
        panel.add((Component)new FontAdjust.FontLabel("Min:"), c);
        c = new GridBagConstraints();
        c.gridx = 2;
        c.gridy = 1;
        c.fill = 2;
        c.anchor = 17;
        c.insets = new Insets(2, 5, 2, 5);
        this.minTextField = new FontAdjust.FontTextField(6);
        this.minTextField.setMinimumSize(new Dimension(50, 20));
        this.minTextField.addActionListener(this);
        this.minTextField.setActionCommand("min");
        this.minTextField.setToolTipText("Minimum value on slider");
        this.minTextField.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent arg0) {
                PopupParamAdjuster.this.minTextField.selectAll();
            }

            @Override
            public void focusLost(FocusEvent arg0) {
                PopupParamAdjuster.this.actionPerformed(new ActionEvent(PopupParamAdjuster.this.minTextField, 0, "min"));
            }
        });
        panel.add((Component)this.minTextField, c);
        c = new GridBagConstraints();
        c.gridx = 3;
        c.gridy = 1;
        c.fill = 2;
        c.anchor = 13;
        c.insets = new Insets(2, 5, 2, 5);
        panel.add((Component)new FontAdjust.FontLabel("Max:"), c);
        c = new GridBagConstraints();
        c.gridx = 4;
        c.gridy = 1;
        c.fill = 2;
        c.anchor = 17;
        c.insets = new Insets(2, 5, 2, 5);
        this.maxTextField = new FontAdjust.FontTextField(6);
        this.maxTextField.setMinimumSize(new Dimension(50, 20));
        this.maxTextField.addActionListener(this);
        this.maxTextField.setActionCommand("max");
        this.maxTextField.setToolTipText("Maximum value on slider");
        this.maxTextField.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent arg0) {
                PopupParamAdjuster.this.maxTextField.selectAll();
            }

            @Override
            public void focusLost(FocusEvent arg0) {
                PopupParamAdjuster.this.actionPerformed(new ActionEvent(PopupParamAdjuster.this.maxTextField, 0, "max"));
            }
        });
        panel.add((Component)this.maxTextField, c);
        c = new GridBagConstraints();
        c.gridx = 5;
        c.gridy = 1;
        c.fill = 2;
        c.anchor = 13;
        c.insets = new Insets(2, 5, 2, 5);
        this.cmdLabel = new FontAdjust.FontLabel("Cmd:");
        panel.add((Component)this.cmdLabel, c);
        c = new GridBagConstraints();
        c.gridx = 6;
        c.gridy = 1;
        c.fill = 2;
        c.anchor = 17;
        c.insets = new Insets(2, 5, 2, 5);
        c.weightx = 2.0;
        this.cmdTextField = new FontAdjust.FontTextField(20);
        this.cmdTextField.setMinimumSize(new Dimension(100, 20));
        this.cmdTextField.addActionListener(this);
        this.cmdTextField.setActionCommand("cmd");
        this.cmdTextField.setToolTipText("SCPI command to set value, a # will be replaced with selected value on the slider");
        this.cmdTextField.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent arg0) {
                PopupParamAdjuster.this.cmdTextField.selectAll();
            }

            @Override
            public void focusLost(FocusEvent arg0) {
                PopupParamAdjuster.this.actionPerformed(new ActionEvent(PopupParamAdjuster.this.cmdTextField, 0, "cmd"));
            }
        });
        panel.add((Component)this.cmdTextField, c);
        JPopupMenu popupMenu = new JPopupMenu();
        JMenuItem mi = new FontAdjust.FontMenuItem("-1% .. +1%");
        mi.setActionCommand("Menu: 1%");
        mi.addActionListener(this);
        popupMenu.add(mi);
        mi = new FontAdjust.FontMenuItem("-2% .. +2%");
        mi.setActionCommand("Menu: 2%");
        mi.addActionListener(this);
        popupMenu.add(mi);
        mi = new FontAdjust.FontMenuItem("-5% .. +5%");
        mi.setActionCommand("Menu: 5%");
        mi.addActionListener(this);
        popupMenu.add(mi);
        mi = new FontAdjust.FontMenuItem("-10% .. +10%");
        mi.setActionCommand("Menu: 10%");
        mi.addActionListener(this);
        popupMenu.add(mi);
        mi = new FontAdjust.FontMenuItem("-20% .. +20%");
        mi.setActionCommand("Menu: 20%");
        mi.addActionListener(this);
        popupMenu.add(mi);
        mi = new FontAdjust.FontMenuItem("Full range");
        mi.setActionCommand("Menu: full");
        mi.addActionListener(this);
        popupMenu.add(mi);
        mi = new FontAdjust.FontCheckBoxMenuItem("High res.");
        mi.setActionCommand("HighRes");
        mi.addActionListener(this);
        popupMenu.add(mi);
        panel.setComponentPopupMenu(popupMenu);
        this.slider.setInheritsPopupMenu(true);
        this.paramComboBox.setInheritsPopupMenu(true);
        this.minTextField.setInheritsPopupMenu(true);
        this.maxTextField.setInheritsPopupMenu(true);
        this.cmdTextField.setInheritsPopupMenu(true);
        return panel;
    }

    private void filterParams(String filter) {
        this.paramComboBox.removeAllItems();
        String f = CharacterEscapes.forSimpleSearch(filter);
        for (String p : SetupFormatsAdjuster.listAdjustableParamsNames(true)) {
            if (!p.matches(f)) continue;
            this.paramComboBox.addItem(SetupFormatsAdjuster.getAdjustParam(p));
        }
        this.paramComboBox.setEnabled(this.paramComboBox.getItemCount() > 1);
        this.paramComboBox.setSelectedItem(0);
        this.adjustParam = (SetupFormatsAdjuster.AdjustParam)this.paramComboBox.getSelectedItem();
        this.setupSelected();
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        if (arg0.getActionCommand().equalsIgnoreCase("cmd")) {
            this.setupCmd();
        } else if (arg0.getActionCommand().equalsIgnoreCase("min")) {
            this.setupRange();
        } else if (arg0.getActionCommand().equalsIgnoreCase("max")) {
            this.setupRange();
        } else if (arg0.getActionCommand().equalsIgnoreCase("param")) {
            this.adjustParam = (SetupFormatsAdjuster.AdjustParam)this.paramComboBox.getSelectedItem();
            this.setupSelected();
        } else if (arg0.getActionCommand().equalsIgnoreCase("HighRes")) {
            this.highres = ((JCheckBoxMenuItem)arg0.getSource()).isSelected();
            this.setTicks();
        } else if (arg0.getActionCommand().startsWith("Menu:")) {
            this.setupRange(arg0.getActionCommand().substring(6));
        }
    }

    @Override
    public void stateChanged(ChangeEvent arg0) {
        if (this.inSetup != 0) {
            return;
        }
        int i = this.slider.getValue();
        if (this.sliderEntries == null) {
            return;
        }
        if (this.queue.size() > 0) {
            this.queue.poll();
        }
        this.queue.add(this.sliderEntries[i]);
    }

    public static List<String> generateScript() {
        ArrayList<String> list = new ArrayList<String>();
        int n = 1;
        for (PopupParamAdjuster pa : popupList) {
            list.add("#ShowPopupSystem ParamAdjuster " + pa.generateLocationParams());
            list.add("#SetParamAdjuster " + n + " \"" + pa.adjustParam.getName() + "\" " + StringUtil.formatDoubleEE(pa.min, false) + " " + StringUtil.formatDoubleEE(pa.max, false) + (pa.adjustParam.getCmd().length() > 0 ? " \"" + pa.adjustParam.getCmd() + "\"" : ""));
            ++n;
        }
        return list;
    }

    public static void alignGridAll(int pixels) {
        for (PopupParamAdjuster pa : popupList) {
            pa.alignGrid(pixels);
        }
    }

    private class UpdateThread
    extends Thread {
        UpdateThread() {
            this.setName("ParamAdjusterUpdater");
            this.setDaemon(true);
            this.start();
        }

        @Override
        public void run() {
            while (PopupParamAdjuster.this.popupOpen) {
                try {
                    Double v = (Double)PopupParamAdjuster.this.queue.take();
                    if (PopupParamAdjuster.this.adjustParam == null || Double.isNaN(v) || Double.isInfinite(v) || !PopupParamAdjuster.this.popupOpen) continue;
                    PopupParamAdjuster.this.adjustParam.setParam(v);
                    Double vv = null;
                    if (PopupParamAdjuster.this.queue.size() == 0) {
                        vv = PopupParamAdjuster.this.adjustParam.getParam();
                    }
                    PopupParamAdjuster.this.lastValue = vv != null ? vv : v;
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            PopupParamAdjuster.this.showTitle(PopupParamAdjuster.this.lastValue);
                        }
                    });
                }
                catch (Exception exception) {}
            }
        }
    }
}

