/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.main;

import dk.hkj.devices.ManageDeviceDefinitions;
import dk.hkj.main.FontAdjust;
import dk.hkj.main.PopupBase;
import dk.hkj.util.StringUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class PopupNotes
extends PopupBase {
    private String notes = null;

    public PopupNotes(ManageDeviceDefinitions.DeviceDefinition def) {
        this.setTitle("Notes about " + def.getDeviceName());
        this.definePopupName("Notes", true);
        this.notes = def.getItem("#notes");
        this.add(this.makePanel());
        this.setAlwaysOnTop(true);
        this.pack();
    }

    public PopupNotes(String title, List<String> notes) {
        this.setTitle(title);
        this.definePopupName("Notes", true);
        this.notes = StringUtil.listToString(notes, "\n");
        this.add(this.makePanel());
        this.setAlwaysOnTop(true);
        this.pack();
    }

    public PopupNotes(String title, String notes) {
        this.setTitle(title);
        this.definePopupName("Notes", true);
        this.notes = notes;
        this.add(this.makePanel());
        this.setAlwaysOnTop(true);
        this.pack();
    }

    public JPanel makePanel() {
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BorderLayout());
        FontAdjust.FontTextArea textArea = new FontAdjust.FontTextArea(this.notes);
        textArea.setWrapStyleWord(true);
        textArea.setLineWrap(true);
        JScrollPane scrollPane = new JScrollPane(textArea);
        scrollPane.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        mainPanel.setPreferredSize(new Dimension(400, 200));
        mainPanel.add(scrollPane);
        FontAdjust.FontButton closeButton = new FontAdjust.FontButton("Close");
        closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PopupNotes.this.setVisible(false);
                PopupNotes.this.dispose();
            }
        });
        mainPanel.add((Component)closeButton, "South");
        return mainPanel;
    }
}

