/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.main;

import dk.hkj.comm.CommInterface;
import dk.hkj.comm.LXIInterface;
import dk.hkj.comm.SerialInterface;
import dk.hkj.comm.SocketInterface;
import dk.hkj.devices.LoadDeviceConfig;
import dk.hkj.main.FontAdjust;
import dk.hkj.main.HelpLoader;
import dk.hkj.main.InterfaceThreads;
import dk.hkj.main.Main;
import dk.hkj.main.PopupBase;
import dk.hkj.main.Support;
import dk.hkj.util.FileUtil;
import dk.hkj.util.StringUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;

public class PopupNewDevice
extends PopupBase
implements ActionListener {
    private JTextField addressTextField = null;
    private JTextField portTextField = null;
    private JComboBox<SerialPortEntry> serialPortComboBox = null;
    private JTextField baudrateTextField = null;
    private JLabel deviceIdLabel;
    private JTextField deviceNameTextField;
    private JTextField deviceHandleTextField;
    private JButton generateButton = null;
    private JButton loadButton = null;
    private JTabbedPane typeTabbedPane = null;
    private JLabel filenameLabel;
    private DeviceFound deviceFound = null;
    private String deviceName = null;
    private String deviceHandle = null;
    private String fname = null;
    private JPopupMenu popupMenu = null;
    private String[] baudrates = new String[]{"115200", "38400", "19200", "9600", "4800", "2400", "1200", "1200E72", "1200O72", "2400E72", "2400O72", "4800E72", "4800O72", "9600E72", "9600O72"};

    public PopupNewDevice() {
        this.setTitle("New SCPI device");
        this.definePopupName("NewDevice", true);
        this.add(this.makePanel());
        this.setAlwaysOnTop(true);
        this.pack();
    }

    private JPanel getSocketPanel() {
        FontAdjust.FontPanel panel = new FontAdjust.FontPanel();
        panel.setScaleHeight(110);
        panel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        Dimension minDim = new Dimension(100, 25);
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 13;
        c.insets = new Insets(2, 5, 2, 5);
        panel.add((Component)new FontAdjust.FontLabel("IP address:"), c);
        this.addressTextField = new FontAdjust.FontTextField(20);
        this.addressTextField.setMinimumSize(minDim);
        this.addressTextField.setToolTipText("<html>IP address of device<br>Using the #discover? command on the \"Commands\" page will work for LXI devices");
        c.gridx = 1;
        c.gridy = 0;
        c.weightx = 1.0;
        c.anchor = 17;
        c.gridwidth = 2;
        c.insets = new Insets(2, 5, 2, 5);
        panel.add((Component)this.addressTextField, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 1;
        c.weightx = 1.0;
        c.anchor = 13;
        c.insets = new Insets(2, 5, 2, 5);
        panel.add((Component)new FontAdjust.FontLabel("Port:"), c);
        this.portTextField = new FontAdjust.FontTextField(10);
        this.portTextField.setToolTipText("When empty TestController will try a couple of common ports");
        this.portTextField.setMinimumSize(minDim);
        c.gridx = 1;
        c.gridy = 1;
        c.anchor = 17;
        c.insets = new Insets(2, 5, 2, 5);
        panel.add((Component)this.portTextField, c);
        c.gridx = 2;
        c.gridy = 1;
        c.anchor = 17;
        c.weightx = 1.0;
        c.insets = new Insets(2, 5, 2, 5);
        panel.add((Component)new FontAdjust.FontLabel("If not known, try leaving this field empty"), c);
        return panel;
    }

    private JPanel getSerialPanel() {
        FontAdjust.FontPanel panel = new FontAdjust.FontPanel();
        panel.setScaleHeight(100);
        panel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        Dimension minDim = new Dimension(100, 25);
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 13;
        c.insets = new Insets(2, 5, 2, 5);
        panel.add((Component)new FontAdjust.FontLabel("Port:"), c);
        this.serialPortComboBox = new FontAdjust.FontComboBox<SerialPortEntry>();
        for (CommInterface port : SerialInterface.getSerialPorts(".*", false)) {
            this.serialPortComboBox.addItem(new SerialPortEntry(port));
        }
        this.serialPortComboBox.setMinimumSize(minDim);
        this.serialPortComboBox.setToolTipText("Serial port the device is connected to");
        c.gridx = 1;
        c.gridy = 0;
        c.weightx = 1.0;
        c.anchor = 17;
        c.gridwidth = 2;
        c.insets = new Insets(2, 5, 2, 5);
        panel.add(this.serialPortComboBox, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 1;
        c.weightx = 1.0;
        c.anchor = 13;
        c.insets = new Insets(2, 5, 2, 5);
        panel.add((Component)new FontAdjust.FontLabel("Baudrate:"), c);
        this.baudrateTextField = new FontAdjust.FontTextField(10);
        this.baudrateTextField.setToolTipText("Baudrate only or a full specification (9600N81) can be used.");
        this.baudrateTextField.setMinimumSize(minDim);
        c.gridx = 1;
        c.gridy = 1;
        c.anchor = 17;
        c.insets = new Insets(2, 5, 2, 5);
        panel.add((Component)this.baudrateTextField, c);
        c.gridx = 2;
        c.gridy = 1;
        c.anchor = 17;
        c.weightx = 1.0;
        c.insets = new Insets(2, 5, 2, 5);
        panel.add((Component)new FontAdjust.FontLabel("When empty a couple of baudrates will be tried"), c);
        return panel;
    }

    public JPanel makePanel() {
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        Dimension minDim = new Dimension(100, 25);
        this.typeTabbedPane = new JTabbedPane();
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 3;
        c.weightx = 1.0;
        c.anchor = 11;
        c.fill = 2;
        mainPanel.add((Component)this.typeTabbedPane, c);
        this.typeTabbedPane.addTab("Socket", this.getSocketPanel());
        this.typeTabbedPane.addTab("Serial", this.getSerialPanel());
        FontAdjust.FontButton checkButton = new FontAdjust.FontButton("Check (Can take a minute)");
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 3;
        c.weightx = 1.0;
        c.fill = 2;
        c.insets = new Insets(2, 15, 2, 15);
        mainPanel.add((Component)checkButton, c);
        checkButton.addActionListener(this);
        checkButton.setActionCommand("Scan");
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 3;
        c.weightx = 1.0;
        c.anchor = 13;
        c.insets = new Insets(2, 5, 2, 5);
        mainPanel.add((Component)new FontAdjust.FontLabel("*idn?:"), c);
        this.deviceIdLabel = new FontAdjust.FontLabel("");
        c.gridx = 1;
        c.gridy = 3;
        c.anchor = 17;
        c.gridwidth = 2;
        c.insets = new Insets(2, 5, 2, 5);
        mainPanel.add((Component)this.deviceIdLabel, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 4;
        c.weightx = 1.0;
        c.anchor = 13;
        c.insets = new Insets(2, 5, 2, 5);
        mainPanel.add((Component)new FontAdjust.FontLabel("Name:"), c);
        this.deviceNameTextField = new FontAdjust.FontTextField(20);
        this.deviceNameTextField.setToolTipText("The name must be unique within TestController");
        this.deviceNameTextField.setMinimumSize(minDim);
        this.deviceNameTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent arg0) {
                PopupNewDevice.this.deviceNameTextField.setBackground(Support.colorScheme.textBackground);
            }
        });
        this.deviceNameTextField.setEnabled(false);
        c.gridx = 1;
        c.gridy = 4;
        c.anchor = 17;
        c.gridwidth = 2;
        c.insets = new Insets(2, 5, 2, 5);
        c.fill = 2;
        mainPanel.add((Component)this.deviceNameTextField, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 5;
        c.weightx = 1.0;
        c.anchor = 13;
        c.insets = new Insets(2, 5, 2, 5);
        mainPanel.add((Component)new FontAdjust.FontLabel("Handle:"), c);
        this.deviceHandleTextField = new FontAdjust.FontTextField(10);
        this.deviceHandleTextField.setToolTipText("A short handle that is used to identify the device, it is best if it is unique within TestController");
        this.deviceHandleTextField.setMinimumSize(minDim);
        this.deviceHandleTextField.setEnabled(false);
        this.deviceHandleTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent arg0) {
                PopupNewDevice.this.deviceHandleTextField.setBackground(Support.colorScheme.textBackground);
            }
        });
        c.gridx = 1;
        c.gridy = 5;
        c.anchor = 17;
        c.gridwidth = 2;
        c.insets = new Insets(2, 5, 2, 5);
        c.fill = 2;
        mainPanel.add((Component)this.deviceHandleTextField, c);
        this.generateButton = new FontAdjust.FontButton("Generate device file skeleton");
        c.gridx = 0;
        c.gridy = 6;
        c.gridwidth = 3;
        c.weightx = 1.0;
        c.fill = 2;
        c.insets = new Insets(15, 15, 15, 15);
        mainPanel.add((Component)this.generateButton, c);
        this.generateButton.addActionListener(this);
        this.generateButton.setActionCommand("Generate");
        this.generateButton.setEnabled(false);
        this.filenameLabel = new FontAdjust.FontLabel("Filename:");
        c.gridx = 0;
        c.gridy = 7;
        c.gridwidth = 3;
        c.weightx = 1.0;
        c.fill = 2;
        c.insets = new Insets(2, 15, 2, 15);
        mainPanel.add((Component)this.filenameLabel, c);
        this.filenameLabel.setEnabled(false);
        this.loadButton = new FontAdjust.FontButton("Load new device");
        c.gridx = 0;
        c.gridy = 8;
        c.gridwidth = 3;
        c.weightx = 1.0;
        c.fill = 2;
        c.insets = new Insets(2, 15, 2, 15);
        mainPanel.add((Component)this.loadButton, c);
        this.loadButton.addActionListener(this);
        this.loadButton.setActionCommand("Load");
        this.loadButton.setEnabled(false);
        this.popupMenu = new JPopupMenu();
        FontAdjust.FontMenuItem mi = new FontAdjust.FontMenuItem("Copy filename to clipboard");
        mi.addActionListener(this);
        mi.setActionCommand("ClipBoard");
        this.popupMenu.add(mi);
        this.addMouseListenerAll(mainPanel, new MouseAdapter(){

            public void popup(MouseEvent e) {
                if (!PopupNewDevice.this.popupMenu.isVisible() && PopupNewDevice.this.fname != null) {
                    PopupNewDevice.this.popupMenu.show(e.getComponent(), e.getX(), e.getY());
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    this.popup(e);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    this.popup(e);
                }
            }
        });
        mainPanel.setPreferredSize(new Dimension(500, 310));
        return mainPanel;
    }

    public void addMouseListenerAll(Container comp, MouseListener ml) {
        if (comp instanceof JComponent) {
            ((JComponent)comp).addMouseListener(ml);
        }
        Component[] componentArray = comp.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Component c = componentArray[n2];
            if (c instanceof JComponent) {
                ((JComponent)c).addMouseListener(ml);
            }
            if (c instanceof Container) {
                this.addMouseListenerAll((Container)c, ml);
            }
            ++n2;
        }
    }

    private DeviceFound checkSocket(String address, String port) {
        try {
            CommInterface ci = null;
            ci = port.equalsIgnoreCase("LXI") ? new LXIInterface(address) : new SocketInterface(address, Integer.parseInt(port));
            ci.open();
            if (ci.isOpen()) {
                String answer = ci.writeRead("*IDN?");
                if (answer == null || answer.trim().length() < 5) {
                    answer = ci.writeRead("*IDN?");
                }
                ci.close();
                if (answer != null && answer.trim().split("[,]").length >= 4) {
                    return new DeviceFound(answer, address, port, "", "\n");
                }
            }
        }
        catch (Exception exception) {}
        return null;
    }

    private DeviceFound scanSocketForDevice(String address) {
        ArrayList<String> ports = new ArrayList<String>();
        ports.addAll(Support.manageDeviceDefinitions.getDeviceSocketPorts());
        for (String port : ports) {
            DeviceFound df = this.checkSocket(address, port);
            if (df == null) continue;
            return df;
        }
        DeviceFound df = this.checkSocket(address, "LXI");
        if (df != null) {
            return df;
        }
        return null;
    }

    private DeviceFound checkSerial(CommInterface ci, String baudrate, String eol) {
        try {
            ci.setParams(baudrate);
            ci.setEOL(eol);
            if (ci.isOpen()) {
                String answer = ci.writeRead("*IDN?");
                if (answer == null || answer.trim().length() < 5) {
                    answer = ci.writeRead("*IDN?");
                }
                if (answer != null && answer.trim().split("[,]").length >= 4) {
                    return new DeviceFound(answer, ci.getDeviceName(), "comfixedbaud", baudrate, eol);
                }
                if (answer != null && answer.trim().length() > 4) {
                    return new DeviceFound(answer, ci.getDeviceName(), "comfixedbaud", baudrate, eol);
                }
            }
        }
        catch (Exception exception) {}
        return null;
    }

    private DeviceFound scanSerialForDevice(CommInterface ci, String baudrate) {
        ci.open();
        ci.setTimeout(1000);
        try {
            if (baudrate != null && baudrate.length() > 0) {
                DeviceFound df = this.checkSerial(ci, baudrate, "\n");
                if (df != null) {
                    DeviceFound deviceFound = df;
                    return deviceFound;
                }
                df = this.checkSerial(ci, baudrate, "\r");
                if (df != null) {
                    DeviceFound deviceFound = df;
                    return deviceFound;
                }
            } else {
                String[] stringArray = this.baudrates;
                int n = this.baudrates.length;
                int n2 = 0;
                while (n2 < n) {
                    String s = stringArray[n2];
                    DeviceFound df = this.checkSerial(ci, s, "\n");
                    if (df != null) {
                        DeviceFound deviceFound = df;
                        return deviceFound;
                    }
                    df = this.checkSerial(ci, s, "\r");
                    if (df != null) {
                        DeviceFound deviceFound = df;
                        return deviceFound;
                    }
                    ++n2;
                }
            }
        }
        finally {
            ci.close();
        }
        return null;
    }

    private String makeName(String id) {
        String[] parts = id.split("[,]");
        if (parts.length >= 2 && parts[0].trim().length() >= 2 && parts[1].trim().length() > 3) {
            String name = parts[1].toLowerCase().trim();
            String brand = parts[0].toLowerCase().trim();
            int i = brand.indexOf(32);
            if (i > 0) {
                brand = brand.substring(0, i);
            }
            if (Character.isAlphabetic(brand.charAt(0))) {
                brand = Character.toUpperCase(brand.charAt(0)) + brand.substring(1);
            }
            if (name.matches(".*[0-9]+.*")) {
                while (Character.isAlphabetic(name.charAt(name.length() - 1))) {
                    name = name.substring(0, name.length() - 1);
                }
                i = name.lastIndexOf(32);
                if (i > 0) {
                    name = name.substring(i + 1);
                }
                i = 0;
                while (i >= 0 && i < name.length()) {
                    name = String.valueOf(name.substring(0, i)) + Character.toUpperCase(name.charAt(i)) + name.substring(i + 1);
                    ++i;
                }
            } else {
                name = Character.toUpperCase(name.charAt(0)) + name.substring(1);
            }
            return String.valueOf(brand) + " " + name;
        }
        return "";
    }

    private String makeHandle(String id) {
        int i = (id = this.makeName(id)).lastIndexOf(32);
        if (i < 0) {
            return Support.cleanString(id);
        }
        String s = id.substring(i + 1);
        if (Character.isDigit(s.charAt(0))) {
            s = String.valueOf(id.charAt(0)) + s;
        }
        return Support.cleanString(s);
    }

    private void scan() {
        this.fname = null;
        this.deviceFound = null;
        this.deviceIdLabel.setText("");
        this.deviceNameTextField.setText("");
        this.deviceNameTextField.setEnabled(false);
        this.deviceHandleTextField.setText("");
        this.deviceHandleTextField.setEnabled(false);
        this.generateButton.setEnabled(false);
        this.loadButton.setEnabled(false);
        this.filenameLabel.setEnabled(false);
        DeviceFound df = null;
        String type = this.typeTabbedPane.getTitleAt(this.typeTabbedPane.getSelectedIndex());
        if (type.equals("Socket")) {
            String address = this.addressTextField.getText().trim();
            String port = this.portTextField.getText().trim();
            if (address.length() > 0) {
                df = port.length() == 0 ? this.scanSocketForDevice(address) : this.checkSocket(address, port);
            }
        } else if (type.equals("Serial")) {
            CommInterface ci = ((SerialPortEntry)this.serialPortComboBox.getSelectedItem()).ci;
            String baudrate = this.baudrateTextField.getText().trim();
            df = baudrate != null && baudrate.length() > 0 ? this.scanSerialForDevice(ci, baudrate) : this.scanSerialForDevice(ci, null);
        }
        if (df != null) {
            this.deviceIdLabel.setText(df.answer);
            this.deviceNameTextField.setBackground(Support.colorScheme.textBackground);
            this.deviceHandleTextField.setBackground(Support.colorScheme.textBackground);
            this.deviceNameTextField.setText(this.makeName(df.answer));
            this.deviceNameTextField.setEnabled(true);
            this.deviceHandleTextField.setText(this.makeHandle(df.answer));
            this.deviceHandleTextField.setEnabled(true);
            this.deviceFound = df;
            this.generateButton.setEnabled(true);
        }
    }

    private void generate() {
        this.deviceName = this.deviceNameTextField.getText().trim();
        this.deviceHandle = this.deviceHandleTextField.getText().trim();
        if (Support.manageDeviceDefinitions.findDeviceDefintionFromName(this.deviceName) != null) {
            this.deviceNameTextField.setBackground(Support.colorScheme.errorBackground);
            return;
        }
        if (Support.manageDeviceDefinitions.findDeviceDefintionFromHandle(this.deviceHandle) != null) {
            this.deviceHandleTextField.setBackground(Support.colorScheme.errorBackground);
            return;
        }
        List<String> list = HelpLoader.getHelpFile("Skeleton");
        StringBuilder sb = new StringBuilder();
        sb.append("#idString ");
        int i = this.deviceFound.answer.indexOf(",");
        i = this.deviceFound.answer.indexOf(",", i + 1);
        sb.append(this.deviceFound.answer.substring(0, i + 1));
        sb.append("\r\n");
        sb.append("#name ");
        sb.append(this.deviceName);
        sb.append("\r\n");
        sb.append("#handle ");
        sb.append(this.deviceHandle);
        sb.append("\r\n");
        sb.append("#port ");
        sb.append(this.deviceFound.port);
        sb.append("\r\n");
        sb.append("; Alternate port types: comnobaud or com, com lets the user define baudrate on the \"Load devices\" page\r\n");
        if (this.deviceFound.baudrate != null && this.deviceFound.baudrate.length() > 0) {
            sb.append("#baudrate ");
            sb.append(this.deviceFound.baudrate);
            sb.append("\r\n");
            if (this.deviceFound.eol.equals("\r")) {
                sb.append("#eol ");
                sb.append("\\r");
                sb.append("\r\n");
            }
        }
        String txt = "";
        if (list != null && list.size() > 5) {
            txt = StringUtil.listToString(list, "\r\n");
            txt = txt.replace("####", sb.toString());
        } else {
            sb.insert(0, "; Manual is here: https://lygte-info.dk/project/TestControllerConfigDevice%20UK.html\r\n\r\n");
            txt = sb.toString();
            sb.append("\r\n");
            sb.append("\r\n");
        }
        this.fname = String.valueOf(Support.getDevicePath()) + "/" + this.deviceName + ".txt";
        this.fname = Paths.get(Support.uniqueFilename(this.fname), new String[0]).toString();
        this.filenameLabel.setText("Filename: " + this.fname);
        this.filenameLabel.setEnabled(true);
        try {
            File f = new File(this.fname);
            FileUtil.writeFile(f, txt);
            Desktop dt = Desktop.getDesktop();
            if (dt != null) {
                dt.open(f);
            }
            this.loadButton.setEnabled(true);
        }
        catch (IOException e) {
            e.printStackTrace(System.out);
        }
    }

    private void load() {
        Support.manageDeviceDefinitions.loadDefinitions(new File(this.fname));
        int i = 0;
        while (i < InterfaceThreads.loadDeviceConfig.getRowCount()) {
            InterfaceThreads.loadDeviceConfig.getIndex(i).setEnabled(false);
            ++i;
        }
        InterfaceThreads.loadDeviceConfig.removeDevice(this.deviceName);
        LoadDeviceConfig.LoadDevice ld = InterfaceThreads.loadDeviceConfig.addDevice(this.deviceName);
        ld.setAddress(this.deviceFound.address);
        ld.setEnabled(true);
        InterfaceThreads.startInterface();
        Main.selectPane("Commands");
        this.setVisible(false);
        this.dispose();
    }

    private void copyToClipboard() {
        if (this.fname == null) {
            return;
        }
        try {
            StringSelection stringSelection = new StringSelection(this.fname);
            Clipboard clpbrd = Toolkit.getDefaultToolkit().getSystemClipboard();
            clpbrd.setContents(stringSelection, null);
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("Scan")) {
            this.scan();
        } else if (e.getActionCommand().equals("Generate")) {
            this.generate();
        } else if (e.getActionCommand().equals("Load")) {
            this.load();
        } else if (e.getActionCommand().equals("ClipBoard")) {
            this.copyToClipboard();
        }
    }

    private class DeviceFound {
        String answer;
        String port;
        String address;
        String baudrate;
        String eol;

        DeviceFound(String answer, String address, String port, String baudrate, String eol) {
            this.answer = answer;
            this.address = address;
            this.port = port;
            this.baudrate = baudrate;
            this.eol = eol;
        }
    }

    class SerialPortEntry {
        CommInterface ci;

        SerialPortEntry(CommInterface ci) {
            this.ci = ci;
        }

        public String toString() {
            return this.ci.getName();
        }
    }
}

