/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.main;

import dk.hkj.devices.ManageDeviceDefinitions;
import dk.hkj.main.DeviceInterface;
import dk.hkj.main.FontAdjust;
import dk.hkj.main.InterfaceThreads;
import dk.hkj.main.PopupBase;
import dk.hkj.util.StringUtil;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.Timer;

public class PopupModeSelection
extends PopupBase {
    private List<String> modes = null;
    private ManageDeviceDefinitions.DeviceDefinition def = null;
    private final int[] maxRows = new int[]{6, 8, 9, 13, 20, 25};
    private DeviceInterface di;
    private static Map<String, PopupModeSelection> openWindows = Collections.synchronizedMap(new HashMap());
    private List<JButton> buttonList = new ArrayList<JButton>();
    private List<JCheckBox> checkBoxList = new ArrayList<JCheckBox>();
    private Timer timer;
    private String name = "";
    private int columns = 0;
    private int rows = 0;
    ButtonPressActionListener buttonPressActionListener = new ButtonPressActionListener();
    CheckBoxActionListener checkBoxActionListener = new CheckBoxActionListener();

    public PopupModeSelection(DeviceInterface di, JComponent pos, ManageDeviceDefinitions.DeviceDefinition def) {
        PopupModeSelection pop;
        this.di = di;
        this.def = def;
        this.name = di.getHandleName();
        if (di == null || di.dt == null || di.dt.cPort == null) {
            this.name = String.valueOf(this.name) + " not active";
        }
        if ((pop = openWindows.get(this.name)) != null) {
            pop.dispose();
            openWindows.remove(pop);
        }
        openWindows.put(this.name, this);
        this.setDefaultCloseOperation(2);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent e) {
                openWindows.remove(PopupModeSelection.this);
                PopupModeSelection.this.timer.stop();
                PopupModeSelection.this.timer = null;
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent arg0) {
                openWindows.remove(PopupModeSelection.this);
                PopupModeSelection.this.timer.stop();
                PopupModeSelection.this.timer = null;
            }
        });
        String layout = di.def.getItem("#cmdModeLayout");
        if (layout != null && layout.trim().split("[ ]+").length == 2) {
            this.columns = StringUtil.parseInt(layout.trim().split("[ ]+")[0]);
            this.rows = StringUtil.parseInt(layout.trim().split("[ ]+")[1]);
        }
        this.modes = new ArrayList<String>();
        for (String s : di.getModesPopupList()) {
            if (this.rows <= 0 && s.length() <= 0) continue;
            this.modes.add(s);
        }
        if (this.rows == 0) {
            this.modes.sort(new Comparator<String>(){

                @Override
                public int compare(String o1, String o2) {
                    return o1.toLowerCase().compareTo(o2.toLowerCase());
                }
            });
        }
        this.setTitle(this.name);
        this.definePopupName(String.valueOf(this.name) + "*Mode", false);
        this.setMinimumSize(new Dimension(200, 50));
        this.setResizable(false);
        this.timer = new Timer(500, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                PopupModeSelection.this.timerUpdate();
            }
        });
        this.timer.start();
        this.setLocationRelativeTo(pos);
        this.makePanel();
        this.pack();
        this.setVisible(true);
        this.updateModesCheck();
    }

    public String getHelpURL() {
        String s = this.di.def.getItem("#helpurl");
        if (s != null && s.length() > 0) {
            try {
                new URI(s);
                return s;
            }
            catch (URISyntaxException uRISyntaxException) {}
        }
        return null;
    }

    private void makePanel() {
        if (this.rows == 0) {
            this.columns = 1;
            int i = 0;
            while (i < this.maxRows.length) {
                if (this.modes.size() < this.maxRows[1] * (i + 1)) {
                    this.columns = i + 1;
                    break;
                }
                ++i;
            }
            this.rows = (this.modes.size() + this.columns - 1) / this.columns;
        }
        JPanel panel = new JPanel();
        panel.setLayout(new GridLayout(this.rows, this.columns, 2, 2));
        for (String key : this.modes) {
            ManageDeviceDefinitions.FunctionMode fm = this.def.getFunctionMode(key);
            if (key.length() == 0) {
                panel.add(new JPanel());
                continue;
            }
            if (fm instanceof ManageDeviceDefinitions.FunctionModeCheck) {
                ManageDeviceDefinitions.FunctionModeCheck fmc = (ManageDeviceDefinitions.FunctionModeCheck)fm;
                FontAdjust.FontCheckBox checkBox = new FontAdjust.FontCheckBox(key.replace("_", " "));
                checkBox.setActionCommand(key);
                checkBox.addActionListener(this.checkBoxActionListener);
                checkBox.setSelected(fmc.defaultOn);
                this.checkBoxList.add(checkBox);
                panel.add(checkBox);
                continue;
            }
            FontAdjust.FontButton button = new FontAdjust.FontButton(key.replace("_", " "));
            button.setActionCommand(key);
            button.addActionListener(this.buttonPressActionListener);
            this.buttonList.add(button);
            panel.add(button);
        }
        this.add(panel);
    }

    private void enableCheckModes() {
        boolean noLogging = !InterfaceThreads.isLogging();
        for (JCheckBox checkbox : this.checkBoxList) {
            if (noLogging) {
                boolean enable = true;
                ManageDeviceDefinitions.FunctionModeCheck fmc = (ManageDeviceDefinitions.FunctionModeCheck)this.def.getFunctionMode(checkbox.getActionCommand());
                if (fmc != null && !fmc.modesRequired.isEmpty()) {
                    String[] stringArray = fmc.modesRequired.split("[ ,;]");
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String m = stringArray[n2];
                        boolean state = false;
                        if (m.startsWith("!")) {
                            state = true;
                            m = m.substring(1);
                        }
                        if (this.di.modeActive(m.trim()) == state) {
                            enable = false;
                            break;
                        }
                        ++n2;
                    }
                }
                checkbox.setEnabled(enable);
                continue;
            }
            checkbox.setEnabled(false);
        }
    }

    private void timerUpdate() {
        boolean noLogging = !InterfaceThreads.isLogging();
        for (JButton button : this.buttonList) {
            button.setEnabled(noLogging);
        }
        this.enableCheckModes();
    }

    public void updateModesCheck() {
        if (InterfaceThreads.isLogging()) {
            return;
        }
        for (JCheckBox checkbox : this.checkBoxList) {
            ManageDeviceDefinitions.FunctionModeCheck fmc = (ManageDeviceDefinitions.FunctionModeCheck)this.def.getFunctionMode(checkbox.getActionCommand());
            if (fmc == null) continue;
            boolean active = this.di.modeActive(fmc.getName());
            if (checkbox.isEnabled() && active != checkbox.isSelected()) {
                this.di.setupMode(fmc.getName(), checkbox.isSelected());
                continue;
            }
            if (!active) continue;
            this.di.setupMode(fmc.getName(), false);
        }
    }

    public List<String> generateScript() {
        ArrayList<String> list = new ArrayList<String>();
        if (this.isVisible()) {
            list.add("#ShowPopupMode " + this.di.getHandleName() + " " + this.generateLocationParams() + (this.isOnTop() ? "  onTop" : ""));
        }
        return list;
    }

    private class ButtonPressActionListener
    implements ActionListener {
        private ButtonPressActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            if (((PopupModeSelection)PopupModeSelection.this).di.dt != null && ((PopupModeSelection)PopupModeSelection.this).di.dt.cPort != null) {
                PopupModeSelection.this.di.setupMode(arg0.getActionCommand(), true);
                PopupModeSelection.this.enableCheckModes();
                PopupModeSelection.this.updateModesCheck();
            }
        }
    }

    private class CheckBoxActionListener
    implements ActionListener {
        private CheckBoxActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            if (((PopupModeSelection)PopupModeSelection.this).di.dt != null && ((PopupModeSelection)PopupModeSelection.this).di.dt.cPort != null) {
                PopupModeSelection.this.di.setupMode(arg0.getActionCommand(), ((JCheckBox)arg0.getSource()).isSelected());
            }
        }
    }
}

