/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.main;

import dk.hkj.main.DeviceInterface;
import dk.hkj.main.FontAdjust;
import dk.hkj.main.InterfaceThreads;
import dk.hkj.main.PopupBaseFrame;
import dk.hkj.main.Support;
import dk.hkj.main.ValueFormat;
import dk.hkj.util.StringUtil;
import dk.hkj.vars.Var;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.Timer;

public class PopupMPPT
extends PopupBaseFrame
implements ActionListener,
FocusListener {
    private static List<PopupMPPT> popupMPPT = new ArrayList<PopupMPPT>();
    private static int popupNextNo = 0;
    private int popupNo;
    private Timer timer = null;
    private JComboBox<String> loadComboBox = null;
    private JTextField stepCurrentTextField = null;
    private JTextField maxCurrentTextField = null;
    private JTextField minVoltageTextField = null;
    private JTextField updateSpeedTextField = null;
    private JCheckBox activeCheckBox = null;
    private JLabel loadCurrentLabel = null;
    private JLabel loadVoltageLabel = null;
    private JLabel loadPowerLabel = null;
    private double stepCurrent = 0.01;
    private double maxCurrent = 10.0;
    private double minVoltage = 1.0;
    private double updateSpeed = 0.5;
    private boolean active = false;
    private String selectedLoadHandle = "";
    private int deviceChannel = 1;
    private DeviceInterface di = null;
    private double lastPower = 0.0;
    private double lastSetCurrent = 0.0;
    private boolean dir = false;
    private ValueFormat fmtVoltage = null;
    private ValueFormat fmtCurrent = null;
    private ValueFormat fmtPower = null;
    private double loadCurrent = 0.0;
    private double loadVoltage = 0.0;
    private double loadPower = 0.0;
    private String voltageName = "";
    private String currentName = "";
    private int nn = 1;
    private int incCount = 0;
    private int sameReading = 0;
    private long displayTimer = 0L;
    private long controlTimer = 0L;

    private PopupMPPT(int no) {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                if (PopupMPPT.this.timer != null) {
                    PopupMPPT.this.timer.stop();
                    PopupMPPT.this.timer = null;
                }
                popupMPPT.remove(this);
            }
        });
        this.popupNo = no;
        this.setPreferredSize(new Dimension(250, 220));
        this.setSize(new Dimension(250, 220));
        this.setTitle("MPPT");
        this.setDefaultCloseOperation(2);
        this.definePopupName("MPPT" + (no > 1 ? Integer.valueOf(no - 1) : ""), true);
        this.layoutForm();
        this.timer = new Timer(100, this);
        this.timer.setActionCommand("Timer");
        this.timer.start();
    }

    private void layoutForm() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = null;
        Dimension dd = new Dimension(50, 20);
        int n = 0;
        JPanel readoutPanel = new JPanel();
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = n++;
        c.gridwidth = 5;
        c.weightx = 1.0;
        c.fill = 2;
        c.insets = new Insets(2, 5, 2, 5);
        this.add((Component)readoutPanel, c);
        this.loadVoltageLabel = new FontAdjust.FontLabel("0V");
        readoutPanel.add(this.loadVoltageLabel);
        readoutPanel.add(Box.createHorizontalStrut(10));
        this.loadCurrentLabel = new FontAdjust.FontLabel("0A");
        readoutPanel.add(this.loadCurrentLabel);
        readoutPanel.add(Box.createHorizontalStrut(10));
        this.loadPowerLabel = new FontAdjust.FontLabel("0W");
        readoutPanel.add(this.loadPowerLabel);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = n;
        c.insets = new Insets(2, 5, 2, 5);
        this.add((Component)new FontAdjust.FontLabel("Load:"), c);
        this.loadComboBox = new FontAdjust.FontComboBox<String>();
        for (String s : InterfaceThreads.getDevicesHandlesWithInterface("Load", "setCurrent readVoltage readCurrent", true)) {
            this.loadComboBox.addItem(s);
        }
        this.loadComboBox.addActionListener(this);
        this.loadComboBox.setActionCommand("Load");
        this.loadComboBox.setToolTipText("Load to adjust for MPPT");
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = n++;
        c.insets = new Insets(2, 5, 2, 5);
        this.add(this.loadComboBox, c);
        c.gridx = 0;
        c.gridy = n;
        c.insets = new Insets(2, 5, 2, 5);
        this.add((Component)new FontAdjust.FontLabel("Step current:"), c);
        this.stepCurrentTextField = new FontAdjust.FontTextField(6);
        this.stepCurrentTextField.addActionListener(this);
        this.stepCurrentTextField.setActionCommand("StepCurrent");
        this.stepCurrentTextField.addFocusListener(this);
        this.stepCurrentTextField.setToolTipText("Step size for adjusting current");
        this.stepCurrentTextField.setMinimumSize(dd);
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = n++;
        c.insets = new Insets(2, 5, 2, 5);
        this.add((Component)this.stepCurrentTextField, c);
        c.gridx = 0;
        c.gridy = n;
        c.insets = new Insets(2, 5, 2, 5);
        this.add((Component)new FontAdjust.FontLabel("Max current:"), c);
        this.maxCurrentTextField = new FontAdjust.FontTextField(6);
        this.maxCurrentTextField.addActionListener(this);
        this.maxCurrentTextField.setActionCommand("MaxCurrent");
        this.maxCurrentTextField.addFocusListener(this);
        this.maxCurrentTextField.setToolTipText("Do not adjust current above this value");
        this.maxCurrentTextField.setMinimumSize(dd);
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = n++;
        c.insets = new Insets(2, 5, 2, 5);
        this.add((Component)this.maxCurrentTextField, c);
        c.gridx = 0;
        c.gridy = n;
        c.insets = new Insets(2, 5, 2, 5);
        this.add((Component)new FontAdjust.FontLabel("Min voltage:"), c);
        this.minVoltageTextField = new FontAdjust.FontTextField(6);
        this.minVoltageTextField.addActionListener(this);
        this.minVoltageTextField.setActionCommand("MinVoltage");
        this.minVoltageTextField.addFocusListener(this);
        this.minVoltageTextField.setToolTipText("Reduce current if voltage gets below this value");
        this.minVoltageTextField.setMinimumSize(dd);
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = n++;
        c.insets = new Insets(2, 5, 2, 5);
        this.add((Component)this.minVoltageTextField, c);
        c.gridx = 0;
        c.gridy = n;
        c.insets = new Insets(2, 5, 2, 5);
        this.add((Component)new FontAdjust.FontLabel("Update speed:"), c);
        this.updateSpeedTextField = new FontAdjust.FontTextField(6);
        this.updateSpeedTextField.addActionListener(this);
        this.updateSpeedTextField.setActionCommand("UpdateSpeed");
        this.updateSpeedTextField.addFocusListener(this);
        this.updateSpeedTextField.setToolTipText("Time in seconds between updates");
        this.updateSpeedTextField.setMinimumSize(dd);
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = n++;
        c.insets = new Insets(2, 5, 2, 5);
        this.add((Component)this.updateSpeedTextField, c);
        c.gridx = 0;
        c.gridy = n;
        c.insets = new Insets(2, 5, 2, 5);
        this.add((Component)new FontAdjust.FontLabel("Adjust active:"), c);
        this.activeCheckBox = new FontAdjust.FontCheckBox("");
        this.activeCheckBox.addActionListener(this);
        this.activeCheckBox.setActionCommand("Active");
        this.activeCheckBox.setToolTipText("Checkmark to start adjusting load");
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = n++;
        c.insets = new Insets(2, 5, 2, 5);
        this.add((Component)this.activeCheckBox, c);
        this.fillValues();
        if (this.loadComboBox.getItemCount() > 0) {
            if (this.popupNo < this.loadComboBox.getItemCount()) {
                this.loadComboBox.setSelectedIndex(this.popupNo);
            } else {
                this.loadComboBox.setSelectedIndex(0);
            }
        } else {
            this.enableControls(false);
        }
    }

    public double getStepCurrent() {
        return this.stepCurrent;
    }

    public double getMaxCurrent() {
        return this.maxCurrent;
    }

    public double getMinVoltage() {
        return this.minVoltage;
    }

    public double getUpdateSpeed() {
        return this.updateSpeed;
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    private void fillValues() {
        this.stepCurrentTextField.setText(StringUtil.formatDoubleEE(this.stepCurrent, false));
        this.maxCurrentTextField.setText(StringUtil.formatDoubleEE(this.maxCurrent, false));
        this.minVoltageTextField.setText(StringUtil.formatDoubleEE(this.minVoltage, false));
        this.updateSpeedTextField.setText(StringUtil.formatDoubleEE(this.updateSpeed, false));
    }

    private void enableControls(boolean enable) {
        this.stepCurrentTextField.setEnabled(enable);
        this.maxCurrentTextField.setEnabled(enable);
        this.minVoltageTextField.setEnabled(enable);
        this.updateSpeedTextField.setEnabled(enable);
        this.activeCheckBox.setEnabled(enable);
        if (!enable) {
            this.activeCheckBox.setSelected(false);
            this.active = false;
        }
    }

    private void adj(int n) {
        this.lastSetCurrent += (this.dir ? this.stepCurrent : -this.stepCurrent) * (double)n;
        if (this.lastSetCurrent > this.maxCurrent) {
            this.lastSetCurrent = this.maxCurrent;
        }
        if (this.lastSetCurrent < this.stepCurrent) {
            this.lastSetCurrent = this.stepCurrent;
        }
    }

    private void updateLoad() {
        long t = System.currentTimeMillis();
        boolean updateDisplay = false;
        boolean updateControl = false;
        if (t > this.displayTimer) {
            updateDisplay = true;
            this.displayTimer = t + 500L;
        }
        if (t > this.controlTimer && this.active) {
            updateControl = true;
            this.controlTimer = t + (long)(this.updateSpeed * 1000.0);
        }
        try {
            if (updateDisplay || updateControl) {
                InterfaceThreads.setupVars();
                this.loadVoltage = Var.gl.find(this.voltageName).asDouble();
                this.loadCurrent = Var.gl.find(this.currentName).asDouble();
                this.loadPower = this.loadVoltage * this.loadCurrent;
            }
            if (updateDisplay) {
                this.loadCurrentLabel.setText(String.valueOf(this.fmtCurrent.format.formatDisplay(this.loadCurrent)) + " A");
                this.loadVoltageLabel.setText(String.valueOf(this.fmtVoltage.format.formatDisplay(this.loadVoltage)) + " V");
                this.loadPowerLabel.setText(String.valueOf(this.fmtPower.format.formatDisplay(this.loadPower)) + " W");
            }
            if (this.active && updateControl) {
                if (this.loadVoltage < this.minVoltage) {
                    this.lastSetCurrent -= this.stepCurrent * (double)(this.loadVoltage < this.minVoltage / 5.0 ? 5 : 1);
                    if (this.lastSetCurrent < this.stepCurrent) {
                        this.lastSetCurrent = this.stepCurrent;
                    }
                    this.dir = false;
                    this.di.executeIFace("setCurrent", this.deviceChannel, this.lastSetCurrent);
                } else if (this.lastPower < this.loadPower || this.sameReading > 5) {
                    this.adj(this.nn);
                    if (this.incCount > 5) {
                        this.nn = 5;
                    }
                    ++this.incCount;
                    this.di.executeIFace("setCurrent", this.deviceChannel, this.lastSetCurrent);
                    this.sameReading = 0;
                } else if (this.lastPower > this.loadPower) {
                    this.dir = !this.dir;
                    this.incCount = 0;
                    if (this.nn > 1) {
                        this.nn /= 2;
                    }
                    this.adj(this.nn);
                    this.di.executeIFace("setCurrent", this.deviceChannel, this.lastSetCurrent);
                    this.sameReading = 0;
                } else {
                    ++this.sameReading;
                    if (this.loadPower < 1.0E8) {
                        this.lastSetCurrent += this.stepCurrent;
                        this.di.executeIFace("setCurrent", this.deviceChannel, this.lastSetCurrent);
                    }
                }
                this.lastPower = this.loadPower;
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
    }

    public static synchronized void closeAll() {
        popupNextNo = 0;
        for (PopupMPPT p : popupMPPT) {
            p.setVisible(false);
        }
        popupMPPT.clear();
    }

    public static synchronized PopupMPPT getPopup(int no) {
        PopupMPPT pop2;
        if (popupMPPT.size() == 0) {
            popupNextNo = 0;
        }
        for (PopupMPPT pop2 : popupMPPT) {
            if (pop2.popupNo != no) continue;
            pop2.requestFocus();
            return pop2;
        }
        no = no < 1 ? (popupNextNo = popupNextNo + 1) : no;
        pop2 = new PopupMPPT(no);
        Point p = Support.paneCommand.popupsButton.getLocationOnScreen();
        p.translate(-850, -550);
        if (p.y < 0) {
            p.y = 0;
        }
        if (p.x < 0) {
            p.x = 0;
        }
        p.x += (no - 1) * 230;
        pop2.setLocation(p);
        pop2.setVisible(true);
        popupMPPT.add(pop2);
        return pop2;
    }

    public static synchronized void stopAll() {
        for (PopupMPPT pop : popupMPPT) {
            pop.active = false;
            pop.activeCheckBox.setSelected(false);
        }
    }

    public static void alignGridAll(int pixels) {
        for (PopupMPPT pop : popupMPPT) {
            pop.alignGrid(pixels);
        }
    }

    private void configForLoad() {
        this.di = InterfaceThreads.getLoadedDeviceInterfaceHandle(this.selectedLoadHandle);
        this.enableControls(this.di != null);
        this.deviceChannel = 1;
        int i = this.selectedLoadHandle.indexOf(58);
        if (i > 1) {
            this.di.executeIFace("setCurrent", this.deviceChannel, 0.0);
            this.deviceChannel = Integer.parseInt(this.selectedLoadHandle.substring(i + 1));
        }
        this.voltageName = this.di.executeIFace("nameVoltage", this.deviceChannel, "").asString();
        this.currentName = this.di.executeIFace("nameCurrent", this.deviceChannel, "").asString();
        this.fmtVoltage = InterfaceThreads.findValueFormat(this.voltageName);
        this.fmtCurrent = InterfaceThreads.findValueFormat(this.currentName);
        if (this.di.getIFaces().containsKey("readPower")) {
            String powerName = this.di.executeIFace("namePower", this.deviceChannel, "").asString();
            this.fmtPower = InterfaceThreads.findValueFormat(powerName);
        } else {
            this.fmtPower = new ValueFormat("??", "W", ValueFormat.formatSI3);
        }
    }

    @Override
    public void focusGained(FocusEvent arg0) {
    }

    @Override
    public void focusLost(FocusEvent arg0) {
        JTextField tf = (JTextField)arg0.getSource();
        String ac = "";
        if (tf == this.stepCurrentTextField) {
            ac = "StepCurrent";
        } else if (tf == this.maxCurrentTextField) {
            ac = "maxCurrent";
        } else if (tf == this.minVoltageTextField) {
            ac = "MinVoltage";
        } else if (tf == this.updateSpeedTextField) {
            ac = "UpdateSpeed";
        }
        if (!ac.isEmpty()) {
            this.actionPerformed(new ActionEvent(tf, 0, ac));
        }
    }

    private void setActive(boolean active) {
        this.active = active;
        if (active) {
            this.lastSetCurrent = this.stepCurrent * 5.0;
            this.lastPower = -1.0;
            this.dir = true;
            this.nn = 1;
            this.incCount = 0;
            if (this.di.getIFaces().containsKey("setOn")) {
                this.di.executeIFace("setCurrent", this.deviceChannel, 0.0);
                this.di.executeIFace("setOn", this.deviceChannel, 1.0);
            }
        }
    }

    public void setParams(String channel, double stepCurrent, double maxCurrent, double minVoltage, double updateSpeed, boolean active) {
        this.selectedLoadHandle = channel;
        this.stepCurrent = stepCurrent;
        this.maxCurrent = maxCurrent;
        this.minVoltage = minVoltage;
        this.updateSpeed = updateSpeed;
        this.fillValues();
        this.configForLoad();
        this.setActive(active);
        this.activeCheckBox.setSelected(active);
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        String s = arg0.getActionCommand();
        if (s.equals("Load")) {
            this.selectedLoadHandle = (String)this.loadComboBox.getSelectedItem();
            this.configForLoad();
        } else if (s.equals("StepCurrent")) {
            this.stepCurrent = Support.parseTextFieldDouble(this.stepCurrentTextField, 0.01, false, 1.0E-6, 1.0);
        } else if (s.equals("MaxCurrent")) {
            this.maxCurrent = Support.parseTextFieldDouble(this.maxCurrentTextField, 10.0, false, 0.001, 1000000.0);
        } else if (s.equals("MinVoltage")) {
            this.minVoltage = Support.parseTextFieldDouble(this.minVoltageTextField, 1.0, false, 0.001, 1000000.0);
        } else if (s.equals("UpdateSpeed")) {
            this.updateSpeed = Support.parseTextFieldDouble(this.updateSpeedTextField, 0.5, false, 0.01, 10.0);
        } else if (s.equals("Active")) {
            this.setActive(this.activeCheckBox.isSelected());
        } else if (s.equals("Timer")) {
            this.updateLoad();
        }
    }

    public static List<String> generateScript() {
        ArrayList<String> list = new ArrayList<String>();
        int n = 1;
        for (PopupMPPT pop : popupMPPT) {
            list.add("#ShowPopupSystem MPPT " + pop.generateLocationParams());
            list.add("#SetMPPT " + n + " " + pop.selectedLoadHandle + " " + StringUtil.formatDoubleEE(pop.stepCurrent, false) + " " + StringUtil.formatDoubleEE(pop.maxCurrent, false) + " " + StringUtil.formatDoubleEE(pop.minVoltage, false) + " " + StringUtil.formatDoubleEE(pop.updateSpeed, false) + " " + Integer.toString(pop.active ? 1 : 0));
            ++n;
        }
        return list;
    }
}

