/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.main;

import dk.hkj.main.FontAdjust;
import dk.hkj.main.InterfaceThreads;
import dk.hkj.main.PopupBase;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.Timer;

public class PopupLogTrigger
extends PopupBase
implements ActionListener {
    private static PopupLogTrigger logTrigger = null;
    private JButton startButton;
    private JButton stopButton;
    private InterfaceThreads.LoggingMode mode = null;
    private Timer timer;
    private JPanel panel;

    public PopupLogTrigger() {
        PopupLogTrigger.closeAll();
        this.setTitle("Log Trigger");
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                PopupLogTrigger.this.timer.stop();
                PopupLogTrigger.this.timer = null;
                logTrigger = null;
            }
        });
        this.definePopupName("LogTrigger", false);
        this.setAlwaysOnTop(true);
        logTrigger = this;
        this.panel = new JPanel();
        this.add(this.panel);
        this.timer = new Timer(500, this);
        this.timer.setActionCommand("time");
        this.timer.start();
        this.makeLayout();
    }

    public static void closeAll() {
        if (logTrigger != null) {
            logTrigger.setVisible(false);
            logTrigger = null;
        }
    }

    private void makeLayout() {
        this.panel.removeAll();
        this.startButton = null;
        this.stopButton = null;
        if (InterfaceThreads.loggingMode.equals((Object)InterfaceThreads.LoggingMode.NOnCommand)) {
            this.startButton = new FontAdjust.FontButton("Log N samples");
            this.startButton.setActionCommand("trig");
        } else if (InterfaceThreads.loggingMode.equals((Object)InterfaceThreads.LoggingMode.SingleOnCommand)) {
            this.startButton = new FontAdjust.FontButton("Log a sample");
            this.startButton.setActionCommand("trig");
        } else if (InterfaceThreads.loggingMode.equals((Object)InterfaceThreads.LoggingMode.StartStopOnCommand)) {
            this.startButton = new FontAdjust.FontButton("Start logging");
            this.startButton.setActionCommand("start");
            this.stopButton = new FontAdjust.FontButton("Stop logging");
            this.stopButton.setActionCommand("stop");
        } else {
            this.panel.add(new FontAdjust.FontLabel("<html>Logging mode do not<br>support manual trigger"));
        }
        if (this.startButton != null) {
            this.startButton.addActionListener(this);
            this.panel.add(this.startButton);
        }
        if (this.stopButton != null) {
            this.stopButton.addActionListener(this);
            this.panel.add(this.stopButton);
        }
        this.mode = InterfaceThreads.loggingMode;
        this.pack();
    }

    @Override
    public void actionPerformed(ActionEvent cmd) {
        if (cmd.getActionCommand().equals("time")) {
            if (this.mode != InterfaceThreads.loggingMode) {
                this.makeLayout();
            }
            if (this.startButton != null) {
                this.startButton.setEnabled(InterfaceThreads.isLogging());
            }
            if (this.stopButton != null) {
                this.stopButton.setEnabled(InterfaceThreads.isLogging());
            }
        } else if (cmd.getActionCommand().equals("trig")) {
            InterfaceThreads.lastTrig = true;
        } else if (cmd.getActionCommand().equals("start")) {
            InterfaceThreads.lastTrig = true;
        } else if (cmd.getActionCommand().equals("stop")) {
            InterfaceThreads.lastTrig = false;
        }
    }

    public static List<String> generateScript() {
        ArrayList<String> list = new ArrayList<String>();
        if (logTrigger != null && logTrigger.isVisible()) {
            list.add("#ShowPopupSystem LogTrigger " + logTrigger.generateLocationParams());
        }
        return list;
    }

    public static void alignGridAll(int pixels) {
        if (logTrigger != null && logTrigger.isVisible()) {
            logTrigger.alignGrid(pixels);
        }
    }
}

