/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.main;

import dk.hkj.main.FontAdjust;
import dk.hkj.main.InterfaceThreads;
import dk.hkj.main.PopupBase;
import dk.hkj.main.PopupLogEvent;
import dk.hkj.main.Support;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.Timer;

public class PopupLogEventCapture
extends PopupBase
implements ActionListener {
    static PopupLogEventCapture popup = null;
    private Timer timer;
    private JTextArea cmdsTextArea;
    private JButton okButton;
    private int lastCount = 0;
    private boolean on = false;

    public PopupLogEventCapture(boolean on, String cmds) {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                if (PopupLogEventCapture.this.timer != null) {
                    PopupLogEventCapture.this.timer.stop();
                    PopupLogEventCapture.this.timer = null;
                }
                popup = null;
            }
        });
        this.on = on;
        this.setAlwaysOnTop(true);
        this.setTitle("Log Event Define Commands");
        this.setDefaultCloseOperation(2);
        this.definePopupName("LogEventCapture", false);
        this.setLayout(new GridBagLayout());
        this.init();
        if (cmds.length() > 0 && cmds.charAt(cmds.length() - 1) != '\n') {
            cmds = String.valueOf(cmds) + "\n";
        }
        this.cmdsTextArea.setText(cmds);
        this.update(true);
        this.timer = new Timer(300, this);
        this.timer.setActionCommand("Timer");
        this.timer.start();
        this.pack();
    }

    public static synchronized PopupLogEventCapture getPopup(boolean on, String cmds) {
        if (popup != null) {
            PopupLogEventCapture.closeAll();
        }
        popup = new PopupLogEventCapture(on, cmds);
        return popup;
    }

    public static synchronized void closeAll() {
        if (popup != null) {
            popup.setVisible(false);
            popup = null;
        }
    }

    private void init() {
        GridBagConstraints c = null;
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 2;
        c.weightx = 1.0;
        c.anchor = 13;
        c.fill = 2;
        c.insets = new Insets(5, 5, 0, 5);
        if (this.on) {
            this.add((Component)new JLabel("Type SCPI commands"), c);
            ++c.gridy;
            c.insets = new Insets(0, 5, 5, 5);
            this.add((Component)new JLabel("or use the different \"Setup\" popups to configure and turn on devices"), c);
        } else {
            this.add((Component)new JLabel("Type SCPI commands"), c);
            ++c.gridy;
            c.insets = new Insets(0, 5, 5, 5);
            this.add((Component)new JLabel("or use the different \"Setup\" popups to turn off devices"), c);
        }
        JPopupMenu pm = new JPopupMenu();
        JMenuItem mi = new JMenuItem("Clear");
        mi.setActionCommand("Clear");
        mi.addActionListener(this);
        pm.add(mi);
        mi = new JMenuItem("Add setOn()");
        mi.setActionCommand("SetOn");
        mi.addActionListener(this);
        pm.add(mi);
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 2;
        c.weightx = 1.0;
        c.anchor = 13;
        c.fill = 2;
        c.insets = new Insets(5, 5, 5, 5);
        this.cmdsTextArea = new FontAdjust.FontTextArea(10, 40);
        this.cmdsTextArea.setComponentPopupMenu(pm);
        JScrollPane scroll = new JScrollPane(this.cmdsTextArea);
        this.add((Component)scroll, c);
        c.gridx = 1;
        c.gridy = 3;
        c.weightx = 1.0;
        c.anchor = 17;
        c.fill = 2;
        c.insets = new Insets(5, 5, 5, 5);
        this.okButton = new FontAdjust.FontButton("Ok");
        this.okButton.addActionListener(this);
        this.okButton.setActionCommand("Ok");
        this.add((Component)this.okButton, c);
    }

    private void update(boolean reset) {
        List<String> list = Support.commandList.getList();
        if (reset) {
            this.lastCount = list.size();
            return;
        }
        if (list.size() < this.lastCount) {
            this.lastCount = 0;
        }
        if (list.size() == this.lastCount) {
            return;
        }
        int i = this.lastCount;
        while (i < list.size()) {
            this.cmdsTextArea.append(String.valueOf(list.get(i)) + "\n");
            ++i;
        }
        this.lastCount = list.size();
    }

    private void addSetOn() {
        for (String s : InterfaceThreads.getDevicesHandlesWithInterface("*", "setOn", true)) {
            this.cmdsTextArea.append("=setOn(\"" + s + "\"," + (this.on ? 1 : 0) + ")\n");
        }
    }

    private void okPressed() {
        PopupLogEvent.setCmds(this.on, this.cmdsTextArea.getText());
        PopupLogEventCapture.closeAll();
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        String cmd = arg0.getActionCommand();
        if (cmd.equals("Timer")) {
            this.update(false);
        } else if (cmd.equals("Ok")) {
            this.okPressed();
        } else if (cmd.equals("Clear")) {
            this.cmdsTextArea.setText("");
        } else if (cmd.equals("SetOn")) {
            this.addSetOn();
        }
    }
}

