/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.main;

import dk.hkj.main.CommandProcessor;
import dk.hkj.main.DeviceInterface;
import dk.hkj.main.FontAdjust;
import dk.hkj.main.IconGenerator;
import dk.hkj.main.Indicator;
import dk.hkj.main.InterfaceThreads;
import dk.hkj.main.PopupBase;
import dk.hkj.main.PopupLogEventCapture;
import dk.hkj.main.Support;
import dk.hkj.script.Script;
import dk.hkj.util.StringUtil;
import dk.hkj.vars.Var;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.Timer;

public class PopupLogEvent
extends PopupBase
implements ActionListener,
FocusListener {
    static PopupLogEvent popup = null;
    private JPanel cardPanel;
    private JComboBox<String> channelComboBox;
    private JTextField minTextField;
    private JTextField maxTextField;
    private JTextField timeTextField;
    private JTextField expressionTextField;
    private JButton inputFormatButton;
    private JTextField initTimeTextField;
    private JTextField finalTimeTextField;
    private JTextField logIntervalTextField;
    private Indicator indicator;
    private JButton onCmdsButton;
    private JButton offCmdsButton;
    private JButton startButton;
    private JButton stopButton;
    private List<String> devices = null;
    private double min = -1.7976931348623157E308;
    private double max = Double.MAX_VALUE;
    private long time = 0L;
    private long initTime = 0L;
    private long finalTime = 0L;
    private String expression;
    private String channel = "";
    private LogMode logMode = LogMode.time;
    private State state = State.idleState;
    private JLabel modeLabel;
    private long initTimeCounter = 0L;
    private long finalTimeCounter = 0L;
    private double logInterval = 1.0;
    private long deltaTime;
    private long lastTime;
    private String onCmds = "";
    private String offCmds = "";
    private Script script = new Script();
    private Timer timer;
    private boolean isAlarm = false;

    public static boolean isPopupAlarm() {
        return popup != null && PopupLogEvent.popup.isAlarm;
    }

    private PopupLogEvent() {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                PopupLogEvent.this.stop();
                if (PopupLogEvent.this.timer != null) {
                    PopupLogEvent.this.timer.stop();
                    PopupLogEvent.this.timer = null;
                }
                popup = null;
                Support.math.removeDomain("LogEvent");
                PopupLogEventCapture.closeAll();
            }
        });
        this.setAlwaysOnTop(true);
        this.setTitle("Log Event");
        this.setDefaultCloseOperation(2);
        this.definePopupName("LogEvent", false);
        this.setLayout(new GridBagLayout());
        this.devices = InterfaceThreads.getDevicesHandlesWithInterface("*", "setOn", true);
        this.init();
        this.timer = new Timer(300, this);
        this.timer.setActionCommand("Timer");
        this.timer.start();
        popup = this;
        this.setEnable(true);
        this.setMode();
        this.pack();
    }

    private void init() {
        GridBagConstraints c = null;
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 2;
        c.weightx = 1.0;
        c.anchor = 13;
        c.fill = 2;
        c.insets = new Insets(5, 5, 5, 5);
        this.cardPanel = new JPanel();
        this.cardPanel.setLayout(new CardLayout(0, 0));
        JPanel panel = new JPanel();
        panel.setLayout(new FlowLayout(0, 0, 0));
        this.inputFormatButton = new FontAdjust.FontButton(null);
        this.inputFormatButton.setBorder(BorderFactory.createEmptyBorder());
        this.inputFormatButton.setIcon(IconGenerator.makeIcon(IconGenerator.IconType.FieldChange));
        this.inputFormatButton.setActionCommand("InputMethod");
        this.inputFormatButton.addActionListener(this);
        this.inputFormatButton.setToolTipText("Change between time, min/max and expression as stop condition");
        panel.add(this.inputFormatButton);
        panel.add(Box.createHorizontalStrut(10));
        panel.add(this.cardPanel);
        this.add((Component)panel, c);
        panel = new JPanel();
        panel.setLayout(new FlowLayout(0, 0, 0));
        panel.add(new FontAdjust.FontLabel("Time:"));
        panel.add(Box.createHorizontalStrut(5));
        this.timeTextField = new FontAdjust.FontTextField(8);
        this.timeTextField.setActionCommand("Time");
        this.timeTextField.addActionListener(this);
        this.timeTextField.addFocusListener(this);
        this.timeTextField.setToolTipText("Log for this time with devices on");
        panel.add(this.timeTextField);
        this.cardPanel.add(panel);
        panel = new JPanel();
        panel.setLayout(new FlowLayout(0, 0, 0));
        this.channelComboBox = new FontAdjust.FontComboBox<String>();
        this.channelComboBox.setActionCommand("Channel");
        this.channelComboBox.addActionListener(this);
        this.channelComboBox.setPreferredSize(new Dimension(150, 20));
        this.channelComboBox.setToolTipText("Select channel to test agains min/max");
        this.channelComboBox.setMaximumRowCount(20);
        this.fillChannels();
        if (this.channelComboBox.getItemCount() > 0) {
            this.channelComboBox.setSelectedIndex(0);
        }
        panel.add(this.channelComboBox);
        panel.add(Box.createHorizontalStrut(10));
        panel.add(new FontAdjust.FontLabel("Min.:"));
        panel.add(Box.createHorizontalStrut(5));
        this.minTextField = new FontAdjust.FontTextField(4);
        this.minTextField.setActionCommand("Min");
        this.minTextField.addActionListener(this);
        this.minTextField.addFocusListener(this);
        this.minTextField.setToolTipText("Stop logging if value is below this, leave empty when not needed");
        panel.add(this.minTextField);
        panel.add(Box.createHorizontalStrut(10));
        panel.add(new FontAdjust.FontLabel("Max.:"));
        panel.add(Box.createHorizontalStrut(5));
        this.maxTextField = new FontAdjust.FontTextField(4);
        this.maxTextField.setActionCommand("Max");
        this.maxTextField.addActionListener(this);
        this.maxTextField.addFocusListener(this);
        this.maxTextField.setToolTipText("Stop logging if value is above this, leave empty when not needed");
        panel.add(this.maxTextField);
        this.cardPanel.add(panel);
        panel = new JPanel();
        panel.setLayout(new FlowLayout(0, 0, 0));
        panel.add(new FontAdjust.FontLabel("Stop expression:"));
        panel.add(Box.createHorizontalStrut(5));
        this.expressionTextField = new Support.PopupTextField(25);
        this.expressionTextField.setActionCommand("Exp");
        this.expressionTextField.addActionListener(this);
        this.expressionTextField.addFocusListener(this);
        this.expressionTextField.setToolTipText("Expression that must return true to stop logging, press INS to see a variable list");
        panel.add(this.expressionTextField);
        this.cardPanel.add(panel);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 1;
        c.weightx = 1.0;
        c.anchor = 17;
        c.fill = 2;
        c.insets = new Insets(5, 5, 5, 5);
        panel = new JPanel();
        panel.setLayout(new FlowLayout(0, 0, 0));
        this.add((Component)panel, c);
        panel.add(new JLabel("Init time:"));
        panel.add(Box.createHorizontalStrut(5));
        this.initTimeTextField = new FontAdjust.FontTextField(6);
        this.initTimeTextField.setActionCommand("InitTime");
        this.initTimeTextField.setText("0");
        this.initTimeTextField.addActionListener(this);
        this.initTimeTextField.addFocusListener(this);
        this.initTimeTextField.setToolTipText("Time from on to start of logging in seconds, this can be a negative value, i.e. logging will start before devices is turned on");
        panel.add(this.initTimeTextField);
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 1;
        c.weightx = 1.0;
        c.anchor = 13;
        c.fill = 2;
        c.insets = new Insets(5, 5, 5, 5);
        panel = new JPanel();
        panel.setLayout(new FlowLayout(0, 0, 0));
        this.add((Component)panel, c);
        panel.add(new JLabel("Final time:"));
        panel.add(Box.createHorizontalStrut(5));
        this.finalTimeTextField = new FontAdjust.FontTextField(6);
        this.finalTimeTextField.setActionCommand("FinalTime");
        this.finalTimeTextField.setText("0");
        this.finalTimeTextField.addActionListener(this);
        this.finalTimeTextField.addFocusListener(this);
        this.finalTimeTextField.setToolTipText("Time from off to stop of logging in seconds");
        panel.add(this.finalTimeTextField);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 2;
        c.weightx = 1.0;
        c.anchor = 17;
        c.fill = 2;
        c.insets = new Insets(5, 5, 5, 5);
        panel = new JPanel();
        panel.setLayout(new FlowLayout(0, 0, 0));
        this.add((Component)panel, c);
        panel.add(new JLabel("Log interval:"));
        panel.add(Box.createHorizontalStrut(5));
        this.logIntervalTextField = new FontAdjust.FontTextField(6);
        this.logIntervalTextField.setActionCommand("LogInterval");
        this.logIntervalTextField.setText("1.0");
        this.logIntervalTextField.addActionListener(this);
        this.logIntervalTextField.addFocusListener(this);
        this.logIntervalTextField.setToolTipText("Interval between samples in seconds");
        panel.add(this.logIntervalTextField);
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 2;
        c.weightx = 1.0;
        c.anchor = 17;
        c.fill = 2;
        c.insets = new Insets(5, 5, 5, 5);
        this.modeLabel = new FontAdjust.FontLabel("");
        panel = new JPanel();
        panel.setToolTipText("Method used for controlling on/off of devices");
        panel.setLayout(new FlowLayout(1, 0, 0));
        panel.setBorder(BorderFactory.createRaisedSoftBevelBorder());
        panel.add(this.modeLabel);
        this.add((Component)panel, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 3;
        c.weightx = 1.0;
        c.anchor = 13;
        c.fill = 2;
        c.insets = new Insets(5, 5, 5, 5);
        panel = new JPanel();
        panel.setLayout(new FlowLayout(0, 0, 0));
        this.add((Component)panel, c);
        this.onCmdsButton = new FontAdjust.FontButton("On cmds");
        this.onCmdsButton.setActionCommand("OnCmds");
        this.onCmdsButton.addActionListener(this);
        this.onCmdsButton.setToolTipText("Turn on commands definition will override setOn()");
        this.onCmdsButton.setIcon(IconGenerator.makeIcon(IconGenerator.IconType.SmallClearCircle));
        panel.add(this.onCmdsButton);
        panel.add(Box.createHorizontalStrut(10));
        this.offCmdsButton = new FontAdjust.FontButton("Off cmds");
        this.offCmdsButton.setActionCommand("OffCmds");
        this.offCmdsButton.addActionListener(this);
        this.offCmdsButton.setToolTipText("Turn off commands definition may override setOn()");
        this.offCmdsButton.setIcon(IconGenerator.makeIcon(IconGenerator.IconType.SmallClearCircle));
        panel.add(this.offCmdsButton);
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 3;
        c.weightx = 1.0;
        c.anchor = 17;
        c.fill = 2;
        c.insets = new Insets(5, 5, 5, 5);
        panel = new JPanel();
        panel.setLayout(new FlowLayout(1, 0, 0));
        this.add((Component)panel, c);
        this.startButton = new FontAdjust.FontButton("Start");
        this.startButton.setActionCommand("Start");
        this.startButton.addActionListener(this);
        this.startButton.setToolTipText("Turn on, log and turn off");
        panel.add(this.startButton);
        panel.add(Box.createHorizontalStrut(10));
        this.stopButton = new FontAdjust.FontButton("Stop");
        this.stopButton.setActionCommand("Stop");
        this.stopButton.addActionListener(this);
        this.stopButton.setToolTipText("Stop logging and turn off");
        panel.add(this.stopButton);
        this.indicator = new Indicator();
        this.indicator.setOn(false);
        this.indicator.setColor(Color.red);
        panel.add(Box.createHorizontalStrut(10));
        panel.add(this.indicator);
    }

    private void setMode() {
        if (this.onCmds.isEmpty()) {
            this.modeLabel.setText(this.devices.size() == 0 ? "No support for setOn()" : "Use setOn()");
        }
        if (!this.onCmds.isEmpty() && this.offCmds.isEmpty()) {
            this.modeLabel.setText("Use on cmds & outputs off");
        }
        if (!this.onCmds.isEmpty() && !this.offCmds.isEmpty()) {
            this.modeLabel.setText("Use on cmds & off cmds");
        }
    }

    private void setOnCmds(String cmds) {
        this.onCmds = cmds.trim();
        this.onCmdsButton.setIcon(this.onCmds.isEmpty() ? IconGenerator.makeIcon(IconGenerator.IconType.SmallClearCircle) : IconGenerator.makeIcon(IconGenerator.IconType.SmallGreenCircle));
        this.setMode();
    }

    private void setOffCmds(String cmds) {
        this.offCmds = cmds.trim();
        this.offCmdsButton.setIcon(this.offCmds.isEmpty() ? IconGenerator.makeIcon(IconGenerator.IconType.SmallClearCircle) : IconGenerator.makeIcon(IconGenerator.IconType.SmallGreenCircle));
        this.setMode();
    }

    public static synchronized PopupLogEvent getPopup() {
        if (popup == null) {
            popup = new PopupLogEvent();
        }
        return popup;
    }

    public static synchronized void closeAll() {
        if (popup != null) {
            popup.setVisible(false);
            popup = null;
        }
        PopupLogEventCapture.closeAll();
    }

    public static synchronized void setCmds(boolean on, String cmds) {
        PopupLogEvent.getPopup();
        popup.setVisible(true);
        if (on) {
            popup.setOnCmds(cmds);
        } else {
            popup.setOffCmds(cmds);
        }
    }

    public static void setParams(double itime, double ftime, double interval, String mode, double time, String channel, double min, double max, String exp) {
        PopupLogEvent.getPopup();
        PopupLogEvent.popup.isAlarm = false;
        popup.setVisible(true);
        PopupLogEvent.popup.initTime = (long)(itime * 1000.0);
        PopupLogEvent.popup.finalTime = (long)(ftime * 1000.0);
        PopupLogEvent.popup.logInterval = interval;
        LogMode lm = null;
        if (mode.equalsIgnoreCase("minmax")) {
            lm = LogMode.minmax;
        } else if (mode.equalsIgnoreCase("exp")) {
            lm = LogMode.expression;
        } else if (mode.equalsIgnoreCase("time")) {
            lm = LogMode.time;
        }
        PopupLogEvent.popup.time = (long)(time * 1000.0);
        PopupLogEvent.popup.channel = channel;
        PopupLogEvent.popup.min = min;
        PopupLogEvent.popup.max = max;
        PopupLogEvent.popup.expression = exp;
        PopupLogEvent.popup.initTimeTextField.setText(Double.toString(itime));
        PopupLogEvent.popup.finalTimeTextField.setText(Double.toString(ftime));
        PopupLogEvent.popup.logIntervalTextField.setText(Double.toString(interval));
        popup.setLogMode(lm != null ? lm : LogMode.time);
        PopupLogEvent.popup.timeTextField.setText(Double.toString(time));
        PopupLogEvent.popup.channelComboBox.setSelectedItem(channel);
        PopupLogEvent.popup.minTextField.setText(min < -1.0E307 ? "" : StringUtil.formatDoubleEE(min));
        PopupLogEvent.popup.maxTextField.setText(max > 1.0E307 ? "" : StringUtil.formatDoubleEE(max));
        PopupLogEvent.popup.expressionTextField.setText(exp);
    }

    private void fillChannels() {
        Object sel = this.channelComboBox.getSelectedItem();
        this.channelComboBox.removeAllItems();
        for (String s : InterfaceThreads.listChannels(true)) {
            this.channelComboBox.addItem(s);
        }
        this.channelComboBox.setSelectedItem(sel);
    }

    private String getDeviceName(String device) {
        int i = device.indexOf(58);
        if (i > 0) {
            return device.substring(0, i);
        }
        return device;
    }

    private int getDeviceChannel(String device) {
        int i = device.indexOf(58);
        if (i > 0) {
            return Integer.parseInt(device.substring(i + 1));
        }
        return 1;
    }

    private void setOn(boolean on) {
        if (on) {
            Support.math.resetCalc("LogEvent");
        }
        if (this.onCmds.trim().isEmpty()) {
            for (String s : this.devices) {
                DeviceInterface di = InterfaceThreads.getLoadedDeviceInterfaceHandle(this.getDeviceName(s));
                if (di == null) continue;
                di.executeIFace("setOn", this.getDeviceChannel(s), on ? 1 : 0);
            }
        } else if (on) {
            CommandProcessor.runScript(this.onCmds);
        } else if (this.offCmds.trim().isEmpty()) {
            CommandProcessor.sysCmdOutputOff();
        } else {
            CommandProcessor.runScript(this.offCmds);
        }
    }

    private void setEnable(boolean enable) {
        this.channelComboBox.setEnabled(enable);
        this.minTextField.setEnabled(enable);
        this.maxTextField.setEnabled(enable);
        this.timeTextField.setEnabled(enable);
        this.expressionTextField.setEnabled(enable);
        this.inputFormatButton.setEnabled(enable);
        this.initTimeTextField.setEnabled(enable);
        this.finalTimeTextField.setEnabled(enable);
        this.logIntervalTextField.setEnabled(enable);
        this.startButton.setEnabled(enable);
        this.stopButton.setEnabled(!enable);
    }

    private void start() {
        this.isAlarm = false;
        this.lastTime = System.currentTimeMillis();
        this.initTimeCounter = Math.abs(this.initTime);
        this.finalTimeCounter = this.finalTime;
        this.setEnable(false);
        this.state = State.initState;
        CommandProcessor.sysCmdLog(0.0, null, false);
        if (this.initTime < 0L) {
            CommandProcessor.sysCmdLog(this.logInterval, null, false);
        } else {
            this.setOn(true);
        }
        this.update();
    }

    private void stop() {
        this.isAlarm = false;
        if (this.state != State.idleState) {
            this.state = State.idleState;
            CommandProcessor.sysCmdLog(0.0, null, false);
            this.setOn(false);
            this.setEnable(true);
            this.indicator.setOn(false);
            this.indicator.setColor(Color.red);
        }
    }

    private void captureCmds(boolean on) {
        PopupLogEventCapture plec = PopupLogEventCapture.getPopup(on, on ? this.onCmds : this.offCmds);
        Point p = this.getLocationOnScreen();
        p.y += this.getSize().height;
        plec.setLocation(p);
        plec.setVisible(true);
    }

    private void update() {
        long t = System.currentTimeMillis();
        this.deltaTime = t - this.lastTime;
        this.lastTime = t;
        if (t <= 0L) {
            return;
        }
        if (this.state == State.initState) {
            this.indicator.setOn(true);
            this.indicator.setColor(this.initTime < 0L ? new Color(255, 180, 180) : Color.yellow);
            this.initTimeCounter -= this.deltaTime;
            if (this.initTimeCounter <= 0L) {
                this.state = State.loggingState;
                if (this.initTime >= 0L) {
                    CommandProcessor.sysCmdLog(this.logInterval, null, false);
                } else {
                    this.setOn(true);
                }
                this.deltaTime = 0L;
                this.indicator.setOn(true);
                this.indicator.setColor(Color.red);
            }
        }
        if (this.state == State.loggingState) {
            boolean done = false;
            InterfaceThreads.setupVars();
            switch (this.logMode) {
                case expression: {
                    try {
                        Support.math.calcAllColumns(this.script, "LogEvent");
                        done = this.script.expression(this.expression).asBoolean();
                        this.expressionTextField.setBackground(Support.colorScheme.textBackground);
                    }
                    catch (Exception exception) {
                        this.expressionTextField.setBackground(Support.colorScheme.errorBackground);
                        done = true;
                    }
                    break;
                }
                case minmax: {
                    try {
                        double v = Support.math.getChannelValue(this.channel, "LogEvent");
                        if (v < this.min) {
                            done = true;
                        }
                        if (v > this.max) {
                            done = true;
                        }
                        if (!Double.isInfinite(v) && !Double.isNaN(v)) break;
                        done = true;
                    }
                    catch (Exception exception) {
                        done = true;
                    }
                    break;
                }
                case time: {
                    double delta = Math.min(this.logInterval / 2.0, 0.01);
                    if (this.initTime < 0L) {
                        delta += (double)Math.abs(this.initTime);
                    }
                    if (!(Var.gl.getAsDouble("time", 0.0) > ((double)this.time + delta) / 1000.0)) break;
                    done = true;
                }
            }
            if (done) {
                this.state = State.finalState;
                this.deltaTime = 0L;
                this.setOn(false);
                this.indicator.setOn(true);
                this.indicator.setColor(Color.blue);
            }
        }
        if (this.state == State.finalState) {
            this.finalTimeCounter -= this.deltaTime;
            if (this.finalTimeCounter <= 0L) {
                this.stop();
                this.isAlarm = true;
            }
        }
    }

    private LogMode nextLogMode() {
        CardLayout cl = (CardLayout)this.cardPanel.getLayout();
        cl.next(this.cardPanel);
        this.logMode = LogMode.time;
        if (this.expressionTextField.getParent().isVisible()) {
            this.logMode = LogMode.expression;
        } else if (this.channelComboBox.getParent().isVisible()) {
            this.logMode = LogMode.minmax;
        }
        return this.logMode;
    }

    private void setLogMode(LogMode am) {
        while (am != this.logMode) {
            this.nextLogMode();
        }
    }

    @Override
    public void focusGained(FocusEvent arg0) {
        JTextField f = (JTextField)arg0.getSource();
        f.selectAll();
    }

    @Override
    public void focusLost(FocusEvent arg0) {
        JTextField f = (JTextField)arg0.getSource();
        f.postActionEvent();
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        String cmd = arg0.getActionCommand();
        if (cmd.startsWith("Exp")) {
            this.expression = this.expressionTextField.getText();
        } else if (cmd.startsWith("Channel")) {
            this.channel = (String)this.channelComboBox.getSelectedItem();
        } else if (cmd.startsWith("Min")) {
            if (this.minTextField.getText().trim().length() == 0) {
                this.min = -1.7976931348623157E308;
                this.minTextField.setBackground(Support.colorScheme.textBackground);
                return;
            }
            try {
                this.min = StringUtil.parseDoubleEE(this.minTextField.getText());
                this.minTextField.setBackground(Double.isNaN(this.min) ? Support.colorScheme.errorBackground : Support.colorScheme.textBackground);
            }
            catch (Exception exception) {
                this.min = -1.7976931348623157E308;
                this.minTextField.setBackground(Support.colorScheme.errorBackground);
            }
        } else if (cmd.startsWith("Max")) {
            if (this.maxTextField.getText().trim().length() == 0) {
                this.max = Double.MAX_VALUE;
                this.maxTextField.setBackground(Support.colorScheme.textBackground);
                return;
            }
            try {
                this.max = StringUtil.parseDoubleEE(this.maxTextField.getText());
                this.maxTextField.setBackground(Double.isNaN(this.max) ? Support.colorScheme.errorBackground : Support.colorScheme.textBackground);
            }
            catch (Exception exception) {
                this.min = Double.MAX_VALUE;
                this.maxTextField.setBackground(Support.colorScheme.errorBackground);
            }
        } else if (cmd.equals("Time")) {
            try {
                this.time = (long)(StringUtil.parseHMS(this.timeTextField.getText()) * 1000.0);
                this.timeTextField.setBackground(this.time <= 0L ? Support.colorScheme.errorBackground : Support.colorScheme.textBackground);
            }
            catch (Exception exception) {
                this.time = 0L;
                this.timeTextField.setBackground(Support.colorScheme.errorBackground);
            }
        } else if (cmd.equals("InitTime")) {
            try {
                this.initTime = (long)(StringUtil.parseHMS(this.initTimeTextField.getText()) * 1000.0);
                this.initTimeTextField.setBackground(Support.colorScheme.textBackground);
            }
            catch (Exception exception) {
                this.initTime = 0L;
                this.initTimeTextField.setBackground(Support.colorScheme.errorBackground);
            }
        } else if (cmd.equals("FinalTime")) {
            try {
                this.finalTime = (long)(StringUtil.parseHMS(this.finalTimeTextField.getText()) * 1000.0);
                this.finalTimeTextField.setBackground(this.finalTime < 0L ? Support.colorScheme.errorBackground : Support.colorScheme.textBackground);
            }
            catch (Exception exception) {
                this.finalTime = 0L;
                this.finalTimeTextField.setBackground(Support.colorScheme.errorBackground);
            }
        } else if (cmd.equals("LogInterval")) {
            try {
                this.logInterval = StringUtil.parseDoubleEE(this.logIntervalTextField.getText());
                this.finalTimeTextField.setBackground(Double.isNaN(this.logInterval) || this.logInterval <= 0.0 ? Support.colorScheme.errorBackground : Support.colorScheme.textBackground);
            }
            catch (Exception exception) {
                this.logInterval = 0.0;
                this.logIntervalTextField.setBackground(Support.colorScheme.errorBackground);
            }
        } else if (cmd.equals("Start")) {
            this.start();
        } else if (cmd.equals("Stop")) {
            this.stop();
        } else if (cmd.equals("OnCmds")) {
            this.captureCmds(true);
        } else if (cmd.equals("OffCmds")) {
            this.captureCmds(false);
        } else if (cmd.equals("Timer")) {
            if (this.state != State.idleState) {
                this.update();
            }
        } else if (cmd.startsWith("InputMethod")) {
            this.nextLogMode();
        }
    }

    private void generateOn(boolean on, List<String> list) {
        if (this.onCmds.trim().isEmpty()) {
            for (String s : this.devices) {
                list.add("=setOn(\"" + s + "\"," + (on ? "1" : "0") + ")");
            }
        } else if (on) {
            String[] stringArray = this.onCmds.split("\n");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                list.add(s);
                ++n2;
            }
        } else if (this.offCmds.trim().isEmpty()) {
            list.add("#off");
        } else {
            String[] stringArray = this.offCmds.split("\n");
            int n = stringArray.length;
            int n3 = 0;
            while (n3 < n) {
                String s = stringArray[n3];
                list.add(s);
                ++n3;
            }
        }
    }

    private void doGenerateLogScript(List<String> list) {
        list.add("#log 0");
        if (this.initTime <= 0L) {
            list.add("#log " + this.logInterval);
        }
        if (this.initTime < 0L) {
            list.add("#delay " + (double)(-this.initTime) / 1000.0);
        }
        list.add("; Turn devices on");
        this.generateOn(true, list);
        if (this.initTime > 0L) {
            list.add("#delay " + (double)this.initTime / 1000.0);
            list.add("#log " + this.logInterval);
        }
        switch (this.logMode) {
            case expression: {
                list.add("; Main loop");
                if (this.initTime >= 0L) {
                    list.add("#hasLogged");
                }
                if (this.expression.trim().isEmpty()) {
                    list.clear();
                    return;
                }
                list.add("#while " + this.expression);
                list.add("#hasLogged");
                list.add("#endwhile");
                break;
            }
            case minmax: {
                list.add("; Main loop");
                if (this.initTime >= 0L) {
                    list.add("#hasLogged");
                }
                String s = "";
                if (this.min > -1.7976931348623157E308 && this.max < Double.MAX_VALUE) {
                    s = String.valueOf(this.channel) + ">=" + this.min + " && " + this.channel + "<=" + this.max;
                } else if (this.min > -1.7976931348623157E308) {
                    s = String.valueOf(this.channel) + ">=" + this.min;
                } else if (this.max < Double.MAX_VALUE) {
                    s = String.valueOf(this.channel) + "<=" + this.max;
                } else {
                    list.clear();
                    return;
                }
                list.add("#while " + s);
                list.add("#hasLogged");
                list.add("#endwhile");
                break;
            }
            case time: {
                if (this.time == 0L) {
                    list.clear();
                    return;
                }
                list.add("; Main loop is only a delay when logging on time");
                list.add("#delay " + (double)this.time / 1000.0);
            }
        }
        list.add("; Turn devices off");
        this.generateOn(false, list);
        if (this.finalTime > 0L) {
            list.add("#delay " + (double)this.finalTime / 1000.0);
        }
        list.add("#log 0");
    }

    public static List<String> generateLogScript() {
        ArrayList<String> list = new ArrayList<String>();
        if (popup != null) {
            popup.doGenerateLogScript(list);
        }
        return list;
    }

    public static List<String> generateScript() {
        ArrayList<String> list = new ArrayList<String>();
        if (popup != null) {
            list.add("#ShowPopupSystem LogEvent " + popup.generateLocationParams());
            StringBuilder sb = new StringBuilder();
            sb.append("#SetLogEvent ");
            sb.append(Double.toString((double)PopupLogEvent.popup.initTime / 1000.0));
            sb.append(" ");
            sb.append(Double.toString((double)PopupLogEvent.popup.finalTime / 1000.0));
            sb.append(" ");
            sb.append(Double.toString(PopupLogEvent.popup.logInterval));
            sb.append(" ");
            if (PopupLogEvent.popup.logMode == LogMode.time) {
                sb.append("time ");
                sb.append(Double.toString((double)PopupLogEvent.popup.time / 1000.0));
            } else if (PopupLogEvent.popup.logMode == LogMode.minmax) {
                sb.append("minmax ");
                sb.append(PopupLogEvent.popup.channel);
                sb.append(" ");
                sb.append(StringUtil.formatDoubleEE(PopupLogEvent.popup.min));
                sb.append(" ");
                sb.append(StringUtil.formatDoubleEE(PopupLogEvent.popup.max));
            } else if (PopupLogEvent.popup.logMode == LogMode.expression) {
                sb.append("exp ");
                sb.append("\"" + PopupLogEvent.popup.expressionTextField.getText().trim() + "\"");
            }
            list.add(sb.toString());
            list.add("#SetLogEventCmds \"" + Support.escapeForCommandLine(PopupLogEvent.popup.onCmds) + "\" \"" + Support.escapeForCommandLine(PopupLogEvent.popup.offCmds) + "\"");
        }
        return list;
    }

    public static void alignGridAll(int pixels) {
        if (popup != null) {
            popup.alignGrid(pixels);
        }
    }

    private static enum LogMode {
        time,
        minmax,
        expression;

    }

    private static enum State {
        idleState,
        initState,
        loggingState,
        finalState;

    }
}

