/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.main;

import dk.hkj.database.Importer;
import dk.hkj.main.CommandProcessor;
import dk.hkj.main.FontAdjust;
import dk.hkj.main.Main;
import dk.hkj.main.PopupBase;
import dk.hkj.main.PopupGridPanel;
import dk.hkj.main.Support;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.filechooser.FileNameExtensionFilter;

public class PopupImport
extends PopupBase
implements ActionListener {
    private JButton fileButton = null;
    private JButton importButton = null;
    private JLabel importLabel = null;
    private List<ImportColumn> importColumns = null;
    private JComboBox<String> importHeadersComboBox = null;
    private JComboBox<String> headersComboBox = null;
    private JCheckBox clearCheckBox = null;
    private JPanel fieldPanel = null;
    private File importFile = null;

    PopupImport() {
        this.setTitle("Import table");
        this.definePopupName("Import", true);
        this.add(this.makePanel());
        this.setDefaultCloseOperation(2);
        this.importButtonEnable();
        this.pack();
        this.setModal(true);
    }

    public JPanel makePanel() {
        FontAdjust.FontPanel mainPanel = new FontAdjust.FontPanel();
        mainPanel.setLayout(new GridBagLayout());
        mainPanel.setScaleWidth(510);
        mainPanel.setScaleHeight(300);
        mainPanel.setLayout(new GridBagLayout());
        Dimension minDim = new Dimension(150, 20);
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 10;
        c.fill = 2;
        c.weightx = 10.0;
        c.weighty = 0.0;
        c.insets = new Insets(2, 2, 2, 2);
        this.fileButton = new FontAdjust.FontButton("Select file to import");
        this.fileButton.setActionCommand("File");
        this.fileButton.addActionListener(this);
        mainPanel.add((Component)this.fileButton, c);
        int n = 0;
        c = new GridBagConstraints();
        c.gridx = n++;
        c.gridy = 1;
        c.anchor = 17;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.insets = new Insets(2, 2, 2, 2);
        mainPanel.add((Component)new FontAdjust.FontLabel("Reference:"), c);
        c = new GridBagConstraints();
        c.gridx = n++;
        c.gridy = 1;
        c.anchor = 13;
        c.weightx = n++;
        c.weighty = 0.0;
        c.insets = new Insets(2, 2, 2, 2);
        mainPanel.add((Component)new FontAdjust.FontLabel("Import:"), c);
        c = new GridBagConstraints();
        c.gridx = 2;
        c.gridy = 1;
        c.anchor = 17;
        c.weightx = n++;
        c.weighty = 0.0;
        c.insets = new Insets(2, 2, 2, 2);
        this.importHeadersComboBox = new FontAdjust.FontComboBox<String>();
        this.importHeadersComboBox.setToolTipText("The columns that is synchronized to the table");
        this.importHeadersComboBox.setMinimumSize(minDim);
        this.importHeadersComboBox.setActionCommand("importRef");
        this.importHeadersComboBox.addActionListener(this);
        mainPanel.add(this.importHeadersComboBox, c);
        c = new GridBagConstraints();
        c.gridx = n++;
        c.gridy = 1;
        c.anchor = 13;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.insets = new Insets(2, 20, 2, 2);
        this.importLabel = new FontAdjust.FontLabel("Table:");
        this.importLabel.setEnabled(Support.dataBase.rows() > 0);
        mainPanel.add((Component)this.importLabel, c);
        c = new GridBagConstraints();
        c.gridx = n;
        c.gridy = 1;
        c.anchor = 17;
        c.weightx = 100.0;
        c.weighty = 0.0;
        c.insets = new Insets(2, 2, 2, 2);
        this.headersComboBox = new FontAdjust.FontComboBox<String>();
        for (String s : Support.dataBase.header().getColumnsList()) {
            this.headersComboBox.addItem(s);
        }
        this.headersComboBox.setEnabled(Support.dataBase.rows() > 0);
        this.headersComboBox.setActionCommand("Ref");
        this.headersComboBox.setToolTipText("The imported data is synchronized to this column, interpolation will be done when necessary");
        this.headersComboBox.addActionListener(this);
        this.headersComboBox.setMinimumSize(minDim);
        mainPanel.add(this.headersComboBox, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 10;
        c.anchor = 17;
        c.weightx = 10.0;
        c.weighty = 10.0;
        c.insets = new Insets(2, 2, 2, 2);
        this.fieldPanel = new JPanel();
        this.fieldPanel.setLayout(new GridBagLayout());
        this.fieldPanel.setAlignmentX(2.0f);
        this.fieldPanel.setAlignmentY(1.0f);
        JScrollPane sp = new JScrollPane(this.fieldPanel);
        sp.setMinimumSize(new Dimension(500, 300));
        sp.setAlignmentX(2.0f);
        sp.setAlignmentY(1.0f);
        mainPanel.add((Component)sp, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 3;
        c.gridwidth = 3;
        c.anchor = 17;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.insets = new Insets(2, 2, 2, 2);
        this.clearCheckBox = new FontAdjust.FontCheckBox("Clear table before import");
        this.clearCheckBox.setToolTipText("When checked import can be used to read a limited sets of columns from a csv file into a empty table");
        this.clearCheckBox.setActionCommand("clear");
        this.clearCheckBox.addActionListener(this);
        mainPanel.add((Component)this.clearCheckBox, c);
        c = new GridBagConstraints();
        c.gridx = n;
        c.gridy = 3;
        c.gridwidth = 1;
        c.anchor = 13;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.insets = new Insets(2, 2, 2, 2);
        this.importButton = new FontAdjust.FontButton("Import");
        this.importButton.setActionCommand("Import");
        this.importButton.addActionListener(this);
        mainPanel.add((Component)this.importButton, c);
        return mainPanel;
    }

    private void syncTableReference() {
        String s = (String)this.importHeadersComboBox.getSelectedItem();
        if (s == null) {
            return;
        }
        int i = 0;
        while (i < this.headersComboBox.getItemCount()) {
            if (s.equalsIgnoreCase(this.headersComboBox.getItemAt(i))) {
                this.headersComboBox.setSelectedIndex(i);
                return;
            }
            ++i;
        }
        int j = s.indexOf(46);
        if (j >= 0) {
            s = s.substring(j + 1);
        }
        int i2 = 0;
        while (i2 < this.headersComboBox.getItemCount()) {
            String sx = this.headersComboBox.getItemAt(i2);
            j = sx.indexOf(46);
            if (j >= 0) {
                sx = sx.substring(j + 1);
            }
            if (s.equalsIgnoreCase(sx)) {
                this.headersComboBox.setSelectedIndex(i2);
                return;
            }
            ++i2;
        }
    }

    private void fillForm() {
        List<String> columns;
        if (this.importColumns != null) {
            for (ImportColumn c : this.importColumns) {
                c.remove();
            }
            this.importColumns.clear();
        }
        this.importHeadersComboBox.removeAllItems();
        try {
            columns = Importer.loadHeaders(this.importFile);
        }
        catch (IOException iOException) {
            columns = null;
        }
        if (columns == null || columns.size() == 0) {
            return;
        }
        int n = 0;
        this.importColumns = new ArrayList<ImportColumn>();
        for (String name : columns) {
            if (name.contains("/")) continue;
            this.importColumns.add(new ImportColumn(n++, name));
            this.importHeadersComboBox.addItem(name);
        }
        this.pack();
    }

    private void selectFile() {
        FontAdjust.FontFileChooser fileChooser = new FontAdjust.FontFileChooser();
        fileChooser.setDialogTitle("Import table data from file");
        try {
            fileChooser.setCurrentDirectory(new File(Support.getDataPath()));
        }
        catch (Exception exception) {
            System.out.println("Failed to set director: " + Support.getDataPath());
        }
        fileChooser.setFileFilter(new FileNameExtensionFilter("CSV", "csv"));
        fileChooser.addChoosableFileFilter(new FileNameExtensionFilter("TXT", "txt"));
        fileChooser.addChoosableFileFilter(new FileNameExtensionFilter("DAT", "dat"));
        fileChooser.setAcceptAllFileFilterUsed(true);
        if (fileChooser.showOpenDialog(this) == 0) {
            this.importFile = Support.fileWithOptinalDefaults(fileChooser.getSelectedFile().getAbsolutePath(), null, ".csv");
            this.fillForm();
            Support.setDataPath(fileChooser.getCurrentDirectory().getPath());
        }
        this.importButtonEnable();
    }

    private void importButtonEnable() {
        int n = 0;
        if (this.importColumns != null) {
            for (ImportColumn ic : this.importColumns) {
                n += ic.isSelected() ? 1 : 0;
            }
        }
        this.importButton.setEnabled(this.importFile != null && n > 0);
    }

    private void adjustClear() {
        this.importLabel.setEnabled(Support.dataBase.rows() > 0 && !this.clearCheckBox.isSelected());
        this.headersComboBox.setEnabled(Support.dataBase.rows() > 0 && !this.clearCheckBox.isSelected());
        for (ImportColumn ic : this.importColumns) {
            ic.adjust();
        }
        this.importButtonEnable();
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        if (arg0.getActionCommand().equals("Import")) {
            this.importToTable();
        } else if (arg0.getActionCommand().equals("importRef")) {
            this.syncTableReference();
        } else if (arg0.getActionCommand().equals("clear")) {
            this.adjustClear();
        } else if (arg0.getActionCommand().equals("File")) {
            this.selectFile();
        }
    }

    private void importToTable() {
        String refColumn = (String)this.importHeadersComboBox.getSelectedItem();
        String ref = (String)this.headersComboBox.getSelectedItem();
        if (this.headersComboBox.isEnabled() && ref != null && ref.length() > 0 && refColumn != ref) {
            refColumn = String.valueOf(refColumn) + "/" + ref;
        }
        ArrayList<String> dataColumns = new ArrayList<String>();
        for (ImportColumn ic : this.importColumns) {
            String s = ic.getField();
            if (s == null || s.isEmpty()) continue;
            dataColumns.add(s);
        }
        if (this.clearCheckBox.isSelected()) {
            CommandProcessor.clearTable();
        }
        Importer importer = new Importer(Support.dataBase);
        String err = "";
        try {
            err = importer.importData(this.importFile, refColumn, dataColumns);
        }
        catch (IOException iOException) {
            err = "File read error";
        }
        if (err != null && err.length() > 0) {
            JOptionPane.showMessageDialog(this, err, "Import failed", 0);
        } else {
            this.setVisible(false);
            Main.changeDevicesOrTable(Support.UpdateType.ColumnsTable);
            PopupGridPanel.systemStateChanged();
            Support.clearExporter();
        }
    }

    private class ImportColumn
    extends MouseAdapter
    implements ActionListener {
        private String name = null;
        private JLabel importNameLabel = null;
        private JCheckBox includeCheckBox = null;
        private JLabel renameLabel = null;
        private JTextField renameTextField = null;

        public ImportColumn(int n, String name) {
            this.name = name;
            GridBagConstraints c = null;
            c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = n;
            c.anchor = 17;
            c.fill = 2;
            c.weightx = 0.0;
            c.weighty = 0.0;
            c.insets = new Insets(1, 3, 1, 10);
            this.importNameLabel = new FontAdjust.FontLabel(name);
            this.importNameLabel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createRaisedBevelBorder(), BorderFactory.createEmptyBorder(2, 5, 2, 5)));
            this.importNameLabel.addMouseListener(this);
            PopupImport.this.fieldPanel.add((Component)this.importNameLabel, c);
            c = new GridBagConstraints();
            c.gridx = 1;
            c.gridy = n;
            c.weightx = 0.0;
            c.weighty = 0.0;
            c.insets = new Insets(2, 2, 2, 2);
            this.includeCheckBox = new FontAdjust.FontCheckBox("Include: ");
            this.includeCheckBox.setToolTipText("Include this column in the table");
            this.includeCheckBox.setHorizontalTextPosition(2);
            this.includeCheckBox.setActionCommand("check");
            this.includeCheckBox.addActionListener(this);
            PopupImport.this.fieldPanel.add((Component)this.includeCheckBox, c);
            c = new GridBagConstraints();
            c.gridx = 2;
            c.gridy = n;
            c.anchor = 17;
            c.weightx = 0.0;
            c.weighty = 0.0;
            c.insets = new Insets(2, 20, 2, 2);
            this.renameLabel = new FontAdjust.FontLabel("Rename to:");
            this.renameLabel.setEnabled(false);
            PopupImport.this.fieldPanel.add((Component)this.renameLabel, c);
            c = new GridBagConstraints();
            c.gridx = 3;
            c.gridy = n;
            c.anchor = 17;
            c.weightx = 0.0;
            c.weighty = 0.0;
            c.insets = new Insets(2, 2, 2, 2);
            this.renameTextField = new FontAdjust.FontTextField(10);
            this.renameTextField.setMinimumSize(new Dimension(100, 20));
            this.renameTextField.setToolTipText("<html>To avoid multiple columns with the same name, renaming is necessary.<br>This is automatic, but can be overriden with this value");
            this.renameTextField.setEnabled(false);
            PopupImport.this.fieldPanel.add((Component)this.renameTextField, c);
            this.adjust();
        }

        public void adjust() {
            this.importNameLabel.setEnabled(true);
            this.includeCheckBox.setEnabled(true);
            if (Support.dataBase.rows() == 0 && Support.dataBase.columns() == 0 || PopupImport.this.clearCheckBox.isSelected()) {
                if (this.name.equals("index")) {
                    this.importNameLabel.setToolTipText("When importing into empty data index will always be included, checkmark and renaming is ignored");
                    this.importNameLabel.setEnabled(false);
                    this.includeCheckBox.setEnabled(false);
                    this.includeCheckBox.setSelected(false);
                    this.renameLabel.setEnabled(false);
                    this.renameTextField.setEnabled(false);
                } else if (this.name.equals("time")) {
                    this.importNameLabel.setToolTipText("When importing into empty data time will always be included, checkmark and renaming is ignored");
                    this.importNameLabel.setEnabled(false);
                    this.includeCheckBox.setEnabled(false);
                    this.includeCheckBox.setSelected(false);
                    this.renameLabel.setEnabled(false);
                    this.renameTextField.setEnabled(false);
                }
            }
        }

        public String getName() {
            return this.name;
        }

        public void remove() {
            PopupImport.this.fieldPanel.remove(this.importNameLabel);
            PopupImport.this.fieldPanel.remove(this.includeCheckBox);
            PopupImport.this.fieldPanel.remove(this.renameLabel);
            PopupImport.this.fieldPanel.remove(this.renameTextField);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getActionCommand().equals("check")) {
                boolean enb = this.isSelected();
                this.renameLabel.setEnabled(enb);
                this.renameTextField.setEnabled(enb);
                PopupImport.this.importButtonEnable();
            }
        }

        @Override
        public void mouseClicked(MouseEvent arg0) {
            this.includeCheckBox.setSelected(!this.isSelected());
            this.actionPerformed(new ActionEvent(this.includeCheckBox, 1, "check"));
        }

        public boolean isSelected() {
            return this.includeCheckBox.isSelected() && this.importNameLabel.isEnabled();
        }

        public String getField() {
            if (!this.isSelected()) {
                return "";
            }
            String rename = this.renameTextField.getText().trim();
            if (rename != null && rename.length() > 0) {
                return String.valueOf(this.name) + "/" + rename;
            }
            return this.name;
        }
    }
}

