/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.main;

import dk.hkj.main.FontAdjust;
import dk.hkj.main.Main;
import dk.hkj.main.PopupBaseFrame;
import dk.hkj.main.Support;
import dk.hkj.util.ByteBuffer;
import dk.hkj.util.CharacterEscapes;
import dk.hkj.util.MySwingUtil;
import dk.hkj.util.StringUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileNameExtensionFilter;

public class PopupImage
extends PopupBaseFrame
implements ActionListener {
    private final int MAX_IMAGES = 200;
    private static PopupImage popupImage = null;
    private ImagePanel imagePanel = null;
    private List<ImageEntry> imageList = new ArrayList<ImageEntry>();
    private int index = 0;
    private JButton leftButton = null;
    private JButton rightButton = null;
    private JButton viewButton = null;
    private JPanel buttonPanel = null;
    private JRadioButtonMenuItem halfMenuItem = null;
    private JRadioButtonMenuItem actualMenuItem = null;
    private JRadioButtonMenuItem doubleMenuItem = null;
    private JRadioButtonMenuItem windowMenuItem = null;
    private JRadioButtonMenuItem zoomMenuItem = null;
    private static SizingType sizingType = SizingType.actualsize;
    private JPopupMenu popupMenu = null;
    private boolean showFirstLoaded = false;
    private String defaultPath = null;

    private ImageEntry hasImage(ImageEntry ie) {
        for (ImageEntry i : this.imageList) {
            if (!i.path.equals(ie.path)) continue;
            return i;
        }
        return null;
    }

    private PopupImage() {
        popupImage = this;
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                if (popupImage == PopupImage.this) {
                    PopupImage.popupImage = null;
                }
                PopupImage.this.imageList.clear();
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent e) {
                if (popupImage == PopupImage.this) {
                    PopupImage.popupImage = null;
                }
                PopupImage.this.imageList.clear();
            }
        });
        this.setAlwaysOnTop(false);
        this.setTitle("Image");
        this.setDefaultCloseOperation(2);
        this.definePopupName("Image", true);
        this.setMinimumSize(new Dimension(300, 200));
        this.setPreferredSize(new Dimension(500, 350));
        Dimension button1Dimensions = new Dimension(120, 20);
        Dimension button2Dimensions = new Dimension(70, 20);
        this.imagePanel = new ImagePanel();
        this.add(this.imagePanel);
        this.popupMenu = new JPopupMenu();
        this.imagePanel.setComponentPopupMenu(this.popupMenu);
        this.imagePanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                this.maybeShowPopup(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.maybeShowPopup(e);
            }

            private void maybeShowPopup(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    PopupImage.this.popupMenu.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        });
        ButtonGroup bg = new ButtonGroup();
        JMenuItem mi = new FontAdjust.FontRadioButtonMenuItem("\u00d7\u00bd");
        mi.setToolTipText("Image is half orginal size if popup is large enough");
        mi.addActionListener(this);
        mi.setActionCommand("\u00bd");
        if (sizingType == SizingType.halfsize) {
            mi.setSelected(true);
        }
        this.popupMenu.add(mi);
        this.halfMenuItem = (JRadioButtonMenuItem)mi;
        bg.add(mi);
        mi = new FontAdjust.FontRadioButtonMenuItem("\u00d71");
        mi.setToolTipText("Image is in orginal size if popup is large enough");
        mi.addActionListener(this);
        mi.setActionCommand("1");
        if (sizingType == SizingType.actualsize) {
            mi.setSelected(true);
        }
        this.popupMenu.add(mi);
        this.actualMenuItem = (JRadioButtonMenuItem)mi;
        bg.add(mi);
        mi = new FontAdjust.FontRadioButtonMenuItem("\u00d72");
        mi.addActionListener(this);
        mi.setToolTipText("Image double orginal size if popup is large enough");
        mi.setActionCommand("2");
        if (sizingType == SizingType.doublesize) {
            mi.setSelected(true);
        }
        this.popupMenu.add(mi);
        this.doubleMenuItem = (JRadioButtonMenuItem)mi;
        bg.add(mi);
        mi = new FontAdjust.FontRadioButtonMenuItem("Window");
        mi.setToolTipText("Image scales to window size");
        mi.addActionListener(this);
        mi.setActionCommand("window");
        if (sizingType == SizingType.resize) {
            mi.setSelected(true);
        }
        this.popupMenu.add(mi);
        this.windowMenuItem = (JRadioButtonMenuItem)mi;
        bg.add(mi);
        mi = new FontAdjust.FontRadioButtonMenuItem("Zoom");
        mi.setToolTipText("Image size is change with mouse wheel and it can be dragged around");
        mi.addActionListener(this);
        if (sizingType == SizingType.zoomsize) {
            mi.setSelected(true);
        }
        mi.setActionCommand("zoom");
        this.popupMenu.add(mi);
        this.zoomMenuItem = (JRadioButtonMenuItem)mi;
        bg.add(mi);
        this.popupMenu.addSeparator();
        mi = new FontAdjust.FontMenuItem("Mirror");
        mi.setToolTipText("Flip horizontally");
        mi.addActionListener(this);
        mi.setActionCommand("flipH");
        this.popupMenu.add(mi);
        mi = new FontAdjust.FontMenuItem("Upside/down");
        mi.setToolTipText("Flip vertically");
        mi.addActionListener(this);
        mi.setActionCommand("flipV");
        this.popupMenu.add(mi);
        mi = new FontAdjust.FontMenuItem("Rotate +90\u00b0");
        mi.setToolTipText("Flip vertically");
        mi.addActionListener(this);
        mi.setActionCommand("R+");
        this.popupMenu.add(mi);
        mi = new FontAdjust.FontMenuItem("Rotate -90\u00b0");
        mi.setToolTipText("Flip vertically");
        mi.addActionListener(this);
        mi.setActionCommand("R-");
        this.popupMenu.add(mi);
        mi = new FontAdjust.FontMenuItem("Rotate 180\u00b0");
        mi.setToolTipText("Flip vertically");
        mi.addActionListener(this);
        mi.setActionCommand("R");
        this.popupMenu.add(mi);
        this.popupMenu.addSeparator();
        mi = new FontAdjust.FontMenuItem("Copy");
        mi.addActionListener(this);
        mi.setToolTipText("Copy image clipboard");
        mi.setActionCommand("copy");
        this.popupMenu.add(mi);
        mi = new FontAdjust.FontMenuItem("Save");
        mi.addActionListener(this);
        mi.setToolTipText("Save image to a file");
        mi.setActionCommand("save");
        this.popupMenu.add(mi);
        mi = new FontAdjust.FontMenuItem("Load");
        mi.addActionListener(this);
        mi.setToolTipText("Load more images");
        mi.setActionCommand("load");
        this.popupMenu.add(mi);
        mi = new FontAdjust.FontMenuItem("Sort on names");
        mi.addActionListener(this);
        mi.setToolTipText("Sort images according to name");
        mi.setActionCommand("sort");
        this.buttonPanel = new JPanel();
        this.leftButton = new FontAdjust.FontButton("<");
        this.buttonPanel.add(this.leftButton);
        this.leftButton.setActionCommand("<");
        this.leftButton.setPreferredSize(button1Dimensions);
        this.leftButton.addActionListener(this);
        this.rightButton = new FontAdjust.FontButton(">");
        this.buttonPanel.add(this.rightButton);
        this.rightButton.addActionListener(this);
        this.rightButton.setPreferredSize(button1Dimensions);
        this.rightButton.setActionCommand(">");
        this.buttonPanel.add(Box.createHorizontalStrut(20));
        this.viewButton = new FontAdjust.FontButton("All");
        this.buttonPanel.add(this.viewButton);
        this.viewButton.addActionListener(this);
        this.viewButton.setPreferredSize(button2Dimensions);
        this.viewButton.setActionCommand("all");
        this.add((Component)this.buttonPanel, "South");
        this.imagePanel.setFocusable(true);
        MySwingUtil.addKeyListenerAll(this, new KeyListener(){

            @Override
            public void keyPressed(KeyEvent arg0) {
                if (arg0.isConsumed()) {
                    return;
                }
                if (arg0.getKeyCode() == 37) {
                    if (sizingType == SizingType.zoomsize) {
                        PopupImage.this.imagePanel.moveImage(-10, 0);
                    } else {
                        PopupImage.this.actionPerformed(new ActionEvent(PopupImage.this.imagePanel, 0, "<"));
                    }
                    arg0.consume();
                } else if (arg0.getKeyCode() == 39) {
                    if (sizingType == SizingType.zoomsize) {
                        PopupImage.this.imagePanel.moveImage(10, 0);
                    } else {
                        PopupImage.this.actionPerformed(new ActionEvent(PopupImage.this.imagePanel, 0, ">"));
                    }
                    arg0.consume();
                } else if (arg0.getKeyCode() == 33) {
                    PopupImage.this.actionPerformed(new ActionEvent(PopupImage.this.imagePanel, 0, "<<"));
                    arg0.consume();
                } else if (arg0.getKeyCode() == 34) {
                    PopupImage.this.actionPerformed(new ActionEvent(PopupImage.this.imagePanel, 0, ">>"));
                    arg0.consume();
                } else if (arg0.getKeyCode() == 36) {
                    PopupImage.this.actionPerformed(new ActionEvent(PopupImage.this.imagePanel, 0, "home"));
                    arg0.consume();
                } else if (arg0.getKeyCode() == 35) {
                    PopupImage.this.actionPerformed(new ActionEvent(PopupImage.this.imagePanel, 0, "end"));
                    arg0.consume();
                } else if (arg0.getKeyCode() == 38) {
                    if (sizingType == SizingType.zoomsize) {
                        PopupImage.this.imagePanel.moveImage(0, -10);
                    } else {
                        PopupImage.this.actionPerformed(new ActionEvent(PopupImage.this.imagePanel, 0, "all"));
                    }
                    arg0.consume();
                } else if (arg0.getKeyCode() == 40) {
                    if (sizingType == SizingType.zoomsize) {
                        PopupImage.this.imagePanel.moveImage(0, 10);
                    } else {
                        PopupImage.this.actionPerformed(new ActionEvent(PopupImage.this.imagePanel, 0, "single"));
                    }
                    arg0.consume();
                } else if (arg0.getKeyCode() == 32) {
                    PopupImage.this.actionPerformed(new ActionEvent(PopupImage.this.imagePanel, 0, PopupImage.this.imagePanel.isAll() ? "single" : "all"));
                    arg0.consume();
                } else if (Character.toUpperCase(arg0.getKeyChar()) == 'R') {
                    PopupImage.this.actionPerformed(new ActionEvent(PopupImage.this.imagePanel, 0, "R+"));
                    arg0.consume();
                } else if (Character.toUpperCase(arg0.getKeyChar()) == 'M') {
                    PopupImage.this.actionPerformed(new ActionEvent(PopupImage.this.imagePanel, 0, "flipH"));
                    arg0.consume();
                } else if (Character.toUpperCase(arg0.getKeyChar()) == 'U') {
                    PopupImage.this.actionPerformed(new ActionEvent(PopupImage.this.imagePanel, 0, "flipV"));
                    arg0.consume();
                } else if (Character.toUpperCase(arg0.getKeyChar()) == '\u0013') {
                    PopupImage.this.actionPerformed(new ActionEvent(PopupImage.this.imagePanel, 0, "save"));
                    arg0.consume();
                } else if (Character.toUpperCase(arg0.getKeyChar()) == '\u0003') {
                    PopupImage.this.actionPerformed(new ActionEvent(PopupImage.this.imagePanel, 0, "copy"));
                    arg0.consume();
                } else if (Character.toUpperCase(arg0.getKeyChar()) == '\f') {
                    PopupImage.this.actionPerformed(new ActionEvent(PopupImage.this.imagePanel, 0, "load"));
                    arg0.consume();
                } else if (arg0.getKeyChar() == '+') {
                    PopupImage.this.imagePanel.adjustZoom(0.1);
                    arg0.consume();
                } else if (arg0.getKeyChar() == '-') {
                    PopupImage.this.imagePanel.adjustZoom(-0.1);
                    arg0.consume();
                } else if (Character.toLowerCase(arg0.getKeyChar()) == 'z') {
                    PopupImage.this.actionPerformed(new ActionEvent(PopupImage.this.imagePanel, 0, "zoom"));
                    arg0.consume();
                } else if (Character.toLowerCase(arg0.getKeyChar()) == 'w') {
                    PopupImage.this.actionPerformed(new ActionEvent(PopupImage.this.imagePanel, 0, "window"));
                    arg0.consume();
                } else if (arg0.getKeyChar() == '\u00bd') {
                    PopupImage.this.actionPerformed(new ActionEvent(PopupImage.this.imagePanel, 0, "\u00bd"));
                    arg0.consume();
                } else if (arg0.getKeyChar() == '1') {
                    PopupImage.this.actionPerformed(new ActionEvent(PopupImage.this.imagePanel, 0, "1"));
                    arg0.consume();
                } else if (arg0.getKeyChar() == '2') {
                    PopupImage.this.actionPerformed(new ActionEvent(PopupImage.this.imagePanel, 0, "2"));
                    arg0.consume();
                }
            }

            @Override
            public void keyReleased(KeyEvent arg0) {
            }

            @Override
            public void keyTyped(KeyEvent arg0) {
            }
        });
        this.buttonPanel.setComponentPopupMenu(this.popupMenu);
        this.imagePanel.sizing(sizingType);
        this.enableButtons();
        this.pack();
    }

    public void setMenuSizing() {
        if (sizingType == SizingType.halfsize) {
            this.halfMenuItem.setSelected(true);
        } else if (sizingType == SizingType.actualsize) {
            this.actualMenuItem.setSelected(true);
        } else if (sizingType == SizingType.doublesize) {
            this.doubleMenuItem.setSelected(true);
        } else if (sizingType == SizingType.resize) {
            this.windowMenuItem.setSelected(true);
        } else if (sizingType == SizingType.zoomsize) {
            this.zoomMenuItem.setSelected(true);
        }
    }

    public void enableButtons() {
        this.leftButton.setEnabled(this.imageList.size() > 1 && this.index > 0);
        this.rightButton.setEnabled(this.imageList.size() > 1 && this.index < this.imageList.size() - 1);
        this.leftButton.setVisible(this.imageList.size() > 1);
        this.viewButton.setVisible(this.imageList.size() > 1);
        this.rightButton.setVisible(this.imageList.size() > 1);
        this.buttonPanel.setVisible(this.imageList.size() > 1);
    }

    private ImageEntry getImageFile(String path) {
        BufferedImage image;
        File f;
        try {
            f = new File(String.valueOf(Support.getDataPath()) + "/Images/" + path);
            if (!f.exists()) {
                f = new File(String.valueOf(Support.getDataPath()) + "/Images/" + path + ".png");
            }
            if (!f.exists()) {
                f = new File(String.valueOf(Support.getDataPath()) + "/Images/" + path + ".jpg");
            }
            if (f.exists() && (image = ImageIO.read(f)) != null) {
                return new ImageEntry(image, f.getAbsolutePath(), f.getName());
            }
        }
        catch (Exception exception) {}
        try {
            f = new File(path);
            if (!f.exists()) {
                f = new File(String.valueOf(path) + ".png");
            }
            if (!f.exists()) {
                f = new File(String.valueOf(path) + ".jpg");
            }
            if (f.exists() && (image = ImageIO.read(f)) != null) {
                return new ImageEntry(image, f.getAbsolutePath(), f.getName());
            }
        }
        catch (Exception exception) {}
        return null;
    }

    private ImageEntry getImageFile2(String path) {
        File f;
        try {
            f = new File(String.valueOf(Support.getDataPath()) + "/Images/" + path);
            if (!f.exists()) {
                f = new File(String.valueOf(Support.getDataPath()) + "/Images/" + path + ".png");
            }
            if (!f.exists()) {
                f = new File(String.valueOf(Support.getDataPath()) + "/Images/" + path + ".jpg");
            }
            if (f.exists()) {
                return new ImageEntry(f);
            }
        }
        catch (Exception exception) {}
        try {
            f = new File(path);
            if (!f.exists()) {
                f = new File(String.valueOf(path) + ".png");
            }
            if (!f.exists()) {
                f = new File(String.valueOf(path) + ".jpg");
            }
            if (f.exists()) {
                return new ImageEntry(f);
            }
        }
        catch (Exception exception) {}
        return null;
    }

    private ImageEntry getImage(String path) {
        BufferedImage image;
        URL url;
        try {
            url = new URL(path);
            image = ImageIO.read(url);
            if (image != null) {
                String name = url.getFile();
                int i = name.lastIndexOf(47);
                if (i >= 0) {
                    name = name.substring(i + 1);
                }
                return new ImageEntry(image, url.toString(), name);
            }
        }
        catch (Exception exception) {}
        try {
            url = new URL("http://lygte-info.dk/pic/Projects/TestController/images/" + path);
            image = ImageIO.read(url);
            if (image != null) {
                String name = url.getFile();
                int i = name.lastIndexOf(47);
                if (i >= 0) {
                    name = name.substring(i + 1);
                }
                return new ImageEntry(image, url.toString(), name);
            }
        }
        catch (Exception exception) {}
        return this.getImageFile(path);
    }

    private List<String> getFileList(String path) {
        ArrayList<String> list = new ArrayList<String>();
        File f = new File(path);
        path = f.getParent();
        final Pattern p = Pattern.compile(CharacterEscapes.forSimpleSearch(f.getName()));
        if (path == null) {
            path = String.valueOf(Support.getDataPath()) + "/Images";
        }
        f = new File(path);
        File[] fileArray = f.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File arg0, String arg1) {
                return p.matcher(arg1).matches();
            }
        });
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File ff = fileArray[n2];
            list.add(ff.getAbsolutePath());
            ++n2;
        }
        return list;
    }

    public synchronized void addImage(BufferedImage image, String path, String name, boolean allowDuplicates) {
        if (image != null && this.imageList.size() < 200) {
            ImageEntry i;
            ImageEntry ie = new ImageEntry(image, path, name);
            ImageEntry imageEntry = i = allowDuplicates ? null : this.hasImage(ie);
            if (i == null) {
                this.imageList.add(ie);
            } else {
                ie = i;
            }
            if (this.showFirstLoaded) {
                this.showFirstLoaded = false;
                this.index = this.imageList.indexOf(ie);
                this.imagePanel.setImage(this.imageList.get(this.index));
            }
            this.enableButtons();
            if (this.imageList.size() > 1 && this.imagePanel.isAll()) {
                this.imagePanel.repaint();
            }
        }
    }

    private synchronized void addImage(ImageEntry image) {
        if (image != null && image.isValid() && this.imageList.size() < 200) {
            ImageEntry i = this.hasImage(image);
            if (i == null) {
                this.imageList.add(image);
            } else {
                image = i;
            }
            if (this.showFirstLoaded) {
                this.showFirstLoaded = false;
                this.index = this.imageList.indexOf(image);
                this.imagePanel.setImage(this.imageList.get(this.index));
            }
            this.enableButtons();
            if (this.imageList.size() > 1 && this.imagePanel.isAll()) {
                this.imagePanel.repaint();
            }
        }
    }

    public void addImageAsync(final ImageEntry image) {
        if (image == null) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PopupImage.this.addImage(image);
            }
        });
    }

    public void addImageAsync(final List<ImageEntry> imageEntry) {
        if (imageEntry == null || imageEntry.size() == 0) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                for (ImageEntry i : imageEntry) {
                    PopupImage.this.addImage(i);
                }
            }
        });
    }

    private void addedAdd(List<String> paths) {
        while (paths.size() > 30) {
            ArrayList<String> part = new ArrayList<String>();
            int i = 0;
            while (i < 15) {
                part.add(paths.get(0));
                paths.remove(0);
                ++i;
            }
            if (this.imageList.size() >= 200) continue;
            new Added(part);
        }
        if (this.imageList.size() < 200) {
            new Added(paths);
        }
    }

    public void addImage(String path) {
        if (new File(path).isDirectory()) {
            path = String.valueOf(path) + "/*";
            this.addedAdd(this.getFileList(path));
        } else {
            new Added(path);
        }
    }

    public void showDefault(boolean askLoadImages) {
        this.enableButtons();
        if (askLoadImages) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PopupImage.this.loadImages();
                }
            });
        }
    }

    private void loadImages() {
        FontAdjust.FontFileChooser fileChooser = new FontAdjust.FontFileChooser();
        fileChooser.setDialogTitle("Load image files or directories");
        try {
            fileChooser.setCurrentDirectory(new File(this.defaultPath == null ? Support.getDataPath() : this.defaultPath));
        }
        catch (Exception exception) {
            System.out.println("Failed to set director: " + Support.getDataPath());
        }
        fileChooser.setFileSelectionMode(2);
        fileChooser.setMultiSelectionEnabled(true);
        fileChooser.setFileFilter(new FileNameExtensionFilter("JPG & PNG Images", "jpg", "png"));
        fileChooser.setAcceptAllFileFilterUsed(true);
        if (fileChooser.showOpenDialog(this) == 0) {
            ArrayList<String> paths = new ArrayList<String>();
            File[] fileArray = fileChooser.getSelectedFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                if (f.isDirectory()) {
                    paths.add(String.valueOf(f.getAbsolutePath()) + "/*");
                } else {
                    paths.add(f.getAbsolutePath());
                }
                ++n2;
            }
            this.showFirstLoaded = true;
            this.addedAdd(paths);
            this.defaultPath = fileChooser.getCurrentDirectory().toString();
        }
    }

    public static synchronized PopupImage getPopup() {
        if (popupImage != null) {
            popupImage.requestFocus();
            return popupImage;
        }
        popupImage = new PopupImage();
        Point p = Main.main.frame.getLocationOnScreen();
        p.y -= 50;
        if (p.y < 0) {
            p.y = 0;
        }
        if (p.x < 0) {
            p.x = 0;
        }
        popupImage.setLocation(p);
        popupImage.setVisible(true);
        return popupImage;
    }

    public void setShowFirstLoaded() {
        this.showFirstLoaded = true;
    }

    public static void closeAll() {
        if (popupImage != null) {
            popupImage.setVisible(false);
            popupImage = null;
        }
    }

    public static void windowShow() {
        if (popupImage != null) {
            popupImage.requestFocus();
        }
    }

    public void saveImage() {
        FontAdjust.FontFileChooser fc = new FontAdjust.FontFileChooser();
        try {
            fc.setCurrentDirectory(new File(Support.getDataPath()));
        }
        catch (Exception exception) {
            System.out.println("Failed to set director: " + Support.getDataPath());
        }
        fc.setFileFilter(new FileNameExtensionFilter("PNG", "png"));
        fc.setAcceptAllFileFilterUsed(false);
        while (true) {
            int option = 0;
            if (fc.showDialog(null, "Save image") != 0) break;
            File f = Support.fileWithOptinalDefaults(fc.getSelectedFile().getAbsolutePath(), null, ".png");
            if (option == 0 && f.exists() && (option = JOptionPane.showConfirmDialog(null, "File exists, overwrite?", "File exists", 1)) == 2) {
                return;
            }
            if (option != 0) continue;
            Support.setDataPath(fc.getCurrentDirectory().getPath());
            try {
                ImageIO.write((RenderedImage)this.imageList.get(this.index).getFullImage(), "png", f);
                return;
            }
            catch (IOException iOException) {
                continue;
            }
            break;
        }
    }

    public void sortImages() {
        if (this.imageList.size() == 0) {
            return;
        }
        ImageEntry obj = this.imageList.get(this.index);
        this.imageList.sort(null);
        this.index = this.imageList.indexOf(obj);
        if (this.imagePanel.isAll()) {
            this.imagePanel.repaint();
        }
        this.enableButtons();
    }

    public void copyImage() {
        ImageSelection imgSel = new ImageSelection(this.imageList.get(this.index).getFullImage());
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(imgSel, null);
    }

    private ImageEntry flipHImage(ImageEntry image) {
        BufferedImage bi = image.getFullImage();
        int w = bi.getWidth();
        int h = bi.getHeight();
        BufferedImage result = new BufferedImage(w, h, 2);
        int y = 0;
        while (y < h) {
            int x = 0;
            while (x < w) {
                int p = bi.getRGB(x, y);
                result.setRGB(w - x - 1, y, p);
                ++x;
            }
            ++y;
        }
        return new ImageEntry(result, image.path, image.name);
    }

    private ImageEntry flipVImage(ImageEntry image) {
        BufferedImage bi = image.getFullImage();
        int w = bi.getWidth();
        int h = bi.getHeight();
        BufferedImage result = new BufferedImage(w, h, 2);
        int y = 0;
        while (y < h) {
            int x = 0;
            while (x < w) {
                int p = bi.getRGB(x, y);
                result.setRGB(x, h - y - 1, p);
                ++x;
            }
            ++y;
        }
        return new ImageEntry(result, image.path, image.name);
    }

    private ImageEntry rotateImage(ImageEntry image) {
        BufferedImage bi = image.getFullImage();
        int w = bi.getWidth();
        int h = bi.getHeight();
        BufferedImage result = new BufferedImage(h, w, 2);
        int y = 0;
        while (y < h) {
            int x = 0;
            while (x < w) {
                int p = bi.getRGB(x, y);
                result.setRGB(h - y - 1, x, p);
                ++x;
            }
            ++y;
        }
        return new ImageEntry(result, image.path, image.name);
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        if (arg0.getActionCommand().equals("window")) {
            sizingType = SizingType.resize;
            this.setMenuSizing();
            this.imagePanel.sizing(sizingType);
        } else if (arg0.getActionCommand().equals("1")) {
            sizingType = SizingType.actualsize;
            this.setMenuSizing();
            this.imagePanel.sizing(sizingType);
        } else if (arg0.getActionCommand().equals("\u00bd")) {
            sizingType = SizingType.halfsize;
            this.setMenuSizing();
            this.imagePanel.sizing(sizingType);
        } else if (arg0.getActionCommand().equals("2")) {
            sizingType = SizingType.doublesize;
            this.setMenuSizing();
            this.imagePanel.sizing(sizingType);
        } else if (arg0.getActionCommand().equals("zoom")) {
            sizingType = SizingType.zoomsize;
            this.setMenuSizing();
            this.imagePanel.sizing(sizingType);
        } else if (arg0.getActionCommand().equals("all")) {
            if (this.imageList.size() > 1) {
                this.imagePanel.setImages(this.imageList);
            }
        } else if (arg0.getActionCommand().equals("single")) {
            this.imagePanel.setImage(this.imageList.get(this.index));
        } else if (arg0.getActionCommand().equals("<")) {
            if (this.index > 0) {
                --this.index;
                this.imagePanel.setImage(this.imageList.get(this.index));
            }
        } else if (arg0.getActionCommand().equals("<<")) {
            if (this.index > 0) {
                this.index -= 5;
                if (this.index < 0) {
                    this.index = 0;
                }
                this.imagePanel.setImage(this.imageList.get(this.index));
            }
        } else if (arg0.getActionCommand().equals(">")) {
            if (this.index < this.imageList.size() - 1) {
                ++this.index;
                this.imagePanel.setImage(this.imageList.get(this.index));
            }
        } else if (arg0.getActionCommand().equals(">>")) {
            if (this.index < this.imageList.size() - 1) {
                this.index += 5;
                if (this.index >= this.imageList.size()) {
                    this.index = this.imageList.size() - 1;
                }
                this.imagePanel.setImage(this.imageList.get(this.index));
            }
        } else if (arg0.getActionCommand().equals("flipH")) {
            this.imageList.set(this.index, this.flipHImage(this.imageList.get(this.index)));
            this.imagePanel.setImage(this.imageList.get(this.index));
        } else if (arg0.getActionCommand().equals("flipV")) {
            this.imageList.set(this.index, this.flipVImage(this.imageList.get(this.index)));
            this.imagePanel.setImage(this.imageList.get(this.index));
        } else if (arg0.getActionCommand().equals("R+")) {
            this.imageList.set(this.index, this.rotateImage(this.imageList.get(this.index)));
            this.imagePanel.setImage(this.imageList.get(this.index));
        } else if (arg0.getActionCommand().equals("R-")) {
            this.imageList.set(this.index, this.rotateImage(this.rotateImage(this.rotateImage(this.imageList.get(this.index)))));
            this.imagePanel.setImage(this.imageList.get(this.index));
        } else if (arg0.getActionCommand().equals("R")) {
            this.imageList.set(this.index, this.rotateImage(this.rotateImage(this.imageList.get(this.index))));
            this.imagePanel.setImage(this.imageList.get(this.index));
        } else if (arg0.getActionCommand().equals("home")) {
            this.index = 0;
            this.imagePanel.setImage(this.imageList.get(this.index));
        } else if (arg0.getActionCommand().equals("end")) {
            this.index = this.imageList.size() - 1;
            this.imagePanel.setImage(this.imageList.get(this.index));
        } else if (arg0.getActionCommand().equals("save")) {
            this.saveImage();
        } else if (arg0.getActionCommand().equals("load")) {
            this.loadImages();
        } else if (arg0.getActionCommand().equals("sort")) {
            this.sortImages();
        } else if (arg0.getActionCommand().equals("copy")) {
            this.copyImage();
        }
    }

    public static List<String> generateScript() {
        ArrayList<String> list = new ArrayList<String>();
        if (popupImage == null) {
            return list;
        }
        list.add("; Image view including all loaded files");
        list.add("#ShowPopupSystem Image " + popupImage.generateLocationParams());
        StringBuilder sb = new StringBuilder();
        boolean firstLine = true;
        for (ImageEntry ie : PopupImage.popupImage.imageList) {
            if (ie.path == null || ie.path.length() <= 0) continue;
            if (sb.length() > 50 && sb.length() + ie.path.length() > 100) {
                list.add("#ShowImage " + (firstLine ? "" : "- ") + sb.toString());
                sb.setLength(0);
                firstLine = false;
            }
            if (sb.length() > 0) {
                sb.append(" ");
            }
            if (ie.path.contains(" ")) {
                sb.append("\"");
                sb.append(ie.path);
                sb.append("\"");
                continue;
            }
            sb.append(ie.path);
        }
        if (sb.length() > 0) {
            list.add("#ShowImage " + (firstLine ? "" : "- ") + sb.toString());
        }
        return list;
    }

    public static void alignGridAll(int pixels) {
        if (popupImage == null) {
            return;
        }
        popupImage.alignGrid(pixels);
    }

    private class Added
    extends Thread {
        List<String> path = new ArrayList<String>();

        public Added(String path) {
            this.path.add(path);
            this.start();
        }

        public Added(List<String> path) {
            this.path = path;
            this.start();
        }

        @Override
        public void run() {
            for (String pp : this.path) {
                if (pp.contains("*") || this.path.contains("?")) {
                    for (String fname : PopupImage.this.getFileList(pp)) {
                        PopupImage.this.addImageAsync(PopupImage.this.getImageFile(fname));
                    }
                } else {
                    PopupImage.this.addImageAsync(PopupImage.this.getImage(pp));
                }
                if (PopupImage.this.imageList.size() >= 200) break;
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PopupImage.this.sortImages();
                }
            });
        }
    }

    static class ImageEntry
    implements Comparable<ImageEntry> {
        private BufferedImage imagex;
        String path;
        String name;

        ImageEntry(File f) throws IOException {
            ByteBuffer bb = new ByteBuffer();
            bb.append(f);
            this.imagex = ImageIO.read(bb.getAsInputStream());
            this.path = f.getAbsolutePath();
            this.name = f.getName();
        }

        ImageEntry(BufferedImage image, String path, String name) {
            this.imagex = image;
            this.path = path;
            this.name = name;
        }

        @Override
        public int compareTo(ImageEntry o) {
            return this.name.compareTo(o.name);
        }

        public long size() {
            return (long)(this.imagex.getHeight() * this.imagex.getWidth()) * 4L;
        }

        public BufferedImage getFullImage() {
            return this.imagex;
        }

        public BufferedImage getSmallImage() {
            return this.imagex;
        }

        public boolean isValid() {
            return this.imagex != null;
        }
    }

    private class ImagePanel
    extends JPanel
    implements ImageObserver,
    MouseListener,
    MouseWheelListener,
    MouseMotionListener {
        private ImageEntry image = null;
        private List<ImageEntry> images = null;
        private int dw = 0;
        private int dh = 0;
        private int w0 = 0;
        private int h0 = 0;
        private SizingType sizingType = SizingType.resize;
        private double zoom = 1.0;
        private int xofs = 0;
        private int yofs = 0;
        private boolean dragOn = false;
        private int dragx0 = 0;
        private int dragy0 = 0;

        ImagePanel() {
            this.addMouseListener(this);
            this.addMouseWheelListener(this);
            this.addMouseMotionListener(this);
        }

        public void setImage(ImageEntry imageEntry) {
            if (this.image == imageEntry) {
                return;
            }
            this.xofs = 0;
            this.yofs = 0;
            this.zoom = 1.0;
            this.image = imageEntry;
            this.images = null;
            PopupImage.this.enableButtons();
            this.repaint();
            PopupImage.this.setTitle("Image   -   " + imageEntry.name + "      " + imageEntry.getFullImage().getWidth() + " \u00d7 " + imageEntry.getFullImage().getHeight());
        }

        public void setImages(List<ImageEntry> imageEntries) {
            if (this.images == imageEntries) {
                return;
            }
            this.xofs = 0;
            this.yofs = 0;
            this.zoom = 1.0;
            this.images = imageEntries;
            this.image = null;
            PopupImage.this.enableButtons();
            this.repaint();
            if (Support.devlop) {
                long sz = 0L;
                for (ImageEntry ie : imageEntries) {
                    sz += ie.size();
                }
                PopupImage.this.setTitle("Image   -   " + PopupImage.this.imageList.size() + " images, estimated memory usage " + StringUtil.formatDoubleEE(sz, true, 3) + "b");
            } else {
                PopupImage.this.setTitle("Image   -   " + PopupImage.this.imageList.size() + " images");
            }
        }

        public void sizing(SizingType sizingType) {
            this.xofs = 0;
            this.yofs = 0;
            this.zoom = 1.0;
            this.sizingType = sizingType;
            this.repaint();
        }

        public boolean isAll() {
            return this.images != null;
        }

        private void setScale() {
            if (this.image == null) {
                return;
            }
            int iw = this.image.getFullImage().getWidth(null);
            int ih = this.image.getFullImage().getHeight(null);
            if (ih == 0 || iw == 0) {
                return;
            }
            this.dw = this.getWidth() - this.getInsets().left - this.getInsets().right;
            this.dh = this.getHeight() - this.getInsets().top - this.getInsets().bottom;
            this.w0 = 0;
            this.h0 = 0;
            switch (this.sizingType) {
                case resize: {
                    int x = (int)((double)iw / (double)ih * (double)this.dh);
                    if (x <= this.dw) {
                        this.w0 = (this.dw - x) / 2;
                        this.dw = x;
                        break;
                    }
                    x = (int)((double)ih / (double)iw * (double)this.dw);
                    if (x > this.dh) break;
                    this.h0 = (this.dh - x) / 2;
                    this.dh = x;
                    break;
                }
                case actualsize: {
                    if (iw > this.dw || ih > this.dh) {
                        int x = (int)((double)iw / (double)ih * (double)this.dh);
                        if (x <= this.dw) {
                            this.w0 = (this.dw - x) / 2;
                            this.dw = x;
                            break;
                        }
                        x = (int)((double)ih / (double)iw * (double)this.dw);
                        if (x > this.dh) break;
                        this.h0 = (this.dh - x) / 2;
                        this.dh = x;
                        break;
                    }
                    this.w0 = (this.dw - iw) / 2;
                    this.h0 = (this.dh - ih) / 2;
                    this.dw = iw;
                    this.dh = ih;
                    break;
                }
                case halfsize: {
                    if (iw / 2 > this.dw || ih / 2 > this.dh) {
                        int x = (int)((double)iw / (double)ih * (double)this.dh);
                        if (x <= this.dw) {
                            this.w0 = (this.dw - x) / 2;
                            this.dw = x;
                            break;
                        }
                        x = (int)((double)ih / (double)iw * (double)this.dw);
                        if (x > this.dh) break;
                        this.h0 = (this.dh - x) / 2;
                        this.dh = x;
                        break;
                    }
                    this.w0 = (this.dw - iw / 2) / 2;
                    this.h0 = (this.dh - ih / 2) / 2;
                    this.dw = iw / 2;
                    this.dh = ih / 2;
                    break;
                }
                case doublesize: {
                    if (iw * 2 > this.dw || ih * 2 > this.dh) {
                        int x = (int)((double)iw / (double)ih * (double)this.dh);
                        if (x <= this.dw) {
                            this.w0 = (this.dw - x) / 2;
                            this.dw = x;
                            break;
                        }
                        x = (int)((double)ih / (double)iw * (double)this.dw);
                        if (x > this.dh) break;
                        this.h0 = (this.dh - x) / 2;
                        this.dh = x;
                        break;
                    }
                    this.w0 = (this.dw - iw * 2) / 2;
                    this.h0 = (this.dh - ih * 2) / 2;
                    this.dw = iw * 2;
                    this.dh = ih * 2;
                    break;
                }
                case zoomsize: {
                    this.w0 = (int)(((double)this.dw - (double)iw * this.zoom) / 2.0) + this.xofs;
                    this.h0 = (int)(((double)this.dh - (double)ih * this.zoom) / 2.0) + this.yofs;
                    this.dw = (int)((double)iw * this.zoom);
                    this.dh = (int)((double)ih * this.zoom);
                }
            }
        }

        private List<Rectangle> getAllPositions() {
            ArrayList<Rectangle> list = new ArrayList<Rectangle>(this.images.size());
            int n = this.images.size();
            int wcnt = n < 3 ? n : (int)Math.sqrt(n);
            int hcnt = 0;
            int wimg = 0;
            int himg = 0;
            int marginx = 10;
            int marginy = 8;
            if (n > 200) {
                marginx = 4;
                marginy = 2;
            } else if (n > 50) {
                marginx = 8;
                marginy = 6;
            }
            int m = 0;
            do {
                ++m;
                if (wcnt < n - 1) {
                    ++wcnt;
                }
                if ((hcnt = (n + wcnt - 1) / wcnt) == 0) {
                    hcnt = 1;
                }
                wimg = this.getWidth() / wcnt - marginx;
            } while ((himg = this.getHeight() / hcnt - marginy) < wimg && hcnt > 1 && m < 10);
            int hpos = 0;
            while (hpos < hcnt) {
                int wpos = 0;
                while (wpos < wcnt) {
                    int x0 = this.getWidth() * wpos / wcnt + marginx / 2;
                    int y0 = this.getHeight() * hpos / hcnt + marginy / 2;
                    list.add(new Rectangle(x0, y0, wimg, himg));
                    if (list.size() >= this.images.size()) break;
                    ++wpos;
                }
                if (list.size() >= this.images.size()) break;
                ++hpos;
            }
            if (list.size() > this.images.size()) {
                System.out.println("Overflow in list");
            }
            return list;
        }

        public void adjustZoom(double delta) {
            if (this.sizingType == SizingType.zoomsize) {
                this.zoom += delta;
                if (this.zoom < 0.1) {
                    this.zoom = 0.1;
                }
                if (this.zoom > 10.0) {
                    this.zoom = 10.0;
                }
                this.repaint();
            }
        }

        public void moveImage(int dx, int dy) {
            this.xofs += dx;
            this.yofs += dy;
            int w = (int)((double)this.image.getFullImage().getWidth(null) * this.zoom);
            int h = (int)((double)this.image.getFullImage().getHeight(null) * this.zoom);
            if (this.xofs < -w) {
                this.xofs = -w;
            }
            if (this.xofs > w) {
                this.xofs = w;
            }
            if (this.yofs < -h) {
                this.yofs = -h;
            }
            if (this.yofs > h) {
                this.yofs = h;
            }
            this.repaint();
        }

        @Override
        public void paint(Graphics gh) {
            Graphics2D g2 = (Graphics2D)gh.create();
            g2.setColor(Color.LIGHT_GRAY);
            g2.fillRect(0, 0, this.getWidth(), this.getHeight());
            if (this.image != null) {
                this.setScale();
                g2.drawImage(this.image.getFullImage(), this.w0, this.h0, this.dw, this.dh, this);
            } else if (this.images != null) {
                List<Rectangle> list = this.getAllPositions();
                int i = 0;
                while (i < list.size()) {
                    Rectangle r = list.get(i);
                    BufferedImage img = this.images.get(i).getSmallImage();
                    if (i == PopupImage.this.index) {
                        g2.setColor(new Color(Color.LIGHT_GRAY.getRed() + 20, Color.LIGHT_GRAY.getGreen() + 20, Color.LIGHT_GRAY.getBlue() + 20));
                        g2.fillRect(r.x, r.y, r.width, r.height);
                    }
                    int iw = ((Image)img).getWidth(null);
                    int ih = ((Image)img).getHeight(null);
                    int dw = r.width;
                    int dh = r.height;
                    this.w0 = 0;
                    this.h0 = 0;
                    int x = (int)((double)iw / (double)ih * (double)dh);
                    if (x <= dw) {
                        this.w0 = (dw - x) / 2;
                        dw = x;
                    } else {
                        x = (int)((double)ih / (double)iw * (double)dw);
                        if (x <= dh) {
                            this.h0 = (dh - x) / 2;
                            dh = x;
                        }
                    }
                    g2.drawImage(img, this.w0 + r.x, this.h0 + r.y, dw, dh, this);
                    ++i;
                }
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (this.images != null) {
                List<Rectangle> list = this.getAllPositions();
                int i = 0;
                while (i < list.size()) {
                    Rectangle r = list.get(i);
                    if (r.contains(e.getX(), e.getY())) {
                        PopupImage.this.index = i;
                        this.setImage(this.images.get(i));
                    }
                    ++i;
                }
            } else {
                this.requestFocusInWindow();
                this.requestFocus();
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.dragOn = this.sizingType == SizingType.zoomsize && this.image != null;
            this.dragx0 = e.getX();
            this.dragy0 = e.getY();
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.dragOn = false;
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent arg0) {
            if (this.sizingType == SizingType.zoomsize) {
                this.adjustZoom((double)(-arg0.getWheelRotation()) / 10.0);
            }
        }

        @Override
        public void mouseDragged(MouseEvent arg0) {
            if (this.dragOn) {
                int dx = arg0.getX() - this.dragx0;
                int dy = arg0.getY() - this.dragy0;
                this.dragx0 = arg0.getX();
                this.dragy0 = arg0.getY();
                this.moveImage(dx, dy);
            }
        }

        @Override
        public void mouseMoved(MouseEvent arg0) {
        }
    }

    static class ImageSelection
    implements Transferable {
        private Image image;

        public ImageSelection(Image image) {
            this.image = image;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{DataFlavor.imageFlavor};
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return DataFlavor.imageFlavor.equals(flavor);
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            if (!DataFlavor.imageFlavor.equals(flavor)) {
                throw new UnsupportedFlavorException(flavor);
            }
            return this.image;
        }
    }

    static enum SizingType {
        resize,
        actualsize,
        doublesize,
        halfsize,
        zoomsize;

    }
}

