/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.main;

import dk.hkj.main.FontAdjust;
import dk.hkj.main.InterfaceThreads;
import dk.hkj.main.PopupBaseFrame;
import dk.hkj.main.Support;
import dk.hkj.panels.AdjustPanel;
import dk.hkj.panels.AdvancedDeviceReadoutPanel;
import dk.hkj.panels.AdvancedReadoutPanel;
import dk.hkj.panels.AnalogReadoutPanel;
import dk.hkj.panels.AutoHoldReadoutPanel;
import dk.hkj.panels.BasicPanel;
import dk.hkj.panels.BitsReadoutPanel;
import dk.hkj.panels.ChartingPanel;
import dk.hkj.panels.DevicePopupsPanel;
import dk.hkj.panels.DualAdjustPanel;
import dk.hkj.panels.DualChartingPanel;
import dk.hkj.panels.DualDeviceReadoutPanel;
import dk.hkj.panels.DualReadoutPanel;
import dk.hkj.panels.EfficiencyReadoutPanel;
import dk.hkj.panels.HistogramPanel;
import dk.hkj.panels.MathAnalogReadoutPanel;
import dk.hkj.panels.MathBitsReadoutPanel;
import dk.hkj.panels.MathDualReadoutPanel;
import dk.hkj.panels.MathPentaReadoutPanel;
import dk.hkj.panels.MathReadoutPanel;
import dk.hkj.panels.MathTripleReadoutPanel;
import dk.hkj.panels.MinMaxChartPanel;
import dk.hkj.panels.MultiOnOffPanel;
import dk.hkj.panels.MultiPSLoadReadoutPanel;
import dk.hkj.panels.OnOffPanel;
import dk.hkj.panels.PSLoadReadoutPanel;
import dk.hkj.panels.ReadoutDevicePanel;
import dk.hkj.panels.ReadoutPanel;
import dk.hkj.panels.ScriptPanel;
import dk.hkj.panels.SetDualPSVoltCurrentWithOffPanel;
import dk.hkj.panels.SetDualParamPanel;
import dk.hkj.panels.SetDualParamsWithOffPanel;
import dk.hkj.panels.SetMultiLoadsWithOffPanel;
import dk.hkj.panels.SetPSVoltCurrentWithOffPanel;
import dk.hkj.panels.SetParamPanel;
import dk.hkj.panels.SetParamWithOffPanel;
import dk.hkj.panels.SetTripleParamPanel;
import dk.hkj.panels.SetTripleParamsWithOffPanel;
import dk.hkj.panels.SimpleDeviceReadoutPanel;
import dk.hkj.panels.SimpleReadoutPanel;
import dk.hkj.panels.SystemPanel;
import dk.hkj.panels.VoltCurrentPowerReadoutPanel;
import dk.hkj.script.Script;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.Timer;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class PopupGridPanel
extends PopupBaseFrame
implements ActionListener {
    private static PopupGridPanel popupGridPanel;
    private static List<PopupGridPanel> popupSinglePanel;
    public static final int SAMPLE_TIME = 300;
    private static final int SINGLE_WIDTH = 300;
    private static final int SINGLE_HEIGHT = 200;
    private static final int GRID_WIDTH = 500;
    private static final int GRID_HEIGHT = 300;
    private static String[] PANELS;
    private int rows = 2;
    private int columns = 3;
    private JPanel gridPanel = null;
    private JLabel gridLabel = null;
    private JButton resetButton = null;
    public List<BasicPanel> panelList = new ArrayList<BasicPanel>();
    private Timer timer = null;
    private int lastPanelWidth = 0;
    private int lastPanelHeight = 0;
    private int lastRowCount = 0;
    private int lastColumnCount = 0;
    private JPopupMenu addPopupMenu = null;
    private JPopupMenu gridPopupMenu = null;
    private boolean single = false;
    private boolean needData = false;
    private List<Long> sampleClock = new ArrayList<Long>();
    private int mathId = 0;
    private Script script = new Script();

    static {
        String[] stringArray;
        popupGridPanel = null;
        popupSinglePanel = new ArrayList<PopupGridPanel>();
        if (Support.devlop) {
            String[] stringArray2 = new String[10];
            stringArray2[0] = "Readout: Simple readout, Readout, Advanced readout, Dual readout, Auto hold readout";
            stringArray2[1] = "Device (tracking) readout: Simple device readout, Device readout, Advanced Device readout, Dual device readout";
            stringArray2[2] = "Math readout: Math readout, Math dual readout, Math triple readout, Math penta readout";
            stringArray2[3] = "Other readouts: Volt/Current/Power readout, Analog readout, Math analog readout, Bits readout, Math bits readout, Efficiency readout";
            stringArray2[4] = "Charts: Charting, Dual charting, Min/Max Chart, Histogram";
            stringArray2[5] = "Specific type readout: PS & Load Readout, Multi PS & Load Readout";
            stringArray2[6] = "General device setting: On/off, Multi on/off, Set param, Set dual param,Set triple param, Set param with off, Set dual params with off, Set triple params with off";
            stringArray2[7] = "Specific device setting: Set PS Volt/Current with off, Set dual PS Volt/Current with off, Set multi loads with off";
            stringArray2[8] = "General device adjustment: Adjust, Dual adjust";
            stringArray = stringArray2;
            stringArray2[9] = "System: Device popups, System, Script";
        } else {
            String[] stringArray3 = new String[9];
            stringArray3[0] = "Readout: Simple readout, Readout, Advanced readout, Dual readout, Auto hold readout";
            stringArray3[1] = "Device (tracking) readout: Simple device readout, Device Readout, Advanced Device readout, Dual device readout";
            stringArray3[2] = "Other readouts: Volt/Current/Power readout, Efficiency readout";
            stringArray3[3] = "Charts: Charting, Dual charting, Min/Max Chart, Histogram";
            stringArray3[4] = "Specific type readout: PS & Load Readout, Multi PS & Load Readout";
            stringArray3[5] = "General device setting: On/off, Multi on/off, Set param";
            stringArray3[6] = "Specific device setting: Set PS Volt/Current with off, Set dual PS Volt/Current with off, Set multi loads with off";
            stringArray3[7] = "General device adjustment: Adjust, Dual adjust";
            stringArray = stringArray3;
            stringArray3[8] = "System: Device popups, System, Script";
        }
        PANELS = stringArray;
    }

    private void killPanel() {
        if (this.single) {
            popupGridPanel.remove(this);
            if (this.timer != null) {
                this.timer.stop();
                this.timer = null;
            }
        } else if (popupGridPanel == this) {
            if (this.timer != null) {
                this.timer.stop();
                this.timer = null;
            }
            popupGridPanel = null;
        }
    }

    private PopupGridPanel(boolean single) {
        ++this.mathId;
        this.single = single;
        this.setTitle(single ? "Single panel" : "Grid panel");
        this.setDefaultCloseOperation(2);
        this.setLayout(new BorderLayout());
        this.setSize(single ? new Dimension(300, 200) : new Dimension(500, 300));
        if (single) {
            popupSinglePanel.add(this);
        }
        this.gridPanel = new JPanel();
        this.gridPanel.setLayout(new GridBagLayout());
        this.add(this.gridPanel);
        if (!single) {
            this.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentHidden(ComponentEvent e) {
                    PopupGridPanel.this.killPanel();
                }

                @Override
                public void componentResized(ComponentEvent arg0) {
                    PopupGridPanel.this.sizePanels(false);
                }
            });
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosed(WindowEvent e) {
                    PopupGridPanel.this.killPanel();
                    Support.math.removeDomain("GridPanel" + PopupGridPanel.this.mathId);
                }
            });
            this.definePopupName("GridPanel", true);
            int i = 0;
            while (i < 0) {
                this.panelList.add(new MultiOnOffPanel());
                this.panelList.add(new OnOffPanel());
                ++i;
            }
            this.setNeedDate();
            JPanel controlPanel = new JPanel();
            controlPanel.setLayout(new FlowLayout(0, 10, 2));
            this.resetButton = new FontAdjust.FontButton("Reset");
            this.resetButton.setActionCommand("reset");
            this.resetButton.addActionListener(this);
            this.resetButton.setToolTipText("Reset all data displays, but do not affect devices");
            this.resetButton.setInheritsPopupMenu(true);
            this.resetButton.setMargin(new Insets(1, 1, 1, 1));
            controlPanel.add(this.resetButton);
            controlPanel.add(Box.createHorizontalStrut(10));
            this.gridLabel = new FontAdjust.FontLabel("Layout size: xx");
            this.gridLabel.setToolTipText("Right click to select layout grid for panels");
            controlPanel.add(this.gridLabel);
            this.addPopupMenu = new JPopupMenu();
            this.addPopupMenu.addPopupMenuListener(new PopupMenuListener(){

                @Override
                public void popupMenuCanceled(PopupMenuEvent arg0) {
                }

                @Override
                public void popupMenuWillBecomeInvisible(PopupMenuEvent arg0) {
                }

                @Override
                public void popupMenuWillBecomeVisible(PopupMenuEvent arg0) {
                    PopupGridPanel.this.prepareAddPopupMenu();
                }
            });
            this.gridPopupMenu = new JPopupMenu();
            this.gridPopupMenu.addPopupMenuListener(new PopupMenuListener(){

                @Override
                public void popupMenuCanceled(PopupMenuEvent arg0) {
                }

                @Override
                public void popupMenuWillBecomeInvisible(PopupMenuEvent arg0) {
                }

                @Override
                public void popupMenuWillBecomeVisible(PopupMenuEvent arg0) {
                    PopupGridPanel.this.prepareGridPopupMenu();
                }
            });
            this.gridPanel.setComponentPopupMenu(this.addPopupMenu);
            this.gridPanel.setToolTipText("Right click and select panels to show");
            controlPanel.setComponentPopupMenu(this.addPopupMenu);
            this.gridLabel.setComponentPopupMenu(this.gridPopupMenu);
            this.setPanelGrid(2, 3);
            this.add((Component)controlPanel, "South");
        } else {
            this.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentHidden(ComponentEvent e) {
                    if (popupSinglePanel.contains(PopupGridPanel.this)) {
                        if (PopupGridPanel.this.timer != null) {
                            PopupGridPanel.this.timer.stop();
                            PopupGridPanel.this.timer = null;
                        }
                        popupSinglePanel.remove(PopupGridPanel.this);
                        Support.math.removeDomain("GridPanel" + PopupGridPanel.this.mathId);
                    }
                }

                @Override
                public void componentResized(ComponentEvent arg0) {
                    PopupGridPanel.this.sizePanels(false);
                }
            });
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosed(WindowEvent e) {
                    if (popupSinglePanel.contains(PopupGridPanel.this)) {
                        if (PopupGridPanel.this.timer != null) {
                            PopupGridPanel.this.timer.stop();
                            PopupGridPanel.this.timer = null;
                        }
                        popupSinglePanel.remove(PopupGridPanel.this);
                        Support.math.removeDomain("GridPanel" + PopupGridPanel.this.mathId);
                    }
                }
            });
            this.setPanelGrid(1, 1);
            this.definePopupName("SinglePanel", true);
        }
        this.timer = new Timer(300, this);
        this.timer.setActionCommand("timer");
        this.timer.start();
        Support.math.resetCalc("GridPanel" + this.mathId);
    }

    public double getSampleTime() {
        if (this.sampleClock.size() <= 2) {
            return 0.3;
        }
        return (double)(this.sampleClock.get(this.sampleClock.size() - 1) - this.sampleClock.get(0)) / 1000.0 / (double)(this.sampleClock.size() - 1);
    }

    public static void closeAll() {
        if (popupGridPanel != null) {
            popupGridPanel.setVisible(false);
            popupGridPanel = null;
        }
        int i = popupSinglePanel.size() - 1;
        while (i >= 0) {
            popupSinglePanel.get(i).setVisible(false);
            ++i;
        }
    }

    private void setNeedDate() {
        this.needData = false;
        for (BasicPanel bp : this.panelList) {
            if (!bp.needData()) continue;
            this.needData = true;
        }
    }

    private void update() {
        this.sampleClock.add(System.currentTimeMillis());
        if (this.sampleClock.size() > 10) {
            this.sampleClock.remove(0);
        }
        if (this.needData) {
            InterfaceThreads.setupVars();
            Support.math.calcAllColumns(this.script, "GridPanel" + this.mathId);
        }
        int i = 0;
        while (i < Math.min(this.rows * this.columns, this.panelList.size())) {
            this.panelList.get(i).update();
            ++i;
        }
    }

    public void layoutPanels() {
        this.gridPanel.removeAll();
        int n = 0;
        GridBagConstraints cc = new GridBagConstraints();
        HashSet<String> reservedPositions = new HashSet<String>();
        int r = 0;
        while (r < this.rows) {
            int c = 0;
            while (c < this.columns) {
                if (!reservedPositions.contains(c + "-" + r)) {
                    if (n >= this.panelList.size()) break;
                    BasicPanel bp = this.panelList.get(n);
                    cc.gridx = c;
                    cc.gridy = r;
                    cc.anchor = 10;
                    cc.insets = new Insets(1, 1, 1, 1);
                    cc.gridwidth = bp.doubleWidth && !this.single ? 2 : 1;
                    cc.gridheight = bp.doubleHeight && !this.single ? 2 : 1;
                    cc.weightx = 1.0;
                    cc.weighty = 1.0;
                    this.gridPanel.add((Component)bp, cc);
                    reservedPositions.add(c + "-" + r);
                    if (bp.doubleWidth && !this.single) {
                        reservedPositions.add(c + 1 + "-" + r);
                    }
                    if (bp.doubleHeight && !this.single) {
                        reservedPositions.add(c + "-" + (r + 1));
                    }
                    if (bp.doubleWidth && bp.doubleHeight && !this.single) {
                        reservedPositions.add(c + 1 + "-" + (r + 1));
                    }
                    bp.forceFontResize();
                    ++n;
                }
                ++c;
            }
            if (n >= this.panelList.size()) break;
            ++r;
        }
        this.gridPanel.repaint();
    }

    public void sizePanels(boolean force) {
        int w = this.gridPanel.getWidth();
        int h = this.gridPanel.getHeight();
        if (h < 50) {
            h = 50;
        }
        if (w < 100) {
            w = 100;
        }
        if (!force && w == this.lastPanelWidth && h == this.lastPanelHeight && this.lastRowCount == this.rows && this.lastColumnCount == this.columns) {
            return;
        }
        this.lastPanelWidth = w;
        this.lastPanelHeight = h;
        this.lastRowCount = this.rows;
        this.lastColumnCount = this.columns;
        for (BasicPanel bp : this.panelList) {
            Dimension dim = new Dimension(w / this.columns * (bp.doubleWidth ? 2 : 1) - 4, h / this.rows * (bp.doubleHeight ? 2 : 1) - 4);
            bp.setMinimumSize(dim);
            bp.setPreferredSize(dim);
            bp.setSize(dim);
            bp.forceFontResize();
        }
    }

    private void reset() {
        Support.math.resetCalc("GridPanel" + this.mathId);
        for (BasicPanel bp : this.panelList) {
            bp.reset();
        }
    }

    public void moveUp(BasicPanel bp) {
        int index = this.panelList.indexOf(bp);
        if (index == 0) {
            return;
        }
        this.panelList.remove(index);
        this.panelList.add(index - 1, bp);
        this.layoutPanels();
    }

    public void moveDown(BasicPanel bp) {
        int index = this.panelList.indexOf(bp);
        if (index == this.panelList.size() - 1) {
            return;
        }
        this.panelList.remove(index);
        this.panelList.add(index + 1, bp);
        this.layoutPanels();
    }

    public void moveLineUp(BasicPanel bp) {
        int index = this.panelList.indexOf(bp);
        if (index < this.columns) {
            return;
        }
        this.panelList.remove(index);
        this.panelList.add(index - this.columns, bp);
        this.layoutPanels();
    }

    public void moveLineDown(BasicPanel bp) {
        int index = this.panelList.indexOf(bp);
        if (index == this.panelList.size() - 1) {
            return;
        }
        this.panelList.remove(index);
        this.panelList.add(index + this.columns, bp);
        this.layoutPanels();
    }

    public void moveTop(BasicPanel bp) {
        this.panelList.remove(bp);
        this.panelList.add(0, bp);
        this.layoutPanels();
    }

    public void moveBottom(BasicPanel bp) {
        this.panelList.remove(bp);
        this.panelList.add(bp);
        this.layoutPanels();
    }

    public void removePanel(BasicPanel bp) {
        this.panelList.remove(bp);
        this.setNeedDate();
        this.layoutPanels();
    }

    public static PopupGridPanel createSinglePanel(int x, int y, int w, int h, BasicPanel bp) {
        PopupGridPanel pgp = new PopupGridPanel(true);
        pgp.addPanel(bp);
        if (w != 0 && h != 0) {
            pgp.setLocation(x, y);
            pgp.setSize(w, h);
        }
        pgp.setVisible(true);
        return pgp;
    }

    public void convertToSingle(BasicPanel bp) {
        this.panelList.remove(bp);
        PopupGridPanel.createSinglePanel(0, 0, 0, 0, bp);
        this.setNeedDate();
        this.layoutPanels();
    }

    public void moveToGrid(BasicPanel bp) {
        PopupGridPanel pgp = PopupGridPanel.getPopup();
        this.panelList.remove(bp);
        pgp.addPanel(bp);
        this.setVisible(false);
    }

    public void removeAllPanels() {
        this.panelList.clear();
        this.setNeedDate();
        this.layoutPanels();
    }

    public static BasicPanel createPanel(String name) {
        name = name.replace(" ", "").replace("/", "").replace("&", "");
        BasicPanel bp = null;
        if (name.equalsIgnoreCase(SimpleReadoutPanel.panelName)) {
            bp = new SimpleReadoutPanel();
        } else if (name.equalsIgnoreCase(SimpleDeviceReadoutPanel.panelName)) {
            bp = new SimpleDeviceReadoutPanel();
        } else if (name.equalsIgnoreCase(ReadoutPanel.panelName)) {
            bp = new ReadoutPanel();
        } else if (name.equalsIgnoreCase(ReadoutDevicePanel.panelName)) {
            bp = new ReadoutDevicePanel();
        } else if (name.equalsIgnoreCase(AdvancedReadoutPanel.panelName)) {
            bp = new AdvancedReadoutPanel();
        } else if (name.equalsIgnoreCase(AdvancedDeviceReadoutPanel.panelName)) {
            bp = new AdvancedDeviceReadoutPanel();
        } else if (name.equalsIgnoreCase(DualDeviceReadoutPanel.panelName)) {
            bp = new DualDeviceReadoutPanel();
        } else if (name.equalsIgnoreCase(DualReadoutPanel.panelName)) {
            bp = new DualReadoutPanel();
        } else if (name.equalsIgnoreCase(ChartingPanel.panelName)) {
            bp = new ChartingPanel();
        } else if (name.equalsIgnoreCase(OnOffPanel.panelName)) {
            bp = new OnOffPanel();
        } else if (name.equalsIgnoreCase(MultiOnOffPanel.panelName)) {
            bp = new MultiOnOffPanel();
        } else if (name.equalsIgnoreCase(SetParamPanel.panelName)) {
            bp = new SetParamPanel();
        } else if (name.equalsIgnoreCase(PSLoadReadoutPanel.panelName)) {
            bp = new PSLoadReadoutPanel();
        } else if (name.equalsIgnoreCase(MultiPSLoadReadoutPanel.panelName)) {
            bp = new MultiPSLoadReadoutPanel();
        } else if (name.equalsIgnoreCase(VoltCurrentPowerReadoutPanel.panelName)) {
            bp = new VoltCurrentPowerReadoutPanel();
        } else if (name.equalsIgnoreCase(DevicePopupsPanel.panelName)) {
            bp = new DevicePopupsPanel();
        } else if (name.equalsIgnoreCase(SystemPanel.panelName)) {
            bp = new SystemPanel();
        } else if (name.equalsIgnoreCase(SetParamWithOffPanel.panelName)) {
            bp = new SetParamWithOffPanel();
        } else if (name.equalsIgnoreCase(SetPSVoltCurrentWithOffPanel.panelName)) {
            bp = new SetPSVoltCurrentWithOffPanel();
        } else if (name.equalsIgnoreCase(SetDualParamsWithOffPanel.panelName)) {
            bp = new SetDualParamsWithOffPanel();
        } else if (name.equalsIgnoreCase(SetTripleParamsWithOffPanel.panelName)) {
            bp = new SetTripleParamsWithOffPanel();
        } else if (name.equalsIgnoreCase(SetDualPSVoltCurrentWithOffPanel.panelName)) {
            bp = new SetDualPSVoltCurrentWithOffPanel();
        } else if (name.equalsIgnoreCase(MathReadoutPanel.panelName)) {
            bp = new MathReadoutPanel();
        } else if (name.equalsIgnoreCase(MathDualReadoutPanel.panelName)) {
            bp = new MathDualReadoutPanel();
        } else if (name.equalsIgnoreCase(MathTripleReadoutPanel.panelName)) {
            bp = new MathTripleReadoutPanel();
        } else if (name.equalsIgnoreCase(MathPentaReadoutPanel.panelName)) {
            bp = new MathPentaReadoutPanel();
        } else if (name.equalsIgnoreCase(HistogramPanel.panelName)) {
            bp = new HistogramPanel();
        } else if (name.equalsIgnoreCase(MinMaxChartPanel.panelName)) {
            bp = new MinMaxChartPanel();
        } else if (name.equalsIgnoreCase(SetMultiLoadsWithOffPanel.panelName)) {
            bp = new SetMultiLoadsWithOffPanel();
        } else if (name.equalsIgnoreCase(ScriptPanel.panelName)) {
            bp = new ScriptPanel();
        } else if (name.equalsIgnoreCase(DualChartingPanel.panelName)) {
            bp = new DualChartingPanel();
        } else if (name.equalsIgnoreCase(AutoHoldReadoutPanel.panelName)) {
            bp = new AutoHoldReadoutPanel();
        } else if (name.equalsIgnoreCase(SetDualParamPanel.panelName)) {
            bp = new SetDualParamPanel();
        } else if (name.equalsIgnoreCase(SetTripleParamPanel.panelName)) {
            bp = new SetTripleParamPanel();
        } else if (name.equalsIgnoreCase(AdjustPanel.panelName)) {
            bp = new AdjustPanel();
        } else if (name.equalsIgnoreCase(DualAdjustPanel.panelName)) {
            bp = new DualAdjustPanel();
        } else if (name.equalsIgnoreCase(AnalogReadoutPanel.panelName)) {
            bp = new AnalogReadoutPanel();
        } else if (name.equalsIgnoreCase(MathAnalogReadoutPanel.panelName)) {
            bp = new MathAnalogReadoutPanel();
        } else if (name.equalsIgnoreCase(BitsReadoutPanel.panelName)) {
            bp = new BitsReadoutPanel();
        } else if (name.equalsIgnoreCase(EfficiencyReadoutPanel.panelName)) {
            bp = new EfficiencyReadoutPanel();
        } else if (name.equalsIgnoreCase(MathBitsReadoutPanel.panelName)) {
            bp = new MathBitsReadoutPanel();
        }
        return bp;
    }

    public BasicPanel addPanel(BasicPanel bp) {
        if (bp != null) {
            bp.setScript(this.script);
            this.panelList.add(bp);
            this.sizePanels(true);
            this.layoutPanels();
            this.setNeedDate();
        }
        return bp;
    }

    private void prepareAddPopupMenu() {
        this.addPopupMenu.removeAll();
        String[] stringArray = PANELS;
        int n = PANELS.length;
        int n2 = 0;
        while (n2 < n) {
            String group = stringArray[n2];
            int i = group.indexOf(58);
            FontAdjust.FontMenu menu = new FontAdjust.FontMenu(group.substring(0, i).trim());
            this.addPopupMenu.add(menu);
            String[] stringArray2 = group.substring(i + 1).split("[,;]+");
            int n3 = stringArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                String item = stringArray2[n4];
                item = item.trim();
                FontAdjust.FontMenuItem mi = new FontAdjust.FontMenuItem(item);
                mi.setActionCommand("Panel:" + item);
                mi.addActionListener(this);
                menu.add(mi);
                ++n4;
            }
            ++n2;
        }
    }

    private void prepareGridPopupMenu() {
        this.gridPopupMenu.removeAll();
        int r = 0;
        while (r < 8) {
            FontAdjust.FontMenu menu = new FontAdjust.FontMenu("Rows: " + (r + 1));
            this.gridPopupMenu.add(menu);
            int c = 0;
            while (c < 12) {
                FontAdjust.FontMenuItem mi = new FontAdjust.FontMenuItem("Columns: " + (c + 1));
                mi.setActionCommand("G:" + (r + 1) + ":" + (c + 1));
                mi.addActionListener(this);
                menu.add(mi);
                ++c;
            }
            ++r;
        }
    }

    public void setPanelGrid(int rows, int columns) {
        this.rows = rows;
        this.columns = columns;
        this.sizePanels(true);
        this.layoutPanels();
        if (this.gridLabel != null) {
            this.gridLabel.setText("Grid layout: " + rows + " \u00d7 " + columns);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().startsWith("G:")) {
            String[] s = e.getActionCommand().split("[: ]+");
            this.setPanelGrid(Integer.parseInt(s[1]), Integer.parseInt(s[2]));
        } else if (e.getActionCommand().startsWith("Panel:")) {
            BasicPanel bp = PopupGridPanel.createPanel(e.getActionCommand().substring(6));
            this.addPanel(bp);
        } else if (e.getActionCommand().equals("timer")) {
            this.update();
        } else if (e.getActionCommand().equals("reset")) {
            this.reset();
        }
    }

    private void systemStateChangedHot() {
        for (BasicPanel bp : this.panelList) {
            bp.systemStateChanged();
        }
    }

    public boolean isSinglePanel() {
        return this.single;
    }

    public int getRows() {
        return this.rows;
    }

    public int getColumns() {
        return this.columns;
    }

    public static synchronized PopupGridPanel getPopup() {
        if (popupGridPanel != null) {
            popupGridPanel.requestFocus();
            return popupGridPanel;
        }
        popupGridPanel = new PopupGridPanel(false);
        Point p = Support.paneCommand.popupsButton.getLocationOnScreen();
        p.translate(-750, -400);
        if (p.y < 0) {
            p.y = 0;
        }
        if (p.x < 0) {
            p.x = 0;
        }
        popupGridPanel.setLocation(p);
        popupGridPanel.setVisible(true);
        return popupGridPanel;
    }

    private void generateScript(List<String> list) {
        StringBuilder sb = new StringBuilder();
        if (!this.single) {
            list.add("#GridPanel " + this.rows + " " + this.columns);
        }
        for (BasicPanel bp : this.panelList) {
            if (this.single) {
                sb.append("#SinglePanel ");
                sb.append(this.getLocationOnScreen().x);
                sb.append(" ");
                sb.append(this.getLocationOnScreen().y);
                sb.append(" ");
                sb.append(this.getWidth());
                sb.append(" ");
                sb.append(this.getHeight());
                sb.append(" ");
            } else {
                sb.append("#GridPanel ");
            }
            sb.append(bp.generateScriptCmd());
            list.add(sb.toString());
            sb.setLength(0);
        }
    }

    public static void systemStateChanged() {
        if (popupGridPanel != null) {
            popupGridPanel.systemStateChangedHot();
        }
        if (popupSinglePanel.size() > 0) {
            for (PopupGridPanel pgp : popupSinglePanel) {
                pgp.systemStateChangedHot();
            }
        }
    }

    public static List<String> generateScript() {
        ArrayList<String> list = new ArrayList<String>();
        if (popupGridPanel != null) {
            list.add(";");
            list.add("; Grid panel including all panels in it");
            list.add("#ShowPopupSystem GridPanel " + PopupGridPanel.popupGridPanel.getLocationOnScreen().x + " " + PopupGridPanel.popupGridPanel.getLocationOnScreen().y + " " + popupGridPanel.getWidth() + " " + popupGridPanel.getHeight());
            list.add("#GridPanel");
            popupGridPanel.generateScript(list);
        }
        if (popupSinglePanel.size() > 0) {
            list.add(";");
            list.add("; Single panels");
            for (PopupGridPanel pgp : popupSinglePanel) {
                pgp.generateScript(list);
            }
        }
        return list;
    }

    public static void alignGridAll(int pixels) {
        popupGridPanel.alignGrid(pixels);
    }
}

