/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.main;

import dk.hkj.devices.ManageDeviceDefinitions;
import dk.hkj.main.FontAdjust;
import dk.hkj.main.InterfaceThreads;
import dk.hkj.main.PopupBase;
import dk.hkj.main.Support;
import dk.hkj.shared.SharedInterface;
import dk.hkj.shared.SharedInterfaceAR488;
import dk.hkj.shared.SharedInterfaceAR488Lan;
import dk.hkj.shared.SharedInterfaceNSGPIB232CT;
import dk.hkj.shared.SharedInterfacePrologixEthernet;
import dk.hkj.shared.SharedInterfacePrologixUSB;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

public class PopupGpibConfig
extends PopupBase
implements ActionListener {
    private static PopupGpibConfig showGpibConfig = null;
    private JTable table;
    private JComboBox<String> addComboBox;

    public PopupGpibConfig() {
        if (showGpibConfig != null) {
            showGpibConfig.dispose();
        }
        showGpibConfig = this;
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent arg0) {
            }
        });
        this.setTitle("GPIB interfaces");
        this.definePopupName("GPIB interfaces", true);
        InterfaceThreads.sharedInterfaceList.sort();
        this.addComponentListener(new ComponentListener(){

            @Override
            public void componentHidden(ComponentEvent arg0) {
            }

            @Override
            public void componentMoved(ComponentEvent arg0) {
            }

            @Override
            public void componentResized(ComponentEvent arg0) {
                PopupGpibConfig.this.setPreferredSize(PopupGpibConfig.this.getMaximumSize());
            }

            @Override
            public void componentShown(ComponentEvent arg0) {
            }
        });
        Dimension d = new Dimension(780, 200);
        this.setPreferredSize(d);
        this.makeMainPanel();
        this.pack();
        this.setVisible(true);
    }

    private void makeMainPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        this.table = new FontAdjust.FontTable(){

            @Override
            public Component prepareRenderer(TableCellRenderer renderer, int row, int col) {
                JComponent comp = (JComponent)super.prepareRenderer(renderer, row, col);
                if (!comp.getBackground().equals(Support.colorScheme.selectedCellbackground)) {
                    comp.setBackground(row % 4 == 0 ? Support.colorScheme.tableGridAlternateBackground : Support.colorScheme.textBackground);
                }
                if (col == 0) {
                    comp.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 0));
                    ((JLabel)comp).setHorizontalAlignment(2);
                } else if (col == 3) {
                    ((JLabel)comp).setHorizontalAlignment(0);
                    if (((String)InterfaceThreads.sharedInterfaceList.getValueAt(row, col)).length() == 0) {
                        comp.setBackground(Support.colorScheme.errorBackground);
                    }
                } else if (col == 4) {
                    ((JLabel)comp).setHorizontalAlignment(0);
                    SharedInterface sif = InterfaceThreads.sharedInterfaceList.get(row);
                    if (sif.getPortType() == ManageDeviceDefinitions.PortType.Serial && sif.getBaudrate().length() == 0) {
                        comp.setBackground(Support.colorScheme.errorBackground);
                    }
                } else if (comp instanceof JLabel) {
                    ((JLabel)comp).setHorizontalAlignment(0);
                }
                return comp;
            }
        };
        this.table.setColumnModel(new Support.WidthTableColumnModel(new int[]{120, 80, 120, 140, 80, 200}));
        this.table.setModel(InterfaceThreads.sharedInterfaceList);
        this.table.setDefaultEditor(String.class, new Support.AutoSelectCellEditor());
        Support.colorScheme.selectedCellbackground = this.table.getSelectionBackground();
        Support.colorScheme.selectedCellForeground = this.table.getSelectionForeground();
        this.table.setAutoResizeMode(0);
        JScrollPane sp = new JScrollPane(this.table);
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.gridwidth = 10;
        c.weightx = 100.0;
        c.weighty = 100.0;
        panel.add((Component)sp, c);
        this.addComboBox = new FontAdjust.FontComboBox<String>();
        this.addComboBox.addItem(SharedInterfaceAR488.interfaceType);
        this.addComboBox.addItem(SharedInterfaceAR488Lan.interfaceType);
        this.addComboBox.addItem(SharedInterfacePrologixUSB.interfaceType);
        this.addComboBox.addItem(SharedInterfacePrologixEthernet.interfaceType);
        this.addComboBox.addItem(SharedInterfaceNSGPIB232CT.interfaceType);
        if (Support.devlop) {
            this.addComboBox.addItem(SharedInterface.interfaceType);
        }
        this.addComboBox.setToolTipText("Select GPIB controller type, then press Add");
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 1;
        c.anchor = 17;
        c.insets = new Insets(5, 5, 5, 5);
        c.weightx = 0.0;
        c.weighty = 1.0;
        panel.add(this.addComboBox, c);
        FontAdjust.FontButton addButton = new FontAdjust.FontButton("Add");
        addButton.addActionListener(this);
        addButton.setActionCommand("Add");
        addButton.setToolTipText("Select GPIB controller type, then press Add");
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 1;
        c.anchor = 17;
        c.insets = new Insets(5, 5, 5, 5);
        c.weightx = 0.0;
        c.weighty = 1.0;
        panel.add((Component)addButton, c);
        FontAdjust.FontButton removeButton = new FontAdjust.FontButton("Remove");
        removeButton.addActionListener(this);
        removeButton.setActionCommand("Remove");
        removeButton.setToolTipText("Press to remove all marked GPIB controllers");
        c = new GridBagConstraints();
        c.gridx = 2;
        c.gridy = 1;
        c.anchor = 17;
        c.insets = new Insets(5, 5, 5, 5);
        c.weightx = 1.0;
        c.weighty = 1.0;
        panel.add((Component)removeButton, c);
        this.add(panel);
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        if (arg0.getActionCommand().equals("Add")) {
            InterfaceThreads.sharedInterfaceList.addGPIBInterface((String)this.addComboBox.getSelectedItem());
            InterfaceThreads.sharedInterfaceList.saveDefault();
        } else if (arg0.getActionCommand().equals("Remove")) {
            ArrayList<Integer> toRemove = new ArrayList<Integer>();
            int i = this.table.getRowCount() - 1;
            while (i >= 0) {
                if (this.table.isRowSelected(i)) {
                    toRemove.add(i);
                }
                --i;
            }
            if (toRemove.size() <= 1 || JOptionPane.showConfirmDialog(this, "Confirm", "Remove all marked interfaces", 0) == 0) {
                Iterator iterator = toRemove.iterator();
                while (iterator.hasNext()) {
                    i = (Integer)iterator.next();
                    InterfaceThreads.sharedInterfaceList.remove(i);
                }
            }
            this.table.clearSelection();
            InterfaceThreads.sharedInterfaceList.saveDefault();
        }
    }
}

