/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.main;

import dk.hkj.database.Header;
import dk.hkj.main.FFTChart;
import dk.hkj.main.FontAdjust;
import dk.hkj.main.InterfaceThreads;
import dk.hkj.main.PopupBaseFrame;
import dk.hkj.main.PopupNotes;
import dk.hkj.main.Support;
import dk.hkj.util.StringUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.Timer;

public class PopupFFTView
extends PopupBaseFrame
implements ActionListener,
FocusListener {
    private static PopupFFTView popupFFTView = null;
    private JComboBox<String> channelComboBox = null;
    private JComboBox<String> yAxisComboBox = null;
    private JComboBox<String> xAxisComboBox = null;
    private JComboBox<String> windowFunctionComboBox = null;
    private JTextField minFreqTextField = null;
    private JTextField maxFreqTextField = null;
    private JButton saveButton = null;
    private FFTChart fftChart = null;
    private Timer timer = null;
    private String currentChannel = null;
    private String lastChannel = null;

    public PopupFFTView() {
        PopupFFTView.closeAll();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                if (PopupFFTView.this.timer != null) {
                    PopupFFTView.this.timer.stop();
                    PopupFFTView.this.timer = null;
                }
                PopupFFTView.this.fftChart.destroy();
                PopupFFTView.popupFFTView = null;
            }
        });
        this.setPreferredSize(new Dimension(800, 500));
        this.setSize(new Dimension(800, 500));
        this.setTitle("FFT View");
        this.setDefaultCloseOperation(2);
        this.definePopupName("FFTView", true);
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = null;
        this.fftChart = new FFTChart();
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 2;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        c.anchor = 11;
        this.add((Component)this.fftChart.getPanel(), c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.fill = 2;
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        this.add((Component)panel, c);
        this.channelComboBox = new FontAdjust.FontComboBox<String>();
        this.channelComboBox.setMaximumRowCount(20);
        int n = 0;
        this.channelComboBox.setActionCommand("column");
        this.channelComboBox.addActionListener(this);
        this.channelComboBox.setToolTipText("Channel to analyze");
        c = new GridBagConstraints();
        c.gridx = n++;
        c.gridy = 0;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.anchor = 17;
        c.insets = new Insets(5, 5, 5, 5);
        panel.add(this.channelComboBox, c);
        c = new GridBagConstraints();
        c.gridx = n++;
        c.gridy = 0;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.anchor = 13;
        c.insets = new Insets(5, 5, 5, 2);
        panel.add((Component)new FontAdjust.FontLabel("Min freq:"), c);
        this.minFreqTextField = new FontAdjust.FontTextField(6);
        this.minFreqTextField.setActionCommand("Freq");
        this.minFreqTextField.addActionListener(this);
        this.minFreqTextField.setToolTipText("Starting frequency");
        this.minFreqTextField.addFocusListener(this);
        this.minFreqTextField.setMinimumSize(new Dimension(50, 20));
        c = new GridBagConstraints();
        c.gridx = n++;
        c.gridy = 0;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.anchor = 17;
        c.insets = new Insets(5, 2, 5, 5);
        panel.add((Component)this.minFreqTextField, c);
        c = new GridBagConstraints();
        c.gridx = n++;
        c.gridy = 0;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.anchor = 13;
        c.insets = new Insets(5, 5, 5, 2);
        panel.add((Component)new FontAdjust.FontLabel("Max freq:"), c);
        this.maxFreqTextField = new FontAdjust.FontTextField(6);
        this.maxFreqTextField.setActionCommand("Freq");
        this.maxFreqTextField.addActionListener(this);
        this.maxFreqTextField.setToolTipText("Ending frequency");
        this.maxFreqTextField.addFocusListener(this);
        this.maxFreqTextField.setMinimumSize(new Dimension(50, 20));
        c = new GridBagConstraints();
        c.gridx = n++;
        c.gridy = 0;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.anchor = 17;
        c.insets = new Insets(5, 2, 5, 5);
        panel.add((Component)this.maxFreqTextField, c);
        c = new GridBagConstraints();
        c.gridx = n++;
        c.gridy = 0;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.anchor = 13;
        c.insets = new Insets(5, 5, 5, 2);
        panel.add((Component)new FontAdjust.FontLabel("Y:"), c);
        this.yAxisComboBox = new FontAdjust.FontComboBox<String>();
        for (String s : FFTChart.getAmpFormats()) {
            this.yAxisComboBox.addItem(s);
        }
        this.yAxisComboBox.setActionCommand("yAxis");
        this.yAxisComboBox.addActionListener(this);
        this.yAxisComboBox.setToolTipText("Amplitude scale: lin/log/rms/peak/dB");
        c = new GridBagConstraints();
        c.gridx = n++;
        c.gridy = 0;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.anchor = 17;
        c.insets = new Insets(5, 2, 5, 5);
        panel.add(this.yAxisComboBox, c);
        c = new GridBagConstraints();
        c.gridx = n++;
        c.gridy = 0;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.anchor = 13;
        c.insets = new Insets(5, 5, 5, 2);
        panel.add((Component)new FontAdjust.FontLabel("X:"), c);
        this.xAxisComboBox = new FontAdjust.FontComboBox<String>();
        for (String s : FFTChart.getFreqFormats()) {
            this.xAxisComboBox.addItem(s);
        }
        this.xAxisComboBox.setActionCommand("xAxis");
        this.xAxisComboBox.addActionListener(this);
        this.xAxisComboBox.setToolTipText("Frequency scale: lin/log/Hz/minute/hour/day");
        c = new GridBagConstraints();
        c.gridx = n++;
        c.gridy = 0;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.anchor = 17;
        c.insets = new Insets(5, 2, 5, 5);
        panel.add(this.xAxisComboBox, c);
        this.windowFunctionComboBox = new FontAdjust.FontComboBox<String>();
        for (String s : FFTChart.getWindowFunctions()) {
            this.windowFunctionComboBox.addItem(s);
        }
        this.windowFunctionComboBox.setActionCommand("WF");
        this.windowFunctionComboBox.addActionListener(this);
        this.windowFunctionComboBox.setToolTipText("Windowing function");
        c = new GridBagConstraints();
        c.gridx = n++;
        c.gridy = 0;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.anchor = 17;
        c.insets = new Insets(5, 2, 5, 5);
        panel.add(this.windowFunctionComboBox, c);
        this.saveButton = new FontAdjust.FontButton("Save");
        this.saveButton.setActionCommand("Save");
        this.saveButton.addActionListener(this);
        this.saveButton.setToolTipText("Save the FFT chart to disk");
        c = new GridBagConstraints();
        c.gridx = n++;
        c.gridy = 0;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.anchor = 13;
        c.insets = new Insets(5, 5, 5, 5);
        panel.add((Component)this.saveButton, c);
        JPopupMenu menu = new JPopupMenu();
        JMenuItem mi = new FontAdjust.FontMenuItem("Zoom in");
        mi.setActionCommand("zi");
        mi.addActionListener(this);
        menu.add(mi);
        mi = new FontAdjust.FontMenuItem("Zoom out");
        mi.setActionCommand("zo");
        mi.addActionListener(this);
        menu.add(mi);
        mi = new FontAdjust.FontMenuItem("Zoom all");
        mi.setActionCommand("za");
        mi.addActionListener(this);
        menu.add(mi);
        mi = new FontAdjust.FontMenuItem("Copy");
        mi.setActionCommand("copy");
        mi.addActionListener(this);
        menu.add(mi);
        mi = new FontAdjust.FontMenuItem("Harmonics");
        mi.setActionCommand("list");
        mi.addActionListener(this);
        menu.add(mi);
        mi = new FontAdjust.FontCheckBoxMenuItem("Snap to peak");
        mi.setActionCommand("snap");
        mi.addActionListener(this);
        menu.add(mi);
        this.fftChart.getPanel().setPopupMenu(menu);
        this.fillChannelComboBox();
        this.lastChannel = this.currentChannel;
        this.fftChart.setChannel(this.currentChannel);
        this.setControls();
        this.refresh();
        this.timer = new Timer(500, this);
        this.timer.setActionCommand("Timer");
        this.timer.start();
    }

    public void setChannel(String channel) {
        if (channel == null || channel.equals("-")) {
            return;
        }
        this.currentChannel = channel;
        if (this.currentChannel != null && !this.currentChannel.isEmpty()) {
            this.lastChannel = this.currentChannel;
        }
        this.fftChart.setChannel(this.currentChannel);
        this.refresh();
        this.fftChart.setupFormat();
    }

    public void setFreq(double f1, double f2) {
        this.fftChart.setMinFreq(f1);
        this.fftChart.setMaxFreq(f2);
        this.fftChart.setupFormat();
        this.refresh();
    }

    public void setOption(String option) {
        this.fftChart.setOption(option);
    }

    public void refresh() {
        if (this.currentChannel == null || this.currentChannel.isEmpty() || Support.dataBase.rows() < 4) {
            return;
        }
        double[] data = Support.dataBase.getColumn(this.currentChannel);
        int timeColumn = Support.dataBase.header().getTimeColumn();
        double periodeTime = 0.0;
        if (timeColumn >= 0) {
            periodeTime = Support.dataBase.getValue(data.length - 1, timeColumn) - Support.dataBase.getValue(0, timeColumn);
        }
        this.fftChart.refresh(periodeTime, data);
    }

    public static synchronized void closeAll() {
        if (popupFFTView != null) {
            popupFFTView.setVisible(false);
            PopupFFTView.popupFFTView.fftChart.destroy();
            popupFFTView = null;
        }
    }

    public static PopupFFTView getPopup() {
        if (popupFFTView != null) {
            popupFFTView.requestFocus();
            return popupFFTView;
        }
        popupFFTView = new PopupFFTView();
        Point p = Support.paneCommand.popupsButton.getLocationOnScreen();
        p.translate(-750, -500);
        if (p.y < 0) {
            p.y = 0;
        }
        if (p.x < 0) {
            p.x = 0;
        }
        popupFFTView.setLocation(p);
        popupFFTView.setVisible(true);
        return popupFFTView;
    }

    private void enableControls(boolean enable) {
        this.channelComboBox.setEnabled(enable);
        this.yAxisComboBox.setEnabled(enable);
        this.xAxisComboBox.setEnabled(enable);
        this.windowFunctionComboBox.setEnabled(enable);
        this.minFreqTextField.setEnabled(enable);
        this.maxFreqTextField.setEnabled(enable);
        this.saveButton.setEnabled(enable);
    }

    public void fillChannelComboBox() {
        this.fftChart.cursorOff();
        this.channelComboBox.setActionCommand("");
        this.channelComboBox.removeAllItems();
        int n = -1;
        for (String s : Support.dataBase.header().getColumnsList()) {
            if (Header.isExcludeColumn(s)) continue;
            this.channelComboBox.addItem(s);
            if (!s.equals(this.lastChannel)) continue;
            n = this.channelComboBox.getItemCount() - 1;
        }
        if (n >= 0) {
            this.channelComboBox.setSelectedIndex(n);
        }
        this.currentChannel = (String)this.channelComboBox.getSelectedItem();
        this.channelComboBox.setActionCommand("column");
        this.enableControls(this.channelComboBox.getItemCount() > 0);
    }

    private void parseFreq() {
        String s;
        this.minFreqTextField.setBackground(Support.colorScheme.textBackground);
        double v = 0.0;
        try {
            s = this.minFreqTextField.getText().trim();
            if (s != null && !s.isEmpty() && (Double.isNaN(v = StringUtil.parseDoubleEE(s)) || v < 0.0)) {
                this.minFreqTextField.setBackground(Support.colorScheme.errorBackground);
                v = 0.0;
            }
        }
        catch (Exception exception) {
            this.minFreqTextField.setBackground(Support.colorScheme.errorBackground);
        }
        this.fftChart.setMinFreq(v);
        this.maxFreqTextField.setBackground(Support.colorScheme.textBackground);
        v = 1.0E101;
        try {
            s = this.maxFreqTextField.getText().trim();
            if (s != null && !s.isEmpty() && (Double.isNaN(v = StringUtil.parseDoubleEE(s)) || v < 0.0)) {
                this.maxFreqTextField.setBackground(Support.colorScheme.errorBackground);
                v = 1.0E101;
            }
        }
        catch (Exception exception) {
            this.maxFreqTextField.setBackground(Support.colorScheme.errorBackground);
        }
        this.fftChart.setMaxFreq(v);
        this.fftChart.setupFormat();
        this.refresh();
    }

    @Override
    public void focusGained(FocusEvent arg0) {
    }

    @Override
    public void focusLost(FocusEvent arg0) {
        this.parseFreq();
    }

    public void setControls() {
        this.channelComboBox.setSelectedItem(this.currentChannel);
        this.yAxisComboBox.setSelectedItem(this.fftChart.getAmpFormat().name());
        this.xAxisComboBox.setSelectedItem(this.fftChart.getFreqFormat().name());
        this.windowFunctionComboBox.setSelectedItem(this.fftChart.getWindowFunction().name());
        double f = this.fftChart.getMinFreq();
        this.minFreqTextField.setText(f == 0.0 ? "" : StringUtil.formatDoubleEE(f));
        f = this.fftChart.getMaxFreq();
        this.maxFreqTextField.setText(f > 1.0E100 ? "" : StringUtil.formatDoubleEE(f));
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        if (arg0.getActionCommand().equals("column")) {
            this.setChannel((String)this.channelComboBox.getSelectedItem());
        } else if (arg0.getActionCommand().equals("yAxis")) {
            String s = (String)this.yAxisComboBox.getSelectedItem();
            this.fftChart.setAmpFormat(s);
            this.fftChart.setupFormat();
            this.refresh();
        } else if (arg0.getActionCommand().equals("xAxis")) {
            String s = (String)this.xAxisComboBox.getSelectedItem();
            this.fftChart.setFreqFormat(s);
            this.fftChart.setupFormat();
            this.setControls();
            this.refresh();
        } else if (arg0.getActionCommand().equals("WF")) {
            String s = (String)this.windowFunctionComboBox.getSelectedItem();
            this.fftChart.setWindowFunction(s);
            this.fftChart.setupFormat();
            this.setControls();
            this.refresh();
        } else if (arg0.getActionCommand().equals("Timer")) {
            if (InterfaceThreads.isLogging()) {
                this.refresh();
            }
        } else if (arg0.getActionCommand().equals("Freq")) {
            this.parseFreq();
        } else if (arg0.getActionCommand().equals("Save")) {
            this.fftChart.saveChart();
        } else if (arg0.getActionCommand().equals("zi")) {
            this.minFreqTextField.setText(StringUtil.formatDoubleEE(this.fftChart.zoomInMin()));
            this.maxFreqTextField.setText(StringUtil.formatDoubleEE(this.fftChart.zoomInMax()));
            this.parseFreq();
        } else if (arg0.getActionCommand().equals("zo")) {
            this.minFreqTextField.setText(StringUtil.formatDoubleEE(this.fftChart.zoomOutMin()));
            this.maxFreqTextField.setText(StringUtil.formatDoubleEE(this.fftChart.zoomOutMax()));
            this.parseFreq();
        } else if (arg0.getActionCommand().equals("za")) {
            this.minFreqTextField.setText("");
            this.maxFreqTextField.setText("");
            this.parseFreq();
        } else if (arg0.getActionCommand().equals("copy")) {
            this.fftChart.copyChart(Support.systemSettings.imageResolution[0].width, Support.systemSettings.imageResolution[0].height);
        } else if (arg0.getActionCommand().equals("list")) {
            List<String> list = this.fftChart.listPeaks();
            PopupNotes notes = new PopupNotes("Harmonics", list);
            notes.setLocationRelativeTo(this);
            notes.setVisible(true);
        } else if (arg0.getActionCommand().equals("snap")) {
            boolean snap = ((JCheckBoxMenuItem)arg0.getSource()).getState();
            this.fftChart.setSnap(snap);
        }
    }

    public static List<String> generateScript() {
        ArrayList<String> list = new ArrayList<String>();
        if (popupFFTView != null) {
            list.add("#ShowPopupSystem FFTView " + popupFFTView.generateLocationParams());
            StringBuilder sb = new StringBuilder();
            sb.append("#FFTView ");
            sb.append(PopupFFTView.popupFFTView.currentChannel);
            sb.append(' ');
            double v = PopupFFTView.popupFFTView.fftChart.getMinFreq();
            if (v == 0.0) {
                sb.append('-');
            } else {
                sb.append(StringUtil.formatDoubleEE(v));
            }
            sb.append(' ');
            v = PopupFFTView.popupFFTView.fftChart.getMaxFreq();
            if (v > 1.0E100) {
                sb.append('-');
            } else {
                sb.append(StringUtil.formatDoubleEE(v));
            }
            sb.append(' ');
            sb.append(PopupFFTView.popupFFTView.fftChart.getAmpFormat().name());
            sb.append(' ');
            sb.append(PopupFFTView.popupFFTView.fftChart.getFreqFormat().name());
            sb.append(' ');
            sb.append(PopupFFTView.popupFFTView.fftChart.getWindowFunction().name());
            list.add(sb.toString());
        }
        return list;
    }

    public static void databaseModified() {
        if (popupFFTView != null) {
            popupFFTView.fillChannelComboBox();
            popupFFTView.refresh();
        }
    }

    public static void alignGridAll(int pixels) {
        if (popupFFTView != null) {
            popupFFTView.alignGrid(pixels);
        }
    }
}

