/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.main;

import dk.hkj.database.DataBase;
import dk.hkj.database.Exporter;
import dk.hkj.main.FontAdjust;
import dk.hkj.main.InterfaceThreads;
import dk.hkj.main.PopupBase;
import dk.hkj.main.Support;
import dk.hkj.util.StringUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.table.TableCellRenderer;

public class PopupExport
extends PopupBase
implements ActionListener,
FocusListener {
    private static final long serialVersionUID = 1L;
    private JTable table = null;
    private JScrollPane scrollPane = null;
    private JTextField firstTextField = null;
    private JTextField lastTextField = null;
    private JTextField reduceTextField = null;
    private JTextField changeTextField = null;
    private JTextField formulaTextField = null;
    private JComboBox<String> changeColumnComboBox = null;
    private JLabel reduceLabel = null;
    private JLabel timeLabel = null;
    private JLabel samplesLabel = null;
    private JComboBox<String> reduceComboBox = null;
    private boolean disableParse = false;
    private JButton saveButton = null;
    private JButton loadButton = null;
    private JButton exportButton = null;
    private JButton toTableButton = null;
    private boolean isTimeBased = false;
    private int domainColumn = -1;
    private String sdfHelp = "y: Year\nM: Month\nd: Day in month\nE: Day name in week\na: Am/pm marker\nH: Hour in day (0-23)\nK: Hour in am/pm (0-11)\nh: Hour in am/pm (1-12)\nm: Minute in hour\ns: Second in minute\nS: Millisecond\nSee Java SimpleDateFormat for more explanation";
    private String numberHelp = "0: Digit\n#: Optional digit\n-: Minus sign\n&: Show as percent\nSee Java DecimalFormat for more explanation";

    PopupExport() {
        this.setTitle("Export table");
        this.domainColumn = Support.dataBase.header().getDomainColumn();
        this.isTimeBased = Support.dataBase.header().isTimeColumn(this.domainColumn);
        this.definePopupName("Export", true);
        this.add(this.makePanel());
        this.pack();
        this.setModal(true);
        this.parseFields();
    }

    public JPanel makePanel() {
        FontAdjust.FontPanel mainPanel = new FontAdjust.FontPanel();
        mainPanel.setScaleWidth(690);
        mainPanel.setScaleHeight(400);
        mainPanel.setLayout(new GridBagLayout());
        Dimension minDim = new Dimension(60, 25);
        this.table = new FontAdjust.FontTable(){

            @Override
            public Component prepareRenderer(TableCellRenderer renderer, int row, int col) {
                Component comp = super.prepareRenderer(renderer, row, col);
                if (!comp.getBackground().equals(Support.colorScheme.selectedCellbackground)) {
                    comp.setBackground(row % 4 == 0 ? Support.colorScheme.tableGridAlternateBackground : Support.colorScheme.textBackground);
                }
                if (comp instanceof JLabel) {
                    JLabel label = (JLabel)comp;
                    if (col == 0 || col == 2 || col == 4) {
                        label.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 0));
                        label.setHorizontalAlignment(2);
                    } else {
                        label.setHorizontalAlignment(0);
                    }
                }
                return comp;
            }

            @Override
            public String getToolTipText(MouseEvent e) {
                String tip = null;
                Point p = e.getPoint();
                int row = this.rowAtPoint(p);
                int column = this.columnAtPoint(p);
                try {
                    Exporter.ColumnExport ce = Exporter.getExporter().get(row);
                    switch (this.columnModel.getColumn(column).getModelIndex()) {
                        case 3: {
                            break;
                        }
                        case 4: {
                            if (!ce.getFormat().equals((Object)Exporter.ExportFormat.Custom)) break;
                            if (ce.isDateTime()) {
                                tip = "<html>" + PopupExport.this.sdfHelp.replace("\n", "<br>") + "</html>";
                                break;
                            }
                            tip = "<html>" + PopupExport.this.numberHelp.replace("\n", "<br>") + "</html>";
                        }
                        default: {
                            break;
                        }
                    }
                }
                catch (RuntimeException runtimeException) {}
                return tip != null && tip.length() > 0 ? tip : null;
            }
        };
        this.table.setColumnModel(new Support.WidthTableColumnModel(new int[]{200, 60, 200, 100, 100}));
        this.table.setModel(Exporter.getExporter());
        this.table.setDefaultEditor(String.class, new Support.AutoSelectCellEditor());
        this.table.setDefaultEditor(Integer.class, new Support.AutoSelectCellEditor());
        this.table.setDefaultEditor(JComboBox.class, new FormatCellEditor());
        this.table.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.isControlDown() && !e.isAltDown() && !e.isShiftDown()) {
                    ListSelectionModel lsm = PopupExport.this.table.getSelectionModel();
                    if (e.getKeyCode() == 38 && lsm.getMinSelectionIndex() >= 0) {
                        if (PopupExport.this.table.isRowSelected(0)) {
                            return;
                        }
                        int i = 0;
                        while (i < PopupExport.this.table.getRowCount()) {
                            if (PopupExport.this.table.isRowSelected(i)) {
                                Exporter.getExporter().moveUp(i);
                                lsm.removeSelectionInterval(i, i);
                                lsm.addSelectionInterval(i - 1, i - 1);
                            }
                            ++i;
                        }
                        Exporter.getExporter().changeNotification();
                    } else if (e.getKeyCode() == 40 && lsm.getMaxSelectionIndex() < PopupExport.this.table.getRowCount() - 1) {
                        if (PopupExport.this.table.isRowSelected(PopupExport.this.table.getRowCount() - 1)) {
                            return;
                        }
                        int i = PopupExport.this.table.getRowCount() - 1;
                        while (i >= 0) {
                            if (PopupExport.this.table.isRowSelected(i)) {
                                Exporter.getExporter().moveDown(i);
                                lsm.removeSelectionInterval(i, i);
                                lsm.addSelectionInterval(i + 1, i + 1);
                            }
                            --i;
                        }
                        Exporter.getExporter().changeNotification();
                    }
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }
        });
        Support.dataBase.getTableDataModel().setTable(this.table);
        this.scrollPane = new JScrollPane(this.table);
        this.table.setAutoResizeMode(0);
        String tt = "<html>Use Ctrl-Up/Down to move selected rows around.<br>Index, dataTime and digital columns have special formats.<br><br>Columns with changed format may not be possible to load into TestController.<br>Renamed columns may loose formatting information if loaded into TestController again.</html>";
        this.table.setToolTipText(tt);
        this.scrollPane.setToolTipText(tt);
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 5;
        c.fill = 1;
        c.weightx = 10.0;
        c.weighty = 10.0;
        c.insets = new Insets(2, 2, 2, 2);
        mainPanel.add((Component)this.scrollPane, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 1;
        c.anchor = 13;
        c.insets = new Insets(2, 2, 2, 2);
        c.weightx = 1.0;
        mainPanel.add((Component)new FontAdjust.FontLabel("First sample to export: "), c);
        this.firstTextField = new FontAdjust.FontTextField(6);
        this.firstTextField.addActionListener(this);
        this.firstTextField.addFocusListener(this);
        this.firstTextField.setMinimumSize(minDim);
        this.firstTextField.setToolTipText("<html>Formats supported:<br>Empty: All data<br>seconds from start<br>h:m:s hour minutes seconds<br>postfix with h/m for hours/minutes<br>#sampleNumber<br>Prefix with - means from end of data<br>Prefix with w for width/lenght of data, only in last field");
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 1;
        c.anchor = 17;
        c.insets = new Insets(2, 2, 2, 2);
        c.weightx = 1.0;
        c.fill = 1;
        mainPanel.add((Component)this.firstTextField, c);
        c = new GridBagConstraints();
        c.gridx = 2;
        c.gridy = 1;
        c.anchor = 13;
        c.insets = new Insets(2, 2, 2, 2);
        c.weightx = 1.0;
        mainPanel.add((Component)new FontAdjust.FontLabel("Last sample to export: "), c);
        this.lastTextField = new FontAdjust.FontTextField(6);
        this.lastTextField.addActionListener(this);
        this.lastTextField.addFocusListener(this);
        this.lastTextField.setMinimumSize(minDim);
        this.lastTextField.setToolTipText("<html>Formats supported:<br>Empty: All data<br>seconds from start<br>h:m:s hour minutes seconds<br>postfix with h/m for hours/minutes<br>#sampleNumber<br>Prefix with - means from end of data<br>Prefix with w for width/lenght of data, only in last field");
        c = new GridBagConstraints();
        c.gridx = 3;
        c.gridy = 1;
        c.insets = new Insets(2, 2, 2, 2);
        c.anchor = 17;
        c.weightx = 1.0;
        c.fill = 1;
        mainPanel.add((Component)this.lastTextField, c);
        this.timeLabel = new FontAdjust.FontLabel("Time: " + Support.showPeriod(Exporter.getExporter().getActualTime()));
        this.timeLabel.setToolTipText("Time from first selected sample to last selected sample");
        c = new GridBagConstraints();
        c.gridx = 4;
        c.gridy = 1;
        c.insets = new Insets(2, 2, 2, 2);
        c.anchor = 10;
        c.weightx = 1.0;
        mainPanel.add((Component)this.timeLabel, c);
        this.reduceComboBox = new FontAdjust.FontComboBox<String>();
        this.reduceComboBox.addActionListener(this);
        Exporter.ReduceFormat[] reduceFormatArray = Exporter.ReduceFormat.values();
        int n = reduceFormatArray.length;
        int n2 = 0;
        while (n2 < n) {
            Exporter.ReduceFormat rf = reduceFormatArray[n2];
            this.reduceComboBox.addItem(rf.name());
            ++n2;
        }
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 2;
        c.insets = new Insets(2, 2, 2, 2);
        c.anchor = 17;
        c.weightx = 1.0;
        mainPanel.add(this.reduceComboBox, c);
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 2;
        c.insets = new Insets(2, 2, 2, 2);
        c.anchor = 13;
        c.weightx = 1.0;
        this.reduceLabel = new FontAdjust.FontLabel("Reduce to samples: ");
        mainPanel.add((Component)this.reduceLabel, c);
        this.changeColumnComboBox = new FontAdjust.FontComboBox<String>();
        this.changeColumnComboBox.setVisible(false);
        for (String s : Support.dataBase.header().getDataColumnsList()) {
            this.changeColumnComboBox.addItem(s);
        }
        this.changeColumnComboBox.addActionListener(this);
        this.changeColumnComboBox.setMinimumSize(new Dimension(150, 25));
        mainPanel.add(this.changeColumnComboBox, c);
        this.reduceTextField = new FontAdjust.FontTextField(6);
        this.reduceTextField.addActionListener(this);
        this.reduceTextField.addFocusListener(this);
        this.reduceTextField.setMinimumSize(minDim);
        this.reduceTextField.setToolTipText("Minimum change from last saved row, before a new row is saved (Sign is ignored)");
        this.changeTextField = new FontAdjust.FontTextField(6);
        this.changeTextField.addActionListener(this);
        this.changeTextField.addFocusListener(this);
        this.changeTextField.setMinimumSize(minDim);
        this.changeTextField.setVisible(false);
        this.formulaTextField = new FontAdjust.FontTextField(10);
        this.formulaTextField.addActionListener(this);
        this.formulaTextField.addFocusListener(this);
        this.formulaTextField.setMinimumSize(minDim);
        this.formulaTextField.setVisible(false);
        this.formulaTextField.setToolTipText("Use names from \"Column\" and < = > || && operators to make a formula");
        c = new GridBagConstraints();
        c.gridx = 2;
        c.gridy = 2;
        c.fill = 1;
        c.insets = new Insets(2, 2, 2, 2);
        c.anchor = 17;
        c.weightx = 1.0;
        mainPanel.add((Component)this.reduceTextField, c);
        mainPanel.add((Component)this.changeTextField, c);
        c.gridx = 1;
        c.gridwidth = 3;
        mainPanel.add((Component)this.formulaTextField, c);
        this.samplesLabel = new FontAdjust.FontLabel("Samples: " + Exporter.getExporter().getActualSamples());
        this.samplesLabel.setToolTipText("Actual number of samples to export after reduction");
        this.formulaTextField.setBackground(Exporter.getExporter().isFormulaError() ? Support.colorScheme.errorBackground : Support.colorScheme.textBackground);
        c = new GridBagConstraints();
        c.gridx = 4;
        c.gridy = 2;
        c.insets = new Insets(2, 2, 2, 2);
        c.anchor = 10;
        c.weightx = 1.0;
        mainPanel.add((Component)this.samplesLabel, c);
        this.loadButton = new FontAdjust.FontButton("Load format");
        this.loadButton.setActionCommand("Load");
        this.loadButton.addActionListener(this);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 3;
        c.fill = 1;
        c.insets = new Insets(2, 2, 2, 2);
        mainPanel.add((Component)this.loadButton, c);
        this.saveButton = new FontAdjust.FontButton("Save format");
        this.saveButton.setActionCommand("Save");
        this.saveButton.addActionListener(this);
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 3;
        c.fill = 1;
        c.insets = new Insets(2, 2, 2, 2);
        mainPanel.add((Component)this.saveButton, c);
        this.toTableButton = new FontAdjust.FontButton("To table");
        this.toTableButton.setActionCommand("ToTable");
        this.toTableButton.setToolTipText("Save and reload data, this is used to reduce data");
        this.toTableButton.addActionListener(this);
        c = new GridBagConstraints();
        c.gridx = 3;
        c.gridy = 3;
        c.fill = 1;
        c.insets = new Insets(2, 2, 2, 2);
        mainPanel.add((Component)this.toTableButton, c);
        this.exportButton = new FontAdjust.FontButton("Export data");
        this.exportButton.setActionCommand("Export");
        this.exportButton.addActionListener(this);
        c = new GridBagConstraints();
        c.gridx = 4;
        c.gridy = 3;
        c.fill = 1;
        c.insets = new Insets(2, 2, 2, 2);
        mainPanel.add((Component)this.exportButton, c);
        this.updateFields();
        return mainPanel;
    }

    public void setRange(String first, String last) {
        Exporter.getExporter().setRange(first, last);
        this.updateFields();
    }

    private void parseFields() {
        if (this.exportButton == null || this.disableParse) {
            return;
        }
        try {
            Exporter.getExporter().setRange(this.firstTextField.getText(), this.lastTextField.getText());
            this.firstTextField.setBackground(Support.colorScheme.textBackground);
            this.lastTextField.setBackground(Support.colorScheme.textBackground);
        }
        catch (Exception exception) {
            this.firstTextField.setBackground(Support.colorScheme.errorBackground);
            this.lastTextField.setBackground(Support.colorScheme.errorBackground);
        }
        String s = (String)this.reduceComboBox.getSelectedItem();
        Exporter.getExporter().setReduceFormat(s);
        if (s.equals(Exporter.ReduceFormat.AllData.name())) {
            this.changeColumnComboBox.setVisible(false);
            this.changeTextField.setVisible(false);
            this.formulaTextField.setVisible(false);
            this.reduceLabel.setVisible(false);
            this.reduceTextField.setVisible(false);
            this.reduceTextField.setBackground(Support.colorScheme.textBackground);
        } else if (s.equals(Exporter.ReduceFormat.ReduceOnChange.name())) {
            this.changeColumnComboBox.setVisible(true);
            this.changeTextField.setVisible(true);
            this.formulaTextField.setVisible(false);
            this.reduceLabel.setVisible(false);
            this.reduceTextField.setVisible(false);
            Exporter.getExporter().setChangeColumn((String)this.changeColumnComboBox.getSelectedItem());
            try {
                Exporter.getExporter().setChangeValue(StringUtil.parseDoubleEE(this.changeTextField.getText()));
                this.changeTextField.setBackground(Support.colorScheme.textBackground);
            }
            catch (Exception exception) {
                this.changeTextField.setBackground(Support.colorScheme.errorBackground);
            }
        } else if (s.equals(Exporter.ReduceFormat.ReduceByFormula.name())) {
            this.changeColumnComboBox.setVisible(false);
            this.changeTextField.setVisible(false);
            this.formulaTextField.setVisible(true);
            this.reduceLabel.setVisible(false);
            this.reduceTextField.setVisible(false);
            Exporter.getExporter().setFormula(this.formulaTextField.getText());
        } else {
            this.changeColumnComboBox.setVisible(false);
            this.changeTextField.setVisible(false);
            this.formulaTextField.setVisible(false);
            this.reduceLabel.setVisible(true);
            this.reduceTextField.setVisible(true);
            try {
                Exporter.getExporter().setSamples(StringUtil.parseInt(this.reduceTextField.getText()));
                this.reduceTextField.setBackground(Support.colorScheme.textBackground);
            }
            catch (Exception exception) {
                this.reduceTextField.setBackground(Support.colorScheme.errorBackground);
            }
        }
        int n = Exporter.getExporter().getActualSamples();
        this.timeLabel.setText("Time: " + Support.showPeriod(Exporter.getExporter().getActualTime()));
        this.samplesLabel.setText("Samples: " + n);
        this.formulaTextField.setBackground(Exporter.getExporter().isFormulaError() ? Support.colorScheme.errorBackground : Support.colorScheme.textBackground);
        this.exportButton.setEnabled(n > 0);
        this.toTableButton.setEnabled(Exporter.getExporter().canReload() && n > 0);
    }

    public void updateFields() {
        this.disableParse = true;
        this.firstTextField.setText(Exporter.getExporter().getFirstEntry());
        this.lastTextField.setText(Exporter.getExporter().getLastEntry());
        this.reduceTextField.setText(Integer.toString(Exporter.getExporter().getSamples()));
        this.reduceComboBox.setSelectedItem(Exporter.getExporter().getReduceFormat().name());
        this.changeColumnComboBox.setSelectedItem(Exporter.getExporter().getChangeColumn());
        this.changeTextField.setText(StringUtil.formatDoubleEE(Exporter.getExporter().getChangeValue()));
        this.formulaTextField.setText(Exporter.getExporter().getFormula());
        if (this.changeColumnComboBox.getSelectedItem() == null) {
            this.changeColumnComboBox.setSelectedIndex(0);
        }
        this.disableParse = false;
        this.parseFields();
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        if (arg0.getActionCommand().equals("Export")) {
            this.exportData();
        } else if (arg0.getActionCommand().equals("ToTable")) {
            this.exportToTable();
        } else if (arg0.getActionCommand().equals("Load")) {
            this.loadFormat();
        } else if (arg0.getActionCommand().equals("Save")) {
            this.saveFormat();
        } else {
            this.parseFields();
        }
    }

    @Override
    public void focusGained(FocusEvent arg0) {
    }

    @Override
    public void focusLost(FocusEvent arg0) {
        this.parseFields();
    }

    private void exportToTable() {
        if (JOptionPane.showConfirmDialog(this, "Overwrite current table data with export processed data", "Confirm", 0) == 0) {
            Exporter.getExporter().exportReload();
            this.setVisible(false);
        }
    }

    private void exportData() {
        FontAdjust.FontFileChooser fileChooser = new FontAdjust.FontFileChooser();
        fileChooser.setDialogTitle("Export table");
        try {
            fileChooser.setCurrentDirectory(new File(Support.getDataPath()));
        }
        catch (Exception exception) {
            System.out.println("Failed to set director: " + Support.getDataPath());
        }
        DataBase.FileFormat ff = Support.dataBase.getFileFormat();
        FontAdjust.FontRadioButton formatTabRadioButton = null;
        FontAdjust.FontRadioButton formatCTabRadioButton = null;
        AbstractButton formatUsRadioButton = null;
        AbstractButton formatEuRadioButton = null;
        if (!InterfaceThreads.isLoggingToDisk()) {
            JPanel savePanel = new JPanel();
            BoxLayout bl = new BoxLayout(savePanel, 3);
            savePanel.setLayout(bl);
            ButtonGroup bg = new ButtonGroup();
            formatTabRadioButton = new FontAdjust.FontRadioButton("TAB format");
            bg.add(formatTabRadioButton);
            savePanel.add(formatTabRadioButton);
            formatCTabRadioButton = new FontAdjust.FontRadioButton("CTAB format");
            formatCTabRadioButton.setToolTipText("Use tab delimeter with comma as decimal point");
            bg.add(formatCTabRadioButton);
            savePanel.add(formatCTabRadioButton);
            formatUsRadioButton = new FontAdjust.FontRadioButton(". , format");
            bg.add(formatUsRadioButton);
            savePanel.add(formatUsRadioButton);
            formatEuRadioButton = new FontAdjust.FontRadioButton(", ; format");
            bg.add(formatEuRadioButton);
            savePanel.add(formatEuRadioButton);
            if (ff == DataBase.FileFormat.tab) {
                formatTabRadioButton.setSelected(true);
            } else if (ff == DataBase.FileFormat.ctab) {
                formatCTabRadioButton.setSelected(true);
            } else if (ff == DataBase.FileFormat.us) {
                formatUsRadioButton.setSelected(true);
            } else {
                formatEuRadioButton.setSelected(true);
            }
            fileChooser.setAccessory(savePanel);
        }
        fileChooser.setFileFilter(new FileNameExtensionFilter("CSV", "csv"));
        fileChooser.setAcceptAllFileFilterUsed(true);
        while (fileChooser.showSaveDialog(this.table) == 0) {
            int option = 0;
            File file = Support.fileWithOptinalDefaults(fileChooser.getSelectedFile().getAbsolutePath(), null, ".csv");
            if (file.exists() && (option = JOptionPane.showConfirmDialog(null, "File exists, overwrite?", "File exists", 1)) == 1) {
                return;
            }
            if (option != 0) continue;
            try {
                if (formatTabRadioButton != null) {
                    if (formatTabRadioButton.isSelected()) {
                        Support.dataBase.setFileFormat(DataBase.FileFormat.tab);
                    } else if (formatCTabRadioButton.isSelected()) {
                        Support.dataBase.setFileFormat(DataBase.FileFormat.ctab);
                    } else if (formatUsRadioButton.isSelected()) {
                        Support.dataBase.setFileFormat(DataBase.FileFormat.us);
                    } else if (formatEuRadioButton.isSelected()) {
                        Support.dataBase.setFileFormat(DataBase.FileFormat.euro);
                    }
                }
                Exporter.getExporter().export(file);
                Support.setDataPath(fileChooser.getCurrentDirectory().getPath());
                this.setVisible(false);
                return;
            }
            catch (IOException e) {
                e.printStackTrace(System.out);
            }
        }
    }

    private void saveFormat() {
        FontAdjust.FontFileChooser fileChooser = new FontAdjust.FontFileChooser();
        fileChooser.setDialogTitle("Save export format");
        try {
            fileChooser.setCurrentDirectory(new File(Support.getDataPath()));
        }
        catch (Exception exception) {
            System.out.println("Failed to set director: " + Support.getDataPath());
        }
        fileChooser.setFileFilter(new FileNameExtensionFilter("TXT", "txt"));
        fileChooser.setAcceptAllFileFilterUsed(true);
        while (fileChooser.showSaveDialog(this.table) == 0) {
            int option = 0;
            File file = fileChooser.getSelectedFile();
            if (!file.getName().contains(".")) {
                file = new File(String.valueOf(file.getPath()) + "ExportFormat.txt");
            }
            if (file.exists()) {
                option = JOptionPane.showConfirmDialog(null, "File exists, overwrite?", "File exists", 1);
            }
            if (option == 2) {
                return;
            }
            if (option != 0) continue;
            Exporter.getExporter().saveFormatToFile(file);
            Support.setDataPath(fileChooser.getCurrentDirectory().getPath());
            return;
        }
    }

    private void loadFormat() {
        FontAdjust.FontFileChooser fileChooser = new FontAdjust.FontFileChooser();
        fileChooser.setDialogTitle("Load export format");
        try {
            fileChooser.setCurrentDirectory(new File(Support.getDataPath()));
        }
        catch (Exception exception) {
            System.out.println("Failed to set director: " + Support.getDataPath());
        }
        fileChooser.setFileFilter(new FileNameExtensionFilter("TXT", "txt"));
        fileChooser.setAcceptAllFileFilterUsed(true);
        if (fileChooser.showOpenDialog(this.table) == 0) {
            File file = Support.fileWithOptinalDefaults(fileChooser.getSelectedFile().getAbsolutePath(), null, ".txt");
            Exporter.getExporter().loadFormatFromFile(file);
            this.updateFields();
            Support.setDataPath(fileChooser.getCurrentDirectory().getPath());
        }
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible && Exporter.getExporter() != null) {
            Exporter.getExporter().adjustColumns();
            this.updateFields();
            Exporter.getExporter().addChangeListener(new Exporter.ColumnChangeListener(){

                @Override
                public void update() {
                    PopupExport.this.toTableButton.setEnabled(Exporter.getExporter().canReload());
                }
            });
        }
        super.setVisible(visible);
    }

    public class FormatCellEditor
    extends DefaultCellEditor {
        public FormatCellEditor() {
            super(new FontAdjust.FontComboBox());
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            Component editor = super.getTableCellEditorComponent(table, value, isSelected, row, column);
            if (editor instanceof JComboBox) {
                JComboBox cb = (JComboBox)editor;
                Exporter.ColumnExport ce = Exporter.getExporter().get(row);
                cb.removeAllItems();
                cb.setMaximumRowCount(20);
                cb.addItem(Exporter.getExporter().getFormatName(Exporter.ExportFormat.Full));
                if (ce.isDateTime()) {
                    cb.addItem(Exporter.getExporter().getFormatName(Exporter.ExportFormat.Display));
                    cb.addItem(Exporter.getExporter().getFormatName(Exporter.ExportFormat.System));
                    cb.addItem(Exporter.getExporter().getFormatName(Exporter.ExportFormat.SystemShort));
                    cb.addItem(Exporter.getExporter().getFormatName(Exporter.ExportFormat.SystemLong));
                    cb.addItem(Exporter.getExporter().getFormatName(Exporter.ExportFormat.ymdhms));
                    cb.addItem(Exporter.getExporter().getFormatName(Exporter.ExportFormat.ymd_hms));
                    cb.addItem(Exporter.getExporter().getFormatName(Exporter.ExportFormat.hms));
                    cb.addItem(Exporter.getExporter().getFormatName(Exporter.ExportFormat.ymd));
                    cb.addItem(Exporter.getExporter().getFormatName(Exporter.ExportFormat.Split));
                    cb.addItem(Exporter.getExporter().getFormatName(Exporter.ExportFormat.SplitSystem));
                    cb.addItem(Exporter.getExporter().getFormatName(Exporter.ExportFormat.Custom));
                } else if (ce.isTime()) {
                    cb.addItem(Exporter.getExporter().getFormatName(Exporter.ExportFormat.Display));
                } else if (ce.isIndex()) {
                    cb.addItem(Exporter.getExporter().getFormatName(Exporter.ExportFormat.Reindex));
                } else {
                    cb.addItem(Exporter.getExporter().getFormatName(Exporter.ExportFormat.MinusFull));
                    cb.addItem(Exporter.getExporter().getFormatName(Exporter.ExportFormat.Display));
                    cb.addItem(Exporter.getExporter().getFormatName(Exporter.ExportFormat.Custom));
                    if (ce.isDigital()) {
                        cb.addItem(Exporter.getExporter().getFormatName(Exporter.ExportFormat.Split));
                    }
                }
                cb.setSelectedItem(value);
            }
            return editor;
        }
    }
}

