/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.main;

import dk.hkj.main.FontAdjust;
import dk.hkj.main.PopupBase;
import dk.hkj.main.ValueFormat;
import java.awt.Dialog;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class PopupCustomFormat
extends PopupBase
implements ActionListener {
    private JComboBox<String> typeComboBox;
    private JPanel digitsPanel;
    private JPanel siLimitsPanel;
    private int decimals = 0;
    private char minSI = (char)46;
    private String format = "";
    private boolean ok = false;
    private static final String typeFixed = "Fixed number of decimals";
    private static final String typeVar = "Maximum number of decimals";
    private static final String typeSiBasic = "SI";
    private static final String typeSiDigits = "SI with maximum digits";
    private static final String typeSiLimits = "SI with maximum digits and lower limit";
    private static final String typeInt = "Integer";
    private static final String typeDigital = "Digital bits";

    PopupCustomFormat(String columnName, ValueFormat.ValueFormatter vf) {
        this.setTitle("Value format for " + columnName);
        this.definePopupName("ValueFormat", false);
        String s = vf.toString();
        if (s.matches("D[0-9]")) {
            this.format = typeFixed;
            this.decimals = s.charAt(1) - 48;
        } else if (s.matches("X[0-9]")) {
            this.format = typeVar;
            this.decimals = s.charAt(1) - 48;
        } else if (s.matches("SI[3-9]")) {
            this.format = typeSiDigits;
            this.decimals = s.charAt(2) - 48;
        } else if (s.matches("SI[3-9][_munpfazy]")) {
            this.format = typeSiLimits;
            this.decimals = s.charAt(2) - 48;
            this.minSI = s.charAt(3);
        } else if (s.equalsIgnoreCase(typeSiBasic)) {
            this.format = typeSiBasic;
            this.decimals = -1;
        } else if (s.equalsIgnoreCase("INT")) {
            this.format = typeInt;
            this.decimals = -1;
        } else if (s.equalsIgnoreCase("DIGITAL")) {
            this.format = typeDigital;
            this.decimals = -1;
        }
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.setDefaultCloseOperation(2);
        this.add(this.makePanel());
        this.typeComboBox.setSelectedItem(this.format);
        this.updateLayout();
    }

    static ValueFormat.ValueFormatter show(Point location, String columnName, ValueFormat.ValueFormatter vf) {
        PopupCustomFormat pcf = new PopupCustomFormat(columnName, vf);
        pcf.setLocation(location);
        pcf.setVisible(true);
        System.out.println("Result: " + pcf.getFormatString());
        return pcf.ok ? ValueFormat.getFormatter(pcf.getFormatString()) : null;
    }

    private String getFormatString() {
        if (this.format.equalsIgnoreCase(typeFixed)) {
            if (this.decimals < 0) {
                this.decimals = 0;
            }
            return "D" + this.decimals;
        }
        if (this.format.equalsIgnoreCase(typeVar)) {
            if (this.decimals < 0) {
                this.decimals = 0;
            }
            return "X" + this.decimals;
        }
        if (this.format.equalsIgnoreCase(typeSiDigits)) {
            if (this.decimals < 3) {
                this.decimals = 3;
            }
            return typeSiBasic + this.decimals;
        }
        if (this.format.equalsIgnoreCase(typeSiLimits)) {
            if (this.decimals < 3) {
                this.decimals = 3;
            }
            return typeSiBasic + this.decimals + (this.minSI != '.' ? Character.valueOf(this.minSI) : "");
        }
        if (this.format.equalsIgnoreCase(typeSiBasic)) {
            return typeSiBasic;
        }
        if (this.format.equalsIgnoreCase(typeInt)) {
            return "INT";
        }
        return "D4";
    }

    private void updateLayout() {
        this.generateDecimals();
        this.generateSiLimits();
        this.pack();
    }

    private void generateDecimals() {
        this.digitsPanel.removeAll();
        if (!(this.format.equalsIgnoreCase(typeFixed) || this.format.equalsIgnoreCase(typeVar) || this.format.equalsIgnoreCase(typeSiDigits) || this.format.equalsIgnoreCase(typeSiLimits))) {
            return;
        }
        int start = 0;
        if (this.format.equalsIgnoreCase(typeSiDigits) || this.format.equalsIgnoreCase(typeSiLimits)) {
            this.digitsPanel.add(new JLabel("Digits:"));
            start = 3;
        } else {
            this.digitsPanel.add(new JLabel("Decimals:"));
        }
        ButtonGroup grp = new ButtonGroup();
        int i = start;
        while (i < 10) {
            FontAdjust.FontRadioButton rb = new FontAdjust.FontRadioButton(Integer.toString(i));
            if (i == this.decimals) {
                rb.setSelected(true);
            }
            rb.addActionListener(this);
            rb.setActionCommand("Dec:" + String.valueOf(i));
            grp.add(rb);
            this.digitsPanel.add(rb);
            ++i;
        }
    }

    private void generateSiLimits() {
        this.siLimitsPanel.removeAll();
        if (!this.format.equalsIgnoreCase(typeSiLimits)) {
            return;
        }
        this.siLimitsPanel.add(new FontAdjust.FontLabel("Min. SI:"));
        ButtonGroup grp = new ButtonGroup();
        char[] cArray = "_munpfazy".toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            FontAdjust.FontRadioButton rb = new FontAdjust.FontRadioButton(String.valueOf(c));
            if (c == this.minSI) {
                rb.setSelected(true);
            }
            rb.addActionListener(this);
            rb.setActionCommand("MinSI:" + String.valueOf(c));
            grp.add(rb);
            this.siLimitsPanel.add(rb);
            ++n2;
        }
    }

    JPanel makePanel() {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createEmptyBorder(2, 5, 2, 5));
        panel.setLayout(new BoxLayout(panel, 1));
        this.typeComboBox = new FontAdjust.FontComboBox<String>();
        this.typeComboBox.addItem(typeFixed);
        this.typeComboBox.addItem(typeVar);
        this.typeComboBox.addItem(typeSiBasic);
        this.typeComboBox.addItem(typeSiDigits);
        this.typeComboBox.addItem(typeSiLimits);
        this.typeComboBox.addItem(typeInt);
        this.typeComboBox.addActionListener(this);
        this.typeComboBox.setActionCommand("Type");
        panel.add(this.typeComboBox);
        this.digitsPanel = new JPanel();
        panel.add(this.digitsPanel);
        this.siLimitsPanel = new JPanel();
        panel.add(this.siLimitsPanel);
        FontAdjust.FontButton okButton = new FontAdjust.FontButton("Ok");
        okButton.addActionListener(this);
        okButton.setActionCommand("Ok");
        panel.add(okButton);
        return panel;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("Type")) {
            this.format = (String)this.typeComboBox.getSelectedItem();
            System.out.println(this.format);
            this.updateLayout();
        } else if (e.getActionCommand().startsWith("Dec:")) {
            this.decimals = e.getActionCommand().charAt(4) - 48;
        } else if (e.getActionCommand().startsWith("MinSI:")) {
            this.minSI = e.getActionCommand().charAt(6);
        } else if (e.getActionCommand().equals("Ok")) {
            this.ok = true;
            this.setVisible(false);
        }
    }
}

