/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.main;

import dk.hkj.color.ColorUtil;
import dk.hkj.main.ChartAnnotations;
import dk.hkj.main.ChartScales;
import dk.hkj.main.FontAdjust;
import dk.hkj.main.PopupBase;
import dk.hkj.main.Support;
import dk.hkj.main.ValueFormat;
import dk.hkj.util.MySwingUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultCellEditor;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

public class PopupChartLayout
extends PopupBase
implements ActionListener {
    private final int ColorPatchWidth = 30;
    private final int ColorPatchHeight = 20;
    private NamesTableModel namesTableModel = new NamesTableModel();
    private SyncTableModel syncTableModel = new SyncTableModel();
    private AnnoListModel annoListModel = null;
    private JList<String> dataList = null;
    private static PopupChartLayout popupChartLayout = null;
    private JButton chartColorButton = null;
    private JButton chartBorderColorButton = null;
    private JButton chartGridColorButton = null;
    private JButton chartFontColorButton = null;
    private JButton chartHeaderColorButton = null;
    private JButton chartDefaultColorButton = null;
    private JButton curveColorsButton = null;
    private JPanel editPanel = null;

    public PopupChartLayout() {
        PopupChartLayout.closeAll();
        this.setTitle("Chart layout");
        this.setDefaultCloseOperation(2);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent e) {
                if (popupChartLayout == PopupChartLayout.this) {
                    PopupChartLayout.popupChartLayout = null;
                }
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                if (popupChartLayout == PopupChartLayout.this) {
                    PopupChartLayout.popupChartLayout = null;
                }
            }
        });
        popupChartLayout = this;
        this.setPreferredSize(new Dimension(470, 310));
        this.definePopupName("PopupChartLayout", true);
        this.setOnTop(true);
        JTabbedPane tp = new JTabbedPane();
        this.add(tp);
        tp.add("Colors", this.makeColorPanel());
        tp.add("Names", this.makeNamePanel());
        tp.add("Sync", this.makeSyncPanel());
        tp.add("Annotations", this.makeAnnotatePanel());
        this.pack();
    }

    private JPanel makeNamePanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints c = null;
        FontAdjust.FontTable table = new FontAdjust.FontTable(){

            @Override
            public Component prepareRenderer(TableCellRenderer renderer, int row, int col) {
                Component comp = super.prepareRenderer(renderer, row, col);
                if (!comp.getBackground().equals(Support.colorScheme.selectedCellbackground)) {
                    comp.setBackground(row % 4 == 0 ? Support.colorScheme.tableGridAlternateBackground : Support.colorScheme.textBackground);
                }
                if (comp instanceof JLabel) {
                    JLabel label = (JLabel)comp;
                    label.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 0));
                    label.setHorizontalAlignment(2);
                }
                return comp;
            }
        };
        JScrollPane scrollPane = new JScrollPane(table);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.insets = new Insets(2, 10, 2, 10);
        c.fill = 1;
        panel.add((Component)scrollPane, c);
        table.setDefaultEditor(String.class, new Support.AutoSelectCellEditor());
        table.setColumnModel(new Support.WidthTableColumnModel(new int[]{200, 200}));
        table.setModel(this.namesTableModel);
        table.getTableHeader().setReorderingAllowed(false);
        table.setAutoResizeMode(0);
        table.setFillsViewportHeight(true);
        JButton resetButton = new JButton("Reset");
        resetButton.setActionCommand("ResetNames");
        resetButton.addActionListener(this);
        resetButton.setToolTipText("Reset all names to default values");
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 1;
        c.insets = new Insets(2, 10, 2, 10);
        c.anchor = 13;
        panel.add((Component)resetButton, c);
        return panel;
    }

    private JPanel makeSyncPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints c = null;
        FontAdjust.FontTable table = new FontAdjust.FontTable(){

            @Override
            public Component prepareRenderer(TableCellRenderer renderer, int row, int col) {
                Component comp = super.prepareRenderer(renderer, row, col);
                if (!comp.getBackground().equals(Support.colorScheme.selectedCellbackground)) {
                    comp.setBackground(row % 4 == 0 ? Support.colorScheme.tableGridAlternateBackground : Support.colorScheme.textBackground);
                }
                if (comp instanceof JLabel) {
                    JLabel label = (JLabel)comp;
                    label.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 0));
                    label.setHorizontalAlignment(2);
                }
                return comp;
            }
        };
        JScrollPane scrollPane = new JScrollPane(table);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.insets = new Insets(2, 10, 2, 10);
        c.fill = 1;
        panel.add((Component)scrollPane, c);
        table.setDefaultEditor(String.class, new SyncTypeCellEditor());
        table.setColumnModel(new Support.WidthTableColumnModel(new int[]{200, 200}));
        table.setModel(this.syncTableModel);
        table.getTableHeader().setReorderingAllowed(false);
        table.setAutoResizeMode(0);
        table.setFillsViewportHeight(true);
        JButton resetButton = new JButton("Reset");
        resetButton.setActionCommand("ResetSync");
        resetButton.addActionListener(this);
        resetButton.setToolTipText("Remove all synchronization");
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 1;
        c.insets = new Insets(2, 10, 2, 10);
        c.anchor = 13;
        panel.add((Component)resetButton, c);
        return panel;
    }

    private JPanel makeAnnotatePanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        JPanel listPanel = new JPanel();
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.weighty = 0.0;
        c.anchor = 12;
        c.fill = 3;
        panel.add((Component)listPanel, c);
        listPanel.setLayout(new BorderLayout());
        listPanel.add((Component)new FontAdjust.FontLabel("    Annotations    "), "North");
        this.annoListModel = new AnnoListModel();
        this.dataList = new JList();
        this.dataList.setSelectionMode(0);
        this.dataList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent arg0) {
                PopupChartLayout.this.elementSelected(PopupChartLayout.this.dataList.getSelectedIndex());
            }
        });
        this.dataList.setModel(this.annoListModel);
        JScrollPane scrollPane = new JScrollPane(this.dataList);
        listPanel.add((Component)scrollPane, "Center");
        this.dataList.addMouseListener(new MouseAdapter(){

            public void check(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    PopupChartLayout.this.annoClick();
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                this.check(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.check(e);
            }
        });
        this.editPanel = new JPanel();
        this.editPanel.setLayout(new FlowLayout(0));
        this.editPanel.setMinimumSize(new Dimension(250, 200));
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.anchor = 12;
        c.fill = 1;
        panel.add((Component)this.editPanel, c);
        this.elementSelected(-1);
        return panel;
    }

    private void elementSelected(int index) {
        this.editPanel.removeAll();
        this.editPanel.repaint();
        if (index < 0 || index >= Support.paneChart.annotations.getList().size()) {
            JPanel panel = new JPanel();
            panel.setLayout(new BoxLayout(panel, 3));
            panel.add(new FontAdjust.FontLabel("Right click in annotations list to add"));
            panel.add(new FontAdjust.FontLabel("Click on annotation names to edit"));
            this.editPanel.add(panel);
            return;
        }
        ChartAnnotations.Anno anno = Support.paneChart.annotations.getList().get(index);
        this.editPanel.add(anno.getEditPanel());
    }

    private void annoClick() {
        JMenuItem mi;
        JMenuItem mi2;
        JPopupMenu pm = new JPopupMenu();
        JMenu mm = new JMenu("Text");
        pm.add(mm);
        for (String s : ChartAnnotations.getAnnotationNamesText()) {
            mi2 = new JMenuItem(s);
            mi2.setActionCommand("Add:" + s);
            mi2.addActionListener(this);
            mm.add(mi2);
        }
        mm = new JMenu("Simple");
        pm.add(mm);
        for (String s : ChartAnnotations.getAnnotationNamesSimple()) {
            mi2 = new JMenuItem(s);
            mi2.setActionCommand("Add:" + s);
            mi2.addActionListener(this);
            mm.add(mi2);
        }
        mm = new JMenu("Complex");
        pm.add(mm);
        for (String s : ChartAnnotations.getAnnotationNamesComplex()) {
            mi2 = new JMenuItem(s);
            mi2.setActionCommand("Add:" + s);
            mi2.addActionListener(this);
            mm.add(mi2);
        }
        if (this.dataList.getSelectedIndex() > 0) {
            mi = new JMenuItem("Move up");
            mi.setActionCommand("Up");
            mi.addActionListener(this);
            pm.add(mi);
        }
        if (this.dataList.getSelectedIndex() < this.annoListModel.getSize() - 1) {
            mi = new JMenuItem("Move down");
            mi.setActionCommand("Down");
            mi.addActionListener(this);
            pm.add(mi);
        }
        if (this.dataList.getSelectedIndex() >= 0) {
            mi = new JMenuItem("Deselect");
            mi.setToolTipText("Remove selection, i.e. not item is selected anomore");
            mi.setActionCommand("Deselect");
            mi.addActionListener(this);
            pm.add(mi);
            mi = new JMenuItem("Remove");
            mi.setToolTipText("Remove selected annotation");
            mi.setActionCommand("Remove");
            mi.addActionListener(this);
            pm.add(mi);
        }
        pm.show(this, 10, 100);
    }

    public void doUpdateValues(int column, double position) {
        int i = this.dataList.getSelectedIndex();
        if (i < 0) {
            return;
        }
        Support.paneChart.annotations.getList().get(i).updateValues(column, position);
    }

    private JPanel makeColorPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints c = null;
        this.chartColorButton = new FontAdjust.FontButton("Background");
        this.chartColorButton.setActionCommand("Background");
        this.chartColorButton.addActionListener(this);
        this.chartColorButton.setHorizontalAlignment(2);
        this.chartColorButton.setToolTipText("Background for the curves");
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(2, 2, 2, 2);
        c.fill = 2;
        panel.add((Component)this.chartColorButton, c);
        this.chartBorderColorButton = new FontAdjust.FontButton("Border");
        this.chartBorderColorButton.setActionCommand("Border");
        this.chartBorderColorButton.addActionListener(this);
        this.chartBorderColorButton.setHorizontalAlignment(2);
        this.chartBorderColorButton.setToolTipText("Color for area outside chart");
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 1;
        c.insets = new Insets(2, 2, 2, 2);
        c.fill = 2;
        panel.add((Component)this.chartBorderColorButton, c);
        this.chartGridColorButton = new FontAdjust.FontButton("Grid");
        this.chartGridColorButton.setActionCommand("Grid");
        this.chartGridColorButton.addActionListener(this);
        this.chartGridColorButton.setHorizontalAlignment(2);
        this.chartGridColorButton.setToolTipText("Grid color in chart");
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 2;
        c.insets = new Insets(2, 2, 2, 2);
        c.fill = 2;
        panel.add((Component)this.chartGridColorButton, c);
        this.chartFontColorButton = new FontAdjust.FontButton("Font");
        this.chartFontColorButton.setActionCommand("Font");
        this.chartFontColorButton.addActionListener(this);
        this.chartFontColorButton.setHorizontalAlignment(2);
        this.chartFontColorButton.setToolTipText("Color on x-axis font");
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 3;
        c.insets = new Insets(2, 2, 2, 2);
        c.fill = 2;
        panel.add((Component)this.chartFontColorButton, c);
        this.chartHeaderColorButton = new FontAdjust.FontButton("Title");
        this.chartHeaderColorButton.setActionCommand("Title");
        this.chartHeaderColorButton.setToolTipText("Title is only used when saving charts");
        this.chartHeaderColorButton.addActionListener(this);
        this.chartHeaderColorButton.setHorizontalAlignment(2);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 4;
        c.insets = new Insets(2, 2, 2, 2);
        c.fill = 2;
        panel.add((Component)this.chartHeaderColorButton, c);
        this.chartDefaultColorButton = new FontAdjust.FontButton("Default");
        this.chartDefaultColorButton.setActionCommand("Default");
        this.chartDefaultColorButton.addActionListener(this);
        this.chartDefaultColorButton.setToolTipText("Restore default colors");
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 0;
        c.insets = new Insets(2, 2, 2, 2);
        panel.add((Component)this.chartDefaultColorButton, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 6;
        c.gridwidth = 2;
        c.weightx = 1.0;
        c.insets = new Insets(20, 2, 2, 2);
        c.fill = 2;
        panel.add((Component)new FontAdjust.FontLabel("Curve colors (Click on color to change, right click to remove):"), c);
        this.curveColorsButton = new FontAdjust.FontButton("");
        this.curveColorsButton.setActionCommand("CC");
        this.curveColorsButton.addActionListener(this);
        this.curveColorsButton.setBorderPainted(false);
        this.curveColorsButton.setBorder(null);
        this.curveColorsButton.setToolTipText("Colors for the individual curves");
        this.curveColorsButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 1 && e.getButton() == 1) {
                    PopupChartLayout.this.colorClick1(e.getX() / 32);
                } else if (e.getClickCount() == 1 && e.getButton() == 3) {
                    PopupChartLayout.this.colorClick2(e.getX() / 32);
                }
            }
        });
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 7;
        c.gridwidth = 2;
        c.insets = new Insets(2, 2, 2, 2);
        c.weightx = 1.0;
        panel.add((Component)this.curveColorsButton, c);
        this.fillColors();
        return panel;
    }

    private void colorClick1(int n) {
        Color c = MySwingUtil.colorChooser(this, "Curve " + (n + 1), n < Support.chartLineColor.length ? Support.chartLineColor[n] : null);
        if (c != null) {
            if (n >= Support.chartLineColor.length) {
                Support.chartLineColor = Arrays.copyOf(Support.chartLineColor, n + 1);
            }
            Support.chartLineColor[n] = c;
            Support.paneChart.update();
            this.fillColors();
        }
    }

    private void colorClick2(int n) {
        if (n < Support.chartLineColor.length) {
            int i = n;
            while (i < Support.chartLineColor.length - 1) {
                Support.chartLineColor[i] = Support.chartLineColor[i + 1];
                ++i;
            }
            Support.chartLineColor = Arrays.copyOf(Support.chartLineColor, Support.chartLineColor.length - 1);
        }
        if (Support.chartLineColor.length == 0) {
            Support.chartLineColor = new Color[1];
            Support.chartLineColor[0] = Color.red;
        }
        Support.paneChart.update();
        this.fillColors();
    }

    private BufferedImage generateColorImage(Color color) {
        BufferedImage image = new BufferedImage(30, 20, 1);
        Graphics g = image.getGraphics();
        if (color == null) {
            g.setColor(Color.lightGray);
            g.fillRect(0, 0, 30, 20);
            g.setColor(Color.white);
            g.drawRect(1, 1, 28, 18);
            g.drawLine(1, 1, 28, 18);
            g.drawLine(1, 18, 28, 1);
        } else {
            g.setColor(color);
            g.fillRect(0, 0, 30, 20);
        }
        return image;
    }

    private ImageIcon generateColorIcon(Color color) {
        return new ImageIcon(this.generateColorImage(color));
    }

    private ImageIcon generateCurveColors() {
        BufferedImage image = new BufferedImage(32 * (Support.chartLineColor.length + 1), 20, 1);
        Graphics g = image.getGraphics();
        g.setColor(this.getBackground());
        g.fillRect(0, 0, image.getWidth(), image.getHeight());
        int i = 0;
        while (i < Support.chartLineColor.length) {
            g.drawImage(this.generateColorImage(Support.chartLineColor[i]), i * 32, 0, null);
            ++i;
        }
        g.drawImage(this.generateColorImage(null), Support.chartLineColor.length * 32, 0, null);
        return new ImageIcon(image);
    }

    private void fillColors() {
        this.chartColorButton.setIcon(this.generateColorIcon(Support.chartColor));
        this.chartBorderColorButton.setIcon(this.generateColorIcon(Support.chartBorderColor));
        this.chartGridColorButton.setIcon(this.generateColorIcon(Support.chartGridColor));
        this.chartFontColorButton.setIcon(this.generateColorIcon(Support.chartFontColor));
        this.chartHeaderColorButton.setIcon(this.generateColorIcon(Support.chartHeaderColor));
        this.curveColorsButton.setIcon(this.generateCurveColors());
    }

    public static void closeAll() {
        if (popupChartLayout != null) {
            popupChartLayout.setVisible(false);
            popupChartLayout = null;
        }
    }

    public static void layoutFillColors() {
        if (popupChartLayout != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    popupChartLayout.fillColors();
                }
            });
        }
    }

    public static void updateNames() {
        if (popupChartLayout != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    popupChartLayout.namesTableModel.changed();
                }
            });
        }
    }

    public static void updateSync() {
        if (popupChartLayout != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    popupChartLayout.syncTableModel.changed();
                }
            });
        }
    }

    public static void updateAnnotations() {
        if (popupChartLayout != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    popupChartLayout.annoListModel.changed();
                }
            });
        }
    }

    public static void updataValues(int column, double position) {
        if (popupChartLayout != null) {
            popupChartLayout.doUpdateValues(column, position);
        }
    }

    public List<String> doGenerateScript() {
        ArrayList<String> list = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        for (String s : Support.dataBase.header().getColumnsList()) {
            if (s.equals("time") || s.equals("dateTime")) continue;
            list.add(Support.chartScales.getScale(s).generateScript());
        }
        sb.append("#ChartCurves ");
        for (String s : Support.paneChart.checkedColumns) {
            sb.append(" ");
            sb.append(Support.conditionalQuote(s));
        }
        list.add(sb.toString());
        sb.setLength(0);
        sb.append("#ChartX ");
        sb.append(Support.conditionalQuote(Support.paneChart.getDomainColumn()));
        list.add(sb.toString());
        sb.setLength(0);
        sb.append("#ChartBackground ");
        sb.append(Support.chartColor != null ? ColorUtil.colorToName(Support.chartColor) : Character.valueOf('-'));
        sb.append(' ');
        sb.append(Support.chartBorderColor != null ? ColorUtil.colorToName(Support.chartBorderColor) : Character.valueOf('-'));
        sb.append(' ');
        sb.append(Support.chartGridColor != null ? ColorUtil.colorToName(Support.chartGridColor) : Character.valueOf('-'));
        sb.append(' ');
        sb.append(Support.chartFontColor != null ? ColorUtil.colorToName(Support.chartFontColor) : Character.valueOf('-'));
        sb.append(' ');
        sb.append(Support.chartHeaderColor != null ? ColorUtil.colorToName(Support.chartHeaderColor) : Character.valueOf('-'));
        list.add(sb.toString());
        sb.setLength(0);
        sb.append("#ChartColors");
        int i = 0;
        while (i < Support.chartLineColor.length) {
            sb.append(' ');
            sb.append(ColorUtil.colorToName(Support.chartLineColor[i]));
            ++i;
        }
        list.add(sb.toString());
        sb.setLength(0);
        list.add("#ChartTitle" + (Support.chartTitle == null ? "" : Support.conditionalQuote(" " + Support.chartTitle)));
        for (String s : Support.dataBase.header().getColumnsList()) {
            String sx = "";
            if (s.equals("time")) {
                sx = Support.chartScales.getTimeName();
                if (sx.equals("time")) {
                    sx = null;
                }
            } else if (s.equals("dateTime")) {
                sx = Support.chartScales.getDateTimeName();
                if (sx.equals("dateTime")) {
                    sx = null;
                }
            } else {
                sx = Support.chartScales.getScale(s).getAxisOverrideName();
            }
            if (sx == null) continue;
            list.add("#ChartScaleName " + Support.conditionalQuote(s) + " " + Support.conditionalQuote(sx));
        }
        HashSet<String> syncMasters = new HashSet<String>();
        int[] nArray = Support.dataBase.header().getDataColumns();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int i2 = nArray[n2];
            String sync = Support.chartScales.getScale(Support.dataBase.header().getColumnName(i2)).getSyncToScale();
            if (sync != null && !syncMasters.contains(sync)) {
                syncMasters.add(sync);
                sb.append("#ChartScaleSync ");
                sb.append(Support.conditionalQuote(sync));
                int[] nArray2 = Support.dataBase.header().getDataColumns();
                int n3 = nArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    int j = nArray2[n4];
                    String name = Support.dataBase.header().getColumnName(j);
                    ChartScales.ChartScale cs = Support.chartScales.getScale(name);
                    if (cs.getSyncToScale() != null && cs.getSyncToScale().equals(sync)) {
                        sb.append(" ");
                        sb.append(Support.conditionalQuote(name));
                    }
                    ++n4;
                }
                list.add(sb.toString());
                sb.setLength(0);
            }
            ++n2;
        }
        list.add("#ChartAnnotate");
        for (ChartAnnotations.Anno a : Support.paneChart.annotations.getList()) {
            list.add(a.generateScript());
        }
        return list;
    }

    public static List<String> generateScript() {
        List<String> list = new ArrayList<String>();
        if (popupChartLayout != null) {
            list = popupChartLayout.doGenerateScript();
        }
        return list;
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        int i;
        if (arg0.getActionCommand().equals("Background")) {
            Color c = MySwingUtil.colorChooser(this, "Background", Support.chartColor);
            if (c != null) {
                Support.chartColor = c;
                Support.paneChart.update();
                this.fillColors();
            }
        } else if (arg0.getActionCommand().equals("Border")) {
            Color c = MySwingUtil.colorChooser(this, "Border", Support.chartBorderColor);
            if (c != null) {
                Support.chartBorderColor = c;
                Support.paneChart.update();
                this.fillColors();
            }
        } else if (arg0.getActionCommand().equals("Grid")) {
            Color c = MySwingUtil.colorChooser(this, "Grid", Support.chartGridColor);
            if (c != null) {
                Support.chartGridColor = c;
                Support.paneChart.update();
                this.fillColors();
            }
        } else if (arg0.getActionCommand().equals("Font")) {
            Color c = MySwingUtil.colorChooser(this, "Font", Support.chartFontColor);
            if (c != null) {
                Support.chartFontColor = c;
                Support.paneChart.update();
                this.fillColors();
            }
        } else if (arg0.getActionCommand().equals("Title")) {
            Color c = MySwingUtil.colorChooser(this, "Title", Support.chartHeaderColor);
            if (c != null) {
                Support.chartHeaderColor = c;
                Support.paneChart.update();
                this.fillColors();
            }
        } else if (arg0.getActionCommand().equals("Default")) {
            Support.chartColor = null;
            Support.chartBorderColor = null;
            Support.chartGridColor = null;
            Support.chartFontColor = null;
            Support.chartHeaderColor = null;
            Support.chartLineColor = Arrays.copyOf(Support.InitialChartLineColor, Support.InitialChartLineColor.length);
            Support.paneChart.update();
            this.fillColors();
        } else if (arg0.getActionCommand().equals("ResetNames")) {
            Support.chartScales.resetOverrides();
            Support.chartTitle = null;
            Support.paneChart.update();
            this.namesTableModel.changed();
        } else if (arg0.getActionCommand().equals("ResetSync")) {
            Support.chartScales.disableSync();
            Support.paneChart.update();
            this.syncTableModel.changed();
        } else if (arg0.getActionCommand().startsWith("Add:")) {
            Support.paneChart.annotations.add(arg0.getActionCommand().substring(4));
            Support.paneChart.update();
            this.annoListModel.changed();
        } else if (arg0.getActionCommand().equals("Up")) {
            int i2 = this.dataList.getSelectedIndex();
            Support.paneChart.annotations.moveUp(i2);
            this.dataList.setSelectedIndex(i2 - 1);
            Support.paneChart.update();
        } else if (arg0.getActionCommand().equals("Down")) {
            int i3 = this.dataList.getSelectedIndex();
            Support.paneChart.annotations.moveDown(i3);
            this.dataList.setSelectedIndex(i3 + 1);
            Support.paneChart.update();
        } else if (arg0.getActionCommand().equals("Deselect")) {
            this.dataList.clearSelection();
            this.elementSelected(-1);
        } else if (arg0.getActionCommand().equals("Remove") && (i = this.dataList.getSelectedIndex()) >= 0) {
            Support.paneChart.annotations.getList().remove(i);
            this.annoListModel.changed();
            this.elementSelected(-1);
            Support.paneChart.update();
        }
    }

    class AnnoListModel
    implements ListModel<String> {
        private List<ListDataListener> listDataListener = new ArrayList<ListDataListener>();

        AnnoListModel() {
        }

        @Override
        public void addListDataListener(ListDataListener l) {
            this.listDataListener.add(l);
        }

        @Override
        public String getElementAt(int index) {
            ChartAnnotations.Anno anno = Support.paneChart.annotations.getList().get(index);
            return anno.name();
        }

        @Override
        public int getSize() {
            return Support.paneChart.annotations.getList().size();
        }

        @Override
        public void removeListDataListener(ListDataListener l) {
            this.listDataListener.remove(l);
        }

        private void changed() {
            for (ListDataListener ld : this.listDataListener) {
                ld.intervalAdded(new ListDataEvent(this, 0, 0, this.getSize()));
            }
        }
    }

    public class NamesTableModel
    implements TableModel {
        private List<TableModelListener> listeners = new ArrayList<TableModelListener>();

        NamesTableModel() {
        }

        @Override
        public void addTableModelListener(TableModelListener arg0) {
            this.listeners.add(arg0);
        }

        @Override
        public Class<?> getColumnClass(int column) {
            switch (column) {
                case 0: {
                    return String.class;
                }
                case 1: {
                    return String.class;
                }
            }
            return String.class;
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return "Name";
                }
                case 1: {
                    return "Chart name";
                }
            }
            return "?";
        }

        @Override
        public int getRowCount() {
            return Support.dataBase.columns() + 1;
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (row >= Support.dataBase.columns()) {
                switch (col) {
                    case 0: {
                        return "<Title on saved charts>";
                    }
                    case 1: {
                        return Support.chartTitle == null ? "<Filename>" : Support.chartTitle;
                    }
                }
                return Character.valueOf('?');
            }
            switch (col) {
                case 0: {
                    return Support.dataBase.header().getColumnName(row);
                }
                case 1: {
                    String s = Support.dataBase.header().getColumnName(row);
                    if (s.equals("time")) {
                        return Support.chartScales.getTimeName();
                    }
                    if (s.equals("dateTime")) {
                        return Support.chartScales.getDateTimeName();
                    }
                    ChartScales.ChartScale cs = Support.chartScales.getScale(s);
                    return cs.getAxisName();
                }
            }
            return Character.valueOf('?');
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            switch (col) {
                case 0: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
            return false;
        }

        @Override
        public void removeTableModelListener(TableModelListener arg0) {
            int i = this.listeners.size() - 1;
            while (i >= 0) {
                if (this.listeners.get(i) == arg0) {
                    this.listeners.remove(i);
                }
                --i;
            }
        }

        @Override
        public void setValueAt(Object val, int row, int col) {
            switch (col) {
                case 1: {
                    if (row >= Support.dataBase.columns()) {
                        String s = (String)val;
                        Support.chartTitle = s == null || s.trim().isEmpty() ? null : s;
                        break;
                    }
                    String s = Support.dataBase.header().getColumnName(row);
                    Support.chartScales.overrideName(s, (String)val);
                    Support.paneChart.update();
                }
            }
        }

        private void changed() {
            for (TableModelListener ml : this.listeners) {
                ml.tableChanged(new TableModelEvent(this));
            }
        }
    }

    public class SyncTableModel
    implements TableModel {
        private List<String> columnNames = new ArrayList<String>();
        private List<TableModelListener> listeners = new ArrayList<TableModelListener>();

        SyncTableModel() {
            int[] nArray = Support.dataBase.header().getDataColumns();
            int n = nArray.length;
            int n2 = 0;
            while (n2 < n) {
                int i = nArray[n2];
                this.columnNames.add(Support.dataBase.header().getColumnName(i));
                ++n2;
            }
        }

        @Override
        public void addTableModelListener(TableModelListener arg0) {
            this.listeners.add(arg0);
        }

        public List<String> getSynsColumns(int exclude) {
            String ownName = this.columnNames.get(exclude);
            ArrayList<String> list = new ArrayList<String>();
            list.add("");
            for (String s : this.columnNames) {
                ChartScales.ChartScale cs = Support.chartScales.getScale(s);
                if (cs.getSyncToScale() != null || s.equals(ownName)) continue;
                list.add(s);
            }
            return list;
        }

        private boolean isSyncMaster(String name) {
            for (String s : this.columnNames) {
                ChartScales.ChartScale cs = Support.chartScales.getScale(s);
                if (!name.equals(cs.getSyncToScale())) continue;
                return true;
            }
            return false;
        }

        private boolean isDigital(String name) {
            int n = Support.dataBase.header().getIndex(name);
            return Support.dataBase.format().get((int)n).format instanceof ValueFormat.ValueFormatterDigital;
        }

        @Override
        public Class<?> getColumnClass(int column) {
            switch (column) {
                case 0: {
                    return String.class;
                }
                case 1: {
                    return String.class;
                }
            }
            return String.class;
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return "Name";
                }
                case 1: {
                    return "Synchronized to";
                }
            }
            return "?";
        }

        @Override
        public int getRowCount() {
            return this.columnNames.size();
        }

        @Override
        public Object getValueAt(int row, int col) {
            switch (col) {
                case 0: {
                    return this.columnNames.get(row);
                }
                case 1: {
                    String name = this.columnNames.get(row);
                    ChartScales.ChartScale cs = Support.chartScales.getScale(name);
                    String s = cs.getSyncToScale();
                    if (this.isSyncMaster(name)) {
                        return "-- master --";
                    }
                    if (this.isDigital(name)) {
                        return "-- Digital --";
                    }
                    return s == null || s.equals(name) ? "" : s;
                }
            }
            return Character.valueOf('?');
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            switch (col) {
                case 0: {
                    return false;
                }
                case 1: {
                    String name = this.columnNames.get(row);
                    return !this.isSyncMaster(name) && !this.isDigital(name);
                }
            }
            return false;
        }

        @Override
        public void removeTableModelListener(TableModelListener arg0) {
            int i = this.listeners.size() - 1;
            while (i >= 0) {
                if (this.listeners.get(i) == arg0) {
                    this.listeners.remove(i);
                }
                --i;
            }
        }

        @Override
        public void setValueAt(Object val, int row, int col) {
            switch (col) {
                case 1: {
                    ChartScales.ChartScale cs = Support.chartScales.getScale(this.columnNames.get(row));
                    try {
                        cs.setSyncToScale((String)val);
                        Support.paneChart.update();
                        this.changed();
                        break;
                    }
                    catch (Exception exception) {}
                }
            }
        }

        private void changed() {
            for (TableModelListener ml : this.listeners) {
                ml.tableChanged(new TableModelEvent(this));
            }
        }
    }

    public class SyncTypeCellEditor
    extends DefaultCellEditor {
        public SyncTypeCellEditor() {
            super(new FontAdjust.FontComboBox());
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            Component editor = super.getTableCellEditorComponent(table, value, isSelected, row, column);
            if (editor instanceof JComboBox) {
                JComboBox cb = (JComboBox)editor;
                cb.setMaximumRowCount(20);
                cb.removeAllItems();
                for (String s : PopupChartLayout.this.syncTableModel.getSynsColumns(row)) {
                    cb.addItem(s);
                }
                cb.setSelectedItem(value);
            }
            return editor;
        }
    }
}

