/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.main;

import dk.hkj.main.FontAdjust;
import dk.hkj.main.PopupBase;
import dk.hkj.main.Support;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.xy.DefaultXYDataset;

public class PopupChart
extends PopupBase
implements ActionListener {
    private static PopupChart chart = null;
    private DefaultXYDataset dataset = null;
    private JFreeChart freeChart = null;
    private ChartPanel chartPanel = null;

    public PopupChart(String title, String xTitle, String yTitle) {
        PopupChart.closeAll();
        this.setTitle(title);
        this.setDefaultCloseOperation(2);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent e) {
                if (chart == PopupChart.this) {
                    chart = null;
                }
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                if (chart == PopupChart.this) {
                    chart = null;
                }
            }
        });
        this.definePopupName("PopupChart", true);
        chart = this;
        this.dataset = new DefaultXYDataset();
        this.freeChart = ChartFactory.createXYLineChart(title, xTitle, yTitle, this.dataset, PlotOrientation.VERTICAL, true, true, false);
        this.freeChart.getXYPlot().getDomainAxis().setUpperMargin(0.0);
        this.freeChart.getXYPlot().getDomainAxis().setLowerMargin(0.0);
        Support.MyDecimalFormat nf = new Support.MyDecimalFormat();
        nf.setMaximumFractionDigits(1);
        ((NumberAxis)this.freeChart.getXYPlot().getRangeAxis()).setNumberFormatOverride(nf);
        nf.setSIFormat(true);
        FontAdjust.fontSizes.chartTheme.apply(this.freeChart);
        this.freeChart.getLegend().setVisible(false);
        this.freeChart.getTitle().setVisible(false);
        this.chartPanel = new ChartPanel(this.freeChart);
        this.chartPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.chartPanel.setBackground(Color.white);
        this.add(this.chartPanel);
        this.pack();
    }

    public void showData(double[][] series) {
        this.dataset.addSeries((Comparable)((Object)"Sample"), series);
        this.freeChart.getXYPlot().getRangeAxis().setAutoRange(true);
        this.chartPanel.restoreAutoBounds();
    }

    public void showData(double[] x, int n, double[] yn) {
        double[][] series = new double[2][x.length];
        int i = 0;
        while (i < x.length) {
            series[0][i] = x[i];
            series[1][i] = yn[i];
            ++i;
        }
        this.dataset.addSeries((Comparable)((Object)("X" + n)), series);
        this.freeChart.getXYPlot().getRangeAxis().setAutoRange(true);
        this.chartPanel.restoreAutoBounds();
    }

    public static void closeAll() {
        if (chart != null) {
            chart.setVisible(false);
            chart = null;
        }
    }

    public static PopupChart getPopup(String title, String xTitle, String yTitle) {
        if (chart == null) {
            chart = new PopupChart(title, xTitle, yTitle);
            chart.setVisible(true);
        }
        return chart;
    }

    @Override
    public void actionPerformed(ActionEvent cmd) {
    }

    public static void alignGridAll(int pixels) {
        if (chart != null) {
            chart.alignGrid(pixels);
        }
    }
}

