/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.main;

import com.github.sarxos.webcam.Webcam;
import dk.hkj.main.CameraDigits;
import dk.hkj.main.PopupBaseFrame;
import dk.hkj.util.ImagePanel;
import dk.hkj.util.StringUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class PopupCameraSelect
extends PopupBaseFrame
implements ActionListener {
    private static PopupCameraSelect popupImageSelect = null;
    private Webcam webcam = null;
    private ImagePanel imagePanel = null;
    private JPanel infoPanel = null;
    private JLabel cursorLabel = null;
    private Point startPoint = null;
    private CameraDigits.DigitArea digitArea = CameraDigits.DigitArea.none;
    private CameraDigits cameraDigits = null;
    private Point cursorLocation = new Point();

    public void setDigits(CameraDigits cameraDigits) {
        this.cameraDigits = cameraDigits;
    }

    private PopupCameraSelect(Webcam webcam) {
        this.webcam = webcam;
        PopupCameraSelect.closeAll();
        this.setTitle("Camera select");
        this.setDefaultCloseOperation(2);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent e) {
                if (popupImageSelect == PopupCameraSelect.this) {
                    popupImageSelect = null;
                }
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                if (popupImageSelect == PopupCameraSelect.this) {
                    popupImageSelect = null;
                }
            }
        });
        popupImageSelect = this;
        this.setPreferredSize(new Dimension(470, 310));
        this.setSize(new Dimension(470, 310));
        this.definePopupName("PopupCameraSelect", true);
        this.makeLayout();
        if (webcam == null) {
            this.setVisible(false);
            return;
        }
        ImageUpdate iu = new ImageUpdate();
        iu.start();
    }

    public void setCamera(Webcam webcam) {
        this.webcam = webcam;
    }

    private void makeLayout() {
        this.imagePanel = new ImagePanel();
        this.imagePanel.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent arg0) {
            }

            @Override
            public void mouseEntered(MouseEvent arg0) {
            }

            @Override
            public void mouseExited(MouseEvent arg0) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                PopupCameraSelect.this.startPoint = e.getPoint();
                PopupCameraSelect.this.digitArea = PopupCameraSelect.this.cameraDigits.getDigitArea(PopupCameraSelect.this.startPoint);
                System.out.println(PopupCameraSelect.this.startPoint + "  " + PopupCameraSelect.this.digitArea.name());
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }
        });
        this.imagePanel.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent arg0) {
                PopupCameraSelect.this.cursorLocation = arg0.getPoint();
                Point here = arg0.getPoint();
                int dx = here.x - ((PopupCameraSelect)PopupCameraSelect.this).startPoint.x;
                int dy = here.y - ((PopupCameraSelect)PopupCameraSelect.this).startPoint.y;
                PopupCameraSelect.this.cameraDigits.move(PopupCameraSelect.this.digitArea, dx, dy);
                PopupCameraSelect.this.startPoint = here;
            }

            @Override
            public void mouseMoved(MouseEvent arg0) {
                PopupCameraSelect.this.cursorLocation = arg0.getPoint();
            }
        });
        this.add(this.imagePanel);
        this.infoPanel = new JPanel();
        this.add((Component)this.infoPanel, "South");
        this.cursorLabel = new JLabel("Cursor: ");
        this.infoPanel.add(this.cursorLabel);
    }

    public static void closeAll() {
        if (popupImageSelect != null) {
            popupImageSelect.setVisible(false);
            popupImageSelect = null;
        }
    }

    public static synchronized PopupCameraSelect getPopup(Webcam webcam) {
        PopupCameraSelect pop = new PopupCameraSelect(webcam);
        pop.setLocationRelativeTo(null);
        pop.setVisible(true);
        popupImageSelect = pop;
        return pop;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }

    private class ImageUpdate
    extends Thread {
        private ImageUpdate() {
        }

        @Override
        public void run() {
            long next = System.currentTimeMillis() + 20L;
            while (popupImageSelect != null) {
                try {
                    if (PopupCameraSelect.this.webcam == null || !PopupCameraSelect.this.webcam.isOpen()) {
                        Thread.sleep(200L);
                    }
                    if (System.currentTimeMillis() < next) {
                        ImageUpdate.sleep(next - System.currentTimeMillis());
                    }
                    next = System.currentTimeMillis() + 50L;
                    final BufferedImage img = PopupCameraSelect.this.webcam.getImage();
                    if (PopupCameraSelect.this.cameraDigits != null) {
                        long mask = PopupCameraSelect.this.cameraDigits.getOnMask(img);
                        int i = 0;
                        while (i < 6) {
                            System.out.print(StringUtil.bin((byte)(mask >> 8 * (5 - i))));
                            System.out.print(" ");
                            ++i;
                        }
                        System.out.println();
                        Graphics2D gph = (Graphics2D)img.getGraphics();
                        gph.setColor(new Color(50, 50, 50, 100));
                        gph.setColor(new Color(255, 0, 0));
                        if (PopupCameraSelect.this.cameraDigits != null) {
                            for (Shape s : PopupCameraSelect.this.cameraDigits.getShapes()) {
                                gph.fill(s);
                            }
                        }
                    }
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            PopupCameraSelect.this.imagePanel.setImage(img);
                            StringBuilder sb = new StringBuilder();
                            sb.append("Cursor: ");
                            sb.append(String.valueOf(((PopupCameraSelect)((ImageUpdate)ImageUpdate.this).PopupCameraSelect.this).cursorLocation.x) + "  " + ((PopupCameraSelect)((ImageUpdate)ImageUpdate.this).PopupCameraSelect.this).cursorLocation.y);
                            PopupCameraSelect.this.cursorLabel.setText(sb.toString());
                        }
                    });
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

