/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.main;

import com.github.sarxos.webcam.Webcam;
import com.github.sarxos.webcam.WebcamImageTransformer;
import com.github.sarxos.webcam.util.jh.JHFlipFilter;
import dk.hkj.main.CameraDigits;
import dk.hkj.main.FontAdjust;
import dk.hkj.main.PopupBaseFrame;
import dk.hkj.main.PopupCameraSelect;
import dk.hkj.main.Support;
import dk.hkj.util.FileUtil;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class PopupCameraInput
extends PopupBaseFrame
implements ActionListener,
FocusListener {
    private static PopupCameraInput popupCameraInput = null;
    private JTextField deviceNameTextField = null;
    private JTextField deviceHandleTextField = null;
    private JComboBox<String> webcamComboBox = null;
    private JComboBox<String> resolutionComboBox = null;
    private JComboBox<String> rotateComboBox = null;
    private Webcam webcam = null;
    private Decoder[] decoder = new Decoder[4];
    private boolean changed = false;
    private int numDecoders = 1;

    private PopupCameraInput() {
        PopupCameraInput.closeAll();
        this.setTitle("Camera input");
        this.setDefaultCloseOperation(2);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent e) {
                PopupCameraInput.this.closing();
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                PopupCameraInput.this.closing();
            }
        });
        popupCameraInput = this;
        this.setPreferredSize(new Dimension(520, 280));
        this.setSize(new Dimension(520, 280));
        this.definePopupName("PopupCameraInput", true);
        int i = 0;
        while (i < 4) {
            this.decoder[i] = new Decoder(i);
            ++i;
        }
        this.makeLayout();
        this.setNumDecoders(1);
        this.loadDefaultSettings();
        this.initCamera();
    }

    private void closing() {
        if (this.webcam != null) {
            this.webcam.close();
            Webcam.resetDriver();
            this.webcam = null;
        }
        if (popupCameraInput == this) {
            popupCameraInput = null;
        }
        Decoder[] decoderArray = this.decoder;
        int n = this.decoder.length;
        int n2 = 0;
        while (n2 < n) {
            Decoder dc = decoderArray[n2];
            if (dc.cameraDigits.isMoved()) {
                this.changed = true;
            }
            ++n2;
        }
        this.saveDefaultSettings();
    }

    private void makeLayout() {
        this.setLayout(new GridLayout(6, 1, 0, 0));
        JPanel panel = new JPanel();
        panel.setLayout(new FlowLayout(0));
        this.add(panel);
        panel.add(new FontAdjust.FontLabel("Device:"));
        this.deviceNameTextField = new FontAdjust.FontTextField(6);
        this.deviceNameTextField.setText("Camera");
        panel.add(this.deviceNameTextField);
        panel.add(Box.createHorizontalStrut(10));
        panel.add(new FontAdjust.FontLabel("Handle:"));
        this.deviceHandleTextField = new FontAdjust.FontTextField(6);
        this.deviceHandleTextField.setText("CAM");
        panel.add(this.deviceHandleTextField);
        panel.add(Box.createHorizontalStrut(10));
        ButtonGroup bg = new ButtonGroup();
        int i = 0;
        while (i < 4) {
            FontAdjust.FontRadioButton rb = new FontAdjust.FontRadioButton(Integer.toString(i + 1));
            if (i == 0) {
                rb.setSelected(true);
            }
            rb.setActionCommand("#" + (i + 1));
            rb.addActionListener(this);
            bg.add(rb);
            panel.add(rb);
            ++i;
        }
        panel = new JPanel();
        panel.setLayout(new FlowLayout(0));
        this.add(panel);
        panel.add(new FontAdjust.FontLabel("Camera:"));
        this.webcamComboBox = new FontAdjust.FontComboBox<String>();
        for (Webcam cam : Webcam.getWebcams()) {
            this.webcamComboBox.addItem(cam.getName());
        }
        this.webcamComboBox.setActionCommand("Camera");
        this.webcamComboBox.addActionListener(this);
        this.webcamComboBox.setSelectedIndex(0);
        panel.add(this.webcamComboBox);
        panel.add(Box.createHorizontalStrut(10));
        panel.add(new FontAdjust.FontLabel("Resolution:"));
        this.resolutionComboBox = new FontAdjust.FontComboBox<String>();
        this.resolutionComboBox.addItem("320 x 240");
        this.resolutionComboBox.addItem("640 x 480");
        this.resolutionComboBox.addItem("800 x 600");
        this.resolutionComboBox.addItem("1024 x 768");
        this.resolutionComboBox.addItem("1280 x 800");
        this.resolutionComboBox.addItem("1680 x 1050");
        this.resolutionComboBox.addItem("1920 x 1200");
        this.resolutionComboBox.setSelectedItem("1024 x 768");
        this.resolutionComboBox.setActionCommand("Resolution");
        this.resolutionComboBox.addActionListener(this);
        panel.add(this.resolutionComboBox);
        panel.add(Box.createHorizontalStrut(10));
        panel.add(new FontAdjust.FontLabel("Rotate:"));
        this.rotateComboBox = new FontAdjust.FontComboBox<String>();
        this.rotateComboBox.addItem("none");
        this.rotateComboBox.addItem("CW");
        this.rotateComboBox.addItem("180\u00b0");
        this.rotateComboBox.addItem("CCW");
        this.rotateComboBox.setSelectedIndex(0);
        this.rotateComboBox.setActionCommand("Rotate");
        this.rotateComboBox.addActionListener(this);
        panel.add(this.rotateComboBox);
        Decoder[] decoderArray = this.decoder;
        int n = this.decoder.length;
        int n2 = 0;
        while (n2 < n) {
            Decoder dc = decoderArray[n2];
            this.add(dc.makePanel());
            ++n2;
        }
    }

    private void initCamera() {
        if (this.resolutionComboBox == null || this.rotateComboBox == null) {
            return;
        }
        String cam = (String)this.webcamComboBox.getSelectedItem();
        if (this.webcam != null && this.webcam.isOpen()) {
            this.webcam.close();
        }
        this.webcam = Webcam.getWebcamByName(cam);
        String size = (String)this.resolutionComboBox.getSelectedItem();
        if (size == null) {
            return;
        }
        String[] s = size.split("[x ]+");
        Dimension d = new Dimension(Integer.parseInt(s[0]), Integer.parseInt(s[1]));
        this.webcam.setCustomViewSizes(d);
        this.webcam.setViewSize(d);
        this.webcam.setImageTransformer(new Transformer((String)this.rotateComboBox.getSelectedItem()));
        this.webcam.open();
        Decoder[] decoderArray = this.decoder;
        int n = this.decoder.length;
        int n2 = 0;
        while (n2 < n) {
            Decoder dc = decoderArray[n2];
            dc.updateCamera();
            ++n2;
        }
    }

    public static void closeAll() {
        if (popupCameraInput != null) {
            popupCameraInput.setVisible(false);
            popupCameraInput = null;
        }
    }

    public static synchronized PopupCameraInput getPopup() {
        PopupCameraInput pop = new PopupCameraInput();
        Point p = Support.paneCommand.popupsButton.getLocationOnScreen();
        p.translate(-200, -550);
        if (p.y < 0) {
            p.y = 0;
        }
        if (p.x < 0) {
            p.x = 0;
        }
        pop.setLocation(p);
        pop.setVisible(true);
        popupCameraInput = pop;
        return pop;
    }

    private void placeDigits() {
    }

    private void setNumDecoders(int n) {
        this.numDecoders = n;
        int i = 0;
        while (i < 4) {
            this.decoder[i].setEnabled(i < this.numDecoders);
            ++i;
        }
    }

    public void saveToFileSettings(File file) {
        ArrayList<String> list = new ArrayList<String>();
        Decoder[] decoderArray = this.decoder;
        int n = this.decoder.length;
        int n2 = 0;
        while (n2 < n) {
            Decoder dc = decoderArray[n2];
            dc.saveToList(list);
            ++n2;
        }
        try {
            FileUtil.writeFile(file, list);
        }
        catch (IOException iOException) {}
    }

    public void loadFromFileSettings(File file) {
        try {
            List<String> list = FileUtil.readFileAsList(file);
            for (String line : list) {
                Decoder dc;
                int n;
                int n2;
                Decoder[] decoderArray;
                if ((line = line.trim()).length() > 0 && !line.startsWith(";") && line.contains("|")) {
                    decoderArray = this.decoder;
                    n2 = this.decoder.length;
                    n = 0;
                    while (n < n2) {
                        dc = decoderArray[n];
                        dc.parseList(line);
                        ++n;
                    }
                }
                decoderArray = this.decoder;
                n2 = this.decoder.length;
                n = 0;
                while (n < n2) {
                    dc = decoderArray[n];
                    dc.updateCamera();
                    ++n;
                }
            }
        }
        catch (IOException iOException) {}
    }

    public void saveDefaultSettings() {
        if (this.changed) {
            this.saveToFileSettings(new File(String.valueOf(Support.getConfigPath()) + "/settingsCamera.txt"));
            this.changed = false;
        }
    }

    public void loadDefaultSettings() {
        this.loadFromFileSettings(new File(String.valueOf(Support.getConfigPath()) + "/settingsCamera.txt"));
    }

    @Override
    public void focusGained(FocusEvent arg0) {
    }

    @Override
    public void focusLost(FocusEvent arg0) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equalsIgnoreCase("Camera")) {
            this.initCamera();
        } else if (e.getActionCommand().equalsIgnoreCase("Resolution")) {
            this.initCamera();
        } else if (e.getActionCommand().equalsIgnoreCase("Rotate")) {
            this.initCamera();
        } else if (e.getActionCommand().equalsIgnoreCase("#1")) {
            this.setNumDecoders(1);
        } else if (e.getActionCommand().equalsIgnoreCase("#2")) {
            this.setNumDecoders(2);
        } else if (e.getActionCommand().equalsIgnoreCase("#3")) {
            this.setNumDecoders(3);
        } else if (e.getActionCommand().equalsIgnoreCase("#4")) {
            this.setNumDecoders(4);
        }
        this.saveDefaultSettings();
    }

    private class Decoder
    implements ActionListener,
    FocusListener {
        private boolean enabled = true;
        private int index = 0;
        private JLabel numFormatLabel = null;
        private JComboBox<String> numFormatComboBox = null;
        private JButton showButton = null;
        private JSlider spacingSlider = null;
        private JLabel valueNameLabel = null;
        private JTextField valueNameTextField = null;
        private int digitSpacing = 13;
        private String valueName = "";
        private String selectedCameraDigits = "-8888";
        private CameraDigits cameraDigits = null;
        private PopupCameraSelect popupCameraSelect = null;

        Decoder(int index) {
            this.index = index;
            this.valueName = "Value" + (index + 1);
            this.cameraDigits = new CameraDigits();
            this.cameraDigits.setFormat(this.selectedCameraDigits);
            this.cameraDigits.setDigitSpacing(this.digitSpacing);
        }

        public JPanel makePanel() {
            JPanel panel = new JPanel();
            panel.setLayout(new FlowLayout(0));
            this.valueNameLabel = new FontAdjust.FontLabel("Name:");
            panel.add(this.valueNameLabel);
            this.valueNameTextField = new FontAdjust.FontTextField(6);
            this.valueNameTextField.setText(this.valueName);
            this.valueNameTextField.setActionCommand("ValueName");
            this.valueNameTextField.addActionListener(this);
            this.valueNameTextField.addFocusListener(this);
            panel.add(this.valueNameTextField);
            panel.add(Box.createHorizontalStrut(10));
            this.numFormatLabel = new FontAdjust.FontLabel("Format:");
            panel.add(this.numFormatLabel);
            String ddd = "8888888888";
            this.numFormatComboBox = new FontAdjust.FontComboBox<String>();
            int i = 2;
            while (i < 8) {
                this.numFormatComboBox.addItem(ddd.substring(0, i));
                this.numFormatComboBox.addItem("-" + ddd.substring(0, i));
                this.numFormatComboBox.addItem("1" + ddd.substring(0, i));
                this.numFormatComboBox.addItem("-1" + ddd.substring(0, i));
                ++i;
            }
            this.numFormatComboBox.setActionCommand("Format");
            this.numFormatComboBox.addActionListener(this);
            this.numFormatComboBox.setSelectedItem(this.selectedCameraDigits);
            panel.add(this.numFormatComboBox);
            this.spacingSlider = new JSlider(10, 25, this.digitSpacing);
            this.spacingSlider.setPaintLabels(false);
            this.spacingSlider.setPaintTicks(false);
            this.spacingSlider.setPreferredSize(new Dimension(40, 20));
            this.spacingSlider.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    Decoder.this.digitSpacing = Decoder.this.spacingSlider.getValue();
                    Decoder.this.cameraDigits.setDigitSpacing(Decoder.this.digitSpacing);
                }
            });
            panel.add(this.spacingSlider);
            this.showButton = new JButton("Show");
            this.showButton.setActionCommand("Show");
            this.showButton.addActionListener(this);
            panel.add(this.showButton);
            return panel;
        }

        public void saveToList(List<String> list) {
            StringBuilder sb = new StringBuilder();
            sb.append("Index:");
            sb.append(this.index);
            sb.append("|");
            sb.append("ValueName:");
            sb.append(this.valueName);
            sb.append("|");
            sb.append("Format:");
            sb.append(this.selectedCameraDigits);
            sb.append("|");
            sb.append("DigitSpacing:");
            sb.append(this.digitSpacing);
            sb.append("|");
            sb.append("Location:");
            sb.append(this.cameraDigits.location());
            list.add(sb.toString());
            this.cameraDigits.isMoved();
        }

        public void parseList(String line) {
            for (Support.ConfigLineElement element : new Support.ConfigLineSplitter(line)) {
                if (element.name.equals("Index")) {
                    if (element.value.equals("" + this.index)) continue;
                    return;
                }
                if (element.name.equals("ValueName")) {
                    this.valueName = element.value;
                    this.valueNameTextField.setText(this.valueName);
                    continue;
                }
                if (element.name.equals("Format")) {
                    this.selectedCameraDigits = element.value;
                    this.setFormat(this.selectedCameraDigits);
                    continue;
                }
                if (element.name.equals("DigitSpacing")) {
                    this.digitSpacing = Integer.parseInt(element.value);
                    this.spacingSlider.setValue(this.digitSpacing);
                    continue;
                }
                if (!element.name.equals("Location")) continue;
                this.cameraDigits.setLocation(element.value);
            }
        }

        public void setEnabled(boolean enable) {
            this.enabled = enable;
            this.numFormatLabel.setEnabled(enable);
            this.numFormatComboBox.setEnabled(enable);
            this.showButton.setEnabled(enable);
            this.valueNameLabel.setEnabled(enable);
            this.valueNameTextField.setEnabled(enable);
            this.spacingSlider.setEnabled(enable);
            if (!enable) {
                this.closeCamera();
            }
        }

        private void setFormat(String format) {
            this.selectedCameraDigits = format;
            this.numFormatComboBox.setSelectedItem(format);
            this.cameraDigits.setFormat(this.selectedCameraDigits);
            this.updateCamera();
        }

        private void formatSelected() {
            String s = (String)this.numFormatComboBox.getSelectedItem();
            if (!s.equals(this.selectedCameraDigits)) {
                PopupCameraInput.this.changed = true;
            }
            this.selectedCameraDigits = s;
            this.cameraDigits.setFormat(this.selectedCameraDigits);
            this.updateCamera();
        }

        public void updateCamera() {
            if (this.enabled && this.popupCameraSelect != null) {
                this.popupCameraSelect.setCamera(PopupCameraInput.this.webcam);
                this.popupCameraSelect.setDigits(this.cameraDigits);
            }
        }

        private void closeCamera() {
            if (this.popupCameraSelect != null) {
                this.popupCameraSelect.setVisible(false);
                this.popupCameraSelect = null;
            }
        }

        private void showCamera() {
            Decoder[] decoderArray = PopupCameraInput.this.decoder;
            int n = decoderArray.length;
            int n2 = 0;
            while (n2 < n) {
                Decoder dc = decoderArray[n2];
                dc.closeCamera();
                ++n2;
            }
            this.popupCameraSelect = PopupCameraSelect.getPopup(PopupCameraInput.this.webcam);
            this.updateCamera();
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            if (arg0.getActionCommand().equals("Show")) {
                this.showCamera();
            } else if (arg0.getActionCommand().equals("Format")) {
                this.formatSelected();
            } else if (arg0.getActionCommand().equals("ValueName")) {
                String s = this.valueNameTextField.getText().trim().replace(" ", "_");
                while (!s.isEmpty() && Character.isDigit(s.charAt(this.index))) {
                    s = s.substring(1);
                }
                if (!s.equals(this.valueName)) {
                    this.valueNameTextField.setText(s);
                    this.valueName = s;
                    PopupCameraInput.this.changed = true;
                }
            }
            PopupCameraInput.this.saveDefaultSettings();
        }

        @Override
        public void focusGained(FocusEvent arg0) {
        }

        @Override
        public void focusLost(FocusEvent arg0) {
            String cmd = "";
            if (arg0.getSource() == this.valueNameTextField) {
                cmd = "ValueName";
            }
            if (!cmd.isEmpty()) {
                this.actionPerformed(new ActionEvent(arg0.getSource(), arg0.getID(), cmd));
            }
        }
    }

    private class Transformer
    implements WebcamImageTransformer {
        JHFlipFilter filter = null;

        Transformer(String op) {
            if (op.startsWith("CW")) {
                this.filter = new JHFlipFilter(4);
            }
            if (op.contains("180")) {
                this.filter = new JHFlipFilter(6);
            }
            if (op.startsWith("CCW")) {
                this.filter = new JHFlipFilter(5);
            }
        }

        @Override
        public BufferedImage transform(BufferedImage image) {
            if (this.filter == null) {
                return image;
            }
            return this.filter.filter(image, null);
        }
    }
}

