/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.main;

import dk.hkj.main.FontAdjust;
import dk.hkj.main.InterfaceThreads;
import dk.hkj.main.PopupBase;
import dk.hkj.main.PopupVarDisplay;
import dk.hkj.main.Support;
import dk.hkj.script.Script;
import dk.hkj.vars.FormatVar;
import dk.hkj.vars.Var;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.MenuItem;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class PopupCalculator
extends PopupBase
implements ActionListener,
MouseListener,
KeyListener {
    private static PopupCalculator popupCalculator = null;
    private JPanel mainPanel = null;
    private JLabel resultLabel = null;
    private JComboBox<String> inputComboBox = null;
    private Script script;
    private Var lastResult;
    private PopupMenu popupMenu = null;
    private final String inputToolTip = "Write an expression and press ENTER, note that 1 and 1.0 is not the same";
    private String lastExpression = "";
    private long lastTime = 0L;
    DecimalFormat dfEE = new DecimalFormat("0.0##############E0;-0.0##############E0");
    DecimalFormat df4E = new DecimalFormat("0.0###E0;-0.0###E0");
    DecimalFormat df9E = new DecimalFormat("0.0########E0;-0.0########E0");
    DecimalFormat dfE = new DecimalFormat("#########0.0##############;-#########0.0##############");
    DecimalFormat df4 = new DecimalFormat("#########0.0###;-#########0.0###");
    DecimalFormat df9 = new DecimalFormat("#########0.0########;-#########0.0########");

    public PopupCalculator() {
        DecimalFormatSymbols dfs = new DecimalFormatSymbols();
        dfs.setDecimalSeparator('.');
        this.dfEE.setDecimalFormatSymbols(dfs);
        this.df4E.setDecimalFormatSymbols(dfs);
        this.df9E.setDecimalFormatSymbols(dfs);
        this.dfE.setDecimalFormatSymbols(dfs);
        this.df4.setDecimalFormatSymbols(dfs);
        this.df9.setDecimalFormatSymbols(dfs);
        PopupCalculator.closeAll();
        popupCalculator = this;
        this.setTitle("Calculator");
        this.definePopupName("Calculator", true);
        this.setLayout(new BorderLayout());
        this.script = new Script();
        this.add(this.makePanel());
        this.setAlwaysOnTop(true);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowActivated(WindowEvent arg0) {
                PopupCalculator.this.inputComboBox.requestFocusInWindow();
            }
        });
        this.setPreferredSize(new Dimension(600, 100));
        this.pack();
    }

    public static void closeAll() {
        if (popupCalculator != null) {
            popupCalculator.setVisible(false);
        }
    }

    public static PopupCalculator getInstance() {
        return popupCalculator;
    }

    public static boolean reShow() {
        if (popupCalculator != null) {
            popupCalculator.setVisible(true);
        }
        return popupCalculator != null;
    }

    private Component makePanel() {
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new GridBagLayout());
        this.mainPanel.addMouseListener(this);
        GridBagConstraints c = null;
        this.resultLabel = new FontAdjust.FontLabel("--");
        this.resultLabel.setBorder(BorderFactory.createEtchedBorder(1));
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(0, 5, 0, 5);
        c.fill = 2;
        c.weightx = 1.0;
        c.weighty = 1.0;
        this.mainPanel.add((Component)this.resultLabel, c);
        this.resultLabel.addMouseListener(this);
        this.inputComboBox = new FontAdjust.FontComboBox<String>();
        c = new GridBagConstraints();
        this.inputComboBox.setEditable(true);
        this.inputComboBox.addActionListener(this);
        this.inputComboBox.setActionCommand("Calc");
        this.inputComboBox.setMaximumRowCount(20);
        this.inputComboBox.setToolTipText("Write an expression and press ENTER, note that 1 and 1.0 is not the same");
        this.inputComboBox.getEditor().getEditorComponent().addMouseListener(this);
        this.inputComboBox.getEditor().getEditorComponent().addKeyListener(this);
        c.gridx = 0;
        c.gridy = 1;
        c.insets = new Insets(0, 5, 5, 5);
        c.fill = 2;
        c.weightx = 1.0;
        c.weighty = 1.0;
        this.mainPanel.add(this.inputComboBox, c);
        String tip = "The way to show the result, selected format will be used if possible.";
        ButtonGroup grp = new ButtonGroup();
        FontAdjust.FontRadioButton radioButton = new FontAdjust.FontRadioButton("SI");
        c = new GridBagConstraints();
        radioButton.setActionCommand("DSI");
        radioButton.addActionListener(this);
        radioButton.setSelected(true);
        radioButton.setToolTipText(tip);
        grp.add(radioButton);
        c.gridx = 1;
        c.gridy = 0;
        c.insets = new Insets(2, 2, 2, 2);
        this.mainPanel.add((Component)radioButton, c);
        radioButton = new FontAdjust.FontRadioButton("EE");
        c = new GridBagConstraints();
        radioButton.setActionCommand("DEE");
        radioButton.addActionListener(this);
        radioButton.setToolTipText(tip);
        grp.add(radioButton);
        c.gridx = 1;
        c.gridy = 1;
        c.insets = new Insets(2, 2, 2, 2);
        this.mainPanel.add((Component)radioButton, c);
        radioButton = new FontAdjust.FontRadioButton("4");
        c = new GridBagConstraints();
        radioButton.setActionCommand("D4");
        radioButton.addActionListener(this);
        radioButton.setToolTipText(tip);
        grp.add(radioButton);
        c.gridx = 2;
        c.gridy = 0;
        c.insets = new Insets(2, 2, 2, 2);
        this.mainPanel.add((Component)radioButton, c);
        radioButton = new FontAdjust.FontRadioButton("9");
        c = new GridBagConstraints();
        radioButton.setActionCommand("D9");
        radioButton.addActionListener(this);
        radioButton.setToolTipText(tip);
        grp.add(radioButton);
        c.gridx = 2;
        c.gridy = 1;
        c.insets = new Insets(2, 2, 2, 2);
        this.mainPanel.add((Component)radioButton, c);
        radioButton = new FontAdjust.FontRadioButton("Int");
        c = new GridBagConstraints();
        radioButton.setActionCommand("DInt");
        radioButton.addActionListener(this);
        radioButton.setToolTipText(tip);
        grp.add(radioButton);
        c.gridx = 3;
        c.gridy = 0;
        c.insets = new Insets(2, 2, 2, 2);
        this.mainPanel.add((Component)radioButton, c);
        radioButton = new FontAdjust.FontRadioButton("Str");
        c = new GridBagConstraints();
        radioButton.setActionCommand("DStr");
        radioButton.addActionListener(this);
        radioButton.setToolTipText(tip);
        grp.add(radioButton);
        c.gridx = 3;
        c.gridy = 1;
        c.insets = new Insets(2, 2, 2, 2);
        this.mainPanel.add((Component)radioButton, c);
        radioButton = new FontAdjust.FontRadioButton("HEX");
        c = new GridBagConstraints();
        radioButton.setActionCommand("DHex");
        radioButton.addActionListener(this);
        radioButton.setToolTipText(tip);
        grp.add(radioButton);
        c.gridx = 4;
        c.gridy = 0;
        c.insets = new Insets(2, 2, 2, 2);
        this.mainPanel.add((Component)radioButton, c);
        radioButton = new FontAdjust.FontRadioButton("BIN");
        c = new GridBagConstraints();
        radioButton.setActionCommand("DBin");
        radioButton.addActionListener(this);
        radioButton.setToolTipText(tip);
        grp.add(radioButton);
        c.gridx = 4;
        c.gridy = 1;
        c.insets = new Insets(2, 2, 2, 2);
        this.mainPanel.add((Component)radioButton, c);
        this.popupMenu = new PopupMenu();
        MenuItem mi = new MenuItem("Result to clipboard");
        mi.addActionListener(this);
        mi.setActionCommand("clipboard");
        this.popupMenu.add(mi);
        mi = new MenuItem("To log window");
        mi.addActionListener(this);
        mi.setActionCommand("log");
        this.popupMenu.add(mi);
        mi = new MenuItem("Result popup");
        mi.addActionListener(this);
        mi.setActionCommand("ResultPopup");
        this.popupMenu.add(mi);
        this.mainPanel.add(this.popupMenu);
        return this.mainPanel;
    }

    public void display(Var v) {
        this.resultLabel.setText(FormatVar.getDefault().formatVar(v));
        if (PopupVarDisplay.isPopupVisible()) {
            PopupVarDisplay.showVar(FormatVar.getDefault().formatVarAsList(v));
        }
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        if (arg0.getActionCommand().equals("Calc") || arg0.getActionCommand().equals("comboBoxEdited")) {
            String s = (String)this.inputComboBox.getEditor().getItem();
            try {
                if (s.equals(this.lastExpression) && System.currentTimeMillis() - this.lastTime < 1000L) {
                    return;
                }
                this.lastResult = s.equals("InternalVarList") ? Var.gl : this.script.execute(s);
                this.lastExpression = s;
                this.lastTime = System.currentTimeMillis();
                this.inputComboBox.getEditor().getEditorComponent().setBackground(Support.colorScheme.textBackground);
                this.display(this.lastResult);
                ((JTextField)this.inputComboBox.getEditor().getEditorComponent()).selectAll();
                this.inputComboBox.setToolTipText("Write an expression and press ENTER, note that 1 and 1.0 is not the same");
                if (!this.inputComboBox.isPopupVisible()) {
                    int i = 0;
                    while (i < this.inputComboBox.getItemCount()) {
                        if (this.inputComboBox.getItemAt(i).equals(s)) {
                            return;
                        }
                        ++i;
                    }
                    if (this.inputComboBox.getItemCount() > 50) {
                        this.inputComboBox.removeItemAt(50);
                    }
                    this.inputComboBox.insertItemAt(s, 0);
                }
            }
            catch (Exception e) {
                this.inputComboBox.getEditor().getEditorComponent().setBackground(Support.colorScheme.errorBackground);
                this.inputComboBox.setToolTipText(e.getMessage());
                e.printStackTrace(System.out);
            }
        } else if (arg0.getActionCommand().equals("DSI")) {
            FormatVar.getDefault().setFormat(FormatVar.DisplayFormat.DSI);
            FormatVar.getDefault().setDecimals(-1);
            this.display(this.lastResult);
        } else if (arg0.getActionCommand().equals("DEE")) {
            FormatVar.getDefault().setFormat(FormatVar.DisplayFormat.DE);
            FormatVar.getDefault().setDecimals(9);
            this.display(this.lastResult);
        } else if (arg0.getActionCommand().equals("D9")) {
            FormatVar.getDefault().setFormat(FormatVar.DisplayFormat.DX);
            FormatVar.getDefault().setDecimals(9);
            this.display(this.lastResult);
        } else if (arg0.getActionCommand().equals("D4")) {
            FormatVar.getDefault().setFormat(FormatVar.DisplayFormat.DX);
            FormatVar.getDefault().setDecimals(4);
            this.display(this.lastResult);
        } else if (arg0.getActionCommand().equals("DHex")) {
            FormatVar.getDefault().setFormat(FormatVar.DisplayFormat.DHex);
            this.display(this.lastResult);
        } else if (arg0.getActionCommand().equals("DBin")) {
            FormatVar.getDefault().setFormat(FormatVar.DisplayFormat.DBin);
            this.display(this.lastResult);
        } else if (arg0.getActionCommand().equals("DInt")) {
            FormatVar.getDefault().setFormat(FormatVar.DisplayFormat.DInt);
            this.display(this.lastResult);
        } else if (arg0.getActionCommand().equals("DStr")) {
            FormatVar.getDefault().setFormat(FormatVar.DisplayFormat.DStr);
            this.display(this.lastResult);
        } else if (arg0.getActionCommand().equals("clipboard")) {
            StringSelection stringSelection = new StringSelection(this.resultLabel.getText());
            Clipboard clpbrd = Toolkit.getDefaultToolkit().getSystemClipboard();
            clpbrd.setContents(stringSelection, null);
        } else if (arg0.getActionCommand().equals("log")) {
            String s = (String)this.inputComboBox.getEditor().getItem();
            InterfaceThreads.log(";; Calculator: " + s + " -> " + this.resultLabel.getText());
        } else if (arg0.getActionCommand().equals("ResultPopup")) {
            Point p = this.getLocationOnScreen();
            p.y -= 100;
            if (p.y < 0) {
                p.y = 0;
            }
            new PopupVarDisplay(p);
            this.display(this.lastResult);
            this.inputComboBox.requestFocusInWindow();
            this.inputComboBox.requestFocus();
        }
    }

    @Override
    public void mouseClicked(MouseEvent arg0) {
    }

    @Override
    public void mouseEntered(MouseEvent arg0) {
    }

    @Override
    public void mouseExited(MouseEvent arg0) {
    }

    @Override
    public void mousePressed(MouseEvent arg0) {
        if (arg0.isPopupTrigger()) {
            this.popupMenu.show(this.resultLabel, arg0.getX(), arg0.getY());
        }
    }

    @Override
    public void mouseReleased(MouseEvent arg0) {
        if (arg0.isPopupTrigger()) {
            this.popupMenu.show(this.resultLabel, arg0.getX(), arg0.getY());
        }
    }

    @Override
    public void keyPressed(KeyEvent arg0) {
        if (arg0.getKeyCode() == 525) {
            this.popupMenu.show(this.resultLabel, (int)this.inputComboBox.getLocation().getX(), (int)this.inputComboBox.getLocation().getY());
        }
    }

    @Override
    public void keyReleased(KeyEvent arg0) {
    }

    @Override
    public void keyTyped(KeyEvent arg0) {
    }

    public static List<String> generateScript() {
        ArrayList<String> list = new ArrayList<String>();
        if (popupCalculator != null && popupCalculator.isVisible()) {
            list.add("#ShowPopupSystem Calculator " + popupCalculator.generateLocationParams());
        }
        return list;
    }

    public static void alignGridAll(int pixels) {
        if (popupCalculator != null && popupCalculator.isVisible()) {
            popupCalculator.alignGrid(pixels);
        }
    }

    private static enum DisplayFormat {
        DSI,
        DE,
        D4,
        D9,
        DInt,
        DStr,
        DHex,
        DBin;

    }
}

