/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.main;

import dk.hkj.main.Main;
import dk.hkj.main.Support;
import dk.hkj.util.FileUtil;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JDialog;
import javax.swing.Timer;

public class PopupBase
extends JDialog {
    private String popupName;
    private Timer timer = null;
    private Point overrideLocation = null;
    private Point overrideSize = null;
    private boolean noSave = false;
    private static Timer saveTimer = new Timer(1000, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            PopupBase.saveDefault();
            saveTimer.stop();
        }
    });
    private boolean saveSize = false;
    private boolean isInitialized = false;
    private static List<PopupLocation> popupLocations = null;

    protected PopupBase() {
        this.setIconImage(Main.main.frame.getIconImage());
        this.timer = new Timer(100, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                PopupBase.this.timer = null;
                if (PopupBase.this.overrideLocation != null) {
                    if (((PopupBase)PopupBase.this).overrideLocation.x < -50) {
                        ((PopupBase)PopupBase.this).overrideLocation.x = -50;
                    }
                    if (((PopupBase)PopupBase.this).overrideLocation.y < -50) {
                        ((PopupBase)PopupBase.this).overrideLocation.y = -50;
                    }
                    PopupBase.this.setLocation(((PopupBase)PopupBase.this).overrideLocation.x, ((PopupBase)PopupBase.this).overrideLocation.y);
                    if (PopupBase.this.saveSize) {
                        if (PopupBase.this.overrideSize != null) {
                            PopupBase.this.setSize(((PopupBase)PopupBase.this).overrideSize.x, ((PopupBase)PopupBase.this).overrideSize.y);
                        } else {
                            PopupLocation pl = PopupLocation.findElement(PopupBase.this.popupName);
                            if (pl.w > 0 && pl.h > 0) {
                                PopupBase.this.setSize(pl.w, pl.h);
                            }
                        }
                    }
                } else if (PopupBase.this.popupName.length() > 0 && !PopupBase.this.isInitialized) {
                    PopupLocation pl = PopupLocation.findElement(PopupBase.this.popupName);
                    if (pl.x >= -100 && pl.y >= -100 && Support.systemSettings.restorePopupLocations) {
                        PopupBase.this.setLocation(pl.x, pl.y);
                        if (PopupBase.this.saveSize) {
                            PopupBase.this.setSize(pl.w, pl.h);
                        }
                    }
                }
                PopupBase.this.isInitialized = true;
            }
        });
        this.timer.setInitialDelay(10);
        this.timer.setRepeats(false);
        this.timer.start();
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentMoved(ComponentEvent arg0) {
                if (popupLocations == null || !PopupBase.this.isInitialized) {
                    return;
                }
                if (!PopupBase.this.isShowing()) {
                    return;
                }
                if (PopupBase.this.noSave) {
                    return;
                }
                PopupLocation pl = PopupLocation.findElement(PopupBase.this.popupName);
                pl.x = PopupBase.this.getLocationOnScreen().x;
                pl.y = PopupBase.this.getLocationOnScreen().y;
                pl.w = PopupBase.this.getSize().width;
                pl.h = PopupBase.this.getSize().height;
                saveTimer.restart();
            }

            @Override
            public void componentResized(ComponentEvent arg0) {
                if (popupLocations == null || !PopupBase.this.isInitialized) {
                    return;
                }
                if (!PopupBase.this.isShowing()) {
                    return;
                }
                PopupLocation pl = PopupLocation.findElement(PopupBase.this.popupName);
                if (PopupBase.this.noSave) {
                    return;
                }
                pl.x = PopupBase.this.getLocationOnScreen().x;
                pl.y = PopupBase.this.getLocationOnScreen().y;
                pl.w = PopupBase.this.getSize().width;
                pl.h = PopupBase.this.getSize().height;
                saveTimer.restart();
            }
        });
    }

    public String generateLocationParams() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getLocationOnScreen().x);
        sb.append(" ");
        sb.append(this.getLocationOnScreen().y);
        if (this.saveSize) {
            sb.append(" ");
            sb.append(this.getSize().width);
            sb.append(" ");
            sb.append(this.getSize().height);
        }
        return sb.toString();
    }

    public void disableSaveLocation() {
        this.noSave = true;
    }

    protected void definePopupName(String name, boolean saveSize) {
        this.popupName = name;
        this.saveSize = saveSize;
        Support.addUsedFunction(name);
    }

    public void setOverrideLocation(int x, int y) {
        if (this.isInitialized) {
            if (x < -50) {
                x = -50;
            }
            if (y < -50) {
                y = -50;
            }
            this.setLocation(x, y);
        } else {
            this.overrideLocation = new Point(x, y);
        }
    }

    public void setOverrideLocation(int x, int y, int w, int h) {
        if (this.isInitialized) {
            if (x < -50) {
                x = -50;
            }
            if (y < -50) {
                y = -50;
            }
            this.setLocation(x, y);
            this.setSize(w, h);
        } else {
            this.overrideLocation = new Point(x, y);
            this.overrideSize = new Point(w, h);
        }
    }

    public static void saveToFile(File file) {
        ArrayList<String> list = new ArrayList<String>();
        for (PopupLocation pl : popupLocations) {
            list.add(pl.toString());
        }
        try {
            FileUtil.writeFile(file, list);
        }
        catch (IOException iOException) {}
    }

    public static void loadFromFile(File file) {
        try {
            List<String> list = FileUtil.readFileAsList(file);
            for (String line : list) {
                if (line.trim().length() <= 0) continue;
                popupLocations.add(new PopupLocation(line));
            }
        }
        catch (IOException iOException) {}
    }

    public void setOnTop(boolean onTop) {
        this.setAlwaysOnTop(onTop);
    }

    public void alignGrid(int pixels) {
        int x = this.getLocationOnScreen().x / pixels * pixels + (pixels - 1) / 2;
        int y = this.getLocationOnScreen().y / pixels * pixels + (pixels - 1) / 2;
        this.setOverrideLocation(x, y);
    }

    public boolean isOnTop() {
        return this.isAlwaysOnTop();
    }

    public static void saveDefault() {
        PopupBase.saveToFile(new File(String.valueOf(Support.getConfigPath()) + "/settingsPopups.txt"));
    }

    public static void loadDefault() {
        PopupBase.loadFromFile(new File(String.valueOf(Support.getConfigPath()) + "/settingsPopups.txt"));
    }

    private static class PopupLocation {
        String name;
        int x = -1000;
        int y = -1000;
        int w = -1000;
        int h = -1000;

        PopupLocation() {
        }

        static PopupLocation findElement(String name) {
            PopupLocation pl2;
            if (popupLocations == null) {
                popupLocations = new ArrayList();
                PopupBase.loadDefault();
            }
            for (PopupLocation pl2 : popupLocations) {
                if (!pl2.name.equals(name)) continue;
                return pl2;
            }
            pl2 = new PopupLocation();
            pl2.name = name;
            popupLocations.add(pl2);
            return pl2;
        }

        PopupLocation(String line) {
            for (Support.ConfigLineElement element : new Support.ConfigLineSplitter(line)) {
                if (element.name.equals("Name")) {
                    this.name = element.value;
                    continue;
                }
                if (element.name.equals("x")) {
                    this.x = Integer.parseInt(element.value);
                    continue;
                }
                if (element.name.equals("y")) {
                    this.y = Integer.parseInt(element.value);
                    continue;
                }
                if (element.name.equals("h")) {
                    this.h = Integer.parseInt(element.value);
                    continue;
                }
                if (!element.name.equals("w")) continue;
                this.w = Integer.parseInt(element.value);
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("Name:");
            sb.append(this.name);
            sb.append("|x:");
            sb.append(this.x);
            sb.append("|y:");
            sb.append(this.y);
            sb.append("|w:");
            sb.append(this.w);
            sb.append("|h:");
            sb.append(this.h);
            sb.append("|");
            return sb.toString();
        }
    }
}

