/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.main;

import dk.hkj.main.AutoHold;
import dk.hkj.main.FontAdjust;
import dk.hkj.main.InterfaceThreads;
import dk.hkj.main.PopupBase;
import dk.hkj.main.Support;
import dk.hkj.main.ValueFormat;
import dk.hkj.util.MySwingUtil;
import dk.hkj.util.StringUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.Timer;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

public class PopupAutoHold
extends PopupBase
implements ActionListener,
FocusListener,
TableModel {
    private static PopupAutoHold popupAutoHold = null;
    private String selectedChannelName = "";
    protected ValueFormat fmt = new ValueFormat("??", "", ValueFormat.formatD2);
    protected AutoHold ah = new AutoHold(this);
    private JComboBox<String> channelComboBox;
    private JTextField toleranceTextField;
    private JTextField lockTimeTextField;
    private JTextField minValueTextField;
    private JLabel currentValueLabel;
    private JTable table;
    private Timer timer;
    private List<TableModelListener> listeners = new ArrayList<TableModelListener>();
    private JPopupMenu popupMenu;

    public static void set(String channel, double tol, double lockTime, double min) {
        PopupAutoHold.getPopup();
        if (channel != null && channel.length() > 0) {
            popupAutoHold.setChannel(channel);
        }
        if (!Double.isNaN(tol)) {
            PopupAutoHold.popupAutoHold.ah.setTolerance(tol);
        }
        if (!Double.isNaN(lockTime)) {
            PopupAutoHold.popupAutoHold.ah.setLockTime(lockTime);
        }
        if (!Double.isNaN(min)) {
            PopupAutoHold.popupAutoHold.ah.setMinValue(min);
        }
        popupAutoHold.fillTextFields();
    }

    private PopupAutoHold() {
        this.setPreferredSize(new Dimension(250, 300));
        popupAutoHold = this;
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent e) {
                if (popupAutoHold == PopupAutoHold.this) {
                    if (PopupAutoHold.this.timer != null) {
                        PopupAutoHold.this.timer.stop();
                        PopupAutoHold.this.timer = null;
                    }
                    Support.math.removeDomain("AutoHold");
                    PopupAutoHold.popupAutoHold = null;
                }
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                if (popupAutoHold == PopupAutoHold.this) {
                    if (PopupAutoHold.this.timer != null) {
                        PopupAutoHold.this.timer.stop();
                        PopupAutoHold.this.timer = null;
                    }
                    Support.math.removeDomain("AutoHold");
                    PopupAutoHold.popupAutoHold = null;
                }
            }
        });
        this.setAlwaysOnTop(true);
        this.setTitle("Auto hold");
        this.setDefaultCloseOperation(2);
        this.definePopupName("AutoHold", true);
        this.popupMenu = new JPopupMenu();
        this.getLayeredPane().setComponentPopupMenu(this.popupMenu);
        this.popupMenu.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuCanceled(PopupMenuEvent arg0) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent arg0) {
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent arg0) {
                PopupAutoHold.this.makePopupMenu();
            }
        });
        int n = 0;
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = null;
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = n++;
        c.gridwidth = 4;
        c.anchor = 11;
        c.fill = 2;
        c.insets = new Insets(2, 5, 2, 5);
        this.currentValueLabel = new FontAdjust.FontLabel();
        ((FontAdjust.FontLabel)this.currentValueLabel).setLargeFont(true);
        this.currentValueLabel.setHorizontalAlignment(0);
        this.currentValueLabel.setInheritsPopupMenu(true);
        this.currentValueLabel.setComponentPopupMenu(this.popupMenu);
        this.currentValueLabel.setFocusable(true);
        this.currentValueLabel.requestFocusInWindow();
        this.currentValueLabel.requestFocus();
        this.add((Component)this.currentValueLabel, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = n++;
        c.gridwidth = 4;
        c.anchor = 17;
        c.fill = 1;
        c.weightx = 1.0;
        c.insets = new Insets(2, 5, 2, 5);
        this.channelComboBox = new FontAdjust.FontComboBox<String>();
        this.channelComboBox.addActionListener(this);
        this.channelComboBox.setComponentPopupMenu(this.popupMenu);
        this.channelComboBox.setActionCommand("channel");
        this.channelComboBox.setMaximumRowCount(20);
        this.fillChannels();
        if (this.channelComboBox.getItemCount() > 0) {
            this.channelComboBox.setSelectedIndex(0);
        }
        this.add(this.channelComboBox, c);
        this.channelComboBox.setInheritsPopupMenu(true);
        Dimension dim = new Dimension(50, 20);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = n;
        c.anchor = 13;
        c.weightx = 1.0;
        c.insets = new Insets(2, 5, 2, 5);
        this.add((Component)new FontAdjust.FontLabel("Tol (%): "), c);
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = n;
        c.anchor = 17;
        c.insets = new Insets(2, 5, 2, 5);
        this.toleranceTextField = new FontAdjust.FontTextField(6);
        this.toleranceTextField.setMinimumSize(dim);
        this.toleranceTextField.setToolTipText("Tolerance in percent");
        this.toleranceTextField.addActionListener(this);
        this.toleranceTextField.addFocusListener(this);
        this.toleranceTextField.setComponentPopupMenu(this.popupMenu);
        this.toleranceTextField.setInheritsPopupMenu(true);
        this.add((Component)this.toleranceTextField, c);
        c = new GridBagConstraints();
        c.gridx = 2;
        c.gridy = n;
        c.weightx = 1.0;
        c.anchor = 13;
        c.insets = new Insets(2, 5, 2, 5);
        this.add((Component)new FontAdjust.FontLabel("Time: "), c);
        c = new GridBagConstraints();
        c.gridx = 3;
        c.gridy = n++;
        c.anchor = 17;
        c.insets = new Insets(2, 5, 2, 5);
        this.lockTimeTextField = new FontAdjust.FontTextField(6);
        this.lockTimeTextField.setMinimumSize(dim);
        this.lockTimeTextField.addActionListener(this);
        this.lockTimeTextField.addFocusListener(this);
        this.lockTimeTextField.setComponentPopupMenu(this.popupMenu);
        this.lockTimeTextField.setInheritsPopupMenu(true);
        this.add((Component)this.lockTimeTextField, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = n;
        c.anchor = 13;
        c.insets = new Insets(2, 5, 2, 5);
        this.add((Component)new FontAdjust.FontLabel("Min: "), c);
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = n;
        c.anchor = 17;
        c.insets = new Insets(2, 5, 2, 5);
        this.minValueTextField = new FontAdjust.FontTextField(6);
        this.minValueTextField.setMinimumSize(dim);
        this.minValueTextField.addActionListener(this);
        this.minValueTextField.addFocusListener(this);
        this.minValueTextField.setComponentPopupMenu(this.popupMenu);
        this.minValueTextField.setInheritsPopupMenu(true);
        this.add((Component)this.minValueTextField, c);
        c = new GridBagConstraints();
        c.gridx = 2;
        c.gridwidth = 2;
        c.gridy = n++;
        c.anchor = 10;
        c.insets = new Insets(2, 5, 2, 5);
        FontAdjust.FontButton resetButton = new FontAdjust.FontButton("Reset");
        resetButton.setActionCommand("reset");
        resetButton.setComponentPopupMenu(this.popupMenu);
        resetButton.addActionListener(this);
        this.add((Component)resetButton, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = n++;
        c.gridwidth = 4;
        c.weightx = 10.0;
        c.weighty = 10.0;
        c.anchor = 18;
        c.fill = 1;
        c.insets = new Insets(2, 5, 2, 5);
        this.table = new FontAdjust.FontTable(){

            @Override
            public Component prepareRenderer(TableCellRenderer renderer, int row, int col) {
                JComponent comp = (JComponent)super.prepareRenderer(renderer, row, col);
                boolean sel = comp.getBackground().equals(Support.colorScheme.selectedCellbackground);
                if (!sel) {
                    comp.setBackground((this.getRowCount() - row) % 4 == 0 ? Support.colorScheme.tableGridAlternateBackground : Support.colorScheme.textBackground);
                }
                if (comp instanceof JLabel) {
                    ((JLabel)comp).setHorizontalAlignment(0);
                }
                return comp;
            }
        };
        this.table.setModel(this);
        this.table.setComponentPopupMenu(this.popupMenu);
        this.table.getTableHeader().setReorderingAllowed(false);
        this.table.getTableHeader().setComponentPopupMenu(this.popupMenu);
        this.table.getTableHeader().setInheritsPopupMenu(true);
        this.table.setInheritsPopupMenu(true);
        JScrollPane sp = new JScrollPane(this.table);
        sp.setInheritsPopupMenu(true);
        this.add((Component)sp, c);
        this.fillTextFields();
        this.timer = new Timer(200, this);
        this.timer.setActionCommand("timer");
        this.timer.start();
        MySwingUtil.addKeyListenerAll(this, new KeyListener(){

            @Override
            public void keyPressed(KeyEvent arg0) {
            }

            @Override
            public void keyReleased(KeyEvent arg0) {
            }

            @Override
            public void keyTyped(KeyEvent arg0) {
                if (arg0.getKeyChar() == ' ') {
                    PopupAutoHold.this.ah.addSampleDirect();
                    PopupAutoHold.this.fireInsert();
                }
            }
        });
        this.pack();
    }

    private void makePopupMenu() {
        this.popupMenu.removeAll();
        JMenuItem mi = new FontAdjust.FontMenuItem("Number to clipboard");
        mi.setActionCommand("numclip");
        mi.addActionListener(this);
        this.popupMenu.add(mi);
        mi = new FontAdjust.FontMenuItem("Text to clipboard");
        mi.setActionCommand("textclip");
        mi.addActionListener(this);
        this.popupMenu.add(mi);
        FontAdjust.FontMenu menu = new FontAdjust.FontMenu("Type measurement");
        menu.setToolTipText("For this to work the cursor must be in another program that can accept the typed measurement");
        this.popupMenu.add(menu);
        mi = new FontAdjust.FontRadioButtonMenuItem("No");
        if (this.ah.getTypeOption() == AutoHold.TypeOption.None) {
            mi.setSelected(true);
        }
        mi.setActionCommand("type:no");
        mi.addActionListener(this);
        menu.add(mi);
        this.popupMenu.add(menu);
        mi = new FontAdjust.FontRadioButtonMenuItem("With Enter");
        if (this.ah.getTypeOption() == AutoHold.TypeOption.WithEnter) {
            mi.setSelected(true);
        }
        mi.setActionCommand("type:enter");
        mi.addActionListener(this);
        menu.add(mi);
        this.popupMenu.add(menu);
        mi = new FontAdjust.FontRadioButtonMenuItem("With down arrow");
        if (this.ah.getTypeOption() == AutoHold.TypeOption.WithDown) {
            mi.setSelected(true);
        }
        mi.setActionCommand("type:down");
        mi.addActionListener(this);
        menu.add(mi);
        this.popupMenu.add(menu);
        mi = new FontAdjust.FontRadioButtonMenuItem("With right arrow");
        if (this.ah.getTypeOption() == AutoHold.TypeOption.WithRight) {
            mi.setSelected(true);
        }
        mi.setActionCommand("type:right");
        mi.addActionListener(this);
        menu.add(mi);
        mi = new FontAdjust.FontRadioButtonMenuItem("With tab");
        if (this.ah.getTypeOption() == AutoHold.TypeOption.WithTab) {
            mi.setSelected(true);
        }
        mi.setActionCommand("type:tab");
        mi.addActionListener(this);
        menu.add(mi);
    }

    private void parseTextFields() {
        double a = StringUtil.parseDoubleEE(this.toleranceTextField.getText());
        if (!Double.isNaN(a)) {
            this.ah.setTolerance(a / 100.0);
        }
        if (!Double.isNaN(a = StringUtil.parseDoubleEE(this.lockTimeTextField.getText()))) {
            this.ah.setLockTime(a);
        }
        if (!Double.isNaN(a = StringUtil.parseDoubleEE(this.minValueTextField.getText()))) {
            this.ah.setMinValue(a);
        }
    }

    private void fillTextFields() {
        if (this.selectedChannelName != null) {
            this.channelComboBox.setSelectedItem(this.selectedChannelName);
        }
        this.toleranceTextField.setText(StringUtil.formatDoubleEE(this.ah.getTolerance() * 100.0, false));
        this.lockTimeTextField.setText(StringUtil.formatDoubleEE(this.ah.getLockTime(), false));
        this.minValueTextField.setText(StringUtil.formatDoubleEE(this.ah.getMinValue(), false));
    }

    protected void toClipboard(String data) {
        Clipboard clpbrd = Toolkit.getDefaultToolkit().getSystemClipboard();
        StringSelection stringSelection = new StringSelection(data);
        clpbrd.setContents(stringSelection, null);
    }

    private void reset() {
        this.ah.reset();
        Support.math.resetCalc("AutoHold");
        this.fireDelete();
    }

    private void setChannel(String channel) {
        this.selectedChannelName = channel;
        this.fmt = InterfaceThreads.findValueFormat(this.selectedChannelName);
        this.reset();
    }

    @Override
    public void actionPerformed(ActionEvent cmd) {
        if (cmd.getActionCommand().equals("channel")) {
            this.setChannel((String)this.channelComboBox.getSelectedItem());
        } else if (cmd.getActionCommand().equals("timer")) {
            this.timerUpdate();
        } else if (cmd.getActionCommand().equals("reset")) {
            this.reset();
        } else if (cmd.getActionCommand().equals("numclip")) {
            StringBuilder sb = new StringBuilder();
            for (double d : this.ah.getSampleList()) {
                sb.append(Double.toString(d).replace('.', DecimalFormatSymbols.getInstance().getDecimalSeparator()));
                sb.append("\n");
            }
            this.toClipboard(sb.toString());
        } else if (cmd.getActionCommand().equals("textclip")) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.selectedChannelName);
            sb.append("\n");
            int i = 0;
            while (i < this.ah.getSampleList().size()) {
                sb.append(i + 1);
                sb.append('\t');
                sb.append(String.valueOf(this.fmt.format.formatDisplay(this.ah.getSampleList().get(i))) + this.fmt.unit);
                sb.append("\n");
                ++i;
            }
            this.toClipboard(sb.toString());
        } else if (cmd.getActionCommand().equals("type:no")) {
            this.ah.setTypeOption(AutoHold.TypeOption.None);
        } else if (cmd.getActionCommand().equals("type:enter")) {
            this.ah.setTypeOption(AutoHold.TypeOption.WithEnter);
        } else if (cmd.getActionCommand().equals("type:down")) {
            this.ah.setTypeOption(AutoHold.TypeOption.WithDown);
        } else if (cmd.getActionCommand().equals("type:right")) {
            this.ah.setTypeOption(AutoHold.TypeOption.WithRight);
        } else if (cmd.getActionCommand().equals("type:tab")) {
            this.ah.setTypeOption(AutoHold.TypeOption.WithTab);
        } else {
            this.parseTextFields();
        }
    }

    private void timerUpdate() {
        InterfaceThreads.setupVars();
        double v = Support.math.getChannelValue(this.selectedChannelName, "AutoHold");
        if (!Double.isNaN(v)) {
            this.currentValueLabel.setText(String.valueOf(this.fmt.format.formatDisplay(v)) + this.fmt.unit);
            if (this.ah.newValue(v)) {
                this.fireInsert();
            }
        }
    }

    private void fillChannels() {
        Object sel = this.channelComboBox.getSelectedItem();
        this.channelComboBox.removeAllItems();
        for (String s : InterfaceThreads.listChannels(true)) {
            this.channelComboBox.addItem(s);
        }
        this.channelComboBox.setSelectedItem(sel);
    }

    @Override
    public void focusGained(FocusEvent arg0) {
        if (arg0.getSource() instanceof JTextField) {
            ((JTextField)arg0.getSource()).selectAll();
        }
    }

    @Override
    public void focusLost(FocusEvent arg0) {
        this.parseTextFields();
    }

    public static synchronized void closeAll() {
        if (popupAutoHold != null) {
            popupAutoHold.setVisible(false);
            popupAutoHold = null;
        }
    }

    @Override
    public void addTableModelListener(TableModelListener arg0) {
        this.listeners.add(arg0);
    }

    @Override
    public Class<?> getColumnClass(int column) {
        return column == 0 ? Integer.class : String.class;
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public String getColumnName(int column) {
        return column == 0 ? "Index" : "Samples";
    }

    @Override
    public int getRowCount() {
        return this.ah.getSampleList().size();
    }

    @Override
    public Object getValueAt(int row, int column) {
        switch (column) {
            case 0: {
                return this.ah.getSampleList().size() - row;
            }
            case 1: {
                return String.valueOf(this.fmt.format.formatDisplay(this.ah.getSampleList().get(this.ah.getSampleList().size() - row - 1))) + this.fmt.unit;
            }
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int arg0, int arg1) {
        return false;
    }

    @Override
    public void removeTableModelListener(TableModelListener arg0) {
        this.listeners.remove(arg0);
    }

    @Override
    public void setValueAt(Object arg0, int arg1, int arg2) {
    }

    public void fireInsert() {
        for (TableModelListener tml : this.listeners) {
            tml.tableChanged(new TableModelEvent(this, this.getRowCount(), this.getRowCount(), -1, 1));
        }
    }

    public void fireDelete() {
        for (TableModelListener tml : this.listeners) {
            tml.tableChanged(new TableModelEvent(this, 0, this.getRowCount(), -1, -1));
        }
    }

    public static PopupAutoHold getPopup() {
        if (popupAutoHold != null) {
            popupAutoHold.requestFocus();
            return popupAutoHold;
        }
        popupAutoHold = new PopupAutoHold();
        Point p = Support.paneCommand.popupsButton.getLocationOnScreen();
        p.translate(-750, -500);
        if (p.y < 0) {
            p.y = 0;
        }
        if (p.x < 0) {
            p.x = 0;
        }
        popupAutoHold.setLocation(p);
        popupAutoHold.setVisible(true);
        return popupAutoHold;
    }

    public static List<String> generateScript() {
        ArrayList<String> list = new ArrayList<String>();
        if (popupAutoHold != null) {
            list.add("#ShowPopupSystem AutoHold " + popupAutoHold.generateLocationParams());
            list.add("#AutoHold " + PopupAutoHold.popupAutoHold.selectedChannelName + " " + PopupAutoHold.popupAutoHold.ah.generateParams());
        }
        return list;
    }

    public static void alignGridAll(int pixels) {
        if (popupAutoHold != null) {
            popupAutoHold.alignGrid(pixels);
        }
    }
}

