/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.main;

import dk.hkj.devices.SetupFormatsAdjuster;
import dk.hkj.main.FontAdjust;
import dk.hkj.main.Indicator;
import dk.hkj.main.InterfaceThreads;
import dk.hkj.main.PopupBase;
import dk.hkj.main.Support;
import dk.hkj.main.ValueFormat;
import dk.hkj.util.StringUtil;
import dk.hkj.vars.Var;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.Timer;

public class PopupAutoAdjust
extends PopupBase
implements ActionListener,
FocusListener {
    private static PopupAutoAdjust popupAutoAdjust = null;
    private Timer timer = null;
    private JComboBox<SetupFormatsAdjuster.AdjustParam> controlComboBox = null;
    private JTextField minTextField = null;
    private JTextField maxTextField = null;
    private JTextField minChangeTextField = null;
    private JTextField updateSpeedTextField = null;
    private JComboBox<String> targetComboBox = null;
    private JRadioButton minRadio = null;
    private JRadioButton maxRadio = null;
    private JRadioButton valueRadio = null;
    private JTextField targetTextField = null;
    private Indicator indicator = null;
    private JButton startButton = null;
    private JButton stopButton = null;
    private JLabel controlLabel = null;
    private JLabel targetLabel = null;
    private JLabel errorLabel = null;
    private double minParamControl = 0.0;
    private double maxParamControl = 0.0;
    private double minControl = 0.01;
    private double maxControl = 10.0;
    private double lastControl = 0.0;
    private double dxControl = 0.0;
    private Phase phase = Phase.Idle;
    private Function function = Function.Min;
    private boolean direction = true;
    private double minChange = 1.0;
    private double updateSpeed = 2.0;
    private double targetSetting = 0.0;
    private ValueFormat fmtTarget = null;
    private double targetValue = 0.0;
    private double targetLow = 0.0;
    private double targetMid = 0.0;
    private double targetHigh = 0.0;
    private boolean active = false;
    private SetupFormatsAdjuster.AdjustParam controlParam = null;
    private String targetParam = null;
    private long displayTimer = 0L;
    private long controlTimer = 0L;

    private PopupAutoAdjust() {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                if (PopupAutoAdjust.this.timer != null) {
                    PopupAutoAdjust.this.timer.stop();
                    PopupAutoAdjust.this.timer = null;
                }
                PopupAutoAdjust.popupAutoAdjust = null;
            }
        });
        this.setPreferredSize(new Dimension(370, 270));
        this.setSize(new Dimension(370, 270));
        this.setTitle("Auto adjust");
        this.setDefaultCloseOperation(2);
        this.definePopupName("AutoAdjusts", true);
        this.setOnTop(true);
        this.layoutForm();
        this.timer = new Timer(100, this);
        this.timer.setActionCommand("Timer");
        this.timer.start();
    }

    private void layoutForm() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = null;
        Dimension dd = new Dimension(50, 20);
        int n = 0;
        JPanel readoutPanel = new JPanel();
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = n++;
        c.gridwidth = 5;
        c.weightx = 1.0;
        c.fill = 2;
        c.insets = new Insets(2, 5, 2, 5);
        this.add((Component)readoutPanel, c);
        this.controlLabel = new FontAdjust.FontLabel("0");
        this.controlLabel.setInheritsPopupMenu(true);
        readoutPanel.add(this.controlLabel);
        readoutPanel.add(Box.createHorizontalStrut(10));
        this.targetLabel = new FontAdjust.FontLabel("0");
        this.targetLabel.setInheritsPopupMenu(true);
        readoutPanel.add(this.targetLabel);
        readoutPanel.add(Box.createHorizontalStrut(10));
        this.errorLabel = new FontAdjust.FontLabel("");
        this.errorLabel.setInheritsPopupMenu(true);
        readoutPanel.add(this.errorLabel);
        JPopupMenu pm = new JPopupMenu();
        readoutPanel.setComponentPopupMenu(pm);
        JMenuItem mi = new JMenuItem("Copy control value to clipboard");
        mi.addActionListener(this);
        mi.setActionCommand("Clipboard");
        pm.add(mi);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = n;
        c.insets = new Insets(2, 5, 2, 5);
        this.add((Component)new FontAdjust.FontLabel("Control:"), c);
        this.controlComboBox = new FontAdjust.FontComboBox<SetupFormatsAdjuster.AdjustParam>();
        for (String p : SetupFormatsAdjuster.listAdjustableParamsNames(false)) {
            this.controlComboBox.addItem(SetupFormatsAdjuster.getAdjustParam(p));
        }
        this.controlComboBox.addActionListener(this);
        this.controlComboBox.setActionCommand("Control");
        this.controlComboBox.setToolTipText("Control to adjust");
        this.controlComboBox.setMaximumRowCount(30);
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = n++;
        c.gridwidth = 2;
        c.insets = new Insets(2, 5, 2, 5);
        c.anchor = 17;
        this.add(this.controlComboBox, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = n;
        c.insets = new Insets(2, 5, 2, 5);
        this.add((Component)new FontAdjust.FontLabel("Control range:"), c);
        this.minTextField = new FontAdjust.FontTextField(6);
        this.minTextField.addActionListener(this);
        this.minTextField.setActionCommand("min");
        this.minTextField.addFocusListener(this);
        this.minTextField.setToolTipText("Minimum value for control parameter");
        this.minTextField.setMinimumSize(dd);
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = n;
        c.insets = new Insets(2, 5, 2, 5);
        c.anchor = 17;
        this.add((Component)this.minTextField, c);
        this.maxTextField = new FontAdjust.FontTextField(6);
        this.maxTextField.addActionListener(this);
        this.maxTextField.setActionCommand("max");
        this.maxTextField.addFocusListener(this);
        this.maxTextField.setToolTipText("Maximum value for control parameter");
        this.maxTextField.setMinimumSize(dd);
        c = new GridBagConstraints();
        c.gridx = 2;
        c.gridy = n++;
        c.insets = new Insets(2, 5, 2, 5);
        c.anchor = 17;
        this.add((Component)this.maxTextField, c);
        c.gridx = 0;
        c.gridy = n;
        c.insets = new Insets(2, 5, 2, 5);
        this.add((Component)new FontAdjust.FontLabel("Min change:"), c);
        this.minChangeTextField = new FontAdjust.FontTextField(6);
        this.minChangeTextField.addActionListener(this);
        this.minChangeTextField.setActionCommand("MinChange");
        this.minChangeTextField.addFocusListener(this);
        this.minChangeTextField.setToolTipText("Minimum change for control value, this is used to stop the adjustment");
        this.minChangeTextField.setMinimumSize(dd);
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = n++;
        c.insets = new Insets(2, 5, 2, 5);
        c.anchor = 17;
        this.add((Component)this.minChangeTextField, c);
        c.gridx = 0;
        c.gridy = n;
        c.insets = new Insets(2, 5, 2, 5);
        this.add((Component)new FontAdjust.FontLabel("Update speed:"), c);
        this.updateSpeedTextField = new FontAdjust.FontTextField(6);
        this.updateSpeedTextField.addActionListener(this);
        this.updateSpeedTextField.setActionCommand("UpdateSpeed");
        this.updateSpeedTextField.addFocusListener(this);
        this.updateSpeedTextField.setToolTipText("Time in seconds between setting control value and reading target value, this must be long enough for target value to be stable");
        this.updateSpeedTextField.setMinimumSize(dd);
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = n++;
        c.insets = new Insets(2, 5, 2, 5);
        c.anchor = 17;
        this.add((Component)this.updateSpeedTextField, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = n;
        c.insets = new Insets(2, 5, 2, 5);
        this.add((Component)new FontAdjust.FontLabel("Target:"), c);
        this.targetComboBox = new FontAdjust.FontComboBox<String>();
        for (String p : InterfaceThreads.listChannels(false)) {
            this.targetComboBox.addItem(p);
        }
        this.targetComboBox.addActionListener(this);
        this.targetComboBox.setActionCommand("Target");
        this.targetComboBox.setToolTipText("Target parameter to reach");
        this.targetComboBox.setMaximumRowCount(30);
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = n++;
        c.gridwidth = 2;
        c.insets = new Insets(2, 5, 2, 5);
        c.anchor = 17;
        this.add(this.targetComboBox, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = n;
        c.insets = new Insets(2, 5, 2, 5);
        this.add((Component)new FontAdjust.FontLabel("Find:"), c);
        JPanel targetPanel = new JPanel();
        ButtonGroup bg = new ButtonGroup();
        this.minRadio = new FontAdjust.FontRadioButton("Min");
        this.minRadio.addActionListener(this);
        this.minRadio.setActionCommand("MinRadio");
        this.minRadio.setSelected(true);
        bg.add(this.minRadio);
        targetPanel.add(this.minRadio);
        this.maxRadio = new FontAdjust.FontRadioButton("Max");
        this.maxRadio.addActionListener(this);
        this.maxRadio.setActionCommand("MaxRadio");
        bg.add(this.maxRadio);
        targetPanel.add(this.maxRadio);
        this.valueRadio = new FontAdjust.FontRadioButton("Value");
        this.valueRadio.addActionListener(this);
        this.valueRadio.setActionCommand("ValueRadio");
        bg.add(this.valueRadio);
        targetPanel.add(this.valueRadio);
        this.targetTextField = new FontAdjust.FontTextField(6);
        this.targetTextField.addActionListener(this);
        this.targetTextField.setActionCommand("targetValue");
        this.targetTextField.addFocusListener(this);
        this.targetTextField.setToolTipText("Auto adjust control to reach this value");
        this.targetTextField.setMinimumSize(dd);
        this.targetTextField.setEnabled(false);
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = n++;
        c.gridwidth = 2;
        c.insets = new Insets(2, 5, 2, 5);
        c.anchor = 17;
        targetPanel.add(this.targetTextField);
        this.add((Component)targetPanel, c);
        this.startButton = new FontAdjust.FontButton("Start");
        this.startButton.addActionListener(this);
        this.startButton.setActionCommand("Start");
        this.startButton.setToolTipText("Start adjustment");
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = n;
        c.insets = new Insets(2, 5, 2, 5);
        this.add((Component)this.startButton, c);
        this.stopButton = new FontAdjust.FontButton("Stop");
        this.stopButton.addActionListener(this);
        this.stopButton.setActionCommand("Stop");
        this.stopButton.setToolTipText("Force stop of adjustment");
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = n;
        c.insets = new Insets(2, 5, 2, 5);
        this.add((Component)this.stopButton, c);
        this.indicator = new Indicator();
        this.indicator.setIndicatorSize(40, 20);
        this.indicator.setToolTipText("Is on when searching for value");
        this.indicator.setOn(false);
        c = new GridBagConstraints();
        c.gridx = 2;
        c.gridy = n++;
        c.anchor = 13;
        c.insets = new Insets(2, 5, 2, 5);
        this.add((Component)this.indicator, c);
        this.fillValues();
        if (this.controlComboBox.getItemCount() > 0) {
            this.controlComboBox.setSelectedIndex(0);
        }
        if (this.targetComboBox.getItemCount() > 0) {
            this.targetComboBox.setSelectedIndex(0);
        }
        this.enableControls(true);
        this.configForControl();
        this.configForTarget();
    }

    public double getStepCurrent() {
        return this.minControl;
    }

    public double getMaxCurrent() {
        return this.maxControl;
    }

    public double getMinVoltage() {
        return this.minChange;
    }

    public double getUpdateSpeed() {
        return this.updateSpeed;
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    private void fillValues() {
        this.minTextField.setText(StringUtil.formatDoubleEE(this.minControl, false));
        this.maxTextField.setText(StringUtil.formatDoubleEE(this.maxControl, false));
        this.minChangeTextField.setText(StringUtil.formatDoubleEE(this.minChange, false));
        this.updateSpeedTextField.setText(StringUtil.formatDoubleEE(this.updateSpeed, false));
        switch (this.function) {
            case Max: {
                this.maxRadio.setSelected(true);
                break;
            }
            case Min: {
                this.minRadio.setSelected(true);
                break;
            }
            case Value: {
                this.valueRadio.setSelected(true);
                this.targetTextField.setEnabled(true);
                this.targetTextField.setText(StringUtil.formatDoubleEE(this.targetSetting, false));
                break;
            }
        }
    }

    private void enableControls(boolean enable) {
        if (this.targetComboBox.getItemCount() == 0 || this.controlComboBox.getItemCount() == 0) {
            enable = false;
        }
        this.controlComboBox.setEnabled(enable);
        this.minTextField.setEnabled(enable);
        this.maxTextField.setEnabled(enable);
        this.minChangeTextField.setEnabled(enable);
        this.updateSpeedTextField.setEnabled(enable);
        this.targetComboBox.setEnabled(enable);
        this.minRadio.setEnabled(enable);
        this.maxRadio.setEnabled(enable);
        this.valueRadio.setEnabled(enable);
        this.targetTextField.setEnabled(enable);
        this.startButton.setEnabled(enable);
        this.stopButton.setEnabled(true);
    }

    private void setControl(double value) {
        this.controlParam.setParam(value);
        this.controlLabel.setText(String.valueOf(StringUtil.formatDoubleEE(value)) + this.controlParam.getUnit());
    }

    private void updateControl() {
        long t = System.currentTimeMillis();
        boolean updateDisplay = false;
        boolean updateControl = false;
        if (t > this.displayTimer) {
            updateDisplay = true;
            this.displayTimer = t + 500L;
        }
        if (t > this.controlTimer && this.phase != Phase.Idle) {
            updateControl = true;
            this.controlTimer = t + (long)(this.updateSpeed * 1000.0);
        }
        try {
            if (updateDisplay || updateControl) {
                InterfaceThreads.setupVars();
                this.targetValue = Var.gl.find(this.targetParam).asDouble();
            }
            if (updateDisplay) {
                this.targetLabel.setText(String.valueOf(this.fmtTarget.format.formatDisplay(this.targetValue)) + this.fmtTarget.unit);
                switch (this.function) {
                    case Max: {
                        this.errorLabel.setText("");
                        break;
                    }
                    case Min: {
                        this.errorLabel.setText("");
                        break;
                    }
                    case Value: {
                        double dx = this.targetValue - this.targetSetting;
                        String s = "";
                        if (Math.abs(this.targetValue) > 0.0) {
                            double pct = dx / this.targetSetting;
                            if (Math.abs(pct) < 0.003) {
                                s = "  " + ValueFormat.formatD0.formatDisplay(pct * 1000000.0) + "ppm";
                            } else if (Math.abs(pct) < 0.3) {
                                s = "  " + ValueFormat.formatD1.formatDisplay(pct * 100.0) + "%";
                            }
                        }
                        this.errorLabel.setText("Error: " + this.fmtTarget.format.formatDisplay(dx) + s);
                        break;
                    }
                }
            }
            if (updateControl) {
                boolean redo = false;
                do {
                    redo = false;
                    switch (this.phase) {
                        case Idle: {
                            break;
                        }
                        case AskHigh: {
                            this.targetHigh = this.targetValue;
                            switch (this.function) {
                                case Max: {
                                    if (this.targetHigh > this.targetMid) {
                                        this.lastControl += this.dxControl;
                                        this.targetMid = this.targetHigh;
                                    } else if (this.targetLow > this.targetMid) {
                                        this.lastControl -= this.dxControl;
                                        this.targetMid = this.targetLow;
                                    }
                                    this.dxControl /= 2.0;
                                    break;
                                }
                                case Min: {
                                    if (this.targetHigh < this.targetMid) {
                                        this.lastControl += this.dxControl;
                                        this.targetMid = this.targetHigh;
                                    } else if (this.targetLow < this.targetMid) {
                                        this.lastControl -= this.dxControl;
                                        this.targetMid = this.targetLow;
                                    }
                                    this.dxControl /= 2.0;
                                    break;
                                }
                                case Value: {
                                    break;
                                }
                            }
                            this.setControl(this.lastControl - this.dxControl);
                            this.phase = Phase.AskLow;
                            break;
                        }
                        case AskLow: {
                            this.targetLow = this.targetValue;
                            this.setControl(this.lastControl + this.dxControl);
                            this.phase = Phase.AskHigh;
                            break;
                        }
                        case AskMid: {
                            this.targetMid = this.targetValue;
                            this.setControl(this.lastControl - this.dxControl);
                            this.phase = Phase.AskLow;
                            break;
                        }
                        case AskValue1: {
                            if (this.targetValue > this.targetSetting) {
                                if (this.direction) {
                                    this.direction = false;
                                    this.dxControl /= 2.0;
                                }
                                this.lastControl += this.dxControl;
                            } else {
                                if (!this.direction) {
                                    this.direction = true;
                                    this.dxControl /= 2.0;
                                }
                                this.lastControl -= this.dxControl;
                            }
                            this.setControl(this.lastControl);
                            break;
                        }
                        case AskValue2: {
                            if (this.targetValue < this.targetSetting) {
                                if (this.direction) {
                                    this.direction = false;
                                    this.dxControl /= 2.0;
                                }
                                this.lastControl += this.dxControl;
                            } else {
                                if (!this.direction) {
                                    this.direction = true;
                                    this.dxControl /= 2.0;
                                }
                                this.lastControl -= this.dxControl;
                            }
                            this.setControl(this.lastControl);
                            break;
                        }
                        case AskMin: {
                            this.targetLow = this.targetValue;
                            this.setControl(this.maxControl);
                            this.phase = Phase.AskMax;
                            break;
                        }
                        case AskMax: {
                            this.targetHigh = this.targetValue;
                            this.direction = false;
                            this.targetValue = this.targetLow;
                            this.lastControl = this.minControl;
                            if (this.targetLow > this.targetSetting && this.targetHigh < this.targetSetting) {
                                this.phase = Phase.AskValue1;
                                redo = true;
                                break;
                            }
                            if (this.targetLow < this.targetSetting && this.targetHigh > this.targetSetting) {
                                this.phase = Phase.AskValue2;
                                redo = true;
                                break;
                            }
                            this.setActive(false);
                            break;
                        }
                        case Start: {
                            this.indicator.setOn(true);
                            this.dxControl = (this.minControl + this.maxControl) / 4.0;
                            if (this.function == Function.Value) {
                                this.lastControl = this.minControl;
                                this.phase = Phase.AskMin;
                            } else {
                                this.lastControl = (this.minControl + this.maxControl) / 2.0;
                                this.phase = Phase.AskMid;
                            }
                            this.setControl(this.lastControl);
                            break;
                        }
                    }
                } while (redo);
                if (this.dxControl < this.minChange / 3.0) {
                    this.setActive(false);
                    String s = ";; Auto adjust " + this.function.name() + ": " + this.controlLabel.getText() + "   " + this.targetLabel.getText() + "   " + this.errorLabel.getText();
                    InterfaceThreads.log(s);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
    }

    public static synchronized void closeAll() {
        if (popupAutoAdjust != null) {
            popupAutoAdjust.setVisible(false);
            popupAutoAdjust = null;
        }
    }

    public static synchronized PopupAutoAdjust getPopup() {
        if (popupAutoAdjust != null) {
            popupAutoAdjust.requestFocus();
            return popupAutoAdjust;
        }
        popupAutoAdjust = new PopupAutoAdjust();
        Point p = Support.paneCommand.popupsButton.getLocationOnScreen();
        p.translate(-850, -550);
        if (p.y < 0) {
            p.y = 0;
        }
        if (p.x < 0) {
            p.x = 0;
        }
        popupAutoAdjust.setLocation(p);
        popupAutoAdjust.setVisible(true);
        return popupAutoAdjust;
    }

    public static void alignGridAll(int pixels) {
        if (popupAutoAdjust != null) {
            popupAutoAdjust.alignGrid(pixels);
        }
    }

    public static synchronized void stopAll() {
        if (popupAutoAdjust != null) {
            popupAutoAdjust.setActive(false);
        }
    }

    private void configForControl() {
        if (this.controlParam != null) {
            this.minControl = this.controlParam.getMin();
            this.maxControl = this.controlParam.getMax();
            this.minParamControl = this.minControl;
            this.maxParamControl = this.maxControl;
            this.minChange = (this.maxControl - this.minControl) / 1000.0;
        } else {
            this.minControl = 0.0;
            this.maxControl = 0.0;
            this.minChange = 1.0;
        }
        this.fillValues();
    }

    private void configForTarget() {
        this.fmtTarget = InterfaceThreads.findValueFormat(this.targetParam);
    }

    @Override
    public void focusGained(FocusEvent arg0) {
    }

    @Override
    public void focusLost(FocusEvent arg0) {
        JTextField tf = (JTextField)arg0.getSource();
        String ac = "";
        if (tf == this.minTextField) {
            ac = "min";
        } else if (tf == this.maxTextField) {
            ac = "max";
        } else if (tf == this.minChangeTextField) {
            ac = "MinChange";
        } else if (tf == this.targetTextField) {
            ac = "TargetValue";
        } else if (tf == this.updateSpeedTextField) {
            ac = "UpdateSpeed";
        }
        if (!ac.isEmpty()) {
            this.actionPerformed(new ActionEvent(tf, 0, ac));
        }
    }

    private void setActive(boolean active) {
        this.active = active;
        this.enableControls(!active);
        if (active) {
            this.phase = Phase.Start;
            this.setControl(this.minControl);
            this.controlParam.setDeviceOn(true);
            this.indicator.setOn(true);
        } else {
            this.indicator.setOn(false);
            this.phase = Phase.Idle;
        }
    }

    public void setParams(String controlChannel, double minValue, double maxValue, double minChange, double updateSpeed, String targetChannel, String target) {
        if (this.phase != Phase.Idle) {
            return;
        }
        int i = 0;
        while (i < this.controlComboBox.getItemCount()) {
            if (controlChannel.equalsIgnoreCase(this.controlComboBox.getItemAt(i).getName())) {
                this.controlComboBox.setSelectedIndex(i);
                break;
            }
            ++i;
        }
        this.configForControl();
        this.targetComboBox.setSelectedItem(targetChannel);
        this.configForTarget();
        if (target.equalsIgnoreCase("max")) {
            this.function = Function.Max;
        } else if (target.equalsIgnoreCase("min")) {
            this.function = Function.Min;
        } else {
            this.function = Function.Value;
            this.targetSetting = StringUtil.parseDoubleEE(target);
        }
        this.minControl = minValue;
        this.maxControl = maxValue;
        this.minChange = minChange;
        this.updateSpeed = updateSpeed;
        this.fillValues();
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        String s = arg0.getActionCommand();
        if (s.equals("Control")) {
            this.controlParam = (SetupFormatsAdjuster.AdjustParam)this.controlComboBox.getSelectedItem();
            this.configForControl();
        } else if (s.equals("min")) {
            this.minControl = Support.parseTextFieldDouble(this.minTextField, 1.0, false, this.minParamControl, this.maxParamControl);
        } else if (s.equals("max")) {
            this.maxControl = Support.parseTextFieldDouble(this.maxTextField, 1.0, false, this.minParamControl, this.maxParamControl);
        } else if (s.equals("MinChange")) {
            this.minChange = Support.parseTextFieldDouble(this.minChangeTextField, 1.0, false, 1.0E-9, 1000000.0);
        } else if (s.equals("UpdateSpeed")) {
            this.updateSpeed = Support.parseTextFieldDouble(this.updateSpeedTextField, 0.5, false, 0.1, 30.0);
        } else if (s.equals("Target")) {
            this.targetParam = (String)this.targetComboBox.getSelectedItem();
            this.configForTarget();
        } else if (s.equals("TargetValue")) {
            this.targetSetting = Support.parseTextFieldDouble(this.targetTextField, 1.0, false, 1.0E-9, 1.0E9);
        } else if (s.equals("MinRadio")) {
            this.targetTextField.setEnabled(false);
            this.function = Function.Min;
        } else if (s.equals("MaxRadio")) {
            this.targetTextField.setEnabled(false);
            this.function = Function.Max;
        } else if (s.equals("ValueRadio")) {
            this.targetTextField.setEnabled(true);
            this.function = Function.Value;
        } else if (s.equals("Start")) {
            this.setActive(true);
        } else if (s.equals("Stop")) {
            this.setActive(false);
            this.setControl(this.minControl);
            this.controlParam.setDeviceOn(false);
        } else if (arg0.getActionCommand().equals("Clipboard")) {
            StringSelection stringSelection = new StringSelection(this.controlLabel.getText());
            Clipboard clpbrd = Toolkit.getDefaultToolkit().getSystemClipboard();
            clpbrd.setContents(stringSelection, null);
        } else if (s.equals("Timer")) {
            this.updateControl();
        }
    }

    private String generateScriptCmd() {
        StringBuilder sb = new StringBuilder();
        sb.append("#SetAutoAdjust ");
        sb.append(Support.conditionalQuote(this.controlParam.getName()));
        sb.append(" ");
        sb.append(StringUtil.formatDoubleEE(this.minControl, false));
        sb.append(" ");
        sb.append(StringUtil.formatDoubleEE(this.maxControl, false));
        sb.append(" ");
        sb.append(StringUtil.formatDoubleEE(this.minChange, false));
        sb.append(" ");
        sb.append(StringUtil.formatDoubleEE(this.updateSpeed, false));
        sb.append(" ");
        sb.append(Support.conditionalQuote(this.targetParam));
        sb.append(" ");
        switch (this.function) {
            case Max: {
                sb.append("Max");
                break;
            }
            case Min: {
                sb.append("Min");
                break;
            }
            case Value: {
                sb.append(StringUtil.formatDoubleEE(this.targetSetting, false));
                break;
            }
        }
        return sb.toString();
    }

    public static List<String> generateScript() {
        ArrayList<String> list = new ArrayList<String>();
        if (popupAutoAdjust != null) {
            list.add("#ShowPopupSystem PopupAutoAdjust " + popupAutoAdjust.generateLocationParams());
            list.add(popupAutoAdjust.generateScriptCmd());
        }
        return list;
    }

    private static enum Function {
        Min,
        Max,
        Value;

    }

    private static enum Phase {
        Idle,
        Start,
        AskMid,
        AskLow,
        AskHigh,
        AskMin,
        AskMax,
        AskValue1,
        AskValue2;

    }
}

