/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.main;

import dk.hkj.main.CommandProcessor;
import dk.hkj.main.FontAdjust;
import dk.hkj.main.IconGenerator;
import dk.hkj.main.Indicator;
import dk.hkj.main.InterfaceThreads;
import dk.hkj.main.PopupBase;
import dk.hkj.main.PopupLogEvent;
import dk.hkj.main.PopupParamSweeper;
import dk.hkj.main.Support;
import dk.hkj.script.Script;
import dk.hkj.util.AudibleAlarm;
import dk.hkj.util.StringUtil;
import java.awt.AWTException;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class PopupAlarm
extends PopupBase
implements ActionListener,
FocusListener {
    private static List<PopupAlarm> popupList = new ArrayList<PopupAlarm>();
    private Timer timer;
    private JPanel cardPanel;
    private JTextField minTextField;
    private JTextField maxTextField;
    private JTextField expressionTextField;
    private JButton audioTestButton;
    private JButton visualTestButton;
    private JButton inputFormatButton;
    private Indicator soundIndicator;
    private Indicator alarmIndicator;
    private JSlider alarmLevelSlider;
    private JButton settingsButton;
    private JCheckBox allOffCheckBox;
    private JCheckBox retrigCheckBox;
    private JCheckBox activeCheckBox;
    private JComboBox<String> channelComboBox;
    private JButton resetButton;
    private static List<SoundType> soundTypes = null;
    private static List<SoundPattern> soundPatters = null;
    private static List<VisualPattern> visualPatters = null;
    private String selectedSoundType;
    private String selectedSoundPattern;
    private String selectedVisualPattern;
    private List<JRadioButton> soundTypeRadioButtons = new ArrayList<JRadioButton>();
    private List<JRadioButton> soundPatternRadioButtons = new ArrayList<JRadioButton>();
    private List<JRadioButton> visualPatternRadioButtons = new ArrayList<JRadioButton>();
    private String expression = "";
    private AudibleAlarm audibleAlarm = null;
    private int alarmAudioLevel = 100;
    private JPanel audibleAlarmPanel;
    private JPanel visualAlarmPanel;
    private boolean active = false;
    private boolean allOff = false;
    private boolean alarm = false;
    private boolean alarmLast = false;
    private boolean retrig = false;
    private boolean autoreset = false;
    private Script script = new Script();
    private DateFormat sdf = SimpleDateFormat.getDateTimeInstance(3, 2);
    private AlarmPane alarmPane = null;
    private AlarmMode alarmMode = AlarmMode.minmax;
    private double min = -1.7976931348623157E308;
    private double max = Double.MAX_VALUE;
    private String channel = "";
    protected String alarmFrom = "";
    private boolean settingsVisible = true;
    private int number;
    private boolean scriptArm = false;

    public static PopupAlarm getAlarm(int no) {
        if (no > 0) {
            --no;
        }
        if (no < popupList.size()) {
            return popupList.get(no);
        }
        Point p = Support.paneCommand.popupsButton.getLocationOnScreen();
        p.translate(-750, -450 + popupList.size() * -100);
        if (p.y < 0) {
            p.y = 0;
        }
        PopupAlarm pa = new PopupAlarm();
        pa.setLocation(p);
        pa.setVisible(true);
        return pa;
    }

    public static void setAlarm(int no, boolean on, boolean outputOff, boolean retrig, String expression) {
        PopupAlarm pa = PopupAlarm.getAlarm(no);
        pa.showSettings(false);
        pa.audibleAlarmPanel.setVisible(false);
        pa.visualAlarmPanel.setVisible(false);
        pa.allOffCheckBox.setSelected(outputOff);
        pa.allOff = outputOff;
        pa.retrigCheckBox.setSelected(retrig);
        pa.retrig = retrig;
        pa.activeCheckBox.setSelected(on);
        pa.active = on;
        pa.expressionTextField.setText(expression);
        pa.expression = expression;
        pa.setAlarmMode(AlarmMode.expression);
        pa.pack();
    }

    public static void setAlarm(final int no, final boolean on, final boolean outputOff, final boolean retrig, final String channel, final double min, final double max) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PopupAlarm pa = PopupAlarm.getAlarm(no);
                pa.showSettings(false);
                pa.audibleAlarmPanel.setVisible(false);
                pa.visualAlarmPanel.setVisible(false);
                pa.allOffCheckBox.setSelected(outputOff);
                pa.allOff = outputOff;
                pa.retrigCheckBox.setSelected(retrig);
                pa.retrig = retrig;
                pa.activeCheckBox.setSelected(on);
                pa.active = on;
                pa.channelComboBox.setSelectedItem(channel);
                pa.channel = channel;
                if (!Double.isFinite(min)) {
                    pa.minTextField.setText("");
                } else {
                    pa.minTextField.setText(StringUtil.formatDoubleEE(min));
                }
                pa.min = min;
                if (!Double.isFinite(max)) {
                    pa.maxTextField.setText("");
                } else {
                    pa.maxTextField.setText(StringUtil.formatDoubleEE(max));
                }
                pa.max = max;
                pa.setAlarmMode(AlarmMode.minmax);
                pa.pack();
            }
        });
    }

    public static void setAlarm(int no, boolean on, boolean outputOff, boolean retrig) {
        PopupAlarm pa = PopupAlarm.getAlarm(no);
        pa.showSettings(false);
        pa.audibleAlarmPanel.setVisible(false);
        pa.visualAlarmPanel.setVisible(false);
        pa.allOffCheckBox.setSelected(outputOff);
        pa.allOff = outputOff;
        pa.retrigCheckBox.setSelected(retrig);
        pa.retrig = retrig;
        pa.activeCheckBox.setSelected(on);
        pa.active = on;
        pa.setAlarmMode(AlarmMode.sweeperEventScript);
        pa.pack();
    }

    public static void adjustAlarm(final int no, final String param) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PopupAlarm.setupSoundTypes();
                PopupAlarm pa = PopupAlarm.getAlarm(no);
                if (StringUtil.isInt(param)) {
                    int n = StringUtil.parseInt(param);
                    if (n < 0) {
                        n = 0;
                    }
                    if (n > 100) {
                        n = 100;
                    }
                    pa.alarmLevelSlider.setValue(n);
                    pa.alarmAudioLevel = n;
                } else {
                    String s = StringUtil.unQuote(param.toLowerCase());
                    int i = 0;
                    while (i < soundTypes.size()) {
                        SoundType st = (SoundType)soundTypes.get(i);
                        if (st.name.toLowerCase().startsWith(s)) {
                            ((JRadioButton)pa.soundTypeRadioButtons.get(i)).setSelected(true);
                            pa.selectedSoundType = st.name;
                            break;
                        }
                        ++i;
                    }
                    i = 0;
                    while (i < soundPatters.size()) {
                        SoundPattern sp = (SoundPattern)soundPatters.get(i);
                        if (sp.name.toLowerCase().startsWith(s)) {
                            ((JRadioButton)pa.soundPatternRadioButtons.get(i)).setSelected(true);
                            pa.selectedSoundPattern = sp.name;
                            break;
                        }
                        ++i;
                    }
                    i = 0;
                    while (i < visualPatters.size()) {
                        VisualPattern vp = (VisualPattern)visualPatters.get(i);
                        if (vp.name.toLowerCase().startsWith(s)) {
                            ((JRadioButton)pa.visualPatternRadioButtons.get(i)).setSelected(true);
                            pa.selectedVisualPattern = vp.name;
                            break;
                        }
                        ++i;
                    }
                }
            }
        });
    }

    public static boolean isAdjustKeyword(String s) {
        PopupAlarm.setupSoundTypes();
        int i = 0;
        while (i < soundTypes.size()) {
            if (PopupAlarm.soundTypes.get((int)i).name.equalsIgnoreCase(s)) {
                return true;
            }
            ++i;
        }
        i = 0;
        while (i < soundPatters.size()) {
            if (PopupAlarm.soundPatters.get((int)i).name.equalsIgnoreCase(s)) {
                return true;
            }
            ++i;
        }
        i = 0;
        while (i < visualPatters.size()) {
            if (PopupAlarm.visualPatters.get((int)i).name.equalsIgnoreCase(s)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static void closeAlarm(final int no) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                int n;
                if (no < 0) {
                    int i = popupList.size() - 1;
                    while (i >= 0) {
                        ((PopupAlarm)popupList.get(i)).setVisible(false);
                        --i;
                    }
                }
                if ((n = no) > 0) {
                    --n;
                }
                if (n < popupList.size()) {
                    ((PopupAlarm)popupList.get(n)).setVisible(false);
                }
            }
        });
    }

    public PopupAlarm() {
        popupList.add(this);
        this.number = popupList.indexOf(this);
        PopupAlarm.setupSoundTypes();
        if (popupList.size() > 1) {
            this.disableSaveLocation();
        }
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                if (PopupAlarm.this.timer != null) {
                    PopupAlarm.this.timer.stop();
                    PopupAlarm.this.timer = null;
                }
                if (PopupAlarm.this.audibleAlarm != null) {
                    PopupAlarm.this.audibleAlarm.stopSound();
                }
                Support.math.removeDomain("Alarm" + PopupAlarm.this.number);
                popupList.remove(PopupAlarm.this);
            }
        });
        this.setAlwaysOnTop(true);
        this.setTitle("Alarm");
        this.setDefaultCloseOperation(2);
        this.definePopupName("Alarm", false);
        PopupAlarm.setupSoundTypes();
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = null;
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 2;
        c.weightx = 1.0;
        c.anchor = 13;
        c.fill = 2;
        c.insets = new Insets(5, 5, 5, 5);
        this.cardPanel = new JPanel();
        this.cardPanel.setLayout(new CardLayout(0, 0));
        JPanel panel = new JPanel();
        panel.setLayout(new FlowLayout(0, 0, 0));
        this.inputFormatButton = new FontAdjust.FontButton(null);
        this.inputFormatButton.setBorder(BorderFactory.createEmptyBorder());
        this.inputFormatButton.setIcon(IconGenerator.makeIcon(IconGenerator.IconType.FieldChange));
        this.inputFormatButton.setActionCommand("InputMethod");
        this.inputFormatButton.addActionListener(this);
        this.inputFormatButton.setToolTipText("Change between min/max and expression format");
        panel.add(this.inputFormatButton);
        panel.add(Box.createHorizontalStrut(10));
        panel.add(this.cardPanel);
        this.add((Component)panel, c);
        panel = new JPanel();
        panel.setLayout(new FlowLayout(0, 0, 0));
        this.channelComboBox = new FontAdjust.FontComboBox<String>();
        this.channelComboBox.setActionCommand("Channel");
        this.channelComboBox.addActionListener(this);
        this.channelComboBox.setPreferredSize(new Dimension(150, 20));
        this.channelComboBox.setToolTipText("Select channel to test agains min/max");
        this.channelComboBox.setMaximumRowCount(20);
        this.fillChannels();
        if (this.channelComboBox.getItemCount() > 0) {
            this.channelComboBox.setSelectedIndex(0);
        }
        panel.add(this.channelComboBox);
        panel.add(Box.createHorizontalStrut(10));
        panel.add(new FontAdjust.FontLabel("Min.:"));
        panel.add(Box.createHorizontalStrut(5));
        this.minTextField = new FontAdjust.FontTextField(4);
        this.minTextField.setActionCommand("Min");
        this.minTextField.addActionListener(this);
        this.minTextField.addFocusListener(this);
        this.minTextField.setToolTipText("Start an alarm if value is below this, leave empty when not needed");
        panel.add(this.minTextField);
        panel.add(Box.createHorizontalStrut(10));
        panel.add(new FontAdjust.FontLabel("Max.:"));
        panel.add(Box.createHorizontalStrut(5));
        this.maxTextField = new FontAdjust.FontTextField(4);
        this.maxTextField.setActionCommand("Max");
        this.maxTextField.addActionListener(this);
        this.maxTextField.addFocusListener(this);
        this.maxTextField.setToolTipText("Start an alarm if value is above this, leave empty when not needed");
        panel.add(this.maxTextField);
        this.cardPanel.add(panel);
        panel = new JPanel();
        panel.setLayout(new FlowLayout(0, 0, 0));
        panel.add(new FontAdjust.FontLabel("Expression:"));
        panel.add(Box.createHorizontalStrut(5));
        this.expressionTextField = new Support.PopupTextField(25);
        this.expressionTextField.setActionCommand("Exp");
        this.expressionTextField.addActionListener(this);
        this.expressionTextField.addFocusListener(this);
        this.expressionTextField.setToolTipText("Expression that must return true on alarm condition, use INS to gte a list of variables");
        panel.add(this.expressionTextField);
        this.cardPanel.add(panel);
        panel = new JPanel();
        FontAdjust.FontLabel label = new FontAdjust.FontLabel("When param sweeper, log event or script is done");
        panel.add(label);
        this.cardPanel.add(panel);
        panel = new JPanel();
        panel.setLayout(new FlowLayout(0, 0, 0));
        this.settingsButton = new FontAdjust.FontButton("");
        this.settingsButton.setBorder(BorderFactory.createEmptyBorder());
        this.settingsButton.setToolTipText("Show or hide the audible/visual settings");
        this.settingsButton.setAlignmentX(0.0f);
        this.settingsButton.setSelected(true);
        this.settingsButton.addActionListener(this);
        this.settingsButton.setActionCommand("Settings");
        panel.add(this.settingsButton);
        panel.add(Box.createHorizontalStrut(10));
        this.allOffCheckBox = new FontAdjust.FontCheckBox("Outputs off");
        this.allOffCheckBox.setToolTipText("Do a \"Outputs off\" command when there is an alarm condition");
        this.allOffCheckBox.addActionListener(this);
        this.allOffCheckBox.setActionCommand("AllOff");
        panel.add(this.allOffCheckBox);
        panel.add(Box.createHorizontalStrut(10));
        this.retrigCheckBox = new FontAdjust.FontCheckBox("Retrig");
        this.retrigCheckBox.setToolTipText("When checked alarm will be triggered each time a alarm condition occur, not only first time");
        this.retrigCheckBox.addActionListener(this);
        this.retrigCheckBox.setActionCommand("Retrig");
        panel.add(this.retrigCheckBox);
        panel.add(Box.createHorizontalStrut(10));
        this.activeCheckBox = new FontAdjust.FontCheckBox("On");
        this.activeCheckBox.setToolTipText("Turn the alarm checking on, the indicator will be green. Removing this checkmark includes a reset");
        this.activeCheckBox.addActionListener(this);
        this.activeCheckBox.setActionCommand("Active");
        panel.add(this.activeCheckBox);
        panel.add(Box.createHorizontalStrut(10));
        this.resetButton = new FontAdjust.FontButton("Reset");
        this.resetButton.addActionListener(this);
        this.resetButton.setActionCommand("Reset");
        this.resetButton.setToolTipText("Turn sound/visual off and reset the alarm flag, but not disable alarm testing");
        panel.add(this.resetButton);
        this.alarmIndicator = new Indicator();
        this.alarmIndicator.setToolTipText("Indicate alarm state: not testing/testing/active/alarmHasTriggered");
        this.alarmIndicator.setOn(false);
        panel.add(Box.createHorizontalStrut(10));
        panel.add(this.alarmIndicator);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 2;
        c.weightx = 1.0;
        c.anchor = 13;
        c.fill = 2;
        c.insets = new Insets(5, 5, 5, 5);
        this.add((Component)panel, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 2;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 2;
        c.insets = new Insets(5, 5, 5, 5);
        this.audibleAlarmPanel = this.GenerateSoundPanel();
        this.add((Component)this.audibleAlarmPanel, c);
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 2;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 2;
        c.insets = new Insets(5, 5, 5, 5);
        this.visualAlarmPanel = this.GenerateVisualPanel();
        this.add((Component)this.visualAlarmPanel, c);
        this.showSettings(true);
        this.timer = new Timer(300, this);
        this.timer.setActionCommand("Timer");
        this.timer.start();
        this.pack();
    }

    private JPanel GenerateVisualPanel() {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createTitledBorder("Visual alarm"));
        panel.setLayout(new GridBagLayout());
        GridBagConstraints c = null;
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.insets = new Insets(5, 5, 5, 5);
        JPanel visualPatternPanel = new JPanel();
        visualPatternPanel.setLayout(new GridLayout(visualPatters.size(), 1));
        panel.add((Component)visualPatternPanel, c);
        ButtonGroup bg = new ButtonGroup();
        boolean selected = false;
        for (VisualPattern vp : visualPatters) {
            FontAdjust.FontRadioButton rb = new FontAdjust.FontRadioButton(vp.name);
            this.visualPatternRadioButtons.add(rb);
            rb.setActionCommand("VP:" + vp.name);
            rb.addActionListener(this);
            bg.add(rb);
            if (!selected) {
                rb.setSelected(true);
                this.selectedVisualPattern = vp.name;
                selected = true;
            }
            visualPatternPanel.add(rb);
        }
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 1;
        c.weighty = 1.0;
        c.fill = 2;
        c.insets = new Insets(5, 5, 5, 5);
        this.visualTestButton = new FontAdjust.FontButton("Test");
        this.visualTestButton.setActionCommand("TestVisual");
        this.visualTestButton.addActionListener(this);
        panel.add((Component)this.visualTestButton, c);
        return panel;
    }

    private JPanel GenerateSoundPanel() {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createTitledBorder("Audible alarm"));
        panel.setLayout(new GridBagLayout());
        GridBagConstraints c = null;
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.insets = new Insets(5, 5, 5, 5);
        JPanel soundTypePanel = new JPanel();
        soundTypePanel.setLayout(new GridLayout(soundTypes.size(), 1));
        panel.add((Component)soundTypePanel, c);
        ButtonGroup bg = new ButtonGroup();
        boolean selected = false;
        for (SoundType st : soundTypes) {
            FontAdjust.FontRadioButton rb = new FontAdjust.FontRadioButton(st.name);
            this.soundTypeRadioButtons.add(rb);
            rb.setActionCommand("ST:" + st.name);
            rb.addActionListener(this);
            bg.add(rb);
            if (!selected && !st.name.equalsIgnoreCase("None")) {
                rb.setSelected(true);
                this.selectedSoundType = st.name;
                selected = true;
            }
            soundTypePanel.add(rb);
        }
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.insets = new Insets(5, 5, 5, 5);
        JPanel soundPatternPanel = new JPanel();
        soundPatternPanel.setLayout(new GridLayout(soundPatters.size(), 1));
        panel.add((Component)soundPatternPanel, c);
        bg = new ButtonGroup();
        selected = false;
        for (SoundPattern sp : soundPatters) {
            FontAdjust.FontRadioButton rb = new FontAdjust.FontRadioButton(sp.name);
            this.soundPatternRadioButtons.add(rb);
            rb.setActionCommand("SP:" + sp.name);
            rb.addActionListener(this);
            bg.add(rb);
            if (!selected) {
                rb.setSelected(true);
                this.selectedSoundPattern = sp.name;
                selected = true;
            }
            soundPatternPanel.add(rb);
        }
        c = new GridBagConstraints();
        c.gridx = 2;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 3;
        c.insets = new Insets(5, 5, 5, 5);
        this.alarmLevelSlider = new FontAdjust.FontSlider(1);
        this.alarmLevelSlider.setMinimum(0);
        this.alarmLevelSlider.setMaximum(100);
        this.alarmLevelSlider.setValue(100);
        this.alarmLevelSlider.setMajorTickSpacing(20);
        this.alarmLevelSlider.setMinorTickSpacing(5);
        this.alarmLevelSlider.setPaintTicks(true);
        this.alarmLevelSlider.setPaintLabels(true);
        this.alarmLevelSlider.setToolTipText("Relative volume of this alarm in TestController, the computer have other volume controls that affect the final volumen");
        this.alarmLevelSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                PopupAlarm.this.alarmAudioLevel = PopupAlarm.this.alarmLevelSlider.getValue();
                if (PopupAlarm.this.audibleAlarm != null) {
                    PopupAlarm.this.audibleAlarm.setVolume(PopupAlarm.this.alarmAudioLevel);
                }
            }
        });
        panel.add((Component)this.alarmLevelSlider, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 1;
        c.weighty = 1.0;
        c.fill = 2;
        c.insets = new Insets(5, 5, 5, 5);
        this.audioTestButton = new FontAdjust.FontButton("Test");
        this.audioTestButton.setActionCommand("Test");
        this.audioTestButton.addActionListener(this);
        panel.add((Component)this.audioTestButton, c);
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 1;
        c.weighty = 1.0;
        c.insets = new Insets(5, 5, 5, 5);
        this.soundIndicator = new Indicator();
        this.soundIndicator.setOn(false);
        this.soundIndicator.setToolTipText("Is red when the sound alarm is active also during the silent intervals");
        panel.add((Component)this.soundIndicator, c);
        return panel;
    }

    public static synchronized void setupSoundTypes() {
        if (soundTypes != null) {
            return;
        }
        soundTypes = new ArrayList<SoundType>();
        soundTypes.add(new SoundType("None", ' ', 0, 0, 0, 0));
        soundTypes.add(new SoundType("Sliding up fast", 's', 300, 800, 333, 0));
        soundTypes.add(new SoundType("Sliding up slow", 's', 300, 800, 1000, 0));
        soundTypes.add(new SoundType("Sliding down", 's', 700, 250, 666, 0));
        soundTypes.add(new SoundType("Dual high & fast", 'd', 600, 800, 100, 100));
        soundTypes.add(new SoundType("Dual low & slow", 'd', 300, 450, 500, 500));
        soundTypes.add(new SoundType("Up/down fast", 'u', 500, 800, 333, 333));
        soundPatters = new ArrayList<SoundPattern>();
        soundPatters.add(new SoundPattern("Single", 0, 1));
        soundPatters.add(new SoundPattern("3 times slow", 10000, 3));
        soundPatters.add(new SoundPattern("3 times fast", 2000, 3));
        soundPatters.add(new SoundPattern("10 times slow", 10000, 10));
        soundPatters.add(new SoundPattern("Slow until reset", 10000, Integer.MAX_VALUE));
        soundPatters.add(new SoundPattern("Fast until reset", 2000, Integer.MAX_VALUE));
        soundPatters.add(new SoundPattern("Continuous", 0, Integer.MAX_VALUE));
        visualPatters = new ArrayList<VisualPattern>();
        visualPatters.add(new VisualPattern("None", 0, Color.BLUE, Color.BLUE));
        visualPatters.add(new VisualPattern("White/Gray fast", 300, Color.WHITE, Color.DARK_GRAY));
        visualPatters.add(new VisualPattern("Red/Gray fast", 300, Color.RED, Color.DARK_GRAY));
        visualPatters.add(new VisualPattern("Blue/Gray fast", 300, Color.BLUE, Color.DARK_GRAY));
        visualPatters.add(new VisualPattern("Red/Green fast", 300, Color.RED, Color.GREEN));
        visualPatters.add(new VisualPattern("Red/White fast", 300, Color.RED, Color.WHITE));
        visualPatters.add(new VisualPattern("White/Gray slow", 1000, Color.WHITE, Color.DARK_GRAY));
        visualPatters.add(new VisualPattern("Red/Gray slow", 1000, Color.RED, Color.DARK_GRAY));
    }

    public static synchronized void closeAll() {
        while (popupList.size() > 0) {
            PopupAlarm pa = popupList.get(0);
            popupList.remove(0);
            if (!pa.isVisible()) continue;
            pa.setVisible(false);
        }
    }

    private boolean isAlarm() {
        boolean alarm = false;
        InterfaceThreads.setupVars();
        switch (this.alarmMode) {
            case expression: {
                try {
                    Support.math.calcAllColumns(this.script, "Alarm" + this.number);
                    alarm = this.script.expression(this.expression).asBoolean();
                    if (alarm) {
                        this.alarmFrom = this.expression;
                    }
                    this.expressionTextField.setBackground(Support.colorScheme.textBackground);
                }
                catch (Exception e) {
                    e.printStackTrace(System.out);
                    this.expressionTextField.setBackground(Support.colorScheme.errorBackground);
                    alarm = true;
                    this.alarmFrom = "Failed to evaluate expression: " + this.expression;
                }
                break;
            }
            case minmax: {
                try {
                    double v = Support.math.getChannelValue(this.channel, "Alarm" + this.number);
                    if (v < this.min) {
                        alarm = true;
                        this.alarmFrom = String.valueOf(this.channel) + " " + StringUtil.formatDoubleEE(v) + " < " + this.minTextField.getText();
                    }
                    if (v > this.max) {
                        alarm = true;
                        this.alarmFrom = String.valueOf(this.channel) + " " + StringUtil.formatDoubleEE(v) + " > " + this.maxTextField.getText();
                    }
                    if (!Double.isInfinite(v) && !Double.isNaN(v)) break;
                    alarm = true;
                    this.alarmFrom = String.valueOf(this.channel) + " invalid value";
                }
                catch (Exception exception) {
                    alarm = true;
                    this.alarmFrom = String.valueOf(this.channel) + " failed to read channel";
                }
                break;
            }
            case sweeperEventScript: {
                if (PopupParamSweeper.isPopupAlarm()) {
                    alarm = true;
                    this.alarmFrom = "ParamSweeper is done sweeping";
                    break;
                }
                if (PopupLogEvent.isPopupAlarm()) {
                    alarm = true;
                    this.alarmFrom = "LogEvent is done running";
                    break;
                }
                if (!this.scriptArm || CommandProcessor.isBackground()) break;
                alarm = true;
                this.alarmFrom = "Script is done running";
            }
        }
        return alarm;
    }

    private AlarmMode nextAlarmMode() {
        CardLayout cl = (CardLayout)this.cardPanel.getLayout();
        cl.next(this.cardPanel);
        this.alarmMode = AlarmMode.sweeperEventScript;
        if (this.expressionTextField.getParent().isVisible()) {
            this.alarmMode = AlarmMode.expression;
        } else if (this.channelComboBox.getParent().isVisible()) {
            this.alarmMode = AlarmMode.minmax;
        }
        return this.alarmMode;
    }

    private void setAlarmMode(AlarmMode am) {
        while (am != this.alarmMode) {
            this.nextAlarmMode();
        }
    }

    private void showSettings(boolean show) {
        this.settingsVisible = show;
        this.audibleAlarmPanel.setVisible(show);
        this.visualAlarmPanel.setVisible(show);
        this.settingsButton.setIcon(IconGenerator.makeIcon(this.settingsVisible ? IconGenerator.IconType.FoldUp : IconGenerator.IconType.FoldDown));
        this.pack();
    }

    @Override
    public void actionPerformed(ActionEvent action) {
        String cmd = action.getActionCommand();
        if (cmd.equalsIgnoreCase("Timer")) {
            this.soundIndicator.setOn(this.audibleAlarm != null && this.audibleAlarm.isPlaying());
            if (this.active) {
                this.alarm = this.isAlarm();
                if (this.alarm && !this.alarmLast) {
                    this.alarmLast = this.alarm;
                    if (this.allOff) {
                        CommandProcessor.stopBackground();
                        CommandProcessor.sysCmdOutputOff();
                    }
                    this.startSound();
                    this.startVisualAlarm();
                    InterfaceThreads.log(";; Alarm " + this.sdf.format(new Date()) + "  from: " + this.alarmFrom);
                }
                if (!this.alarm && this.alarmLast && this.autoreset) {
                    this.reset();
                }
                if (this.retrig) {
                    this.alarmLast = this.alarm;
                }
                this.alarmIndicator.setOn(true);
                this.alarmIndicator.setColor(this.alarm ? Color.RED : (this.alarmLast ? new Color(255, 120, 0) : Color.GREEN));
                this.scriptArm = CommandProcessor.isBackground();
            } else {
                this.alarmIndicator.setOn(false);
            }
        } else if (cmd.equalsIgnoreCase("Test")) {
            this.alarmFrom = "Test";
            this.startSound();
        } else if (cmd.equalsIgnoreCase("TestVisual")) {
            this.alarmFrom = "Test";
            this.startVisualAlarm();
        } else if (cmd.startsWith("Exp")) {
            this.expression = this.expressionTextField.getText();
        } else if (cmd.startsWith("Settings")) {
            this.showSettings(!this.settingsVisible);
        } else if (cmd.startsWith("AllOff")) {
            this.allOff = this.allOffCheckBox.isSelected();
        } else if (cmd.startsWith("Channel")) {
            this.channel = (String)this.channelComboBox.getSelectedItem();
        } else if (cmd.startsWith("Min")) {
            if (this.minTextField.getText().trim().length() == 0) {
                this.min = -1.7976931348623157E308;
                this.minTextField.setBackground(Support.colorScheme.textBackground);
                return;
            }
            try {
                this.min = StringUtil.parseDoubleEE(this.minTextField.getText());
                this.minTextField.setBackground(Double.isNaN(this.min) ? Support.colorScheme.errorBackground : Support.colorScheme.textBackground);
            }
            catch (Exception exception) {
                this.min = -1.7976931348623157E308;
                this.minTextField.setBackground(Support.colorScheme.errorBackground);
            }
        } else if (cmd.startsWith("Max")) {
            if (this.maxTextField.getText().trim().length() == 0) {
                this.max = Double.MAX_VALUE;
                this.maxTextField.setBackground(Support.colorScheme.textBackground);
                return;
            }
            try {
                this.max = StringUtil.parseDoubleEE(this.maxTextField.getText());
                this.maxTextField.setBackground(Double.isNaN(this.max) ? Support.colorScheme.errorBackground : Support.colorScheme.textBackground);
            }
            catch (Exception exception) {
                this.min = Double.MAX_VALUE;
                this.maxTextField.setBackground(Support.colorScheme.errorBackground);
            }
        } else if (cmd.startsWith("Retrig")) {
            this.retrig = this.retrigCheckBox.isSelected();
        } else if (cmd.equalsIgnoreCase("Reset")) {
            this.reset();
        } else if (cmd.startsWith("Active")) {
            this.active = this.activeCheckBox.isSelected();
            Support.math.resetCalc("Alarm" + this.number);
            if (!this.active) {
                this.reset();
            }
        } else if (cmd.startsWith("InputMethod")) {
            this.nextAlarmMode();
        } else if (cmd.startsWith("ST:")) {
            this.selectedSoundType = cmd.substring(3);
        } else if (cmd.startsWith("SP:")) {
            this.selectedSoundPattern = cmd.substring(3);
        } else if (cmd.startsWith("VP:")) {
            this.selectedVisualPattern = cmd.substring(3);
        }
    }

    private void reset() {
        this.alarm = false;
        this.alarmLast = false;
        this.alarmIndicator.setOn(false);
        if (this.audibleAlarm != null) {
            this.audibleAlarm.stopSound();
        }
        this.stopVisualAlarm();
        Support.math.resetCalc("Alarm" + this.number);
    }

    private void startSound() {
        if (this.audibleAlarm != null) {
            this.audibleAlarm.stopSound();
        }
        SoundPattern sp = this.getSoundPattern(this.selectedSoundPattern);
        this.autoreset = sp.name.toLowerCase().contains("continuous");
        this.audibleAlarm = AudibleAlarm.play(this.alarmAudioLevel, 2000, sp.interval, sp.count, this.getSoundType((String)this.selectedSoundType).as);
        this.soundIndicator.setOn(this.audibleAlarm.isPlaying());
    }

    private SoundType getSoundType(String name) {
        for (SoundType st : soundTypes) {
            if (!st.name.equalsIgnoreCase(name)) continue;
            return st;
        }
        return soundTypes.get(1);
    }

    private SoundPattern getSoundPattern(String name) {
        for (SoundPattern sp : soundPatters) {
            if (!sp.name.equalsIgnoreCase(name)) continue;
            return sp;
        }
        return soundPatters.get(0);
    }

    private VisualPattern getVisualPattern(String name) {
        for (VisualPattern sp : visualPatters) {
            if (!sp.name.equalsIgnoreCase(name)) continue;
            return sp;
        }
        return visualPatters.get(0);
    }

    private void cancelScreenSaver() {
        try {
            Point point = MouseInfo.getPointerInfo().getLocation();
            Robot robot = new Robot();
            robot.mouseMove(point.x + 1, point.y);
            robot.mouseMove(point.x, point.y);
        }
        catch (AWTException e) {
            e.printStackTrace();
        }
    }

    private void startVisualAlarm() {
        this.stopVisualAlarm();
        VisualPattern vp = this.getVisualPattern(this.selectedVisualPattern);
        if (vp.interval == 0) {
            return;
        }
        this.alarmPane = new AlarmPane(vp.interval, vp.color1, vp.color2);
        this.cancelScreenSaver();
        this.alarmPane.setVisible(true);
    }

    private void stopVisualAlarm() {
        if (this.alarmPane != null) {
            this.alarmPane.setVisible(false);
            this.alarmPane = null;
        }
    }

    private void fillChannels() {
        Object sel = this.channelComboBox.getSelectedItem();
        this.channelComboBox.removeAllItems();
        for (String s : InterfaceThreads.listChannels(true)) {
            this.channelComboBox.addItem(s);
        }
        this.channelComboBox.setSelectedItem(sel);
    }

    @Override
    public void focusGained(FocusEvent arg0) {
        JTextField f = (JTextField)arg0.getSource();
        f.selectAll();
    }

    @Override
    public void focusLost(FocusEvent arg0) {
        JTextField f = (JTextField)arg0.getSource();
        f.postActionEvent();
    }

    public static List<String> generateScript() {
        ArrayList<String> list = new ArrayList<String>();
        int n = 1;
        for (PopupAlarm pa : popupList) {
            list.add("#ShowPopupSystem Alarm " + pa.generateLocationParams());
            String visual = "";
            if (!pa.selectedVisualPattern.equalsIgnoreCase("None")) {
                visual = " \"" + pa.selectedVisualPattern + "\"";
            }
            list.add("#AdjustAlarm " + n + " " + pa.alarmAudioLevel + " \"" + pa.selectedSoundType + "\" \"" + pa.selectedSoundPattern + "\"" + visual);
            String param = "";
            switch (pa.alarmMode) {
                case expression: {
                    param = pa.expressionTextField.getText();
                    break;
                }
                case minmax: {
                    param = (String)pa.channelComboBox.getSelectedItem();
                    param = pa.minTextField.getText().trim().length() == 0 ? String.valueOf(param) + " NaN" : String.valueOf(param) + " " + pa.minTextField.getText().trim();
                    if (pa.maxTextField.getText().trim().length() == 0) {
                        param = String.valueOf(param) + " NaN";
                        break;
                    }
                    param = String.valueOf(param) + " " + pa.maxTextField.getText().trim();
                    break;
                }
            }
            list.add("#SetAlarm " + n + " " + (pa.alarmMode != AlarmMode.sweeperEventScript ? "off " : "") + (pa.allOffCheckBox.isSelected() ? 1 : 0) + " " + (pa.retrigCheckBox.isSelected() ? 1 : 0) + " " + param);
            ++n;
        }
        return list;
    }

    public static void alignGridAll(int pixels) {
        for (PopupAlarm pa : popupList) {
            pa.alignGrid(pixels);
        }
    }

    private static enum AlarmMode {
        minmax,
        expression,
        sweeperEventScript;

    }

    private class AlarmPane
    extends JDialog
    implements ActionListener,
    KeyListener {
        private Color c1;
        private Color c2;
        private Timer timer1;
        private Timer timer2;
        int cancelCount = 0;

        AlarmPane(int interval, Color c1, Color c2) {
            this.setDefaultCloseOperation(2);
            this.c1 = c1;
            this.c2 = c2;
            this.setAlwaysOnTop(true);
            this.setTitle("Test Controller Alarm from: " + PopupAlarm.this.alarmFrom);
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            this.setSize((int)((double)screenSize.width * 0.7), (int)((double)screenSize.height * 0.7));
            this.getContentPane().setBackground(c1);
            this.setLocation((screenSize.width - this.getWidth()) / 2, (screenSize.height - this.getHeight()) / 2);
            this.timer2 = new Timer(100, this);
            this.timer2.setActionCommand("Timer");
            this.timer2.start();
            this.timer1 = new Timer(interval, this);
            this.timer1.setActionCommand("Flash");
            this.timer1.start();
            this.addKeyListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getActionCommand().equalsIgnoreCase("Flash")) {
                Color c = this.getContentPane().getBackground().equals(this.c1) ? this.c2 : this.c1;
                this.getContentPane().setBackground(c);
                PopupAlarm.this.cancelScreenSaver();
            } else if (e.getActionCommand().equalsIgnoreCase("Timer") && this.cancelCount > 0) {
                --this.cancelCount;
                if (this.cancelCount == 0) {
                    this.setVisible(false);
                }
            }
        }

        @Override
        public void keyPressed(KeyEvent arg0) {
            this.cancelCount = 10;
        }

        @Override
        public void keyReleased(KeyEvent arg0) {
        }

        @Override
        public void keyTyped(KeyEvent arg0) {
        }
    }

    public static class SoundPattern {
        String name;
        int interval;
        int count;

        public SoundPattern(String name, int interval, int count) {
            this.name = name;
            this.interval = interval;
            this.count = count;
        }
    }

    private static class SoundType {
        String name;
        AudibleAlarm.AlarmSound as;

        public SoundType(String name, char generator, int f1, int f2, int ms1, int ms2) {
            this.name = name;
            this.as = new AudibleAlarm.AlarmSound(generator, f1, f2, ms1, ms2);
        }

        public String toString() {
            return this.name;
        }
    }

    public static class VisualPattern {
        String name;
        int interval;
        Color color1;
        Color color2;

        public VisualPattern(String name, int interval, Color color1, Color color2) {
            this.name = name;
            this.interval = interval;
            this.color1 = color1;
            this.color2 = color2;
        }
    }
}

