/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.main;

import dk.hkj.main.CommandProcessor;
import dk.hkj.main.FontAdjust;
import dk.hkj.main.HelpLoader;
import dk.hkj.main.IconGenerator;
import dk.hkj.main.InterfaceThreads;
import dk.hkj.main.PopupBase;
import dk.hkj.main.Support;
import dk.hkj.util.StringUtil;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.plaf.basic.BasicComboBoxRenderer;

public class PopupAdvancedLog
extends PopupBase
implements ActionListener {
    private JTextField intervalTextField;
    private JComboBox<InterfaceThreads.LoggingMode> modeComboBox;
    private JTextField nTextField;
    private JTextField triggerTextField;
    private JTextField belowTextField;
    private JTextField aboveTextField;
    private JPanel triggerPanel;
    private JComboBox<String> belowComboBox;
    private JComboBox<String> aboveComboBox;
    private JButton startButton;
    private static TrigMode trigMode = TrigMode.Above;
    private static String trigChannel = "";
    private static String trigValue = "";
    private static String trigExpression = "";
    private static double interval = 1.0;
    private static int trigCount = 100;
    private static InterfaceThreads.LoggingMode mode = InterfaceThreads.LoggingMode.Normal;
    private static Map<String, String> help = null;

    public PopupAdvancedLog(boolean toDisk) {
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.setTitle("Advanced log");
        this.setDefaultCloseOperation(2);
        this.definePopupName("AdvancedLog", false);
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = null;
        this.loadHelp();
        if (!toDisk) {
            c = new GridBagConstraints();
            c.gridx = 1;
            c.gridy = 0;
            c.insets = new Insets(5, 5, 5, 5);
            c.anchor = 13;
            this.add((Component)new FontAdjust.FontLabel("Interval:"), c);
            c = new GridBagConstraints();
            c.gridx = 2;
            c.gridy = 0;
            c.weightx = 1.0;
            c.anchor = 17;
            c.insets = new Insets(5, 5, 5, 5);
            this.intervalTextField = new FontAdjust.FontTextField(6);
            this.intervalTextField.setText(Double.toString(interval));
            this.intervalTextField.setToolTipText(help.get("IntervalTextField".toLowerCase()));
            this.intervalTextField.addActionListener(this);
            this.intervalTextField.setActionCommand("interval");
            this.intervalTextField.addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent arg0) {
                    PopupAdvancedLog.this.actionPerformed(new ActionEvent(PopupAdvancedLog.this.intervalTextField, 0, "interval"));
                }
            });
            this.add((Component)this.intervalTextField, c);
        }
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 1;
        c.anchor = 13;
        c.insets = new Insets(5, 5, 5, 5);
        this.add((Component)new FontAdjust.FontLabel("Mode:"), c);
        c = new GridBagConstraints();
        c.gridx = 2;
        c.gridy = 1;
        c.weightx = 1.0;
        c.anchor = 17;
        c.insets = new Insets(5, 5, 5, 5);
        this.modeComboBox = new FontAdjust.FontComboBox<InterfaceThreads.LoggingMode>();
        InterfaceThreads.LoggingMode[] loggingModeArray = InterfaceThreads.LoggingMode.values();
        int n = loggingModeArray.length;
        int n2 = 0;
        while (n2 < n) {
            InterfaceThreads.LoggingMode lm = loggingModeArray[n2];
            this.modeComboBox.addItem(lm);
            ++n2;
        }
        this.modeComboBox.setSelectedItem((Object)InterfaceThreads.loggingMode);
        this.modeComboBox.addActionListener(this);
        this.modeComboBox.setToolTipText(help.get("modeComboBox".toLowerCase()));
        this.modeComboBox.setActionCommand("mode");
        this.modeComboBox.setMaximumRowCount(30);
        this.modeComboBox.setRenderer(new MyComboBoxRenderer());
        this.add(this.modeComboBox, c);
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 2;
        c.insets = new Insets(5, 5, 5, 5);
        c.anchor = 13;
        this.add((Component)new FontAdjust.FontLabel("Samples (N):"), c);
        c = new GridBagConstraints();
        c.gridx = 2;
        c.gridy = 2;
        c.weightx = 1.0;
        c.anchor = 17;
        c.insets = new Insets(5, 5, 5, 5);
        this.nTextField = new FontAdjust.FontTextField(6);
        this.nTextField.setText(Integer.toString(trigCount));
        this.nTextField.setToolTipText(help.get("nTextField".toLowerCase()));
        this.nTextField.addActionListener(this);
        this.nTextField.setActionCommand("N");
        this.nTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent arg0) {
                PopupAdvancedLog.this.actionPerformed(new ActionEvent(PopupAdvancedLog.this.nTextField, 0, "N"));
            }
        });
        this.add((Component)this.nTextField, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 3;
        c.anchor = 17;
        c.insets = new Insets(5, 5, 5, 5);
        FontAdjust.FontButton changeButton = new FontAdjust.FontButton("");
        changeButton.setIcon(IconGenerator.makeIcon(IconGenerator.IconType.FieldChange));
        changeButton.setBorder(null);
        changeButton.setActionCommand("trigChange");
        changeButton.addActionListener(this);
        this.add((Component)changeButton, c);
        this.triggerPanel = new JPanel();
        this.triggerPanel.setLayout(new FlowLayout(0, 0, 0));
        this.triggerPanel.setLayout(new CardLayout());
        JPanel trig1 = new JPanel();
        trig1.setLayout(new FlowLayout(0, 0, 0));
        trig1.add(new FontAdjust.FontLabel("Expression:"));
        trig1.add(Box.createHorizontalStrut(5));
        this.triggerTextField = new FontAdjust.FontTextField(30);
        this.triggerTextField.setToolTipText(help.get("triggerTextField".toLowerCase()));
        this.triggerTextField.setText(trigExpression);
        this.triggerTextField.addActionListener(this);
        this.triggerTextField.setActionCommand("trigger");
        this.triggerTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent arg0) {
                PopupAdvancedLog.this.actionPerformed(new ActionEvent(PopupAdvancedLog.this.triggerTextField, 0, "trigger"));
            }
        });
        trig1.add(this.triggerTextField);
        this.triggerPanel.add((Component)trig1, "Trig1");
        JPanel trig2 = new JPanel();
        trig2.setLayout(new FlowLayout(0, 0, 0));
        trig2.add(new FontAdjust.FontLabel("Trig below:"));
        trig2.add(Box.createHorizontalStrut(5));
        this.belowComboBox = new FontAdjust.FontComboBox<String>();
        for (String s : InterfaceThreads.listChannels(true)) {
            this.belowComboBox.addItem(s);
        }
        this.belowComboBox.setSelectedItem(trigChannel);
        this.belowComboBox.setActionCommand("belowChannel");
        this.belowComboBox.addActionListener(this);
        trig2.add(this.belowComboBox);
        trig2.add(Box.createHorizontalStrut(5));
        this.belowTextField = new FontAdjust.FontTextField(6);
        this.belowTextField.setText(trigValue);
        this.belowTextField.addActionListener(this);
        this.belowTextField.setActionCommand("trigBelow");
        this.belowTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent arg0) {
                PopupAdvancedLog.this.actionPerformed(new ActionEvent(PopupAdvancedLog.this.belowTextField, 0, "trigBelow"));
            }
        });
        trig2.add(this.belowTextField);
        this.triggerPanel.add((Component)trig2, "Trig2");
        JPanel trig3 = new JPanel();
        trig3.setLayout(new FlowLayout(0, 0, 0));
        trig3.add(new FontAdjust.FontLabel("Trig above:"));
        trig3.add(Box.createHorizontalStrut(5));
        this.aboveComboBox = new FontAdjust.FontComboBox<String>();
        for (String s : InterfaceThreads.listChannels(true)) {
            this.aboveComboBox.addItem(s);
        }
        this.aboveComboBox.setSelectedItem(trigChannel);
        this.aboveComboBox.setActionCommand("belowChannel");
        this.aboveComboBox.addActionListener(this);
        trig3.add(this.aboveComboBox);
        trig3.add(Box.createHorizontalStrut(5));
        this.aboveTextField = new FontAdjust.FontTextField(6);
        this.aboveTextField.setText(trigValue);
        this.aboveTextField.addActionListener(this);
        this.aboveTextField.setActionCommand("trigAbove");
        this.aboveTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent arg0) {
                PopupAdvancedLog.this.actionPerformed(new ActionEvent(PopupAdvancedLog.this.aboveTextField, 0, "trigAbove"));
            }
        });
        if (trigChannel == null || trigChannel.isEmpty()) {
            trigChannel = this.aboveComboBox.getItemAt(0);
        }
        trig3.add(this.aboveTextField);
        this.triggerPanel.add((Component)trig3, "Trig3");
        switch (trigMode) {
            case Above: {
                ((CardLayout)this.triggerPanel.getLayout()).show(this.triggerPanel, "Trig3");
                break;
            }
            case Below: {
                ((CardLayout)this.triggerPanel.getLayout()).show(this.triggerPanel, "Trig2");
                break;
            }
            case Expression: {
                ((CardLayout)this.triggerPanel.getLayout()).show(this.triggerPanel, "Trig1");
                break;
            }
        }
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridwidth = 2;
        c.gridy = 3;
        c.anchor = 13;
        c.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.triggerPanel, c);
        c = new GridBagConstraints();
        c.gridx = 2;
        c.gridy = 4;
        c.weightx = 1.0;
        c.anchor = 13;
        c.insets = new Insets(5, 5, 5, 5);
        this.startButton = new FontAdjust.FontButton(toDisk ? "Ok" : "Log");
        this.startButton.addActionListener(this);
        this.startButton.setActionCommand(toDisk ? "Ok" : "Log");
        this.add((Component)this.startButton, c);
        this.pack();
        this.setUIEnabled();
    }

    @Override
    public void actionPerformed(ActionEvent cmd) {
        block36: {
            if (cmd.getActionCommand().equals("Ok")) {
                this.setTrig();
                this.setVisible(false);
            } else if (cmd.getActionCommand().equals("Log")) {
                this.setTrig();
                CommandProcessor.sysCmdLog(interval, null, false);
                this.setVisible(false);
            } else if (cmd.getActionCommand().equals("trigChange")) {
                ((CardLayout)this.triggerPanel.getLayout()).next(this.triggerPanel);
                trigMode = this.belowComboBox.getParent().isVisible() ? TrigMode.Below : (this.aboveComboBox.getParent().isVisible() ? TrigMode.Above : TrigMode.Expression);
                switch (trigMode) {
                    case Expression: {
                        break;
                    }
                    case Above: {
                        this.aboveComboBox.setSelectedItem(trigChannel);
                        this.aboveTextField.setText(trigValue);
                        break;
                    }
                    case Below: {
                        this.belowTextField.setText(trigValue);
                        this.belowComboBox.setSelectedItem(trigChannel);
                    }
                }
            } else if (cmd.getActionCommand().equals("belowChannel")) {
                trigChannel = (String)this.belowComboBox.getSelectedItem();
            } else if (cmd.getActionCommand().equals("aboveChannel")) {
                trigChannel = (String)this.aboveComboBox.getSelectedItem();
            } else if (cmd.getActionCommand().equals("trigAbove")) {
                try {
                    StringUtil.parseDoubleEE(this.aboveTextField.getText());
                    trigValue = this.aboveTextField.getText();
                    this.aboveTextField.setBackground(Support.colorScheme.textBackground);
                }
                catch (Exception exception) {
                    this.aboveTextField.setBackground(Support.colorScheme.errorBackground);
                }
            } else if (cmd.getActionCommand().equals("trigBelow")) {
                try {
                    StringUtil.parseDoubleEE(this.belowTextField.getText());
                    trigValue = this.belowTextField.getText();
                    this.belowTextField.setBackground(Support.colorScheme.textBackground);
                }
                catch (Exception exception) {
                    this.belowTextField.setBackground(Support.colorScheme.errorBackground);
                }
            } else if (cmd.getActionCommand().equals("trigger")) {
                trigExpression = this.triggerTextField.getText();
            } else if (cmd.getActionCommand().equals("interval")) {
                try {
                    interval = Double.parseDouble(this.intervalTextField.getText().replace(',', '.'));
                    if (interval < 0.01 || interval > 3600.0) {
                        this.intervalTextField.setBackground(Support.colorScheme.errorBackground);
                        break block36;
                    }
                    this.intervalTextField.setBackground(Support.colorScheme.textBackground);
                }
                catch (Exception exception) {
                    this.intervalTextField.setBackground(Support.colorScheme.errorBackground);
                }
            } else if (cmd.getActionCommand().equals("N")) {
                try {
                    trigCount = StringUtil.parseInt(this.nTextField.getText());
                    if (trigCount < 1 || trigCount > 10000) {
                        this.nTextField.setBackground(Support.colorScheme.errorBackground);
                        break block36;
                    }
                    this.nTextField.setBackground(Support.colorScheme.textBackground);
                }
                catch (Exception exception) {
                    this.nTextField.setBackground(Support.colorScheme.errorBackground);
                }
            } else if (cmd.getActionCommand().equals("mode")) {
                mode = (InterfaceThreads.LoggingMode)((Object)this.modeComboBox.getSelectedItem());
                this.setUIEnabled();
            }
        }
    }

    private void setUIEnabled() {
        this.triggerTextField.setEnabled(InterfaceThreads.isTrig(mode));
        this.aboveComboBox.setEnabled(InterfaceThreads.isTrig(mode));
        this.aboveTextField.setEnabled(InterfaceThreads.isTrig(mode));
        this.belowComboBox.setEnabled(InterfaceThreads.isTrig(mode));
        this.belowTextField.setEnabled(InterfaceThreads.isTrig(mode));
        this.nTextField.setEnabled(mode == InterfaceThreads.LoggingMode.NOnCommand || mode == InterfaceThreads.LoggingMode.NOnTrig || mode == InterfaceThreads.LoggingMode.WhileTrigOrN || mode == InterfaceThreads.LoggingMode.StopOnTrigOrN);
    }

    private void putHelp(String key, String value) {
        help.put(key.trim().toLowerCase(), "<html>" + value.replace("\n", "<br>") + "</html>");
    }

    private void setTrig() {
        InterfaceThreads.loggingMode = mode;
        InterfaceThreads.lastTrig = false;
        InterfaceThreads.hasTriggered = false;
        InterfaceThreads.trigLogCount = trigCount;
        switch (trigMode) {
            case Expression: {
                InterfaceThreads.trigExpression = trigExpression;
                break;
            }
            case Above: {
                InterfaceThreads.trigExpression = String.valueOf(trigChannel) + ">=" + trigValue.replace(',', '.');
                break;
            }
            case Below: {
                InterfaceThreads.trigExpression = String.valueOf(trigChannel) + "<=" + trigValue.replace(',', '.');
            }
        }
    }

    public void loadHelp() {
        if (help == null) {
            List<String> list = HelpLoader.getHelpFile("LogTriggerHelp");
            StringBuilder sb = new StringBuilder();
            String key = "";
            help = new HashMap<String, String>();
            for (String s : list) {
                if (s.length() > 0 && Character.isAlphabetic(s.charAt(0))) {
                    if (key.length() > 0) {
                        this.putHelp(key, sb.toString());
                        sb.setLength(0);
                    }
                    key = s;
                    continue;
                }
                if (sb.length() > 0) {
                    sb.append("\n");
                }
                sb.append(s.trim());
            }
            if (key.length() > 0) {
                this.putHelp(key, sb.toString());
                sb.setLength(0);
            }
        }
    }

    private static class MyComboBoxRenderer
    extends BasicComboBoxRenderer {
        private MyComboBoxRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
                if (-1 < index) {
                    InterfaceThreads.LoggingMode lm = (InterfaceThreads.LoggingMode)((Object)list.getModel().getElementAt(index));
                    String s = null;
                    if (lm != null) {
                        s = (String)help.get(lm.name().toLowerCase());
                    }
                    list.setToolTipText(s != null && s.length() > 0 ? s : null);
                } else {
                    list.setToolTipText(null);
                }
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.setFont(list.getFont());
            this.setText(value == null ? "" : value.toString());
            return this;
        }
    }

    private static enum TrigMode {
        Expression,
        Below,
        Above;

    }
}

