/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.main;

import dk.hkj.main.DeviceInterface;
import dk.hkj.main.FontAdjust;
import dk.hkj.main.InterfaceThreads;
import dk.hkj.main.Mathematics;
import dk.hkj.main.PopupBase;
import dk.hkj.main.Support;
import dk.hkj.main.ValueFormat;
import dk.hkj.util.ElectronicUtils;
import dk.hkj.util.StringUtil;
import dk.hkj.vars.Var;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.Timer;

public class PopupAdjustScale
extends PopupBase
implements ActionListener,
FocusListener,
MouseListener {
    private final int ZOOM_DELAY = 1500;
    private final int SMOOTH_BUFFER_SIZE = 1500;
    private final Color backgroundColor = new Color(246, 255, 158);
    private final Color needleColor = new Color(255, 28, 0);
    private final Color tickColor = new Color(200, 150, 0);
    private final Color refTickColor = new Color(0, 255, 0);
    private final Color minmaxTickColor = new Color(50, 50, 255);
    private final Color refMarkColor = new Color(0, 255, 0);
    private final Color textColor = new Color(0, 0, 0);
    private final int scaleMargin = 20;
    private final int tickSize = 10;
    private final int smallTickSize = 4;
    private static List<PopupAdjustScale> popupList = new ArrayList<PopupAdjustScale>();
    private JPanel imagePanel;
    private BufferedImage image = new BufferedImage(700, 120, 1);
    private JComboBox<String> channelComboBox;
    private JTextField referenceTextField;
    private JTextField toleranceTextField;
    private JLabel valueLabel;
    private JLabel errorValLabel;
    private JLabel errorPctLabel;
    private Timer timer;
    private JPopupMenu popupMenu;
    private NumberFormat pctFormat;
    private NumberFormat nf;
    private String selectedChannelName = "";
    private AdjustMode adjustMode = AdjustMode.ref;
    private double reference = Double.NaN;
    private ToleranceType toleranceType = ToleranceType.percent;
    private double toleranceMin = Double.NaN;
    private double toleranceMax = Double.NaN;
    private double toleranceAbsMin = 0.0;
    private double toleranceAbsMax = 0.0;
    private double scaleMin = 0.0;
    private double scaleMax = 0.0;
    private double tickStep = 1.0;
    private double lastValue = 0.0;
    private Sample[] smoothBuffer = null;
    private int nsmooth = 0;
    private long smoothTime;
    private long zoomRequest = 0L;
    private JMenuItem adjustModeRefMenuItem = null;
    private JMenuItem useSIMenuItem = null;
    private boolean useSI = true;
    private String handle = null;

    private PopupAdjustScale(String handle) {
        this.handle = handle;
        this.pctFormat = NumberFormat.getInstance(Locale.US);
        this.pctFormat.setGroupingUsed(false);
        this.pctFormat.setMaximumFractionDigits(2);
        this.nf = NumberFormat.getInstance(Locale.US);
        this.nf.setGroupingUsed(false);
        this.nf.setMaximumFractionDigits(10);
        this.setPreferredSize(new Dimension(700, 135));
        popupList.add(this);
        if (popupList.size() > 1) {
            this.disableSaveLocation();
        }
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent e) {
                if (PopupAdjustScale.this.timer != null) {
                    PopupAdjustScale.this.timer.stop();
                    PopupAdjustScale.this.timer = null;
                }
                Support.math.removeDomain("AdjustScale");
                popupList.remove(PopupAdjustScale.this);
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                if (PopupAdjustScale.this.timer != null) {
                    PopupAdjustScale.this.timer.stop();
                    PopupAdjustScale.this.timer = null;
                }
                Support.math.removeDomain("AdjustScale");
                popupList.remove(PopupAdjustScale.this);
            }
        });
        this.setAlwaysOnTop(true);
        this.setTitle("Adjust scale");
        this.setDefaultCloseOperation(2);
        this.definePopupName("AdjustScale", true);
        FontMetrics fm = this.getFontMetrics(FontAdjust.fontSizes.textFont);
        Dimension minRefDim = new Dimension(fm.stringWidth("88.88888"), 25);
        Dimension minTolDim = new Dimension(fm.stringWidth("8.88888 8.88888xxx"), 25);
        fm = this.getFontMetrics(FontAdjust.fontSizes.uiFont);
        Dimension labelValDim = new Dimension(fm.stringWidth("888.8888888xxx"), 25);
        Dimension labelErrorValDim = new Dimension(fm.stringWidth("888.8888888xxxx"), 25);
        Dimension labelErrorPctDim = new Dimension(fm.stringWidth("+888.88ppm"), 25);
        ButtonGroup bg = new ButtonGroup();
        this.popupMenu = new JPopupMenu();
        JMenuItem mi = new FontAdjust.FontRadioButtonMenuItem("No smoothing");
        bg.add(mi);
        mi.setSelected(true);
        mi.setActionCommand("S0");
        mi.addActionListener(this);
        this.popupMenu.add(mi);
        mi = new FontAdjust.FontRadioButtonMenuItem("Smooth 1 second");
        bg.add(mi);
        mi.setActionCommand("S1000");
        mi.addActionListener(this);
        this.popupMenu.add(mi);
        mi = new FontAdjust.FontRadioButtonMenuItem("Smooth 3 seconds");
        bg.add(mi);
        mi.setActionCommand("S3000");
        mi.addActionListener(this);
        this.popupMenu.add(mi);
        mi = new FontAdjust.FontRadioButtonMenuItem("Smooth 10 seconds");
        bg.add(mi);
        mi.setActionCommand("S10000");
        mi.addActionListener(this);
        this.popupMenu.add(mi);
        mi = new FontAdjust.FontRadioButtonMenuItem("Smooth 30 seconds");
        bg.add(mi);
        mi.setActionCommand("S30000");
        mi.addActionListener(this);
        this.popupMenu.add(mi);
        mi = new FontAdjust.FontRadioButtonMenuItem("Smooth 1 minute");
        bg.add(mi);
        mi.setActionCommand("S60000");
        mi.addActionListener(this);
        this.popupMenu.add(mi);
        mi = new FontAdjust.FontRadioButtonMenuItem("Smooth 2 minutes");
        bg.add(mi);
        mi.setActionCommand("S120000");
        mi.addActionListener(this);
        this.popupMenu.add(mi);
        bg = new ButtonGroup();
        this.popupMenu.addSeparator();
        mi = new FontAdjust.FontRadioButtonMenuItem("Adjust for ref");
        bg.add(mi);
        mi.setActionCommand("ref");
        mi.addActionListener(this);
        this.adjustModeRefMenuItem = mi;
        mi.setSelected(true);
        this.popupMenu.add(mi);
        mi = new FontAdjust.FontRadioButtonMenuItem("Adjust for min");
        bg.add(mi);
        mi.setActionCommand("min");
        mi.addActionListener(this);
        this.popupMenu.add(mi);
        mi = new FontAdjust.FontRadioButtonMenuItem("Adjust for max");
        bg.add(mi);
        mi.setActionCommand("max");
        mi.addActionListener(this);
        this.popupMenu.add(mi);
        this.add(this.popupMenu);
        this.addMouseListener(this);
        mi = new FontAdjust.FontCheckBoxMenuItem("Use SI format");
        mi.setSelected(true);
        mi.setActionCommand("SI");
        mi.addActionListener(this);
        this.useSIMenuItem = mi;
        this.popupMenu.add(mi);
        this.add(this.popupMenu);
        this.addMouseListener(this);
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = null;
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.gridwidth = 20;
        c.anchor = 10;
        c.fill = 1;
        c.weighty = 1.0;
        c.insets = new Insets(5, 5, 0, 5);
        this.imagePanel = new JPanel(){

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                g.drawImage(PopupAdjustScale.this.image, 0, 0, null);
            }
        };
        this.add((Component)this.imagePanel, c);
        this.imagePanel.add(this.popupMenu);
        int n = 0;
        c = new GridBagConstraints();
        c.gridx = n++;
        c.gridy = 1;
        c.weightx = 1.0;
        c.anchor = 17;
        c.insets = new Insets(0, 5, 5, 5);
        this.channelComboBox = new FontAdjust.FontComboBox<String>();
        this.channelComboBox.addActionListener(this);
        this.channelComboBox.setActionCommand("channel");
        this.channelComboBox.setMaximumRowCount(30);
        this.fillChannels(handle);
        if (this.channelComboBox.getItemCount() > 0) {
            this.channelComboBox.setSelectedIndex(0);
        }
        this.add(this.channelComboBox, c);
        c = new GridBagConstraints();
        c.gridx = n++;
        c.gridy = 1;
        c.insets = new Insets(0, 5, 5, 2);
        c.anchor = 13;
        this.add((Component)new FontAdjust.FontLabel("Ref:"), c);
        c = new GridBagConstraints();
        c.gridx = n++;
        c.gridy = 1;
        c.weightx = 1.0;
        c.anchor = 17;
        c.insets = new Insets(0, 2, 5, 5);
        this.referenceTextField = new FontAdjust.FontTextField(6);
        this.referenceTextField.addActionListener(this);
        this.referenceTextField.setActionCommand("reference");
        this.referenceTextField.setToolTipText("Specify target value, a marker will be shown on the scale");
        this.referenceTextField.setMinimumSize(minRefDim);
        this.referenceTextField.addFocusListener(this);
        this.add((Component)this.referenceTextField, c);
        c = new GridBagConstraints();
        c.gridx = n++;
        c.gridy = 1;
        c.insets = new Insets(0, 5, 5, 2);
        c.anchor = 13;
        this.add((Component)new FontAdjust.FontLabel("Tol:"), c);
        c = new GridBagConstraints();
        c.gridx = n++;
        c.gridy = 1;
        c.weightx = 1.0;
        c.anchor = 17;
        c.insets = new Insets(0, 2, 5, 5);
        this.toleranceTextField = new FontAdjust.FontTextField(10);
        this.toleranceTextField.addActionListener(this);
        this.toleranceTextField.setActionCommand("tolerance");
        this.toleranceTextField.setMinimumSize(minTolDim);
        this.toleranceTextField.setToolTipText("<html>Specify tolerance, it will be marked on the scale and the scale will center around the reference value.<br>Tolerance formats:<br>value: A +/- relative tolerance<br>value%: A +/- percent tolerance<br>value ppm: A +/- ppm tolerance<br>value value: A - and + tolerance, can be either relative or absolute depending on values and sign<br>value% value%: A - and + percent tolerance (Sign is optional, only one % sign is needed)<br>value ppm value ppm: A - and + ppm tolerance (Sign is optional, only one ppm is needed)");
        this.toleranceTextField.addFocusListener(this);
        this.add((Component)this.toleranceTextField, c);
        c = new GridBagConstraints();
        c.gridx = n++;
        c.gridy = 1;
        c.insets = new Insets(0, 5, 5, 4);
        c.anchor = 17;
        this.valueLabel = new FontAdjust.FontLabel("");
        this.valueLabel.setMinimumSize(labelValDim);
        this.valueLabel.setToolTipText("Measured value");
        this.add((Component)this.valueLabel, c);
        c = new GridBagConstraints();
        c.gridx = n++;
        c.gridy = 1;
        c.insets = new Insets(0, 4, 5, 4);
        c.anchor = 17;
        this.errorValLabel = new FontAdjust.FontLabel("");
        this.errorValLabel.setMinimumSize(labelErrorValDim);
        this.valueLabel.setToolTipText("Difference between measured value and ref");
        this.add((Component)this.errorValLabel, c);
        c = new GridBagConstraints();
        c.gridx = n++;
        c.gridy = 1;
        c.insets = new Insets(0, 4, 5, 2);
        c.anchor = 17;
        this.errorPctLabel = new FontAdjust.FontLabel("");
        this.errorPctLabel.setMinimumSize(labelErrorPctDim);
        this.valueLabel.setToolTipText("Difference between measured value and ref in percent or ppm");
        this.add((Component)this.errorPctLabel, c);
        this.calculateAbsTolerance();
        this.paintScale();
        this.timer = new Timer(100, this);
        this.timer.setActionCommand("timer");
        this.timer.start();
        this.pack();
    }

    @Override
    public void actionPerformed(ActionEvent cmd) {
        if (cmd.getActionCommand().equals("timer")) {
            this.timerUpdate();
        } else if (cmd.getActionCommand().equals("channel")) {
            this.selectedChannelName = (String)this.channelComboBox.getSelectedItem();
            Support.math.resetCalc("AdjustScale");
            this.nsmooth = 0;
        } else if (cmd.getActionCommand().equals("reference")) {
            this.adjustMode = AdjustMode.ref;
            if (this.adjustModeRefMenuItem != null) {
                this.adjustModeRefMenuItem.setSelected(true);
            }
            this.parseReference();
        } else if (cmd.getActionCommand().equals("tolerance")) {
            this.parseTolerance();
        } else if (cmd.getActionCommand().equals("ref")) {
            this.adjustMode = AdjustMode.ref;
        } else if (cmd.getActionCommand().equals("min")) {
            this.referenceTextField.setText("");
            this.adjustMode = AdjustMode.min;
            this.reference = this.lastValue;
        } else if (cmd.getActionCommand().equals("max")) {
            this.referenceTextField.setText("");
            this.adjustMode = AdjustMode.max;
            this.reference = this.lastValue;
        } else if (cmd.getActionCommand().equals("SI")) {
            this.useSI = this.useSIMenuItem.isSelected();
        } else if (cmd.getActionCommand().matches("S[0-9]+")) {
            int n = Integer.parseInt(cmd.getActionCommand().substring(1));
            this.smoothTime = n;
            if (n <= 1) {
                this.nsmooth = 0;
                this.smoothBuffer = null;
            } else if (this.smoothBuffer == null) {
                this.nsmooth = 0;
                this.smoothBuffer = new Sample[1500];
            }
        }
    }

    private void parseReference() {
        try {
            String line = this.referenceTextField.getText().replace(',', '.').trim();
            if (line.length() == 0) {
                this.reference = Double.NaN;
                this.referenceTextField.setBackground(Support.colorScheme.textBackground);
                this.calculateAbsTolerance();
                this.adjustScale(true);
                return;
            }
            double v = StringUtil.parseDoubleEE(line);
            if (Double.isNaN(v)) {
                this.referenceTextField.setBackground(Support.colorScheme.errorBackground);
            } else {
                this.referenceTextField.setBackground(Support.colorScheme.textBackground);
                this.reference = v;
                this.calculateAbsTolerance();
                this.adjustScale(true);
            }
        }
        catch (Exception exception) {
            this.referenceTextField.setBackground(Support.colorScheme.errorBackground);
        }
    }

    private void parseTolerance() {
        try {
            int i;
            String line = this.toleranceTextField.getText().trim();
            if (line.length() == 0) {
                this.toleranceMin = Double.NaN;
                this.toleranceMax = Double.NaN;
                this.toleranceTextField.setBackground(Support.colorScheme.textBackground);
                this.adjustScale(true);
                return;
            }
            boolean pct = line.contains("%");
            double pctDiv = 100.0;
            if (pct) {
                line = line.replace("%", "").trim();
            }
            if (!pct && line.contains("ppm")) {
                pct = true;
                pctDiv = 1000000.0;
                line = line.replace("ppm", "").trim();
            }
            if ((i = line.indexOf(32)) < 0) {
                double a = Math.abs(StringUtil.parseDoubleEE(line));
                if (pct) {
                    if (a > 100.0) {
                        a = 100.0;
                    }
                    this.toleranceMin = -a / pctDiv;
                    this.toleranceMax = a / pctDiv;
                    this.toleranceType = ToleranceType.percent;
                } else {
                    this.toleranceMin = -a;
                    this.toleranceMax = a;
                    this.toleranceType = ToleranceType.relative;
                }
            } else {
                String vmin = line.substring(0, i).trim();
                String vmax = line.substring(i + 1).trim();
                double a1 = StringUtil.parseDoubleEE(vmin);
                double a2 = StringUtil.parseDoubleEE(vmax);
                if (pct) {
                    a1 = Math.abs(a1);
                    a2 = Math.abs(a2);
                    if (a1 > 100.0) {
                        a1 = 100.0;
                    }
                    if (a2 > 100.0) {
                        a2 = 100.0;
                    }
                    this.toleranceMin = -a1 / pctDiv;
                    this.toleranceMax = a2 / pctDiv;
                    this.toleranceType = ToleranceType.percent;
                } else if (a1 < 0.0 && a2 > 0.0 || a1 > this.reference || a2 < this.reference) {
                    this.toleranceMin = -a1;
                    this.toleranceMax = a2;
                    this.toleranceType = ToleranceType.relative;
                } else {
                    this.toleranceMin = a1;
                    this.toleranceMax = a2;
                    this.toleranceType = ToleranceType.absolute;
                }
            }
        }
        catch (Exception exception) {
            this.toleranceMin = Double.NaN;
            this.toleranceMax = Double.NaN;
        }
        if (Double.isNaN(this.toleranceMin) || Double.isNaN(this.toleranceMax)) {
            this.toleranceTextField.setBackground(Support.colorScheme.errorBackground);
            this.toleranceMin = Double.NaN;
            this.toleranceMax = Double.NaN;
        } else {
            this.toleranceTextField.setBackground(Support.colorScheme.textBackground);
        }
        this.calculateAbsTolerance();
        this.adjustScale(true);
    }

    private void calculateAbsTolerance() {
        switch (this.toleranceType) {
            case absolute: {
                this.toleranceAbsMin = this.toleranceMin;
                this.toleranceAbsMax = this.toleranceMax;
                break;
            }
            case relative: {
                this.toleranceAbsMin = this.reference + this.toleranceMin;
                this.toleranceAbsMax = this.reference + this.toleranceMax;
                break;
            }
            case percent: {
                this.toleranceAbsMin = this.reference * (1.0 + this.toleranceMin);
                this.toleranceAbsMax = this.reference * (1.0 + this.toleranceMax);
            }
        }
    }

    private void timerUpdate() {
        try {
            boolean valueValid = false;
            InterfaceThreads.setupVars();
            DeviceInterface di = InterfaceThreads.getLoadedDeviceInterfaceHandle(this.selectedChannelName);
            Mathematics.MathEntry me = null;
            ValueFormat fmt = null;
            if (di != null) {
                List<String> vn = di.getValueNameList();
                if (vn.size() == 1) {
                    this.selectedChannelName = String.valueOf(di.getHandleName()) + "." + vn.get(0);
                    if (!this.selectedChannelName.equals(this.channelComboBox.getSelectedItem())) {
                        this.fillChannels(this.handle);
                        this.channelComboBox.setSelectedItem(this.selectedChannelName);
                    }
                    valueValid = true;
                } else {
                    String s = this.selectedChannelName.substring(di.getHandleName().length() + 1);
                    valueValid = vn.contains(s);
                }
                fmt = di.getValueFormat(this.selectedChannelName);
            } else if (this.selectedChannelName != null) {
                int i = this.selectedChannelName.indexOf(46);
                if (i > 0) {
                    me = Support.math.getEntry(this.selectedChannelName.substring(i + 1));
                }
                boolean bl = valueValid = me != null && me.isEnabled();
                if (valueValid) {
                    Var.gl.getCreate(this.selectedChannelName).set(me.calcDirect("AdjustScale", (double)System.currentTimeMillis() / 1000.0));
                    fmt = me.getValueFormat();
                }
            }
            if (valueValid) {
                Var v = Var.gl.get(this.selectedChannelName);
                if (this.smoothBuffer == null) {
                    this.lastValue = v.asDouble();
                } else {
                    int i = this.smoothBuffer.length - 1;
                    while (i > 0) {
                        this.smoothBuffer[i] = this.smoothBuffer[i - 1];
                        --i;
                    }
                    this.smoothBuffer[0] = new Sample(System.currentTimeMillis(), v.asDouble());
                    if (this.nsmooth < this.smoothBuffer.length) {
                        ++this.nsmooth;
                    }
                    this.lastValue = 0.0;
                    long cutoffTime = System.currentTimeMillis() - this.smoothTime;
                    int j = 0;
                    int i2 = 0;
                    while (i2 < this.nsmooth && this.smoothBuffer[i2].time >= cutoffTime) {
                        this.lastValue += this.smoothBuffer[i2].value;
                        ++j;
                        ++i2;
                    }
                    this.lastValue = j > 0 ? (this.lastValue /= (double)j) : v.asDouble();
                }
                if (this.adjustMode == AdjustMode.min && this.lastValue < this.reference) {
                    this.reference = this.lastValue;
                    if (this.useSI) {
                        this.referenceTextField.setText(StringUtil.formatDoubleEE(this.reference, false));
                    } else {
                        this.referenceTextField.setText(this.nf.format(this.reference));
                    }
                    this.calculateAbsTolerance();
                } else if (this.adjustMode == AdjustMode.max && this.lastValue > this.reference) {
                    this.reference = this.lastValue;
                    if (this.useSI) {
                        this.referenceTextField.setText(StringUtil.formatDoubleEE(this.reference, false));
                    } else {
                        this.referenceTextField.setText(this.nf.format(this.reference));
                    }
                    this.calculateAbsTolerance();
                }
                this.valueLabel.setText(String.valueOf(fmt.format.formatDisplay(this.lastValue)) + fmt.unit);
                if (!Double.isNaN(this.reference)) {
                    double delta = this.lastValue - this.reference;
                    this.errorValLabel.setText(String.valueOf(delta > 0.0 ? "+" : "") + fmt.format.formatDisplay(delta) + fmt.unit);
                    if (this.reference == 0.0) {
                        this.errorPctLabel.setText("");
                    } else if (Math.abs(delta /= this.reference) < 0.001) {
                        this.errorPctLabel.setText(String.valueOf(delta > 0.0 ? "+" : "") + this.pctFormat.format(delta * 1000000.0) + "ppm");
                    } else if (delta < 1.0) {
                        this.errorPctLabel.setText(String.valueOf(delta > 0.0 ? "+" : "") + this.pctFormat.format(delta * 100.0) + "%");
                    } else {
                        this.errorPctLabel.setText("");
                    }
                } else {
                    this.errorValLabel.setText("");
                    this.errorPctLabel.setText("");
                }
            } else {
                this.valueLabel.setText("----");
                this.errorValLabel.setText("");
                this.errorPctLabel.setText("");
            }
        }
        catch (Exception e) {
            this.valueLabel.setText("----");
            this.errorValLabel.setText("");
            this.errorPctLabel.setText("");
            e.printStackTrace();
        }
        this.paintScale();
        this.repaint();
    }

    private void adjustScale(boolean force) {
        boolean changeRange = false;
        boolean center = !Double.isNaN(this.toleranceMin) && !Double.isNaN(this.reference);
        double value = center ? this.lastValue - this.reference : this.lastValue;
        boolean bl = changeRange = this.scaleMin > this.lastValue || this.scaleMax < this.lastValue || this.scaleMin == this.scaleMax;
        if (!changeRange) {
            if (center) {
                if (this.scaleMax - this.scaleMin > this.toleranceAbsMax - this.toleranceAbsMin) {
                    changeRange |= value < (this.scaleMax - this.reference) / 3.0 && value > (this.scaleMin - this.reference) / 3.0;
                }
            } else {
                changeRange = Double.isNaN(this.reference) ? (changeRange |= this.lastValue < this.scaleMax / 3.0 && this.lastValue > this.scaleMin / 3.0) : (changeRange |= this.lastValue < this.scaleMax / 3.0 && this.lastValue > this.scaleMin / 5.0 && this.reference < this.scaleMax / 3.0 && this.reference > this.scaleMin / 3.0);
            }
            if (!changeRange) {
                this.zoomRequest = System.currentTimeMillis();
            }
            if (changeRange && System.currentTimeMillis() - this.zoomRequest < 1500L) {
                changeRange = false;
            }
        }
        if (changeRange || force) {
            ElectronicUtils.SeriesIndex r;
            double range = Math.abs(value);
            if (!center && !Double.isNaN(this.reference) && Math.abs(this.reference) > range) {
                range = Math.abs(this.reference);
            }
            if ((r = ElectronicUtils.findIndex(125, range *= 1.2)).getValue() < range) {
                r.next();
            }
            range = r.getValue();
            boolean dd = true;
            if (center) {
                this.scaleMin = this.reference;
                this.scaleMax = this.reference;
                if (range < this.toleranceAbsMax - this.toleranceAbsMin) {
                    double v = Math.max(Math.abs(Math.min(this.lastValue, this.toleranceAbsMin) - this.reference), Math.abs(Math.max(this.lastValue, this.toleranceAbsMax) - this.reference));
                    this.scaleMin = this.reference - v;
                    this.scaleMax = this.reference + v;
                    range = this.scaleMax - this.scaleMin;
                    r = null;
                } else {
                    this.scaleMin = -range + this.reference;
                    this.scaleMax = range + this.reference;
                }
            } else {
                this.scaleMin = 0.0;
                this.scaleMax = 0.0;
                if (value < 0.0 || this.reference < 0.0) {
                    this.scaleMin = -range;
                }
                if (value > 0.0 || this.reference > 0.0) {
                    this.scaleMax = range;
                }
                boolean bl2 = dd = this.scaleMin < 0.0 && this.scaleMax > 0.0;
            }
            if (this.scaleMin == this.scaleMax) {
                this.scaleMin -= 5.0E-13;
                this.scaleMax += 5.0E-13;
                r = null;
                range = this.scaleMax - this.scaleMin;
            }
            this.tickStep = r == null ? range / (double)(dd ? 5 : 10) : (r.getSeriesEntry() == 1.0 || r.getSeriesEntry() == 10.0 ? range / (double)(dd ? 5 : 10) : (r.getSeriesEntry() == 2.0 ? range / (double)(dd ? 4 : 8) : (r.getSeriesEntry() == 5.0 ? range / (double)(dd ? 5 : 10) : range / (double)(dd ? 5 : 10))));
        }
    }

    private int scalePixel(int w, double value) {
        return (int)Math.round((value - this.scaleMin) / (this.scaleMax - this.scaleMin) * (double)(w - 40)) + 20;
    }

    private void paintScale() {
        int w = this.getWidth() - 30;
        if (w < 100) {
            w = 100;
        }
        int h = 55;
        this.image = new BufferedImage(w, h, 1);
        Dimension dim = new Dimension(w + 30, h + 10);
        this.imagePanel.setPreferredSize(dim);
        this.imagePanel.setMinimumSize(dim);
        this.imagePanel.setMaximumSize(dim);
        Graphics g = this.image.getGraphics();
        g.setFont(FontAdjust.fontSizes.uiFont);
        FontMetrics fm = g.getFontMetrics();
        int tickStart = fm.getAscent() + fm.getDescent();
        g.setColor(this.backgroundColor);
        g.fillRect(0, 0, w, h);
        this.adjustScale(false);
        if (!Double.isNaN(this.toleranceMin)) {
            g.setColor(this.refMarkColor);
            int m1 = this.scalePixel(w, this.toleranceAbsMin);
            int m2 = this.scalePixel(w, this.toleranceAbsMax);
            g.fillRect(m1, h - tickStart - 10, m2 - m1, 10);
        }
        if (!Double.isNaN(this.reference)) {
            int m = this.scalePixel(w, this.reference);
            g.setColor(this.adjustMode == AdjustMode.ref ? this.refTickColor : this.minmaxTickColor);
            g.drawLine(m, h, m, h - tickStart - 30);
            g.drawLine(m - 1, h, m - 1, h - tickStart - 10);
            g.drawLine(m + 1, h, m + 1, h - tickStart - 10);
        }
        double max = Math.max(Math.abs(this.scaleMin), Math.abs(this.scaleMax));
        if (this.tickStep > 0.0) {
            double pos = this.scaleMin;
            while (pos <= this.scaleMax) {
                if (Math.abs(pos) < max * 1.0E-10) {
                    pos = 0.0;
                }
                int m = this.scalePixel(w, pos);
                g.setColor(this.tickColor);
                g.drawLine(m, h - tickStart, m, h - 10 - tickStart);
                g.setColor(this.textColor);
                String str = this.useSI ? StringUtil.formatDoubleEE(pos) : this.nf.format(pos);
                g.drawString(str, m - fm.stringWidth(str) / 2, h - fm.getDescent());
                int i = 1;
                while (i < 5) {
                    double ppos = pos + this.tickStep * (double)i / 5.0;
                    m = this.scalePixel(w, ppos);
                    g.setColor(this.tickColor);
                    if (ppos < this.scaleMax) {
                        g.drawLine(m, h - tickStart - 10 + 4, m, h - 10 - tickStart);
                    }
                    ++i;
                }
                pos += this.tickStep;
            }
        }
        if (!Double.isNaN(this.lastValue)) {
            int m = this.scalePixel(w, this.lastValue);
            g.setColor(this.needleColor);
            g.drawLine(m, h - 10 - tickStart, m, 0);
            g.drawLine(m - 1, h - 10 - tickStart - 10, m - 1, 0);
            g.drawLine(m + 1, h - 10 - tickStart - 10, m + 1, 0);
        }
    }

    public void filterChannels(String channelFilter) {
        this.channelComboBox.removeAllItems();
        for (String s : InterfaceThreads.listChannels(true, channelFilter)) {
            this.channelComboBox.addItem(s);
        }
        this.channelComboBox.setEnabled(this.channelComboBox.getItemCount() > 1);
        this.channelComboBox.setSelectedItem(0);
    }

    public void selectDevice(String handle) {
        int i = 0;
        while (i < this.channelComboBox.getItemCount()) {
            String s = this.channelComboBox.getItemAt(i);
            if (handle == null || s.matches(String.valueOf(handle) + "\\..*")) {
                this.channelComboBox.setSelectedIndex(i);
                this.selectedChannelName = (String)this.channelComboBox.getSelectedItem();
                Support.math.resetCalc("AdjustScale");
                this.nsmooth = 0;
                return;
            }
            ++i;
        }
    }

    private void fillChannels(String handle) {
        Object sel = this.channelComboBox.getSelectedItem();
        this.channelComboBox.removeAllItems();
        for (String s : InterfaceThreads.listChannels(true)) {
            if (handle != null && !s.matches(String.valueOf(handle) + "\\..*")) continue;
            this.channelComboBox.addItem(s);
        }
        Support.math.resetCalc("AdjustScale");
        this.channelComboBox.setSelectedItem(sel);
    }

    @Override
    public void focusGained(FocusEvent arg0) {
    }

    @Override
    public void focusLost(FocusEvent arg0) {
        this.actionPerformed(new ActionEvent(this.referenceTextField, 0, "reference"));
        this.actionPerformed(new ActionEvent(this.toleranceTextField, 0, "tolerance"));
    }

    private void showPopup(MouseEvent arg0) {
        this.popupMenu.show((Component)arg0.getSource(), arg0.getX(), arg0.getY());
    }

    @Override
    public void mouseClicked(MouseEvent arg0) {
    }

    @Override
    public void mouseEntered(MouseEvent arg0) {
    }

    @Override
    public void mouseExited(MouseEvent arg0) {
    }

    @Override
    public void mousePressed(MouseEvent arg0) {
        if (arg0.isPopupTrigger()) {
            this.showPopup(arg0);
        }
    }

    @Override
    public void mouseReleased(MouseEvent arg0) {
        if (arg0.isPopupTrigger()) {
            this.showPopup(arg0);
        }
    }

    public static PopupAdjustScale getPopup(String handle) {
        Point p = Support.paneCommand.popupsButton.getLocationOnScreen();
        p.translate(-750, -400 + popupList.size() * -100);
        if (p.y < 0) {
            p.y = 0;
        }
        PopupAdjustScale pa = new PopupAdjustScale(handle);
        pa.setLocation(p);
        pa.setVisible(true);
        return pa;
    }

    public static PopupAdjustScale getPopup() {
        return PopupAdjustScale.getPopup(popupList.size() + 1);
    }

    public static PopupAdjustScale getPopup(int no) {
        if (no == 0) {
            --no;
        }
        if (no < popupList.size()) {
            return popupList.get(no);
        }
        return PopupAdjustScale.getPopup(null);
    }

    public static synchronized void closeAll() {
        while (popupList.size() > 0) {
            PopupAdjustScale pr = popupList.get(0);
            if (pr.isVisible()) {
                pr.setVisible(false);
            }
            popupList.remove(pr);
        }
    }

    public static List<String> generateScript() {
        ArrayList<String> list = new ArrayList<String>();
        for (PopupAdjustScale pas : popupList) {
            list.add("#ShowPopupSystem AdjustScale " + pas.generateLocationParams());
        }
        return list;
    }

    public static void alignGridAll(int pixels) {
        for (PopupAdjustScale pas : popupList) {
            pas.alignGrid(pixels);
        }
    }

    static enum AdjustMode {
        ref,
        min,
        max;

    }

    private class Sample {
        double value;
        long time;

        public Sample(Long time, double value) {
            this.time = time;
            this.value = value;
        }
    }

    static enum ToleranceType {
        absolute,
        relative,
        percent;

    }
}

