/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.main;

import dk.hkj.devices.ManageDeviceDefinitions;
import dk.hkj.main.FontAdjust;
import dk.hkj.main.PopupBase;
import dk.hkj.main.Support;
import java.awt.BorderLayout;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class PopupAbout
extends PopupBase
implements ActionListener {
    public PopupAbout() {
        this.setTitle("About");
        this.definePopupName("About", true);
        this.add(this.makePanel());
        this.setAlwaysOnTop(true);
        this.pack();
    }

    public JPanel makePanel() {
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BorderLayout());
        FontAdjust.FontLabel label = new FontAdjust.FontLabel();
        label.setBorder(BorderFactory.createEmptyBorder(5, 10, 20, 10));
        String fontTag = "<font style=\"font-size:" + FontAdjust.fontSizes.textFont.getSize() * 3 / 2 + "pt\">";
        JEditorPane ep = new JEditorPane();
        ep.setContentType("text/html");
        ep.setText("<html>" + fontTag + "<center><font size=+2>Test Controller V" + "2.38" + "</font><br><br><font size=+1>By HKJ from lygte-info.dk</font><br>" + "Questions and donations can be send to info@lygte-info.dk<br>" + "<a href=https://lygte-info.dk/project/TestControllerIntro%20UK.html>https://lygte-info.dk/project/TestControllerIntro%20UK.html</a><br>" + "<br><br>Uses jSerialComm for serial communication<br>" + "<a href=http://fazecast.github.io/jSerialComm>http://fazecast.github.io/jSerialComm</a>" + "<br><br>" + "Uses jFreeChart for charts<br>" + "<a href=http://www.jfree.org/jfreechart>http://www.jfree.org/jfreechart</a><br><br>" + "Uses hid4Jave to scan for HID devices (Could not get reading to work)<br>" + "<a href=https://github.com/gary-rowe/hid4java>https://github.com/gary-rowe/hid4java</a><br><br>" + "</center><br>" + this.findCredits() + "</font>");
        ep.setEditable(false);
        Rectangle r = ep.getVisibleRect();
        r.height = 20;
        mainPanel.setPreferredSize(new Dimension(500, 250));
        mainPanel.add(new JScrollPane(ep));
        ep.setSelectionStart(0);
        ep.setSelectionEnd(0);
        ep.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent arg0) {
                if (arg0.getEventType() != HyperlinkEvent.EventType.ACTIVATED) {
                    return;
                }
                Desktop dt = Desktop.getDesktop();
                if (dt != null) {
                    try {
                        dt.browse(arg0.getURL().toURI());
                    }
                    catch (Exception exception) {}
                }
            }
        });
        return mainPanel;
    }

    private String findCredits() {
        StringBuilder sb = new StringBuilder();
        HashMap<String, String> authors = new HashMap<String, String>();
        for (String deviceName : Support.manageDeviceDefinitions.getDeviceList()) {
            ManageDeviceDefinitions.DeviceDefinition dd = Support.manageDeviceDefinitions.findDeviceDefintionFromName(deviceName);
            if (dd == null) continue;
            dd.parse();
            String author = dd.getItem("#author");
            if (author == null || author.trim().length() <= 0) continue;
            String work = (String)authors.get(author = author.trim());
            work = work == null ? deviceName : String.valueOf(work) + ", " + deviceName;
            authors.put(author, work);
        }
        ArrayList<Object> aut = new ArrayList<Object>();
        aut.addAll(authors.keySet());
        if (aut.size() == 0) {
            return "";
        }
        aut.sort(new Comparator<String>(){

            @Override
            public int compare(String arg0, String arg1) {
                return arg0.toLowerCase().compareTo(arg1.toLowerCase());
            }
        });
        sb.append("Thanks for making more device definitions to:<table>");
        for (String string : aut) {
            sb.append("<tr><td>");
            sb.append("<b>");
            sb.append(string);
            sb.append("</b>: ");
            sb.append("</td><td>");
            sb.append((String)authors.get(string));
            sb.append("</td>");
        }
        sb.append("</table>");
        return sb.toString();
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
    }
}

