/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.main;

import dk.hkj.database.DataBase;
import dk.hkj.main.FontAdjust;
import dk.hkj.main.InterfaceThreads;
import dk.hkj.main.Main;
import dk.hkj.main.PopupGridPanel;
import dk.hkj.main.Support;
import dk.hkj.main.ValueFormat;
import dk.hkj.util.StringUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.Timer;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;

public class PaneTable
implements Main.PaneInterface,
ActionListener {
    private JPanel tablePanel = null;
    private JTable table = null;
    private JButton loadButton = null;
    private JButton saveButton = null;
    private JButton exportButton = null;
    private JButton importButton = null;
    private JPanel checkboxPanel = null;
    private JScrollPane scrollPane = null;
    private JTextField searchTextField = null;
    private List<JCheckBox> checkboxList = new ArrayList<JCheckBox>();
    private List<String> checkboxNameList = new ArrayList<String>();
    private Timer timer = null;
    private String lastGotoValue = "";
    ActionListener checkBoxListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent arg0) {
            PaneTable.this.updateColumnSelection();
        }
    };

    protected PaneTable() {
        this.timer = new Timer(500, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PaneTable.this.timerUpdate();
            }
        });
    }

    @Override
    public int getHotKey() {
        return 84;
    }

    @Override
    public String getTitle() {
        return "Table";
    }

    @Override
    public JPanel getPanel() {
        this.tablePanel = new JPanel();
        this.tablePanel.setLayout(new BorderLayout());
        this.table = new FontAdjust.FontTable(){

            @Override
            public Component prepareRenderer(TableCellRenderer renderer, int row, int col) {
                JLabel comp = (JLabel)super.prepareRenderer(renderer, row, col);
                comp.setHorizontalAlignment(0);
                if (!comp.getBackground().equals(Support.colorScheme.selectedCellbackground)) {
                    comp.setBackground(row % 4 == 0 ? Support.colorScheme.tableGridAlternateBackground : Support.colorScheme.textBackground);
                }
                return comp;
            }

            @Override
            protected JTableHeader createDefaultTableHeader() {
                return new JTableHeader(this.columnModel){

                    @Override
                    public String getToolTipText(MouseEvent e) {
                        Point p = e.getPoint();
                        int index = this.columnModel.getColumnIndexAtX(p.x);
                        int realIndex = this.columnModel.getColumn(index).getModelIndex();
                        return String.valueOf(Support.dataBase.header().getColumnName(realIndex)) + " (" + Support.dataBase.format().get((int)realIndex).unit + ")";
                    }
                };
            }
        };
        Support.colorScheme.selectedCellbackground = this.table.getSelectionBackground();
        Support.colorScheme.selectedCellForeground = this.table.getSelectionForeground();
        int[] nArray = new int[6];
        nArray[1] = 80;
        nArray[3] = 130;
        nArray[4] = 80;
        nArray[5] = 80;
        this.table.setColumnModel(new Support.WidthTableColumnModel(nArray));
        this.table.setModel(Support.dataBase.getTableDataModel());
        this.table.getTableHeader().setReorderingAllowed(false);
        Support.dataBase.getTableDataModel().setTable(this.table);
        this.scrollPane = new JScrollPane(this.table);
        this.table.setAutoResizeMode(0);
        this.tablePanel.add(this.scrollPane);
        this.table.setFillsViewportHeight(true);
        this.table.addNotify();
        this.table.addMouseListener(new MouseAdapter(){

            public void popupShow(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    JTable source = (JTable)e.getSource();
                    int row = source.rowAtPoint(e.getPoint());
                    final int column = source.columnAtPoint(e.getPoint());
                    if (!source.isRowSelected(row)) {
                        source.changeSelection(row, column, false, false);
                    }
                    JPopupMenu popupMenu = new JPopupMenu();
                    JMenuItem mi = new JMenuItem("Goto min.");
                    mi.setActionCommand("min:" + column);
                    mi.addActionListener(PaneTable.this);
                    popupMenu.add(mi);
                    mi = new JMenuItem("Goto max.");
                    mi.addActionListener(PaneTable.this);
                    mi.setActionCommand("max:" + column);
                    popupMenu.add(mi);
                    mi = new JMenuItem("Goto value");
                    mi.addActionListener(PaneTable.this);
                    mi.setActionCommand("value:" + column);
                    popupMenu.add(mi);
                    ValueFormat.formatMenu(popupMenu, "Format", "", Support.dataBase.format().get((int)column).format, false, false, new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            PaneTable.this.setDecimals(column, e.getActionCommand());
                        }
                    });
                    popupMenu.show(e.getComponent(), e.getX(), e.getY());
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                this.popupShow(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.popupShow(e);
            }
        });
        FontAdjust.FontPanel sidePanel = new FontAdjust.FontPanel();
        sidePanel.setLayout(new GridBagLayout());
        sidePanel.setScaleWidth(120);
        this.tablePanel.add((Component)sidePanel, "East");
        this.checkboxPanel = new JPanel();
        this.checkboxPanel.setAlignmentX(0.5f);
        this.checkboxPanel.setLayout(new BoxLayout(this.checkboxPanel, 3));
        GridBagConstraints c = new GridBagConstraints();
        c.gridy = 0;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.anchor = 11;
        sidePanel.add((Component)new JScrollPane(this.checkboxPanel), c);
        this.searchTextField = new FontAdjust.FontTextField(6);
        this.searchTextField.setAlignmentX(0.5f);
        this.searchTextField.setToolTipText("<html>Formats supported:<br>Empty: All data<br>seconds from start<br>h:m:s hour minutes seconds<br>postfix with h/m for hours/minutes<br>#sampleNumber<br>Prefix with - means from end of data<br>Prefix with w for width/lenght of data, only in last field");
        this.searchTextField.setActionCommand("Search");
        this.searchTextField.addActionListener(this);
        c = new GridBagConstraints();
        c.gridy = 1;
        c.fill = 2;
        c.weightx = 1.0;
        sidePanel.add((Component)this.searchTextField, c);
        sidePanel.add(Box.createVerticalStrut(10));
        this.saveButton = new FontAdjust.FontButton("Save");
        this.saveButton.setAlignmentX(0.5f);
        this.saveButton.addActionListener(this);
        this.saveButton.setActionCommand("Save");
        this.saveButton.setToolTipText("Save in CSV format that can be loaded into TestController again");
        c = new GridBagConstraints();
        c.gridy = 2;
        c.fill = 2;
        c.weightx = 1.0;
        sidePanel.add((Component)this.saveButton, c);
        this.exportButton = new FontAdjust.FontButton("Export");
        this.exportButton.setAlignmentX(0.5f);
        this.exportButton.addActionListener(this);
        this.exportButton.setActionCommand("Export");
        this.exportButton.setToolTipText("It is possible to select format and data to save, use CSV format.");
        c = new GridBagConstraints();
        c.gridy = 3;
        c.fill = 2;
        c.weightx = 1.0;
        sidePanel.add((Component)this.exportButton, c);
        this.importButton = new FontAdjust.FontButton("Import");
        this.importButton.setAlignmentX(0.5f);
        this.importButton.addActionListener(this);
        this.importButton.setActionCommand("Import");
        this.importButton.setToolTipText("Import some columns from a CSV file and align data");
        c = new GridBagConstraints();
        c.gridy = 4;
        c.fill = 2;
        c.weightx = 1.0;
        sidePanel.add((Component)this.importButton, c);
        this.loadButton = new FontAdjust.FontButton("Load");
        this.loadButton.setAlignmentX(0.5f);
        this.loadButton.addActionListener(this);
        this.loadButton.setActionCommand("Load");
        this.loadButton.setToolTipText("Load a CSV file into test controller (Note: All columns must be numeric)");
        c = new GridBagConstraints();
        c.gridy = 5;
        c.fill = 2;
        c.anchor = 15;
        c.weightx = 1.0;
        sidePanel.add((Component)this.loadButton, c);
        return this.tablePanel;
    }

    public void setDecimals(int column, String format) {
        ValueFormat.ValueFormatter vf = ValueFormat.getFormatter(format);
        if (column < 0 || Support.dataBase.header().isIndexColumn(column) || Support.dataBase.header().isTimeColumn(column) || vf == null) {
            return;
        }
        if (Support.dataBase.format().get((int)column).format instanceof ValueFormat.ValueFormatterDateTime) {
            return;
        }
        if (Support.dataBase.format().get((int)column).format instanceof ValueFormat.ValueFormatterDigital) {
            return;
        }
        Support.dataBase.format().get((int)column).format = vf;
        Support.dataBase.getTableDataModel().columnChanged(column);
    }

    public void setDecimals(String column, ValueFormat.ValueFormatter fmt) {
        this.setDecimals(Support.dataBase.header().getIndex(column), fmt.getName());
    }

    private void gotoMin(int column) {
        double[] data = Support.dataBase.getColumn(column);
        double v = data[0];
        int ii = 0;
        int col = 0;
        while (col < data.length) {
            if (data[col] < v) {
                v = data[col];
                ii = col;
            }
            ++col;
        }
        this.moveView(ii);
    }

    private void gotoMax(int column) {
        double[] data = Support.dataBase.getColumn(column);
        double v = data[0];
        int ii = 0;
        int col = 0;
        while (col < data.length) {
            if (data[col] > v) {
                v = data[col];
                ii = col;
            }
            ++col;
        }
        this.moveView(ii);
    }

    private void gotoValue(int column) {
        String vv = JOptionPane.showInputDialog(Main.main.frame, "Value?", this.lastGotoValue);
        if (vv == null || vv.length() == 0) {
            return;
        }
        double target = StringUtil.parseDoubleEE(vv);
        if (Double.isNaN(target)) {
            return;
        }
        this.lastGotoValue = vv;
        double[] data = Support.dataBase.getColumn(column);
        double v = Math.abs(data[0] - target);
        int ii = 0;
        int col = 0;
        while (col < data.length) {
            if (Math.abs(data[col] - target) < v) {
                v = Math.abs(data[col] - target);
                ii = col;
            }
            ++col;
        }
        this.moveView(ii);
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        String cmd = arg0.getActionCommand();
        if (cmd.equals("Load")) {
            this.loadData();
        } else if (cmd.equals("Save")) {
            this.saveData();
        } else if (cmd.equals("Export")) {
            Support.showExport();
        } else if (cmd.startsWith("min:")) {
            this.gotoMin(Integer.parseInt(cmd.substring(4)));
        } else if (cmd.startsWith("max:")) {
            this.gotoMax(Integer.parseInt(cmd.substring(4)));
        } else if (cmd.startsWith("value:")) {
            this.gotoValue(Integer.parseInt(cmd.substring(6)));
        } else if (cmd.equals("Import")) {
            Support.showImport();
        }
        if (cmd.equals("Search")) {
            this.searchLocation();
        }
    }

    public void updateCheckboxes() {
        this.checkboxPanel.removeAll();
        this.checkboxNameList.clear();
        this.checkboxList.clear();
        for (String section : Support.dataBase.header().getOptionalColumns(true)) {
            FontAdjust.FontCheckBox box = new FontAdjust.FontCheckBox(section);
            box.setSelected(true);
            this.checkboxList.add(box);
            this.checkboxPanel.add(box);
            this.checkboxNameList.add(section);
            box.addActionListener(this.checkBoxListener);
            box.setActionCommand(section);
        }
        this.checkboxPanel.revalidate();
        this.checkboxPanel.repaint();
    }

    private void moveView(int index) {
        Rectangle cellRect = this.table.getCellRect(index, 0, true);
        int h = this.scrollPane.getSize().height;
        cellRect.height = h - 40;
        cellRect.y -= h / 8;
        if (cellRect.y < 0) {
            cellRect.y = 0;
        }
        this.table.scrollRectToVisible(cellRect);
        this.table.setRowSelectionInterval(index, index);
    }

    private void searchLocation() {
        int domainColumn = Support.dataBase.header().getDomainColumn();
        DataBase.DataBaseRange range = Support.dataBase.getRangePosition(domainColumn, this.searchTextField.getText());
        this.moveView(range.getFirstIndex());
    }

    @Override
    public void changeDevicesOrTable(Support.UpdateType type) {
        if (type.equals((Object)Support.UpdateType.StartInit)) {
            return;
        }
        this.updateCheckboxes();
        this.updateColumnSelection();
    }

    private void updateColumnSelection() {
        ArrayList<String> list = new ArrayList<String>();
        String s = Support.dataBase.header().getIndexColumnName();
        if (s.length() > 0) {
            list.add(s);
        }
        if ((s = Support.dataBase.header().getTimeColumnName()).length() > 0) {
            list.add(s);
        }
        for (JCheckBox cb : this.checkboxList) {
            if (!cb.isSelected()) continue;
            list.add(cb.getActionCommand());
        }
        Support.dataBase.getTableDataModel().includeColumns(list);
    }

    private void saveData() {
        FontAdjust.FontFileChooser fileChooser = new FontAdjust.FontFileChooser();
        fileChooser.setDialogTitle("Save table data to file");
        try {
            fileChooser.setCurrentDirectory(new File(Support.getDataPath()));
        }
        catch (Exception exception) {
            System.out.println("Failed to set director: " + Support.getDataPath());
        }
        DataBase.FileFormat ff = Support.dataBase.getFileFormat();
        FontAdjust.FontRadioButton formatTabRadioButton = null;
        FontAdjust.FontRadioButton formatCTabRadioButton = null;
        AbstractButton formatUsRadioButton = null;
        AbstractButton formatEuRadioButton = null;
        if (!InterfaceThreads.isLoggingToDisk()) {
            JPanel savePanel = new JPanel();
            BoxLayout bl = new BoxLayout(savePanel, 3);
            savePanel.setLayout(bl);
            ButtonGroup bg = new ButtonGroup();
            formatTabRadioButton = new FontAdjust.FontRadioButton("TAB format");
            bg.add(formatTabRadioButton);
            savePanel.add(formatTabRadioButton);
            formatCTabRadioButton = new FontAdjust.FontRadioButton("CTAB format");
            formatCTabRadioButton.setToolTipText("Use tab delimeter with comma as decimal point");
            bg.add(formatCTabRadioButton);
            savePanel.add(formatCTabRadioButton);
            formatUsRadioButton = new FontAdjust.FontRadioButton(". , format");
            bg.add(formatUsRadioButton);
            savePanel.add(formatUsRadioButton);
            formatEuRadioButton = new FontAdjust.FontRadioButton(", ; format");
            bg.add(formatEuRadioButton);
            savePanel.add(formatEuRadioButton);
            if (ff == DataBase.FileFormat.tab) {
                formatTabRadioButton.setSelected(true);
            } else if (ff == DataBase.FileFormat.ctab) {
                formatCTabRadioButton.setSelected(true);
            } else if (ff == DataBase.FileFormat.us) {
                formatUsRadioButton.setSelected(true);
            } else {
                formatEuRadioButton.setSelected(true);
            }
            fileChooser.setAccessory(savePanel);
        }
        fileChooser.setFileFilter(new FileNameExtensionFilter("CSV", "csv"));
        fileChooser.setAcceptAllFileFilterUsed(true);
        if (fileChooser.showSaveDialog(this.table) == 0) {
            File file = Support.fileWithOptinalDefaults(fileChooser.getSelectedFile().getAbsolutePath(), null, ".csv");
            if (file.exists() && JOptionPane.showConfirmDialog(null, "File exists, overwrite?", "File exists", 1) != 0) {
                return;
            }
            try {
                if (formatTabRadioButton != null) {
                    if (formatTabRadioButton.isSelected()) {
                        Support.dataBase.setFileFormat(DataBase.FileFormat.tab);
                    } else if (formatCTabRadioButton.isSelected()) {
                        Support.dataBase.setFileFormat(DataBase.FileFormat.ctab);
                    } else if (formatUsRadioButton.isSelected()) {
                        Support.dataBase.setFileFormat(DataBase.FileFormat.us);
                    } else if (formatEuRadioButton.isSelected()) {
                        Support.dataBase.setFileFormat(DataBase.FileFormat.euro);
                    }
                }
                Support.dataBase.save(file);
                Support.setDataPath(fileChooser.getCurrentDirectory().getPath());
            }
            catch (IOException e) {
                e.printStackTrace(System.out);
            }
        }
    }

    private void timerUpdate() {
        this.loadButton.setEnabled(!InterfaceThreads.isLogging());
        this.importButton.setEnabled(!InterfaceThreads.isLogging());
        this.saveButton.setEnabled(Support.dataBase.rows() > 0 && !Support.dataBase.isOptimizing());
        this.exportButton.setEnabled(Support.dataBase.rows() > 0 && !Support.dataBase.isOptimizing());
        this.saveButton.setToolTipText(InterfaceThreads.isLoggingToDisk() ? "Already logging to disk" : "");
    }

    private void loadData() {
        FontAdjust.FontFileChooser fileChooser = new FontAdjust.FontFileChooser();
        fileChooser.setDialogTitle("Load table data from file");
        try {
            fileChooser.setCurrentDirectory(new File(Support.getDataPath()));
        }
        catch (Exception exception) {
            System.out.println("Failed to set director: " + Support.getDataPath());
        }
        fileChooser.setFileFilter(new FileNameExtensionFilter("CSV", "csv"));
        fileChooser.addChoosableFileFilter(new FileNameExtensionFilter("TXT", "txt"));
        fileChooser.addChoosableFileFilter(new FileNameExtensionFilter("DAT", "dat"));
        fileChooser.setAcceptAllFileFilterUsed(true);
        if (fileChooser.showOpenDialog(this.table) == 0) {
            File file = Support.fileWithOptinalDefaults(fileChooser.getSelectedFile().getAbsolutePath(), null, ".csv");
            try {
                Support.dataBase.load(file);
                Support.chartTitle = null;
                Support.math.disableAll();
                Main.changeDevicesOrTable(Support.UpdateType.ColumnsTable);
                Support.clearExporter();
                Support.setDataPath(fileChooser.getCurrentDirectory().getPath());
                Support.addUsedFunction("load");
                PopupGridPanel.systemStateChanged();
            }
            catch (IOException e) {
                e.printStackTrace(System.out);
            }
        }
        Main.changeDevicesOrTable(Support.UpdateType.ColumnsTable);
    }

    @Override
    public void select() {
        this.timer.start();
        this.timerUpdate();
        this.updateCheckboxes();
    }

    @Override
    public void deselect() {
        this.timer.stop();
    }
}

