/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.main;

import dk.hkj.main.ChartScales;
import dk.hkj.main.FontAdjust;
import dk.hkj.main.Main;
import dk.hkj.main.Support;
import dk.hkj.util.MySwingUtil;
import dk.hkj.util.StringUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

public class PaneScales
implements Main.PaneInterface {
    private JTable table = null;
    private JPanel mainPanel = null;
    private JPanel bottomPanel = null;
    private JScrollPane scrollPane = null;
    private final Color markUsedChartColor = new Color(120, 250, 120);
    private final Color markUsedHistogramColor = new Color(60, 220, 140);
    ActionListener globalChangeActionListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent arg0) {
            ArrayList<ChartScales.ChartScale> list = new ArrayList<ChartScales.ChartScale>();
            int i = 0;
            while (i < PaneScales.this.table.getRowCount()) {
                if (PaneScales.this.table.isRowSelected(i)) {
                    list.add(Support.chartScales.getScale(i));
                }
                ++i;
            }
            String cmd = arg0.getActionCommand();
            try {
                for (ChartScales.ChartScale cs : list) {
                    if (cmd.equals("Decimals")) {
                        int v = ((MyTextField)arg0.getSource()).parseInt(0, 10);
                        if (v < 0 || v >= 20) continue;
                        cs.setDecimals(v);
                        continue;
                    }
                    if (cmd.equals("Auto")) {
                        cs.setAuto(((JCheckBox)arg0.getSource()).isSelected());
                        continue;
                    }
                    if (cmd.equals("Auto Z")) {
                        cs.setAutoIncludeZero(((JCheckBox)arg0.getSource()).isSelected());
                        continue;
                    }
                    if (cmd.equals("MinAuto")) {
                        double v = ((MyTextField)arg0.getSource()).parseDouble();
                        if (Double.isNaN(v)) continue;
                        cs.setRange(v);
                        continue;
                    }
                    if (cmd.equals("BottomStep")) {
                        double v = ((MyTextField)arg0.getSource()).parseDouble();
                        if (Double.isNaN(v)) continue;
                        cs.setBottomStep(v);
                        continue;
                    }
                    if (cmd.equals("Min")) {
                        double v = ((MyTextField)arg0.getSource()).parseDouble();
                        if (Double.isNaN(v)) continue;
                        cs.setMin(v);
                        continue;
                    }
                    if (cmd.equals("Max")) {
                        double v = ((MyTextField)arg0.getSource()).parseDouble();
                        if (Double.isNaN(v)) continue;
                        cs.setMax(v);
                        continue;
                    }
                    if (!cmd.equals("Remove")) continue;
                    Support.chartScales.remove(cs);
                }
            }
            catch (Exception exception) {}
            if (cmd.equals("Remove")) {
                PaneScales.this.updateScales();
                Support.chartScales.scalesTableModel.changeNotification(true);
            } else {
                Support.chartScales.scalesTableModel.changeNotification(false);
            }
        }
    };

    @Override
    public String getTitle() {
        return "Scales for chart";
    }

    @Override
    public JPanel getPanel() {
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new BorderLayout());
        this.bottomPanel = new JPanel();
        this.bottomPanel.setLayout(new GridBagLayout());
        this.mainPanel.add((Component)this.bottomPanel, "South");
        this.table = new FontAdjust.FontTable(){

            @Override
            public Component prepareRenderer(TableCellRenderer renderer, int row, int col) {
                JComponent comp = (JComponent)super.prepareRenderer(renderer, row, col);
                if (!comp.getBackground().equals(Support.colorScheme.selectedCellbackground)) {
                    Color c = Support.colorScheme.textBackground;
                    if ((col == 8 || col == 9) && Support.chartScales.getCenterSpan() && c.equals(Color.WHITE)) {
                        c = new Color(235, 255, 255);
                    }
                    comp.setBackground(row % 4 == 0 ? Support.colorScheme.tableGridAlternateBackground : c);
                }
                if (col == 0 && comp instanceof JLabel) {
                    comp.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 0));
                    ((JLabel)comp).setHorizontalAlignment(2);
                    String rowName = (String)Support.chartScales.getTableDataModel().getValueAt(row, 0);
                    if (Support.paneChart.usedScale(rowName)) {
                        comp.setBackground(PaneScales.this.markUsedChartColor);
                    } else if (Support.paneHistogram.checkedColumns.contains(rowName)) {
                        comp.setBackground(PaneScales.this.markUsedHistogramColor);
                    }
                } else if (comp instanceof JLabel) {
                    ((JLabel)comp).setHorizontalAlignment(0);
                }
                return comp;
            }
        };
        this.table.setAutoResizeMode(0);
        this.table.getTableHeader().setReorderingAllowed(false);
        this.table.setColumnModel(new Support.WidthTableColumnModel(new int[]{200, 60, 60, 60, 60, 60, 100, 100, 100, 100}));
        this.table.setModel(Support.chartScales.getTableDataModel());
        Support.colorScheme.selectedCellbackground = this.table.getSelectionBackground();
        Support.colorScheme.selectedCellForeground = this.table.getSelectionForeground();
        this.table.setDefaultEditor(String.class, new Support.AutoSelectCellEditor());
        this.table.setDefaultEditor(Integer.class, new Support.AutoSelectCellEditor());
        this.table.setDefaultRenderer(Boolean.class, new MyBooleanTableCellRenderer());
        Support.chartScales.setTable(this.table);
        this.scrollPane = new JScrollPane(this.table);
        this.mainPanel.add((Component)this.scrollPane, "Center");
        this.table.setFillsViewportHeight(true);
        this.table.addNotify();
        this.table.getTableHeader().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                if (event.getButton() == 1 && event.getClickCount() == 1) {
                    Point point = event.getPoint();
                    int column = PaneScales.this.table.columnAtPoint(point);
                    if (column == 8 || column == 9) {
                        Support.chartScales.setCenterSpan(!Support.chartScales.getCenterSpan());
                    }
                }
            }
        });
        Support.OpenFocusTraversalPolicy ft = new Support.OpenFocusTraversalPolicy(this.bottomPanel);
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.weightx = 1.0;
        c.anchor = 13;
        c.insets = new Insets(5, 5, 5, 5);
        this.bottomPanel.add((Component)new FontAdjust.FontLabel("Decimals:"), c);
        MyTextField decimalsTextField = new MyTextField(3);
        decimalsTextField.setActionCommand("Decimals");
        decimalsTextField.addActionListener(this.globalChangeActionListener);
        decimalsTextField.setMinimumSize(new Dimension(30, 20));
        ft.add(decimalsTextField);
        c = new GridBagConstraints();
        c.gridx = 1;
        c.weightx = 1.0;
        c.anchor = 17;
        c.insets = new Insets(5, 5, 5, 5);
        this.bottomPanel.add((Component)decimalsTextField, c);
        FontAdjust.FontCheckBox autoCheckBox = new FontAdjust.FontCheckBox("Auto");
        autoCheckBox.setActionCommand("Auto");
        autoCheckBox.addActionListener(this.globalChangeActionListener);
        ft.add(autoCheckBox);
        c = new GridBagConstraints();
        c.gridx = 2;
        c.weightx = 1.0;
        c.anchor = 10;
        c.insets = new Insets(5, 5, 5, 5);
        this.bottomPanel.add((Component)autoCheckBox, c);
        FontAdjust.FontCheckBox autoZCheckBox = new FontAdjust.FontCheckBox("Auto include zero");
        autoZCheckBox.setActionCommand("Auto Z");
        autoZCheckBox.addActionListener(this.globalChangeActionListener);
        ft.add(autoZCheckBox);
        c = new GridBagConstraints();
        c.gridx = 3;
        c.weightx = 1.0;
        c.anchor = 10;
        c.insets = new Insets(5, 5, 5, 5);
        this.bottomPanel.add((Component)autoZCheckBox, c);
        c = new GridBagConstraints();
        c.gridx = 4;
        c.weightx = 1.0;
        c.anchor = 13;
        c.insets = new Insets(5, 5, 5, 5);
        this.bottomPanel.add((Component)new FontAdjust.FontLabel("Auto min. range:"), c);
        MyTextField minAutoTextField = new MyTextField(5);
        minAutoTextField.setActionCommand("MinAuto");
        minAutoTextField.addActionListener(this.globalChangeActionListener);
        minAutoTextField.setMinimumSize(new Dimension(30, 20));
        ft.add(minAutoTextField);
        c = new GridBagConstraints();
        c.gridx = 5;
        c.weightx = 1.0;
        c.anchor = 17;
        c.insets = new Insets(5, 5, 5, 5);
        this.bottomPanel.add((Component)minAutoTextField, c);
        c = new GridBagConstraints();
        c.gridx = 6;
        c.weightx = 1.0;
        c.anchor = 13;
        c.insets = new Insets(5, 5, 5, 5);
        this.bottomPanel.add((Component)new FontAdjust.FontLabel("Auto bottom step:"), c);
        MyTextField bottomStepTextField = new MyTextField(5);
        bottomStepTextField.setActionCommand("BottomStep");
        bottomStepTextField.addActionListener(this.globalChangeActionListener);
        bottomStepTextField.setMinimumSize(new Dimension(30, 20));
        ft.add(bottomStepTextField);
        c = new GridBagConstraints();
        c.gridx = 7;
        c.weightx = 1.0;
        c.anchor = 17;
        c.insets = new Insets(5, 5, 5, 5);
        this.bottomPanel.add(bottomStepTextField);
        c = new GridBagConstraints();
        c.gridx = 8;
        c.weightx = 1.0;
        c.anchor = 13;
        c.insets = new Insets(5, 5, 5, 5);
        this.bottomPanel.add((Component)new FontAdjust.FontLabel("Min.:"), c);
        MyTextField minTextField = new MyTextField(5);
        minTextField.setActionCommand("Min");
        minTextField.addActionListener(this.globalChangeActionListener);
        minTextField.setMinimumSize(new Dimension(30, 20));
        ft.add(minTextField);
        c = new GridBagConstraints();
        c.gridx = 9;
        c.weightx = 1.0;
        c.anchor = 17;
        c.insets = new Insets(5, 5, 5, 5);
        this.bottomPanel.add(minTextField);
        c = new GridBagConstraints();
        c.gridx = 10;
        c.weightx = 1.0;
        c.anchor = 13;
        c.insets = new Insets(5, 5, 5, 5);
        this.bottomPanel.add((Component)new FontAdjust.FontLabel("Max.:"), c);
        MyTextField maxTextField = new MyTextField(5);
        maxTextField.setActionCommand("Max");
        maxTextField.addActionListener(this.globalChangeActionListener);
        maxTextField.setMinimumSize(new Dimension(30, 20));
        ft.add(maxTextField);
        c = new GridBagConstraints();
        c.gridx = 11;
        c.weightx = 1.0;
        c.anchor = 17;
        c.insets = new Insets(5, 5, 5, 5);
        this.bottomPanel.add((Component)maxTextField, c);
        FontAdjust.FontButton removeButtom = new FontAdjust.FontButton("Remove");
        removeButtom.setActionCommand("Remove");
        removeButtom.addActionListener(this.globalChangeActionListener);
        ft.add(removeButtom);
        c = new GridBagConstraints();
        c.gridx = 12;
        c.weightx = 1.0;
        c.anchor = 13;
        c.insets = new Insets(5, 5, 5, 5);
        this.bottomPanel.add((Component)removeButtom, c);
        this.bottomPanel.setFocusTraversalPolicy(ft);
        this.bottomPanel.setFocusTraversalPolicyProvider(true);
        MySwingUtil.setToolTipTextAll(this.bottomPanel, "This panel only affect selected lines, use ENTER to change numeric values");
        return this.mainPanel;
    }

    @Override
    public int getHotKey() {
        return 83;
    }

    @Override
    public void changeDevicesOrTable(Support.UpdateType type) {
        if (type.equals((Object)Support.UpdateType.StartInit)) {
            return;
        }
        this.updateScales();
    }

    private void updateScales() {
        int[] nArray = Support.dataBase.header().getDataColumns();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            if (Support.dataBase.format().get((int)i).format.digitalValues() == 0) {
                String name = Support.dataBase.header().getColumnName(i);
                Support.chartScales.addScale(name, 2, true, true, 1.0, 1.0, 0.0, 100.0);
            }
            ++n2;
        }
        Support.chartScales.sort();
        Support.chartScales.saveDefault();
    }

    @Override
    public void select() {
        this.updateScales();
    }

    @Override
    public void deselect() {
        Support.chartScales.saveDefault();
    }

    class MyBooleanTableCellRenderer
    implements TableCellRenderer {
        MyBooleanTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JComponent comp;
            if (value instanceof Boolean) {
                comp = new FontAdjust.FontCheckBox();
                ((JCheckBox)comp).setHorizontalAlignment(0);
                ((JCheckBox)comp).setSelected((Boolean)value);
            } else {
                comp = new JPanel();
                ((JPanel)comp).setLayout(new BorderLayout());
                FontAdjust.FontLabel l = new FontAdjust.FontLabel("-");
                l.setHorizontalAlignment(0);
                ((JPanel)comp).add(l);
            }
            if (isSelected) {
                ((Component)comp).setBackground(table.getSelectionBackground());
                ((Component)comp).setForeground(table.getSelectionForeground());
            }
            return comp;
        }
    }

    private class MyTextField
    extends FontAdjust.FontTextField {
        MyTextField(int width) {
            super(width);
            this.setMinimumSize(new Dimension(30, 20));
            this.addFocusListener(new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent arg0) {
                    MyTextField.this.selectAll();
                }
            });
        }

        public Double parseDouble() {
            this.selectAll();
            Double v = Double.NaN;
            try {
                v = StringUtil.parseFloat(this.getText());
                this.setBackground(Support.colorScheme.textBackground);
            }
            catch (Exception exception) {
                this.setBackground(Support.colorScheme.errorBackground);
            }
            return v;
        }

        public int parseInt(int min, int max) {
            this.selectAll();
            try {
                int v = StringUtil.parseInt(this.getText());
                if (v >= min && v <= max) {
                    this.setBackground(Support.colorScheme.textBackground);
                    return v;
                }
            }
            catch (Exception exception) {}
            this.setBackground(Support.colorScheme.errorBackground);
            return Integer.MIN_VALUE;
        }
    }
}

