/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.main;

import dk.hkj.main.DeviceInterface;
import dk.hkj.main.FontAdjust;
import dk.hkj.main.InterfaceThreads;
import dk.hkj.main.Main;
import dk.hkj.main.Support;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

public class PaneRemap
implements Main.PaneInterface,
ActionListener {
    private JPanel mainPanel;
    private JTable table;
    private JScrollPane scrollPane;
    private JComboBox<DeviceItem> devicesComboBox;

    @Override
    public String getTitle() {
        return "Remap handles";
    }

    @Override
    public int getHotKey() {
        return 80;
    }

    @Override
    public JPanel getPanel() {
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new GridBagLayout());
        this.table = new FontAdjust.FontTable(){

            @Override
            public Component prepareRenderer(TableCellRenderer renderer, int row, int col) {
                Component comp = super.prepareRenderer(renderer, row, col);
                if (comp instanceof JLabel) {
                    ((JLabel)comp).setHorizontalAlignment(0);
                }
                if (!comp.getBackground().equals(Support.colorScheme.selectedCellbackground)) {
                    comp.setBackground(row % 4 == 0 ? Support.colorScheme.tableGridAlternateBackground : Support.colorScheme.textBackground);
                }
                return comp;
            }
        };
        this.scrollPane = new JScrollPane(this.table);
        Support.colorScheme.selectedCellbackground = this.table.getSelectionBackground();
        Support.colorScheme.selectedCellForeground = this.table.getSelectionForeground();
        this.table.setAutoResizeMode(0);
        int[] nArray = new int[6];
        nArray[0] = 200;
        nArray[1] = 180;
        nArray[2] = 80;
        nArray[3] = 60;
        nArray[4] = 150;
        this.table.setColumnModel(new Support.WidthTableColumnModel(nArray));
        this.table.setModel(InterfaceThreads.remapper);
        this.table.setDefaultEditor(String.class, new Support.AutoSelectCellEditor());
        this.table.getTableHeader().setReorderingAllowed(false);
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 8;
        c.gridheight = 1;
        c.insets = new Insets(2, 2, 2, 2);
        c.fill = 1;
        c.weighty = 1.0;
        c.weightx = 1.0;
        this.mainPanel.add((Component)this.scrollPane, c);
        this.devicesComboBox = new FontAdjust.FontComboBox<DeviceItem>();
        this.devicesComboBox.setToolTipText("Select device to add");
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 3;
        c.weightx = 1.0;
        c.fill = 1;
        c.insets = new Insets(2, 2, 2, 2);
        this.mainPanel.add(this.devicesComboBox, c);
        FontAdjust.FontButton addButton = new FontAdjust.FontButton("Add");
        addButton.setToolTipText("Add selected device to list");
        addButton.setActionCommand("Add");
        addButton.addActionListener(this);
        c = new GridBagConstraints();
        c.gridx = 3;
        c.gridy = 1;
        c.gridwidth = 1;
        c.weightx = 0.1;
        c.insets = new Insets(2, 2, 2, 2);
        this.mainPanel.add((Component)addButton, c);
        FontAdjust.FontButton addAllButton = new FontAdjust.FontButton("Add all");
        addAllButton.setToolTipText("Add all devices to list");
        addAllButton.setActionCommand("AddAll");
        addAllButton.addActionListener(this);
        c = new GridBagConstraints();
        c.gridx = 4;
        c.gridy = 1;
        c.gridwidth = 1;
        c.weightx = 0.1;
        c.insets = new Insets(2, 2, 2, 2);
        this.mainPanel.add((Component)addAllButton, c);
        FontAdjust.FontButton removeButton = new FontAdjust.FontButton("Remove");
        removeButton.setToolTipText("Remove selected devices from list");
        c = new GridBagConstraints();
        removeButton.setActionCommand("Remove");
        removeButton.addActionListener(this);
        c.gridx = 5;
        c.gridy = 1;
        c.gridwidth = 1;
        c.weightx = 0.1;
        c.insets = new Insets(2, 2, 2, 2);
        this.mainPanel.add((Component)removeButton, c);
        FontAdjust.FontButton sortNameButton = new FontAdjust.FontButton("Sort name");
        sortNameButton.setToolTipText("Sort list by device name and serial number");
        sortNameButton.setActionCommand("SortName");
        sortNameButton.addActionListener(this);
        c = new GridBagConstraints();
        c.gridx = 6;
        c.gridy = 1;
        c.gridwidth = 1;
        c.weightx = 0.1;
        c.insets = new Insets(2, 2, 2, 2);
        this.mainPanel.add((Component)sortNameButton, c);
        FontAdjust.FontButton sortHandleButton = new FontAdjust.FontButton("Sort handle");
        sortHandleButton.setToolTipText("Sort list by handle name");
        sortHandleButton.setActionCommand("SortHandle");
        sortHandleButton.addActionListener(this);
        c = new GridBagConstraints();
        c.gridx = 7;
        c.gridy = 1;
        c.gridwidth = 1;
        c.weightx = 0.1;
        c.insets = new Insets(2, 2, 2, 2);
        this.mainPanel.add((Component)sortHandleButton, c);
        return this.mainPanel;
    }

    @Override
    public void changeDevicesOrTable(Support.UpdateType type) {
        if (type.equals((Object)Support.UpdateType.StartInit)) {
            return;
        }
        this.devicesComboBox.removeAllItems();
        for (InterfaceThreads.DeviceThread dt : InterfaceThreads.getDevices()) {
            this.devicesComboBox.addItem(new DeviceItem(dt.getDeviceInterface()));
        }
    }

    @Override
    public void select() {
    }

    @Override
    public void deselect() {
        InterfaceThreads.remapper.saveDefault();
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        if (arg0.getActionCommand().equals("Add")) {
            InterfaceThreads.remapper.addDevice(((DeviceItem)this.devicesComboBox.getSelectedItem()).getDevice());
        } else if (arg0.getActionCommand().equals("AddAll")) {
            if (JOptionPane.showConfirmDialog(this.mainPanel, "Confirm", "Add all devices", 0) == 0) {
                int i = 0;
                while (i < this.devicesComboBox.getItemCount()) {
                    InterfaceThreads.remapper.addDevice(this.devicesComboBox.getItemAt(i).getDevice());
                    ++i;
                }
            }
        } else if (arg0.getActionCommand().equals("Remove")) {
            ArrayList<Integer> toRemove = new ArrayList<Integer>();
            int i = this.table.getRowCount() - 1;
            while (i >= 0) {
                if (this.table.isRowSelected(i)) {
                    toRemove.add(i);
                }
                --i;
            }
            if (toRemove.size() <= 1 || JOptionPane.showConfirmDialog(this.mainPanel, "Confirm", "Remove all marked devices", 0) == 0) {
                Iterator iterator = toRemove.iterator();
                while (iterator.hasNext()) {
                    i = (Integer)iterator.next();
                    InterfaceThreads.remapper.removeDevice(i);
                }
            }
        } else if (arg0.getActionCommand().equals("SortName")) {
            InterfaceThreads.remapper.sortName();
        } else if (arg0.getActionCommand().equals("SortHandle")) {
            InterfaceThreads.remapper.sortHandle();
        }
    }

    private class DeviceItem {
        private DeviceInterface di;

        DeviceItem(DeviceInterface di) {
            this.di = di;
        }

        public DeviceInterface getDevice() {
            return this.di;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.di.getHandleName());
            sb.append(": ");
            sb.append(this.di.getDeviceName());
            if (this.di.dt != null && this.di.dt.cPort != null) {
                sb.append(" on ");
                sb.append(this.di.dt.cPort.getDeviceName());
            }
            if (this.di.getSerialNumber() != null && this.di.getSerialNumber().length() > 0) {
                sb.append("  SN: ");
                sb.append(this.di.getSerialNumber());
            }
            return sb.toString();
        }
    }
}

